//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"


//@import "../1FN3_MLFB/Base.misc.js"


/**
 * @category   1FN3 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2022 Plan Software GmbH (http://www.plansoft.de)
 */

var vtTimeStart;
var vtTimeStop;
var vtTime;

function parse_init( strMLFB )
{
    vtTimeStart	= Date.getTime();
    
    var oParsing = {
        strBaseMLFB : '',
        strFullMLFB : '',
        strError    : '',
        strWarning  : '',
        aTokens     : [],
        oFreetext   : {}
    };
    
    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    strMLFB = normalizeMLFB( strMLFB );
    strBaseTypeMLFB = normalizeMLFB( strBaseTypeMLFB );
    
    // MLFB Freitexte
    var nFreetext = find(strMLFB,'{');
    var strFreetext = '';
    if (nFreetext > 0){
        strFreetext = strMLFB.right(strMLFB.length-nFreetext+1);
    }
    oParsing.oFreetext = parseFreetext( strFreetext, true );
    strMLFB = replace(strMLFB,strFreetext,"");
    oParsing.strFullMLFB = strMLFB;
    
    // Kurzangaben aus MLFB 
    var aComponents = tokenize( strMLFB );
    if ( !aComponents.length ){
        oParsing.strError = 'ERRORMSG_MLFB_1FN3___INVALID_MLFB';
        return( oParsing )
    } else if ( aComponents.length > 1 ){
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ( ( aComponents[1] === 'Z' ) || ( aComponents[1] === '-Z' ) ){
            aComponents = removeElementsFromArray( aComponents, 1, 1 );
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;
    
    if ( oParsing.strBaseMLFB.length !== 16 ){
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FN3___PARSE_WRONG_SIZE';
        return( oParsing );
    }
    
    if ( oParsing.strBaseMLFB.indexOf("1FN3") < 0 ){
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FN3___PARSE_WRONG_PRODUCT';
        return( oParsing );
    }
    
    var bCoolingInMLFB = false;
    
    // fix sind MLFB1-8 + 10, 11
    if (strMLFB.charAt(13) == "."){
        var strMLFB_fix = strMLFB.substring( 0, 13 ) + "." + strMLFB.substring( 14 );
    }else{
        var strMLFB_fix = strMLFB;
    }
    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration="1" ;
    
    

    if(strStartConfiguration=="1")
    {
        // entweder unvollständige MLFB, also Defaults setzen oder KEEP-Configuration-Fall, 
        // dann muss die MLFB aber vollständig spezifiziert sein!
        //und eine zur Haupt MLFB unterschiedliche Base Type MLFB übergeben werden.
        //Hier sollen dann möglichst viele Attribute beibehalten werden.
        if(strBaseTypeMLFB != "")
        {
            /* fixe-BaseTypeMLFB für Abgleich mit MLFB
            1FN30501ND000(.)A3
            */
            if (strBaseTypeMLFB.charAt(13) == "."){
                var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring( 0, 13 ) + "." + strBaseTypeMLFB.substring( 14 );
            }else{
                var strBaseTypeMLFB_fix = strBaseTypeMLFB;
            }
        }
        
        // EDIT RepairConfig added
        if(strBaseTypeMLFB_fix==strMLFB_fix && find(strMLFB.left(16), ".") < 0)   // if same motor is selected again
        {
            var bRepairConfig = true;
        }

        // Abgleich BT (BaseTypeMLFB) und MLFB für Keep Configuration
        // -----------------------------------------------------------------------------------------------
        // Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
        // -----------------------------------------------------------------------------------------------
        if( ((strBaseTypeMLFB_fix!=strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") || bRepairConfig)
        {
            // #################################################################################################################
            // KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION
            // #################################################################################################################
            //--------------------------------------------------------------------------------------------------------
            // Base-Type-MLFB aufbereiten
            //--------------------------------------------------------------------------------------------------------
            var aBTComponents = tokenize( strBaseTypeMLFB );
            if ( aBTComponents.length > 1 )
            {
                // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
                // eliminate the resulting invalid short description 'Z'
                if ( ( aBTComponents[1] === 'Z' ) || ( aBTComponents[1] === '-Z' ) ){
                    aBTComponents = removeElementsFromArray( aBTComponents, 1, 1 );
                }
            }
            
            strBaseTypeMLFB = aBTComponents[0];
            
            if ( strBaseTypeMLFB.length === 17 ){
                // eliminate the -Z 
                strBaseTypeMLFB = strBaseTypeMLFB.substring( 0, 16 );
            }
            
            
            // ---------------------------------------------------------------------------------------------------
            // MLFB14 Leistungs- und Signalanschluss
            // ---------------------------------------------------------------------------------------------------
            /*
                { A, B, E, F } 
                check VT_PRIM_SEK_PARTS_MAP_1FN3
            */
            var sMLFB14 = strMLFB.charAt(13);
            var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);
            
            if (sBT_MLFB14 == "."){
                
                if (strBaseTypeMLFB.charAt(8) == "K"){
					var sMLFB14 = "S";
					strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
				}else{
                    // check
                    var bCheck = checkMLFB14_Parser(strBaseTypeMLFB, sMLFB14);
                    if (bCheck){
                        // setzen
                        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                    }else{
                        // Setze Default:
                        if (strBaseTypeMLFB.left(7) == "1FN3050"){
                            sMLFB14 = "F";
                            var bCheck = checkMLFB14_Parser(strBaseTypeMLFB, sMLFB14);
                            if (bCheck){
                                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                            }else{
                                
                                sMLFB14 = getMLFB14_ParserDefault(strBaseTypeMLFB);
                                if (sMLFB14 != "ERROR"){
                                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                                }else{
                                    oParsing.strError = "DICT1_ERR_1FN3___PARSER_SET_MLFB14";
                                }
                            }
                        }else{
                            sMLFB14 = "B";
                            var bCheck = checkMLFB14_Parser(strBaseTypeMLFB, sMLFB14);
                            if (bCheck){
                                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                            }else{
                                
                                sMLFB14 = getMLFB14_ParserDefault(strBaseTypeMLFB);
                                if (sMLFB14 != "ERROR"){
                                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                                }else{
                                    oParsing.strError = "DICT1_ERR_1FN3___PARSER_SET_MLFB14";
                                }
                            }
                        }
                    }
                }
            }
            
            
            // -----------------------------------------------------------------------------------------------
            // Zuweisen der neuen MLFB und KAG-Liste
            strMLFB = strBaseTypeMLFB.substring( 0, 16 ) + strMLFB.substring(16);
            
            oParsing.strBaseMLFB = strBaseTypeMLFB.substring( 0, 16 );
            oParsing.strFullMLFB = strMLFB;
            aComponents[0]=oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
            ECL_SetValue("ECSI_MLFB", strMLFB);
        }
        // #######################################################################################################
        // END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END
        // #######################################################################################################
        else{
            // kein KEEP-Configuration, aber MLFB evtl. nicht vollständig spezifiziert
            if(find(strMLFB.left(16), ".") >= 0){
                //Unvollständige SIZER MLFB
                
                // Prüfen, ob '.' an Stelle 1 bis 13, 15, 16 -->  dann Fehler
                for (var i = 0; i < 13; i++){
                    if (strMLFB.charAt(i) == "."){
                        oParsing.strError = 'ERRORMSG_MLFB_1FN3___INCOMPLETE_MLFB';
                        return( oParsing );
                    }
                }
                if (strMLFB.charAt(14) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1FN3___INCOMPLETE_MLFB';
                    return( oParsing );
                }
                if (strMLFB.charAt(15) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1FN3___INCOMPLETE_MLFB';
                    return( oParsing );
                }
                // Wenn an Stelle 14 ein Wildcard, dann Default setzen
                
                
                
                // ---------------------------------------------------------------------------------------------------
                // MLFB14 Leistungs- und Signalanschluss
                // ---------------------------------------------------------------------------------------------------
                /*
                    { A, B, E, F } 
                    check VT_PRIM_SEK_PARTS_MAP_1FN3
                */
                
                if (strMLFB.charAt(13) == "."){
                    
                    // Setze Default:
                    /*
                    for 1FN3050: F is Default
                    
                    for 1FN3100...1FN3900: B is Default
                    
                    for natural cooled: only 'S'
                    */
                    if (strMLFB.charAt(8) == "K"){
						var sMLFB14 = "S";
						strMLFB = replaceAt(strMLFB, 13, sMLFB14);
					}else{
                        if (strMLFB.left(7) == "1FN3050"){
                            var sMLFB14 = "F";
                            var bCheck = checkMLFB14_Parser(strMLFB, sMLFB14);
                            if (bCheck){
                                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
                            }else{
                                
                                sMLFB14 = getMLFB14_ParserDefault(strMLFB);
                                if (sMLFB14 != "ERROR"){
                                    strMLFB = replaceAt(strMLFB, 13, sMLFB14);
                                }else{
                                    oParsing.strError = "DICT1_ERR_1FN3___PARSER_SET_MLFB14";
                                }
                            }
                        }else{
                            var sMLFB14 = "B";
                            var bCheck = checkMLFB14_Parser(strMLFB, sMLFB14);
                            if (bCheck){
                                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
                            }else{
                                
                                sMLFB14 = getMLFB14_ParserDefault(strMLFB);
                                if (sMLFB14 != "ERROR"){
                                    strMLFB = replaceAt(strMLFB, 13, sMLFB14);
                                }else{
                                    oParsing.strError = "DICT1_ERR_1FN3___PARSER_SET_MLFB14";
                                }
                            }
                        }
                    }
                }
                
                // ---------------------------------------------------------------------------------------------------
                ECL_SetValue("ECSI_MLFB", strMLFB);
            }
            
            // Zuweisen der neuen MLFB und KAG-Liste
            oParsing.strBaseMLFB = strMLFB.substring( 0, 16 );
            aComponents[0]=oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
        }
    // Jetzt sollte immer eine vollständig spezifizierte MLFB zur Verfügung stehen
    }	// der vorherige Abschnitt wurde nur bei IsStartConfiguration == 1 durchlaufen. Passt das ? todo
    
    
    // Ergebnis-Objekt zusammenbauen
    var oResult;
    oResult = parse_1FN3(oParsing.aTokens);
    //oResult = add_help_shortcuts(oResult);
    
    
    if ( oResult ) {
        if ( oResult.oProduct )
            oParsing.oProduct = oResult.oProduct;
        if ( oResult.oParsingData )
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strBaseTypeMLFB = strBaseTypeMLFB;
        oParsing.strError += ( ( oParsing.strError ? ' ' : '' ) + oResult.strError );
        oParsing.strWarning += ( ( oParsing.strWarning ? ' ' : '' ) + oResult.strWarning );
        oParsing.IsStartConfig = strStartConfiguration;
    }
    
    
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: "+vtTime+" sec"+"\n");

    return( oParsing );
}

function parse_1FN3( aTokens ) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /*
    MLFB Struktur
    MLFB.MLFB01 { 1FN3 }
    MLFB.MLFB05 
    MLFB.MLFB06
    MLFB.MLFB07
    MLFB.MLFB08
    MLFB.MLFB09
    MLFB.MLFB10
    MLFB.MLFB11 
    MLFB.MLFB12 
    MLFB.MLFB13 
    MLFB.MLFB14 (.) {A,B,E,F} Leistungs- und Signalanschluss
    MLFB.MLFB15 A
    MLFB.MLFB16 3
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4); // 1FN3
    oResult.oParsingData.MLFB.MLFB05 = strBaseMLFB.charAt( 4 ); 	// 
    oResult.oParsingData.MLFB.MLFB06 = strBaseMLFB.charAt( 5 ); 	// 
    oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt( 6 );	 	// 
    oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt( 7 ); 	// 
    oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt( 8 );	 	// 
    oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt( 9 );	 	// 
    oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt( 10 ); 	// 
    oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt( 11 ); 	// 
    oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt( 12 ); 	// 
    oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt( 13 ); 	// (.) {A,B,E,F,S} Leistungs- und Signalanschluss
    oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt( 14 ); 	// A
    oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt( 15 ); 	// 3
    
    // Rümpfe
    
    // MLFB_01_07_1FN3
    var MLFB_01_07_1FN3 	= strBaseMLFB.substring(0, 7);
    // MLFB_RUMPF_PRI_1FN3
    var MLFB_RUMPF_PRI_1FN3 = strBaseMLFB.substring(0, 9);
        
    oResult.oParsingData.MLFB_01_07_1FN3 = MLFB_01_07_1FN3;
    oResult.oParsingData.MLFB_RUMPF_PRI_1FN3 = MLFB_RUMPF_PRI_1FN3;
    
    ECL_SetValue("MLFB_01_07_1FN3", MLFB_01_07_1FN3);
    ECL_SetValue("MLFB_RUMPF_PRI_1FN3", MLFB_RUMPF_PRI_1FN3);

    
    // Kurzangaben
    if (aTokens.length > 0){
        if (aTokens[0] === strBaseMLFB){
            aTokens = removeElementsFromArray( aTokens, 0, 1 );
        }
        oResult.oParsingData.MLFB.KAG = aTokens;
        
        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }
    
    return oResult;
}


/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens){
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1){
            kagString += ";";
        }
    }
    return kagString;
}



function SetFreetextValue(field, value) {
    
    value = trimleft(value, '*');
    value = trimright(value, '*');
    
    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

/*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
    
}

function isKAGinMLFB(aArray, sKAG)
{
    for(var i=0;i<aArray.length;i++)
    {
        if(aArray[i]==sKAG)
            return true;
    }
    
    return false;	
}

// ###############################################################################################################
// Prüfroutinen für KEEP CONFIGURATION
// ###############################################################################################################

function getMLFB14_ParserDefault(sMLFB)
{
    /*
    mit VT_PRIM_SEK_PARTS_MAP_1FN3
    MLFB_PRI_PART_1FN3	MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
    */
    var sTargetAttribute = "MLFB14_1FN3";
    
    var MLFB_RUMPF_PRI_1FN3 = sMLFB.substring(0, 9);
    var MLFB10_1FN3 = sMLFB.charAt(9);
    var MLFB11_1FN3 = sMLFB.charAt(10);
    
    var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3" + sDB_Suffix;
    // 
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                "MLFB10_1FN3 = '" + MLFB10_1FN3 + "' AND " +
                "MLFB11_1FN3 = '" + MLFB11_1FN3 + "' AND " +
                "HMK_VALUE_VALID_1FN3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        return aResult[0].MLFB14_1FN3;
    }else{
        return "ERROR";
    }
}
// ################################################################################################
function checkMLFB14_Parser(sMLFB, MLFB14_1FN3)
{
    /*
    mit VT_PRIM_SEK_PARTS_MAP_1FN3
    MLFB_PRI_PART_1FN3	MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
    */
    
    var sTargetAttribute = "MLFB14_1FN3";
    
    var MLFB_RUMPF_PRI_1FN3 = sMLFB.substring(0, 9);
    var MLFB10_1FN3 = sMLFB.charAt(9);
    var MLFB11_1FN3 = sMLFB.charAt(10);
    
    var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3" + sDB_Suffix;
    // 
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                "MLFB10_1FN3 = '" + MLFB10_1FN3 + "' AND " +
                "MLFB11_1FN3 = '" + MLFB11_1FN3 + "' AND " +
                "MLFB14_1FN3 = '" + MLFB14_1FN3 + "' AND " +
                "HMK_VALUE_VALID_1FN3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // ---------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################
