//@legacy
//#mode(full-ecma)



//@import "VT_1FS2.js"


/*
Motordaten:
    PMD_ACH516_001_000_1FS2		Achshöhe	MLFB06+07									40

    PMD_AAA259_001_000_1FS2		Motortyp 	MLFB05										Z0002

    HMK_ZENTRIERR_LOCHK_1FS2	Zentrierrand & Lochkreis								Z70_L90

Wellenende:
    HMK_WELLENENDE_1FS2			Wellenende D x Länge									00001	Ø 19 mm x 40 mm
    PMD_AAA506_001_000_1FS2		Wellenende												Z0002	Glatte Welle

Bremse:
    PMD_ABU276_001_000_1FS2		Haltebremse												F
    ==> CB_HALTEBREMSE_1FS2		Abbildung über Checkbox-AttributG
Geber:
    PMD_ABU278_001_000_1FS2		Geber													00022	MLFB14 'M'

Anschlusstechnik:
    PMD_AAA759_001_000_1FS2		Anschlusstechnik										00003	OCC für S210
    HMK_KABELABGANG_1FS2		Kabelabgang												00001	mit offenen Enden
    HMK_KABELLAENGE_1010590		Kabellänge												0,5		0,5m
Schutzart:
    PMD_ABJ176_001_000_1FS2		Schutzart												00046	IP66/67 IP69K (30bar)

*/

function SetMotor_Init(oData)
{
    if (oData && !isEmpty(oData)){
        
        Bestimme_Motordaten(oData);			// 
        
        Bestimme_Wellenende(oData);			// 
        
        Bestimme_Bremse(oData);				// 
        Bestimme_Geber(oData);				// 
        
        Bestimme_Anschlusstechnik(oData);	// 
        
    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("PMD_ACH516_001_000_1FS2","40");		// Achshöhe
        ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FS2","Z0002");		// Motortyp
        
        ExecSetStandardifValueEmpty("HMK_ZENTRIERR_LOCHK_1FS2","Z70_L90");	// Zentrierrand & Lochkreis
        
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FS2","Z0002");		// Wellenende (glatte Welle
        ExecSetStandardifValueEmpty("HMK_WELLENENDE_1FS2","00001");			// Wellenabmaße Ø 19 mm x 40 mm
        
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FS2","00022");		// Geber
        
        ExecSetStandardifValueEmpty("PMD_AAA759_001_000_1FS2","00003");		// Anschlusstechnik
        ExecSetStandardifValueEmpty("HMK_KABELABGANG_1FS2","00001");		// Kabelabgang
        ExecSetStandardifValueEmpty("HMK_KABELLAENGE_1010590", 0.5);		// Kabellänge
        
        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FS2","Z0004");		// Art der Kühlung
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FS2","00046");		// Schutzart IP
    }
}

function SetMotor(strchangedAttribute, oData)
{
}
// #########################################################################################################################
/**
Motordaten:
    PMD_ACH516_001_000_1FS2		Achshöhe	MLFB05+06+07								40

    PMD_AAA259_001_000_1FS2		Motortyp 	MLFB05										Z0002
    HMK_ZENTRIERR_LOCHK_1FS2	Zentrierrand & Lochkreis								ZR30_LK46
*/
// #########################################################################################################################
function Bestimme_Motordaten(oData)
{
    
    var oParsingData = oData.oParsingData;
    
    // -----------------------------------------------------------------------------------------------------------
    // Achshöhe:
    // -----------------------------------------------------------------------------------------------------------
    var MLFB07_1FS2 = oParsingData.MLFB.POS07;
    switch (MLFB07_1FS2){
        case "4":
            var PMD_ACH516_001_000_1FS2 = "40";
        break;
        case "5":
            var PMD_ACH516_001_000_1FS2 = "52"; // laut VT30 = 52 (bzw 48)
        break;
        case "6":
            var PMD_ACH516_001_000_1FS2 = "63";
        break;
        case "8":
            var PMD_ACH516_001_000_1FS2 = "80";
        break;
    }
    ECL_DeactivateAllAttributeValues("PMD_ACH516_001_000_1FS2");
    
    ECL_ActivateValue("PMD_ACH516_001_000_1FS2", PMD_ACH516_001_000_1FS2);
    ECL_SetValue("PMD_ACH516_001_000_1FS2", PMD_ACH516_001_000_1FS2);
    
    // -----------------------------------------------------------------------------------------------------------
    // Motortyp
    // -----------------------------------------------------------------------------------------------------------
    var MLFB05_1FS2 = oParsingData.MLFB.POS05;
    
    if (MLFB05_1FS2 == "2"){
        var PMD_AAA259_001_000_1FS2 = "Z0001";	// Compact
    }else{
        var PMD_AAA259_001_000_1FS2 = "Z0002";	// High Dynamic
    }
    ECL_DeactivateAllAttributeValues("PMD_AAA259_001_000_1FS2");
    
    ECL_ActivateValue("PMD_AAA259_001_000_1FS2", PMD_AAA259_001_000_1FS2);
    ECL_SetValue("PMD_AAA259_001_000_1FS2", PMD_AAA259_001_000_1FS2);
    
    
    
    // -----------------------------------------------------------------------------------------------------------
    // Zentrierrand & Lochkreis		HMK_ZENTRIERR_LOCHK_1FS2		VT_1FS2_M00042
    // -----------------------------------------------------------------------------------------------------------
    
    /* 
    VT_1FS2_M00042
        MLFB_RUMPF_01_10_1FS2	HMK_ZENTRIERR_LOCHK_1FS2	HMK_WELLENENDE_1FS2		HMK_VALUE_VALID_1FS2
    */
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FS2_M00042" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_ZENTRIERR_LOCHK_1FS2": {
            inferenceType: VariantTables.Inference.RestrictAll
            },
            "HMK_WELLENENDE_1FS2": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    ExecSetStandardifValueEmpty("HMK_ZENTRIERR_LOCHK_1FS2", "");
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Wellenende:
    MLFB13
    HMK_WELLENENDE_1FS2			Wellenende D x Länge									00001	Ø 8 mm x 25 mm
    PMD_AAA506_001_000_1FS2		Wellenende												Z0002	Glatte Welle
    
    Wenn Getriebeanbau, nur glatte Welle
*/
// #########################################################################################################################
function Bestimme_Wellenende(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    
    var MLFB13_1FS2 = oMLFB.POS13;
    /*
    MLFB13_1FS2		PMD_AAA506_001_000_1FS2
    0				Z0002					glatte Welle
    1				Z0004					Passfeder
    */
    
    switch(MLFB13_1FS2){
        case "0":
            ECL_ActivateValue("PMD_AAA506_001_000_1FS2", "Z0002");
            ECL_SetValue("PMD_AAA506_001_000_1FS2", "Z0002");
        break;
        case "1":
            ECL_ActivateValue("PMD_AAA506_001_000_1FS2", "Z0004");
            ECL_SetValue("PMD_AAA506_001_000_1FS2", "Z0004");
        break;
    }
    // -----------------------------------------------------------------------------------------------------------
    // Wellenende	HMK_WELLENENDE_1FS2			Wellenende D x Länge
    // -----------------------------------------------------------------------------------------------------------
    // siehe Bestimme_Motordaten()
    
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Bremse:
    PMD_ABU276_001_000_1FS2		Haltebremse		CB_HALTEBREMSE_1FS2					F		MLFB11 = 0 (1=T)
*/
// #########################################################################################################################
function Bestimme_Bremse(oData)
{
    var MLFB11_1FS2 = oData.oParsingData.MLFB.POS11;
    // ################################################################################################################
    // Haltebremse			PMD_ABU276_001_000_1FS2		Übersetzung, keine Einschränkung
    // ################################################################################################################
    /*
    VT_1FS2_M00015
    MLFB_RUMPF_01_10_1FS2	MLFB11_1FS2	HMK_VALUE_VALID_1FS2
    
    // Prüfung im Parser
    */
    
    if (MLFB11_1FS2 == "1"){
        // mit Bremse
        ECL_SelectValue("CB_HALTEBREMSE_1FS2", "T");
    }else{ // ohne Bremse
        ECL_DeselectAttribute("CB_HALTEBREMSE_1FS2");
    }
}
// #########################################################################################################################
/**
    Geber:
    PMD_ABU278_001_000_1FS2		Geber												00022	MLFB14 'M'
*/
// #########################################################################################################################
function Bestimme_Geber(oData)
{
    var MLFB14_1FS2 = oData.oParsingData.MLFB.POS14;
    
    // ################################################################################################################
    // Geber			PMD_ABU278_001_000_1FS2
    // ################################################################################################################
    /*
    Aktuell nur "M" 00022	Encoder AM22DQC: Absolutwertgeber 22 bit + 12 bit Multiturn
    */
    
    if (MLFB14_1FS2 == "M"){
        ECL_SetValue("PMD_ABU278_001_000_1FS2", "00022");
    }else{
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FS2___INVALID_MLFB_ENCODER");
        return;
    }
}
// #########################################################################################################################

// #########################################################################################################################
/**
Anschlusstechnik
    PMD_AAA759_001_000_1FS2		Anschlusstechnik							00003	OCC für S210
    
    HMK_KABELABGANG_1FS2	Kabelabgang			00001	mit offenen Enden und Umrichterdirektanschluss über IX-Stecker
                                                00002	mit M17 / M23 Stecker für erhöhte chemische Beständigkeit
    
    HMK_KABELLAENGE_1010590	Kabellänge
    
    HMK_KABEL_KAG_1FS2	Kabel KAG

    
*/
// #########################################################################################################################
function Bestimme_Anschlusstechnik(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    
    ECL_ActivateValue("PMD_AAA759_001_000_1FS2", "00003");
    ECL_SetValue("PMD_AAA759_001_000_1FS2", "00003");
    
    var aKAG = oMLFB.KAG || [];
    
    var sTargetAttribute = "HMK_KABEL_KAG_1FS2";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, oMLFB.KAG);
    
    if (sKAG != "NON"){ // es muss nach dem Startdurchlauf immer eine KAG geben
        // setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }else{
        // noch keine KAG generiert, Default setzen
        sKAG = "Q0A";
        ECL_SetValue("HMK_KABEL_KAG_1FS2", sKAG);
    }
    
    // Kabelabgang & Kabellänge definieren
    // HMK_KABELABGANG_1FS2	HMK_KABELLAENGE_1010590	HMK_KABEL_KAG_1FS2	HMK_VALUE_VALID_1FS2
    
    var sTable = "VT_1FS2_M00005" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_KABEL_KAG_1FS2 = '" + sKAG + "' AND " +
                "HMK_VALUE_VALID_1FS2 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var HMK_KABELABGANG_1FS2 = aResult[0].HMK_KABELABGANG_1FS2;
        var HMK_KABELLAENGE_1010590 = parseFloat(aResult[0].HMK_KABELLAENGE_1010590);
        
        ECL_SetValue("HMK_KABELABGANG_1FS2", HMK_KABELABGANG_1FS2);
        ECL_SetValue("HMK_KABELLAENGE_1010590", HMK_KABELLAENGE_1010590);
    }else{
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FS2___NO_DB_RESULT_CONNECTION_SYSTEM");
        return;
    }
    
}
// #########################################################################################################################
