//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"


//@import "../1FS2_MLFB/Base.misc.js"

//@import "../1FS2_CONFIG/VT_1FS2.js"


/**
 * @category   1FS2 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init( strMLFB )
{
    vtTimeStart	= Date.getTime();
    
    var oParsing = {
        strBaseMLFB : '',
        strFullMLFB : '',
        strError    : '',
        strWarning  : '',
        aTokens     : [],
        oFreetext   : {}
    };
    
    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    strMLFB = normalizeMLFB( strMLFB );
    strBaseTypeMLFB = normalizeMLFB( strBaseTypeMLFB );
    
    
    var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration="1" ;
    
    //if(strStartConfiguration=="1")
    //{
        //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
        //Hier sollen dann möglichst viele Attribute beibehalten werden.
        //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
        if(strBaseTypeMLFB != "")
        {
            //--------------------------------------------------------------------------------------------------------
            // Base Type  MLFB aufbereiten
            //--------------------------------------------------------------------------------------------------------
            var aBTComponents = tokenize( strBaseTypeMLFB );
            if ( aBTComponents.length > 1 )
            {
                // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
                // eliminate the resulting invalid short description 'Z'
                if ( ( aBTComponents[1] === 'Z' ) || ( aBTComponents[1] === '-Z' ) ){
                    aBTComponents = removeElementsFromArray( aBTComponents, 1, 1 );
                }
            }
            
            strBaseTypeMLFB = aBTComponents[0];
            
            if ( strBaseTypeMLFB.length === 17 ){
                // eliminate the -Z 
                strBaseTypeMLFB = strBaseTypeMLFB.substring( 0, 16 );
            }
            
            var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring( 0, 10 ) + "." + strBaseTypeMLFB.charAt(11) + "." + strBaseTypeMLFB.substring( 13, 16 );
        }
        
        var oResult;
        
        var nFreetext = find(strMLFB,'{');
        var strFreetext = '';
        if (nFreetext > 0){
            strFreetext = strMLFB.right(strMLFB.length-nFreetext+1);
        }
        oParsing.oFreetext = parseFreetext( strFreetext, true );
        strMLFB = replace(strMLFB,strFreetext,"");
        oParsing.strFullMLFB = strMLFB;
        
        var aComponents = tokenize( strMLFB );
        if ( !aComponents.length ){
            oParsing.strError = 'ERRORMSG_MLFB_1FS2___INVALID_MLFB';
            return( oParsing )
        } else if ( aComponents.length > 1 ){
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ( ( aComponents[1] === 'Z' ) || ( aComponents[1] === '-Z' ) ){
                aComponents = removeElementsFromArray( aComponents, 1, 1 );
            }
        }
        oParsing.strBaseMLFB = aComponents[0];
        oParsing.aTokens = aComponents;
        
        //var strMLFB_fix = strMLFB.substring( 0, 10 ); // 
        var strMLFB_fix = strMLFB.substring( 0, 10 ) + "." + strMLFB.charAt(11) + "." + strMLFB.substring( 13, 16 ) ;
        
        // -----------------------------------------------------------------------------------------------
        //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
        // -----------------------------------------------------------------------------------------------
        if( (strBaseTypeMLFB_fix!=strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "")
        {
            // -----------------------------------------------------------------------------------------------
            // Platzhalter aus MLFB in BT übernehmen
            // -----------------------------------------------------------------------------------------------
            /* MLFB-Schema
                MLFB01	1FS2
                MLFB05	Motortyp	{1,2}
                MLFB06	Achshöhe 1	{04,05,06,08}	D-TK nur 04, 05, 06
                MLFB07	Achshöhe 2 
                MLFB08	Baulänge/Drehmoment {5,6}
                MLFB09	A (.) Kühlart {A, (B)} zunächst fix "A"
                MLFB10	Wicklung/Bemessungsdrehzahl {C,F}	todo E ????
                MLFB11	. Bremse (0: ohne, 1: mit)
                MLFB12	7 Schutzart fix
                MLFB13	. Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
                MLFB14	M (.) Geber {(S),M} zunächst fix "M"
                MLFB15	Z Anschlusstechnik	über KAG Q{0,1}{A...Y} Stecker,Kabellänge
                MLFB16	0 (Version) 
            */
            // 11 oder 13 ein Wildcard, dann Wert aus alter MLFB setzen, ggf. Default setzen
            
            // --------------------------------------------------------------------------------------------------------
            // MLFB11 Bremse Default 0 ohne Bremse, 1 mit Bremse
            // --------------------------------------------------------------------------------------------------------
            var sMLFB11 = strMLFB.charAt(10);
            var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);
            
            if (sBT_MLFB11 == "."){	//MLFB11 Bremse Default 0 ohne Bremse, 1 mit Bremse
                
                // Wenn Bremse pflicht, dann setzen, sonst Übernahme aus MLFB		
                var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
                
                if (strwithBrake == "1" || sMLFB11 == "1"){
                    // mit Bremse
                    sMLFB11 = "1";
                }else{ // ohne Bremse
                    sMLFB11 = "0";
                }
                
                if (strBaseTypeMLFB.charAt(10) == "1" && strwithBrake != "1"){	// Fehler, Kontext passt sicht zur MLFB
                    oParsing.strError = 'ERRORMSG_MLFB_1FS2___INVALID_CONTEXT_MLFB10_11';
                    return( oParsing );
                }
                
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, sMLFB11);
            }
            
            // --------------------------------------------------------------------------------
            // MLFB12 Schutzart (fix)
            // --------------------------------------------------------------------------------
            if (strBaseTypeMLFB.charAt(11) == "."){
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "7");
            }
            // --------------------------------------------------------------------------------
            
            // --------------------------------------------------------------------------------------------------------
            // MLFB13 Wellenende, Passfeder
            // --------------------------------------------------------------------------------------------------------
            var sMLFB13 = strMLFB.charAt(12);
            var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);
            
            // Wellenende vorgegeben durch Getriebeanbau???
            var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
            
            if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
            {
                // nur glatte Welle und STD-Wellenabmaße (MLFB13 = 0)
                if (sMLFB13 == "1"){
                    sMLFB13 = "0";
                }
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
            }
            else if (sBT_MLFB13 == "."){	
                
                // Wellenende prüfen: bei "2" nur IP64
                //sMLFB13 = checkMLFB13(strBaseTypeMLFB, sMLFB13);
                
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
            }
            // -----------------------------------------------------------------------------------------------
            
            // --------------------------------------------------------------------------------------------------------
            // MLFB14 Geber {(S),M} zunächst fix "M"
            // --------------------------------------------------------------------------------------------------------
            if (strBaseTypeMLFB.charAt(13) == "."){
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "M");
            }
            // --------------------------------------------------------------------------------------------------------
            
            // --------------------------------------------------------------------------------------------------------
            // MLFB15 Anschlusstechnik (fix "Z")
            // --------------------------------------------------------------------------------------------------------
            if (strBaseTypeMLFB.charAt(14) == "."){
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, "Z");
            }
            // --------------------------------------------------------------------------------------------------------
            
            // --------------------------------------------------------------------------------------------------------
            // MLFB16 Version
            // --------------------------------------------------------------------------------------------------------
            if (strBaseTypeMLFB.charAt(15) == "."){
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, "0");
            }
            
            // --------------------------------------------------------------------------------------------------------
            // Zuweisen der neuen MLFB und KAG-Liste
            strMLFB = strBaseTypeMLFB.substring( 0, 16 ) + strMLFB.substring(16);
            
            oParsing.strBaseMLFB = strBaseTypeMLFB.substring( 0, 16 );
            oParsing.strFullMLFB = strMLFB;
            aComponents[0]=oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
            ECL_SetValue("ECSI_MLFB", strMLFB);
        }
        // -- END EDIT KEEP CONF --
        // Wildcards definieren, wenn kein Keep Configuration
        else{
            if(find(strMLFB.left(16), ".") >= 0){
                //Unvollständige SIZER MLFB
                /* MLFB-Schema
                
                MLFB01	1FS2
                MLFB05	Motortyp	{1,2}
                MLFB06	Achshöhe 1	{04,05,06,08}
                MLFB07	Achshöhe 2 
                MLFB08	Baulänge/Drehmoment {5,6}
                MLFB09	A (.) Kühlart {A, (B)} zunächst fix "A"
                MLFB10	Wicklung/Bemessungsdrehzahl {C,F}	
                MLFB11	. Bremse (0: ohne, 1: mit)
                MLFB12	7 Schutzart fix
                MLFB13	. Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
                MLFB14	M (.) Geber {(S),M} zunächst fix "M"
                MLFB15	Z Anschlusstechnik	über KAG Q{0,1}{A...Y} Stecker,Kabellänge
                MLFB16	0 (Version) 
                */
                // ##########################################################################################
                // Prüfen, ob '.' an Stelle 1 bis 10, dann Fehler
                // ##########################################################################################
                for (var i = 0; i < 10; i++){
                    if (strMLFB.charAt(i) == "."){
                        oParsing.strError = 'ERRORMSG_MLFB_1FS2___INCOMPLETE_MLFB';
                        return( oParsing );
                    }
                }
                
                
                // ##########################################################################################
                // Wenn MLFB11 oder MLFB13 ein Wildcard, dann Default setzen
                // ##########################################################################################
                // --------------------------------------------------------------------------------
                // MLFB11 Haltebremse
                // --------------------------------------------------------------------------------
                var sMLFB11 = "0";
                var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired") || "";
                if (strwithBrake == "1"){
                    // mit Bremse
                    sMLFB11 = "1";
                }
                else{  // ohne Bremse
                    if (strMLFB.charAt(10) == "."){
                        sMLFB11 = "0";
                    }else if (strMLFB.charAt(10) == "1"){
                        oParsing.strError = 'ERRORMSG_MLFB_1FS2___INVALID_CONTEXT_MLFB10_11';
                        return( oParsing );
                    }
                }
                strMLFB = replaceAt(strMLFB, 10, sMLFB11);
                
                if (strBaseTypeMLFB.charAt(10) == "1" && strwithBrake != "1"){	// Fehler, Kontext passt sicht zur MLFB
                    oParsing.strError = 'ERRORMSG_MLFB_1FS2___INVALID_CONTEXT_MLFB10_11';
                    return( oParsing );
                }
                
                // --------------------------------------------------------------------------------
                // MLFB12 Schutzart (fix)
                // --------------------------------------------------------------------------------
                if (strMLFB.charAt(11) == "."){
                    strMLFB = replaceAt(strMLFB, 11, "7");
                }
                // --------------------------------------------------------------------------------
                
                
                // --------------------------------------------------------------------------------
                // MLFB13 Wellengeometrie
                // --------------------------------------------------------------------------------
                if (strMLFB.charAt(12) == "."){	
                    /*
                    0	glatte Welle 	Z0002 		Default		passt auch für Getriebekopplung
                    1	Passfeder		Z0004	
                    */
                    var sMLFB13 = "0";
                    strMLFB = replaceAt(strMLFB, 12, sMLFB13);
                }else{
                    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
                    if(strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
                    { 
                        if (strMLFB.charAt(12) != "0"){
                            oParsing.strError = 'ERRORMSG_MLFB_1FS2___INVALID_CONTEXT_MLFB13';
                            return( oParsing );
                        }
                    }
                }
                // --------------------------------------------------------------------------------------------------------
                
                
                
                // --------------------------------------------------------------------------------------------------------
                // MLFB14 Geber {(S),M} zunächst fix "M"
                // --------------------------------------------------------------------------------------------------------
                if (strMLFB.charAt(13) == "."){
                    strMLFB = replaceAt(strMLFB, 13, "M");
                }
                // --------------------------------------------------------------------------------------------------------
                
                // --------------------------------------------------------------------------------------------------------
                // MLFB15 Anschlusstechnik (fix "Z")
                // --------------------------------------------------------------------------------------------------------
                if (strMLFB.charAt(14) == "."){
                    strMLFB = replaceAt(strMLFB, 14, "Z");
                }
                // --------------------------------------------------------------------------------------------------------
                
                // --------------------------------------------------------------------------------------------------------
                // MLFB16 Version
                // --------------------------------------------------------------------------------------------------------
                if (strMLFB.charAt(15) == "."){
                    strMLFB = replaceAt(strMLFB, 15, "0");
                }
                
                // --------------------------------------------------------------------------------------------------------
                
                ECL_SetValue("ECSI_MLFB", strMLFB);
                
                oParsing.strBaseMLFB = strMLFB.substring( 0, 16 );
                aComponents[0]=oParsing.strBaseMLFB;
                //oParsing.aTokens = aComponents;
            }else{
                
                // MLFB vollständig definiert, aber Kontexte berücksichtigen
                // Bremsenkontext prüfen
                var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
                if (strwithBrake == "1"){
                    // mit Bremse
                    var sMLFB11 = "1";
                    strMLFB = replaceAt(strMLFB, 10, sMLFB11);
                }else{ // ohne Bremse
                    var sMLFB11 = "0";
                    strMLFB = replaceAt(strMLFB, 10, sMLFB11);
                }
                
                ECL_SetValue("ECSI_MLFB", strMLFB);
                
                oParsing.strBaseMLFB = strMLFB.substring( 0, 16 );
                aComponents[0]=oParsing.strBaseMLFB;
                
            }
            
        }
    //}
    // END IS-Start-Configuration
    
    if ( oParsing.strBaseMLFB.length !== 16 ){
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FS2___PARSE_WRONG_SIZE';
        return( oParsing );
    }
    
    if ( oParsing.strBaseMLFB.indexOf("1FS2") < 0 ){
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FS2___PARSE_WRONG_PRODUCT';
        return( oParsing );
    }
    
    var oResult;
    oResult = parse_1FT2(oParsing.aTokens);
    
    if ( oResult ) {
        if ( oResult.oProduct )
            oParsing.oProduct = oResult.oProduct;
        if ( oResult.oParsingData )
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strError += ( ( oParsing.strError ? ' ' : '' ) + oResult.strError );
        oParsing.strWarning += ( ( oParsing.strWarning ? ' ' : '' ) + oResult.strWarning );
    }
    
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: "+vtTime+" sec"+"\n");

    return( oParsing );
}


function parse_1FT2( aTokens ) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /*
    MLFB-Schema
    
        MLFB01	1FS2
        MLFB05	Motortyp	{1,2}
        MLFB06	Achshöhe 1	{04,05,06,08}
        MLFB07	Achshöhe 2 
        MLFB08	Baulänge/Drehmoment {5,6}
        MLFB09	A (.) Kühlart {A, (B)} zunächst fix "A"
        MLFB10	Wicklung/Bemessungsdrehzahl {C,F}	
        MLFB11	. Bremse (0: ohne, 1: mit)
        MLFB12	7 Schutzart fix
        MLFB13	. Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
        MLFB14	M (.) Geber {(S),M} zunächst fix "M"
        MLFB15	Z Anschlusstechnik	über KAG Q{0,1}{A...Y} Stecker,Kabellänge
        MLFB16	0 (Version) 
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.POS01 = strBaseMLFB.substring(0, 4);	// 01 1FS2
    oResult.oParsingData.MLFB.POS05 = strBaseMLFB.charAt( 4 );		// 05 Motortyp {1,2}
    oResult.oParsingData.MLFB.POS06 = strBaseMLFB.charAt( 5 );		// 06 Achshöhe 1 {04,05,06,08}
    oResult.oParsingData.MLFB.POS07 = strBaseMLFB.charAt( 6 );		// 07 Achshöhe 2
    oResult.oParsingData.MLFB.POS08 = strBaseMLFB.charAt( 7 );		// 08 Baulänge/Drehmoment {5,6}
    oResult.oParsingData.MLFB.POS09 = strBaseMLFB.charAt( 8 );		// 09 A (.) Kühlart {A, (B)} zunächst fix "A"
    oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt( 9 );		// 10 Wicklung/Bemessungsdrehzahl {C,F}
    oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt( 10 );		// 11 . Bremse (0: ohne, 1: mit)
    oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt( 11 );		// 12 7 Schutzart fix
    oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt( 12 );		// 13 . Wellenende, Passfeder {0,1}	glatte Welle 0, Passfeder 1
    oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt( 13 ); 	// 14 M (.) Geber {(S),M} zunächst fix "M"
    oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt( 14 ); 	// 15 Z Anschlusstechnik	über KAG Q{0,1}{A...Y} Stecker,Kabellänge
    oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt( 15 ); 	// 16 0 Version
    
    oResult.oParsingData.RUMPF = strBaseMLFB.substring(0, 10); 		// = MLFB_RUMPF_01_10_1FS2
    
    // Prüfen, ob Rumpf-MLFB in DB abgebildet:
    var sTable = "VT_1FS2_M00015" + sDB_Suffix;
    
    var sSQL = "SELECT MLFB_RUMPF_01_10_1FS2 FROM " + sTable + " WHERE "+
                "MLFB_RUMPF_01_10_1FS2 = '"+ oResult.oParsingData.RUMPF + "' AND " +
                "HMK_VALUE_VALID_1FS2 = 'T';";
                
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1)
    {
        oResult.strError = 'ERRORMSG_MLFB_1FS2___PARSE_WRONG_MLFB';
    }
    ECL_SetValue("MLFB_RUMPF_01_10_1FS2", oResult.oParsingData.RUMPF);	// = MLFB_RUMPF_01_10_1FS2
    // ################################################################################################################
    
    // Kurzangaben
    if (aTokens.length > 0){
        if (aTokens[0] === strBaseMLFB){
            aTokens = removeElementsFromArray( aTokens, 0, 1 );
        }
        oResult.oParsingData.MLFB.KAG = aTokens || [];
        
        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }
    
    return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens){
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1){
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {
    
    value = trimleft(value, '*');
    value = trimright(value, '*');
    
    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

/*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
    /*/ O_Y84_1FK2	+ O_Y84_TXT_1FK2
    if (find(oParse.strFullMLFB , 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('O_Y84_TXT_1FK2', oParse.oFreetext['Y84']);
    }*/
}

function isKAGinMLFB(aArray, sKAG)
{
    for(var i=0;i<aArray.length;i++)
    {
        if(aArray[i]==sKAG)
            return true;
    }
    
    return false;	
}
