//@legacy
//#mode(full-ecma)



//@import "VT_1FT2.js"


/*
Checkbox-Attribute setzen und lesen
*/

function getCheckBoxAttributes(strChangedAttribute)
{
    switch (strChangedAttribute){
        case "CB_HALTEBREMSE_1FK2":
            // PMD_ABU276_001_000_1FK2	Haltebremse
            setAttributeFromUICheckbox("PMD_ABU276_001_000_1FK2", "CB_HALTEBREMSE_1FK2", "T", "F");
        break;
        
        case "CB_O_N16_1FK2":
            // O_N16_1FK2	Ausführung für erhöhte chemische Beständigkeit	N16, F
            setAttributeFromUICheckbox("O_N16_1FK2", "CB_O_N16_1FK2", "N16", "F");
        break;
        
        case "CB_O_Q20_1FK2":
            // O_Q20_1FK2	Anschluss zum Druckausgleich	Q20, F
            setAttributeFromUICheckbox("O_Q20_1FK2", "CB_O_Q20_1FK2", "Q20", "F");
        break;
        
        case "CB_O_Q30_1FK2":
            // O_Q30_1FK2   	Eignung für Tieftemperatur bis -30°C	Q30, F
            setAttributeFromUICheckbox("O_Q30_1FK2", "CB_O_Q30_1FK2", "Q30", "F");
        break;

        case "CB_O_Q31_1FK2":
            // O_Q31_1FK2	Q31 Metall-Leistungsschild am Motor		Q31, F
            setAttributeFromUICheckbox("O_Q31_1FK2", "CB_O_Q31_1FK2", "Q31", "F");
        break;
        
        case "CB_O_Q40_1FK2":
            // O_Q40_1FK2   	Kompatibilität Reinraum und Trockenraum	Q40, F
            setAttributeFromUICheckbox("O_Q40_1FK2", "CB_O_Q40_1FK2", "Q40", "F");
        break;
    }
}
function setCheckBoxAttributes()
{
    // PMD_ABU276_001_000_1FK2	Haltebremse
    setProductLogicToUIAttribute("PMD_ABU276_001_000_1FK2", "CB_HALTEBREMSE_1FK2", "T", "F");

    // O_N16_1FK2	Ausführung für erhöhte chemische Beständigkeit	N16, F
    setProductLogicToUIAttribute("O_N16_1FK2", "CB_O_N16_1FK2", "N16", "F");

    // O_Q20_1FK2	Anschluss zum Druckausgleich	Q20, F
    setProductLogicToUIAttribute("O_Q20_1FK2", "CB_O_Q20_1FK2", "Q20", "F");

    // O_Q30_1FK2	Eignung für Tieftemperatur bis -30°C		Q30, F
    setProductLogicToUIAttribute("O_Q30_1FK2", "CB_O_Q30_1FK2", "Q30", "F");

    // O_Q31_1FK2	Q31 Metall-Leistungsschild am Motor		Q31, F
    setProductLogicToUIAttribute("O_Q31_1FK2", "CB_O_Q31_1FK2", "Q31", "F");

    // O_Q40_1FK2	Kompatibilität Reinraum und Trockenraum	Q40, F
    setProductLogicToUIAttribute("O_Q40_1FK2", "CB_O_Q40_1FK2", "Q40", "F");

    if (ECL_GetValue("O_N16_1FK2") == "N16") {
        ECL_DeactivateValue("HMK_FARBAUSFUEHRUNG_1FK2", "K23");
    }

    if (ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2") == "K23") {
        ECL_DisableAttribute("CB_O_N16_1FK2");
    }
}

/**
Funktion zur Übertragung des Logik-Auswahl-Zustandes eines Attributes (eingeschränkt durch Produktlogik) auf ein UI-Checkbox Attribut.

*/
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute)
{
    return setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sOrg_Attribute);
    var bValue_T_valid = false;
    var bValue_F_valid = false;
    
    if (aValidValues.length > 0){
        for (var i=0; i < aValidValues.length; i++){
            if (aValidValues[i] == sVal_True){
                bValue_T_valid = true;
            }
            if (aValidValues[i] == sVal_False){
                bValue_F_valid = true;
            }
        }
        
        if (bValue_T_valid && bValue_F_valid){
            ECL_EnableAttribute(sUI_Attribute);
            var sValue = ECL_GetValue(sOrg_Attribute);
            if (sValue == sVal_True){
                ECL_SelectValue(sUI_Attribute, "T");
            }else{
                ECL_DeselectAttribute(sUI_Attribute);
            }
        }
        else if (bValue_T_valid && !bValue_F_valid){
            ECL_SelectValue(sUI_Attribute, "T");
            ECL_DisableAttribute(sUI_Attribute);
        }
        else if (!bValue_T_valid && bValue_F_valid){
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
        }
    }else{
        ECL_DeselectAttribute(sUI_Attribute);
        ECL_DisableAttribute(sUI_Attribute);
        return 0;
    }
    return 1;
}

/**
Funktion zur Übertragung des Auswahl-Zustandes eines UI-Checkbox-Attributes auf das Original-Attribut.
sOrg_Attribute:	original Produkt-Attrubut, welches durch die Produktlogik gesteuert wird
sUI_Attribute:	UI-Attribut mit Checkbox, auf welches die Logik gespiegelt wird
sValue_True:	Wert 'Ja' des Original-Attributes, wenn er von "T" abweicht		(optional)
sValue_False:	Wert 'Nein' des Original-Attributes, wenn er von "F" abweicht	(optional)
*/
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute)
{
    return setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    if (ECL_ValueSelected(sUI_Attribute, "T")){
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_True)) {
            ECL_SetValue(sOrg_Attribute, sVal_True);
            
        }else{
            
            if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
                ECL_SetValue(sOrg_Attribute, sVal_False);
            }
            
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
            return 0;
        }
    }else{
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
            ECL_SetValue(sOrg_Attribute, sVal_False);
        }else{
            return 0;
        }
    }
    
    return 1;
}
