//@legacy
//#mode(full-ecma)




// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################

// ECSI_CC_AdditionalInertia

// IpProtectionLevelMotor

// SensorModule
/*
String.Empty	No sensor module selected
String			Order number as MLFB without separating "-"
*/

// SensorModuleLocation
/*
0	No sensor module selected
1	Outside the cabinet (SME)
2	Inside the cabinet (SMC)
*/

// ECSI_CC_BrakeID

// OutputShaftLength
/*
Double [mm]		Length of the output shaft in mm
*/

// GearboxOutputShaftType
/*
V	Solid output shaft. Shaft type: V & VG
P	"Solid output shaft in combination with 
    mounting type flange (forward positioned bearing).
    Shaft type: V & VG"
W	"Solid output shaft with two shaft ends.
    Shaft type: VD"
H	"Hollow output shaft.
    Shaft type: H, HF, HS, HX & N"
U	"Mixer hollow output shaft (bearing VLplus).
    Shaft type: HM"
M	"Mixer solid output shaft (bearing VLplus).
    Shaft type: VM"
R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
    Shaft type: VR  "
C	"Cooling tower solid output shaft i2 ≠ l.
    Shaft type: VC"

*/

// GearboxOutputShaftDiameter	Double [mm]	Diameter of the output shaft in mm

// GearboxMountingType
/*
F	Foot-mounted 
B	Foot/flange-mounted
P	Flange-mounted i2=l
Z	Housing flange 
D	Mounted with torque support 
 
*/

// GearboxReinforcedBearing
/*
0	Standard bearing of output shaft
1	Reinforced bearing of output shaft
2	XLPlus
3	VLPlus
*/

// SelectedGearboxAdapterID ????


function determineConsequences(sECSI_MLFB) {
    var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    var strErr = "";

    var aShaftParams = getOutputShaft();
    if (aShaftParams == "ERROR") {
        strErr = "ERR: ShaftParams";
    }

    /*
        [GearboxOutputShaftType, 
         GearboxOutputShaftDiameter,
         OutputShaftLength];
    */

    var oConsequences = {
        AdditionalInertia: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor: getIpProtectionLevelMotor(),
        //	SensorModule				: getSensorModule(),
        BrakeID: getBrakeID(sECSI_MLFB),
        //	GearboxOil					: getGearboxOil(),
        GearboxOutputShaftType: aShaftParams[0],
        GearboxOutputShaftDiameter: aShaftParams[1],
        OutputShaftLength: aShaftParams[2],
        GearboxMountingType: "P",								// Flange-mounted i2=l
        GearboxReinforcedBearing: "0",								// Standard
        //SelectedGearboxAdapterID	: getSelectedGearboxAdapterID(),
        NoCableDQ: getNoCableDQ(),
        Error_Message: strErr
    }

    return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
    var dRet = 0;
    if (operator == 'min')
        dRet = 99999;

    var aOrigins = Object.fromDatabase("1FT2_ADD_DATA", "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' ") || [];

    for (var i = 0; i < aOrigins.length; i++) {
        var resval = determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, aOrigins[i].ORIGIN);
        if (resval != -99999) {
            if ((operator == 'min') && (resval < dRet))
                dRet = resval;
            else if ((operator == 'max') && (resval > dRet))
                dRet = resval;
            else if (operator == 'sum')
                dRet += resval;
        }
    }
    var strRet = '';
    if ((dRet != 0) && (dRet != 99999))
        strRet = '' + dRet;	// als String zurückliefern
    return strRet;
}

function determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, origin) {
    var aResult = Object.fromDatabase("1FT2_ADD_DATA", "select * from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");

    for (var i = 0; i < aResult.length; i++) {
        var mlfbPattern = aResult[i]['PATTERN'];
        var dbKAG = aResult[i]['OPTION'];
        var origin = aResult[i]['ORIGIN'];			// für jeden Origin nur max. einen Wert bestimmen
        var resval = aResult[i]['RES_VALUE'] - 0;	// Wert als Zahl bestimmen

        var matchP = true;
        if (mlfbPattern) {
            if (!EK_regFound(baseMLFB, mlfbPattern))
                matchP = false;
        }
        var matchK = true;
        if (dbKAG) {
            if (find(ka, dbKAG) < 0)
                matchK = false;
        }
        if (matchP && matchK) {
            return resval;
        }
    }
    return -99999;
}

function getAdditionalInertia(sECSI_MLFB) {
    // Keine Trägheitsmomente für Bremse, da dies der SIZER selbst addiert!!!

    var AdditionalInertia = 0;
    return AdditionalInertia;
}

function getIpProtectionLevelMotor() {
    // PMD_ABJ176_001_000_1FK2  	Schutzart
    var IpProtectionLevelMotor = "";
    /*
    Z0011	IP64
    Z0023	IP65
    Z0008	IP67
    */
    var PMD_ABJ176_001_000_1FK2 = ECL_GetValue("PMD_ABJ176_001_000_1FK2");

    switch (PMD_ABJ176_001_000_1FK2) {
        case "Z0011":
            IpProtectionLevelMotor = "64";
            break;
        case "Z0023":
            IpProtectionLevelMotor = "65";
            break;
        case "Z0008":
            IpProtectionLevelMotor = "67";
            break;
    }
    return IpProtectionLevelMotor;
}


//	GearboxOutputShaftType
//	OutputShaftLength
//	GearboxOutputShaftDiameter
function getOutputShaft() {
    /* GearboxOutputShaftType
    V	Solid output shaft. Shaft type: V & VG
-->	P	"Solid output shaft in combination with 
        mounting type flange (forward positioned bearing).
        Shaft type: V & VG"
    */

    var GearboxOutputShaftType = "P";

    /* PMD_AAA506_001_000_1FK2	Wellenende
    Z0002	Glatte Welle
    Z0004	Passfeder
    *00005	Alternative Wellengeometrie mit glatter Welle
    */
    /* HMK_WELLENENDE_1FK2
    00001	Ø 8 mm x 25 mm
    00004	Ø 11 mm x 23 mm
    00002	Ø 14 mm x 30 mm
    00003	Ø 19 mm x 40 mm
    00005	Ø 24 mm x 50 mm
    00006	Ø 32 mm x 58 mm
    00007	Ø 38 mm x 80 mm
    
    
    HMK_WELLE_DXL_GETR_1FK2	Wellenende D x Länge des Getriebes
    
    10_26
    12_24
    14_35
    16_36
    16_48
    20_40
    22_46
    22_56
    25_55
    32_68
    32_88
    40_87
    40_97

    */

    /* HMK_WELLENAUSF_1FK2	Wellenausführung
    STD	Standard
    ALT	Alternative Wellengeometrie
    */


    //UI_WELLENMASZ_1FK7M	Wellenende D x Länge
    var HMK_WELLENENDE_1FK2 = ECL_GetValue("HMK_WELLENENDE_1FK2");
    var HMK_WELLE_DXL_GETR_1FK2 = ECL_GetValue("HMK_WELLE_DXL_GETR_1FK2");

    var sD = HMK_WELLE_DXL_GETR_1FK2.left(2);
    var sL = HMK_WELLE_DXL_GETR_1FK2.right(2);

    if (sL == "24") {
        sL = "24.5";
    }
    /*
    switch(HMK_WELLENENDE_1FK2){
        case "00001":
            sD = "8";
            sL = "25";
        break;
        case "00004":
            sD = "11";
            sL = "23";
        break;
        case "00002":
            sD = "14";
            sL = "30";
        break;
        case "00003":
            sD = "19";
            sL = "40";
        break;
        case "00005":
            sD = "24";
            sL = "50";
        break;
        case "00006":
            sD = "32";
            sL = "58";
        break;
        case "00007":
            sD = "38";
            sL = "80";
        break;
    }*/



    var GearboxOutputShaftDiameter = sD;
    var OutputShaftLength = sL;

    var aConsequences = [GearboxOutputShaftType,
        GearboxOutputShaftDiameter,
        OutputShaftLength];

    return aConsequences;
}



function getBrakeID(sECSI_MLFB) {
    /**
    
    //Bremsen Consequences
    */
    var sBrakeID = "";
    var PMD_ABU276_001_000_1FK2 = ECL_GetValue("PMD_ABU276_001_000_1FK2"); // T, F

    var sTable = "BRAKE_ID";

    if (PMD_ABU276_001_000_1FK2 == "T") {
        var MLFB_RUMPF_01_10_1FK2 = ECL_GetValue("MLFB_RUMPF_01_10_1FK2");
        var MLFB_RUMPF_01_08_1FK2 = MLFB_RUMPF_01_10_1FK2.substring(0, 8);

        var MLFB01_1FG1S = ECL_GetValue("MLFB01_1FK2");
        var MLFB11_1FG1S = ECL_GetValue("MLFB11_1FK2");
        var MLFB15_1FG1S = ECL_GetValue("MLFB15_1FK2");

        var sMLFBpattern = MLFB_RUMPF_01_08_1FK2 + "??" + MLFB11_1FG1S + "???" + MLFB15_1FG1S + "?";

        // SZ_MBC_M_OrderNumber	SZ_MBC_M_ShortOptions	SZ_MBC_BrakeId	SZ_MBC_IsDefaultBrake
        var sSQL = "SELECT SZ_MBC_BrakeId FROM BRAKE_ID WHERE " +
            "SZ_MBC_M_OrderNumber = '" + sMLFBpattern + "';";

        var aResult = Object.fromDatabase("1FT2_ADD_DATA", sSQL);

        if (aResult.length > 0) {
            sBrakeID = aResult[0].SZ_MBC_BRAKEID;
        } else {
            sBrakeID = "ERROR";
        }
    }
    else {
        sBrakeID = "";
    }

    return sBrakeID;
}

//Dependecies for cable	NoCableDQ
function getNoCableDQ() {
    var strAnschlusstechnik = ECL_GetValue("PMD_AAA759_001_000_1FK2");
    if (strAnschlusstechnik == "00003") {
        return "true";
    }
    else if (strAnschlusstechnik == "00004") {
        return "false";
    }
    else {
        return "ERROR";
    }
}