//@legacy
//#mode(full-ecma)



//@import "VT_1FT2.js"


/*
    VT_1FK2_M00259	ZO gueltige Ruempfe-KAGs 
        MLFB_RUMPF_01_10_1FK2	MLFB-Rumpf, 1.-10. Stelle
        O_A11_C42_1FK2			Option Getriebetyp ABC**
        O_R00_R80_1FK2			Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2	Wert gültig

Getriebedaten:
    VT91	feste Zuordnung 
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
    VT95	feste Zuordnung 	
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        HMK_WELLE_DXL_GETR_1FK2		Wellenende /.../Getriebes
        HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand /.../Getriebes
    VT96	Auswahl möglich
        PMD_ABV414_001_000_1FK2		Ausführung /...btriebsseite
        PMD_ACE728_001_000_1FK2		Art der Schmierung
        O_M00_M11_1FK2				Option Getriebe M00-M11
    VT97	feste Zuordnung 
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung i des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl Getriebestufen z des Getriebes
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
    VT_1FK2_M00243
	
        O_Q91_Q93_1FK2	Orientierung des Getriebes
	
Wellenende:
    VT107
        PMD_ACH516_001_000_1FK2		Achshöhe /.../Anmerkung
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
        HMK_WELLENAUSF_1FK2			Wellenausführung
    
    
    HMK_WELLE_DXL_GETR_1FK2			Wellenende D x Länge des Getriebes
    PMD_ABV414_001_000_1FK2			Wellenende des Getriebes

Getriebeoptionen
    PMD_ACE728_001_000_1FK2			Schmierung des Getriebes
    
    
Schutzart:
    VT104
        PMD_ABJ176_001_000_1FK2		Schutzart IP
        HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
    VT105
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
        HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
        PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes


    
*/

function SetGetriebe_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Getriebedaten(oData);		// 

        Bestimme_Schutzart_Getriebe(oData);		// 

    } else {
        // Getriebedaten
        ExecSetStandardifValueEmpty("O_A11_C42_1FK2", "NON");
        ExecSetStandardifValueEmpty("O_R00_R80_1FK2", "NON");
        ExecSetStandardifValueEmpty("O_M00_M11_1FK2", "NON");

        ExecSetStandardifValueEmpty("PMD_ABV410_001_000_1FK2", "NON");
        ExecSetStandardifValueEmpty("PMD_ABV517_001_000_1FK2", "NON");
        ExecSetStandardifValueEmpty("UI_GETRIEBE_TYP_1FK2", "NON");
        ExecSetStandardifValueEmpty("UI_GETRIEBE_SIZE_1FK2", "NON");

        ExecSetStandardifValueEmpty("PMD_ACE728_001_000_1FK2", "00001");
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FK2", "Z0002");

        ExecSetStandardifValueEmpty("PMD_ABV414_001_000_1FK2", "00002");
        ExecSetStandardifValueEmpty("HMK_ZENTR_LOCHK_GETR_1FK2", "60_68");
        ExecSetStandardifValueEmpty("HMK_WELLE_DXL_GETR_1FK2", "10_23");

        ExecSetStandardifValueEmpty("HMK_NENNMOMENT_1FK2", "0_16__3000");
        ExecSetStandardifValueEmpty("UI_VT_DREHMO_STILL_1FK2", "0_16");
        ExecSetStandardifValueEmpty("UI_DREHZAHL_MAX_1FK2", "3000");
        ExecSetStandardifValueEmpty("UI_MOM_GETR_DAUER_1FK2", "5_20");
        ExecSetStandardifValueEmpty("UI_MOM_GETR_KURZ_1FK2", "8_32");
        ExecSetStandardifValueEmpty("HMK_DREHZ_ABTRB_MAX_1FK2", "11");

        ExecSetStandardifValueEmpty("PMD_ABV417_001_000_1FK2", "0");
        ExecSetStandardifValueEmpty("PMD_ABV413_001_000_1FK2", "0");

        ExecSetStandardifValueEmpty("PMD_ABY220_001_000_1FK2", ".");
        ExecSetStandardifValueEmpty("HMK_MIN_SCHUART_GETR_1FK2", "00001");
        ExecSetStandardifValueEmpty("HMK_SCHUART_MOTOR_1FK2", "00001");

        ExecSetStandardifValueEmpty("O_Q91_Q93_1FK2", "-");

    }
}

function SetGetriebe(strchangedAttribute, oData) {
}
// #########################################################################################################################
/**
Getriebedaten:
    Aus Ann und Rnn wird über die VT97 die Getriebebezeichnung PMD_ABV410_001_000_1FK2, die Übersetzung und die Anzahl der Stufen abgeleitet
    
    weitere Daten aus Mnn Wellenende (Passfeder, glatte Welle) und Schmierung (STD oder Lebensmittelqualität)
    
    Getriebe typ und -größe aus VT91 mit Bezeichnung PMD_ABV410_001_000_1FK2
*/
// #########################################################################################################################
function Bestimme_Getriebedaten(oData) {

    var parseObj = oData.oParsingData;

    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");

    // PMD_ABV517_001_000_1FK2	Art des Getriebes ==> NON oder Z0004 Planetengetriebe
    var PMD_ABV517_001_000_1FK2 = "NON";
    if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
        var PMD_ABV517_001_000_1FK2 = "Z0004";
    }
    ECL_DeactivateAllAttributeValues("PMD_ABV517_001_000_1FK2");
    ECL_ActivateValue("PMD_ABV517_001_000_1FK2", PMD_ABV517_001_000_1FK2);
    ECL_SelectValue("PMD_ABV517_001_000_1FK2", PMD_ABV517_001_000_1FK2);

    /*
    VT97
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung i des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl Getriebestufen z des Getriebes
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
    */

    // KAG Ann bestimmen
    var sTargetAttribute = "O_A11_C42_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var O_A11_C42_1FK2 = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];

    if (O_A11_C42_1FK2 != "NON") {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        ECL_ActivateValue(sTargetAttribute, O_A11_C42_1FK2);
        ECL_SetValue(sTargetAttribute, O_A11_C42_1FK2);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SetValue(sTargetAttribute, "NON");
    }

    // KAG Rnn bestimmen
    var sTargetAttribute = "O_R00_R80_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var O_R00_R80_1FK2 = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];

    if (O_R00_R80_1FK2 != "NON") {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        ECL_ActivateValue(sTargetAttribute, O_R00_R80_1FK2);
        ECL_SetValue(sTargetAttribute, O_R00_R80_1FK2);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SetValue(sTargetAttribute, "NON");
    }

    // -----------------------------------------------------------------------------------------------------------
    // Gegen gültige MLFB-Rümpfe abgleichen
    // -----------------------------------------------------------------------------------------------------------
    /*
    VT_1FK2_M00259	ZO gueltige Ruempfe-KAGs 
        MLFB_RUMPF_01_10_1FK2	MLFB-Rumpf, 1.-10. Stelle
        O_A11_C42_1FK2			Option Getriebetyp ABC**
        O_R00_R80_1FK2			Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2	Wert gültig
    */
    var MLFB_RUMPF_01_10_1FK2 = parseObj.RUMPF;

    if (O_A11_C42_1FK2 != "NON" && O_R00_R80_1FK2 != "NON") {

        var sTable = "VT_1FK2_M00259" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB_RUMPF_01_10_1FK2 = '" + MLFB_RUMPF_01_10_1FK2 + "' AND " +
            "O_A11_C42_1FK2 = '" + O_A11_C42_1FK2 + "' AND " +
            "O_R00_R80_1FK2 = '" + O_R00_R80_1FK2 + "' AND " +
            "HMK_VALUE_VALID_1FK2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length < 1) {
            // Fehler, Kombination nicht abgebildet
        }
    }
    // -----------------------------------------------------------------------------------------------------------
    // Getriebebezeichnung, Übersetzung und Anz. Stufen
    // -----------------------------------------------------------------------------------------------------------
    if (O_A11_C42_1FK2 != "NON" && O_R00_R80_1FK2 != "NON") {
        var sTable = "VT_1FK2_M00097" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "O_A11_C42_1FK2 = '" + O_A11_C42_1FK2 + "' AND " +
            "O_R00_R80_1FK2 = '" + O_R00_R80_1FK2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var PMD_ABV410_001_000_1FK2 = aResult[0].PMD_ABV410_001_000_1FK2;	// Bezeichnung des Getriebes
            var PMD_ABV413_001_000_1FK2 = aResult[0].PMD_ABV413_001_000_1FK2;	// Übersetzung i des Getriebes
            var PMD_ABV417_001_000_1FK2 = aResult[0].PMD_ABV417_001_000_1FK2;	// Anzahl Getriebestufen z des Getriebes

            ECL_DeactivateAllAttributeValues("PMD_ABV410_001_000_1FK2");
            ECL_ActivateValue("PMD_ABV410_001_000_1FK2", PMD_ABV410_001_000_1FK2);
            ECL_SetValue("PMD_ABV410_001_000_1FK2", PMD_ABV410_001_000_1FK2);

            ECL_DeactivateAllAttributeValues("PMD_ABV413_001_000_1FK2");
            ECL_ActivateValue("PMD_ABV413_001_000_1FK2", PMD_ABV413_001_000_1FK2);
            ECL_SetValue("PMD_ABV413_001_000_1FK2", PMD_ABV413_001_000_1FK2);

            ECL_DeactivateAllAttributeValues("PMD_ABV417_001_000_1FK2");
            ECL_ActivateValue("PMD_ABV417_001_000_1FK2", PMD_ABV417_001_000_1FK2);
            ECL_SetValue("PMD_ABV417_001_000_1FK2", PMD_ABV417_001_000_1FK2);
        }
    } else {
        // Fehler, wenn mit Geriebe
    }


    // -----------------------------------------------------------------------------------------------------------
    // Getriebetyp und -größe
    // -----------------------------------------------------------------------------------------------------------
    /* VT91
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
    */
    if (PMD_ABV410_001_000_1FK2 != "NON") {
        var sTable = "VT_1FK2_M00091" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ABV410_001_000_1FK2 = '" + PMD_ABV410_001_000_1FK2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var UI_GETRIEBE_TYP_1FK2 = aResult[0].UI_GETRIEBE_TYP_1FK2;	// Getriebetyp
            var UI_GETRIEBE_SIZE_1FK2 = aResult[0].UI_GETRIEBE_SIZE_1FK2;	// Getriebegröße

            ECL_DeactivateAllAttributeValues("UI_GETRIEBE_TYP_1FK2");
            ECL_ActivateValue("UI_GETRIEBE_TYP_1FK2", UI_GETRIEBE_TYP_1FK2);
            ECL_SetValue("UI_GETRIEBE_TYP_1FK2", UI_GETRIEBE_TYP_1FK2);

            ECL_DeactivateAllAttributeValues("UI_GETRIEBE_SIZE_1FK2");
            ECL_ActivateValue("UI_GETRIEBE_SIZE_1FK2", UI_GETRIEBE_SIZE_1FK2);
            ECL_SetValue("UI_GETRIEBE_SIZE_1FK2", UI_GETRIEBE_SIZE_1FK2);
        }
        // HMK_KEY_GEARBOX_1FK2
        var sTable = "VT_1FK2_M00220" + sDB_Suffix;
        /* MLFB_RUMPF_01_10_1FK2	PMD_ABV410_001_000_1FK2	PMD_ABV413_001_000_1FK2	PMD_ABV417_001_000_1FK2	HMK_KEY_GEARBOX_1FK2	HMK_VALUE_VALID_1FK2
        */
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB_RUMPF_01_10_1FK2 = '" + MLFB_RUMPF_01_10_1FK2 + "' AND " +
            "PMD_ABV410_001_000_1FK2 = '" + PMD_ABV410_001_000_1FK2 + "' AND " +
            "PMD_ABV413_001_000_1FK2 = '" + PMD_ABV413_001_000_1FK2 + "' AND " +
            "PMD_ABV417_001_000_1FK2 = '" + PMD_ABV417_001_000_1FK2 + "' AND " +
            "HMK_VALUE_VALID_1FK2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var HMK_KEY_GEARBOX_1FK2 = aResult[0].HMK_KEY_GEARBOX_1FK2;	// Getriebetyp

            ECL_SetValue("HMK_KEY_GEARBOX_1FK2", HMK_KEY_GEARBOX_1FK2);
        }
    } else {
        // Fehler, wenn mit Geriebe
    }

    // -----------------------------------------------------------------------------------------------------------
    // Wellenende und Art der Schmierung
    // -----------------------------------------------------------------------------------------------------------
    /*
    VT96
        PMD_ABV414_001_000_1FK2		Wellenende des Getriebes
        PMD_ACE728_001_000_1FK2		Art der Schmierung
        O_M00_M11_1FK2				Option Getriebe M00-M11
    */
    // Kontext für Schmierung (Standard, FB)
    var ECSI_CX_GearLubricant = ECL_GetValue("ECSI_CX_GearLubricant");

    // KAG Mnn bestimmen
    var sTargetAttribute = "O_M00_M11_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var O_M00_M11_1FK2 = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];

    if (O_M00_M11_1FK2 != "NON") {
        // Prüfen, ob Kontext passt: M00, M01 ==> STD | M10, M11 ==> FB
        if (ECSI_CX_GearLubricant == "FB" && (O_M00_M11_1FK2 == "M00" || O_M00_M11_1FK2 == "M01")) {
            O_M00_M11_1FK2 = replaceAt(O_M00_M11_1FK2, 1, "1");
        } else if (ECSI_CX_GearLubricant !== "FB" && (O_M00_M11_1FK2 == "M10" || O_M00_M11_1FK2 == "M11")) {
            O_M00_M11_1FK2 = replaceAt(O_M00_M11_1FK2, 1, "0");
        }
        ECL_ActivateValue(sTargetAttribute, O_M00_M11_1FK2);
        ECL_SetValue(sTargetAttribute, O_M00_M11_1FK2);
    } else {
        if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
            if (ECSI_CX_GearLubricant == "FB") {
                O_M00_M11_1FK2 = "M10";	// FB kontextabhängig
            } else {
                O_M00_M11_1FK2 = "M00";	// STD kontextabhängig
            }
            ECL_ActivateValue(sTargetAttribute, O_M00_M11_1FK2);
            ECL_SetValue(sTargetAttribute, O_M00_M11_1FK2);
        } else {
            ECL_ActivateValue(sTargetAttribute, "NON");
            ECL_SetValue(sTargetAttribute, "NON");
        }
    }

    if (O_M00_M11_1FK2 != "NON") {
        var sTable = "VT_1FK2_M00096" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "O_M00_M11_1FK2 = '" + O_M00_M11_1FK2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var PMD_ABV414_001_000_1FK2 = aResult[0].PMD_ABV414_001_000_1FK2;	// Wellenende des Getriebes
            var PMD_ACE728_001_000_1FK2 = aResult[0].PMD_ACE728_001_000_1FK2;	// Art der Schmierung

            ECL_ActivateValue("PMD_ABV414_001_000_1FK2", PMD_ABV414_001_000_1FK2);
            ECL_SetValue("PMD_ABV414_001_000_1FK2", PMD_ABV414_001_000_1FK2);

            if (ECSI_CX_GearLubricant) {
                ECL_DeactivateAllAttributeValues("PMD_ACE728_001_000_1FK2");
            }
            ECL_ActivateValue("PMD_ACE728_001_000_1FK2", PMD_ACE728_001_000_1FK2);
            ECL_SetValue("PMD_ACE728_001_000_1FK2", PMD_ACE728_001_000_1FK2);
        }
    } else {
        // Fehler, wenn mit Geriebe
    }


    // -----------------------------------------------------------------------------------------------------------
    // Zentrierrand & Lochkreis	/ Wellenende Abmessungen
    // -----------------------------------------------------------------------------------------------------------
    /*
    VT95	
        PMD_ABV410_001_000_1FK2		Bezeichnung des Getriebes
        HMK_WELLE_DXL_GETR_1FK2		Wellenende D x Länge des Getriebes
        HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand & Lochkreis des Getriebes
    */
    if (PMD_ABV410_001_000_1FK2 != "NON") {
        var sTable = "VT_1FK2_M00095" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ABV410_001_000_1FK2 = '" + PMD_ABV410_001_000_1FK2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var HMK_WELLE_DXL_GETR_1FK2 = aResult[0].HMK_WELLE_DXL_GETR_1FK2;		// Wellenende D x Länge des Getriebes
            var HMK_ZENTR_LOCHK_GETR_1FK2 = aResult[0].HMK_ZENTR_LOCHK_GETR_1FK2;	// Zentrierrand & Lochkreis des Getriebes


            ECL_DeactivateAllAttributeValues("HMK_WELLE_DXL_GETR_1FK2");
            ECL_ActivateValue("HMK_WELLE_DXL_GETR_1FK2", HMK_WELLE_DXL_GETR_1FK2);
            ECL_SetValue("HMK_WELLE_DXL_GETR_1FK2", HMK_WELLE_DXL_GETR_1FK2);

            ECL_DeactivateAllAttributeValues("HMK_ZENTR_LOCHK_GETR_1FK2");
            ECL_ActivateValue("HMK_ZENTR_LOCHK_GETR_1FK2", HMK_ZENTR_LOCHK_GETR_1FK2);
            ECL_SetValue("HMK_ZENTR_LOCHK_GETR_1FK2", HMK_ZENTR_LOCHK_GETR_1FK2);
        }
    } else {
        // Fehler, wenn mit Geriebe
    }

    // -----------------------------------------------------------------------------------------------------------
    // O_Q91_Q93_1FK2	Orientierung des Getriebes
    // -----------------------------------------------------------------------------------------------------------
    // KAG Qnn bestimmen
    // STD, -, Q91, Q92, Q93
    var sTargetAttribute = "O_Q91_Q93_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var O_Q91_Q93_1FK2 = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];

    // todo, wählbar oder Einschränkung aus Kontext?
    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var strBaseTypeMLFB_KAGs = strBaseTypeMLFB.substring(16);

    if (strBaseTypeMLFB !== "" && strBaseTypeMLFB_KAGs.indexOf(O_Q91_Q93_1FK2) > 0) {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
    }
    if (ECL_GetValue("HMK_ANGLED_PLANETARY_GEAR_1FK2") == "YES") {

        if (O_Q91_Q93_1FK2 != "NON") {
            ECL_ActivateValue(sTargetAttribute, O_Q91_Q93_1FK2);
            ECL_SetValue(sTargetAttribute, O_Q91_Q93_1FK2);
        } else {
            ECL_ActivateValue(sTargetAttribute, "STD");
            ECL_SetValue(sTargetAttribute, "STD");
        }
    } else {
        ECL_ActivateValue(sTargetAttribute, "-");
        ECL_SetValue(sTargetAttribute, "-");
    }
}
// #########################################################################################################################

// ################################################################################################################
/* 
    Schutzart:
    VT104		Überstzung PMD in HMK für Schutzart Motor
        PMD_ABJ176_001_000_1FK2		Schutzart IP
        HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
    VT105
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
        HMK_SCHUART_MOTOR_1FK2		Schutzart Motor						entspricht PMD_ABJ176_001_000_1FK2	Schutzart
        PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes

*/
// ################################################################################################################
function Bestimme_Schutzart_Getriebe(oData) {

    var PMD_ABJ176_001_000_1FK2 = ECL_GetValue("PMD_ABJ176_001_000_1FK2");
    var UI_GETRIEBE_TYP_1FK2 = ECL_GetValue("UI_GETRIEBE_TYP_1FK2");

    var sTable = "VT_1FK2_M00104" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ABJ176_001_000_1FK2 = '" + PMD_ABJ176_001_000_1FK2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var HMK_SCHUART_MOTOR_1FK2 = aResult[0].HMK_SCHUART_MOTOR_1FK2;		// Schutzart Motor

        ECL_ActivateValue("HMK_SCHUART_MOTOR_1FK2", HMK_SCHUART_MOTOR_1FK2);
        ECL_SetValue("HMK_SCHUART_MOTOR_1FK2", HMK_SCHUART_MOTOR_1FK2);
    }


    var sTable = "VT_1FK2_M00105" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_SCHUART_MOTOR_1FK2 = '" + HMK_SCHUART_MOTOR_1FK2 + "' AND " +
        "UI_GETRIEBE_TYP_1FK2 = '" + UI_GETRIEBE_TYP_1FK2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var HMK_MIN_SCHUART_GETR_1FK2 = aResult[0].HMK_MIN_SCHUART_GETR_1FK2;	// Mindestschutzart Getriebe
        var PMD_ABY220_001_000_1FK2 = aResult[0].PMD_ABY220_001_000_1FK2;		// Schutzart IP / des Getriebes

        ECL_ActivateValue("HMK_MIN_SCHUART_GETR_1FK2", HMK_MIN_SCHUART_GETR_1FK2);
        ECL_SetValue("HMK_MIN_SCHUART_GETR_1FK2", HMK_MIN_SCHUART_GETR_1FK2);
        ECL_ActivateValue("PMD_ABY220_001_000_1FK2", PMD_ABY220_001_000_1FK2);
        ECL_SetValue("PMD_ABY220_001_000_1FK2", PMD_ABY220_001_000_1FK2);
    }

}

// ################################################################################################################
