//@legacy
//#mode(full-ecma)

//@import "VT_1FT2.js"

/*
Motordaten:
    PMD_ACH516_001_000_1FK2		Achshöhe	MLFB05+06+07								20

    PMD_AAA259_001_000_1FK2		Motortyp 	MLFB05										Z0001

    PMD_AAA136_001_000_1FK2 	Art der Kühlung     MLFB09 A, S    Z0004, Z0003 

    PMD_ACB772_001_000_1FK2		Durchmesser / gemäß IEC 60072-1: Maß N					30
    PMD_ACB789_001_000_1FK2		Lochkreisdurchmesser / gemäß IEC 60072-1: Maß M			46
    HMK_ZENTRIERR_LOCHK_1FK2	Zentrierrand & Lochkreis								ZR30_LK46

Wellenende:
    HMK_WELLENENDE_1FK2			Wellenende D x Länge									00001	Ø 8 mm x 25 mm
    PMD_AAA506_001_000_1FK2		Wellenende												Z0002	Glatte Welle
    HMK_WELLENAUSF_1FK2			Wellenausführung										STD

Bremse, Geber:
    PMD_ABU276_001_000_1FK2		Haltebremse												F

    PMD_ABU278_001_000_1FK2		Geber													00024	MLFB14 'S'

Anschlusstechnik:
    PMD_AAA759_001_000_1FK2		Anschlusstechnik										00003	OCC für S210

Schutzart:
    PMD_ABJ176_001_000_1FK2		Schutzart												Z0011	IP64

*/

function SetMotor_Init(oData) {
  if (oData && !isEmpty(oData)) {
    Bestimme_Motordaten_1FT2(oData); //

    Bestimme_Schutzart_1FT2(oData); //
    // alternatives Wellenende nur bei IP64, daher Auswertung Schutzart vor Wellenende
    Bestimme_Wellenende_1FT2(oData); //

    Bestimme_Bremse_Geber_1FT2(oData); //
    Bestimme_Anschlusstechnik_1FT2(oData); //
  } else {
    // Motordaten
    ExecSetStandardifValueEmpty("PMD_ACH516_001_000_1FK2", "20");
    ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FK2", "Z0001");
    ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FK2", "Z0004");

    ExecSetStandardifValueEmpty("PMD_ACB772_001_000_1FK2", "30");
    ExecSetStandardifValueEmpty("PMD_ACB789_001_000_1FK2", "46");
    ExecSetStandardifValueEmpty("HMK_ZENTRIERR_LOCHK_1FK2", "ZR30_LK46");

    ExecSetStandardifValueEmpty("HMK_WELLENENDE_1FK2", "00001");
    ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FK2", "Z0002");
    ExecSetStandardifValueEmpty("HMK_WELLENAUSF_1FK2", "STD");

    ExecSetStandardifValueEmpty("PMD_ABU276_001_000_1FK2", "F");
    ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FK2", "00024");
    ExecSetStandardifValueEmpty("PMD_AAA759_001_000_1FK2", "00003");

    ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FK2", "Z0011");
  }
}

function SetMotor(strchangedAttribute, oData) { }
// #########################################################################################################################
/**
Motordaten:
    PMD_ACH516_001_000_1FK2		Achshöhe	MLFB05+06+07								20

    PMD_AAA259_001_000_1FK2		Motortyp 	MLFB05										Z0001
    
    PMD_AAA136_001_000_1FK2 	Art der Kühlung     MLFB09 A, S    Z0004, Z0003 

    PMD_ACB772_001_000_1FK2		Durchmesser / gemäß IEC 60072-1: Maß N					30
    PMD_ACB789_001_000_1FK2		Lochkreisdurchmesser / gemäß IEC 60072-1: Maß M			46
    HMK_ZENTRIERR_LOCHK_1FK2	Zentrierrand & Lochkreis								ZR30_LK46
*/
// #########################################################################################################################
function Bestimme_Motordaten_1FT2(oData) {
  var oParsingData = oData.oParsingData;

  // -----------------------------------------------------------------------------------------------------------
  // Achshöhe:
  // -----------------------------------------------------------------------------------------------------------
  // VT83	VT_1FK2_M00083
  //			MLFB05_1FK2	MLFB06_1FK2	MLFB07_1FK2	PMD_ACH516_001_000_1FK2

  simpleInference.restrictAttributes(
    "EXTERNAL_DATA",
    "VT_1FK2_M00083" + sDB_Suffix,
    {
      inferenceType: VariantTables.Inference.RestrictNone,
      operators: {
        PMD_ACH516_001_000_1FK2: {
          inferenceType: VariantTables.Inference.RestrictAll,
        },
      },
    }
  );
  // -----------------------------------------------------------------------------------------------------------
  // Motortyp
  // -----------------------------------------------------------------------------------------------------------
  // PMD_AAA259_001_000_1FK2		Motortyp 	MLFB05										Z0001
  // VT_1FK2_M00006
  //	MLFB05_1FK2	PMD_AAA259_001_000_1FK2	HMK_VALUE_VALID_1FK2

  simpleInference.restrictAttributes(
    "EXTERNAL_DATA",
    "VT_1FK2_M00006" + sDB_Suffix,
    {
      inferenceType: VariantTables.Inference.RestrictNone,
      operators: {
        PMD_AAA259_001_000_1FK2: {
          inferenceType: VariantTables.Inference.RestrictAll,
        },
      },
    }
  );

  // -----------------------------------------------------------------------------------------------------------
  // PMD_AAA136_001_000_1FK2 	Art der Kühlung     MLFB09 A, S    Z0004, Z0003
  // -----------------------------------------------------------------------------------------------------------
  /**
   * VT_1FK2_M00252:
   * MLFB01_1FK2  MLFB09_1FK2 PMD_ACH516_001_000_1FK2 PMD_AAA136_001_000_1FK2
   */
  simpleInference.restrictAttributes(
    "EXTERNAL_DATA",
    "VT_1FK2_M00252" + sDB_Suffix,
    {
      inferenceType: VariantTables.Inference.RestrictNone,
      operators: {
        PMD_AAA136_001_000_1FK2: {
          inferenceType: VariantTables.Inference.RestrictAll,
        },
      },
    }
  );

  // -----------------------------------------------------------------------------------------------------------
  // VT_211 - UI Daten
  // -----------------------------------------------------------------------------------------------------------
  /*
      c.MLFB_RUMPF_01_10_1FK2,
      c.PMD_ACH516_001_000_1FK2,	Achshöhe
      c.PMD_ACB772_001_000_1FK2,	Durchmesser N
      c.PMD_ACB789_001_000_1FK2,	Lochkreisdurchm.../M
      c.PMD_ACF214_001_000_1FK2,	Stillstandsdrehmoment				n.n.
      c.PMD_ABP635_001_000_1FK2,	Drehzahl / maximal zulässig			n.n.
      c.PMD_ABJ544_001_000_1FK2,	Drehmoment / Bemessungswert			n.n.
      c.PMD_AAE020_001_000_1FK2,	Drehzahl / Bemessungswert			n.n.
      c.HMK_NENNMOMENT_1FK2 ,		Bemessungsdrehmoment				n.n.
      c.HMK_UMR_SPANNUNG_1FK2,		Umrichter / Spannungsebene			n.n.
      c.PMD_ABP615_001_000_1FK2		abgegebene mechanische Leistung / Bemessungswert	n.n.
    */
  var sTable = "VT_1FK2_M00211" + sDB_Suffix;

  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    oParsingData.RUMPF +
    "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    //var PMD_ACH516_001_000_1FK2 = aResult[0].PMD_ACH516_001_000_1FK2;
    var PMD_ACB772_001_000_1FK2 = aResult[0].PMD_ACB772_001_000_1FK2;
    var PMD_ACB789_001_000_1FK2 = aResult[0].PMD_ACB789_001_000_1FK2;

    ECL_ActivateValue("PMD_ACB772_001_000_1FK2", PMD_ACB772_001_000_1FK2);
    ECL_SetValue("PMD_ACB772_001_000_1FK2", PMD_ACB772_001_000_1FK2);
    ECL_ActivateValue("PMD_ACB789_001_000_1FK2", PMD_ACB789_001_000_1FK2);
    ECL_SetValue("PMD_ACB789_001_000_1FK2", PMD_ACB789_001_000_1FK2);
  } else {
    oData.strError = "DICT1_ERR_1FT2___PARSER_MOTORDATA";
    return;
  }

  // -----------------------------------------------------------------------------------------------------------
  // Zentrierrand & Lochkreis		VT_1FK2_M00025
  // -----------------------------------------------------------------------------------------------------------
  // PMD_ACB772_001_000_1FK2		Durchmesser / gemäß IEC 60072-1: Maß N					30
  // PMD_ACB789_001_000_1FK2		Lochkreisdurchmesser / gemäß IEC 60072-1: Maß M			46
  /* 
    HMK_ZENTRIERR_LOCHK_1FK2
    
    INFERENCES:
      c.PMD_ACB772_001_000_1FK2,
      c.PMD_ACB789_001_000_1FK2,
      c.HMK_ZENTRIERR_LOCHK_1FK2
    */
  simpleInference.restrictAttributes(
    "EXTERNAL_DATA",
    "VT_1FK2_M00025" + sDB_Suffix,
    {
      inferenceType: VariantTables.Inference.RestrictNone,
      operators: {
        HMK_ZENTRIERR_LOCHK_1FK2: {
          inferenceType: VariantTables.Inference.RestrictAll,
        },
      },
    }
  );

  // -----------------------------------------------------------------------------------------------------------
  // Zentrierrand & Lochkreis des Getriebes		VT_1FK2_M00025 ???							todo
  // -----------------------------------------------------------------------------------------------------------
  // HMK_ZENTR_LOCHK_GETR_1FK2
  /* 
    VT_1FK2_M00095	ZO Getriebe-Wellenende
        PMD_ABV410_001_000_1FK2	Produkttyp-Beze.../Getriebes
        HMK_WELLE_DXL_GETR_1FK2	Wellenende /.../Getriebes
        HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand /.../Getriebes
        HMK_VALUE_VALID_1FK2	Wert gültig
        
    * /
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00025" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_ZENTRIERR_LOCHK_1FK2": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    */
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Wellenende:
    MLFB13
    HMK_WELLENENDE_1FK2			Wellenende D x Länge									00001	Ø 8 mm x 25 mm
    PMD_AAA506_001_000_1FK2		Wellenende												Z0002	Glatte Welle
    HMK_WELLENAUSF_1FK2			Wellenausführung										STD
    
    Wenn Getriebeanbau, nur glatte Welle und STD/ALT
*/
// #########################################################################################################################
function Bestimme_Wellenende_1FT2(oData) {
  var oMLFB = oData.oParsingData.MLFB;

  var MLFB06_1FK2 = oMLFB.POS6;
  var MLFB07_1FK2 = oMLFB.POS7;
  var MLFB13_1FK2 = oMLFB.POS13;
  /*
    MLFB13_1FK2		PMD_AAA506_001_000_1FK2		HMK_WELLENAUSF_1FK2
    0				Z0002						STD
    1				Z0004						STD
    2				Z0002						ALT
    */

  switch (MLFB13_1FK2) {
    case "0":
      ECL_ActivateValue("PMD_AAA506_001_000_1FK2", "Z0002");
      ECL_SetValue("PMD_AAA506_001_000_1FK2", "Z0002");
      var HMK_WELLENAUSF_1FK2 = "STD";
      ECL_ActivateValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      ECL_SetValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      break;
    case "1":
      ECL_ActivateValue("PMD_AAA506_001_000_1FK2", "Z0004");
      ECL_SetValue("PMD_AAA506_001_000_1FK2", "Z0004");
      var HMK_WELLENAUSF_1FK2 = "STD";
      ECL_ActivateValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      ECL_SetValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      break;
    case "2":
      ECL_ActivateValue("PMD_AAA506_001_000_1FK2", "Z0002");
      ECL_SetValue("PMD_AAA506_001_000_1FK2", "Z0002");
      var HMK_WELLENAUSF_1FK2 = "ALT";
      ECL_ActivateValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      ECL_SetValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);
      break;
  }
  // -----------------------------------------------------------------------------------------------------------
  // Wellenende	HMK_WELLENENDE_1FK2			Wellenende D x Länge
  // -----------------------------------------------------------------------------------------------------------
  /*
    VT_1FK2_M00085	Definition Wellenmaße
        MLFB06_1FK2	MLFB07_1FK2	HMK_WELLENAUSF_1FK2	HMK_WELLENENDE_1FK2	PMD_ACB769_001_000_1FK2	PMD_ACB783_001_000_1FK2	HMK_VALUE_VALID_1FK2
    */
  // -----------------------------------------------------------------------------------------------------------
  // PMD_AAA506_001_000_1FK2		Wellenende
  // -----------------------------------------------------------------------------------------------------------
  /*
    VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
        MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    */
  // -----------------------------------------------------------------------------------------------------------
  // HMK_WELLENAUSF_1FK2			Wellenausführung
  // -----------------------------------------------------------------------------------------------------------
  /*
    VT_1FK2_M00085	Definition Wellenmaße
    * VT_1FK2_M00107	ZO AH Getriebe Wellengeometrie		n.n.
    VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
    */

  var sTable = "VT_1FK2_M00085" + sDB_Suffix;

  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    "HMK_WELLENAUSF_1FK2 = '" + HMK_WELLENAUSF_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_WELLENENDE_1FK2 = aResult[0].HMK_WELLENENDE_1FK2;
    var PMD_ACB769_001_000_1FK2 = aResult[0].PMD_ACB769_001_000_1FK2;
    var PMD_ACB783_001_000_1FK2 = aResult[0].PMD_ACB783_001_000_1FK2;

    ECL_ActivateValue("HMK_WELLENENDE_1FK2", HMK_WELLENENDE_1FK2);
    ECL_SetValue("HMK_WELLENENDE_1FK2", HMK_WELLENENDE_1FK2);
    ECL_ActivateValue("PMD_ACB769_001_000_1FK2", PMD_ACB769_001_000_1FK2);
    ECL_SetValue("PMD_ACB769_001_000_1FK2", PMD_ACB769_001_000_1FK2);
    ECL_ActivateValue("PMD_ACB783_001_000_1FK2", PMD_ACB783_001_000_1FK2);
    ECL_SetValue("PMD_ACB783_001_000_1FK2", PMD_ACB783_001_000_1FK2);
  } else {
    oData.strError = "DICT1_ERR_1FT2___PARSER_MOTORDATA";
    return;
  }
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Bremse, Geber:
    PMD_ABU276_001_000_1FK2		Haltebremse												F		MLFB11 = 0 (1=T)

    PMD_ABU278_001_000_1FK2		Geber													00024	MLFB14 'S'
*/
// #########################################################################################################################
function Bestimme_Bremse_Geber_1FT2(oData) {
  // ################################################################################################################
  // Haltebremse			PMD_ABU276_001_000_1FK2		Übersetzung, keine Einschränkung
  // ################################################################################################################
  /*
    MLFB11_1FK2 0,1,2
    PMD_ABU276_001_000_1FK2 F,T
    HMK_HOLDING_BRAKE_1FK2	Haltebremse NO,STANDARD,REINFORC

    RESTRICTIONS: TABLE VT_1FK2_M00247 (
      MLFB11_1FK2
      PMD_ABU276_001_000_1FK2
      HMK_HOLDING_BRAKE_1FK2)
    *
    INFERENCES:
      c.MLFB11_1FK2 ,
      c.PMD_ABU276_001_000_1FK2, 
      HMK_HOLDING_BRAKE_1FK2.

    * /
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00004" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictAll,
    });
    */
  var strWithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
  var MLFB11_1FK2 = oData.oParsingData.MLFB.POS11;

  ECL_DeactivateAllAttributeValues("PMD_ABU276_001_000_1FK2");
  ECL_DeactivateAllAttributeValues("HMK_HOLDING_BRAKE_1FK2");
  if (strWithBrake == "1") {
    var PMD_ABU276_001_000_1FK2 = "T";

    if (MLFB11_1FK2 == "1") {
      // mit Bremse Standard
      var HMK_HOLDING_BRAKE_1FK2 = "STANDARD";
    } else if (MLFB11_1FK2 == "2") {
      // mit Bremse verstärkt
      var HMK_HOLDING_BRAKE_1FK2 = "REINFORC";
    } else {
      // ohne Bremse
      // Fehler
    }
  } else {
    var HMK_HOLDING_BRAKE_1FK2 = "NO";
    var PMD_ABU276_001_000_1FK2 = "F";
  }
  ECL_ActivateValue("PMD_ABU276_001_000_1FK2", PMD_ABU276_001_000_1FK2);
  ECL_SelectValue("PMD_ABU276_001_000_1FK2", PMD_ABU276_001_000_1FK2);

  ECL_ActivateValue("HMK_HOLDING_BRAKE_1FK2", HMK_HOLDING_BRAKE_1FK2);
  ECL_SelectValue("HMK_HOLDING_BRAKE_1FK2", HMK_HOLDING_BRAKE_1FK2);

  // ################################################################################################################
  // Geber			PMD_ABU278_001_000_1FK2
  // ################################################################################################################
  /*
    RESTRICTIONS: TABLE VT_1FK2_M00187 (
          HMK_SYSTEM_TRIG_1FK2 =c.HMK_SYSTEM_TRIG_1FK2,
          HMK_TARGET_TRIGGER_1FK2 =c.HMK_TARGET_TRIGGER_1FK2,
          HMK_KONFIG_TYP_1FK2 =c.HMK_KONFIG_TYP_1FK2,
          MLFB01_1FK2 =c.MLFB01_1FK2 ,
          MLFB14_1FK2 =c.MLFB14_1FK2 ,
          PMD_ABU278_001_000_1FK2 =c.PMD_ABU278_001_000_1FK2 )
        *
    INFERENCES:
          c.HMK_SYSTEM_TRIG_1FK2,
          c.HMK_TARGET_TRIGGER_1FK2,
          c.MLFB01_1FK2 ,
          c.MLFB14_1FK2 ,
          c.PMD_ABU278_001_000_1FK2 ,
          c.HMK_KONFIG_TYP_1FK2
    */
  var sTargetAttribute = "PMD_ABU278_001_000_1FK2";

  var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
  var HMK_KONFIG_TYP_1FK2 = ECL_GetValue("HMK_KONFIG_TYP_1FK2");
  var MLFB14_1FK2 = oData.oParsingData.MLFB.POS14;
  var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");

  var sTable = "VT_1FK2_M00187" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_SYSTEM_TRIG_1FK2 = '1FK2' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = '" +
    HMK_TARGET_TRIGGER_1FK2 +
    "' AND " +
    "MLFB01_1FK2 = '" +
    MLFB01_1FK2 +
    "' AND " +
    "MLFB14_1FK2 = '" +
    MLFB14_1FK2 +
    "' AND " +
    "HMK_KONFIG_TYP_1FK2 = '" +
    HMK_KONFIG_TYP_1FK2 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_ABU278_001_000_1FK2 = aResult[0].PMD_ABU278_001_000_1FK2;

    ECL_ActivateValue("PMD_ABU278_001_000_1FK2", PMD_ABU278_001_000_1FK2);
    ECL_SetValue("PMD_ABU278_001_000_1FK2", PMD_ABU278_001_000_1FK2);
  } else {
    oData.strError = "DICT1_ERR_1FT2___PARSER_MOTORDATA";
    return;
  }
}
function checkBremse_1FT2(oData, sTargetAttribute, sKAG) {
  //
  return 1;
}
function checkGeber_1FT2(oData, sTargetAttribute, sKAG) {
  //	bereits im Parser erfolgt
  return 1;
}
// #########################################################################################################################

// #########################################################################################################################
/**
Anschlusstechnik
    PMD_AAA759_001_000_1FK2		Anschlusstechnik							A			00003	OCC für S210
*/
// #########################################################################################################################
function Bestimme_Anschlusstechnik_1FT2(oData) {
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB15_1FK2 = oMLFB.POS15;

  if (MLFB15_1FK2 == "A") {
    var PMD_AAA759_001_000_1FK2 = "00003";
  } else {
    // B
    var PMD_AAA759_001_000_1FK2 = "00004";
  }

  ECL_ActivateValue("PMD_AAA759_001_000_1FK2", PMD_AAA759_001_000_1FK2);
  ECL_SetValue("PMD_AAA759_001_000_1FK2", PMD_AAA759_001_000_1FK2);
}
// #########################################################################################################################

// ################################################################################################################
/* 
    Schutzart:
    PMD_ABJ176_001_000_1FK2		Schutzart												Z0011	IP64
    
    alternatives Wellenende nur bei IP64, daher Auswertung Schutzart vor Wellenende
*/
// ################################################################################################################
function Bestimme_Schutzart_1FT2(oData) {
  var oMLFB = oData.oParsingData.MLFB;
  var MLFB12_1FK2 = oMLFB.POS12;

  var PMD_ABJ176_001_000_1FK2 = "Z0011";

  switch (MLFB12_1FK2) {
    case "0":
      PMD_ABJ176_001_000_1FK2 = "Z0011";
      break;
    case "1":
      PMD_ABJ176_001_000_1FK2 = "Z0023"; // bei Adapteranbeu und DriveTrain nicht bei AH30 und AH40 (abgefangen in Parser)
      break;
    case "2":
      PMD_ABJ176_001_000_1FK2 = "Z0008"; // bei Adapteranbeu und DriveTrain nicht bei AH30 und AH40 (abgefangen in Parser) only 1FT2
      break;
  }

  ECL_ActivateValue("PMD_ABJ176_001_000_1FK2", PMD_ABJ176_001_000_1FK2);
  ECL_SetValue("PMD_ABJ176_001_000_1FK2", PMD_ABJ176_001_000_1FK2);
}

// ################################################################################################################
