//@legacy
//#mode(full-ecma)



//@import "VT_1FT2.js"


/*
O_X01_X08_1FK2		Farbe
O_N16_1FK2			Ausführung für erhöhte chemische Beständigkeit
O_Q20_1FK2			Anschluss zum Druckausgleich

O_Q30_1FK2	Eignung für Tieftemperatur bis -30°C

O_Q31_1FK2			Metall-Leistungsschild am Motor

O_Q40_1FK2	Kompatibilität Reinraum und Trockenraum

O_Y84_1FK2	+ O_Y84_TXT_1FK2		Kundenangabe auf dem Leistungsschild
*/

function SetOptionen_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_N16_1FT2(oData); 			    // O_N16_1FK2	Ausführung für erhöhte chemische Beständigkeit

        Bestimme_Farbausfuehrung_1FT2(oData); 	// HMK_FARBAUSFUEHRUNG_1FK2	Ausführung
        Bestimme_Farbe_1FT2(oData); 			    // O_X01_X08_1FK2	Farbe

        Bestimme_Q30_1FT2(oData);			    // O_Q30_1FK2	Eignung für Tieftemperatur bis -30°C
        Bestimme_Q31_1FT2(oData);		    	// O_Q31_1FK2	Metall-Leistungsschild am Motor
        Bestimme_Q40_1FT2(oData);		    	// O_Q40_1FK2	Kompatibilität Reinraum und Trockenraum

        Bestimme_Y84_1FT2(oData);		    	// O_Y84_1FK2	Kundenangabe auf dem Leistungsschild

        Bestimme_Q20_1FT2(oData); 		    	// O_Q20_1FK2	Anschluss zum Druckausgleich

    } else {

        ExecSetStandardifValueEmpty("HMK_FARBAUSFUEHRUNG_1FK2", "00001");
        ExecSetStandardifValueEmpty("O_X01_X08_1FK2", "STD");
        ExecSetStandardifValueEmpty("O_N16_1FK2", "F");
        ExecSetStandardifValueEmpty("O_Q20_1FK2", "F");
        ExecSetStandardifValueEmpty("O_Q30_1FK2", "F");
        ExecSetStandardifValueEmpty("O_Q31_1FK2", "F");
        ExecSetStandardifValueEmpty("O_Q40_1FK2", "F");

        ExecSetStandardifValueEmpty("O_Y84_1FK2", "F");
        ECL_SetValue("O_Y84_TXT_1FK2", "");

    }
}

function SetOptionen(strchangedAttribute, oData) {
}

/**
    O_X01_X08_1FK2	Farbe

    STD	X01	X02	X03	X04	X05	X06	X08
    
    VT142 nur generelle Abhängigkeit der Optionen zu 1FT2/1FK2
    
    VT135 N16 Abhängigkeit

*/
function Bestimme_Farbausfuehrung_1FT2(oData) {
    // Ausführung aus KAG bestimmen, sonst 00001
    var sTargetAttribute = "HMK_FARBAUSFUEHRUNG_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "K23";
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        bCheck = checkK23_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "00001");
        ECL_SetValue(sTargetAttribute, "00001");
    }
}
function checkK23_1FT2(oData, sTargetAttribute, sKAG) {
    /**
    VT_1FK2_M00189
        MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
    VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
        PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    VT_1FK2_M00205	Restrict Options
        O_N16_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    */
    // VT_1FK2_M00189
    //   MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
    //  PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var PMD_AAA136_001_000_1FK2 = ECL_GetValue("PMD_AAA136_001_000_1FK2");

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FK2_M00205	Restrict Options
    //    O_N16_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");

    var sTable = "VT_1FK2_M00205" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }

    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

function Bestimme_Farbe_1FT2(oData) {
    // Farbe aus KAG bestimmen, sonst STD
    var sTargetAttribute = "O_X01_X08_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, oData.oParsingData.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];

    if (sKAG != "NON") {
        bCheck = checkFarbe_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SetValue(sTargetAttribute, "STD");
    }
}
function checkFarbe_1FT2(oData, sTargetAttribute, sKAG) {
    /*
    VT_1FK2_M00189
        MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
    VT_1FK2_M00249	Optionen_2 1FK21FT2
        MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
    */
    // VT_1FK2_M00189
    //   MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");
    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FK2_M00249	Optionen_2 1FK21FT2
    //  MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;

    var sTable = "VT_1FK2_M00249" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}


/**
    O_N16_1FK2	Ausführung für erhöhte chemische Beständigkeit
    
*/
function Bestimme_N16_1FT2(oData) {
    // O_N16_1FK2
    // KAG: N16, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_N16_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N16";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkN16_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkN16_1FT2(oData, sTargetAttribute, sKAG) {
    /* NEU: keine Einschänkung mehr!
    VT_1FK2_M00135	N16---Color 		<=== N16 gewinnt vor Farbe!
        O_N16_1FK2	O_X01_X08_1FK2	HMK_VALUE_VALID_1FK2
    ==> nur bei STD N16 erlaubt
    * /
    VT_1FK2_M00156
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
    VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
            PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2

    var aKAG = oData.oParsingData.MLFB.KAG || [];
    
    if (find(aKAG, "X0") > -1){
        return 0;
    }*/
    //--------------------------------------------------------------------------------------------------------------
    /*
        ersetzt durch VT_1FK2_M00156
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
    */
    var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2");
    var aKAG = oData.oParsingData.MLFB.KAG;
    if (find(aKAG, "Q31") > -1) {
        var O_Q31_1FK2 = "Q31";
    } else {
        var O_Q31_1FK2 = "F";
    }

    if (find(aKAG, "Q20") > -1) {
        var O_Q20_1FK2 = "Q20";
    } else {
        var O_Q20_1FK2 = "F";
    }

    var sTable = "VT_1FK2_M00156" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
        "O_Q20_1FK2 = '" + O_Q20_1FK2 + "' AND " +
        "O_Q31_1FK2 = '" + O_Q31_1FK2 + "' AND " +	// Q31 nicht unbeding nötig. Nur in Richtung Achshöhe relevant. Nicht erlaubt für AH 20
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAA136_001_000_1FK2 = ECL_GetValue("PMD_AAA136_001_000_1FK2");
    var O_Q31_1FK2 = ECL_GetValue("O_Q31_1FK2");
    //var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");  // N16 gewinnt vor Farbausführung!

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "' AND " +
        "O_Q31_1FK2 = '" + O_Q31_1FK2 + "' AND " +
        //"HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +						
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// O_Q20_1FK2	Anschluss zum Druckausgleich
// ################################################################################################################
function Bestimme_Q20_1FT2(oData) {
    // O_Q20_1FK2
    // KAG: Q20, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Q20_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q20";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkQ20_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }

}
function checkQ20_1FT2(oData, sTargetAttribute, sKAG) {
    /* VT_1FK2_M00156
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        VT_200 ZO Q20
            MLFB10_1FK2	O_Q20_1FK2	HMK_VALUE_VALID_1FK2
    */
    var MLFB10_1FK2 = oData.oParsingData.MLFB.POS10;
    var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2");
    var O_Q31_1FK2 = ECL_GetValue("O_Q31_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");

    var sTable = "VT_1FK2_M00156" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
        "O_Q31_1FK2 = '" + O_Q31_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // ----------------------------------------------------------
    var sTable = "VT_1FK2_M00200" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB10_1FK2 = '" + MLFB10_1FK2 + "' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // ----------------------------------------------------------
    return 1;
}
// ################################################################################################################

// O_Q30_1FK2	Eignung für Tieftemperatur bis -30°C
function Bestimme_Q30_1FT2(oData) {
    // O_Q30_1FK2
    // KAG: Q30, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Q30_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q30";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkQ30_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkQ30_1FT2(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
        VT_1FK2_M00248	Dep MLFB12 -- Q30
            MLFB12_1FK2     O_Q30_1FK2
        VT_1FK2_M00249	Optionen_2 1FK21FT2
            MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
    */
    //--------------------------------------------------------------------------------------------------------------
    var MLFB12_1FK2 = oData.oParsingData.MLFB.POS12;

    var sTable = "VT_1FK2_M00248" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB12_1FK2 = '" + MLFB12_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");

    var O_X01_X08_1FK2 = ECL_GetValue("O_X01_X08_1FK2");

    var sTable = "VT_1FK2_M00249" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        "O_X01_X08_1FK2 = '" + O_X01_X08_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// O_Q31_1FK2	Metall-Leistungsschild am Motor
function Bestimme_Q31_1FT2(oData) {
    // O_Q31_1FK2
    // KAG: Q31, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Q31_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q31";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkQ31_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkQ31_1FT2(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
        VT_1FK2_M00156
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        VT_1FK2_M00189
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
            PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    */
    var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");
    var O_Q20_1FK2 = ECL_GetValue("O_Q20_1FK2");

    var sTable = "VT_1FK2_M00156" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +						// N16 nicht unbeding nötig. Nur in Richtung Achshöhe relevant. Nicht erlaubt für AH 20
        "O_Q20_1FK2 = '" + O_Q20_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FK2_M00189
    //   MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");
    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
    //  PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var PMD_AAA136_001_000_1FK2 = ECL_GetValue("PMD_AAA136_001_000_1FK2");

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// O_Q40_1FK2
function Bestimme_Q40_1FT2(oData) {
    // O_Q40_1FK2
    // KAG: Q40, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Q40_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q40";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkQ40_1FT2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkQ40_1FT2(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
        VT_1FK2_M00249	Optionen_2 1FK21FT2
            MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
        VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
            PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2

    */
    //--------------------------------------------------------------------------------------------------------------
    var MLFB01_1FK2 = oData.oParsingData.MLFB.POS1;
    var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");
    var O_Q30_1FK2 = ECL_GetValue("O_Q30_1FK2");
    var O_X01_X08_1FK2 = ECL_GetValue("O_X01_X08_1FK2");

    var sTable = "VT_1FK2_M00249" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
        "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
        "O_Q30_1FK2 = '" + O_Q30_1FK2 + "' AND " +
        "O_X01_X08_1FK2 = '" + O_X01_X08_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAA136_001_000_1FK2 = ECL_GetValue("PMD_AAA136_001_000_1FK2");
    var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");
    var O_Q31_1FK2 = ECL_GetValue("O_Q31_1FK2");
    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "' AND " +
        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
        "O_Q31_1FK2 = '" + O_Q31_1FK2 + "' AND " +
        "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_Y84(oData)
// ################################################################################################################
function Bestimme_Y84_1FT2(oData) {
    // O_Y84_1FK2
    // KAG: Y84, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Y84_1FK2";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, immer erlaubt, also setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");

        ECL_ResetAttribute("O_Y84_TXT_1FK2");
    }
}
