//@legacy
//#mode(full-ecma)


//@import "../1FT2_MLFB/Base.misc.js"

//@import "VT_1FT2.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
  var strError = "";
  var sMLFB = ECL_GetValue("ECSI_MLFB");
  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
  // var sMLFB1_4 = sMLFB.left(4);
  // var MLFB01_1FK2 = sMLFB.left(4);

  var MLFB_RUMPF_01_10_1FK2 = ECL_GetValue("MLFB_RUMPF_01_10_1FK2");

  var HMK_KONFIG_TYP_1FK2 = ECL_GetValue("HMK_KONFIG_TYP_1FK2");
  var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");
  var HMK_ANGLED_PLANETARY_GEAR_1FK2 = ECL_GetValue("HMK_ANGLED_PLANETARY_GEAR_1FK2");
  var HMK_SYSTEM_TRIG_1FK2 = ECL_GetValue("HMK_SYSTEM_TRIG_1FK2");
  //var sGetriebeTyp =  ECL_GetValue("sGetriebeTyp");

  var MLFB01_1FK2 = ECL_GetValue("MLFB01_1FK2");
  var MLFB05_1FK2 = ECL_GetValue("MLFB05_1FK2");
  var MLFB06_1FK2 = ECL_GetValue("MLFB06_1FK2");
  var MLFB07_1FK2 = ECL_GetValue("MLFB07_1FK2");
  var MLFB10_1FK2 = ECL_GetValue("MLFB10_1FK2");
  var MLFB11_1FK2 = ECL_GetValue("MLFB11_1FK2");
  var MLFB12_1FK2 = ECL_GetValue("MLFB12_1FK2");
  var MLFB13_1FK2 = ECL_GetValue("MLFB13_1FK2");
  var MLFB14_1FK2 = ECL_GetValue("MLFB14_1FK2");
  var MLFB15_1FK2 = ECL_GetValue("MLFB15_1FK2");
  var MLFB16_1FK2 = ECL_GetValue("MLFB16_1FK2");

  var bMitGetriebe = false;
  if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
    bMitGetriebe = true;
  }
  var bWinkelgetriebe = false;
  if (HMK_ANGLED_PLANETARY_GEAR_1FK2 == "YES") {
    bWinkelgetriebe = true;
  }

  var ECSI_CX_GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling"));
  var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));

  var bGearboxCoupling = false;
  var bIsDriveTrain = false;

  if (ECSI_CX_GearboxMotorCoupling == 1) {
    bGearboxCoupling = true;
  }

  if (ECSI_CX_IsDriveTrain == 1) {
    bIsDriveTrain = true;
  }

  var PMD_AAA136_001_000_1FK2 = ECL_GetValue("PMD_AAA136_001_000_1FK2");

  // ################################################################################################################
  // HMK_ZENTRIERR_LOCHK_1FK2		Zentrierrand & Lochkreis
  // ################################################################################################################
  /*
    PMD_ACB772_001_000_1FK2		Durchmesser / gemäß IEC 60072-1: Maß N
    PMD_ACB789_001_000_1FK2		Lochkreisdurchmesser / gemäß IEC 60072-1: Maß M
    
    im PARSER definiert (Achshöhe 1:1 Beziehung)
    
    VTs:
        VT_1FK2_M00025	Zentrierrand und Lochkeis
    * /
    
    // ################################################################################################################
    // VT_025 - Zentrierrand + Lochkr			
    // ################################################################################################################
    /*
    RESTRICTIONS: TABLE VT_1FK2_M00025 (
      PMD_ACB772_001_000_1FK2 =c.PMD_ACB772_001_000_1FK2 ,		<-- Bestimmung über VT86
      PMD_ACB789_001_000_1FK2 =c.PMD_ACB789_001_000_1FK2 ,		<-- Bestimmung über VT86
      HMK_ZENTRIERR_LOCHK_1FK2 =c.HMK_ZENTRIERR_LOCHK_1FK2 ,
      HMK_VALUE_VALID_1FK2 =c.HMK_VALUE_VALID_1FK2 )
    *
    INFERENCES:
      c.PMD_ACB772_001_000_1FK2,
      c.PMD_ACB789_001_000_1FK2,
      c.HMK_ZENTRIERR_LOCHK_1FK2
    * /
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00025" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "HMK_ZENTRIERR_LOCHK_1FK2": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    // ################################################################################################################
    
    
    // ################################################################################################################
    // HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand & Lochkreis des Getriebes												<==== GETRIEBEMOTOR
    // ################################################################################################################
    /*
        VT_1FK2_M00095	ZO Getriebe-Wellenende
            PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
            HMK_WELLE_DXL_GETR_1FK2		Wellenende /.../Getriebes
            HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand /.../Getriebes
            HMK_VALUE_VALID_1FK2		Wert gültig
    feste Zuordnung mit Getriebe (1:1), Vorgabe durch SIZER
    */
  // ################################################################################################################

  // ################################################################################################################
  // PMD_AAA506_001_000_1FK2		Wellenende			MLFB13_1FK2
  // ################################################################################################################
  // PMD_ABV414_001_000_1FK2		Wellenende des Getriebes															<==== GETRIEBEMOTOR
  // ################################################################################################################
  /* PMD_ABV414_001_000_1FK2		Wellenende des Getriebes
        VT_1FK2_M00096	ZO KAG M00-M11
            PMD_ABV414_001_000_1FK2		Ausführung /...btriebsseite
            PMD_ACE728_001_000_1FK2		Art der Schmierung
            O_M00_M11_1FK2				Option Getriebe M00-M11
            HMK_VALUE_VALID_1FK2		Wert gültig
    
    
    /*
    VT_1FK2_M00085	Definition Wellenmaße
        MLFB06_1FK2	MLFB07_1FK2	HMK_WELLENAUSF_1FK2	HMK_WELLENENDE_1FK2	PMD_ACB769_001_000_1FK2	PMD_ACB783_001_000_1FK2	HMK_VALUE_VALID_1FK2
    */
  // -----------------------------------------------------------------------------------------------------------
  // PMD_AAA506_001_000_1FK2		Wellenende
  // -----------------------------------------------------------------------------------------------------------
  /*
    VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
        MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    */
  // -----------------------------------------------------------------------------------------------------------
  // HMK_WELLENAUSF_1FK2			Wellenausführung
  // -----------------------------------------------------------------------------------------------------------
  /*
    VT_1FK2_M00085	Definition Wellenmaße
    VT_1FK2_M00107	ZO AH Getriebe Wellengeometrie
        PMD_ACH516_001_000_1FK2	UI_GETRIEBE_SIZE_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    
    VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
        MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    
    
    MLFB13_1FK2 VTs:
        VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
        VT_1FK2_M00140	Rumpf <> Geber

    */

  ECL_ActivateAllAttributeValues("PMD_AAA506_001_000_1FK2");
  ECL_ActivateAllAttributeValues("HMK_WELLENAUSF_1FK2");
  ECL_ActivateAllAttributeValues("MLFB13_1FK2");

  if (bGearboxCoupling || bIsDriveTrain) {
    // nur glatte Welle
    ECL_DeactivateValue("MLFB13_1FK2", "1"); // Passfeder nicht erlaubt
    ECL_DeactivateValue("PMD_AAA506_001_000_1FK2", "Z0004"); // Passfeder nicht erlaubt

    // nur IP64
    //PMD_ABJ176_001_000_1FK2		Schutzart		MLFB12_1FK2
    // nur Z0011, MLFB12 nur "0"
    // Steuerung bei Schutzart

    var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2");
    // bei AH 30 und 40 keine alternative Wellengeometrie
    if (PMD_ACH516_001_000_1FK2 == "20" || PMD_ACH516_001_000_1FK2 == "30" || MLFB07_1FK2 == "3" || MLFB07_1FK2 == "4") {
      ECL_DeactivateValue("HMK_WELLENAUSF_1FK2", "ALT");
      ECL_DeactivateValue("MLFB13_1FK2", "2");
    }
  } else if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
    ECL_DeactivateValue("MLFB13_1FK2", "1"); // Passfeder nicht erlaubt
    ECL_DeactivateValue("PMD_AAA506_001_000_1FK2", "Z0004"); // Passfeder nicht erlaubt
  } else {
    ECL_ActivateValue("MLFB13_1FK2", "1"); // Passfeder erlaubt
    ECL_ActivateValue("PMD_AAA506_001_000_1FK2", "Z0004"); // Passfeder erlaubt
  }

  var sTable = "VT_1FK2_M00138" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAA506_001_000_1FK2";
  var sWhere = "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    "MLFB12_1FK2 = '" + MLFB12_1FK2 + "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_WELLENENDE_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // HMK_WELLENENDE_1FK2		Wellenende D x Länge
  // ################################################################################################################
  /*
    VT_1FK2_M00085	Definition Wellenmaße
    VT_1FK2_M00186	Restrict Geber Wellenende Ausf
    */

  // ################################################################################################################

  // ################################################################################################################
  // HMK_WELLENAUSF_1FK2		Alternative Wellengeometrie			MLFB13_1FK2
  // ################################################################################################################
  /*
    abhängig von Schutzart IP und Wellenende (PMD_AAA506_001_000_1FK2) 
    HMK_WELLENAUSF_1FK2 einschränken
    
    VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
        MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    
    */
  var PMD_AAA506_001_000_1FK2 = ECL_GetValue("PMD_AAA506_001_000_1FK2");

  var sTable = "VT_1FK2_M00138" + sDB_Suffix;
  var sTargetAttribute = "HMK_WELLENAUSF_1FK2";
  var sWhere = "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    "MLFB12_1FK2 = '" + MLFB12_1FK2 + "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
    "PMD_AAA506_001_000_1FK2 = '" + PMD_AAA506_001_000_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";
  // n-ter Lauf, da für Gearbox-coupling ggf schon eingeschränkt
  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_ALT_WELLE_NO_DB_RESULT";
    return strError;
  }

  if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
    var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2"); // Getriebetyp
    var UI_GETRIEBE_SIZE_1FK2 = ECL_GetValue("UI_GETRIEBE_SIZE_1FK2"); // Getriebegröße

    var sTable = "VT_1FK2_M00107" + sDB_Suffix;
    var sWhere = "PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
      "UI_GETRIEBE_SIZE_1FK2 = '" + UI_GETRIEBE_SIZE_1FK2 + "' AND " +
      "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_ALT_WELLE_NO_DB_RESULT";
      return strError;
    }
  }

  // ################################################################################################################

  // ################################################################################################################
  // VT_085 - Definition Wellenmaße			HMK_WELLENAUSF_1FK2, HMK_WELLENENDE_1FK2, PMD_ACB769_001_000_1FK2, PMD_ACB783_001_000_1FK2
  // ################################################################################################################
  /* Einschränken, welche Wellenabmaße noch erlaubt sind
    RESTRICTIONS: TABLE VT_1FK2_M00085 (
      MLFB06_1FK2 =c.MLFB06_1FK2 ,
      MLFB07_1FK2 =c.MLFB07_1FK2 ,
      HMK_WELLENAUSF_1FK2 =c.HMK_WELLENAUSF_1FK2 ,
      HMK_WELLENENDE_1FK2 =c.HMK_WELLENENDE_1FK2 ,
      PMD_ACB769_001_000_1FK2 =c.PMD_ACB769_001_000_1FK2 ,
      PMD_ACB783_001_000_1FK2 =c.PMD_ACB783_001_000_1FK2 ,
      HMK_VALUE_VALID_1FK2 =c.HMK_VALUE_VALID_1FK2 )
    *
    INFERENCES:
      c.MLFB06_1FK2 ,
      c.MLFB07_1FK2 ,
      c.HMK_WELLENAUSF_1FK2,
      c.HMK_WELLENENDE_1FK2,
      c.PMD_ACB769_001_000_1FK2,
      c.PMD_ACB783_001_000_1FK2
    */
  var sWhereWellenAusf = "";
  if (ECL_ValueEnabled("HMK_WELLENAUSF_1FK2", "ALT") && ECL_ValueEnabled("HMK_WELLENAUSF_1FK2", "STD")) {
    sWhereWellenAusf = "(HMK_WELLENAUSF_1FK2 = 'STD' OR HMK_WELLENAUSF_1FK2 = 'ALT') AND ";
  } else if (ECL_ValueEnabled("HMK_WELLENAUSF_1FK2", "ALT")) {
    sWhereWellenAusf = "HMK_WELLENAUSF_1FK2 = 'ALT' AND ";
  } else {
    sWhereWellenAusf = "HMK_WELLENAUSF_1FK2 = 'STD' AND ";
  }

  // VT_1FK2_M00085
  //	MLFB06_1FK2	MLFB07_1FK2	HMK_WELLENAUSF_1FK2	HMK_WELLENENDE_1FK2	PMD_ACB769_001_000_1FK2	PMD_ACB783_001_000_1FK2	HMK_VALUE_VALID_1FK2

  var sTable = "VT_1FK2_M00085" + sDB_Suffix;
  var sTargetAttribute = "HMK_WELLENENDE_1FK2";
  var sWhere = "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    sWhereWellenAusf + "HMK_VALUE_VALID_1FK2 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_ALT_WELLE_NO_DB_RESULT";
    return strError;
  }

  var HMK_WELLENENDE_1FK2 = ECL_GetValue("HMK_WELLENENDE_1FK2");

  // alternative Wellengeometrie (HMK_WELLENAUSF_1FK2) setzen, falls gewählt
  // VT_1FK2_M00085
  // 	MLFB06_1FK2	MLFB07_1FK2	HMK_WELLENAUSF_1FK2	HMK_WELLENENDE_1FK2	PMD_ACB769_001_000_1FK2	PMD_ACB783_001_000_1FK2	HMK_VALUE_VALID_1FK2
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    "HMK_WELLENENDE_1FK2 = '" + HMK_WELLENENDE_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_WELLENAUSF_1FK2 = aResult[0].HMK_WELLENAUSF_1FK2;
    var PMD_ACB769_001_000_1FK2 = aResult[0].PMD_ACB769_001_000_1FK2;
    var PMD_ACB783_001_000_1FK2 = aResult[0].PMD_ACB783_001_000_1FK2;

    ECL_SetValue("HMK_WELLENAUSF_1FK2", HMK_WELLENAUSF_1FK2);

    ECL_SetValue("PMD_ACB769_001_000_1FK2", PMD_ACB769_001_000_1FK2);
    ECL_SetValue("PMD_ACB783_001_000_1FK2", PMD_ACB783_001_000_1FK2);
  } else {
    strError = "DICT1_ERR_1FT2___PLVT_ALT_WELLE_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  //VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
  //	MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
  var HMK_WELLENAUSF_1FK2 = ECL_GetValue("HMK_WELLENAUSF_1FK2");

  var sTable = "VT_1FK2_M00138" + sDB_Suffix;
  var sTargetAttribute = "PMD_AAA506_001_000_1FK2";
  var sWhere = "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "' AND " +
    "MLFB12_1FK2 = '" + MLFB12_1FK2 + "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
    "HMK_WELLENAUSF_1FK2 = '" + HMK_WELLENAUSF_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_WELLENENDE_NO_DB_RESULT";
    return strError;
  }
  // ################################################################################################################
  // setze MLFB13
  // ################################################################################################################
  /*
    MLFB13_1FK2		PMD_AAA506_001_000_1FK2		HMK_WELLENAUSF_1FK2
    0				      Z0002				          		STD
    1			      	Z0004				          		STD
    2			      	Z0002				          		ALT
    */
  var PMD_AAA506_001_000_1FK2 = ECL_GetValue("PMD_AAA506_001_000_1FK2");
  var HMK_WELLENAUSF_1FK2 = ECL_GetValue("HMK_WELLENAUSF_1FK2");

  if (PMD_AAA506_001_000_1FK2 == "Z0002" && HMK_WELLENAUSF_1FK2 == "STD") {
    MLFB13_1FK2 = "0";
  } else if (PMD_AAA506_001_000_1FK2 == "Z0002" && HMK_WELLENAUSF_1FK2 == "ALT") {
    MLFB13_1FK2 = "2";
  } else if (PMD_AAA506_001_000_1FK2 == "Z0004" && HMK_WELLENAUSF_1FK2 == "STD") {
    MLFB13_1FK2 = "1";
  } else {
    //Fehler
  }

  ECL_SetValue("MLFB13_1FK2", MLFB13_1FK2);

  sMLFB = replaceAt(sMLFB, 12, MLFB13_1FK2);
  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // ################################################################################################################
  // HMK_WELLE_DXL_GETR_1FK2	Wellenende D x Länge des Getriebes														<==== GETRIEBEMOTOR
  // ################################################################################################################
  /*
    VT_1FK2_M00095	ZO Getriebe-Wellenende
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        HMK_WELLE_DXL_GETR_1FK2		Wellenende /.../Getriebes
        HMK_ZENTR_LOCHK_GETR_1FK2	Zentrierrand /.../Getriebes
        HMK_VALUE_VALID_1FK2		Wert gültig
    
    ==> 1:1 Beziehung, fest mit Getriebe definiert. Siehe Parser-Skripte
    */

  // ################################################################################################################

  // Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor
  // Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor	Getriebemotor

  // ################################################################################################################
  // UI_GETRIEBE_TYP_1FK2	Getriebetyp			durch SIZER vorgegeben
  // ################################################################################################################
  /*
    VT_1FK2_M00091	ZO GetriebeKey, Typ, Größe
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
        HMK_VALUE_VALID_1FK2		Wert gültig
    
    VT_1FK2_M00105	ZO Schutzart Motor-Getriebe
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
        HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
        PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes
        HMK_VALUE_VALID_1FK2		Wert gültig
    
    VT_1FK2_M00119	ZO Getriebe - Bild Datenblatt
    n.n.
    */

  // ################################################################################################################

  // ################################################################################################################
  // UI_GETRIEBE_SIZE_1FK2	Getriebegröße		durch SIZER vorgegeben
  // ################################################################################################################
  /*
    VT_1FK2_M00091	ZO GetriebeKey, Typ, Größe
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        UI_GETRIEBE_TYP_1FK2		Getriebetyp
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
        HMK_VALUE_VALID_1FK2		Wert gültig
    
    VT_1FK2_M00107	ZO AH Getriebe Wellengeometrie
        PMD_ACH516_001_000_1FK2		Achshöhe /.../Anmerkung
        UI_GETRIEBE_SIZE_1FK2		Getriebegröße
        HMK_WELLENAUSF_1FK2			Wellenausführung
        HMK_VALUE_VALID_1FK2		Wert gültig

    */

  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABV413_001_000_1FK2	Übersetzung i		durch SIZER vorgegeben
  // ################################################################################################################
  /* 
    VT_1FK2_M00097	ZO KAG A**,B**,C**,R**
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung / des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl /.../Getriebes
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		Wert gültig

alt	VT_1FK2_M00190	ZO GetrMotor Auswahl neutral
neu	VT_1FK2_M00217	ZO GetrMotor Auswahl neutral
    PMD_ABV410_001_000_1FK2
    PMD_ABV413_001_000_1FK2
    PMD_ABV417_001_000_1FK2
    PMD_ABW811_001_000_1FK2
    PMD_ABW812_001_000_1FK2
    PMD_ACG188_001_000_1FK2
    PMD_ABW952_001_000_1FK2
    */

  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABV417_001_000_1FK2	Anzahl Getriebestufen z		durch SIZER vorgegeben
  // ################################################################################################################
  /* 
    VT_1FK2_M00097	ZO KAG A**,B**,C**,R**
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung / des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl /.../Getriebes
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		Wert gültig

    alt	VT_1FK2_M00190	ZO GetrMotor Auswahl neutral
  neu	VT_1FK2_M00217	ZO GetrMotor Auswahl neutral
    PMD_ABV410_001_000_1FK2
    PMD_ABV413_001_000_1FK2
    PMD_ABV417_001_000_1FK2
    PMD_ABW811_001_000_1FK2
    PMD_ABW812_001_000_1FK2
    PMD_ACG188_001_000_1FK2
    PMD_ABW952_001_000_1FK2
    */

  // ################################################################################################################

  // ################################################################################################################
  // O_A11_C42_1FK2	Option Getriebetyp ABC**			durch SIZER vorgegeben
  // ################################################################################################################
  /* 
    VT_1FK2_M00097	ZO KAG A**,B**,C**,R**
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung / des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl /.../Getriebes
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		Wert gültig

    VT_1FK2_M00259	ZO gültige Rümpfe-KAGs
        MLFB_RUMPF_01_10_1FK2		MLFB-Rumpf, 1.-10. Stelle
        O_A11_C42_1FK2				Option Getriebetyp ABC**
        O_R00_R80_1FK2				Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		Wert gültig
    */

  // ################################################################################################################

  // ################################################################################################################
  // O_R00_R80_1FK2	Option GetriebeÜbers R**			durch SIZER vorgegeben
  // ################################################################################################################
  /* 
    VT_1FK2_M00097	ZO KAG A**,B**,C**,R**
        PMD_ABV410_001_000_1FK2		Produkttyp-Beze.../Getriebes
        PMD_ABV413_001_000_1FK2		Übersetzung / des Getriebes
        PMD_ABV417_001_000_1FK2		Anzahl /.../Getriebes
        O_A11_C42_1FK2				    Option Getriebetyp ABC**
        O_R00_R80_1FK2				    Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		  Wert gültig

    VT_1FK2_M00259	ZO gültige Rümpfe-KAGs
        MLFB_RUMPF_01_10_1FK2		MLFB-Rumpf, 1.-10. Stelle
        O_A11_C42_1FK2				  Option Getriebetyp ABC**
        O_R00_R80_1FK2				  Option GetriebeÜbers R**
        HMK_VALUE_VALID_1FK2		Wert gültig
    */

  // ################################################################################################################

  // ################################################################################################################
  // PMD_ACE728_001_000_1FK2	Schmierung des Getriebes
  // ################################################################################################################
  /* VT_1FK2_M00096	ZO KAG M00-M11
        PMD_ABV414_001_000_1FK2		Ausführung /...btriebsseite
        PMD_ACE728_001_000_1FK2		Art der Schmierung
        O_M00_M11_1FK2				Option Getriebe M00-M11
        HMK_VALUE_VALID_1FK2		Wert gültig
    
    keine Einschränkungen, bestimmung M00 s. unten
    NEU Winkelgetriebe: nur STD	
  PMD_ACE728_001_000_1FK2	Schmierung des Getriebes	00001	Standard

    Steuerung aus neuem Kontext (EDIT 05.2023) GearLubricant (Standard, FB) if not set or 'Standard', only STD available; if 'FB', only FB available.
  */
  if (bMitGetriebe) {
    var ECSI_CX_GearLubricant = ECL_GetValue("ECSI_CX_GearLubricant");

    //Edit 05.2023 Ticket 49388: Config: Allow F&B lubricant for angled gears of 1FK2/1FT2 motors and preset by config context
    ECL_DeactivateAllAttributeValues("PMD_ACE728_001_000_1FK2");

    if (ECSI_CX_GearLubricant == "Standard") {
      ECL_ActivateValue("PMD_ACE728_001_000_1FK2", "00001");
      ECL_SelectValue("PMD_ACE728_001_000_1FK2", "00001");
    } else if (ECSI_CX_GearLubricant == "FB") {
      ECL_ActivateValue("PMD_ACE728_001_000_1FK2", "00002");
      ECL_SelectValue("PMD_ACE728_001_000_1FK2", "00002");
    } else {
      // STD only
      ECL_ActivateValue("PMD_ACE728_001_000_1FK2", "00001");
      ECL_SelectValue("PMD_ACE728_001_000_1FK2", "00001");
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_M00_M11_1FK2	Option Getriebe M00-M11
  // ################################################################################################################
  /* VT_1FK2_M00096	ZO KAG M00-M11
        PMD_ABV414_001_000_1FK2		Ausführung /...btriebsseite
        PMD_ACE728_001_000_1FK2		Art der Schmierung
        O_M00_M11_1FK2				Option Getriebe M00-M11
        HMK_VALUE_VALID_1FK2		Wert gültig
    */
  if (bMitGetriebe) {
    var sTargetAttribute = "O_M00_M11_1FK2";

    var PMD_ABV414_001_000_1FK2 = ECL_GetValue("PMD_ABV414_001_000_1FK2");
    var PMD_ACE728_001_000_1FK2 = ECL_GetValue("PMD_ACE728_001_000_1FK2");

    var sTable = "VT_1FK2_M00096" + sDB_Suffix;
    var sWhere =
      "PMD_ABV414_001_000_1FK2 = '" +
      PMD_ABV414_001_000_1FK2 +
      "' AND " +
      "PMD_ACE728_001_000_1FK2 = '" +
      PMD_ACE728_001_000_1FK2 +
      "' AND " +
      "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_M00_M11_NO_DB_RESULT";
      return strError;
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // O_Q91_Q93_1FK2	Orientierung des Getriebes
  // ################################################################################################################
  /*	VT_1FK2_M00243	ZO Getrtyp - Getr-Orientierung
    UI_GETRIEBE_TYP_1FK2	O_Q91_Q93_1FK2
  */
  if (bWinkelgetriebe) {
    var sTargetAttribute = "O_Q91_Q93_1FK2";

    ECL_ActivateAttribute("O_Q91_Q93_1FK2");

    var strBaseTypeMLFB_KAGs = strBaseTypeMLFB.substring(16);
    var O_Q91_Q93_1FK2 = ECL_GetValue("O_Q91_Q93_1FK2");
    var iIndexQnn = strBaseTypeMLFB_KAGs.indexOf(O_Q91_Q93_1FK2);

    if (strBaseTypeMLFB !== "" && iIndexQnn < 0) {
      var UI_GETRIEBE_TYP_1FK2 = ECL_GetValue("UI_GETRIEBE_TYP_1FK2");

      var sTable = "VT_1FK2_M00243" + sDB_Suffix;
      var sWhere = "UI_GETRIEBE_TYP_1FK2 = '" + UI_GETRIEBE_TYP_1FK2 + "';";

      var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

      if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT2___PLVT_Q91_Q93_NO_DB_RESULT";
        return strError;
      }
    }
  } else {
    ECL_DeactivateAllAttributeValues("O_Q91_Q93_1FK2");
    ECL_ActivateValue("O_Q91_Q93_1FK2", "-");
    ECL_SelectValue("O_Q91_Q93_1FK2", "-");

    ECL_DeactivateAttribute("O_Q91_Q93_1FK2");
  }

  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABU276_001_000_1FK2		Haltebremse				MLFB11_1FK2
  // ################################################################################################################
  /*
    VT 188
    VT_1FK2_M00247	MLFB11 <> Haltebremse	nur Übersetzung
        MLFB11_1FK2 PMD_ABU276_001_000_1FK2 HMK_HOLDING_BRAKE_1FK2
    VT_1FK2_M00253 Daten Bremse
    
    MLFB11_1FK2 VTs:
    VT_1FK2_M00247	MLFB11 <> Haltebremse
    */
  // ==> Steuerung aus Kontext im Parser
  var strWithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
  var HMK_HOLDING_BRAKE_1FK2 = ECL_GetValue("HMK_HOLDING_BRAKE_1FK2");
  if (strchangedAttribute == "HMK_HOLDING_BRAKE_1FK2") {
    if (HMK_HOLDING_BRAKE_1FK2 == "STANDARD") {
      MLFB11_1FK2 = "1";
    } else if (HMK_HOLDING_BRAKE_1FK2 == "REINFORC") {
      MLFB11_1FK2 = "2";
    }
  }
  if (strBaseTypeMLFB.charAt(10) == ".") {
    if (strWithBrake == "1") {
      /*ECL_ActivateAllAttributeValues("HMK_HOLDING_BRAKE_1FK2");
            ECL_DeactivateValue("HMK_HOLDING_BRAKE_1FK2", "NO");
            ExecSetStandardifValueEmpty("HMK_HOLDING_BRAKE_1FK2", "STANDARD");
            */
      ECL_ActivateAllAttributeValues("PMD_ABU276_001_000_1FK2");
      ECL_DeactivateValue("PMD_ABU276_001_000_1FK2", "F");
      ECL_SelectValue("PMD_ABU276_001_000_1FK2", "T");

      // Bremsen einschränken (MLFB11)
      var sTable = "VT_1FK2_M00188" + sDB_Suffix;
      // MLFB_RUMPF_01_10_1FK2	MLFB11_1FK2	HMK_VALUE_VALID_1FK2
      // MLFB11 anhand VT188 einschränken, anschließend Übernahme auf HMK_HOLDING_BRAKE_1FK2
      simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00188" + sDB_Suffix, {
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
          MLFB11_1FK2: {
            inferenceType: VariantTables.Inference.RestrictAll,
          },
        },
      });
      ECL_DeactivateValue("MLFB11_1FK2", "0");
      // übertragen von MLFB11 auf HMK_HOLDING_BRAKE_1FK2
      var sStatus = SetAttributeLogicFromMLFB("HMK_HOLDING_BRAKE_1FK2", "MLFB11_1FK2", "VT_1FK2_M00247" + sDB_Suffix);
      if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT2___PLVT_BRAKE_NO_DB_RESULT";
        return strError;
      }
    } else {
      ECL_DeactivateAllAttributeValues("HMK_HOLDING_BRAKE_1FK2");
      ECL_ActivateValue("HMK_HOLDING_BRAKE_1FK2", "NO");
      ECL_SelectValue("HMK_HOLDING_BRAKE_1FK2", "NO");
      ECL_DeactivateAllAttributeValues("PMD_ABU276_001_000_1FK2");
      ECL_ActivateValue("PMD_ABU276_001_000_1FK2", "F");
      ECL_SelectValue("PMD_ABU276_001_000_1FK2", "F");
    }
  } else {
    ECL_DeactiviteAllAttributeValues("PMD_ABU276_001_000_1FK2");
    ECL_DeactiviteAllAttributeValues("HMK_HOLDING_BRAKE_1FK2");
    if (strWithBrake == "1") {
      var PMD_ABU276_001_000_1FK2 = "T";

      if (MLFB11_1FK2 == "1") {
        // mit Bremse Standard
        var HMK_HOLDING_BRAKE_1FK2 = "STANDARD";
      } else if (MLFB11_1FK2 == "2") {
        // mit Bremse verstärkt
        var HMK_HOLDING_BRAKE_1FK2 = "REINFORC";
      } else {
        // ohne Bremse
        // Fehler
      }
    } else {
      var HMK_HOLDING_BRAKE_1FK2 = "NO";
      var PMD_ABU276_001_000_1FK2 = "F";
    }
    ECL_ActivateValue("PMD_ABU276_001_000_1FK2", PMD_ABU276_001_000_1FK2);
    ECL_SelectValue("PMD_ABU276_001_000_1FK2", PMD_ABU276_001_000_1FK2);

    ECL_ActivateValue("HMK_HOLDING_BRAKE_1FK2", HMK_HOLDING_BRAKE_1FK2);
    ECL_SelectValue("HMK_HOLDING_BRAKE_1FK2", HMK_HOLDING_BRAKE_1FK2);
  }

  // ################################################################################################################

  // ################################################################################################################
  // setze MLFB11
  // ################################################################################################################
  var HMK_HOLDING_BRAKE_1FK2 = ECL_GetValue("HMK_HOLDING_BRAKE_1FK2");

  if (strBaseTypeMLFB.charAt(10) == ".") {
    if (HMK_HOLDING_BRAKE_1FK2 == "STANDARD") {
      MLFB11_1FK2 = "1";
    } else if (HMK_HOLDING_BRAKE_1FK2 == "REINFORC") {
      MLFB11_1FK2 = "2";
    } else {
      MLFB11_1FK2 = "0";
    }

    ECL_SetValue("MLFB11_1FK2", MLFB11_1FK2);

    sMLFB = replaceAt(sMLFB, 10, MLFB11_1FK2);
    ECL_SetValue("ECSI_MLFB", sMLFB);
  }
  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABU278_001_000_1FK2		Geber			MLFB14_1FK2
  // ################################################################################################################
  /*
    VT_1FK2_M00140	Rumpf <> Geber
        MLFB13_1FK2	PMD_ABU278_001_000_1FK2	MLFB_RUMPF_01_10_1FK2	HMK_UMR_SPANNUNG_1FK2
    
    VT_1FK2_M00186	Restrict Geber Wellenende Ausf
        PMD_ABU278_001_000_1FK2	HMK_WELLENENDE_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    
    VT_1FK2_M00187	ZO Trigger, MLFB14, Geber
        HMK_SYSTEM_TRIG_1FK2	HMK_TARGET_TRIGGER_1FK2	MLFB01_1FK2	MLFB14_1FK2	PMD_ABU278_001_000_1FK2	HMK_KONFIG_TYP_1FK2

    
    MLFB14_1FK2 VTs:
        VT_1FK2_M00122	Mech. Daten
        VT_1FK2_M00187	ZO Trigger, MLFB14, Geber
    */
  var sTargetAttribute = "PMD_ABU278_001_000_1FK2";

  var sTable = "VT_1FK2_M00140" + sDB_Suffix;
  var sWhere = "MLFB_RUMPF_01_10_1FK2 = '" + MLFB_RUMPF_01_10_1FK2 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_GEBER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  var HMK_WELLENENDE_1FK2 = ECL_GetValue("HMK_WELLENENDE_1FK2");
  var HMK_WELLENAUSF_1FK2 = ECL_GetValue("HMK_WELLENAUSF_1FK2");

  // alternativ MLFB13_1FK2

  var sTable = "VT_1FK2_M00186" + sDB_Suffix;
  var sWhere = "HMK_WELLENENDE_1FK2 = '" + HMK_WELLENENDE_1FK2 + "' AND " +
    "HMK_WELLENAUSF_1FK2 = '" + HMK_WELLENAUSF_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_GEBER_NO_DB_RESULT";
    return strError;
  }
  // --------------------------------------------------------------------------------------------
  var sTable = "VT_1FK2_M00187" + sDB_Suffix;
  var sWhere = "HMK_SYSTEM_TRIG_1FK2 = '" + HMK_SYSTEM_TRIG_1FK2 + "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
    "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
    "HMK_KONFIG_TYP_1FK2 = 'KONFIG';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_GEBER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // setze MLFB14
  // ################################################################################################################
  var PMD_ABU278_001_000_1FK2 = ECL_GetValue("PMD_ABU278_001_000_1FK2");

  switch (PMD_ABU278_001_000_1FK2) {
    case "00024":
      MLFB14_1FK2 = "S";
      break;
    case "00025":
      MLFB14_1FK2 = "M";
      break;
    case "00026":
      MLFB14_1FK2 = "B";
      break;
    case "00027":
      MLFB14_1FK2 = "C";
      break;
  }
  ECL_SetValue("MLFB14_1FK2", MLFB14_1FK2);

  sMLFB = replaceAt(sMLFB, 13, MLFB14_1FK2);
  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // ################################################################################################################
  // PMD_ABJ176_001_000_1FK2		Schutzart		MLFB12_1FK2
  // ################################################################################################################
  /* 
    MLFB12_1FK2	PMD_ABJ176_001_000_1FK2
    0			Z0011						IP64
    1			Z0023						IP65
    2			Z0008						IP67
    
    VT:
        VT_1FK2_M00005	MLFB12 <> Schutzart					nur Übersetzung
        VT_1FK2_M00104	ZO Schutzart Motor-Getriebemotor	n.n.
    MLFB12_1FK2 VTs
        VT_1FK2_M00005	MLFB12 <> Schutzart
        VT_1FK2_M00138	MLFB12,13 - Wellenende Motor/GetrMotor
            MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
    
    
    Getriebemotor:
    
    HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
        VT_1FK2_M00105	ZO Schutzart Motor-Getriebe
            UI_GETRIEBE_TYP_1FK2		Getriebetyp
            HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
            HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
            PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes
            HMK_VALUE_VALID_1FK2		Wert gültig
        
    HMK_SCHUART_MOTOR_1FK2	Schutzart Motor
        VT_1FK2_M00104	ZO Schutzart Motor-Getriebemotor
            PMD_ABJ176_001_000_1FK2		Schutzart IP
            HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
            HMK_VALUE_VALID_1FK2		Wert gültig
        
        VT_1FK2_M00105	ZO Schutzart Motor-Getriebe
            UI_GETRIEBE_TYP_1FK2		Getriebetyp
            HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
            HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
            PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes
            HMK_VALUE_VALID_1FK2		Wert gültig
        
    PMD_ABY220_001_000_1FK2	Schutzart IP / des Getriebes		(ergibt sich aus oberen Attributen VT...)
        VT_1FK2_M00105	ZO Schutzart Motor-Getriebe
            UI_GETRIEBE_TYP_1FK2		Getriebetyp
            HMK_MIN_SCHUART_GETR_1FK2	Mindestschutzart Getriebe
            HMK_SCHUART_MOTOR_1FK2		Schutzart Motor
            PMD_ABY220_001_000_1FK2		Schutzart IP / des Getriebes
            HMK_VALUE_VALID_1FK2		Wert gültig
    */

  if (bMitGetriebe) {
    // HMK_MIN_SCHUART_GETR_1FK2	Mindest Schutzart Getriebe einschränken
    var sTargetAttribute = "HMK_MIN_SCHUART_GETR_1FK2";

    var UI_GETRIEBE_TYP_1FK2 = ECL_GetValue("UI_GETRIEBE_TYP_1FK2");

    var sTable = "VT_1FK2_M00105" + sDB_Suffix;
    var sWhere = "UI_GETRIEBE_TYP_1FK2 = '" + UI_GETRIEBE_TYP_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_MIN_SCHUART_NO_DB_RESULT";
      return strError;
    }

    if (UI_GETRIEBE_TYP_1FK2 == "00001") {
      // NLC ist IP65
      ECL_DeactivateValue("HMK_MIN_SCHUART_GETR_1FK2", "00001");
    }
    ExecSetStandardifValueEmpty("HMK_MIN_SCHUART_GETR_1FK2", "00001");

    // ----------------------------------------------------------------------------------------

    // PMD_ABY220_001_000_1FK2		Schutzart IP Getriebe bestimmen
    var sTargetAttribute = "PMD_ABY220_001_000_1FK2";

    var sTable = "VT_1FK2_M00105" + sDB_Suffix;
    var sWhere = "UI_GETRIEBE_TYP_1FK2 = '" + UI_GETRIEBE_TYP_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_SCHUART_GETR_NO_DB_RESULT";
      return strError;
    }
  }

  // MLFB12 anhand VT138 einschränken, anschließend Übernahme auf PMD_ABJ176_001_000_1FK2
  simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00138" + sDB_Suffix, {
    inferenceType: VariantTables.Inference.RestrictNone,
    operators: {
      MLFB12_1FK2: {
        inferenceType: VariantTables.Inference.RestrictAll,
      },
    },
  });

  // Einschränkung aus Gearbox-Motor-coupling
  if ((MLFB01_1FK2 == "1FK2" && bGearboxCoupling) ||
    (((MLFB01_1FK2 == "1FT2" && bGearboxCoupling) || bIsDriveTrain) && (MLFB07_1FK2 == "3" || MLFB07_1FK2 == "4"))) {
    ECL_DeactivateValue("MLFB12_1FK2", "1");
    ECL_DeactivateValue("MLFB12_1FK2", "2");
  }
  // ----------------------------------------------------------------------------------------------------------------
  // Übernahme Einschränkung MLFB12 auf PMD_ABJ176_001_000_1FK2
  var sStatus = SetAttributeLogicFromMLFB("PMD_ABJ176_001_000_1FK2", "MLFB12_1FK2", "VT_1FK2_M00005" + sDB_Suffix);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_MLFB12_TO_PMD_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // Übernahme Einschränkung PMD_ABJ176_001_000_1FK2 auf PMD_ABJ176_001_000_1FK2
  var sStatus = SetAttributeLogicFromMLFB("HMK_SCHUART_MOTOR_1FK2", "PMD_ABJ176_001_000_1FK2", "VT_1FK2_M00104" + sDB_Suffix);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_SCHUART_TRANSLATE_NO_DB_RESULT";
    return strError;
  }
  // ----------------------------------------------------------------------------------------------------------------
  // Anhand Schutzart (Standard PMD_ABJ176_001_000_1FK2) Schutzart Motor einschränken HMK_SCHUART_MOTOR_1FK2
  /*if (bMitGetriebe){
        var aValidValuesIP_Motor = ECL_GetAllActiveAttributeValues("PMD_ABJ176_001_000_1FK2");
        
        var aWhereIP_Motor = "(PMD_ABJ176_001_000_1FK2 = '" + aValidValuesIP_Motor[0] + "'";
        
        if (aValidValuesIP_Motor.length > 1){
            
            for (var i = 1; i<aValidValuesIP_Motor.length;i++){
                aWhereIP_Motor += " OR PMD_ABJ176_001_000_1FK2 = '" + aValidValuesIP_Motor[i] + "'";
            }
        }
        aWhereIP_Motor += ") AND ";
        
        var sTargetAttribute = "HMK_SCHUART_MOTOR_1FK2";
        
        var sTable = "VT_1FK2_M00105" + sDB_Suffix;
        var sWhere = 	"UI_GETRIEBE_TYP_1FK2 = '" 		+ UI_GETRIEBE_TYP_1FK2 + "' AND " +
                        aWhereIP_Motor +
                        "HMK_VALUE_VALID_1FK2 = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT2___PLVT_HMK_SCHUART_MOTOR_NO_DB_RESULT";
            return strError;
        }
    }*/
  // ################################################################################################################

  //Wenn Schutzart Motor geändert, dann übertragen in PMD-Attribut für MLFB
  if (strchangedAttribute == "HMK_SCHUART_MOTOR_1FK2") {
    var HMK_SCHUART_MOTOR_1FK2 = ECL_GetValue("HMK_SCHUART_MOTOR_1FK2");

    var sTable = "VT_1FK2_M00104" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " + "HMK_SCHUART_MOTOR_1FK2 = '" + HMK_SCHUART_MOTOR_1FK2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var PMD_ABJ176_001_000_1FK2 = aResult[0].PMD_ABJ176_001_000_1FK2; // Schutzart Motor

      ECL_SelectValue("PMD_ABJ176_001_000_1FK2", PMD_ABJ176_001_000_1FK2);
    } else {
      strError = "DICT1_ERR_1FT2___PLVT_HMK_SCHUART_MOTOR_NO_DB_RESULT";
      return strError;
    }
  }
  // ################################################################################################################

  // ################################################################################################################
  // setze MLFB12
  // ################################################################################################################
  var PMD_ABJ176_001_000_1FK2 = ECL_GetValue("PMD_ABJ176_001_000_1FK2");

  switch (PMD_ABJ176_001_000_1FK2) {
    case "Z0011":
      MLFB12_1FK2 = "0";
      break;
    case "Z0023":
      MLFB12_1FK2 = "1";
      break;
    case "Z0008":
      MLFB12_1FK2 = "2";
      break;
  }
  ECL_SetValue("MLFB12_1FK2", MLFB12_1FK2);

  sMLFB = replaceAt(sMLFB, 11, MLFB12_1FK2);
  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // ################################################################################################################
  // PMD_AAA759_001_000_1FK2		Anschlussstechnik
  // ################################################################################################################
  /*
    Abhängig von Umrichter:
    MLFB15_1FK2		PMD_AAA759_001_000_1FK2		Benennung
    A				00003						OCC für S210
    B				00004						Zweikabel für S120

    Wird dies evtl. vom SIZER übergeben? todo
    
    VT_1FK2_M00069	MLFB15 <> Art des Kabelabgangs		nur Übersetzung
    
    MLFB15_1FK2 VTs:
    x	VT_1FK2_M00069	MLFB15 <> Art des Kabelabgangs
    ?	VT_1FK2_M00071	MLFB15 <> Umr Spannung
    ?	VT_1FK2_M00072	MLFB15 <> TRIG BETRIEB
    x	VT_1FK2_M00073	MLFB15 <> RUMPF_01_10
            MLFB_RUMPF_01_10_1FK2	MLFB15_1FK2
    n.n.	VT_1FK2_M00080	ZO Marketingtexte
    n.n.	VT_1FK2_M00082	ZO Rumpf Kurztexte

    VT_1FK2_M00255	Rumpf+OCC+2CC
      MLFB_RUMPF_01_10_1FK2 PMD_AAA759_001_000_1FK2 PMD_ACW698_001_000_1FK2 PMD_ACL641_001_000_1FK2 HMK_VALUE_VALID_1FK2
    */
  var sTargetAttribute = "PMD_AAA759_001_000_1FK2";

  // Restrictions MLFB15
  simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00073" + sDB_Suffix, {
    inferenceType: VariantTables.Inference.RestrictAll,
    operators: {
      MLFB_RUMPF_01_10_1FK2: {
        inferenceType: VariantTables.Inference.RestrictNone,
      },
    },
  });

  // translate restrictions from MLFB15 to PMD_AAA759_001_000_1FK2
  var sStatus = SetAttributeLogicFromMLFB("PMD_AAA759_001_000_1FK2", "MLFB15_1FK2", "VT_1FK2_M00069" + sDB_Suffix);
  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_MLFB15_TO_PMD_NO_DB_RESULT";
    return strError;
  }
  // Restrictions PMD_AAA759_001_000_1FK2 (VT255)
  var sTable = "VT_1FK2_M00255" + sDB_Suffix;
  var sWhere = "MLFB_RUMPF_01_10_1FK2 = '" + MLFB_RUMPF_01_10_1FK2 + "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    strError = "DICT1_ERR_1FT2___PLVT_PMD_AAA759_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // setze MLFB15
  // ################################################################################################################
  var PMD_AAA759_001_000_1FK2 = ECL_GetValue("PMD_AAA759_001_000_1FK2");

  if (PMD_AAA759_001_000_1FK2 == "00003") {
    MLFB15_1FK2 = "A";
  } else {
    MLFB15_1FK2 = "B";
  }

  ECL_SetValue("MLFB15_1FK2", MLFB15_1FK2);

  sMLFB = replaceAt(sMLFB, 14, MLFB15_1FK2);
  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
  // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
  // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
  if (MLFB01_1FK2 == "1FT2") {
    // ################################################################################################################
    // O_X01_X08_1FK2		Farbe
    // ################################################################################################################
    /*
        VT_1FK2_M00135	ZO N16 X** (nur 1FT2)
        
        VT_1FK2_M00189	Optionen 1FK2/1FT2
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        Logik über VT siehe "VT_135 ZO N16 X**"
        */

    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "O_X01_X08_1FK2";

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " + "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_XNN_NO_DB_RESULT";
      return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // HMK_FARBAUSFUEHRUNG_1FK2		KAG
    // ################################################################################################################
    /*
        VT_1FK2_M00189	Optionen 1FK2/1FT2
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        VT_1FK2_M00205	Restrict Options
            O_N16_1FK2  HMK_FARBAUSFUEHRUNG_1FK2

        VT_1FK2_M00254  Dep cooling N16 Q31 K23 Q40
            PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2

        Logik über VT siehe "VT_135 ZO N16 X**"
        */

    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "HMK_FARBAUSFUEHRUNG_1FK2";

    var O_X01_X08_1FK2 = ECL_GetValue("O_X01_X08_1FK2");

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" +
      MLFB01_1FK2 +
      "' AND " +
      "HMK_TARGET_TRIGGER_1FK2 = '" +
      HMK_TARGET_TRIGGER_1FK2 +
      "' AND " +
      "O_X01_X08_1FK2 = '" +
      O_X01_X08_1FK2 +
      "' AND " +
      "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_K23_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    //  VT_1FK2_M00254  Dep cooling N16 Q31 K23 Q40
    //      PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sWhere = "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_K23_NO_DB_RESULT";
      return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // O_Q30_1FK2   	Eignung für Tieftemperatur bis -30°C
    // ################################################################################################################
    /* Checkbox
      VT_1FK2_M00248	Dep MLFB12 -- Q30
          MLFB12_1FK2     O_Q30_1FK2
      VT_1FK2_M00249	Optionen_2 1FK21FT2
          MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
    */
    var sTargetAttribute = "O_Q30_1FK2";

    var sTable = "VT_1FK2_M00248" + sDB_Suffix;
    var sWhere = "MLFB12_1FK2 = '" + MLFB12_1FK2 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q30_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    var O_X01_X08_1FK2 = ECL_GetValue("O_X01_X08_1FK2");

    var sTable = "VT_1FK2_M00249" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" +
      MLFB01_1FK2 +
      "' AND " +
      "HMK_TARGET_TRIGGER_1FK2 = '" +
      HMK_TARGET_TRIGGER_1FK2 +
      "' AND " +
      "O_X01_X08_1FK2 = '" +
      O_X01_X08_1FK2 +
      "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q30_NO_DB_RESULT";
      return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // O_Q31_1FK2		Metall-Leistungsschild am Motor
    // ################################################################################################################
    /*
        ersetzt durch VT_1FK2_M00156	ZO AH-Q20-Q31-N16 (nur 1FT2)
                PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        VT_1FK2_M00189
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        Logik über VT siehe "VT_136 ZO AH-N16-Q31"

neu        VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
                PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
        */
    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "O_Q31_1FK2";

    /*var O_Q20_1FK2 = ECL_GetValue("O_Q20_1FK2");
        
        var sTable = "VT_1FK2_M00156" + sDB_Suffix;
        var sWhere = 	"PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
                        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
                        "O_Q20_1FK2 = '" + O_Q20_1FK2 + "' AND " +
                        "HMK_VALUE_VALID_1FK2 = 'T';";
        
        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT2___PLVT_Q20_NO_DB_RESULT";
            return strError;
        }*/
    // --------------------------------------------------------------------------------------------

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " + "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q31_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    //  VT_1FK2_M00254  Dep cooling N16 Q31 K23 Q40
    //      PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sWhere =
      "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " + "PMD_AAA136_001_000_1FK2 = '" + PMD_AAA136_001_000_1FK2 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q31_NO_DB_RESULT";
      return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // O_N16_1FK2		Ausführung für erhöhte chemische Beständigkeit
    // ################################################################################################################
    /*
        VT_1FK2_M00135	ZO N16 X** (nur 1FT2)
        VT_1FK2_M00156	ZO AH-Q20-Q31-N16 (nur 1FT2)
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        todo	VT_1FK2_M00189	Optionen 1FK2/1FT2

        Logik über VT siehe "VT_135 ZO N16 X**"
        Logik über VT siehe "VT_136 ZO AH-N16-Q31"

neu        VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
                PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
        VT_1FK2_M00205	Restrict Options
          O_N16_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
        */
    // ################################################################################################################

    // ################################################################################################################
    // VT_1FK2_M00189 Optionen 1FK2/1FT2
    // ################################################################################################################
    /*
        VT_1FK2_M00189
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        jeweils als zusätzliche Einschränkung ausfühern!
        */

    // ################################################################################################################

    // ################################################################################################################
    // VT_135 ZO N16 X**
    // ################################################################################################################
    /*
        RESTRICTIONS: TABLE VT_1FK2_M00135 (
          O_N16_1FK2 =c.O_N16_1FK2 ,
          O_X01_X08_1FK2 =c.O_X01_X08_1FK2 ,
          HMK_VALUE_VALID_1FK2 =c.HMK_VALUE_VALID_1FK2 )
        *
        INFERENCES:
          c.O_N16_1FK2,
          c.O_X01_X08_1FK2,
          c.HMK_VALUE_VALID_1FK2.
        */
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00135" + sDB_Suffix, {
      inferenceType: VariantTables.Inference.RestrictAll,
      operators: {
        HMK_VALUE_VALID_1FK2: {
          inferenceType: VariantTables.Inference.RestrictNone,
        },
      },
    });
    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "O_N16_1FK2";

    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");
    var O_Q31_1FK2 = ECL_GetValue("O_Q31_1FK2");

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere = "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
      "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " +
      "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "' AND " +
      "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_N16_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    /* VT_1FK2_M00205  Restrict Options
      O_N16_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
      */

    var sTable = "VT_1FK2_M00205" + sDB_Suffix;
    var sWhere = "HMK_FARBAUSFUEHRUNG_1FK2 = '" + HMK_FARBAUSFUEHRUNG_1FK2 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_N16_NO_DB_RESULT";
      return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // O_Q20_1FK2		Anschluss zum Druckausgleich
    // ################################################################################################################
    /*
        VT_1FK2_M00156	ZO AH-Q20-Q31-N16 (nur 1FT2)
            PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        
        VT_1FK2_M00189
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        VT_200 ZO Q20
      MLFB10_1FK2	O_Q20_1FK2	HMK_VALUE_VALID_1FK2
        */
    var sTargetAttribute = "O_Q20_1FK2";

    /*
        var PMD_ACH516_001_000_1FK2 = ECL_GetValue("PMD_ACH516_001_000_1FK2");
        var O_N16_1FK2 = ECL_GetValue("O_N16_1FK2");
        
        var sTable = "VT_1FK2_M00156" + sDB_Suffix;
        var sWhere = 	"PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
                        "O_N16_1FK2 = '" + O_N16_1FK2 + "' AND " +
                        "HMK_VALUE_VALID_1FK2 = 'T';";
        
        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT2___PLVT_Q20_NO_DB_RESULT";
            return strError;
        }*/
    // --------------------------------------------------------------------------------------------

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " + "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q20_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------

    var sTable = "VT_1FK2_M00200" + sDB_Suffix;
    var sWhere = "MLFB10_1FK2 = '" + MLFB10_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q20_NO_DB_RESULT";
      return strError;
    }
    // ################################################################################################################





    // ################################################################################################################
    // VT_1FK2_M00156 ZO AH-Q20-Q31-N16 (nur 1FT2)
    // ################################################################################################################
    /*
        ersetzt durch VT_1FK2_M00156	ZO AH-Q20-Q31-N16 (nur 1FT2)
                PMD_ACH516_001_000_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	HMK_VALUE_VALID_1FK2
        RESTRICTIONS: TABLE VT_1FK2_M00156 (
          PMD_ACH516_001_000_1FK2 =c.PMD_ACH516_001_000_1FK2 ,
          O_Q20_1FK2 =c.O_Q20_1FK2 ,
          O_Q31_1FK2 =c.O_Q31_1FK2 ,
          O_N16_1FK2 =c.O_N16_1FK2 ,
          HMK_VALUE_VALID_1FK2 =c.HMK_VALUE_VALID_1FK2 )
        *
        INFERENCES:
          c.PMD_ACH516_001_000_1FK2,
          c.O_Q20_1FK2,
          c.O_Q31_1FK2,
          c.O_N16_1FK2.
        */
    //var oAttributesMapping = {"PMD_ACH516_001_000_1FK2": "UI_VT_ACHSHOEHE_1FK2"};
    if (MLFB01_1FK2 == "1FT2") {
      simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00156" + sDB_Suffix, {
        inferenceType: VariantTables.Inference.RestrictNone,
        //mapping: oAttributesMapping,
        operators: {
          O_N16_1FK2: {
            inferenceType: VariantTables.Inference.RestrictIntersect,
          },
          O_Q20_1FK2: {
            inferenceType: VariantTables.Inference.RestrictIntersect,
          },
          O_Q31_1FK2: {
            inferenceType: VariantTables.Inference.RestrictIntersect,
          },
        },
      });
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_Q40_1FK2   	Kompatibilität Reinraum und Trockenraum
    // ################################################################################################################
    var sTargetAttribute = "O_Q40_1FK2";
    /* Checkbox
            VT_1FK2_M00249	Optionen_2 1FK21FT2
                MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
            VT_1FK2_M00254	Dep cooling N16 Q31 K23 Q40
                PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2

        */
    //  VT_1FK2_M00249	Optionen_2 1FK21FT2
    //      MLFB01_1FK2 HMK_TARGET_TRIGGER_1FK2 O_Q30_1FK2  O_Q40_1FK2  O_X01_X08_1FK2
    var O_Q30_1FK2 = ECL_GetValue("O_Q30_1FK2");
    var O_X01_X08_1FK2 = ECL_GetValue("O_X01_X08_1FK2");

    var sTable = "VT_1FK2_M00249" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" +
      MLFB01_1FK2 +
      "' AND " +
      "HMK_TARGET_TRIGGER_1FK2 = '" +
      HMK_TARGET_TRIGGER_1FK2 +
      "' AND " +
      "O_Q30_1FK2 = '" +
      O_Q30_1FK2 +
      "' AND " +
      "O_X01_X08_1FK2 = '" +
      O_X01_X08_1FK2 +
      "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q40_NO_DB_RESULT";
      return strError;
    }
    // --------------------------------------------------------------------------------------------
    //  VT_1FK2_M00254  Dep cooling N16 Q31 K23 Q40
    //      PMD_AAA136_001_000_1FK2 O_N16_1FK2  O_Q31_1FK2  O_Q40_1FK2  HMK_FARBAUSFUEHRUNG_1FK2
    var HMK_FARBAUSFUEHRUNG_1FK2 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FK2");
    var O_Q31_1FK2 = ECL_GetValue("O_Q31_1FK2");

    var sTable = "VT_1FK2_M00254" + sDB_Suffix;
    var sWhere =
      "O_Q31_1FK2 = '" +
      O_Q31_1FK2 +
      "' AND " +
      "HMK_FARBAUSFUEHRUNG_1FK2 = '" +
      HMK_FARBAUSFUEHRUNG_1FK2 +
      "' AND " +
      "PMD_AAA136_001_000_1FK2 = '" +
      PMD_AAA136_001_000_1FK2 +
      "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Q40_NO_DB_RESULT";
      return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // O_Y84_1FK2		Kundenangabe auf dem Leistungsschild
    // ################################################################################################################
    /*
        O_Y84_TXT_1FK2
        
        VT_1FK2_M00189
            MLFB01_1FK2	HMK_TARGET_TRIGGER_1FK2	O_Q20_1FK2	O_Q31_1FK2	O_N16_1FK2	O_X01_X08_1FK2	O_Y84_1FK2	HMK_FARBAUSFUEHRUNG_1FK2	HMK_VALUE_VALID_1FK2
        
        
        Wenn eine Eingabe im Textfeld gemacht wird, wird die Option verdeckt gesetzt, wenn Textfeld leer, dann Option 'F'
        */

    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "O_Y84_1FK2";

    var sTable = "VT_1FK2_M00189" + sDB_Suffix;
    var sWhere =
      "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " + "HMK_TARGET_TRIGGER_1FK2 = '" + HMK_TARGET_TRIGGER_1FK2 + "' AND " + "HMK_VALUE_VALID_1FK2 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      strError = "DICT1_ERR_1FT2___PLVT_Y84_NO_DB_RESULT";
      return strError;
    }

    if (ECL_ValueEnabled("O_Y84_1FK2", "Y84")) {
      ECL_ActivateAttribute("O_Y84_TXT_1FK2");
    } else {
      ECL_DeactivateAttribute("O_Y84_TXT_1FK2");
    }

    if (strchangedAttribute == "O_Y84_TXT_1FK2") {
      var sValueNorm = normalizeOE_Attribute("O_Y84_TXT_1FK2");
      if (sValueNorm == "") {
        ECL_SetValue("O_Y84_1FK2", "F");
      } else {
        ECL_SetValue("O_Y84_1FK2", "Y84");
      }
    }

    // ################################################################################################################
  }

  // ################################################################################################################
  // MLFB
  // ################################################################################################################

  // setzen der MLFB-Einzel-Attribute aus den Nutzer-Attributen <=== erfolgt direkt
  /*
    var MLFB_RUMPF_01_10_1FK2 = ECL_GetValue("MLFB_RUMPF_01_10_1FK2");
    var MLFB11_1FK2 = ECL_GetValue("MLFB11_1FK2");
    var MLFB12_1FK2 = ECL_GetValue("MLFB12_1FK2");
    var MLFB13_1FK2 = ECL_GetValue("MLFB13_1FK2");
    var MLFB14_1FK2 = ECL_GetValue("MLFB14_1FK2");
    var MLFB15_1FK2 = ECL_GetValue("MLFB15_1FK2");
    var MLFB16_1FK2 = ECL_GetValue("MLFB16_1FK2");
    
    var strMLFB = 	MLFB_RUMPF_01_10_1FK2 + 
                    MLFB11_1FK2 + 
                    MLFB12_1FK2 +
                    MLFB13_1FK2 +
                    MLFB14_1FK2 +
                    MLFB15_1FK2 +
                    MLFB16_1FK2;
    
    //ECL_SetValue("ECSI_MLFB", strMLFB);
    
    /*strMLFB = replaceAt(strMLFB, 10, MLFB11_1FK2);
    strMLFB = replaceAt(strMLFB, 11, MLFB12_1FK2);
    strMLFB = replaceAt(strMLFB, 12, MLFB13_1FK2);
    strMLFB = replaceAt(strMLFB, 13, MLFB14_1FK2);
    strMLFB = replaceAt(strMLFB, 14, MLFB15_1FK2);
    */
  // ################################################################################################################

  return "OK";
}
