//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1FT2_MLFB/Base.misc.js"

//@import "../1FT2_CONFIG/VT_1FT2.js"

/**
 * @category   1FK7 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2020 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
  vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  var HMK_TARGET_TRIGGER_1FK2 = ECL_GetValue("HMK_TARGET_TRIGGER_1FK2");

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
  /*	
    
    if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration="1" ;
    
    if(strStartConfiguration=="1")
    {*/
  //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
  //Hier sollen dann möglichst viele Attribute beibehalten werden.
  //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
  if (strBaseTypeMLFB != "") {
    //--------------------------------------------------------------------------------------------------------
    // Base Type  MLFB aufbereiten
    //--------------------------------------------------------------------------------------------------------
    var aBTComponents = tokenize(strBaseTypeMLFB);
    if (aBTComponents.length > 1) {
      // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
      // eliminate the resulting invalid short description 'Z'
      if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
        aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
      }
    }

    strBaseTypeMLFB = aBTComponents[0];

    if (strBaseTypeMLFB.length === 17) {
      // eliminate the -Z
      strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
    }

    var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 10);
  }

  var oResult;

  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_1FT2___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  if (aComponents[0].length != 16) {
    oParsing.strError = "ERRORMSG_MLFB_1FT2___INVALID_MLFB_LENGTH";
    return oParsing;
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  var strMLFB_fix = strMLFB.substring(0, 10); // entspricht der MLFB_RUMPF_01_10_1FK2

  // -----------------------------------------------------------------------------------------------
  //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
  // -----------------------------------------------------------------------------------------------
  // prüfen für Getriebe KAGs Ann, Bnn, Cnn und Übersetzungen Rnn
  var sKAG_GearType = getKAGforAttribute("O_A11_C42_1FK2", aComponents);
  var sKAG_GearTrans = getKAGforAttribute("O_R00_R80_1FK2", aComponents);
  // BaseType
  var sKAG_GearType_BT = getKAGforAttribute("O_A11_C42_1FK2", aBTComponents);
  var sKAG_GearTrans_BT = getKAGforAttribute("O_R00_R80_1FK2", aBTComponents);

  var bGearType = false;
  var bGearTrans = false;

  if (sKAG_GearType != sKAG_GearType_BT) bGearType = true;

  if (sKAG_GearTrans != sKAG_GearTrans_BT) bGearTrans = true;

  // EDIT RepairConfig added
  if (
    strStartConfiguration == "1" &&
    strBaseTypeMLFB_fix == strMLFB_fix &&
    strBaseTypeMLFB != "" &&
    find(strMLFB.left(16), ".") < 0
  ) {
    // if same motor is selected again
    var bRepairConfig = true;
  }

  if (
    (strBaseTypeMLFB_fix != strMLFB_fix &&
      find(strMLFB.left(16), ".") < 0 &&
      strBaseTypeMLFB != "") ||
    bGearType ||
    bGearTrans ||
    bRepairConfig
  ) {
    // KAGs aus Basetype in MLFB übernehmen, alte KAGs in MLFB entfernen
    // alt: aComponents
    // neu: aBTComponents

    // prüfen für Getriebe KAGs Ann, Bnn, Cnn und Übersetzungen Rnn
    var sKAG_GearType = getKAGforAttribute("O_A11_C42_1FK2", aComponents);
    var sKAG_GearTrans = getKAGforAttribute("O_R00_R80_1FK2", aComponents);
    // BaseType
    var sKAG_GearType_BT = getKAGforAttribute("O_A11_C42_1FK2", aBTComponents);
    var sKAG_GearTrans_BT = getKAGforAttribute("O_R00_R80_1FK2", aBTComponents);
    // wenn kein GMOT mehr, nur löschen

    // delete old KAG
    var aNewArray = [];
    for (var i = 0; i < aComponents.length; i++) {
      if (aComponents[i] != sKAG_GearType && aComponents[i] != sKAG_GearTrans) {
        aNewArray.push(aComponents[i]);
      }
    }

    aComponents = aNewArray;

    strMLFB = replace(strMLFB, "+" + sKAG_GearType, "");
    strMLFB = replace(strMLFB, "+" + sKAG_GearTrans, "");
    strMLFB = replace(strMLFB, sKAG_GearType, "");
    strMLFB = replace(strMLFB, sKAG_GearTrans, "");

    if (HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
      // Add new KAGs
      aComponents.push(sKAG_GearType_BT);
      aComponents.push(sKAG_GearTrans_BT);
      aComponents.sort();

      strMLFB = strMLFB + " +" + sKAG_GearType_BT;
      strMLFB = strMLFB + " +" + sKAG_GearTrans_BT;
    }

    ECL_SetValue("ECSI_MLFB", strMLFB);

    // -----------------------------------------------------------------------------------------------
    // Platzhalter aus MLFB in BT übernehmen
    // -----------------------------------------------------------------------------------------------
    /* MLFB-Schema
            MLFB01	1FT2
            MLFB05	Trägheit (Motortyp)	
            MLFB06	Achshöhe 1	
            MLFB07	Achshöhe 2 
            MLFB08	Baulänge 
            MLFB09	A,S (A: Selbstkühlung, S: Fremdbelüftet)
            MLFB10	Wicklung/Bemessungsdrehzahl (B, C, F, G, K)	neu: H + E
            MLFB11	. Bremse (0: ohne, 1: mit Std, 2: mit verstärkt)
            MLFB12	. Schutzart
            MLFB13	. Wellenende, Passfeder
            MLFB14	. Geber (S, M, B, C)
            MLFB15	. Anschlusstechnik	A, B	==> PMD_AAA759_001_000_1FK2		00003, 00004
            MLFB16	0 (reserviert) 
        */
    // 11-15 ein Wildcard, dann Wert aus alter MLFB setzen, ggf. Default setzen

    // --------------------------------------------------------------------------------------------------------
    // MLFB11 Bremse Default 0 ohne Bremse, 1 mit Bremse
    // --------------------------------------------------------------------------------------------------------
    var sMLFB11 = strMLFB.charAt(10);
    var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);

    if (sBT_MLFB11 == ".") {
      //MLFB11 Bremse Default 0 ohne Bremse, 1 mit Bremse Standard, 2 verstärkte Bremse

      // Wenn Bremse pflicht, dann setzen, sonst Übernahme aus MLFB
      var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");

      if (strwithBrake == "1") {
        // mit Bremse (STD oder verstärkt)
        if (sMLFB11 == "0") {
          // set Std-Brake
          sMLFB11 = "1";
        }
        sMLFB11 = getValidMLFB11_1FT2(strBaseTypeMLFB_fix, sMLFB11);
        if (sMLFB11 == "0") {
          oParsing.strError = "ERRORMSG_MLFB_1FT2___BRAKE_CX_MLFB";
        }
      } else {
        // ohne Bremse
        sMLFB11 = "0";
      }
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, sMLFB11);
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB12 Schutzart
    // --------------------------------------------------------------------------------------------------------
    /* VT_5
        MLFB12_1FK2	PMD_ABJ176_001_000_1FK2
            0		Z0011		IP64		auch ALT-Wellenabmaße
            1		Z0023		IP65		nur STD-Wellenabmaße
            2		Z0008		IP67		nur STD-Wellenabmaße
        VT_138
        VT_1FK2_M00138
        MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
        
        */
    var sMLFB12 = strMLFB.charAt(11);

    if (strBaseTypeMLFB.charAt(11) == ".") {
      sMLFB12 = check_Schutzart(strBaseTypeMLFB, sMLFB12);
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB13 Wellenende, Passfeder
    // --------------------------------------------------------------------------------------------------------
    var sMLFB13 = strMLFB.charAt(12);
    var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

    // Wellenende vorgegeben durch Getriebeanbau???
    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");

    if ((strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) || HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
      // nur glatte Welle, aber je nach AH und Getriebegröße ALT und STD-Wellenabmaße (MLFB13 = 0 und 2)
      // VT 107
      sMLFB13 = getMLFB13(strBaseTypeMLFB, aComponents, sMLFB13);
      if (sMLFB13 == "ERROR") {
        oParsing.strError = "ERRORMSG_MLFB_1FT2___ERROR_DETERMINING_MLFB13";
        sMLFB13 = "0";
      }
      /*
      if (sMLFB13 == "1"){
        sMLFB13 = "0";
      }*/
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
    } else if (sBT_MLFB13 == ".") {
      // Wellenende prüfen: bei "2" nur IP64
      sMLFB13 = checkMLFB13(strBaseTypeMLFB, sMLFB13);

      sMLFB13 = getMLFB13(strBaseTypeMLFB, aComponents, sMLFB13);
      if (sMLFB13 == "ERROR") {
        oParsing.strError = "ERRORMSG_MLFB_1FT2___ERROR_DETERMINING_MLFB13";
        sMLFB13 = "0";
      }

      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB14: Geber
    // --------------------------------------------------------------------------------------------------------
    var sMLFB14 = strMLFB.charAt(13);
    var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

    if (sBT_MLFB14 == ".") {
      // Wert aus MLFB übernehmen
      // Check Geber
      sMLFB14 = get_MLFB14_default(strBaseTypeMLFB_fix, sMLFB13, sMLFB14);
      if (sMLFB14 != "ERROR") {
        // setzen
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
      } else {
        // nicht zulässig, default setzen "S"
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "S");
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB15 Anschlusstechnik
    // --------------------------------------------------------------------------------------------------------
    // MLFB15	. Anschlusstechnik	A, B	==> PMD_AAA759_001_000_1FK2		00003, 00004
    /* abhängig vom Umrichter 
        A	00003 	OCC für S210
        B	00004	Zweikabel für S120
        
        VT73 gegen Rumpf
        
        */
    var sMLFB15 = strMLFB.charAt(14);
    var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

    if (sBT_MLFB15 == ".") {
      // Check, wenn OK, Übernahme aus MLFB
      var bCheck = checkMLFB15(strBaseTypeMLFB_fix, sMLFB15);
      if (bCheck) {
        // setzen
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
      } else {
        // Setze Default: //MLFB15
        var strInstallation = ECL_GetValue("ECSI_CX_Installation");
        if (strInstallation == "3") {
          sMLFB15 = "B"; // Zweikabel für S120
        } else {
          sMLFB15 = "A"; // OCC für S210
        }
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
      }
    }

    // -----------------------------------------------------------------------------------------------

    // --------------------------------------------------------------------------------------------------------
    // MLFB16 immer 0
    // --------------------------------------------------------------------------------------------------------
    // MLFB16
    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, "0");

    // -----------------------------------------------------------------------------------------------
    // Zuweisen der neuen MLFB und KAG-Liste
    strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

    oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
    oParsing.strFullMLFB = strMLFB;
    aComponents[0] = oParsing.strBaseMLFB;
    oParsing.aTokens = aComponents;
    ECL_SetValue("ECSI_MLFB", strMLFB);
  }
  // -- END EDIT KEEP CONF --
  // Wildcards definieren, wenn kein Keep Configuration
  else {
    if (find(strMLFB.left(16), ".") >= 0) {
      //Unvollständige SIZER MLFB

      // Prüfen, ob '.' an Stelle 1 bis 10, dann Fehler
      for (var i = 0; i < 10; i++) {
        if (strMLFB.charAt(i) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1FT2___INCOMPLETE_MLFB";
          return oParsing;
        }
      }
      // Wenn MLFB11-15 ein Wildcard, dann Default setzen

      // --------------------------------------------------------------------------------
      // MLFB11 Haltebremse
      // --------------------------------------------------------------------------------
      var sMLFB11 = strMLFB.charAt(10);
      var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired") || "";

      if (sMLFB11 == ".") {
        sMLFB11 = "0";

        if (strwithBrake == "1") {
          // mit Bremse
          sMLFB11 = "1";
        }
        strMLFB = replaceAt(strMLFB, 10, sMLFB11);
      } else {
        if (strwithBrake == "1" && sMLFB11 == "0") {
          oParsing.strError = "ERRORMSG_MLFB_1FT2___BRAKE_CX_MLFB";
          return oParsing;
        }
      }

      // --------------------------------------------------------------------------------
      // MLFB12 Schutzart Default 0
      // --------------------------------------------------------------------------------
      if (strMLFB.charAt(11) == ".") {
        //MLFB12 Schutzart Default 0
        // Setze Default:
        strMLFB = replaceAt(strMLFB, 11, "0");
      }

      // --------------------------------------------------------------------------------
      // MLFB13 Wellengeometrie
      // --------------------------------------------------------------------------------
      if (strMLFB.charAt(12) == ".") {
        /*
                0	glatte Welle 	Z0002 	STD		Default		passt auch für Getriebekopplung
                1	Passfeder		Z0004	STD
                2	glatte Welle	Z0002	ALT		auch für Getriebekopplung, nur IP64

                ob 0 oder 2 muss bestimmt werden
                */
        var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");

        if (
          (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) || HMK_TARGET_TRIGGER_1FK2 == "GMOT") {
          var sMLFB13 = getMLFB13(strMLFB, aComponents, sMLFB13);
          if (sMLFB13 == "ERROR" || sMLFB13 == undefined) {
            oParsing.strError = "ERRORMSG_MLFB_1FT2___ERROR_DETERMINING_MLFB13";
            sMLFB13 = "0";
          }
        } else {
          var sMLFB13 = "0";
        }
        strMLFB = replaceAt(strMLFB, 12, sMLFB13);
      }

      // --------------------------------------------------------------------------------
      // MLFB14: Geber	{S, M, B, C}
      // --------------------------------------------------------------------------------
      if (strMLFB.charAt(13) == ".") {
        //MLFB14 Geber Default S
        var sMLFB14 = "S";
        /*
                MLFB14	Geber
                S		00024	Default
                M		00025
                B		00026		EDIT erst ab Mai 2021
                C		00027		EDIT erst ab Mai 2021
                */
        // Prüfen, welcher Geber als Default verwendet werden kann (VT140)
        var sMLFB14 = get_MLFB14_default(strMLFB_fix, sMLFB13, sMLFB14); // strMLFB_fix = MLFB_RUMPF_01_10_1FK2
        if (sMLFB14 != "ERROR") {
          strMLFB = replaceAt(strMLFB, 13, sMLFB14);
        } else {
          strMLFB = replaceAt(strMLFB, 13, "S");
        }
      }

      // --------------------------------------------------------------------------------
      // MLFB15: Anschlusstechnik
      // --------------------------------------------------------------------------------
      if (strMLFB.charAt(14) == ".") {
        // abhängig von Kontext

        var strInstallation = ECL_GetValue("ECSI_CX_Installation");
        if (strInstallation == "3") {
          var sMLFB15 = "B"; // Zweikabel für S120
          var bCheckMLFB15 = checkMLFB15(strMLFB_fix, sMLFB15);
          if (bCheckMLFB15) {
            sMLFB15 = "B";
          } else {
            oParsing.strError =
              "ERRORMSG_MLFB_1FT2___MLFB15_VOLTAGE_NOT_SUPPORTED";
          }
        } else {
          var sMLFB15 = "A"; // OCC für S210
        }

        strMLFB = replaceAt(strMLFB, 14, sMLFB15);
      }
      // --------------------------------------------------------------------------------------------------------
      // MLFB16 immer 0
      // --------------------------------------------------------------------------------------------------------
      // MLFB16
      strMLFB = replaceAt(strMLFB, 15, "0");
      // --------------------------------------------------------------------------------------------------------

      ECL_SetValue("ECSI_MLFB", strMLFB);

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
      //oParsing.aTokens = aComponents;
    } else {
      // MLFB vollständig definiert, aber Kontexte berücksichtigen
      // Bremsenkontext prüfen
      var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
      if (
        (strwithBrake == "1" && strMLFB.charAt(10) == "0") ||
        (strwithBrake == "0" && strMLFB.charAt(10) !== "0")
      ) {
        oParsing.strError = "ERRORMSG_MLFB_1FT2___BRAKE_CX_MLFB";
        return oParsing;
      }

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
    }
  }
  // END EDIT KEEP CONF

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_1FT2___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (
    oParsing.strBaseMLFB.indexOf("1FT2") < 0 &&
    oParsing.strBaseMLFB.indexOf("1FK2") < 0
  ) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_1FT2___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var oResult;
  oResult = parse_1FT2(oParsing.aTokens);

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;
    var bSetAttributes = set_MLFB_Attributes(oResult);

    oParsing.GearboxMotorCoupling = parseInt(
      ECL_GetValue("ECSI_CX_GearboxMotorCoupling")
    ); // 0,1
    var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
    if (ECSI_CX_IsDriveTrain !== 1) {
      ECSI_CX_IsDriveTrain = 0;
    }
    oParsing.IsDriveTrain = ECSI_CX_IsDriveTrain; // 1/0 "true"/"false"
  }

  vtTimeStop = Date.getTime();
  vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_1FT2(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };
  /*
    MLFB-Schema
    
    MLFB01	1FT2
    MLFB05	Trägheit (Motortyp)	
    MLFB06	Achshöhe 1	
    MLFB07	Achshöhe 2 
    MLFB08	Baulänge 
    MLFB09	A (reserviert)
    MLFB10	Wicklung/Bemessungsdrehzahl (B, C, F, G, K)	+ H + E
    MLFB11	. Bremse (0: ohne, 1: mit)
    MLFB12	. Schutzart
    MLFB13	. Wellenende, Passfeder
    MLFB14	. Geber 
    MLFB15	. Anschlusstechnik	
    MLFB16	0 (reserviert) 
    */
  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  oResult.oParsingData.MLFB.POS1 = strBaseMLFB.substring(0, 4); // 01 1FT2
  oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt(4); // 05 Trägheitsmoment
  oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt(5); // 06 Achshöhe 1
  oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt(6); // 07 Achshöhe 2
  oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt(7); // 08 Baulänge
  oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt(8); // 09 A (nicht definiert)
  oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9); // 10 Wicklung
  oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt(10); // 11 . Haltebremse
  oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt(11); // 12 . Schutzart IP
  oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt(12); // 13 . Wellenende
  oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); // 14 . Geber
  oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); // 15 . Anschlusstechnik
  oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); // 16 0 Version

  oResult.oParsingData.RUMPF = strBaseMLFB.substring(0, 10); // = MLFB_RUMPF_01_10_1FK2

  //oResult.oParsingData.AH = "0"; // todo
  // ################################################################################################################
  // VT_219 - ZO MLFB-Rumpf+1FK/T2
  // ################################################################################################################
  /*
   RESTRICTIONS: TABLE VT_1FK2_M00219 (
    MLFB01_1FK2
    MLFB05_1FK2
    MLFB06_1FK2
    MLFB07_1FK2
    MLFB08_1FK2
    MLFB09_1FK2
    MLFB10_1FK2
    MLFB_RUMPF_01_10_1FK2
    HMK_KEY_MOTOR_1FK2
    HMK_VALUE_VALID_1FK2)
    *
    INFERENCES:
      c.MLFB01_1FK2 ,
      c.MLFB05_1FK2 ,
      c.MLFB06_1FK2 ,
      c.MLFB07_1FK2 ,
      c.MLFB08_1FK2 ,
      c.MLFB09_1FK2 ,
      c.MLFB10_1FK2 ,
      c.MLFB_RUMPF_01_10_1FK2,
    HMK_KEY_MOTOR_1FK2
    * /
    simpleInference.restrictAttributes("EXTERNAL_DATA", "VT_1FK2_M00219" + sDB_Suffix,{
        inferenceType: VariantTables.Inference.RestrictNone,
        operators: {
            "MLFB_RUMPF_01_10_1FK2": {
            inferenceType: VariantTables.Inference.RestrictAll
            }
        }
    });
    var MLFB_RUMPF_01_10_1FK2 = ECL_GetValue("MLFB_RUMPF_01_10_1FK2");
    */
  // Prüfen, ob Rumpf-MLFB in DB abgebildet:
  var sTable = "VT_1FK2_M00219" + sDB_Suffix;

  var sSQL =
    "SELECT MLFB_RUMPF_01_10_1FK2, HMK_KEY_MOTOR_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    oResult.oParsingData.RUMPF +
    "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_KEY_MOTOR_1FK2 = aResult[0].HMK_KEY_MOTOR_1FK2;
    ECL_SetValue("HMK_KEY_MOTOR_1FK2", HMK_KEY_MOTOR_1FK2);
    oResult.oParsingData.HMK_KEY_MOTOR_1FK2 = HMK_KEY_MOTOR_1FK2;
  } else {
    oResult.strError = "ERRORMSG_MLFB_1FT2___PARSE_WRONG_MLFB";
  }
  // ################################################################################################################

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens || [];

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

function set_MLFB_Attributes(oResult) {
  ECL_SetValue("MLFB01_1FK2", oResult.oParsingData.MLFB.POS1); // 01 1FT2
  ECL_SetValue("MLFB05_1FK2", oResult.oParsingData.MLFB.POS5); // 05 Trägheitsmoment
  ECL_SetValue("MLFB06_1FK2", oResult.oParsingData.MLFB.POS6); // 06 Achshöhe 1
  ECL_SetValue("MLFB07_1FK2", oResult.oParsingData.MLFB.POS7); // 07 Achshöhe 2
  ECL_SetValue("MLFB08_1FK2", oResult.oParsingData.MLFB.POS8); // 08 Baulänge
  ECL_SetValue("MLFB09_1FK2", oResult.oParsingData.MLFB.POS9); // 09 A (nicht definiert)
  ECL_SetValue("MLFB10_1FK2", oResult.oParsingData.MLFB.POS10); // 10 Wicklung
  ECL_SetValue("MLFB11_1FK2", oResult.oParsingData.MLFB.POS11); // 11 . Haltebremse
  ECL_SetValue("MLFB12_1FK2", oResult.oParsingData.MLFB.POS12); // 12 . Schutzart IP
  ECL_SetValue("MLFB13_1FK2", oResult.oParsingData.MLFB.POS13); // 13 . Wellenende
  ECL_SetValue("MLFB14_1FK2", oResult.oParsingData.MLFB.POS14); // 14 . Geber
  ECL_SetValue("MLFB15_1FK2", oResult.oParsingData.MLFB.POS15); // 15 . Anschlusstechnik
  ECL_SetValue("MLFB16_1FK2", oResult.oParsingData.MLFB.POS16); // 16 0 Version

  ECL_SetValue("MLFB_RUMPF_01_10_1FK2", oResult.oParsingData.RUMPF); // = MLFB_RUMPF_01_10_1FK2

  return 1;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
  // O_Y84_1FK2	+ O_Y84_TXT_1FK2
  if (find(oParse.strFullMLFB, "Y84") >= 0) {
    if (oParse.oFreetext["Y84"])
      SetFreetextValue("O_Y84_TXT_1FK2", oParse.oFreetext["Y84"]);
  }
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}
// ###############################################################################################################
// Prüfroutinen
// ###############################################################################################################
function check_Schutzart(strBaseTypeMLFB, sMLFB12) {
  var bGearboxMotorCoupling = false;
  var bIsDriveTrain = false;

  var ECSI_CX_GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling"));
  if (ECSI_CX_GearboxMotorCoupling == 1) {
    bGearboxMotorCoupling = true;
  }
  var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
  if (ECSI_CX_IsDriveTrain == 1) {
    bIsDriveTrain = true;
  }

  var MLFB01_1FK2 = strBaseTypeMLFB.substring(0, 4);
  var MLFB06_1FK2 = strBaseTypeMLFB.charAt(5);
  var MLFB07_1FK2 = strBaseTypeMLFB.charAt(6);

  // bei Adapteranbau oder (DriveTrain und AH30,40) nur IP64 (MLFB07 = 0)
  if ((bIsDriveTrain && (MLFB07_1FK2 == "3" || MLFB07_1FK2 == "4")) ||
    (MLFB01_1FK2 == "1FK2" && bGearboxMotorCoupling)) {
    return 0;
  }

  // VT_1FK2_M00138
  // MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2

  var sTable = "VT_1FK2_M00138" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB12_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB01_1FK2 = '" +
    MLFB01_1FK2 +
    "' AND " +
    "MLFB06_1FK2 = '" +
    MLFB06_1FK2 +
    "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = 'MOT' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T' AND " +
    "MLFB12_1FK2 = '" +
    sMLFB12 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB12;
  } else {
    return "0";
  }
}

function getMLFB13(strBaseMLFB, aComponents, sMLFB13) {
  // Depending on the AH and gearbox, the alternative shaft end may have to be selected.
  var MLFB05_1FK2 = strBaseMLFB.charAt(4);
  var MLFB06_1FK2 = strBaseMLFB.charAt(5);
  var MLFB07_1FK2 = strBaseMLFB.charAt(6);
  // only, if AH 30 or 40 and gearbox selected
  var sTable = "VT_1FK2_M00083" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT PMD_ACH516_001_000_1FK2 FROM " + sTable + " WHERE " +
    "MLFB05_1FK2 = '" + MLFB05_1FK2 + "' AND " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB07_1FK2 = '" + MLFB07_1FK2 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_ACH516_001_000_1FK2 = aResult[0].PMD_ACH516_001_000_1FK2;
  } else {
    return "ERROR";
  }

  if (PMD_ACH516_001_000_1FK2 != 30 && PMD_ACH516_001_000_1FK2 != 40) {
    return sMLFB13;
  }

  if (aComponents.length > 0) {
    if (aComponents[0] === strBaseMLFB) {
      aComponents = removeElementsFromArray(aComponents, 0, 1);
    }
  }
  var aKAG = aComponents || [];

  var sKAG_LIST = getKAGAsList(aComponents);

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var O_A11_C42_1FK2 = getKAGforAttribute("O_A11_C42_1FK2", aKAG);
  //var aValues = ["A11", "A12", "A13", "A21", "A22", "A23", "A31", "A32", "A33", "B11",
  //  "B12", "B21", "B22", "B31", "B32", "B21", "B22", "C31", "C32",];

  if (O_A11_C42_1FK2 !== "NON") {
    var sTable = "VT_1FK2_M00097" + sDB_Suffix;

    var sSQL = "SELECT DISTINCT PMD_ABV410_001_000_1FK2 FROM " + sTable + " WHERE " +
      "O_A11_C42_1FK2 = '" + O_A11_C42_1FK2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var PMD_ABV410_001_000_1FK2 = aResult[0].PMD_ABV410_001_000_1FK2; // Bezeichnung des Getriebes

      if (PMD_ABV410_001_000_1FK2 != "NON") {
        var sTable = "VT_1FK2_M00091" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
          "PMD_ABV410_001_000_1FK2 = '" + PMD_ABV410_001_000_1FK2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
          var UI_GETRIEBE_TYP_1FK2 = aResult[0].UI_GETRIEBE_TYP_1FK2; // Getriebetyp
          var UI_GETRIEBE_SIZE_1FK2 = aResult[0].UI_GETRIEBE_SIZE_1FK2; // Getriebegröße

          var sTable = "VT_1FK2_M00107" + sDB_Suffix;
          var sSQL = "SELECT DISTINCT HMK_WELLENAUSF_1FK2 FROM " + sTable + " WHERE " +
            "PMD_ACH516_001_000_1FK2 = '" + PMD_ACH516_001_000_1FK2 + "' AND " +
            "UI_GETRIEBE_SIZE_1FK2 = '" + UI_GETRIEBE_SIZE_1FK2 + "';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length == 1) {
            var HMK_WELLENAUSF_1FK2 = aResult[0].HMK_WELLENAUSF_1FK2;

            if (HMK_WELLENAUSF_1FK2 == "ALT") {
              sMLFB13 = "2";
              return sMLFB13;
            } else {
              sMLFB13 = "0";
              return sMLFB13;
            }
          } else if (aResult.length > 1) {
            if (
              aResult[0].HMK_WELLENAUSF_1FK2 == "STD" ||
              aResult[1].HMK_WELLENAUSF_1FK2 == "STD"
            ) {
              sMLFB13 = "0";
              return sMLFB13;
            } else {
              return "ERROR";
            }
          } else {
            return "ERROR";
          }
        } else {
          return "ERROR";
        }
      } else {
        return "ERROR";
      }
    } else {
      return "ERROR";
    }
  } else {
    return sMLFB13;
  }
}
function checkMLFB13(strBaseTypeMLFB, sMLFB13) {
  var bGearboxMotorCoupling = false;
  var ECSI_CX_GearboxMotorCoupling = parseInt(
    ECL_GetValue("ECSI_CX_GearboxMotorCoupling")
  );
  if (ECSI_CX_GearboxMotorCoupling == 1) {
    bGearboxMotorCoupling = true;
  }

  if (bGearboxMotorCoupling && sMLFB13 == "2") {
    return "0";
  }

  // VT_1FK2_M00138
  // MLFB01_1FK2	MLFB06_1FK2	MLFB07_1FK2	MLFB12_1FK2	MLFB13_1FK2	HMK_TARGET_TRIGGER_1FK2	PMD_AAA506_001_000_1FK2	HMK_WELLENAUSF_1FK2	HMK_VALUE_VALID_1FK2
  var MLFB01_1FK2 = strBaseTypeMLFB.substring(0, 4);
  var MLFB06_1FK2 = strBaseTypeMLFB.charAt(5);
  var MLFB12_1FK2 = strBaseTypeMLFB.charAt(11);

  var sTable = "VT_1FK2_M00138" + sDB_Suffix;

  var sSQL = "SELECT MLFB13_1FK2 FROM " + sTable + " WHERE " +
    "MLFB01_1FK2 = '" + MLFB01_1FK2 + "' AND " +
    "MLFB06_1FK2 = '" + MLFB06_1FK2 + "' AND " +
    "MLFB12_1FK2 = '" + MLFB12_1FK2 + "' AND " +
    "HMK_TARGET_TRIGGER_1FK2 = 'MOT' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T' AND " +
    "MLFB13_1FK2 = '" + sMLFB13 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB13;
  } else {
    return "0";
  }
}

function get_MLFB14_default(MLFB_RUMPF_01_10_1FK2, MLFB13_1FK2, sMLFB14) {
  //HMK_UMR_SPANNUNG_1FK2???
  // sDefault +bersetzen in PMD_ABU278_001_000_1FK2
  switch (sMLFB14) {
    case "S":
      sDefault = "00024";
      break;
    case "M":
      sDefault = "00025";
      break;
    case "B":
      sDefault = "00026";
      break;
    case "C":
      sDefault = "00027";
      break;
  }

  // Aus VT140 auslesen, ob für die Rumpf-MLFB der Default-Geber enthalten ist
  var sTable = "VT_1FK2_M00140" + sDB_Suffix;
  //MLFB13_1FK2	PMD_ABU278_001_000_1FK2	MLFB_RUMPF_01_10_1FK2	HMK_UMR_SPANNUNG_1FK2

  var sSQL =
    "SELECT PMD_ABU278_001_000_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    MLFB_RUMPF_01_10_1FK2 +
    "' AND " +
    "MLFB13_1FK2 = '" +
    MLFB13_1FK2 +
    "';"; // AND " +
  // todo	"HMK_UMR_SPANNUNG_1FK2 = '"+ HMK_UMR_SPANNUNG_1FK2 + "' AND " +
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var bOK = false;
    for (var i = 0; i < aResult.length; i++) {
      if (aResult[i].PMD_ABU278_001_000_1FK2 == sDefault) {
        bOK = true;
        break;
      }
    }

    if (bOK) {
      return sMLFB14;
    } else {
      switch (aResult[0].PMD_ABU278_001_000_1FK2) {
        case "00024":
          sMLFB14 = "S";
          break;
        case "00025":
          sMLFB14 = "M";
          break;
        case "00026":
          sMLFB14 = "B";
          break;
        case "00027":
          sMLFB14 = "C";
          break;
      }
      return sMLFB14;
    }
  }
  return "ERROR";
}
function checkMLFB15(MLFB_RUMPF_01_10_1FK2, sMLFB15) {
  var sTable = "VT_1FK2_M00073" + sDB_Suffix;
  // MLFB_RUMPF_01_10_1FK2	MLFB15_1FK2

  var sSQL =
    "SELECT MLFB15_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    MLFB_RUMPF_01_10_1FK2 +
    "' AND " +
    "MLFB15_1FK2 = '" +
    sMLFB15 +
    "';"; // AND " +

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ---------------------------------
  // PDM Attribute
  /*var sTable = "VT_1FK2_M00255" + sDB_Suffix;
  // MLFB_RUMPF_01_10_1FK2	MLFB15_1FK2

  var sSQL =
    "SELECT MLFB15_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    MLFB_RUMPF_01_10_1FK2 +
    "' AND " +
    "MLFB15_1FK2 = '" +
    sMLFB15 +
    "';"; // AND " +

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }*/
  // ---------------------------------
  // EDIT 01/2023 now it is allowed, Condition is obsolet
  // "B" not allowed for 230V / 240V
  // StandardSupplySystem
  /*	0	230V 1-phase AC, 50Hz 	
      1	230V 3-phase AC, 50Hz
      2	380V 3-phase AC, 50Hz
      3	400V 3-phase AC, 50Hz
      4	415V 3-phase AC, 50Hz
      5	500V 3-phase AC, 50Hz
      6	690V 3-phase AC, 50Hz
      7	240V 1-phase AC, 60Hz
      8	240V 3-phase AC, 60Hz
      9	380V 3-phase AC, 60Hz
      10	400V 3-phase AC, 60Hz
      11	440V 3-phase AC, 60Hz
      12	460V 3-phase AC, 60Hz
      13	480V 3-phase AC, 60Hz
      14	600V 3-phase AC, 60Hz
      15	690V 3-phase AC, 60Hz
    * /
  if (sMLFB15 == "B"){
    var StandardSupplySystem = parseInt(ECL_GetValue("ECSI_CX_StandardSupplySystem")) || 0;
    if (StandardSupplySystem < 2 || StandardSupplySystem == 7 || StandardSupplySystem == 8){
      return 0;
    }
  }*/
  // ---------------------------------
  return 1;
}

function getValidMLFB11_1FT2(strBaseTypeMLFB_fix, sMLFB11) {
  var sTable = "VT_1FK2_M00188" + sDB_Suffix;
  // MLFB_RUMPF_01_10_1FK2	MLFB11_1FK2	HMK_VALUE_VALID_1FK2

  var sSQL =
    "SELECT DISTINCT MLFB11_1FK2 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FK2 = '" +
    strBaseTypeMLFB_fix +
    "' AND " +
    "MLFB11_1FK2 = '" +
    sMLFB11 +
    "' AND " +
    "HMK_VALUE_VALID_1FK2 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB11;
  } else {
    if (sMLFB11 == "2") {
      //  check, if standard is possible
      var sSQL =
        "SELECT DISTINCT MLFB11_1FK2 FROM " +
        sTable +
        " WHERE " +
        "MLFB_RUMPF_01_10_1FK2 = '" +
        strBaseTypeMLFB_fix +
        "' AND " +
        "MLFB11_1FK2 = '1' AND " +
        "HMK_VALUE_VALID_1FK2 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        return "1";
      }
    }
  }
  return "0";
}
