//@legacy
//#mode(full-ecma)




// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################

// ECSI_CC_AdditionalInertia

// IpProtectionLevelMotor

// ECSI_CC_BrakeID

// GearboxOil
/*
1	CLP-ISO-VG220		K06
2	CLP-ISO-PAO-VG220	
3	CLP-ISO-PAO-VG68
4	CLP-ISO-PAO-VG460
5	CLP-ISO-PG-VG460	K08
6	CLP-ISO-PG-VG220	K07
7	CLP-ISO-H1-VG460	K11
8	CLP-ISO-H1-VG100
9	CLP-ISO-E-VG220
 
O_K06_K07_K08_K11_1FG1S
 
K06	Mineralöl CLP ISO VG220
K07	Polyglycol Öl CLP ISO PG VG220
K08	Polyglycol Öl CLP ISO PG VG460
K11	Lebensmittelöl CLP ISO H1 VG460
 
//	ECSI_CC_GearboxOil
* /
var sOelSorte = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");
var ECSI_CC_GearboxOil = "";
switch(sOelSorte){
    case "K06":
        ECSI_CC_GearboxOil = "1";
    break;
    case "K07":
        ECSI_CC_GearboxOil = "6";
    break;
    case "K08":
        ECSI_CC_GearboxOil = "5";
    break;
    case "K11":
        ECSI_CC_GearboxOil = "7";
    break;
    default:
        ECSI_CC_GearboxOil = "";
}
 
ECL_SetValue("ECSI_CC_GearboxOil", ECSI_CC_GearboxOil);
 
// OutputShaftLength
/*
Double [mm]		Length of the output shaft in mm
*/

// GearboxOutputShaftType
/*
V	Solid output shaft. Shaft type: V & VG
P	"Solid output shaft in combination with 
    mounting type flange (forward positioned bearing).
    Shaft type: V & VG"
W	"Solid output shaft with two shaft ends.
    Shaft type: VD"
H	"Hollow output shaft.
    Shaft type: H, HF, HS, HX & N"
U	"Mixer hollow output shaft (bearing VLplus).
    Shaft type: HM"
M	"Mixer solid output shaft (bearing VLplus).
    Shaft type: VM"
R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
    Shaft type: VR  "
C	"Cooling tower solid output shaft i2 ≠ l.
    Shaft type: VC"

*/

// GearboxOutputShaftDiameter	Double [mm]	Diameter of the output shaft in mm

// GearboxMountingType
/*
F	Foot-mounted 
B	Foot/flange-mounted
P	Flange-mounted i2=l
Z	Housing flange 
D	Mounted with torque support 
 
*/

// GearboxReinforcedBearing
/*
0	Standard bearing of output shaft
1	Reinforced bearing of output shaft
2	XLPlus
3	VLPlus
*/

// SelectedGearboxAdapterID ????


function determineConsequences(sECSI_MLFB) {
    var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    var strErr = "";

    var aShaftParams = getOutputShaft();
    if (aShaftParams == "ERROR") {
        strErr = "ERR: ShaftParams";
    }
    /*
        [GearboxOutputShaftType, 
         GearboxOutputShaftDiameter,
         OutputShaftLength];
    */

    var oConsequences = {
        AdditionalInertia: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor: getIpProtectionLevelMotor(),
        //SensorModule				: getSensorModule(),
        //GearboxOil					: getGearboxOil(),
        OutputShaftLength: aShaftParams[2],
        GearboxOutputShaftType: aShaftParams[0],
        GearboxOutputShaftDiameter: aShaftParams[1],
        GearboxMountingType: "P",
        BrakeID: getBrakeID(sECSI_MLFB),
        GearboxReinforcedBearing: getGearboxReinforcedBearing(),
        Error_Message: strErr
    }

    return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
    var dRet = 0;
    if (operator == 'min')
        dRet = 99999;

    var aOrigins = Object.fromDatabase("1FT7_ADD_DATA", "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' ") || [];

    for (var i = 0; i < aOrigins.length; i++) {
        var resval = determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, aOrigins[i].ORIGIN);
        if (resval != -99999) {
            if ((operator == 'min') && (resval < dRet))
                dRet = resval;
            else if ((operator == 'max') && (resval > dRet))
                dRet = resval;
            else if (operator == 'sum')
                dRet += resval;
        }
    }
    var strRet = '';
    if ((dRet != 0) && (dRet != 99999))
        strRet = '' + dRet;	// als String zurückliefern
    return strRet;
}

function determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, origin) {
    var aResult = Object.fromDatabase("1FT7_ADD_DATA", "select * from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");

    for (var i = 0; i < aResult.length; i++) {
        var mlfbPattern = aResult[i]['PATTERN'];
        var dbKAG = aResult[i]['OPTION'];
        var origin = aResult[i]['ORIGIN'];			// für jeden Origin nur max. einen Wert bestimmen
        var resval = aResult[i]['RES_VALUE'] - 0;	// Wert als Zahl bestimmen

        var matchP = true;
        if (mlfbPattern) {
            if (!EK_regFound(baseMLFB, mlfbPattern))
                matchP = false;
        }
        var matchK = true;
        if (dbKAG) {
            if (find(ka, dbKAG) < 0)
                matchK = false;
        }
        if (matchP && matchK) {
            return resval;
        }
    }
    return -99999;
}


/*
********************************************************
* Merkmal Trägheitsmoment
********************************************************

* wenn keine Bremse gewählt
$self.HMK_TRAEGHEITSMOMENT_1FT7M= $root.PMD_AAB904_001_000_1001920
IF $root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.PMD_AAB904_001_000_1001920 SPECIFIED,

* wenn keine Bremse und Getriebe gewählt und (MLB05 = 04)
$self.HMK_TRAEGHEITSMOMENT_1FT7M =
$root.PMD_AAB904_001_000_1001920 +
$root.HMK_GETRIEB_TRAEG_04_1FT7M IF (
$root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.HMK_OPT_GETRIEBE_1FT7M = 'T' AND
$root.MLFB05_1FT7M = '04'),

* wenn keine Bremse und Getriebe gewählt und (MLB05 = 06)
$self.HMK_TRAEGHEITSMOMENT_1FT7M =
$root.PMD_AAB904_001_000_1001920 +
$root.HMK_GETRIEB_TRAEG_06_1FT7M IF (
$root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.HMK_OPT_GETRIEBE_1FT7M = 'T' AND
$root.MLFB05_1FT7M = '06'),

* wenn keine Bremse und Getriebe gewählt und (MLB05 = 08)
$self.HMK_TRAEGHEITSMOMENT_1FT7M =
$root.PMD_AAB904_001_000_1001920 +
$root.HMK_GETRIEB_TRAEG_08_1FT7M IF (
$root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.HMK_OPT_GETRIEBE_1FT7M = 'T' AND
$root.MLFB05_1FT7M = '08'),

* wenn keine Bremse und Getriebe gewählt und (MLB05 = 10)
$self.HMK_TRAEGHEITSMOMENT_1FT7M =
$root.PMD_AAB904_001_000_1001920 +
$root.HMK_GETRIEB_TRAEG_10_1FT7M IF (
$root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.HMK_OPT_GETRIEBE_1FT7M = 'T' AND
$root.MLFB05_1FT7M = '10'),

* wenn keine Bremse und Getriebe gewählt und (MLB05 = 13)
$self.HMK_TRAEGHEITSMOMENT_1FT7M =
$root.PMD_AAB904_001_000_1001920 +
$root.HMK_GETRIEB_TRAEG_13_1FT7M IF (
$root.PMD_ABU276_001_000_1FT7M = 'F' AND
$root.HMK_OPT_GETRIEBE_1FT7M = 'T' AND
$root.MLFB05_1FT7M = '13'),

********************************************************
* setzen Merkmal Trägheitsmoment des Getriebes
********************************************************
* wenn MLFB05 = '03'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_03_1FT7M IF
$root.MLFB05_1FT7M = '03',
*
* wenn MLFB05 = '04'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_04_1FT7M IF
$root.MLFB05_1FT7M = '04',
*
* wenn MLFB05 = '06'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_06_1FT7M IF
$root.MLFB05_1FT7M = '06',
*
* wenn MLFB05 = '08'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_08_1FT7M IF
$root.MLFB05_1FT7M = '08',
*
* wenn MLFB05 = '10'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_10_1FT7M IF
$root.MLFB05_1FT7M = '10',
*
* wenn MLFB05 = '13'
$self.PMD_ABW817_001_000_1FT7M =
$root.HMK_GETRIEB_TRAEG_13_1FT7M IF
$root.MLFB05_1FT7M = '13'

*/
function getAdditionalInertia(sECSI_MLFB) {
    // Keine Trägheitsmomente für Bremse, da dies der SIZER selbst addiert!!!

    // HMK_TRAEGHEITSMOMENT_1FT7M	Trägheitsmoment des Rotors
    // PMD_ABW817_001_000_1FT7M		Trägheitsmoment.../Getriebes
    // PMD_AAB904_001_000_1001920	Trägheitsmoment / des Läufers

    var AdditionalInertia = 0;
    return AdditionalInertia;
}

function getIpProtectionLevelMotor() {
    // PMD_ABJ176_001_000_1FT7M  	Schutzart
    var IpProtectionLevelMotor = "";
    /*
    Z0011	IP64
    Z0023	IP65
    Z0008	IP67
    */
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");

    switch (PMD_ABJ176_001_000_1FT7M) {
        case "Z0011":
            IpProtectionLevelMotor = "64";
            break;

        case "Z0023":
            IpProtectionLevelMotor = "65";
            break;

        case "Z0008":
            IpProtectionLevelMotor = "67";
            break;
    }
    return IpProtectionLevelMotor;
}


//	GearboxOutputShaftType
//	OutputShaftLength
//	GearboxOutputShaftDiameter
function getOutputShaft() {
    /* GearboxOutputShaftType
    V	Solid output shaft. Shaft type: V & VG
-->	P	"Solid output shaft in combination with 
        mounting type flange (forward positioned bearing).
        Shaft type: V & VG"
    W	"Solid output shaft with two shaft ends.
        Shaft type: VD"
    H	"Hollow output shaft.
        Shaft type: H, HF, HS, HX & N"
    U	"Mixer hollow output shaft (bearing VLplus).
        Shaft type: HM"
    M	"Mixer solid output shaft (bearing VLplus).
        Shaft type: VM"
    R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
        Shaft type: VR  "
    C	"Cooling tower solid output shaft i2 ≠ l.
        Shaft type: VC"
    */

    var GearboxOutputShaftType = "P";

    var HMK_AUFBAU_WELLE_1FT7M = ECL_GetValue("HMK_AUFBAU_WELLE_1FT7M");
    var sD = "";
    var sL = "";

    var HMK_KONFIG_ZIEL_1FT7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FT7M");

    if (HMK_KONFIG_ZIEL_1FT7M == "SERVO") {

        //UI_WELLENMASZ_1FK7M	Wellenende D x Länge
        /*
        00003	Ø 14 mm x 30 mm
        00004	Ø 19 mm x 40 mm
        00005	Ø 24 mm x 50 mm
        00006	Ø 32 mm x 58 mm
        00007	Ø 38 mm x 80 mm
        00008	Ø 11 mm x 32 mm
        00009	Ø 48 mm x 82 mm
        */
        var HMK_AUFBAU_WELLE_1FT7M = ECL_GetValue("HMK_AUFBAU_WELLE_1FT7M");
        var sD = "";
        var sL = "";
        switch (HMK_AUFBAU_WELLE_1FT7M) {
            case "00003":
                sD = "14";
                sL = "30";
                break;
            case "00004":
                sD = "19";
                sL = "40";
                break;
            case "00005":
                sD = "24";
                sL = "50";
                break;
            case "00006":
                sD = "32";
                sL = "58";
                break;
            case "00007":
                sD = "38";
                sL = "80";
                break;
            case "00008":
                sD = "11";
                sL = "32";
                break;
            case "00009":
                sD = "48";
                sL = "82";
                break;
        }
    } else {
        // Planetengetriebe

        var PMD_ABV410_001_000_1FT7M = ECL_GetValue("PMD_ABV410_001_000_1FT7M");

        if (PMD_ABV410_001_000_1FT7M != "KEING") {

            var sTable = "VT_1FT7M_M00107" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "PMD_ABV410_001_000_1FT7M = '" + PMD_ABV410_001_000_1FT7M + "';";

            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PL");
            if (aResult.length > 0) {
                // HMK_ACB769_1FT7M	Durchmesser der Welle (D2)
                sD = aResult[0].HMK_ACB769_1FT7M;
                // HMK_ACB783_1FT7M	Länge der Welle (L)
                sL = aResult[0].HMK_ACB783_1FT7M;
            }
        }
    }

    var GearboxOutputShaftDiameter = sD;
    var OutputShaftLength = sL;

    var aConsequences = [GearboxOutputShaftType,
        GearboxOutputShaftDiameter,
        OutputShaftLength];

    return aConsequences;
}



function getBrakeID(sECSI_MLFB) {
    /**
    //Bremsen Consequences
    */
    var sBrakeID = "";
    var PMD_ABU276_001_000_1FT7M = ECL_GetValue("PMD_ABU276_001_000_1FT7M"); // T, F
    /*	
    HMK_OPT_N27_1FT7M	Haltebremse mit reduziertem Trägheitsmoment N27, F
    */

    if (PMD_ABU276_001_000_1FT7M == "T") {


        var HMK_OPT_N27_1FT7M = ECL_GetValue("HMK_OPT_N27_1FT7M");
        // #NO_DATA#	N27
        var sBrakeIDpattern = sECSI_MLFB.left(6);
        var SZ_MBC_M_OrderNumber = sBrakeIDpattern + "????????{B;E;H;L}?";

        var SZ_MBC_M_ShortOptions = "#NO_DATA#";
        if (HMK_OPT_N27_1FT7M == "N27") {
            var SZ_MBC_M_ShortOptions = "N27";
        }
        // edit 20220214
        var aResult = Object.fromDatabase("1FT7_ADD_DATA", "select * from BrakeID where " +
            "SZ_MBC_M_OrderNumber = '" + SZ_MBC_M_OrderNumber + "' AND " +
            "SZ_MBC_M_ShortOptions = '" + SZ_MBC_M_ShortOptions + "'");

        if (aResult.length > 0) {
            sBrakeID = aResult[0].SZ_MBC_BRAKEID;
        } else {
            return "ERROR";
        }


    }
    else {
        sBrakeID = "";
    }

    return sBrakeID;
}

function getGearboxReinforcedBearing() {
    // GearboxReinforcedBearing
    /*
    0	Standard bearing of output shaft
    1	Reinforced bearing of output shaft
    2	XLPlus
    3	VLPlus
    */
    //HMK_OPT_K20_1FT7M	Verstärkte Lagerung	K20, F
    var GearboxReinforcedBearing = "0";
    var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");

    if (HMK_OPT_K20_1FT7M == "K20") {
        GearboxReinforcedBearing = "1";
    }
    return GearboxReinforcedBearing;
}