//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


function SetFarbe_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Farbausfuehrung(oData); 	// Ausführung (Farbe)	HMK_AUSFUEHR_K23_K24_1FT7M + Bestimmung Farbe PMD_AAD756_001_000_1FT7M
    } else {
        ExecSetStandardifValueEmpty("HMK_AUSFUEHR_K23_K24_1FT7M","00001");
        ExecSetStandardifValueEmpty("PMD_AAD756_001_000_1FT7M","00001");
    }
}

function SetFarbe(strchangedAttribute, oData)
{
}

/**
    
*/
function Bestimme_Farbausfuehrung(oData)
{
    var parseObj = oData.oParsingData;
    var aKAG = parseObj.MLFB.KAG || [];
    
    // HMK_AUSFUEHR_K23_K24_1FT7M
    // KAG: K23, K24, 00001
    var sTargetAttribute = "HMK_AUSFUEHR_K23_K24_1FT7M";
    
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (oData.IsDriveTrain == 1)
	{
		sKAG = "K24";
	}else{
		
		// Wenn N16
		if (aKAG.indexOf("N16") > -1){
			// nur Lackierung erlaubt, kein K23, K24
			sKAG = "00001";
		}
	}
    
    if (sKAG == "K23"){	
        
        ECL_SetValue("HMK_AUSFUEHR_K23_K24_1FT7M", sKAG);
        
        // Farbe bestimmen
        var sTargetAttributeColor = "PMD_AAD756_001_000_1FT7M";
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG_Color = getKAGforAttribute(sTargetAttributeColor, parseObj.MLFB.KAG);
        
        if (sKAG_Color == "NON"){
            sKAG_Color = "00001"; // kein STD // im dtk ist 00001 (STD) verfügbar
        }
        ECL_ActivateValue(sTargetAttributeColor, sKAG_Color);
        ECL_SetValue(sTargetAttributeColor, sKAG_Color);
    }
    
    else if (sKAG == "K24"){	
        
        ECL_SetValue("HMK_AUSFUEHR_K23_K24_1FT7M", sKAG);
        
        ECL_DeactivateAllAttributeValues("PMD_AAD756_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAD756_001_000_1FT7M", "00003");
        ECL_SetValue("PMD_AAD756_001_000_1FT7M", "00003"); // ohne
    }
    else{
        // Lackierung
        var HMK_AUSFUEHR_K23_K24_1FT7M = "00001";
        ECL_SetValue("HMK_AUSFUEHR_K23_K24_1FT7M", HMK_AUSFUEHR_K23_K24_1FT7M);
        
        // Farbe bestimmen
        var sTargetAttributeColor = "PMD_AAD756_001_000_1FT7M";
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG_Color = getKAGforAttribute(sTargetAttributeColor, parseObj.MLFB.KAG);
        
        if (sKAG_Color == "NON"){
            sKAG_Color = "00001"; //STD
        }
        ECL_ActivateValue(sTargetAttributeColor, sKAG_Color);
        ECL_SetValue(sTargetAttributeColor, sKAG_Color);
    }
    
}