//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetGeber_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Geberausfuehrung(oData); 	// Drive-CLiQ-Schnittstelle		PMD_ABU209_001_000_1FT7M
        //Bestimme_Geber(oData);				// PMD_ABU278_001_000_1FT7M	Geber
    } else {
        ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FT7M","T");
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FT7M","Z0014");
        ExecSetStandardifValueEmpty("UI_GEBER_1FT7M","OUZ");
        ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FT7M","22DQ");
    }
}

function SetGeber(strchangedAttribute, oData)
{
}

/**
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    
    Drive-CLiQ-Schnittstelle	PMD_ABU209_001_000_1FT7M
    Gebersystem					PMD_ABU278_001_000_1FT7M
    
    gegen MLFB12 prüfen: mit DRIVE CLiQ MLFB12:0,1 ohne DR. CLiQ: 4,5
    
    MLFB14 N, M: ohne DRIVER CLiQ
*/
function Bestimme_Geberausfuehrung(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB14_1FT7M = oMLFB.POS14;
    var MLFB12_1FT7M = oMLFB.POS12;
    
    if (MLFB12_1FT7M == "0" || MLFB12_1FT7M == "1"){
        var PMD_ABU209_001_000_1FT7M = "T";
    }else{
        var PMD_ABU209_001_000_1FT7M = "F";
    }
        
    // Wenn N16, N40 anderer Geber
    
    var aKAG = oMLFB.KAG || [];
    
    // HMK_OPT_CHEM_BEST_2_1FT7M - N16
    if (aKAG.indexOf("N16") > -1 && oData.IsDriveTrain != 1){
        var HMK_OPT_CHEM_BEST_2_1FT7M = "N16";
    }else{
        var HMK_OPT_CHEM_BEST_2_1FT7M = "F";
    }
    
    // HMK_OPT_CHEM_BEST_1_1FT7M - N40
    if (aKAG.indexOf("N40") > -1 && oData.IsDriveTrain != 1){
        var HMK_OPT_CHEM_BEST_1_1FT7M = "N40";
    }else{
        var HMK_OPT_CHEM_BEST_1_1FT7M = "F";
    }
    var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
                "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "PARSE_A");
    var bSolution = false;
    if (aResult.length > 0){
        bSolution = true;
    }else{
        // Geber nicht gültig, anderen Geber wählen
        var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
        // Ohne N40?
        if (HMK_OPT_CHEM_BEST_1_1FT7M == "N40"){
            //var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                        "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
                        "HMK_OPT_CHEM_BEST_1_1FT7M = 'F' AND " +
                        "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                        "HMK_VALUE_VALID_1FT7M = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
            if (aResult.length > 0){
                bSolution = true;
            }
        }
        if (!bSolution){
            // Ohne N16?
            if (HMK_OPT_CHEM_BEST_1_1FT7M == "N16"){
                //var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                            "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                            "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
                            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                            "HMK_OPT_CHEM_BEST_2_1FT7M = 'F' AND " +
                            "HMK_VALUE_VALID_1FT7M = 'T';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_C");
                if (aResult.length > 0){
                    bSolution = true;
                }
            }
        }
        if (!bSolution){
            // Ohne DRIVE-CLiQ
            if (PMD_ABU209_001_000_1FT7M == "T"){
                // var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                            "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                            "PMD_ABU209_001_000_1FT7M = 'F' AND " +
                            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                            "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                            "HMK_VALUE_VALID_1FT7M = 'T';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_D");
                if (aResult.length > 0){
                    bSolution = true;
                }
            }
        }
        if (!bSolution){
            // Ohne ALLES
            // var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                        "PMD_ABU209_001_000_1FT7M = 'F' AND " +
                        "HMK_OPT_CHEM_BEST_1_1FT7M = 'F' AND " +
                        "HMK_OPT_CHEM_BEST_2_1FT7M = 'F' AND " +
                        "HMK_VALUE_VALID_1FT7M = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_OA");
            if (aResult.length > 0){
                bSolution = true;
            }
        }
    }
    if (bSolution){
        var PMD_ABU278_001_000_1FT7M = aResult[0].PMD_ABU278_001_000_1FT7M; // Gebersystem
        
        ECL_ActivateValue("PMD_ABU278_001_000_1FT7M", PMD_ABU278_001_000_1FT7M);
        ECL_SetValue("PMD_ABU278_001_000_1FT7M", PMD_ABU278_001_000_1FT7M);
        
    }
    if (PMD_ABU278_001_000_1FT7M){
        // Geberattribute setzen
        var sTable = "VT_1FT7M_M00044" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "PMD_ABU278_001_000_1FT7M = '"+PMD_ABU278_001_000_1FT7M+"' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE_GEBER");
        if (aResult.length > 0){
            var UI_GEBER_1FT7M = aResult[0].UI_GEBER_1FT7M;
            var UI_GEBER_AUFLOESUNG_1FT7M = aResult[0].UI_GEBER_AUFLOESUNG_1FT7M;
            var PMD_ABU209_001_000_1FT7M = aResult[0].PMD_ABU209_001_000_1FT7M;
            
            ECL_ActivateValue("UI_GEBER_1FT7M", UI_GEBER_1FT7M);
            ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FT7M", UI_GEBER_AUFLOESUNG_1FT7M);
            ECL_ActivateValue("PMD_ABU209_001_000_1FT7M", PMD_ABU209_001_000_1FT7M);
            
            ECL_SetValue("UI_GEBER_1FT7M", UI_GEBER_1FT7M);
            ECL_SetValue("UI_GEBER_AUFLOESUNG_1FT7M", UI_GEBER_AUFLOESUNG_1FT7M);
            ECL_SetValue("PMD_ABU209_001_000_1FT7M", PMD_ABU209_001_000_1FT7M);
        }else{
            var stopper;
        }
    }else{
        var stopper;
    }
    
}

