//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


/*

*/

function SetGetriebe_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Getriebe(oData); 	// PMD_ABV410_001_000_1FT7M	Bezeichnung
        //Bestimme_Uebersetzung(oData);		// PMD_ABV413_001_000_1FT7M	Übersetzung
        //Bestimme_Schaltstufen(oData);		// PMD_ABV417_001_000_1FT7M	Anzahl der Schaltstufen
        //Bestimme_WellenendeGetr(oData);		// PMD_ABV414_001_000_1FT7M	Ausführung des Wellenendes an der Antriebsseite

    } else {
        ExecSetStandardifValueEmpty("PMD_ABV410_001_000_1FT7M","KEING");
        ExecSetStandardifValueEmpty("PMD_ABV413_001_000_1FT7M","0");
        ExecSetStandardifValueEmpty("PMD_ABV417_001_000_1FT7M","0");
        ExecSetStandardifValueEmpty("PMD_ABV414_001_000_1FT7M", "KEING");
        ExecSetStandardifValueEmpty("HMK_OPT_PLANETGETR_1FT7M", "NON");
    }
}

// GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    
    // Mit/Ohne Getriebe allgemein!
    /*	HMK_OPT_GETRIEBE_1FT7M
        VT_1FT7M_M00025	Verriegelung Getriebe MLFB
        VT_1FT7M_M00026	ZO Getr HMK <-> PMD MM
        VT_1FT7M_M00033	Verriegelung Getriebe Typ
        VT_1FT7M_M00036	Trigger 1FT7_P Getriebearten

    */
    // ################################################################################################################
    // Bezeichnung			PMD_ABV410_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00029	tech. Datentabelle Planetengetriebe II
    alt		VT_1FT7M_M00186	ZO Getriebemöglichkeiten
    neu: VT_1FT7M_M00029
    ALT		VT_1FT7M_M00220	tech. Datentabelle Planetengetriebe I
    NEU: 	VT_1FT7M_M00028
    alt		VT_1FT7M_M00253	1FT7M_P Getriebearten
    neu		VT_1FT7M_M00036

    * /
    
    
    // ################################################################################################################
    
        
    // ################################################################################################################
    // PMD_ABV413_001_000_1FT7M	Übersetzung
    // ################################################################################################################
    /*
    VT_1FT7M_M00027	Übersetzung Planetegetriebe  <> J** Opt
    alt		VT_1FT7M_M00186	ZO Getriebemöglichkeiten
    neu: VT_1FT7M_M00029
    
    ALT: VT_1FT7M_M00220	tech. Datentabelle Planetengetriebe I
    NEU: 	VT_1FT7M_M00028
    */
    
    // ################################################################################################################
    
    // ################################################################################################################
    // Anzahl der Schaltstufen			PMD_ABV417_001_000_1FT7M
    // ################################################################################################################
    /*
    VT_1FT7M_M00029	tech. Datentabelle Planetengetriebe II
    alt	VT_1FT7M_M00186	ZO Getriebemöglichkeiten
    neu: VT_1FT7M_M00029
    */
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Ausführung des Wellenendes an der Antriebsseite 			PMD_ABV414_001_000_1FT7M
    // ################################################################################################################
    /*
    VT_1FT7M_M00027	Übersetzung Planetegetriebe  <> J** Opt
    alt		VT_1FT7M_M00186	ZO Getriebemöglichkeiten
    neu: VT_1FT7M_M00029
    
    NICHT MLFB15 !!!!
    */
    
    // ################################################################################################################
    /*
    Bestimmung Getriebe aus KAG HMK_OPT_PLANETGETR_1FT7M "Jxx"
    
    VT_1FT7M_M00027	KAG --> Übersetzung und Wellenende
        PMD_ABV413_001_000_1FT7M		PMD_ABV414_001_000_1FT7M		HMK_OPT_PLANETGETR_1FT7M		HMK_VALUE_VALID_1FT7M
    
    dann mit Übersetzung und HMK_BAUGROESSE aus VT 220 Bezeichnung ABV410
    
    Anzahl schaltstufen? aus VT177
    */

function SetGetriebe(strchangedAttribute, oData)
{
}

/**
    Art des Getriebes:
    Z0002	Flachgetriebe
    Z0003	Kegelradgetriebe
    Z0006	Stirnradgetriebe
    STSCHG	Stirnradschneckengetriebe
    
    Übersetzungsstufe:
    00001	Zweistufig
    00002	Dreistufig
    .    	Kein Wert
    
    VT_1FG1S_M00025
    MLFB_05_06_07_1FG1S		MLFB05_1FG1S	MLFB06_1FG1S	MLFB07_1FG1S	PMD_ABV410_001_000_1FG1S	
    PMD_ABV517_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X		HMK_VALUE_VALID_1FG1S

*/
function Bestimme_Getriebe(oData)
{
    /*
    Bestimmung Getriebe aus KAG HMK_OPT_PLANETGETR_1FT7M "Jxx"
    
    VT_1FT7M_M00027	KAG --> Übersetzung und Wellenende
        PMD_ABV413_001_000_1FT7M		PMD_ABV414_001_000_1FT7M		HMK_OPT_PLANETGETR_1FT7M		HMK_VALUE_VALID_1FT7M
    
    dann mit Übersetzung und HMK_BAUGROESSE aus VT 220 Bezeichnung ABV410
    
    Anzahl schaltstufen? aus VT177
    */
   	
	//var ECSI_CX_SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
	if (oData.oParsingData.GEAR == "SERVO"){
		ECL_DeactivateAllAttributeValues("PMD_ABV410_001_000_1FT7M");
		ECL_ActivateValue("PMD_ABV410_001_000_1FT7M", "KEING");
		ECL_SelectValue("PMD_ABV410_001_000_1FT7M", "KEING");
		
		ECL_DeactivateAllAttributeValues("HMK_OPT_PLANETGETR_1FT7M");
		ECL_ActivateValue("HMK_OPT_PLANETGETR_1FT7M", "NON");
		ECL_SelectValue("HMK_OPT_PLANETGETR_1FT7M", "NON");
		return;
	}
	
	ECL_ActivateAttribute("PMD_ABV410_001_000_1FT7M"); // Bezeichnung Getriebe
	ECL_ActivateAttribute("HMK_UEBERSETZ_STUFE_1FT7M"); // Übersetzung + Stufigkeit
	ECL_ActivateAttribute("PMD_ABV414_001_000_1FT7M"); // Wellenende
	
	ECL_ActivateAttribute("HMK_ACB729_1FT7M");
	ECL_ActivateAttribute("HMK_ACB772_1FT7M");
	ECL_ActivateAttribute("HMK_ACB789_1FT7M");
	ECL_ActivateAttribute("HMK_ACB769_1FT7M");
	ECL_ActivateAttribute("HMK_ACB783_1FT7M");
	
    // HMK_OPT_PLANETGETR_1FT7M
    // KAG: Jxx
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_PLANETGETR_1FT7M";
    var bCheck = false;
    var bErrGetriebe = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);    
    
    if (sKAG != "NON"){
        // Daten Getriebe bestimmen
        ECL_DeactivateAllAttributeValues("HMK_OPT_PLANETGETR_1FT7M");
		ECL_ActivateValue("HMK_OPT_PLANETGETR_1FT7M", sKAG);
		ECL_SelectValue("HMK_OPT_PLANETGETR_1FT7M", sKAG);
        /*
        VT_1FT7M_M00027	KAG --> Übersetzung und Wellenende
        PMD_ABV413_001_000_1FT7M		PMD_ABV414_001_000_1FT7M		HMK_OPT_PLANETGETR_1FT7M		HMK_VALUE_VALID_1FT7M
        */
        var sTable = "VT_1FT7M_M00027" + sDB_Suffix;
        var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                    "HMK_OPT_PLANETGETR_1FT7M = '" + sKAG + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0)
        {
            var PMD_ABV413_001_000_1FT7M = aResult[0].PMD_ABV413_001_000_1FT7M; // Übersetzung
            var PMD_ABV414_001_000_1FT7M = aResult[0].PMD_ABV414_001_000_1FT7M; // Wellenende
            
            ECL_DeactivateAllAttributeValues("PMD_ABV413_001_000_1FT7M");
			ECL_ActivateValue("PMD_ABV413_001_000_1FT7M", PMD_ABV413_001_000_1FT7M);
			ECL_SelectValue("PMD_ABV413_001_000_1FT7M", PMD_ABV413_001_000_1FT7M);
			
			ECL_DeactivateAllAttributeValues("PMD_ABV414_001_000_1FT7M");
			ECL_ActivateValue("PMD_ABV414_001_000_1FT7M", PMD_ABV414_001_000_1FT7M);

            ECL_SetValue("PMD_ABV414_001_000_1FT7M", PMD_ABV414_001_000_1FT7M);
            
            // Bestimme Getriebebezeichnung PMD_ABV410_001_000_1FT7M aus VT220
            /*
            ALT	VT_1FT7M_M00220
                HMK_BAUGROESSE_1FT7M		PMD_ABV410_001_000_1FT7M		PMD_ABV413_001_000_1FT7M	
                HMK_SZ_GETRIEBE_UEB_1FT7M	PMD_ABX578_001_000_1FT7M	PMD_ABW811_001_000_1FT7M	
                PMD_ABW812_001_000_1FT7M		HMK_GETRIEB_TRAEG_03_1FT7M_X		HMK_GETRIEB_TRAEG_04_1FT7M_X	
                HMK_GETRIEB_TRAEG_06_1FT7M_X	HMK_GETRIEB_TRAEG_08_1FT7M_X		HMK_GETRIEB_TRAEG_10_1FT7M_X	
                HMK_GETRIEB_TRAEG_13_1FT7M_X
            
            NEU: 	VT_1FT7M_M00028
            	HMK_BAUGROESSE_1FT7M	PMD_ABV410_001_000_1FT7M	PMD_ABV413_001_000_1FT7M	
				HMK_SZ_GETRIEBE_UEB_1FT7M	PMD_ABX578_001_000_1FT7M	PMD_ABW811_001_000_1FT7M	PMD_ABW812_001_000_1FT7M
	
            */
            var HMK_BAUGROESSE_1FT7M = oData.oParsingData.BAUGR;
            
            var sTable = "VT_1FT7M_M00028" + sDB_Suffix;
            var sSQL = "SELECT PMD_ABV410_001_000_1FT7M FROM "+sTable+" WHERE " +
                        "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                        "PMD_ABV413_001_000_1FT7M = '" + PMD_ABV413_001_000_1FT7M + "';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
            if (aResult.length > 0){
                
                var PMD_ABV410_001_000_1FT7M = aResult[0].PMD_ABV410_001_000_1FT7M;
                
                ECL_DeactivateAllAttributeValues("PMD_ABV410_001_000_1FT7M");
				ECL_ActivateValue("PMD_ABV410_001_000_1FT7M", PMD_ABV410_001_000_1FT7M);
				ECL_SelectValue("PMD_ABV410_001_000_1FT7M", PMD_ABV410_001_000_1FT7M);

                
                // Bestimme Schaltstufen PMD_ABV417_001_000_1FT7M aus VT_1FT7M_M00029
                /*
                VT_1FT7M_M00029
                    PMD_ABV410_001_000_1FT7M		PMD_ABX579_001_000_1FT7M		PMD_ABX577_001_000_1FT7M	
                    PMD_ABX576_001_000_1FT7M		PMD_ABV417_001_000_1FT7M		PMD_ABW818_001_000_1FT7M	
                    PMD_ABW207_001_000_1FT7M		PMD_ABX599_001_000_1FT7M		HMK_GETR_TYP_KENNUNG_1FT7M	
                    HMK_SZ_GETRIEBE_TYP_1FT7M
                */
                var sTable = "VT_1FT7M_M00029" + sDB_Suffix;
                var sSQL = "SELECT PMD_ABV417_001_000_1FT7M FROM "+sTable+" WHERE " +
                            "PMD_ABV410_001_000_1FT7M = '" + PMD_ABV410_001_000_1FT7M + "';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
                if (aResult.length > 0){
                    
                    var PMD_ABV417_001_000_1FT7M = aResult[0].PMD_ABV417_001_000_1FT7M;
                    
                    ECL_DeactivateAllAttributeValues("PMD_ABV417_001_000_1FT7M");
					ECL_ActivateValue("PMD_ABV417_001_000_1FT7M", PMD_ABV417_001_000_1FT7M);
					ECL_SelectValue("PMD_ABV417_001_000_1FT7M", PMD_ABV417_001_000_1FT7M);
					
					// bestimme HMK_UEBERSETZ_STUFE_1FT7M	Übersetzung + Stufigkeit
					/* VT_1FT7M_M00034	ZO Übersetzung <-> Stufigkeit
						PMD_ABV410_001_000_1FT7M	PMD_ABV413_001_000_1FT7M	PMD_ABV417_001_000_1FT7M	HMK_UEBERSETZ_STUFE_1FT7M	HMK_VALUE_VALID_1FT7M
					*/
					
					var sTable = "VT_1FT7M_M00034" + sDB_Suffix;
					var sSQL = "SELECT HMK_UEBERSETZ_STUFE_1FT7M FROM "+sTable+" WHERE " +
								"PMD_ABV410_001_000_1FT7M = '" + PMD_ABV410_001_000_1FT7M + "' AND " +
								"PMD_ABV413_001_000_1FT7M = '" + PMD_ABV413_001_000_1FT7M + "' AND " +
								"PMD_ABV417_001_000_1FT7M = '" + PMD_ABV417_001_000_1FT7M + "' AND " +
								"HMK_VALUE_VALID_1FT7M = 'T';";
					
					var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
					if (aResult.length > 0){
						var HMK_UEBERSETZ_STUFE_1FT7M = aResult[0].HMK_UEBERSETZ_STUFE_1FT7M;
						
						ECL_DeactivateAllAttributeValues("HMK_UEBERSETZ_STUFE_1FT7M");
						ECL_ActivateValue("HMK_UEBERSETZ_STUFE_1FT7M", HMK_UEBERSETZ_STUFE_1FT7M);
						ECL_SelectValue("HMK_UEBERSETZ_STUFE_1FT7M", HMK_UEBERSETZ_STUFE_1FT7M);
						
					}else{
						bErrGetriebe = true;
					}
				}else{
                    bErrGetriebe = true;
                }
            }else{
                bErrGetriebe = true;
            }
        }else{
            bErrGetriebe = true;
        }
    }else{
        bErrGetriebe = true;
    }
    
    if (bErrGetriebe){
        
        // Fehler wird in PL-Skript abgefangen
        
        // Kein Getriebe
        ECL_SelectValue("PMD_ABV413_001_000_1FT7M", "0");
        ECL_SelectValue("PMD_ABV414_001_000_1FT7M", "KEING");
        ECL_SelectValue("PMD_ABV410_001_000_1FT7M", "KEING");
        ECL_SelectValue("PMD_ABV417_001_000_1FT7M", "0");
        ECL_SelectValue("HMK_OPT_PLANETGETR_1FT7M", "NON");
        ECL_SelectValue("HMK_UEBERSETZ_STUFE_1FT7M", "00010");
    }
}




