//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


/*
Motordaten werden vom SIZER in der MLFB übergeben, werden immer 1:1 übernommen
*/

function SetMotor_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Baugroesse(oData); 	// PMD_ABP663_001_000_1FT7M Achshöhe	MLFB05+06 
        Bestimme_Baulaenge(oData); 		// TAK_ABU212_001_000_1FT7M	Baulänge	MLFB07
        Bestimme_Motortyp(oData);		// PMD_AAA259_001_000_1FT7M	Motortyp	MLFB08
        Bestimme_Drehzahl(oData);		// PMD_AAE020_001_000_1FT7M Synchrondrehzahl	MLFB10
        Bestimme_Kuehlung(oData);		// PMD_AAA136_001_000_1FT7M Kühlart	MLFB09
        Bestimme_Wellenende(oData);		// PMD_AAA506_001_000_1FT7M	Ausführung des Wellenendes / an der Antriebsseite	MLFB15
        //Bestimme_Wellengenauigkeit(oData);	// TAK_AAJ730_001_000_1FT7M	Wellen- und Flanschgenauigkeit					MLFB15
        //Bestimme_Haltebremse(oData);	// PMD_ABU276_001_000_1FT7M	Haltebremse											MLFB15
        Bestimme_E_Anschluss(oData);	// PMD_AAB047_001_000_1FT7M	Anordnung des elektrischen Anschlusses
        Bestimme_Bauform(oData);	// Bauform gemäß Code I			PMD_AAC949_001_000_1FT7M
        Bestimme_Schwinggroesse_Schutzart(oData);	// Schwinggrößenstufe		PMD_AAB007_001_000_1FT7M
                                                    // Schutzart IP				PMD_ABJ176_001_000_1FT7M
        
        
    } else {
        
        ECL_SetValue("PMD_ABP663_001_000_1FT7M","36");
        ECL_SetValue("TAK_ABU212_001_000_1FT7M","4");	
        ECL_SetValue("HMK_BAUGROESSE_1FT7M","034");	
        ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FT7M","Z0004"); // Compact Kerntyp
        ExecSetStandardifValueEmpty("PMD_AAE020_001_000_1FT7M","6000");
        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FT7M","Z0004"); // A Selbstkühlung
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FT7M","Z0003"); // Wellenende: Passfeder
        ExecSetStandardifValueEmpty("TAK_AAJ730_001_000_1FT7M","00001"); // Wellen- und Flanschgenauigkeit  N
        ExecSetStandardifValueEmpty("PMD_ABU276_001_000_1FT7M","F"); // Haltebremse keine 
        ExecSetStandardifValueEmpty("PMD_AAB047_001_000_1FT7M","00004"); // Anordnung des elektrischen Anschlusses 00004, Stecker drehbar
        ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1FT7M","Z0004"); // Bauform Z0004 IM B5 (neue Flanschform)
        ExecSetStandardifValueEmpty("PMD_AAB007_001_000_1FT7M","Z0001"); // Schwinggrößenstufe A
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FT7M","Z0011"); // Schutzart IP 64
        ECL_SetValue("PMD_ABV400_001_000_1FT7M","Z0002");
        ECL_SetValue("HMK_RUMPF_1FT7M","1FT7034-1AK7");
    }
}

function SetMotor(strchangedAttribute, oData)
{
}

/**
    Achshöhe		PMD_ABP663_001_000_1FT7M 
    VT_1FT7M_M00004		Achshöhe <> MLFB05
        MLFB05_1FT7M	PMD_ABP663_001_000_1FT7M	PMD_ABV852_001_000_1001920	HMK_VALUE_VALID_1FT7M
*/
function Bestimme_Baugroesse(oData)
{
    var MLFB05_1FT7M = oData.oParsingData.MLFB.POS5 + oData.oParsingData.MLFB.POS6;
    
    var sTable = "VT_1FT7M_M00004" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB05_1FT7M = '" + MLFB05_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_ABP663_001_000_1FT7M = aResult[0].PMD_ABP663_001_000_1FT7M; // Achshöhe
        
        ECL_SetValue("PMD_ABP663_001_000_1FT7M", PMD_ABP663_001_000_1FT7M);
    }
    ECL_DisableAttribute("PMD_ABP663_001_000_1FT7M");
}

/**
    VT_1FT7M_M00005	Baulänge <> MLFB07
        MLFB07_1FT7M	TAK_ABU212_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

*/
function Bestimme_Baulaenge(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB07_1FT7M = oMLFB.POS7;
    var TAK_ABU212_001_000_1FT7M = MLFB07_1FT7M; // 1:1 übersetzt
    
    ECL_SetValue("TAK_ABU212_001_000_1FT7M", TAK_ABU212_001_000_1FT7M);
    ECL_DisableAttribute("TAK_ABU212_001_000_1FT7M");
    
    ECL_DeactivateAllAttributeValues("MLFB07_1FT7M");
    ECL_ActivateValue("MLFB07_1FT7M", MLFB07_1FT7M);
    ECL_SetValue("MLFB07_1FT7M", MLFB07_1FT7M);
    
}
/**
    VT_1FT7M_M00006	Motortyp <> MLFB08
        MLFB08_1FT7M	PMD_AAA259_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
*/
function Bestimme_Motortyp(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB08_1FT7M = oMLFB.POS8;
    
    var sTable = "VT_1FT7M_M00006" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB08_1FT7M = '" + MLFB08_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA259_001_000_1FT7M = aResult[0].PMD_AAA259_001_000_1FT7M; // Motortyp
        
        ECL_DeactivateAllAttributeValues("PMD_AAA259_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAA259_001_000_1FT7M", PMD_AAA259_001_000_1FT7M);
        ECL_SetValue("PMD_AAA259_001_000_1FT7M", PMD_AAA259_001_000_1FT7M);
        
        ECL_DeactivateAllAttributeValues("MLFB08_1FT7M");
        ECL_ActivateValue("MLFB08_1FT7M", MLFB08_1FT7M);
        ECL_SetValue("MLFB08_1FT7M", MLFB08_1FT7M);
    }
}

/**
    VT_1FT7M_M00008
    MLFB10_1FT7M	PMD_AAE020_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

*/
function Bestimme_Drehzahl(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB10_1FT7M = oMLFB.POS10;
    
    var sTable = "VT_1FT7M_M00008" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB10_1FT7M = '" + MLFB10_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAE020_001_000_1FT7M = aResult[0].PMD_AAE020_001_000_1FT7M; // Drehzahl
        
        ECL_DeactivateAllAttributeValues("PMD_AAE020_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAE020_001_000_1FT7M", PMD_AAE020_001_000_1FT7M);
        ECL_SetValue("PMD_AAE020_001_000_1FT7M", PMD_AAE020_001_000_1FT7M);
    }
    ECL_DeactivateAllAttributeValues("MLFB10_1FT7M");
    ECL_ActivateValue("MLFB10_1FT7M", MLFB10_1FT7M);
    ECL_SetValue("MLFB10_1FT7M", MLFB10_1FT7M);
}

/**
    VT_1FT7M_M00007
    MLFB09_1FT7M	PMD_AAA136_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
*/
function Bestimme_Kuehlung(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB09_1FT7M = oMLFB.POS9;
    
    var sTable = "VT_1FT7M_M00007" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA136_001_000_1FT7M = aResult[0].PMD_AAA136_001_000_1FT7M; // Kühlart
        
        //ECL_DeactivateAllAttributeValues("PMD_AAA136_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAA136_001_000_1FT7M", PMD_AAA136_001_000_1FT7M);
        ECL_SetValue("PMD_AAA136_001_000_1FT7M", PMD_AAA136_001_000_1FT7M);
        
    }
    ECL_DeactivateAllAttributeValues("MLFB09_1FT7M");
    ECL_ActivateValue("MLFB09_1FT7M", MLFB09_1FT7M);
    ECL_SetValue("MLFB09_1FT7M", MLFB09_1FT7M);
}

/**
    Bestimme_Wellenende(oData);		// PMD_AAA506_001_000_1FT7M	Ausführung des Wellenendes / an der Antriebsseite	MLFB15
    Bestimme_Wellengenauigkeit(oData);	// TAK_AAJ730_001_000_1FT7M	Wellen- und Flanschgenauigkeit					MLFB15
    Bestimme_haltebremse(oData);	// PMD_ABU276_001_000_1FT7M	Haltebremse											MLFB15
    VT_1FT7M_M00014	Mechanik <> MLFB15
        MLFB15_1FT7M	PMD_AAA506_001_000_1FT7M	TAK_AAJ730_001_000_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
NEU 12/2020: 	VT_1FT7M_M00084
        HMK_RUMPF_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M 
*/
function Bestimme_Wellenende(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB15_1FT7M = oMLFB.POS15;
    
    var sTable = "VT_1FT7M_M00014" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB15_1FT7M = '" + MLFB15_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA506_001_000_1FT7M = aResult[0].PMD_AAA506_001_000_1FT7M; // Wellenende
        var TAK_AAJ730_001_000_1FT7M = aResult[0].TAK_AAJ730_001_000_1FT7M; // Wellen- und Flanschgenauigkeit
        var PMD_ABU276_001_000_1FT7M = aResult[0].PMD_ABU276_001_000_1FT7M; // Haltebremse
        
        // Ausführung des Wellenendes / an der Antriebsseite
        //ECL_DeactivateAllAttributeValues("PMD_AAA506_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAA506_001_000_1FT7M", PMD_AAA506_001_000_1FT7M);
        ECL_SetValue("PMD_AAA506_001_000_1FT7M", PMD_AAA506_001_000_1FT7M);
        
        // Wellen- und Flanschgenauigkeit
        //ECL_DeactivateAllAttributeValues("TAK_AAJ730_001_000_1FT7M");
        ECL_ActivateValue("TAK_AAJ730_001_000_1FT7M", TAK_AAJ730_001_000_1FT7M);
        ECL_SetValue("TAK_AAJ730_001_000_1FT7M", TAK_AAJ730_001_000_1FT7M);
        
        // Haltebremse
        //ECL_DeactivateAllAttributeValues("PMD_ABU276_001_000_1FT7M");
        ECL_ActivateValue("PMD_ABU276_001_000_1FT7M", PMD_ABU276_001_000_1FT7M);
        ECL_SetValue("PMD_ABU276_001_000_1FT7M", PMD_ABU276_001_000_1FT7M);
    }
}

/**
VT_1FT7M_M00101	MLFB13 <> Anord.el.Anschluss
        MLFB13_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

*/
function Bestimme_E_Anschluss(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    //var PMD_ABV400_001_000_1FT7M = oData.oParsingData.ABV400;
    var MLFB13_1FT7M = oMLFB.POS13;
    
    var sTable = "VT_1FT7M_M00101" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
                //"PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAB047_001_000_1FT7M = aResult[0].PMD_AAB047_001_000_1FT7M; // Anordnung des elektrischen Anschlusses
        
        //ECL_DeactivateAllAttributeValues("PMD_AAB047_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAB047_001_000_1FT7M", PMD_AAB047_001_000_1FT7M);
        ECL_SetValue("PMD_AAB047_001_000_1FT7M", PMD_AAB047_001_000_1FT7M);
        
    }else{
        var sError = "ERROR";
    }
}

// ################################################################################################################
// Bauform gemäß Code I			PMD_AAC949_001_000_1FT7M 	(Flanschausführung)
// ################################################################################################################
/*
VT_1FT7M_M00009	Bauform <> MLFB12
    MLFB12_1FT7M	PMD_AAC949_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

VT_1FT7M_M00189	Mapping Vorselektor Bauform
VT_1FT7M_M00060	ZO K20 Motor,Bauform
VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss

MLFB12
*/
function Bestimme_Bauform(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB12_1FT7M = oMLFB.POS12;
    
    var sTable = "VT_1FT7M_M00009" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAC949_001_000_1FT7M = aResult[0].PMD_AAC949_001_000_1FT7M; // Bauform
        
        //ECL_DeactivateAllAttributeValues("PMD_AAC949_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAC949_001_000_1FT7M", PMD_AAC949_001_000_1FT7M);
        ECL_SetValue("PMD_AAC949_001_000_1FT7M", PMD_AAC949_001_000_1FT7M);
        
    }
}



// ################################################################################################################
// Schutzart IP			PMD_ABJ176_001_000_1FT7M	
// ################################################################################################################
    /*
    VT_1FT7M_M00015	Schutzart,Schwinggr. <> MLFB16
        MLFB16_1FT7M	PMD_AAB007_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00188	Mapping Vorselektor Schutzart
    VT_1FT7M_M00057	ZO Motor Q12
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
neu VT_1FT7M_M00054	ZO Q13 MLFB.09 Schutzart
        HMK_OPT_Q13_1FT7M	MLFB09_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    MLFB16
    */
    
// ################################################################################################################
// Schwinggrößenstufe			PMD_AAB007_001_000_1FT7M
// ################################################################################################################
    /*
    VT_1FT7M_M00015	Schutzart,Schwinggr. <> MLFB16
        MLFB16_1FT7M	PMD_AAB007_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    
    MLFB16
    */
    
function Bestimme_Schwinggroesse_Schutzart(oData, isInit)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB16_1FT7M = oMLFB.POS16;
    
    var sTable = "VT_1FT7M_M00015" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB16_1FT7M = '" + MLFB16_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");

    if (aResult.length > 0)
    {
        var PMD_AAB007_001_000_1FT7M = aResult[0].PMD_AAB007_001_000_1FT7M; // Schwinggrößenstufe
        var PMD_ABJ176_001_000_1FT7M = aResult[0].PMD_ABJ176_001_000_1FT7M; // Schutzart IP
        
        //ECL_DeactivateAllAttributeValues("PMD_AAB007_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAB007_001_000_1FT7M", PMD_AAB007_001_000_1FT7M);
        ECL_SetValue("PMD_AAB007_001_000_1FT7M", PMD_AAB007_001_000_1FT7M);
        
        //ECL_DeactivateAllAttributeValues("PMD_ABJ176_001_000_1FT7M");
        ECL_ActivateValue("PMD_ABJ176_001_000_1FT7M", PMD_ABJ176_001_000_1FT7M);
        ECL_SetValue("PMD_ABJ176_001_000_1FT7M", PMD_ABJ176_001_000_1FT7M);
    }

    var availableOptionsForIpProtection = ECL_GetAllActiveAttributeValues("PMD_ABJ176_001_000_1FT7M");
    var codeForIp64 = "Z0011";
    if (availableOptionsForIpProtection.includes(codeForIp64) && isInit) {
        ECL_SetValue("PMD_ABJ176_001_000_1FT7M", codeForIp64);
    }
}

// ################################################################################################################
