//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


/*
Haltebremse
Werksprüfzeugnis
Schmierung und Dichtung


*/

function SetOptionen_1_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_HaltebremseReduziert(oData);	// HMK_OPT_N27_1FT7M	Haltebremse mit reduziertem Trägheitsmoment
        
        Bestimme_Pruefbescheinigung(oData); 	// HMK_OPT_B02_1FT7M	Abnahmeprüfzeugnis
        
        Bestimme_Lagerung(oData); 				// HMK_OPT_K20_1FT7M	Verstärkte Lagerung
        Bestimme_WellenendeSonder(oData); 	 	// PMD_AAD427_001_000_1FT7M	Sonderausführung Wellenende: SIMOTICS S-1FT5 kompatibel
        Bestimme_ChemBest_1(oData);				// HMK_OPT_CHEM_BEST_1_1FT7M	Edelstahlwelle und Beschichtung für erhöhte chemische Beständigkeit
        
        Bestimme_Zusatzabdichtung(oData); 		// HMK_OPT_Q13_1FT7M	Kundenspezifische Zusatzabdichtung
        
    }else{
        ExecSetStandardifValueEmpty("HMK_OPT_N27_1FT7M","F");
        
        ExecSetStandardifValueEmpty("HMK_OPT_B02_1FT7M","F");
        
        ExecSetStandardifValueEmpty("HMK_OPT_K20_1FT7M","F");
        ExecSetStandardifValueEmpty("PMD_AAD427_001_000_1FT7M","F"); // Wellen Sonderausführung
        ExecSetStandardifValueEmpty("HMK_AUFBAU_WELLE_1FT7M","00003"); // Wellenabmessungen
        ExecSetStandardifValueEmpty("HMK_OPT_CHEM_BEST_1_1FT7M","F");
        
        ExecSetStandardifValueEmpty("HMK_OPT_Q13_1FT7M","F");
        
    }
}

function SetOptionen_1(strchangedAttribute, oData)
{
}


// ################################################################################################################
// HMK_OPT_N27_1FT7M	Haltebremse mit reduziertem Trägheitsmoment
// ################################################################################################################
function Bestimme_HaltebremseReduziert(oData)
{
    // HMK_OPT_N27_1FT7M
    // KAG: N27, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_N27_1FT7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N27"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkHaltebremseReduziert(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkHaltebremseReduziert(oData, sTargetAttribute, sKAG)
{
    // VT_1FT7M_M00047	Opt. Haltebremse mit reduz. Trägheitsmom
    //	HMK_BAUGROESSE_1FT7M	MLFB08_1FT7M		MLFB11_1FT7M		MLFB12_1FT7M		
    //	MLFB14_1FT7M			MLFB16_1FT7M		HMK_OPT_N27_1FT7M
    
    var HMK_BAUGROESSE_1FT7M = oData.oParsingData.BAUGR;
    var MLFB08_1FT7M = oData.oParsingData.MLFB.POS8;
    var MLFB11_1FT7M = oData.oParsingData.MLFB.POS11;
    var MLFB12_1FT7M = oData.oParsingData.MLFB.POS12;
    var MLFB14_1FT7M = oData.oParsingData.MLFB.POS14;
    var MLFB16_1FT7M = oData.oParsingData.MLFB.POS16;
    
    var sTable = "VT_1FT7M_M00047" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                "MLFB08_1FT7M = '" + MLFB08_1FT7M + "' AND " +
                "MLFB11_1FT7M = '" + MLFB11_1FT7M + "' AND " +
                "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
                "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
                "MLFB16_1FT7M = '" + MLFB16_1FT7M + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// Abnahmeprüfzeugnis			HMK_OPT_B02_1FT7M
// ################################################################################################################
function Bestimme_Pruefbescheinigung(oData)
{
    // HMK_OPT_B02_1FT7M
    // KAG: B02, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_B02_1FT7M";
    
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B02"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1 && (oData.IsDriveTrain == 0)){	//if (sKAG != "NON"){
        // immer erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
// ################################################################################################################

// ################################################################################################################
/**
    HMK_OPT_K20_1FT7M	Verstärkte Lagerung
*/
// ################################################################################################################
function Bestimme_Lagerung(oData)
{
    // HMK_OPT_K20_1FT7M
    // KAG: K20, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_K20_1FT7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "K20"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkLagerung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkLagerung(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
    {
        return 0;
    }
    /*
    VT_1FT7M_M00060	ZO K20 Motor,Bauform
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAC949_001_000_1FT7M	
        HMK_OPT_K20_1FT7M	HMK_VALUE_VALID_1FT7M
    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");
    
    var sTable = "VT_1FT7M_M00060" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
                "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
                "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    //var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
    //var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    //var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");
    
    /*var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
                //"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }*/
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
/**
    PMD_AAD427_001_000_1FT7M	Sonderausführung Wellenende: SIMOTICS S-1FT5 kompatibel
*/
// ################################################################################################################
function Bestimme_WellenendeSonder(oData)
{
    // PMD_AAD427_001_000_1FT7M
    // KAG: N05, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "PMD_AAD427_001_000_1FT7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N05"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkWellenendeSonder(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        sKAG = "F";
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
    
    // Bestimme Wellenabmessungen
    /*
    VT_1FT7M_M00085	ZO Wellenabmessungen N05		Bestimmung der Abmessungen
        HMK_RUMPF_1FT7M	HMK_AUFBAU_WELLE_1FT7M	PMD_AAD427_001_000_1FT7M
    */
    var HMK_RUMPF_1FT7M = oData.oParsingData.RUMPF;
    
    var sTable = "VT_1FT7M_M00085" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length > 0){
        var HMK_AUFBAU_WELLE_1FT7M = aResult[0].HMK_AUFBAU_WELLE_1FT7M;
        
        ECL_SetValue("HMK_AUFBAU_WELLE_1FT7M", HMK_AUFBAU_WELLE_1FT7M);
    }
}
function checkWellenendeSonder(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1 || oData.GearboxMotorCoupling == 1)
    {
        return 0;
    }
    
    /*
    VT_1FT7M_M00085	ZO Wellenabmessungen N05
        HMK_RUMPF_1FT7M	HMK_AUFBAU_WELLE_1FT7M	PMD_AAD427_001_000_1FT7M

NEU: VT_1FT7M_M00083		MLFB Wellenende N05
        HMK_RUMPF_1FT7M		MLFB12_1FT7M	PMD_AAD427_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    
    */
    var HMK_RUMPF_1FT7M = oData.oParsingData.RUMPF;
    
    var sTable = "VT_1FT7M_M00085" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    
    var MLFB12_1FT7M = oData.oParsingData.MLFB.POS12;
    
    var sTable = "VT_1FT7M_M00083" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    //var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");
    //var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");
    
    var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
                //"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// HMK_OPT_CHEM_BEST_1_1FT7M	Edelstahlwelle und Beschichtung für erhöhte chemische Beständigkeit
// ################################################################################################################
function Bestimme_ChemBest_1(oData)
{
    // HMK_OPT_CHEM_BEST_1_1FT7M
    // KAG: N40, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N40"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkChemBest_1(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkChemBest_1(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
    {
        return 0;
    }
    /*
    VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
        
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00055	Opt. Edelstahlwelle + Beständigkeit
        PMD_ABP663_001_000_1FT7M		PMD_AAA259_001_000_1FT7M		PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M		PMD_AAB047_001_000_1FT7M		PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M		HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    
    */
    
    var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");
    var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");
    
    var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
    var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");
    var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");
    
    var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
                "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "' AND " +
                "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");
    
    var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");
    
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    
    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
                "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
                "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
                "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
                "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
                "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
                "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
                "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// Bestimme_Zusatzabdichtung(oData); // HMK_OPT_Q13_1FT7M	Kundenspezifische Zusatzabdichtung
// ################################################################################################################
function Bestimme_Zusatzabdichtung(oData)
{
    // HMK_OPT_Q13_1FT7M
    // KAG: Q13, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_Q13_1FT7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q13"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkZusatzabdichtung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkZusatzabdichtung(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
    {
        return 0;
    }
    /*
neu: VT_1FT7M_M00054	ZO Q13 MLFB.09 Schutzart
        HMK_OPT_Q13_1FT7M	MLFB09_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var MLFB09_1FT7M = oData.oParsingData.MLFB.POS9;
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");
    
    var sTable = "VT_1FT7M_M00054" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
                "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################



