//@legacy
//#mode(full-ecma)



//@import "VT_1FT7.js"


/*
Option Miscellaneous	/ Sonstiges

Sperrluftanschluss									HMK_OPT_Q12_1FT7M
Ausführung für erhöhte chemische Beständigkeit		HMK_OPT_CHEM_BEST_2_1FT7M (N16)
Kundenangabe auf dem Leistungsschild				HMK_OPT_Y84_1FT7M
Äusserer Erdungsanschluss							HMK_OPT_L13_1FT7M
Ausführung des Steckers								HMK_OPT_L03_L06_1FT7M
Abgang Lüfterstecker								HMK_OPT_Q41_42_43_44_1FT7M
*/


var strError;

function SetOptionsMisc_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Sperrluft(oData); 						// HMK_OPT_Q12_1FT7M		Sperrluftanschluss
        Bestimme_ChemBest_2(oData);						// HMK_OPT_CHEM_BEST_2_1FT7M	Ausführung für erhöhte chemische Beständigkeit
        Bestimme_Kundenangabe_Leistungsschild(oData);	// HMK_OPT_Y84_1FT7M		Kundenangabe auf dem Leistungsschild
        Bestimme_Erdung(oData); 	 					// HMK_OPT_L13_1FT7M		Äusserer Erdungsanschluss
        Bestimme_Stecker(oData); 						// HMK_OPT_L03_L06_1FT7M	Ausführung des Steckers			
        Bestimme_LueftungsStecker(oData); 				// HMK_OPT_Q41_42_43_44_1FT7M	Abgang Lüfterstecker


    } else {
        ExecSetStandardifValueEmpty("HMK_OPT_Q12_1FT7M", "F");
        ExecSetStandardifValueEmpty("HMK_OPT_CHEM_BEST_2_1FT7M", "F");
        ExecSetStandardifValueEmpty("HMK_OPT_Y84_1FT7M", "F");
        ExecSetStandardifValueEmpty("HMK_OPT_L13_1FT7M", "F"); // Äusserer Erdungsanschluss
        ExecSetStandardifValueEmpty("HMK_OPT_L03_L06_1FT7M", "NON");
        ExecSetStandardifValueEmpty("HMK_OPT_Q41_42_43_44_1FT7M", "-");
    }
}

function SetOptionen_1(strchangedAttribute, oData) {
}

// ####################################################################################################################
/**
    Bestimme_Sperrluft(oData); 		// HMK_OPT_Q12_1FT7M	Sperrluftanschluss
*/
// ####################################################################################################################
function Bestimme_Sperrluft(oData) {
    // HMK_OPT_Q12_1FT7M
    // KAG: Q12, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_Q12_1FT7M";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q12"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSperrluft(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkSperrluft(oData, sTargetAttribute, sKAG) {

    if (oData.IsDriveTrain == 1) {
        return 0;
    }
    /*
    VT_1FT7M_M00057	ZO Motor Q12
        PMD_AAA259_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_Q12_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    n.n. VT_1FT7M_M00077	EDZ - Sperrluftanschluss EPLAN
    
    VT_1FT7M_M00110	ZO L03 L06 Q12
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
    */
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00057" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }

    //--------------------------------------------------------------------------------------------------------------
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    //var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

    var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        //"HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FT7M_M00110	ZO L03 L06 Q12
    //	HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
    var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

    var sTable = "VT_1FT7M_M00110" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ####################################################################################################################

// ####################################################################################################################
// HMK_OPT_CHEM_BEST_2_1FT7M	Ausführung für erhöhte chemische Beständigkeit
// ####################################################################################################################
function Bestimme_ChemBest_2(oData) {
    // HMK_OPT_CHEM_BEST_2_1FT7M
    // KAG: N16, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_CHEM_BEST_2_1FT7M";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N16"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkChemBest_2(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkChemBest_2(oData, sTargetAttribute, sKAG) {
    if (oData.IsDriveTrain == 1) {
        return 0;
    }
    /*
    VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M		PMD_AAA259_001_000_1FT7M		PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M		PMD_ABU278_001_000_1FT7M		HMK_OPT_CHEM_BEST_2_1FT7M	
        HMK_VALUE_VALID_1FT7M
        
    VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M

    
    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00058" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");

    var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    //var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

    var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ####################################################################################################################


// ####################################################################################################################
/**	Kundenangabe auf dem Leistungsschild		HMK_OPT_Y84_1FT7M
    
    HMK_OPT_Y84_TXT_1FT7M	Kundenangabe auf dem Leistungsschild (Textfeld) 
    Text wird im Parser befüllt
*/
// ####################################################################################################################
function Bestimme_Kundenangabe_Leistungsschild(oData) {
    // HMK_OPT_Y84_1FT7M
    // KAG: Y84, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_Y84_1FT7M";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
// ####################################################################################################################



// ####################################################################################################################

/**
    HMK_OPT_L13_1FT7M	Äusserer Erdungsanschluss
*/

function Bestimme_Erdung(oData) {
    // HMK_OPT_L13_1FT7M
    // KAG: L13, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_L13_1FT7M";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L13"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkErdung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}

function checkErdung(oData, sTargetAttribute, sKAG) {
    /*
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	
        PMD_ABV400_001_000_1FT7M	HMK_OPT_L13_1FT7M	HMK_VALUE_VALID_1FT7M
    
    n.n.	VT_1FT7M_M00074	EDZ - Erdungsanschluss <--- EPLAN
    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");
    var PMD_ABV400_001_000_1FT7M = oData.oParsingData.ABV400;

    var sTable = "VT_1FT7M_M00079" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ####################################################################################################################



// ################################################################################################################
// Ausführung des Steckers			HMK_OPT_L03_L06_1FT7M
// ################################################################################################################
/**
    Ausführung des Steckers			HMK_OPT_L03_L06_1FT7M
*/

function Bestimme_Stecker(oData) {
    // HMK_OPT_L03_L06_1FT7M
    // KAG: L03, L06, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_L03_L06_1FT7M";
    var bCheck = false;

    // bei Baugröße 117 L06 pflicht!
    if (oData.oParsingData.BAUGR == "117") {
        ECL_ActivateValue(sTargetAttribute, "L06");
        ECL_SetValue(sTargetAttribute, "L06");
    } else {

        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

        if (sKAG != "NON") {
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = checkStecker(oData, sTargetAttribute, sKAG);
        }
        if (bCheck) {
            // wenn erlaubt, setzen
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);
        }
        // wenn keine KAG oder nicht erlaubt, NON setzen
        else {
            // ggf. muss eine Option gewählt sein BGR: 117 --> L06

            ECL_ActivateValue(sTargetAttribute, "NON");
            ECL_SetValue(sTargetAttribute, "NON");
        }
    }
    //var test = setStecker(oData);
}
function checkStecker(oData, sTargetAttribute, sKAG) {
    if (oData.IsDriveTrain == 1) {
        return 0;
    }
    /*
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00110	ZO L03 L06 Q12
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M

    VT_1FT7M_M00119	ZO Rumpf MLFB -- L03, L06
        HMK_RUMPF_1FT7M HMK_OPT_L03_L06_1FT7M

    VT_1FT7M_M00128	Bugrosse_stecker_L03
        PMD_ABV400_001_000_1FT7M    HMK_OPT_L03_L06_1FT7M   HMK_VALUE_VALID_1FT7M
    */

    var HMK_RUMPF_1FT7M = ECL_GetValue("HMK_RUMPF_1FT7M");
    var mlfb12 = oData.strBaseMLFB.charAt(11);
    var mlfb13 = oData.strBaseMLFB.charAt(12);
    var mlfb14 = oData.strBaseMLFB.charAt(13);
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + mlfb12 + "' AND " +
        "MLFB13_1FT7M = '" + mlfb13 + "' AND " +
        "MLFB14_1FT7M = '" + mlfb14 + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");

    var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

    var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FT7M_M00110	ZO L03 L06 Q12
    //	HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
    var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");

    var sTable = "VT_1FT7M_M00110" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1FT7M_M00119	ZO Rumpf MLFB -- L03, L06
    //  HMK_RUMPF_1FT7M HMK_OPT_L03_L06_1FT7M
    var sTable = "VT_1FT7M_M00119" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_ABV400_001_000_1FT7M = oData.oParsingData.ABV400;
    // VT_1FT7M_M00128	Bugrosse_stecker_L03
    //  PMD_ABV400_001_000_1FT7M    HMK_OPT_L03_L06_1FT7M   HMK_VALUE_VALID_1FT7M
    var sTable = "VT_1FT7M_M00128" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
function setStecker(oData) {
    /*
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var sTargetAttribute = "HMK_OPT_L03_L06_1FT7M";
    var HMK_BAUGROESSE_1FT7M = oData.oParsingData.BAUGR;
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// 
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// 
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 

    var HMK_RUMPF_1FT7M = ECL_GetValue("HMK_RUMPF_1FT7M");
    var mlfb12 = oData.oParsingData.strBaseMlfb.charAt(11);
    var mlfb13 = oData.oParsingData.strBaseMlfb.charAt(12);
    var mlfb14 = oData.oParsingData.strBaseMlfb.charAt(13);
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_L03_L06_1FT7M";

    var sWheren = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + mlfb12 + "' AND " +
        "MLFB13_1FT7M = '" + mlfb13 + "' AND " +
        "MLFB14_1FT7M = '" + mlfb14 + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sWhere = "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWheren);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PARSER_STECKER_NO_DB_RESULT";
        //return strError;
    }
    //--------------------------------------------------------------------------------------------------------------


}
// ################################################################################################################


// ################################################################################################################
/**
    HMK_OPT_Q41_42_43_44_1FT7M	Abgang Lüfterstecker
*/
// ################################################################################################################
function Bestimme_LueftungsStecker(oData) {
    // HMK_OPT_Q41_42_43_44_1FT7M
    // KAG: Q41, G42, Q43, Q44, -
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_Q41_42_43_44_1FT7M";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (sKAG != "NON") {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkLueftungsStecker(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, '-' setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "-");
        ECL_SetValue(sTargetAttribute, "-");
    }
}
function checkLueftungsStecker(oData, sTargetAttribute, sKAG) {
    if (oData.IsDriveTrain == 1) {
        return 0;
    }
    /*
    VT_1FT7M_M00118
        HMK_BAUGROESSE_1FT7M    MLFB09_1FT7M    MLFB13_1FT7M    HMK_OPT_Q41_42_43_44_1FT7M  HMK_VALUE_VALID_1FT7M
    
Todo	Abhängig von MLFB13 / Anordnung des elektrischen Anschlusses (Steckerabgangsrichtung/Klemmkasten)
    */
    var HMK_BAUGROESSE_1FT7M = oData.oParsingData.BAUGR;
    var MLFB09_1FT7M = oData.oParsingData.MLFB.POS9;
    var MLFB13_1FT7M = oData.oParsingData.MLFB.POS13;

    var sTable = "VT_1FT7M_M00118" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
        "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
        "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // todo MLFB13 Abhängigkeit prüfen
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}


// ################################################################################################################



