//@legacy
//#mode(full-ecma)



//@import "../1FT7_MLFB/Base.misc.js"

//@import "VT_1FT7.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";
    if (strchangedAttribute == "TAK_AAJ730_001_000_1FT7M") {
        var TAK_AAJ730_001_000_1FT7M = ECL_GetValue("TAK_AAJ730_001_000_1FT7M");
    }
    var sMLFB = ECL_GetValue("ECSI_MLFB");
    //var sMLFB1_4 = sMLFB.left(4);
    //var MLFB01_1FT7M = sMLFB.left(4);

    //var MLFB05_1FT7M = sMLFB.charAt(4) + sMLFB.charAt(5);  //AH 5+6
    //var MLFB07_1FT7M = sMLFB.charAt(6); //
    var MLFB08_1FT7M = sMLFB.charAt(7); //
    var MLFB09_1FT7M = sMLFB.charAt(8);
    //var MLFB10_1FT7M = sMLFB.charAt(9);
    var MLFB11_1FT7M = sMLFB.charAt(10);
    var MLFB12_1FT7M = sMLFB.charAt(11);
    var MLFB13_1FT7M = sMLFB.charAt(12);
    var MLFB14_1FT7M = sMLFB.charAt(13);
    var MLFB15_1FT7M = sMLFB.charAt(14);
    var MLFB16_1FT7M = sMLFB.charAt(15);

    var HMK_BAUGROESSE_1FT7M = ECL_GetValue("HMK_BAUGROESSE_1FT7M"); // MLFB5+6+7
    var HMK_RUMPF_1FT7M = ECL_GetValue("HMK_RUMPF_1FT7M");
    var PMD_ABV400_001_000_1FT7M = ECL_GetValue("PMD_ABV400_001_000_1FT7M");

    var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
    var ECSI_CX_GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling"));

    ECSI_CX_IsDriveTrain = parseInt(ECSI_CX_IsDriveTrain);
    if (ECSI_CX_IsDriveTrain !== 1) {
        ECSI_CX_IsDriveTrain = 0;
    }
    // ################################################################################################################
    //Bestimme Rümpfe:
    // ################################################################################################################
    /*
    HMK_RUMPF_1FT7M		siehe Parser
    
    VT_1FT7M_M00021	Zuordnung_Rumpf_MLFB
        HMK_RUMPF_1FT7M	MLFB05_1FT7M	MLFB07_1FT7M	MLFB08_1FT7M	MLFB09_1FT7M	MLFB10_1FT7M	MLFB11_1FT7
    
    n.n.	VT_1FT7M_M00022	ZO Rumpf-MLFB - Baugröße
    n.n.	VT_1FT7M_M00069	ZO Rumpf,Spannung,Kennlinie
    n.n.	VT_1FT7M_M00100	UI Tabelle
    */
    // ################################################################################################################
    /*
    HMK_BAUGROESSE_1FT7M	Baugröße (Achshöhe + Baulänge)

    VT_1FT7M_M00020	Baugröße <> Achshöhe, Baulänge
    n.n.	VT_1FT7M_M00022	ZO Rumpf-MLFB - Baugröße
    VT_1FT7M_M00023	Auswahllogik I (ZO Baugröße)
    VT_1FT7M_M00114	Auswahllogik II - Rumpf-Lage el.Anschl
    VT_1FT7M_M00028	tech. Datentabelle Planetengetriebe I
    VT_1FT7M_M00085	ZO Wellenabmessungen N05
    VT_1FT7M_M00047	Opt. Haltebremse N27
    VT_1FT7M_M00051	Opt. Abgang Lüftungst. Q41-Q44
    n.n.	VT_1FT7M_M00075	EDZ - Klemmenkasten
    */

    // ################################################################################################################
    // Auswahllogik I auf MLFB-Attributen	
    // ################################################################################################################
    /*
    VT_1FT7M_M00023 steuert über die Baugröße die MLFBs 08, 09, (11), 12, 14, 15, 16
    Daraus ergeben sich Einschränkungen für die Attribute 
    */
    // ################################################################################################################
    var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
        "MLFB08_1FT7M = '" + MLFB08_1FT7M + "' AND " +
        "MLFB09_1FT7M = '" + MLFB09_1FT7M + "';";
    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {

        ECL_DeactivateAllAttributeValues("MLFB12_1FT7M");
        ECL_DeactivateAllAttributeValues("MLFB14_1FT7M");
        ECL_DeactivateAllAttributeValues("MLFB15_1FT7M");
        ECL_DeactivateAllAttributeValues("MLFB16_1FT7M");

        for (var i = 0; i < aResult.length; i++) {

            ECL_ActivateValue("MLFB12_1FT7M", aResult[i].MLFB12_1FT7M);
            ECL_ActivateValue("MLFB14_1FT7M", aResult[i].MLFB14_1FT7M);
            ECL_ActivateValue("MLFB15_1FT7M", aResult[i].MLFB15_1FT7M);
            ECL_ActivateValue("MLFB16_1FT7M", aResult[i].MLFB16_1FT7M);
        }

    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_AUSWAHLLOGIK_I_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // Auswahllogik II (ZO Rumpf) auf MLFB-Attribute	MLFB12_1FT7M, MLFB13_1FT7M, MLFB14_1FT7M
    // ################################################################################################################
    //	VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
    //		HMK_RUMPF_1FT7M		MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    // MLFB12_1FT7M
    var sTargetAttribute = "MLFB12_1FT7M";
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_MLFB12_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------
    // MLFB13_1FT7M
    var sTargetAttribute = "MLFB13_1FT7M";
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_MLFB13_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------
    // MLFB14_1FT7M
    var sTargetAttribute = "MLFB14_1FT7M";
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_MLFB14_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // N16/N40 Umwahl
    if (strchangedAttribute == "UI_OPT_CHEM_BEST_1_1FT7M" || strchangedAttribute == "UI_OPT_CHEM_BEST_2_1FT7M") {
        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
        if (PMD_ABU278_001_000_1FT7M == "00020" || PMD_ABU278_001_000_1FT7M == "00021") {

            if (HMK_OPT_CHEM_BEST_1_1FT7M == "N40" && HMK_OPT_CHEM_BEST_2_1FT7M == "N16") {
                if (strchangedAttribute == "UI_OPT_CHEM_BEST_1_1FT7M") {
                    ECL_SetValue("HMK_OPT_CHEM_BEST_2_1FT7M", "F");
                } else {
                    ECL_SetValue("HMK_OPT_CHEM_BEST_1_1FT7M", "F");
                }
            } else if (HMK_OPT_CHEM_BEST_1_1FT7M == "F" && HMK_OPT_CHEM_BEST_2_1FT7M == "F") {
                if (strchangedAttribute == "UI_OPT_CHEM_BEST_1_1FT7M") {
                    ECL_SetValue("HMK_OPT_CHEM_BEST_2_1FT7M", "T");
                } else {
                    ECL_SetValue("HMK_OPT_CHEM_BEST_1_1FT7M", "T");
                }
            }
        }
    }


    // ################################################################################################################
    // Getriebe Auswirkung auf MLFB-Attribute und dadurch auf Attribute	
    // ################################################################################################################
    /*
    VT_1FT7M_M00025 steuert über HMK_OPT_PLANETGETR_1FT7M die MLFBs 08, (11), 12, 15, 16
    Daraus ergeben sich Einschränkungen für die Attribute 
    */
    // ################################################################################################################
    var HMK_OPT_PLANETGETR_1FT7M = ECL_GetValue("HMK_OPT_PLANETGETR_1FT7M");

    if (HMK_OPT_PLANETGETR_1FT7M != "NON") {
        var sTable = "VT_1FT7M_M00025" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "HMK_OPT_PLANETGETR_1FT7M = '" + HMK_OPT_PLANETGETR_1FT7M + "' AND " +
            "MLFB08_1FT7M = '" + MLFB08_1FT7M + "';";
        var aResult = GetDBDataSetEXT(sSQL, sTable);

        if (aResult.length > 0) {

            var aValidValuesMLFB12 = ECL_GetAllActiveAttributeValues("MLFB12_1FT7M");
            var aValidValuesMLFB15 = ECL_GetAllActiveAttributeValues("MLFB15_1FT7M");
            var aValidValuesMLFB16 = ECL_GetAllActiveAttributeValues("MLFB16_1FT7M");

            ECL_DeactivateAllAttributeValues("MLFB12_1FT7M");
            ECL_DeactivateAllAttributeValues("MLFB15_1FT7M");
            ECL_DeactivateAllAttributeValues("MLFB16_1FT7M");

            for (var i = 0; i < aResult.length; i++) {

                if (aValidValuesMLFB12.indexOf(aResult[i].MLFB12_1FT7M) > -1)
                    ECL_ActivateValue("MLFB12_1FT7M", aResult[i].MLFB12_1FT7M);
                if (aValidValuesMLFB15.indexOf(aResult[i].MLFB15_1FT7M) > -1)
                    ECL_ActivateValue("MLFB15_1FT7M", aResult[i].MLFB15_1FT7M);
                if (aValidValuesMLFB16.indexOf(aResult[i].MLFB16_1FT7M) > -1)
                    ECL_ActivateValue("MLFB16_1FT7M", aResult[i].MLFB16_1FT7M);
            }
        } else {
            strError = "DICT1_ERR_1FT7M___PLVT_GETRIEBE_MLFB_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################
    // DriveTrain MLFB16 einschränkung (Schutzart und Grade R Schwinggrößenstufe
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['0', '1'];

        var sStatus = SetAttributeLogicFromCode("MLFB16_1FT7M", aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_GETRIEBE_MLFB_NO_DB_RESULT";
            return strError;
        }
        ECL_DeactivateValue("MLFB12_1FT7M", "0");
        ECL_DeactivateValue("MLFB12_1FT7M", "5");

        ECL_DeactivateValue("MLFB13_1FT7M", "4");	// Stecker drehbar
        ECL_DeactivateValue("MLFB13_1FT7M", "5");	// nicht mit Klemmkasten
        ECL_DeactivateValue("MLFB13_1FT7M", "6");
        ECL_DeactivateValue("MLFB13_1FT7M", "7");
        ECL_DeactivateValue("MLFB13_1FT7M", "8");

        ECL_DeactivateValue("MLFB15_1FT7M", "K");
        ECL_DeactivateValue("MLFB15_1FT7M", "L");
    }
    // ################################################################################################################

    // ################################################################################################################
    // KS-Adapter Anbau
    // ################################################################################################################
    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
    if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
        // nur mit klassischem Flansch, grundsätzlich nur glatte Welle ohne Passfeder
        // MLFB12 nur 1, 4			(0, 5 deaktivieren)
        ECL_DeactivateValue("MLFB12_1FT7M", "0");
        ECL_DeactivateValue("MLFB12_1FT7M", "5");

        // MLFB15 nur G, H, K, L 	(A,B,D,E deaktivieren)
        ECL_DeactivateValue("MLFB15_1FT7M", "A");
        ECL_DeactivateValue("MLFB15_1FT7M", "B");
        ECL_DeactivateValue("MLFB15_1FT7M", "D");
        ECL_DeactivateValue("MLFB15_1FT7M", "E");
    }

    // ################################################################################################################

    // ################################################################################################################
    // Einschränkung durch Bremsenvorgabe
    // ################################################################################################################
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (ECSI_CX_MotorBrakeRequired && parseInt(ECSI_CX_MotorBrakeRequired) == 1) {
        // mit Bremse
        ECL_DeactivateValue("MLFB15_1FT7M", "A");
        ECL_DeactivateValue("MLFB15_1FT7M", "D");
        ECL_DeactivateValue("MLFB15_1FT7M", "G");
        ECL_DeactivateValue("MLFB15_1FT7M", "K");
    } else {
        // ohne Bremse
        ECL_DeactivateValue("MLFB15_1FT7M", "B");
        ECL_DeactivateValue("MLFB15_1FT7M", "E");
        ECL_DeactivateValue("MLFB15_1FT7M", "H");
        ECL_DeactivateValue("MLFB15_1FT7M", "L");
    }
    // ################################################################################################################

    // ################################################################################################################
    // Zwischenkreisspannung	
    // ################################################################################################################
    /*
    NN
    */
    // ################################################################################################################


    // ################################################################################################################
    // Achshöhe			PMD_ABP663_001_000_1FT7M	
    // ################################################################################################################
    /*	
    VT_1FT7M_M00004	Achshöhe <> MLFB05
n.n.	VT_1FT7M_M00035	UI AH Max einschränken
n.n.	VT_1FT7M_M00048	techn.Daten Haltebremse
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
    VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
    VT_1FT7M_M00060	ZO K20 Motor,Bauform
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss
n.n.	VT_1FT7M_M00080	ZO Toleranzen
    
    
    MLFB05+06
    */
    // ################################################################################################################


    // ################################################################################################################
    // Baulänge			TAK_ABU212_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00005	Baulänge <> MLFB07
        MLFB07_1FT7M	TAK_ABU212_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    MLFB07
    */
    // ################################################################################################################


    // ################################################################################################################
    // Motortyp		PMD_AAA259_001_000_1FT7
    // ################################################################################################################
    /*
    VT_1FT7M_M00006	Motortyp <> MLFB08
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
    VT_1FT7M_M00057	ZO Motor Q12
    VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
    VT_1FT7M_M00060	ZO K20 Motor,Bauform
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss

    
    MLFB08
    */
    // ################################################################################################################


    // ################################################################################################################
    // Art der Kühlung			PMD_AAA136_001_000_1FT7M	
    // ################################################################################################################
    /*
    SIZER-Vorgabe
    
    VT_1FT7M_M00007	Kühlart <> MLFB09
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
    VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
    VT_1FT7M_M00070	EDZ - Kühlart
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss
    
    MLFB09
    VT_1FT7M_M00114	Auswahllogik II - Rumpf-Lage el.Anschl
        HMK_RUMPF_1FT7M		MLFB13_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    // ################################################################################################################


    // ################################################################################################################
    // Bemessungsdrehzahl			PMD_AAE020_001_000_1FT7M	
    // ################################################################################################################
    /*
    im Parser definiert
    VT_1FT7M_M00008	Drehzahl <> MLFB10
        MLFB10_1FT7M	PMD_AAE020_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    NN
    
    MLFB10
    VT_1FT7M_M00114	Auswahllogik II - Rumpf-Lage el.Anschl
        HMK_RUMPF_1FT7M		MLFB13_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    // ################################################################################################################

    // ################################################################################################################
    // Bauform gemäß Code I			PMD_AAC949_001_000_1FT7M 	(Flanschausführung)
    // ################################################################################################################
    // ==> verschoben unterhalb Geber
    // ################################################################################################################


    // ################################################################################################################
    // Haltebremse			PMD_ABU276_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00014	Mechanik <> MLFB15
        MLFB15_1FT7M	PMD_AAA506_001_000_1FT7M	TAK_AAJ730_001_000_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00042	Haltebremse			n.n.
    VT_1FT7M_M00048	techn.Daten Haltebremse	n.n.

    VT_1FT7M_M00073	EDZ - Haltebremse		n.n.
    VT_1FT7M_M00075	EDZ - Klemmenkasten		n.n.
    
NEU 12/2020: 	VT_1FT7M_M00084
        HMK_RUMPF_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M 
    
    MLFB15
    */

    /* verschoben nach oben zu KS-Adapter
    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (strwithBrake == "1"){
        // mit Bremse
        ECL_DeactivateValue("MLFB15_1FT7M", "A");
        ECL_DeactivateValue("MLFB15_1FT7M", "D");
        ECL_DeactivateValue("MLFB15_1FT7M", "G");
        ECL_DeactivateValue("MLFB15_1FT7M", "K");
    }else{
        // ohne Bremse
        ECL_DeactivateValue("MLFB15_1FT7M", "B");
        ECL_DeactivateValue("MLFB15_1FT7M", "E");
        ECL_DeactivateValue("MLFB15_1FT7M", "H");
        ECL_DeactivateValue("MLFB15_1FT7M", "L");
    }
    */

    var sStatus = SetAttributeLogicFromMLFB("PMD_ABU276_001_000_1FT7M", "MLFB15_1FT7M", "VT_1FT7M_M00014" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_HALTEBREMSE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    /*	var PMD_AAA506_001_000_1FT7M = ECL_GetValue("PMD_AAA506_001_000_1FT7M");	// Ausführung des Wellenendes
        var TAK_AAJ730_001_000_1FT7M = ECL_GetValue("TAK_AAJ730_001_000_1FT7M");	// Wellen-/Flanschgenauigkeit
        
        var sTable = "VT_1FT7M_M00014" + sDB_Suffix;
        var sTargetAttribute = "PMD_ABU276_001_000_1FT7M";
        var sWhere = 	"PMD_AAA506_001_000_1FT7M = '" + PMD_AAA506_001_000_1FT7M + "' AND " +
                        "TAK_AAJ730_001_000_1FT7M = '" + TAK_AAJ730_001_000_1FT7M + "' AND " +
                        "HMK_VALUE_VALID_1FT7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT7M___PLVT_HALTEBREMSE_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    */	// ----------------------------------------------------------------------------------------------------------------
    // HMK_RUMPF_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M 
    var sTable = "VT_1FT7M_M00084" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABU276_001_000_1FT7M";
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_HALTEBREMSE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // Ausführung des Wellenendes an der Antriebsseite 			PMD_AAA506_001_000_1FT7
    // ################################################################################################################
    /*
    VT_1FT7M_M00014	Mechanik <> MLFB15
        MLFB15_1FT7M	PMD_AAA506_001_000_1FT7M	TAK_AAJ730_001_000_1FT7M	PMD_ABU276_001_000_1FT7M	
        HMK_VALUE_VALID_1FT7M

    MLFB15 !!!!
    */
    var sTargetAttribute = "PMD_AAA506_001_000_1FT7M";

    var sStatus = SetAttributeLogicFromMLFB("PMD_AAA506_001_000_1FT7M", "MLFB15_1FT7M", "VT_1FT7M_M00014" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_AUSF_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var TAK_AAJ730_001_000_1FT7M = ECL_GetValue("TAK_AAJ730_001_000_1FT7M");	// Wellen-/Flanschgenauigkeit
    var PMD_ABU276_001_000_1FT7M = ECL_GetValue("PMD_ABU276_001_000_1FT7M");	// Bremse

    var sTable = "VT_1FT7M_M00014" + sDB_Suffix;
    var sWhere = "TAK_AAJ730_001_000_1FT7M = '" + TAK_AAJ730_001_000_1FT7M + "' AND " +
        "PMD_ABU276_001_000_1FT7M = '" + PMD_ABU276_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_AUSF_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Wellen- und Flanschgenauigkeit			TAK_AAJ730_001_000_1FT7M
    // ################################################################################################################
    /*
    VT_1FT7M_M00014	Mechanik <> MLFB15
        MLFB15_1FT7M	PMD_AAA506_001_000_1FT7M	TAK_AAJ730_001_000_1FT7M	PMD_ABU276_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

n.n.	VT_1FT7M_M00080	ZO Toleranzen
        PMD_ABP663_001_000_1FT7M	TAK_AAJ730_001_000_1FT7M	PMD_ACE843_001_000_1FT7M	PMD_ACE844_001_000_1FT7M	PMD_ACE845_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    MLFB15
    */
    var sTargetAttribute = "TAK_AAJ730_001_000_1FT7M";


    var sStatus = SetAttributeLogicFromMLFB("TAK_AAJ730_001_000_1FT7M", "MLFB15_1FT7M", "VT_1FT7M_M00014" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_FLANSCHGENAUIGKEIT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_AAA506_001_000_1FT7M = ECL_GetValue("PMD_AAA506_001_000_1FT7M");	// Ausführung des Wellenendes
    var PMD_ABU276_001_000_1FT7M = ECL_GetValue("PMD_ABU276_001_000_1FT7M");	// Bremse

    var sTable = "VT_1FT7M_M00014" + sDB_Suffix;
    var sWhere = "PMD_AAA506_001_000_1FT7M = '" + PMD_AAA506_001_000_1FT7M + "' AND " +
        "PMD_ABU276_001_000_1FT7M = '" + PMD_ABU276_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_FLANSCHGENAUIGKEIT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // Bestimmung MLFB15 aus Wellenende, Wellen-/Flanschgenauigkeit und Haltebremse
    // ################################################################################################################
    var PMD_ABU276_001_000_1FT7M = ECL_GetValue("PMD_ABU276_001_000_1FT7M");	// Bremse
    var PMD_AAA506_001_000_1FT7M = ECL_GetValue("PMD_AAA506_001_000_1FT7M");	// Ausführung des Wellenendes
    var TAK_AAJ730_001_000_1FT7M = ECL_GetValue("TAK_AAJ730_001_000_1FT7M");	// Wellen-/Flanschgenauigkeit

    var sTable = "VT_1FT7M_M00014" + sDB_Suffix;
    var sSQL = "SELECT MLFB15_1FT7M FROM " + sTable + " WHERE " +
        "PMD_AAA506_001_000_1FT7M = '" + PMD_AAA506_001_000_1FT7M + "' AND " +	// Ausführung des Wellenendes an der Antriebsseite
        "TAK_AAJ730_001_000_1FT7M = '" + TAK_AAJ730_001_000_1FT7M + "' AND " +	// Wellen- und Flanschgenauigkeit
        "PMD_ABU276_001_000_1FT7M = '" + PMD_ABU276_001_000_1FT7M + "' AND " +	// Haltebremse
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);
    if (aResult.length > 0) {

        var MLFB15_1FT7M = aResult[0].MLFB15_1FT7M;

        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FT7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB15_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Schutzart IP			PMD_ABJ176_001_000_1FT7M	
    // ################################################################################################################
    var sTargetAttribute = "PMD_ABJ176_001_000_1FT7M";
    /*
    A: VT_1FT7M_M00015	Schutzart,Schwinggr. <> MLFB16
        MLFB16_1FT7M	PMD_AAB007_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    n.n.	VT_1FT7_M00188	Mapping Vorselektor Schutzart
    B: VT_1FT7M_M00057	ZO Motor Q12
        PMD_AAA259_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_Q12_1FT7M	HMK_VALUE_VALID_1FT7M

    C: VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    
    D: VT_1FT7M_M00054	ZO Q13 MLFB.09 Schutzart
        HMK_OPT_Q13_1FT7M	MLFB09_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    
    MLFB16
    */
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, "MLFB16_1FT7M", "VT_1FT7M_M00015" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    var PMD_AAB007_001_000_1FT7M = ECL_GetValue("PMD_AAB007_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00015" + sDB_Suffix;
    var sWhere = "PMD_AAB007_001_000_1FT7M = '" + PMD_AAB007_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // B: ----------------------------------------------------------------------------------------
    /* VT_1FT7M_M00057	ZO Motor Q12
        PMD_AAA259_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_Q12_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
    var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");	// 

    var sTable = "VT_1FT7M_M00057" + sDB_Suffix;
    var sWhere = "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // C -------------------------------------------------------------------------------------------------------------
    /* VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");

    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // D: ----------------------------------------------------------------------------------------
    /*
    VT_1FT7M_M00054	 ZO Q13 MLFB.09 Schutzart
        HMK_OPT_Q13_1FT7M	MLFB09_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var HMK_OPT_Q13_1FT7M = ECL_GetValue("HMK_OPT_Q13_1FT7M");

    var sTable = "VT_1FT7M_M00054" + sDB_Suffix;
    var sWhere = "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
        "HMK_OPT_Q13_1FT7M = '" + HMK_OPT_Q13_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    /* über Einschränkung MLFB16 erledigt
    if (ECSI_CX_IsDriveTrain == 1){
        
        var aValidValues = ['Z0011','Z0023'];
        
        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT7M___PLVT_SCHUTZART_NO_DB_RESULT";
            return strError;
        }
    }*/
    // ################################################################################################################


    // ################################################################################################################
    // Schwinggrößenstufe			PMD_AAB007_001_000_1FT7
    // ################################################################################################################
    /*
    VT_1FT7M_M00015	Schutzart,Schwinggr. <> MLFB16
        MLFB16_1FT7M	PMD_AAB007_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    
    MLFB16
    */
    var sStatus = SetAttributeLogicFromMLFB("PMD_AAB007_001_000_1FT7M", "MLFB16_1FT7M", "VT_1FT7M_M00015" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHWINGGR_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------


    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00015" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAB007_001_000_1FT7M";
    var sWhere = "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_SCHWINGGR_NO_DB_RESULT";
        return strError;
    }
    /* DriveTrain über Einschränkung MLFB16 erledigt
    */
    // ################################################################################################################

    // ################################################################################################################
    // Bestimme MLFB16
    // ################################################################################################################
    /*VT_1FT7M_M00015	Schutzart,Schwinggr. <> MLFB16
        MLFB16_1FT7M	PMD_AAB007_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");
    var PMD_AAB007_001_000_1FT7M = ECL_GetValue("PMD_AAB007_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00015" + sDB_Suffix;
    var sSQL = "SELECT MLFB16_1FT7M FROM " + sTable + " WHERE " +
        "PMD_AAB007_001_000_1FT7M = '" + PMD_AAB007_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PL");
    if (aResult.length > 0) {

        var MLFB16_1FT7M = aResult[0].MLFB16_1FT7M;

        sMLFB = replaceAt(sMLFB, 15, MLFB16_1FT7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB16_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################




    // ################################################################################################################
    // Gebersystem			PMD_ABU278_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M				HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00044	ZO Geber
        PMD_ABU278_001_000_1FT7M	UI_GEBER_1FT7M		UI_GEBER_AUFLOESUNG_1FT7M	UI_DRIVECLIQ_1FT7M	
        PMD_ABU209_001_000_1FT7M	HMK_OPT_R72_1FT7M	HMK_VALUE_VALID_1FT7M

D:	VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAC949_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_VALUE_VALID_1FT7M

B:	VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	
        HMK_VALUE_VALID_1FT7M
    
C:	VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    UI-Geber, Geberauflösung und Geber über VT44

    DriveCliQ: ABU209
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
    VT_1FT7M_M00044	ZO Geber
    VT_1FT7M_M00066	ZO MLFB TempSensor KonfigTyp
        PMD_AAA717_001_000_1FT7M	HMK_TEMP_SENSOR_1FT7M	PMD_ABU209_001_000_1FT7M	MLFB12_1FT7M	HMK_KONFIG_TYP_1FT7M	HMK_VALUE_VALID_1FT7M
    */

    // Einschränkung auf UI_Geber, dann Auflösung, DriveCliq
    // Abschließend Bestimmung Geber ABU278

    // A: ----------------------------------------------------------------------------------------
    /*
    PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M				HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    //	var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    //	var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

    /*	var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
        var sTargetAttribute = "MLFB14_1FT7M";
        var sWhere = 	"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                        "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                        "HMK_VALUE_VALID_1FT7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
            return strError;
        }
    */
    // --------------------------------------------------------------------------------------------
    // Übernahme der Einschränkungen aus der MLFB12 für DRIVE_CLiQ
    // --------------------------------------------------------------------------------------------
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABU209_001_000_1FT7M", "MLFB12_1FT7M", "VT_1FT7M_M00066" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // Check, ob DRIVE-CLiQ erlaubt oder nicht
    if (ECL_GetAllActiveAttributeValues("MLFB12_1FT7M").length === 1) {
        ECL_ActivateValue("PMD_ABU209_001_000_1FT7M", "T");
        ECL_SelectValue("PMD_ABU209_001_000_1FT7M", "T");
        ECL_DeactivateValue("PMD_ABU209_001_000_1FT7M", "F");
        ECL_DisableAttribute("PMD_ABU209_001_000_1FT7M");
    }

    if (ECL_ValueActive("PMD_ABU209_001_000_1FT7M", "T")) {		// && ECL_ValueActive("PMD_ABU209_001_000_1FT7M", "F")
        ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FT7M", "T");
    }

    ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FT7M", "T")

    // weiter mit Vorgabe DQ
    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");

    // Setze MLFB12_1FT7M passend zur Auswahl DQ
    var sTargetAttribute = "MLFB12_1FT7M";
    var sTable = "VT_1FT7M_M00066" + sDB_Suffix;
    var sWhere = "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "HMK_KONFIG_TYP_1FT7M = 'KONFIG' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }

    // --------------------------------------------------------------------------------------------
    // gültige MLFB12 für weitere Abfragen
    // --------------------------------------------------------------------------------------------
    var aValidValues_MLFB12 = ECL_GetAllActiveAttributeValues("MLFB12_1FT7M");
    if (aValidValues_MLFB12 && aValidValues_MLFB12.length == 1) {
        var sWhereMLFB12 = "MLFB12_1FT7M = '" + aValidValues_MLFB12[0] + "' AND ";
    } else if (aValidValues_MLFB12 && aValidValues_MLFB12.length > 1) {
        var sWhereMLFB12 = "(MLFB12_1FT7M = '" + aValidValues_MLFB12[0] + "'";
        for (var i = 1; i < aValidValues_MLFB12.length; i++) {
            sWhereMLFB12 = sWhereMLFB12 + " OR MLFB12_1FT7M = '" + aValidValues_MLFB12[i] + "'";
        }
        sWhereMLFB12 = sWhereMLFB12 + ") AND ";
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_MLFB12_NO_VALID_VALUES";
        return strError;
    }
    // --------------------------------------------------------------------------------------------
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FT7M";
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        sWhereMLFB12 + //"MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +		// Drive-CLiQ muss hier einschränken (MLFB12_1FT7M), aber Bauform noch nicht!!!
        "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
        //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Übernahme der Einschränkungen aus der MLFB14 für Gebersystem
    /* VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M				HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABU278_001_000_1FT7M", "MLFB14_1FT7M", "VT_1FT7M_M00013" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    // Weitere Einschränkungen für Geber
    var sTargetAttribute = "PMD_ABU278_001_000_1FT7M";

    // B: ----------------------------------------------------------------------------------------
    /* VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	
        HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");	// 
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// 
    //var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// 
    var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");	// 

    var sTable = "VT_1FT7M_M00058" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        //"PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        //"HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // C: ----------------------------------------------------------------------------------------
    /*
    C: VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    //var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");	//

    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");
    // MLFB14_1FT7M
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");


    var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
    var sWhere = "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        //"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        //"HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
        //"MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // D: ----------------------------------------------------------------------------------------
    /*
    D: VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    //var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");	// 
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// 
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");	// 

    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        //"PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        //"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Geber 00020, 00021 (vernickelt) nur in Verbindung mit N16 oder N40!
    /*	var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");
        
        if (HMK_OPT_CHEM_BEST_1_1FT7M == "N40" || HMK_OPT_CHEM_BEST_2_1FT7M == "N16"){
            var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
            var sWhere = 	"HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
                            "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
                            "HMK_VALUE_VALID_1FT7M = 'T';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
                return strError;
            }
        }
    */
    // ----------------------------------------------------------------------------------------------------------------

    // ################################################################################################################


    // ----------------------------------------------------------------------------------------------------------------
    // Liste der noch gültigen Geber
    var aValidValues_Geber = ECL_GetAllActiveAttributeValues("PMD_ABU278_001_000_1FT7M");
    if (aValidValues_Geber.length == 1) {
        var sWhereGeber = "PMD_ABU278_001_000_1FT7M = '" + aValidValues_Geber[0] + "' AND ";
    } else if (aValidValues_Geber.length > 1) {
        var sWhereGeber = "(PMD_ABU278_001_000_1FT7M = '" + aValidValues_Geber[0] + "'";
        for (var i = 1; i < aValidValues_Geber.length; i++) {
            sWhereGeber = sWhereGeber + " OR PMD_ABU278_001_000_1FT7M = '" + aValidValues_Geber[i] + "'";
        }
        sWhereGeber = sWhereGeber + ") AND ";
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /* VT_1FT7M_M00044	ZO Geber
        PMD_ABU278_001_000_1FT7M	UI_GEBER_1FT7M		UI_GEBER_AUFLOESUNG_1FT7M	UI_DRIVECLIQ_1FT7M	
        PMD_ABU209_001_000_1FT7M	HMK_OPT_R72_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var HMK_OPT_R72_1FT7M = ECL_GetValue("HMK_OPT_R72_1FT7M");
    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Ausführung einschränken
    var sTable = "VT_1FT7M_M00044" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_1FT7M FROM " + sTable + " WHERE " +
        sWhereGeber +
        "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "HMK_OPT_R72_1FT7M = '" + HMK_OPT_R72_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_UI_GEBER");
    if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("UI_GEBER_1FT7M");
        for (var j = 0; j < aResult.length; j++) {
            ECL_ActivateValue("UI_GEBER_1FT7M", aResult[j].UI_GEBER_1FT7M);
        }
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_1FT7M", "");
    var UI_GEBER_1FT7M = ECL_GetValue("UI_GEBER_1FT7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Auflösung einschränken
    var sTable = "VT_1FT7M_M00044" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_AUFLOESUNG_1FT7M FROM " + sTable + " WHERE " +
        sWhereGeber +
        "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "UI_GEBER_1FT7M = '" + UI_GEBER_1FT7M + "' AND " +
        "HMK_OPT_R72_1FT7M = '" + HMK_OPT_R72_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_GEBER_AUFLOESUNG");
    if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("UI_GEBER_AUFLOESUNG_1FT7M");
        for (var j = 0; j < aResult.length; j++) {
            ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FT7M", aResult[j].UI_GEBER_AUFLOESUNG_1FT7M);
        }
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FT7M", "");
    var UI_GEBER_AUFLOESUNG_1FT7M = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FT7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bestimme Geber

    /* VT_1FT7M_M00044	ZO Geber
        PMD_ABU278_001_000_1FT7M	UI_GEBER_1FT7M		UI_GEBER_AUFLOESUNG_1FT7M	UI_DRIVECLIQ_1FT7M	
        PMD_ABU209_001_000_1FT7M	HMK_OPT_R72_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var UI_GEBER_1FT7M = ECL_GetValue("UI_GEBER_1FT7M");	// 
    var UI_GEBER_AUFLOESUNG_1FT7M = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FT7M");	// 
    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");	// 
    var HMK_OPT_R72_1FT7M = ECL_GetValue("HMK_OPT_R72_1FT7M");	// 

    var sTable = "VT_1FT7M_M00044" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABU278_001_000_1FT7M";
    var sWhere = "UI_GEBER_1FT7M = '" + UI_GEBER_1FT7M + "' AND " +
        "UI_GEBER_AUFLOESUNG_1FT7M = '" + UI_GEBER_AUFLOESUNG_1FT7M + "' AND " +
        "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "HMK_OPT_R72_1FT7M = '" + HMK_OPT_R72_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // Bestimmung MLFB14
    // ################################################################################################################
    /*
    VT_1FT7M_M00013
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
    var sSQL = "SELECT MLFB14_1FT7M FROM " + sTable + " WHERE " +
        "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);
    if (aResult.length > 0) {

        var MLFB14_1FT7M = aResult[0].MLFB14_1FT7M;

        sMLFB = replaceAt(sMLFB, 13, MLFB14_1FT7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB14_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Bauform gemäß Code I			PMD_AAC949_001_000_1FT7M 	(Flanschausführung)
    // ################################################################################################################
    /*
    VT_1FT7M_M00009	Bauform <> MLFB12						Übersetzung in MLFB nicht eindeutig, nur mit DriveCLiQ
        MLFB12_1FT7M	PMD_AAC949_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00050	ZO Bauform Img		n.n.
    
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00060	ZO K20 Motor,Bauform
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAC949_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_VALUE_VALID_1FT7M
    
    
    MLFB12
        VT_1FT7M_M00060
        VT_1FT7M_M00066	ZO MLFB TempSensor KonfigTyp
            PMD_AAA717_001_000_1FT7M	HMK_TEMP_SENSOR_1FT7M	PMD_ABU209_001_000_1FT7M	MLFB12_1FT7M	HMK_KONFIG_TYP_1FT7M	HMK_VALUE_VALID_1FT7M
        VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
            HMK_RUMPF_1FT7M		MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
    */
    // MLFB12 anhand Geber (MLFB14) einschränken
    var sTargetAttribute = "MLFB12_1FT7M";

    var MLFB14_1FT7M = ECL_GetValue("MLFB14_1FT7M");

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        //"PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB14_NO_DB_RESULT";
        return strError;
    }

    //Einschränkung aus MLFB12 übertragen
    var sStatus = SetAttributeLogicFromMLFB("PMD_AAC949_001_000_1FT7M", "MLFB12_1FT7M", "VT_1FT7M_M00009" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // --------------------------------------------------------------------------------------------------------------
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");	// AH
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// Motortyp

    var sTable = "VT_1FT7M_M00060" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAC949_001_000_1FT7M";
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// Kühlung
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// Geber
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// Schutzart
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");	// EdelstahlWelle

    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAC949_001_000_1FT7M";
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }


    // ################################################################################################################
    // Aktualisierung MLFB12
    // ################################################################################################################
    var sTargetAttribute = "MLFB12_1FT7M";
    /**
    VT_1FT7M_M00009	Bauform <> MLFB12						Übersetzung in MLFB nicht eindeutig, nur mit DriveCLiQ
        MLFB12_1FT7M	PMD_AAC949_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    VT_1FT7M_M00066	ZO MLFB TempSensor KonfigTyp
        PMD_AAA717_001_000_1FT7M	HMK_TEMP_SENSOR_1FT7M	PMD_ABU209_001_000_1FT7M	MLFB12_1FT7M	HMK_KONFIG_TYP_1FT7M	HMK_VALUE_VALID_1FT7M
        
    // VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
    //	HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");	// Bauform
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// Anordnung Stecker
    var PMD_ABU209_001_000_1FT7M = ECL_GetValue("PMD_ABU209_001_000_1FT7M");	// DRIVE-CLiQ


    var sTable = "VT_1FT7M_M00009" + sDB_Suffix;
    var sWhere = "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }

    var sTable = "VT_1FT7M_M00066" + sDB_Suffix;
    var sWhere = "PMD_ABU209_001_000_1FT7M = '" + PMD_ABU209_001_000_1FT7M + "' AND " +
        "HMK_KONFIG_TYP_1FT7M = 'KONFIG' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }

    MLFB12_1FT7M = ECL_GetValue("MLFB12_1FT7M");
    sMLFB = replaceAt(sMLFB, 11, MLFB12_1FT7M);
    ECL_SetValue("ECSI_MLFB", sMLFB);

    // ################################################################################################################


    // ################################################################################################################
    // Anordnung des elektrischen Anschlusses			PMD_AAB047_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00101		MLFB13 <> Anord.el.Anschluss						zur Übersetzung in MLFB13, PLUS Logik
        MLFB13_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M				
    
    VT_1FT7M_M00103	elAnschl <> Baugr.Stecker
        PMD_AAB047_001_000_1FT7M	PMD_ABV400_001_000_1FT7M	HMK_SZ_ANSCHLUSS_ART_1FT7M	HMK_VALUE_VALID_1FT7M
    
    A: VT_1FT7M_M00079	ZO L13 Motor,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	
        PMD_ABV400_001_000_1FT7M	HMK_OPT_L13_1FT7M	HMK_VALUE_VALID_1FT7M

    B: VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_VALUE_VALID_1FT7M

    A1: VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    D: VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

n.n.	VT_1FT7M_M00045	ZO AnschlTechnik
n.n.	VT_1FT7M_M00076	EDZ - Anschlusstechnik

    
    MLFB13
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
    */
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sTargetAttribute = "MLFB13_1FT7M";
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    var sStatus = SetAttributeLogicFromMLFB("PMD_AAB047_001_000_1FT7M", "MLFB13_1FT7M", "VT_1FT7M_M00101" + sDB_Suffix)
    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------


    var sTargetAttribute = "PMD_AAB047_001_000_1FT7M";
    // A0 ------------------------------------------------------------------------------------------------------------
    /*
    VT_1FT7M_M00103	elAnschl <> Baugr.Stecker
        PMD_AAB047_001_000_1FT7M	PMD_ABV400_001_000_1FT7M	HMK_SZ_ANSCHLUSS_ART_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABV400_001_000_1FT7M = ECL_GetValue("PMD_ABV400_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00103" + sDB_Suffix;
    var sWhere = "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // A1 ------------------------------------------------------------------------------------------------------------
    /*
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var aL03_L06 = ECL_GetAllActiveAttributeValues("HMK_OPT_L03_L06_1FT7M");

    var sWhere_L03_L06 = "(HMK_OPT_L03_L06_1FT7M = '" + aL03_L06[0] + "'";
    if (aL03_L06 && aL03_L06.length > 0) {
        for (var i = 1; i < aL03_L06.length; i++) {
            sWhere_L03_L06 = sWhere_L03_L06 + " OR HMK_OPT_L03_L06_1FT7M = '" + aL03_L06[i] + "'";
        }
    }
    sWhere_L03_L06 = sWhere_L03_L06 + ") AND ";

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        sWhere_L03_L06 +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // A ------------------------------------------------------------------------------------------------------------
    /*
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	
        PMD_ABV400_001_000_1FT7M	HMK_OPT_L13_1FT7M	HMK_VALUE_VALID_1FT7M
    */

    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");	// 
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00079" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // B -------------------------------------------------------------------------------------------------------------
    /*
    B: VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

    var sTable = "VT_1FT7M_M00058" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // C -------------------------------------------------------------------------------------------------------------
    /*
    D: VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");

    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // D -------------------------------------------------------------------------------------------------------------
    /*
    C: VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    * /
    //var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");
    
    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAB047_001_000_1FT7M";
    var sWhere = 	"HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                    "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
                    //"MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +	// MLFB13 darf nicht in die Bedingung, da es das behandelte Attribut repräsentiert!
                    "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +	
                    //"HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FT7M___PLVT_E_ANSCHLUSS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    */
    // ################################################################################################################

    // ################################################################################################################
    // Bestimmung MLFB13
    // ################################################################################################################
    /*	
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    
    VT_1FT7M_M00101	MLFB13 <> Anord.el.Anschluss								zur Übersetzung in MLFB13, keine Logik
        MLFB13_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */

    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");

    // MLFB13 Einschränken oder InnerJoin
    var sTargetAttribute = "MLFB13_1FT7M";

    var sTable = "VT_1FT7M_M00101" + sDB_Suffix;
    var sWhere = "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB13_NO_DB_RESULT";
        return strError;
    }

    var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB13_NO_DB_RESULT";
        return strError;
    }


    var aMLFB13_1FT7M = ECL_GetAllActiveAttributeValues("MLFB13_1FT7M");

    if (aMLFB13_1FT7M.length > 0) {

        var MLFB13_1FT7M = aMLFB13_1FT7M[0];//.MLFB13_1FT7M;

        sMLFB = replaceAt(sMLFB, 12, MLFB13_1FT7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FT7M___PLVT_BESTIMMUNG_MLFB13_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    // ################################################################################################################

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTI
    // OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTI
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    // ################################################################################################################
    // Ausführung (Farbe)			HMK_AUSFUEHR_K23_K24_1FT7M
    // ################################################################################################################
    /*
    VT_1FT7M_M00053		ZO N16 <> K23, K24
        HMK_OPT_CHEM_BEST_2_1FT7M	HMK_AUSFUEHR_K23_K24_1FT7M	HMK_VALUE_VALID_1FT7M
    
    00001	Lackierung
    K24		Grundierung (ohne Lackierung)
    K23		Sonderlackierung Worldwide (Lackierung mit Grundierung)


    VT_1FT7M_M00064	ZO Farbe X01..X59
        PMD_AAD756_001_000_1FT7M	HMK_FARBE_I_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sTargetAttribute = "HMK_AUSFUEHR_K23_K24_1FT7M";

    // EDIT 05.2023 DriveTrain K24 fix, no color selection possible
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['K24'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_FARBE_NO_DB_RESULT";
            return strError;
        }
    } else {

        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        var sTable = "VT_1FT7M_M00053" + sDB_Suffix;
        var sWhere = "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_FARBE_NO_DB_RESULT";
            return strError;
        }
    }
    var HMK_AUSFUEHR_K23_K24_1FT7M = ECL_GetValue("HMK_AUSFUEHR_K23_K24_1FT7M");

    if (HMK_AUSFUEHR_K23_K24_1FT7M == "K24") {
        // Grundierung, keine Lackierung
        // ==> Farbe_I_ ausblenden	<== Abbildung mit PMD-Attribut
        //ECL_DeactivateAttribute("PMD_AAD756_001_000_1FT7M");
        ECL_DeactivateAllAttributeValues("PMD_AAD756_001_000_1FT7M");
        ECL_ActivateValue("PMD_AAD756_001_000_1FT7M", "00003");
        ECL_SetValue("PMD_AAD756_001_000_1FT7M", "00003"); // Ohne

        // Farbe_II einblenden	<== Abbildung mit PMD-Attribut
        //ECL_ActivateAttribute("HMK_FARBE_II_1FT7M");
        //ECL_SetValue("HMK_FARBE_II_1FT7M", "00001");
    } else {
        // ==> Farbe_I einblenden
        //ECL_ActivateAttribute("PMD_AAD756_001_000_1FT7M");
        ECL_ActivateAllAttributeValues("PMD_AAD756_001_000_1FT7M");
        ECL_DeactivateValue("PMD_AAD756_001_000_1FT7M", "00003");

        // Farbe_II ausblenden
        //ECL_DeactivateAttribute("HMK_FARBE_II_1FT7M");	
    }
    // ################################################################################################################

    // ################################################################################################################
    // Farbe		PMD_AAD756_001_000_1FT7M	
    // ################################################################################################################
    /*
    VT_1FT7M_M00064		ZO Farbe X01..X59
        PMD_AAD756_001_000_1FT7M	HMK_FARBE_I_1FT7M	HMK_VALUE_VALID_1FT7M
    
    00001 STD
    00003 OHNE
    X01...Xnn
    */

    if (HMK_AUSFUEHR_K23_K24_1FT7M != "K24") {
        var sTable = "VT_1FT7M_M00064" + sDB_Suffix;
        var sTargetAttribute = "PMD_AAD756_001_000_1FT7M";
        var sWhere = "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_FARBE_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################

    // ################################################################################################################
    // Äusserer Erdungsanschluss		HMK_OPT_L13_1FT7
    // ################################################################################################################
    /*
    VT_1FT7M_M00079	ZO L13 Motor,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	
        PMD_ABV400_001_000_1FT7M	HMK_OPT_L13_1FT7M	HMK_VALUE_VALID_1FT7M

    n.n. VT_1FT7M_M00074	EDZ - Erdungsanschluss <--- EPLAN 
    */
    var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");
    var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");
    var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");
    var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");
    var PMD_ABV400_001_000_1FT7M = ECL_GetValue("PMD_ABV400_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00079" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_L13_1FT7M";
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_ERDUNG_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Verstärkte Lagerung			HMK_OPT_K20_1FT7
    // ################################################################################################################
    /*
    VT_1FT7M_M00060	ZO K20 Motor,Bauform
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAC949_001_000_1FT7M	
        HMK_OPT_K20_1FT7M	HMK_VALUE_VALID_1FT7M
    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M

    */
    var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");

    var sTable = "VT_1FT7M_M00060" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_K20_1FT7M";
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_K20_NO_DB_RESULT";
        return strError;
    }
    // ---------------------------------------------------------------------------------------
    var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");

    var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_K20_1FT7M";
    var sWhere = "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_K20_NO_DB_RESULT";
        return strError;
    }
    // ---------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_K20_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################






    // ################################################################################################################
    // Abnahmeprüfzeugnis			HMK_OPT_B02_1FT7
    // ################################################################################################################
    /*
    kein Vorkommen in DTK-VTs
    */
    // ################################################################################################################


    // ################################################################################################################
    // Inkrementalgeber			HMK_OPT_R72_1FT7M		R72
    // ################################################################################################################
    /*      ==> nicht bei Konfiguration wählbar!
    VT_1FT7M_M00044	ZO Geber
        PMD_ABU278_001_000_1FT7M	UI_GEBER_1FT7M	UI_GEBER_AUFLOESUNG_1FT7M	UI_DRIVECLIQ_1FT7M	PMD_ABU209_001_000_1FT7M	
        HMK_OPT_R72_1FT7M	HMK_VALUE_VALID_1FT7M
    * /
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 
    
    var sTable = "VT_1FT7M_M00044" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_R72_1FT7M";
    var sWhere = 	"PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FT7M___PLVT_INKREMENTALGEBER_NO_DB_RESULT";
        return strError;
    }*/
    // ################################################################################################################


    // ################################################################################################################
    // Haltebremse mit reduziertem Trägheitsmoment		HMK_OPT_N27_1FT7M	N27
    // ################################################################################################################
    /*
    VT_1FT7M_M00047	Opt. Haltebremse mit reduz. Trägheitsmom
        HMK_BAUGROESSE_1FT7M	MLFB08_1FT7M	MLFB11_1FT7M	MLFB12_1FT7M	MLFB14_1FT7M	MLFB16_1FT7M	
        HMK_OPT_N27_1FT7

n.n.	VT_1FT7M_M00048	techn.Daten Haltebremse
    */
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00047" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_N27_1FT7M";
    var sWhere = "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
        "MLFB08_1FT7M = '" + MLFB08_1FT7M + "' AND " +
        "MLFB11_1FT7M = '" + MLFB11_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
        "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
        "MLFB16_1FT7M = '" + MLFB16_1FT7M + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_BREMSE_RED_TRAEGHEIT_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Sonderausführung Wellenende: SIMOTICS S-1FT5 kompatibel 	PMD_AAD427_001_000_1FT7M		N05
    // ################################################################################################################
    var sTargetAttribute = "PMD_AAD427_001_000_1FT7M";
    /*
    A: VT_1FT7M_M00085	ZO Wellenabmessungen N05		Bestimmung der Abmessungen
        HMK_RUMPF_1FT7M	HMK_AUFBAU_WELLE_1FT7M	PMD_AAD427_001_000_1FT7

NEU: B: VT_1FT7M_M00083		MLFB Wellenende N05
        HMK_RUMPF_1FT7M		MLFB12_1FT7M	PMD_AAD427_001_000_1FT7M	HMK_VALUE_VALID_1FT7M

    C: VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    // A: -------------------------------------------------------------------------------------
    var sTable = "VT_1FT7M_M00085" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    // B: -------------------------------------------------------------------------------------
    /* VT_1FT7M_M00083	N05 MLFB
        HMK_RUMPF_1FT7M		MLFB12_1FT7M	PMD_AAD427_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00083" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    // C: ---------------------------------------------------------------------------------------
    /* VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");
    var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
    var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

    var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
    var sWhere = "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "' AND " +
        "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
        "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    if (ECSI_CX_IsDriveTrain == 1 || ECSI_CX_GearboxMotorCoupling == 1) {

        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_AUFBAU_WELLE_1FT7M	Wellenende D x Länge
    // ################################################################################################################
    /*
    VT_1FT7M_M00085	ZO Wellenabmessungen N05		Bestimmung der Abmessungen
        HMK_RUMPF_1FT7M	HMK_AUFBAU_WELLE_1FT7M	PMD_AAD427_001_000_1FT7
    */
    var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00085" + sDB_Suffix;
    var sTargetAttribute = "HMK_AUFBAU_WELLE_1FT7M";
    var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
        "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_WELLENENDE_SONDER_DIM_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Kundenangabe auf dem Leistungsschild 		HMK_OPT_Y84_1FT7M		Y84
    // ################################################################################################################
    /*
    kein Vorkommen in DTK-VTs
    
    HMK_OPT_Y84_TXT_1FT7M	Kundenangabe auf dem Leistungsschild (Textfeld)
    */

    if (ECL_ValueEnabled("HMK_OPT_Y84_1FT7M", "Y84")) {
        ECL_ActivateAttribute("HMK_OPT_Y84_TXT_1FT7M");
    } else {
        ECL_DeactivateAttribute("HMK_OPT_Y84_TXT_1FT7M");
    }

    if (strchangedAttribute == "HMK_OPT_Y84_TXT_1FT7M") {
        var sValueNorm = normalizeOE_Attribute("HMK_OPT_Y84_TXT_1FT7M");
        if (sValueNorm == "") {
            ECL_SetValue("HMK_OPT_Y84_1FT7M", "F");
        } else {
            ECL_SetValue("HMK_OPT_Y84_1FT7M", "Y84");
        }
    }

    // ################################################################################################################

    // ################################################################################################################
    // Sperrluftanschluss			HMK_OPT_Q12_1FT7M		Q12
    // ################################################################################################################
    /*
    VT_1FT7M_M00057	ZO Motor Q12
        PMD_AAA259_001_000_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_OPT_Q12_1FT7M	HMK_VALUE_VALID_1FT7M

    VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    n.n. VT_1FT7M_M00077	EDZ - Sperrluftanschluss EPLAN
    
    VT_1FT7M_M00110	ZO L03 L06 Q12				<==== keine rückwirkende Einschränkung!
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
    */
    var sTargetAttribute = "HMK_OPT_Q12_1FT7M";

    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_SPERRLUFT_NO_DB_RESULT";
            return strError;
        }
    } else {

        var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
        var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// 

        var sTable = "VT_1FT7M_M00057" + sDB_Suffix;
        var sWhere = "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
            "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_SPERRLUFT_NO_DB_RESULT";
            return strError;
        }
        // --------------------------------------------------------------------------------------------------
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");	// 
        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");	// 

        var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
        var sWhere = "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_SPERRLUFT_NO_DB_RESULT";
            return strError;
        }
        // --------------------------------------------------------------------------------------------------
        /* VT_1FT7M_M00110	ZO L03 L06 Q12						<==== keine rückwirkende Einschränkung!
            HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
        */
        var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

        var sTable = "VT_1FT7M_M00110" + sDB_Suffix;
        var sWhere = "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_SPERRLUFT_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################

    // ################################################################################################################
    // Ausführung des Steckers			HMK_OPT_L03_L06_1FT7M
    // ################################################################################################################
    /*
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
    VT_1FT7M_M00110	ZO L03 L06 Q12
    VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
    VT_1FT7M_M00119	ZO Rumpf MLFB -- L03, L06

    VT_1FT7M_M00128	Bugrosse_stecker_L03
    

    
    A: VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
        
        alt 63
        HMK_BAUGROESSE_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    B: VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    C: VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        
    D: VT_1FT7M_M00110	ZO L03 L06 Q12 
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
    
    E: VT_1FT7M_M00119	ZO Rumpf MLFB -- L03, L06
        HMK_RUMPF_1FT7M HMK_OPT_L03_L06_1FT7M

    F: VT_1FT7M_M00128	Bugrosse_stecker_L03
        PMD_ABV400_001_000_1FT7M    HMK_OPT_L03_L06_1FT7M   HMK_VALUE_VALID_1FT7M
    */
    // A: ---------------------------------------------------------------------------------------
    /*A: VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
        HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sTargetAttribute = "HMK_OPT_L03_L06_1FT7M";

    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['NON'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
    } else {

        var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// 

        var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
        var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
            "MLFB12_1FT7M = '" + MLFB12_1FT7M + "' AND " +
            //"MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
            "MLFB14_1FT7M = '" + MLFB14_1FT7M + "' AND " +
            "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
        // B: ---------------------------------------------------------------------------------------
        /* B: VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
            PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
            HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
        var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");

        var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
        var sWhere = "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T' AND " +
            "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
        // C: ---------------------------------------------------------------------------------------
        /* C: VT_1FT7M_M00061	ZO L03 L06 N16 N40
            HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
        var sWhere = "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
        // D: ---------------------------------------------------------------------------------------
        /* D: VT_1FT7M_M00110	ZO L03 L06 Q12	
            HMK_OPT_L03_L06_1FT7M	HMK_OPT_Q12_1FT7M
        */
        var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");

        var sTable = "VT_1FT7M_M00110" + sDB_Suffix;
        var sWhere = "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
        // E: ---------------------------------------------------------------------------------------
        /* E: VT_1FT7M_M00119	ZO Rumpf MLFB -- L03, L06
                HMK_RUMPF_1FT7M HMK_OPT_L03_L06_1FT7M
        */
        var sTable = "VT_1FT7M_M00119" + sDB_Suffix;
        var sWhere = "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }

        // F: ---------------------------------------------------------------------------------------
        /* F: VT_1FT7M_M00128	Bugrosse_stecker_L03
                PMD_ABV400_001_000_1FT7M    HMK_OPT_L03_L06_1FT7M   HMK_VALUE_VALID_1FT7M
        */
        var sTable = "VT_1FT7M_M00128" + sDB_Suffix;
        var sWhere = "PMD_ABV400_001_000_1FT7M = '" + PMD_ABV400_001_000_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_STECKER_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################

    // ################################################################################################################
    // Abgang Lüfterstecker			HMK_OPT_Q41_42_43_44_1FT7M		Q41...Q44
    // ################################################################################################################
    /*
    VT_1FT7M_M00118
        HMK_BAUGROESSE_1FT7M    MLFB09_1FT7M    MLFB13_1FT7M    HMK_OPT_Q41_42_43_44_1FT7M  HMK_VALUE_VALID_1FT7M
    
todo ?	Abhängig von MLFB13 / Anordnung des elektrischen Anschlusses (Steckerabgangsrichtung/Klemmkasten)
    über VT24 und HMK-Baugröße, Q41...Q44 nur für BGR 117 zulässig
    */
    var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// 

    var sTable = "VT_1FT7M_M00118" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_Q41_42_43_44_1FT7M";
    var sWhere = "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
        "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
        "MLFB13_1FT7M = '" + MLFB13_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_ABGANG_LUEFTERSTECKER_NO_DB_RESULT";
        return strError;
    }
    // ---------------------------------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['-'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_ABGANG_LUEFTERSTECKER_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################

    // ################################################################################################################
    // Kundenspezifische Zusatzabdichtung			HMK_OPT_Q13_1FT7M	Q13
    // ################################################################################################################
    /*
    VT_1FT7M_M00054	ZO Q13 MLFB.09 Schutzart
        HMK_OPT_Q13_1FT7M	MLFB09_1FT7M	PMD_ABJ176_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sTable = "VT_1FT7M_M00054" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_Q13_1FT7M";
    var sWhere = "MLFB09_1FT7M = '" + MLFB09_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_ZUSATZDICHTUNG_NO_DB_RESULT";
        return strError;
    }
    // ---------------------------------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_ZUSATZDICHTUNG_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // Ausführung für erhöhte chemische Beständigkeit			HMK_OPT_CHEM_BEST_2_1FT7M	N16
    // ################################################################################################################
    /*
    Beachte: Wenn Geber 00020 (MLFB14 = B) oder 00021 (MLFB14 = C), ist entweder N16 oder N40 pflicht! 
    
    
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
    VT_1FT7M_M00053	ZO N16 <> K23, K24
    VT_1FT7M_M00056	ZO Q12 N16 N40
    VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
    n.n.	VT_1FT7M_M00072	EDZ - Gebersysteme

    
    A: VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_VALUE_VALID_1FT7M
    B: VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    n.n.VT_1FT7M_M00072	EDZ - Gebersysteme
    C: VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M

    D: VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    E: VT_1FT7M_M00053		ZO N16 <> K23, K24
        HMK_OPT_CHEM_BEST_2_1FT7M	HMK_AUSFUEHR_K23_K24_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    // A: ----------------------------------------------------------------------------------------
    /* VT_1FT7M_M00058	ZO N19 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sTargetAttribute = "HMK_OPT_CHEM_BEST_2_1FT7M";

    // Edit 05.2023 DriveTrain: N16 not allowed
    if (ECSI_CX_IsDriveTrain == 1) {
        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        var bValValidChemBest2 = false;

    } else {
        var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");	// 
        var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
        var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// 
        var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// 
        var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 

        var sWhereGeberNickel = "";
        if (PMD_ABU278_001_000_1FT7M != "00020" && PMD_ABU278_001_000_1FT7M != "00021") {
            sWhereGeberNickel = "PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND ";
        }

        var sTable = "VT_1FT7M_M00058" + sDB_Suffix;
        var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
            "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
            "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
            "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
            sWhereGeberNickel +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        // B: ---------------------------------------------------------------------------------------
        /* VT_1FT7M_M00056	ZO Q12 N16 N40
            HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");	// 
        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");	// 

        var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
        var sWhere = "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        // C: ---------------------------------------------------------------------------------------
        /* C: VT_1FT7M_M00061	ZO L03 L06 N16 N40
            HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

        var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
        var sWhere = "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        // D: ---------------------------------------------------------------------------------------
        /* D: VT_1FT7M_M00013	Geberanschluss <> MLFB14
            PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
            MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        //var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");

        var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
        var sWhere = sWhereGeberNickel +
            "HMK_OPT_CHEM_BEST_1_1FT7M = '" + HMK_OPT_CHEM_BEST_1_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        // E: ---------------------------------------------------------------------------------------
        /*E: VT_1FT7M_M00053		ZO N16 <> K23, K24
            HMK_OPT_CHEM_BEST_2_1FT7M	HMK_AUSFUEHR_K23_K24_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var HMK_AUSFUEHR_K23_K24_1FT7M = ECL_GetValue("HMK_AUSFUEHR_K23_K24_1FT7M");

        var sTable = "VT_1FT7M_M00053" + sDB_Suffix;
        var sWhere = "HMK_AUSFUEHR_K23_K24_1FT7M = '" + HMK_AUSFUEHR_K23_K24_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################
        if (ECL_ValueActive("PMD_ABU278_001_000_1FT7M", "00020")) {
            var sGeber = "00020";
        } else if (ECL_ValueActive("PMD_ABU278_001_000_1FT7M", "00021")) {
            var sGeber = "00021";
        }
        var bGeberNickel = false;
        if (sGeber) {
            // Prüfen ob N16
            if (ECL_ValueActive("HMK_OPT_CHEM_BEST_2_1FT7M", "N16")) {
                bGeberNickel = true;
            }
        }

        // A: mit Geber:
        var sTable = "VT_1FT7M_M00058" + sDB_Suffix;
        var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
            "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
            "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
            "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
            sWhereGeberNickel +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_2_NO_DB_RESULT";
            return strError;
        }
        var bValValidChemBest2 = ECL_ValueActive("HMK_OPT_CHEM_BEST_2_1FT7M", "N16");
    }
    // ################################################################################################################
    // Edelstahlwelle und Beschichtung für erhöhte chemische Beständigkeit		HMK_OPT_CHEM_BEST_1_1FT7M	N40
    // ################################################################################################################
    /*
    VT_1FT7M_M00013	Geberanschluss <> MLFB14
    VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
    VT_1FT7M_M00056	ZO Q12 N16 N40
    VT_1FT7M_M00061	ZO L03 L06 N16 N40
    VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
    n.n.	VT_1FT7M_M00072	EDZ - Gebersysteme


    A: VT_1FT7M_M00056	ZO Q12 N16 N40
        HMK_OPT_Q12_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    n.n.	VT_1FT7M_M00072	EDZ - Gebersysteme
    B: VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
        PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
        HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
    C: VT_1FT7M_M00061	ZO L03 L06 N16 N40
        HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    D: VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
        PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
        PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
        PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
    E: VT_1FT7M_M00013	Geberanschluss <> MLFB14
        PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
        MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
    */
    var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";

    // ---------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1) {

        var aValidValues = ['F'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
    } else {

        // A: ---------------------------------------------------------------------------------------
        var HMK_OPT_Q12_1FT7M = ECL_GetValue("HMK_OPT_Q12_1FT7M");	// 
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");	// 

        var sTable = "VT_1FT7M_M00056" + sDB_Suffix;
        var sWhere = "HMK_OPT_Q12_1FT7M = '" + HMK_OPT_Q12_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
        // B: ---------------------------------------------------------------------------------------
        /* VT_1FT7M_M00062	ZO L03 L06 N05 K20 N40
            PMD_AAD427_001_000_1FT7M	HMK_OPT_K20_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	
            HMK_OPT_L03_L06_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var PMD_AAD427_001_000_1FT7M = ECL_GetValue("PMD_AAD427_001_000_1FT7M");
        var HMK_OPT_K20_1FT7M = ECL_GetValue("HMK_OPT_K20_1FT7M");
        var HMK_OPT_L03_L06_1FT7M = ECL_GetValue("HMK_OPT_L03_L06_1FT7M");

        var sTable = "VT_1FT7M_M00062" + sDB_Suffix;
        var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
        var sWhere = "PMD_AAD427_001_000_1FT7M = '" + PMD_AAD427_001_000_1FT7M + "' AND " +
            "HMK_OPT_K20_1FT7M = '" + HMK_OPT_K20_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T' AND " +
            "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
        // C: ---------------------------------------------------------------------------------------
        /* VT_1FT7M_M00061	ZO L03 L06 N16 N40
            HMK_OPT_L03_L06_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        //var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        var sTable = "VT_1FT7M_M00061" + sDB_Suffix;
        var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
        var sWhere = "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_OPT_L03_L06_1FT7M = '" + HMK_OPT_L03_L06_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
        // D: ---------------------------------------------------------------------------------------
        /* VT_1FT7M_M00055	ZO N40 Motor,Geber,Anschluss
            PMD_ABP663_001_000_1FT7M	PMD_AAA259_001_000_1FT7M	PMD_AAA136_001_000_1FT7M	
            PMD_AAC949_001_000_1FT7M	PMD_AAB047_001_000_1FT7M	PMD_ABU278_001_000_1FT7M	
            PMD_ABJ176_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var PMD_ABP663_001_000_1FT7M = ECL_GetValue("PMD_ABP663_001_000_1FT7M");	// 
        var PMD_AAA259_001_000_1FT7M = ECL_GetValue("PMD_AAA259_001_000_1FT7M");	// 
        var PMD_AAA136_001_000_1FT7M = ECL_GetValue("PMD_AAA136_001_000_1FT7M");	// 
        var PMD_AAC949_001_000_1FT7M = ECL_GetValue("PMD_AAC949_001_000_1FT7M");	// 
        var PMD_AAB047_001_000_1FT7M = ECL_GetValue("PMD_AAB047_001_000_1FT7M");	// 
        //var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");	// 
        var PMD_ABJ176_001_000_1FT7M = ECL_GetValue("PMD_ABJ176_001_000_1FT7M");	// 
        //var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");	// 

        var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
        var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
        var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
            "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
            "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
            "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
            "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
            sWhereGeberNickel +
            //"PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
            "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
        // E: ---------------------------------------------------------------------------------------
        /* E: VT_1FT7M_M00013	Geberanschluss <> MLFB14
            PMD_ABU209_001_000_1FT7M	HMK_OPT_CHEM_BEST_1_1FT7M	HMK_OPT_CHEM_BEST_2_1FT7M	PMD_ABU278_001_000_1FT7M	
            MLFB14_1FT7M	HMK_ABSOLUTW_MULTI_1FT7M	HMK_VALUE_VALID_1FT7M
        */
        var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
        //var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        var sTable = "VT_1FT7M_M00013" + sDB_Suffix;
        var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
        var sWhere = sWhereGeberNickel +
            //"PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
            "HMK_OPT_CHEM_BEST_2_1FT7M = '" + HMK_OPT_CHEM_BEST_2_1FT7M + "' AND " +
            "HMK_VALUE_VALID_1FT7M = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################

    /*if (ECL_ValueActive("PMD_ABU278_001_000_1FT7M", "00020")){
        var sGeber = "00020";
    }else if (ECL_ValueActive("PMD_ABU278_001_000_1FT7M", "00021")){
        var sGeber = "00021";
    }
    */
    if (sGeber) {
        // Prüfen ob N40
        if (ECL_ValueActive("HMK_OPT_CHEM_BEST_1_1FT7M", "N40")) {
            bGeberNickel = true;
        }
    }

    // D: mit Geber:
    var sTable = "VT_1FT7M_M00055" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_CHEM_BEST_1_1FT7M";
    var sWhere = "PMD_ABP663_001_000_1FT7M = '" + PMD_ABP663_001_000_1FT7M + "' AND " +
        "PMD_AAA259_001_000_1FT7M = '" + PMD_AAA259_001_000_1FT7M + "' AND " +
        "PMD_AAA136_001_000_1FT7M = '" + PMD_AAA136_001_000_1FT7M + "' AND " +
        "PMD_AAC949_001_000_1FT7M = '" + PMD_AAC949_001_000_1FT7M + "' AND " +
        "PMD_AAB047_001_000_1FT7M = '" + PMD_AAB047_001_000_1FT7M + "' AND " +
        sWhereGeberNickel +
        //"PMD_ABU278_001_000_1FT7M = '" + PMD_ABU278_001_000_1FT7M + "' AND " +
        "PMD_ABJ176_001_000_1FT7M = '" + PMD_ABJ176_001_000_1FT7M + "' AND " +
        "HMK_VALUE_VALID_1FT7M = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FT7M___PLVT_CHEM_BEST_1_NO_DB_RESULT";
        return strError;
    }


    // ################################################################################################################
    var bValValidChemBest1 = ECL_ValueActive("HMK_OPT_CHEM_BEST_1_1FT7M", "N40");


    // Geber vernickelt (00020, 00021) MLFB14 B, C 
    // erforern entweder N16 oder N40

    var PMD_ABU278_001_000_1FT7M = ECL_GetValue("PMD_ABU278_001_000_1FT7M");
    if (PMD_ABU278_001_000_1FT7M == "00020" || PMD_ABU278_001_000_1FT7M == "00021") {

        var HMK_OPT_CHEM_BEST_1_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_1_1FT7M");
        var HMK_OPT_CHEM_BEST_2_1FT7M = ECL_GetValue("HMK_OPT_CHEM_BEST_2_1FT7M");

        if (HMK_OPT_CHEM_BEST_1_1FT7M == "F" && HMK_OPT_CHEM_BEST_2_1FT7M == "F") {
            if (bValValidChemBest2) {
                ECL_SetValue("HMK_OPT_CHEM_BEST_2_1FT7M", "N16");
                if (bValValidChemBest1) {
                    ECL_ActivateValue("HMK_OPT_CHEM_BEST_1_1FT7M", "N40");
                }
            } else {
                ECL_SetValue("HMK_OPT_CHEM_BEST_1_1FT7M", "N40");
                if (bValValidChemBest2) {
                    ECL_ActivateValue("HMK_OPT_CHEM_BEST_2_1FT7M", "N16");
                }
            }
        } else if (HMK_OPT_CHEM_BEST_1_1FT7M == "N40") {
            ECL_ActivateValue("HMK_OPT_CHEM_BEST_2_1FT7M", "N16");
        } else if (HMK_OPT_CHEM_BEST_2_1FT7M == "N16") {
            ECL_ActivateValue("HMK_OPT_CHEM_BEST_1_1FT7M", "N40");
        }
    }

    // ################################################################################################################

    // Prüfen, ob Geber 20,21 ausgewählt werden dürfen
    if (!(bGeberNickel)) {
        ECL_DeactivateValue("PMD_ABU278_001_000_1FT7M", sGeber);
    }
    // ################################################################################################################


    // ################################################################################################################
    // Abnahmeprüfzeugnis	 HMK_OPT_B02_1FT7M 
    // ################################################################################################################
    if (ECSI_CX_IsDriveTrain == 1) {
        ECL_DeactivateValue("HMK_OPT_B02_1FT7M", "B02");
        ECL_SelectValue("HMK_OPT_B02_1FT7M", "F");
    }
    // ################################################################################################################


    // ################################################################################################################
    // GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    // GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    // ################################################################################################################
    /* 
    Mit/Ohne Getriebe 
    
    Bestimmung des Getriebes im Parser. Feste Vorgabe durch SIZER / KAG in BaseType
    
    HMK_OPT_GETRIEBE_1FT7
    * /
    // ################################################################################################################
    // Set info parameters of gear
    // ################################################################################################################
    /*
    HMK_ACB729_1FT7M	Flanschgröße (D1)
    HMK_ACB772_1FT7M	Zentrierrand (D3)
    HMK_ACB789_1FT7M	Lochkreis (D4)
    HMK_ACB769_1FT7M	Durchmesser der Welle (D2)
    HMK_ACB783_1FT7M	Länge der Welle (L)

    */
    // VT_1FT7M_M00107
    // 	PMD_ABV410_001_000_1FT7M	HMK_ACB729_1FT7M	HMK_ACB772_1FT7M	HMK_ACB789_1FT7M	HMK_ACB769_1FT7M	HMK_ACB783_1FT7M


    var HMK_KONFIG_ZIEL_1FT7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FT7M");
    var PMD_ABV410_001_000_1FT7M = ECL_GetValue("PMD_ABV410_001_000_1FT7M");

    if (HMK_KONFIG_ZIEL_1FT7M == "P_GEAR") {
        // Getriebe einblenden
        ECL_ActivateAttribute("PMD_ABV410_001_000_1FT7M"); // Bezeichnung Getriebe
        ECL_ActivateAttribute("HMK_UEBERSETZ_STUFE_1FT7M"); // Übersetzung + Stufigkeit
        ECL_ActivateAttribute("PMD_ABV414_001_000_1FT7M"); // Wellenende

        ECL_ActivateAttribute("HMK_ACB729_1FT7M");
        ECL_ActivateAttribute("HMK_ACB772_1FT7M");
        ECL_ActivateAttribute("HMK_ACB789_1FT7M");
        ECL_ActivateAttribute("HMK_ACB769_1FT7M");
        ECL_ActivateAttribute("HMK_ACB783_1FT7M");

        if (PMD_ABV410_001_000_1FT7M != "KEING") {

            var sTable = "VT_1FT7M_M00107" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "PMD_ABV410_001_000_1FT7M = '" + PMD_ABV410_001_000_1FT7M + "';";

            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PL");
            if (aResult.length > 0) {
                var HMK_ACB729_1FT7M = aResult[0].HMK_ACB729_1FT7M;
                var HMK_ACB772_1FT7M = aResult[0].HMK_ACB772_1FT7M;
                var HMK_ACB789_1FT7M = aResult[0].HMK_ACB789_1FT7M;
                var HMK_ACB769_1FT7M = aResult[0].HMK_ACB769_1FT7M;
                var HMK_ACB783_1FT7M = aResult[0].HMK_ACB783_1FT7M;

                if (HMK_ACB729_1FT7M < 100) {
                    HMK_ACB729_1FT7M = "V_0" + HMK_ACB729_1FT7M;
                } else {
                    HMK_ACB729_1FT7M = "V_" + HMK_ACB729_1FT7M;
                }

                if (HMK_ACB772_1FT7M < 100) {
                    HMK_ACB772_1FT7M = "V_0" + HMK_ACB772_1FT7M;
                } else {
                    HMK_ACB772_1FT7M = "V_" + HMK_ACB772_1FT7M;
                }

                if (HMK_ACB789_1FT7M < 100) {
                    HMK_ACB789_1FT7M = "V_0" + HMK_ACB789_1FT7M;
                } else {
                    HMK_ACB789_1FT7M = "V_" + HMK_ACB789_1FT7M;
                }

                if (HMK_ACB769_1FT7M < 100) {
                    HMK_ACB769_1FT7M = "V_0" + HMK_ACB769_1FT7M;
                } else {
                    HMK_ACB769_1FT7M = "V_" + HMK_ACB769_1FT7M;
                }

                if (HMK_ACB783_1FT7M < 100) {
                    HMK_ACB783_1FT7M = "V_0" + HMK_ACB783_1FT7M;
                } else {
                    HMK_ACB783_1FT7M = "V_" + HMK_ACB783_1FT7M;
                }

                ECL_DeactivateAllAttributeValues("HMK_ACB729_1FT7M");
                ECL_DeactivateAllAttributeValues("HMK_ACB772_1FT7M");
                ECL_DeactivateAllAttributeValues("HMK_ACB789_1FT7M");
                ECL_DeactivateAllAttributeValues("HMK_ACB769_1FT7M");
                ECL_DeactivateAllAttributeValues("HMK_ACB783_1FT7M");

                ECL_ActivateValue("HMK_ACB729_1FT7M", HMK_ACB729_1FT7M);
                ECL_ActivateValue("HMK_ACB772_1FT7M", HMK_ACB772_1FT7M);
                ECL_ActivateValue("HMK_ACB789_1FT7M", HMK_ACB789_1FT7M);
                ECL_ActivateValue("HMK_ACB769_1FT7M", HMK_ACB769_1FT7M);
                ECL_ActivateValue("HMK_ACB783_1FT7M", HMK_ACB783_1FT7M);

                ECL_SelectValue("HMK_ACB729_1FT7M", HMK_ACB729_1FT7M);
                ECL_SelectValue("HMK_ACB772_1FT7M", HMK_ACB772_1FT7M);
                ECL_SelectValue("HMK_ACB789_1FT7M", HMK_ACB789_1FT7M);
                ECL_SelectValue("HMK_ACB769_1FT7M", HMK_ACB769_1FT7M);
                ECL_SelectValue("HMK_ACB783_1FT7M", HMK_ACB783_1FT7M);
            } else {
                strError = "DICT1_ERR_1FT7M___PLVT_GETRIEBE_ABM_NO_DB_RESULT";
                return strError;
            }
        } else {
            // Fehler

            ECL_DeactivateAllAttributeValues("HMK_OPT_PLANETGETR_1FT7M");
            ECL_ActivateValue("HMK_OPT_PLANETGETR_1FT7M", "KEING");
            ECL_SelectValue("HMK_OPT_PLANETGETR_1FT7M", "KEING");

            strError = "DICT1_ERR_1FT7M___PLVT_GEAR_NO_RESULT";
            return strError;
        }
    } else {
        //ECL_DeactivateAllAttributeValues("HMK_OPT_PLANETGETR_1FT7M");
        ECL_ActivateValue("HMK_OPT_PLANETGETR_1FT7M", "NON");
        ECL_SetValue("HMK_OPT_PLANETGETR_1FT7M", "NON");

        ECL_DeactivateAttribute("PMD_ABV410_001_000_1FT7M"); // Bezeichnung Getriebe
        ECL_DeactivateAttribute("HMK_UEBERSETZ_STUFE_1FT7M"); // Übersetzung + Stufigkeit
        ECL_DeactivateAttribute("PMD_ABV414_001_000_1FT7M"); // Wellenende

        ECL_DeactivateAttribute("HMK_ACB729_1FT7M");
        ECL_DeactivateAttribute("HMK_ACB772_1FT7M");
        ECL_DeactivateAttribute("HMK_ACB789_1FT7M");
        ECL_DeactivateAttribute("HMK_ACB769_1FT7M");
        ECL_DeactivateAttribute("HMK_ACB783_1FT7M");
    }
    // ################################################################################################################




    // ################################################################################################################
    // ################################################################################################################
    return "OK";

}
