//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"


//@import "../1FT7_MLFB/Base.misc.js"

//@import "../1FT7_CONFIG/VT_1FT7.js"


/**
 * @category   1FT7M Parser
 * @package    Parser
 * @copyright  Copyright (c) 2020 Plan Software GmbH (http://www.plansoft.de)
 */

var vtTimeStart;
var vtTimeStop;
var vtTime;
var HMK_RUMPF_1FT7M;
var strError;

function parse_init(strMLFB) {
    vtTimeStart = Date.getTime();

    var oParsing = {
        strBaseMLFB: '',
        strFullMLFB: '',
        strError: '',
        strWarning: '',
        aTokens: [],
        oFreetext: {}
    };

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    strMLFB = normalizeMLFB(strMLFB);
    strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration = "1";
    //var bF70presentBT=false;
    /*	
        
        if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0)
            strStartConfiguration="1" ;
        
        if(strStartConfiguration=="1")
        {*/
    //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
    //Hier sollen dann möglichst viele Attribute beibehalten werden.
    //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
    if (strBaseTypeMLFB != "") {
        //--------------------------------------------------------------------------------------------------------
        // Base Type  MLFB aufbereiten
        //--------------------------------------------------------------------------------------------------------
        var aBTComponents = tokenize(strBaseTypeMLFB);
        if (aBTComponents.length > 1) {
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ((aBTComponents[1] === 'Z') || (aBTComponents[1] === '-Z')) {
                aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
            }
        }

        strBaseTypeMLFB = aBTComponents[0];

        if (strBaseTypeMLFB.length === 17) {
            // eliminate the -Z 
            strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
        }

        //var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring( 0, 8 ) + "." + strBaseTypeMLFB.substring( 9, 11 );
        var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 11);
    }

    var oResult;

    var nFreetext = find(strMLFB, '{');
    var strFreetext = '';
    if (nFreetext > 0) {
        strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
    }
    oParsing.oFreetext = parseFreetext(strFreetext, true);
    strMLFB = replace(strMLFB, strFreetext, "");
    oParsing.strFullMLFB = strMLFB;

    var aComponents = tokenize(strMLFB);
    if (!aComponents.length) {
        oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_MLFB';
        return (oParsing);
    } else if (aComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ((aComponents[1] === 'Z') || (aComponents[1] === '-Z')) {
            aComponents = removeElementsFromArray(aComponents, 1, 1);
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;

    //var strMLFB_fix = strMLFB.substring( 0, 8 ) + "." + strMLFB.substring( 9, 11 );
    var strMLFB_fix = strMLFB.substring(0, 11);
    var sHMK_BG = strMLFB.substring(4, 7);

    var bGear = false;
    var bKeepConfig = false;

    // if Konfig-ziel == Getriebe:
    var ECSI_CX_SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
    var sKAG_Gear_BT = getKAGforAttribute("HMK_OPT_PLANETGETR_1FT7M", aBTComponents);
    if (ECSI_CX_SeriesID == "303" || sKAG_Gear_BT !== "NON") {
        // mit Getriebe
        bGear = true;

        // prüfen auf Getriebe KAG
        var sKAG_Gear = getKAGforAttribute("HMK_OPT_PLANETGETR_1FT7M", aComponents);
        // BaseType
        //var sKAG_Gear_BT = getKAGforAttribute("HMK_OPT_PLANETGETR_1FT7M", aBTComponents);

        var bGearKAGinMLFB = false;
        var bGearKAGinBT = false;


        if (sKAG_Gear != sKAG_Gear_BT) {
            // remove gear-KAG
            var aNewArray = [];
            for (var i = 0; i < aComponents.length; i++) {

                if (aComponents[i] != sKAG_Gear) {
                    aNewArray.push(aComponents[i]);
                }
            }

            bKeepConfig = true;

            aComponents = aNewArray;

            strMLFB = replace(strMLFB, "+" + sKAG_Gear, "");
            strMLFB = replace(strMLFB, sKAG_Gear, "");
        }

        // Add new KAGs
        aComponents.push(sKAG_Gear_BT);
        aComponents.sort();

        strMLFB = strMLFB + "+" + sKAG_Gear_BT;

        ECL_SetValue("ECSI_MLFB", strMLFB);

    }

    // EDIT RepairConfig added
    if (strStartConfiguration == "1" && strBaseTypeMLFB_fix == strMLFB_fix && strBaseTypeMLFB != "" && find(strMLFB.left(16), ".") < 0)   // if same motor is selected again
    {
        var bRepairConfig = true;
    }
    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if (((strBaseTypeMLFB_fix != strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") || bKeepConfig || bRepairConfig) {
        // Bestimmung HMK_BAUGROESSE_1FT7M (MLFB05...MLFB07 und Rumpf MLFB01...MLFB11
        // über VT 23/24 lassen sich die grundsäzulichen zugelassenen MLFBs ermitteln/prüfen
        /*
        HMK_RUMPF_1FT7M
        VT_1FT7M_M00021	Zuordnung_Rumpf_MLFB
            HMK_RUMPF_1FT7M	MLFB05_1FT7M	MLFB07_1FT7M	MLFB08_1FT7M	MLFB09_1FT7M	MLFB10_1FT7M	MLFB11_1FT7
        
        AUswahllogik I : VT23
        Input:
            HMK_BAUGROESSE_1FT7M	MLFB08_1FT7M	MLFB09_1FT7M	MLFB11_1FT7M	HMK_VALUE_VALID_1FT7M
        Output:
            MLFB12_1FT7M	MLFB14_1FT7M	MLFB15_1FT7M	MLFB16_1FT7M	
        
        VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
            
        input:
            HMK_RUMPF_1FT7M	HMK_VALUE_VALID_1FT7M
        Output: 
            MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M
        */
        // -----------------------------------------------------------------------------------------------
        // KAG abgleichen und ggf übernehmen/entfernen
        // -----------------------------------------------------------------------------------------------
        // Getriebe KAG ggf. entfernen
        /*if (bGear){
            if (sKAG_Gear != sKAG_Gear_BT){
                // remove gear-KAG
                var aNewArray=[];
                for(var i=0;i<aComponents.length;i++){
                    
                    if(aComponents[i]!=sKAG_Gear){
                        aNewArray.push(aComponents[i]);
                    }
                }
                
                aComponents=aNewArray;
                
                strMLFB=replace(strMLFB, "+" + sKAG_Gear, "");
                strMLFB=replace(strMLFB, sKAG_Gear, "");
            }
            
            // Add new KAGs
            aComponents.push(sKAG_Gear_BT);
            aComponents.sort();
            
            strMLFB=strMLFB+"+" + sKAG_Gear_BT;
            
            ECL_SetValue("ECSI_MLFB",strMLFB);
        }
        */



        /* Mögliche Platzhalter:
        2.	MLFB12 = .? Flanschausführung	{0, 5, 1, 4} kompakt mit Drive CLiQ, ohne Drive CLiQ, klassisch mit, ohne		// Relevanz für GearboxMotorCoupling
        3.	MLFB13 = .? Steckerabgangsrichtung / Klemmenkasten/Leitungseinführung
        1.	MLFB14 = .? Geber																								// Relevanz für EncoderRoughType
        4.	MLFB15 = .? A/B Wellenende / Wellen- und Flanschgenauigkeit / Haltebremse										// Relevanz MotorBrakeRequired
        5.	MLFB16 = .? 0 Schwinggrößenstufe / Schutzart
        */

        var HMK_RUMPF_1FT7M = strBaseTypeMLFB_fix.substring(0, 7) + "-" + strBaseTypeMLFB_fix.substring(7, 11);
        var HMK_BAUGROESSE_1FT7M = strBaseTypeMLFB_fix.substring(4, 7);

        var BT_MLFB08 = strBaseTypeMLFB_fix.charAt(7);
        var BT_MLFB09 = strBaseTypeMLFB_fix.charAt(8);
        var BT_MLFB10 = strBaseTypeMLFB_fix.charAt(9);
        var BT_MLFB11 = strBaseTypeMLFB_fix.charAt(10);

        // -----------------------------------------------------------------------------------------------
        // Platzhalter aus MLFB in BT übernehmen
        // -----------------------------------------------------------------------------------------------
        var bPunkt_12 = false;
        var bPunkt_13 = false;
        var bPunkt_14 = false;
        var bPunkt_15 = false;
        var bPunkt_16 = false;

        var bGearBox = false;
        var bBrake = false;
        // ------------------------------------------------------------------------------------------------------
        var sMLFB12 = strMLFB.charAt(11);
        var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);
        if (sBT_MLFB12 == ".")
            bPunkt_12 = true;

        var sMLFB13 = strMLFB.charAt(12);
        var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);
        if (sBT_MLFB13 == ".")
            bPunkt_13 = true;

        var sMLFB14 = strMLFB.charAt(13);
        var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);
        if (sBT_MLFB14 == ".")
            bPunkt_14 = true;

        var sMLFB15 = strMLFB.charAt(14);
        var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);
        if (sBT_MLFB15 == ".")
            bPunkt_15 = true;

        var sMLFB16 = strMLFB.charAt(15);
        var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);
        if (sBT_MLFB16 == ".")
            bPunkt_16 = true;

        // ------------------------------------------------------------------------------------------------------
        // Kontexte berücksichtigen
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        if (strwithBrake == "1") {
            bBrake = true;
        }
        //Sonderlogik für Adapteranbau
        var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
        var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
        if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
            bGearBox = true;

            // nur mit klassischem Flansch, grundsätzlich nur glatte Welle ohne Passfeder
            // MLFB12 nur 1, 4			(0, 5 deaktivieren)			wenn zuvor 0, dann 1, wenn 5, dann 4	(mit/ohne DriveCLiQ	
            if (sMLFB12 == "0") {
                sMLFB12 = "1";
            } else if (sMLFB12 == "5") {
                sMLFB12 = "4";
            }
            if (!(bPunkt_12) && sBT_MLFB12 != sMLFB12) {
                // Wenn MLFB12 in der Basetype übergeben wird, prüfen, ob Vorgabe passt
                oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_CONTEXT_MLFB12';
                return (oParsing);
            }
            // MLFB15 nur G, H, K, L 	(A,B,D,E deaktivieren)
            if (bBrake) {
                // H oder L
                if (sMLFB15 != "H" && sMLFB15 != "L") {
                    // sMLFB15 == "H"
                    if (sMLFB15 == "A" || sMLFB15 == "B" || sMLFB15 == "G") { // Setze H 
                        sMLFB15 = "H";
                    } else { // (sMLFB15 == "D" || sMLFB15 == "E" || sMLFB15 == "K")
                        // setze L
                        sMLFB15 = "L";
                    }
                    if (ECSI_CX_IsDriveTrain && parseInt(ECSI_CX_IsDriveTrain) == 1) {
                        sMLFB15 = "H";
                    }
                } else {
                    if (ECSI_CX_IsDriveTrain && parseInt(ECSI_CX_IsDriveTrain) == 1) {
                        sMLFB15 = "H";
                    }
                }
            } else {
                // G oder K
                if (sMLFB15 != "G" && sMLFB15 != "K") {
                    // sMLFB15 == "G"
                    if (sMLFB15 == "A" || sMLFB15 == "B" || sMLFB15 == "H") { // Setze G 
                        sMLFB15 = "G";
                    } else { // (sMLFB15 == "D" || sMLFB15 == "E" || sMLFB15 == "L")
                        // setze K
                        sMLFB15 = "K";
                    }
                    if (ECSI_CX_IsDriveTrain && parseInt(ECSI_CX_IsDriveTrain) == 1) {
                        sMLFB15 = "G";
                    }
                } else {
                    if (ECSI_CX_IsDriveTrain && parseInt(ECSI_CX_IsDriveTrain) == 1) {
                        sMLFB15 = "G";
                    }
                }
            }
            if (!(bPunkt_15) && sBT_MLFB15 != sMLFB15) {
                // Wenn MLFB15 in der Basetype übergeben wird, prüfen, ob Vorgabe passt
                oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_CONTEXT_MLFB15';
                return (oParsing);
            }
        } else {
            if (bBrake) {
                // Erlaubt B, E, H, L
                switch (sMLFB15) {
                    case "A":
                        sMLFB15 = "B";
                        break;
                    case "D":
                        sMLFB15 = "E";
                        break;
                    case "G":
                        sMLFB15 = "H";
                        break;
                    case "K":
                        sMLFB15 = "L";
                        break;
                }
            } else {
                // erlaubt: A, D, G, K
                switch (sMLFB15) {
                    case "B":
                        sMLFB15 = "A";
                        break;
                    case "E":
                        sMLFB15 = "D";
                        break;
                    case "H":
                        sMLFB15 = "G";
                        break;
                    case "L":
                        sMLFB15 = "K";
                        break;
                }
            }
            if (!(bPunkt_15) && sBT_MLFB15 != sMLFB15) {
                // Wenn MLFB15 in der Basetype übergeben wird, prüfen, ob Vorgabe passt
                oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_CONTEXT_MLFB15';
                return (oParsing);
            }
        }

        // ------------------------------------------------------------------------------------------------------


        var bAuswahl_1 = false;
        var bAuswahl_2 = false;

        if (bPunkt_12 && bPunkt_13 && bPunkt_14 && bPunkt_15 && bPunkt_16) {		// todo? können die freien MLFB-Stellen doch teilweise belegt sein?
            // Versuch, ob neue Rumpf-MLFB mit MLFB12-16 gültig ist

            /*
            AUswahllogik I : VT23
            Input:
                HMK_BAUGROESSE_1FT7M	MLFB08_1FT7M	MLFB09_1FT7M	MLFB11_1FT7M	HMK_VALUE_VALID_1FT7M
            Output:
                MLFB12_1FT7M	MLFB14_1FT7M	MLFB15_1FT7M	MLFB16_1FT7M	
            */
            var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                "MLFB12_1FT7M = '" + sMLFB12 + "' AND " +
                "MLFB14_1FT7M = '" + sMLFB14 + "' AND " +
                "MLFB15_1FT7M = '" + sMLFB15 + "' AND " +
                "MLFB16_1FT7M = '" + sMLFB16 + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);

            if (aResult.length > 0) {
                // 12, 14, 15, 16 wären zulässig (13, extra prüfen)
                bAuswahl_1 = true;
            }

            /*
            VT_1FT7M_M00114	ZO Rumpf MLFB12-13-14 L03
                HMK_RUMPF_1FT7M	MLFB12_1FT7M	MLFB13_1FT7M	MLFB14_1FT7M	HMK_OPT_L03_L06_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
                alt 24, 104 ==> 114		63 ==> 114
            input:
                alt: MLFB08_1FT7M		MLFB09_1FT7M	MLFB10_1FT7M		HMK_BAUGROESSE_1FT7M	HMK_VALUE_VALID_1FT7M
                neu: HMK_RUMPF_1FT7M	PMD_AAB047_001_000_1FT7M	HMK_VALUE_VALID_1FT7M
            Output: 
                MLFB12_1FT7M, MLFB13_1FT7M, MLFB14_1FT7M
            */
            var HMK_RUMPF_1FT7M = strBaseTypeMLFB_fix.substring(0, 7) + "-" + strBaseTypeMLFB_fix.substring(7, 11);

            var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                "MLFB12_1FT7M = '" + sMLFB12 + "' AND " +
                "MLFB13_1FT7M = '" + sMLFB13 + "' AND " +
                "MLFB14_1FT7M = '" + sMLFB14 + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);

            if (aResult.length > 0) {
                bAuswahl_2 = true;
                var bMLFB12 = true;
                var bMLFB13 = true;
                if (sMLFB14 !== "E") {
                    var bMLFB14 = true;
                }
            } else {
                bAuswahl_2 = false;

                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                    "MLFB12_1FT7M = '" + sMLFB12 + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";

                var aResult = GetDBDataSetEXT(sSQL);

                if (aResult.length > 0) {
                    var bMLFB12 = true;
                } else {
                    var bMLFB12 = false;
                }
                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                    "MLFB13_1FT7M = '" + sMLFB13 + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";

                var aResult = GetDBDataSetEXT(sSQL);

                if (aResult.length > 0) {
                    var bMLFB13 = true;

                } else {
                    var bMLFB13 = false;
                }
                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                    "MLFB14_1FT7M = '" + sMLFB14 + "' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";

                var aResult = GetDBDataSetEXT(sSQL);

                if (aResult.length > 0) {
                    if (sMLFB14 !== "E") {
                        var bMLFB14 = true;
                    } else {
                        var bMLFB14 = false;
                    }
                } else {
                    var bMLFB14 = false;
                }

            }
        } else {
            // einzelne Wildcards in BaseTypeMLFB belegt, gesondert handeln: 
            oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_BASETYPEMLFB';
            return (oParsing);
        }

        if (bAuswahl_1 && bAuswahl_2) {
            // alles zulässig, 

            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
        } else {


            var bMLFB12 = false;
            var bMLFB13 = false;
            var bMLFB14 = false;
            var bMLFB15 = false;
            var bMLFB16 = false;

            // MLFB12_1FT7M		MLFB14_1FT7M	MLFB15_1FT7M	MLFB16_1FT7M 
            var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";
            var aResult = GetDBDataSetEXT(sSQL);

            if (aResult.length > 0) {
                // zunächst MLFB15 und 12
                for (var i = 0; i < aResult.length; i++) {
                    if (aResult[i].MLFB15_1FT7M == sMLFB15) {
                        var bMLFB15 = true;
                        break;
                    }
                }
                for (var i = 0; i < aResult.length; i++) {
                    if (bMLFB15) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB12_1FT7M == sMLFB12) {
                            var bMLFB12 = true;
                            break;
                        }
                    } else {
                        if (aResult[i].MLFB12_1FT7M == sMLFB12) {
                            var bMLFB12 = true;
                            break;
                        }
                    }
                }

                // Wenn bGearBox || bBrake && !bMLFB15 ==> Fehler
                // wenn bGearBox && !bMLFB12 ==> Fehler
                if ((bGearBox || bBrake) && !bMLFB15) {
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_CONTEXT_GEARBOX_BRAKE_MLFB15';
                    return (oParsing);
                }
                if (bGearBox && !bMLFB12) {
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INVALID_CONTEXT_GEARBOX_MLFB12';
                    return (oParsing);
                }

                // MLFB14 Geber
                if (bMLFB12 && bMLFB15) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB12_1FT7M == sMLFB12 && aResult[i].MLFB14_1FT7M == sMLFB14) {
                            var bMLFB14 = true;
                            break;
                        }
                    }
                } else if (bMLFB15 && !bMLFB12) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB14_1FT7M == sMLFB14) {
                            if (sMLFB14 !== "E") {
                                var bMLFB14 = true;
                            }
                            break;
                        }
                    }
                } else if (bMLFB12 && !bMLFB15) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB12_1FT7M == sMLFB12 && aResult[i].MLFB14_1FT7M == sMLFB14) {
                            if (sMLFB14 !== "E") {
                                var bMLFB14 = true;
                            }
                            break;
                        }
                    }
                } else {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB14_1FT7M == sMLFB14) {
                            if (sMLFB14 !== "E") {
                                var bMLFB14 = true;
                            }
                            break;
                        }
                    }
                }

                // MLFB16 Schwinggrößenstufe und Schutzart
                if (bMLFB12 && bMLFB14 && bMLFB15) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB12_1FT7M == sMLFB12 && aResult[i].MLFB14_1FT7M == sMLFB14 && aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                } else if (bMLFB15 && bMLFB12 && !bMLFB14) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB12_1FT7M == sMLFB12 && aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                } else if (bMLFB15 && !bMLFB12 && bMLFB14) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sMLFB15 && aResult[i].MLFB14_1FT7M == sMLFB14 && aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                } else if (bMLFB12 && bMLFB14 && !bMLFB15) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB12_1FT7M == sMLFB12 && aResult[i].MLFB14_1FT7M == sMLFB14 && aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                } else if (!bMLFB12 && bMLFB14 && !bMLFB15) {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB14_1FT7M == sMLFB14 && aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                } else {
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB16_1FT7M == sMLFB16) {
                            var bMLFB16 = true;
                            break;
                        }
                    }
                }
            }
            // --------------------------------------------------------------
            var sWhere12 = "";
            var sWhere13 = "";
            var sWhere14 = "";
            var sWhere15 = "";
            var sWhere16 = "";

            if (bMLFB12)
                sWhere12 = "MLFB12_1FT7M = '" + sMLFB12 + "' AND ";

            if (bMLFB13)
                sWhere13 = "MLFB13_1FT7M = '" + sMLFB13 + "' AND ";

            if (bMLFB14)
                sWhere14 = "MLFB14_1FT7M = '" + sMLFB14 + "' AND ";

            if (bMLFB15)
                sWhere15 = "MLFB15_1FT7M = '" + sMLFB15 + "' AND ";

            if (bMLFB16)
                sWhere16 = "MLFB16_1FT7M = '" + sMLFB16 + "' AND ";

            // Alle Datensätze durchlaufen, wo Wert = true, passt es, sonst Default setzen. Wenn Widerspruch zu Kontext: Fehler! (s.o.)

            if (bMLFB15) {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
            } else {
                // Default bestimmen
                var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
                var sSQL = "SELECT DISTINCT MLFB15_1FT7M FROM " + sTable + " WHERE " +
                    "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                    "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                    "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                    "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                    sWhere12 +
                    sWhere14 +
                    //sWhere15 +
                    sWhere16 +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
                var aResult = GetDBDataSetEXT(sSQL);

                // Bestimme Default
                if (bGearBox) {
                    if (bBrake) {
                        // Default: H
                        var sDefaultMLFB15_1 = "H";
                        var sDefaultMLFB15_2 = "L";
                    } else {
                        var sDefaultMLFB15_1 = "G";
                        var sDefaultMLFB15_2 = "K";
                    }
                } else if (BT_MLFB08 == "1") {
                    if (bBrake) {
                        // Default: H
                        var sDefaultMLFB15_1 = "H";
                        var sDefaultMLFB15_2 = "H";
                    } else {
                        var sDefaultMLFB15_1 = "G";
                        var sDefaultMLFB15_2 = "G";
                    }
                } else {
                    if (bBrake) {
                        // Default: B
                        var sDefaultMLFB15_1 = "B";
                        var sDefaultMLFB15_2 = "E";
                    } else {
                        var sDefaultMLFB15_1 = "A";
                        var sDefaultMLFB15_2 = "D";
                    }
                }


                if (aResult.length > 1) {

                    // prüfen, ob Standard enthalten
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB15_1FT7M == sDefaultMLFB15_1) {
                            sMLFB15 = sDefaultMLFB15_1;
                            break;
                        }
                    }
                    if (sMLFB15 != sDefaultMLFB15_1) {
                        for (var i = 0; i < aResult.length; i++) {
                            if (aResult[i].MLFB15_1FT7M == sDefaultMLFB15_2) {
                                sMLFB15 = sDefaultMLFB15_2;
                                break;
                            }
                        }
                        if (sMLFB15 != sDefaultMLFB15_2) {
                            // wenn CoreType (MLFB08 == 1) nur glatte Welle Toleranz N ==> G/H


                            oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB15_KEEP_CONFIG_CONTEXT';
                            return (oParsing);
                            //sMLFB15 = aResult[0].MLFB15_1FT7M;
                            //return( oParsing );
                        }
                        //
                    }
                } else if (aResult.length == 1) {
                    if (aResult[0].MLFB15_1FT7M == sDefaultMLFB15_1 || aResult[0].MLFB15_1FT7M == sDefaultMLFB15_2) {
                        sMLFB15 = aResult[0].MLFB15_1FT7M;
                    } else {
                        oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB15_KEEP_CONFIG_CONTEXT';
                        return (oParsing);
                    }
                } else {
                    // Fehler
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB15_KEEP_CONFIG';
                    return (oParsing);
                }

                sWhere15 = "MLFB15_1FT7M = '" + sMLFB15 + "' AND ";
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
            }


            if (bMLFB12) {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
            } else {
                // Default bestimmen
                var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
                var sSQL = "SELECT MLFB12_1FT7M FROM " + sTable + " WHERE " +
                    "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                    "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                    "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                    "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                    //sWhere12 +
                    sWhere14 +
                    sWhere15 +
                    sWhere16 +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
                var aResult = GetDBDataSetEXT(sSQL);
                // Bestimme Default
                if (bGearBox) {
                    var aValidValuesMLFB12 = ["1", "4"]
                } else {
                    var aValidValuesMLFB12 = ["0", "1", "4", "5"]
                }
                if (aResult.length > 1) {

                    // prüfen, ob Standard enthalten
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB12_1FT7M == "1") {
                            sMLFB12 = "1";
                            break;
                        }
                    }
                    if (sMLFB12 != "1") {
                        for (var i = 0; i < aResult.length; i++) {
                            if (aResult[i].MLFB12_1FT7M == "4") {
                                sMLFB15 = "4";
                                break;
                            }
                        }
                        if (sMLFB12 != "4") {
                            if (bGearBox) {
                                oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB12_KEEP_CONFIG_CONTEXT';
                                return (oParsing);
                            } else {
                                // alle grundsätzlich erlaubt
                                sMLFB12 = aResult[0].MLFB12_1FT7M;
                            }
                        }
                    }
                } else if (aResult.length == 1) {
                    sMLFB12 = aResult[0].MLFB12_1FT7M;
                    if (bGearBox && sMLFB12 != "1" && sMLFB12 != "4") {
                        oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB12_KEEP_CONFIG_CONTEXT';
                        return (oParsing);
                    }
                } else {
                    // Fehler
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB12_KEEP_CONFIG';
                    return (oParsing);
                }

                sWhere12 = "MLFB12_1FT7M = '" + sMLFB12 + "' AND ";
            }

            if (bMLFB14) {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
            } else {
                // Default bestimmen
                var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
                var sSQL = "SELECT DISTINCT MLFB14_1FT7M FROM " + sTable + " WHERE " +
                    "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                    "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                    "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                    "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                    sWhere12 +
                    //sWhere14 +
                    sWhere15 +
                    sWhere16 +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
                var aResult = GetDBDataSetEXT(sSQL);

                sMLFB14 = "";

                if (aResult.length > 1) {
                    // Bestimme Default
                    // prüfen, ob Standard enthalten
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB14_1FT7M == "D") {
                            sMLFB14 = "D";
                            break;
                        }
                    }
                    if (sMLFB14 != "D") {
                        sMLFB14 = aResult[0].MLFB14_1FT7M;
                    }
                } else if (aResult.length == 1) {

                    sMLFB14 = aResult[0].MLFB14_1FT7M;
                } else {
                    // Fehler
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB14_KEEP_CONFIG';
                    return (oParsing);
                }

                sWhere14 = "MLFB14_1FT7M = '" + sMLFB14 + "' AND ";
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
            }


            if (bMLFB16) {
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
            } else {
                // Default bestimmen
                var sTable = "VT_1FT7M_M00023" + sDB_Suffix;
                var sSQL = "SELECT MLFB16_1FT7M FROM " + sTable + " WHERE " +
                    "HMK_BAUGROESSE_1FT7M = '" + HMK_BAUGROESSE_1FT7M + "' AND " +
                    "MLFB08_1FT7M = '" + BT_MLFB08 + "' AND " +
                    "MLFB09_1FT7M = '" + BT_MLFB09 + "' AND " +
                    "MLFB11_1FT7M = '" + BT_MLFB11 + "' AND " +
                    sWhere12 +
                    sWhere14 +
                    sWhere15 +
                    //sWhere16 +
                    "HMK_VALUE_VALID_1FT7M = 'T';";
                var aResult = GetDBDataSetEXT(sSQL);

                if (aResult.length > 1) {
                    // Bestimme Default
                    // prüfen, ob Standard enthalten
                    for (var i = 0; i < aResult.length; i++) {
                        if (aResult[i].MLFB16_1FT7M == "2") {
                            sMLFB16 = "2";
                            break;
                        }
                    }
                    if (sMLFB16 != "2") {
                        sMLFB16 = aResult[0].MLFB16_1FT7M;
                    }
                } else if (aResult.length == 1) {

                    sMLFB16 = aResult[0].MLFB16_1FT7M;
                } else {
                    // Fehler
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB16_KEEP_CONFIG';
                    return (oParsing);
                }
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
                //sWhere16 = "MLFB16_1FT7M = '" + sMLFB16 + "' AND ";
            }

        }
        if (bAuswahl_2) {
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
        } else {
            // MLFB13 default bestimmen
            var HMK_RUMPF_1FT7M = strBaseTypeMLFB_fix.substring(0, 7) + "-" + strBaseTypeMLFB_fix.substring(7, 11);

            var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
            var sSQL = "SELECT MLFB13_1FT7M FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                "HMK_VALUE_VALID_1FT7M = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);

            if (aResult.length > 1) {
                // Bestimme Default
                // prüfen, ob Standard enthalten
                for (var i = 0; i < aResult.length; i++) {
                    if (aResult[i].MLFB13_1FT7M == "1") {
                        sMLFB13 = "1";
                        var bMLFB13found = true;
                        break;
                    }
                }
                if (!bMLFB13found) {
                    sMLFB13 = aResult[0].MLFB13_1FT7M;
                }
            } else if (aResult.length == 1) {

                sMLFB13 = aResult[0].MLFB13_1FT7M;
            } else {
                // Fehler
                oParsing.strError = 'ERRORMSG_MLFB_1FT7M___MLFB13_KEEP_CONFIG';
                return (oParsing);
            }

            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
        }

        // -----------------------------------------------------------------------------------------------
        // Zuweisen der neuen MLFB und KAG-Liste
        strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

        oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
        oParsing.strFullMLFB = strMLFB;
        aComponents[0] = oParsing.strBaseMLFB;
        oParsing.aTokens = aComponents;
        ECL_SetValue("ECSI_MLFB", strMLFB);
    }// END EDIT KEEP CONF
    else {
        if (find(strMLFB.left(16), ".") >= 0) {
            //Unvollständige SIZER MLFB

            // Prüfen, ob '.' an Stelle 1 bis 11, dann Fehler
            for (var i = 0; i < 11; i++) {
                if (strMLFB.charAt(i) == ".") {
                    oParsing.strError = 'ERRORMSG_MLFB_1FT7M___INCOMPLETE_MLFB';
                    return (oParsing);
                }
            }
            // Wenn an Stelle 9, (11), 12-16 ein Wildcard, dann Default setzen

            /*if (strMLFB.charAt(8) == "."){	//MLFB09 Kühlung Default A
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 8, "A");
            }
            */
            if (strMLFB.charAt(10) == ".") {	//MLFB11 Zwischenkreisspannung Default 7
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 10, "7");
            }
            if (strMLFB.charAt(11) == ".") {	//MLFB12 Bauform/Flanschausführung Default 1
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 11, "1");
            }
            if (strMLFB.charAt(12) == ".") {	//MLFB13 E-Anschluss/Steckerabgangsrichtung Default 1 Achtung: nicht eindeutig
                // getDefaultValue


                var HMK_RUMPF_1FT7M = strBaseTypeMLFB_fix.substring(0, 7) + "-" + strBaseTypeMLFB_fix.substring(7, 11);

                var sTable = "VT_1FT7M_M00114" + sDB_Suffix;
                var sSQL = "SELECT MLFB13_1FT7M FROM " + sTable + " WHERE " +
                    "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                    "MLFB13_1FT7M = '1' AND " +
                    "HMK_VALUE_VALID_1FT7M = 'T';";

                var aResult = GetDBDataSetEXT(sSQL);

                if (aResult.length > 1) {
                    var sMLFB13 = "1";
                } else {
                    var sSQL = "SELECT MLFB13_1FT7M FROM " + sTable + " WHERE " +
                        "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "' AND " +
                        "HMK_VALUE_VALID_1FT7M = 'T';";

                    var aResult = GetDBDataSetEXT(sSQL);

                    if (aResult.length > 1) {
                        var sMLFB13 = aResult[0].MLFB13_1FT7M;
                    }

                }
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 12, sMLFB13);

            }
            if (strMLFB.charAt(13) == ".") {	//MLFB14 Geber Default D | bei BG 117 nur L
                // Setze Default:
                if (sHMK_BG == "117") {

                    strMLFB = replaceAt(strMLFB, 13, "L");
                } else {
                    strMLFB = replaceAt(strMLFB, 13, "D");
                }
            }
            if (strMLFB.charAt(14) == ".") {	//MLFB15 Wellenende/Flanschgenauigkeit/Bremse Default A ohne Bremse, B mit Bremse
                var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
                //Sonderlogik für Adapteranbau
                var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");

                if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 0) {
                    // nur mit klassischem Flansch, grundsätzlich nur glatte Welle ohne Passfeder
                    // MLFB12 nur 1, 4			(0, 5 deaktivieren)
                    // MLFB15 nur G, H, K, L 	(A,B,D,E deaktivieren)
                    if (strwithBrake == "1") {
                        // Setze Default: H
                        strMLFB = replaceAt(strMLFB, 14, "H");
                    } else {
                        strMLFB = replaceAt(strMLFB, 14, "G");
                    }
                } else {
                    if (strwithBrake == "1") {
                        // Setze Default: B
                        strMLFB = replaceAt(strMLFB, 14, "B");
                    } else {
                        strMLFB = replaceAt(strMLFB, 14, "A");
                    }
                }
            }
            var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
            if (strMLFB.charAt(15) == ".") {	//MLFB16 Schwinggrößenstufe/Schutzart Default 0
                // Setze Default:
                if (ECSI_CX_IsDriveTrain == "1") {
                    strMLFB = replaceAt(strMLFB, 15, "1");
                }
                strMLFB = replaceAt(strMLFB, 15, "0");
            }
            ECL_SetValue("ECSI_MLFB", strMLFB);

            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;
            oParsing.strFullMLFB = strMLFB;
            //oParsing.aTokens = aComponents;
        }
    }


    if (oParsing.strBaseMLFB.length !== 16) {
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FT7M___PARSE_WRONG_SIZE';
        return (oParsing);
    }

    if (oParsing.strBaseMLFB.indexOf("1FT7") < 0) {
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FT7M___PARSE_WRONG_PRODUCT';
        return (oParsing);
    }

    var oResult;
    oResult = parse_1FT7M(oParsing.aTokens);
    oResult = add_Rumpf(oResult);
    oResult = add_ABV400(oResult);
    if (bGear) {
        oResult.oParsingData.GEAR = "P_GEAR";
        ECL_SelectValue("HMK_KONFIG_ZIEL_1FT7M", "P_GEAR");
    } else {
        oResult.oParsingData.GEAR = "SERVO";
        ECL_SelectValue("HMK_KONFIG_ZIEL_1FT7M", "SERVO");
    }
    //var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    //oParsing.sBaseTypeMLFB = sBaseTypeMLFB;


    if (oResult) {
        if (oResult.oProduct)
            oParsing.oProduct = oResult.oProduct;
        if (oResult.oParsingData)
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strError += ((oParsing.strError ? ' ' : '') + oResult.strError);
        oParsing.strWarning += ((oParsing.strWarning ? ' ' : '') + oResult.strWarning);
        oParsing.GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling")); // 0,1
        var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
        if (ECSI_CX_IsDriveTrain !== 1) {
            ECSI_CX_IsDriveTrain = 0;
        }
        oParsing.IsDriveTrain = ECSI_CX_IsDriveTrain; // 1/0 "true"/"false"
    }


    vtTimeStop = Date.getTime();
    vtTime = (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

    return (oParsing);
}

function parse_1FT7M(aTokens) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /*
    MLFB-Schema
    
    MLFB01	1
    MLFB02	F
    MLFB03	T
    MLFB04	7
    MLFB05	Achshöhe 1	{03, 04, 06, 08, 10, 13} entspr. AH 36, 48, 63, 80, 100, 132
    MLFB06	Achshöhe 2	PMD_ABP663_001_000_1FT7M
    MLFB07	Baulänge {2,4,5,6,7,8}		TAK_ABU212_001_000_1FT7M
    MLFB08	Motortyp (Merkmal) {1, 5, 7, 9} Kerntyp, Compact, High Dynamic, Sonderausführung	PMD_AAA259_001_000_1FT7M
    MLFB09	. Kühlung {A, W, S} Selbstkühlung, Wasserkühlung, Fremsbelüftung		PMD_AAA136_001_000_1FT7M
    MLFB10	Bemessungsdrehzahl	{B, C, F, H, K, Z} 
    MLFB11	Zwischenkreisspannung {7} 600...720V
    MLFB12	Flanschausführung	{0, 5, 1, 4} kompakt mit Drive CLiQ, ohne Drive CLiQ, klassisch mit, ohne
    MLFB13	Steckerabgangsrichtung / Klemmenkasten/Leitungseinführung 
    MLFB14	Geber 
    MLFB15	Wellenende / Wellen- und Flanschgenauigkeit / Haltebremse	
            PMD_AAA506_001_000_1FT7M		TAK_AAJ730_001_000_1FT7M		PMD_ABU276_001_000_1FT7M
    MLFB16	Schwinggrößenstufe / Schutzart 		PMD_AAB007_001_000_1FT7M		PMD_ABJ176_001_000_1FT7M
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.POS1 = strBaseMLFB.charAt(0);	//01 1
    oResult.oParsingData.MLFB.POS2 = strBaseMLFB.charAt(1);	//02 F
    oResult.oParsingData.MLFB.POS3 = strBaseMLFB.charAt(2);	//03 T
    oResult.oParsingData.MLFB.POS4 = strBaseMLFB.charAt(3);	//04 7
    oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt(4);	//05 Achshöhe 1	{03, 04, 06, 08, 10, 13} entspr. AH 36, 48, 63, 80, 100, 132
    oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt(5);	//06 Achshöhe 2	PMD_ABP663_001_000_1FT7M
    oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt(6);	//07 Baulänge {2,4,5,6,7,8}		TAK_ABU212_001_000_1FT7M
    oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt(7);	//08 Motortyp (Merkmal) {1, 5, 7, 9} Kerntyp, Compact, High Dynamic, Sonderausführung	PMD_AAA259_001_000_1FT7M
    oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt(8);	//09 .? Kühlung {A, W, S} Selbstkühlung, Wasserkühlung, Fremsbelüftung		PMD_AAA136_001_000_1FT7M
    oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9);	//10 Bemessungsdrehzahl	{B, C, F, H, K, Z}
    oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt(10);	//11 Zwischenkreisspannung {7} 600...720V
    oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt(11);	//12 .? Flanschausführung	{0, 5, 1, 4} kompakt mit Drive CLiQ, ohne Drive CLiQ, klassisch mit, ohne
    oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt(12);	//13 .? Steckerabgangsrichtung / Klemmenkasten/Leitungseinführung
    oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); //14 .? Geber
    oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); //15 .?A/B Wellenende / Wellen- und Flanschgenauigkeit / Haltebremse	
    oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); //16 .?0 Schwinggrößenstufe / Schutzart

    oResult.oParsingData.MLFB.POS1_4 = strBaseMLFB.substring(0, 4);

    oResult.oParsingData.AH = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5); // Achshöhe
    // HMK_BAUGROESSE_1FT7M 
    oResult.oParsingData.BAUGR = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5) + strBaseMLFB.charAt(6); //Baugröße MLFB AH+Baulänge
    ECL_SetValue("HMK_BAUGROESSE_1FT7M", oResult.oParsingData.BAUGR);

    // Kurzangaben
    if (aTokens.length > 0) {
        if (aTokens[0] === strBaseMLFB) {
            aTokens = removeElementsFromArray(aTokens, 0, 1);
        }
        oResult.oParsingData.MLFB.KAG = aTokens || [];

        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }

    return oResult;
}

function add_Rumpf(oResult) {
    var oMLFB = oResult.oParsingData.MLFB;
    var sTable = "VT_1FT7M_M00021" + sDB_Suffix;
    var sSQL = "SELECT HMK_RUMPF_1FT7M FROM " + sTable + " WHERE " +
        "MLFB05_1FT7M = '" + oResult.oParsingData.AH + "' AND " +
        "MLFB07_1FT7M = '" + oMLFB.POS7 + "' AND " +
        "MLFB08_1FT7M = '" + oMLFB.POS8 + "' AND " +
        "MLFB09_1FT7M = '" + oMLFB.POS9 + "' AND " +
        "MLFB10_1FT7M = '" + oMLFB.POS10 + "' AND " +
        "MLFB11_1FT7M = '" + oMLFB.POS11 + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSER");

    if (aResult.length > 0) {
        HMK_RUMPF_1FT7M = aResult[0].HMK_RUMPF_1FT7M;

        ECL_SetValue("HMK_RUMPF_1FT7M", HMK_RUMPF_1FT7M);
        oResult.oParsingData.RUMPF = HMK_RUMPF_1FT7M;

    } else {
        strError = "DICT1_ERR_1FT7M___PARSER_BESTIMMUNG_RUEMPFE_NO_DB_RESULT";
        return strError;
    }
    return oResult;
}

function add_ABV400(oResult) {
    // NEU:	VT_1FT7M_M00123
    var HMK_RUMPF_1FT7M = oResult.oParsingData.RUMPF;
    var sTable = "VT_1FT7M_M00123" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT PMD_ABV400_001_000_1FT7M FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FT7M = '" + HMK_RUMPF_1FT7M + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSER");
    if (aResult.length > 0) {

        var PMD_ABV400_001_000_1FT7M = aResult[0].PMD_ABV400_001_000_1FT7M;
        ECL_SetValue("PMD_ABV400_001_000_1FT7M", PMD_ABV400_001_000_1FT7M);
        oResult.oParsingData.ABV400 = PMD_ABV400_001_000_1FT7M;
    } else {
        strError = "DICT1_ERR_1FT7M___PARSER_BESTIMMUNG_ABV400_NO_DB_RESULT";
        return strError;
    }
    return oResult;
}
/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1) {
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {

    value = trimleft(value, '*');
    value = trimright(value, '*');

    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

    /*	zur Info - oParse: 
        {
            strBaseMLFB : '',
            strFullMLFB
            strError : '',
            strWarning : '',
            aTokens : [],
            oFreetext : {}
        };
    */
    if (find(oParse.strFullMLFB, 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('HMK_OPT_Y84_TXT_1FT7M', oParse.oFreetext['Y84']);
    }
}

function isKAGinMLFB(aArray, sKAG) {
    for (var i = 0; i < aArray.length; i++) {
        if (aArray[i] == sKAG)
            return true;
    }

    return false;
}
