//@legacy
//#mode(full-ecma)



//@import "VT_1FW3.js"


/*
Anschlusstechnik:
    PMD_ABU208_001_000_1FW3		Leistungsanschluss				00001	Klemmenkasten oben		**fix**
    PMD_AAB047_001_000_1FW3		Leistungseinführung				Q_R	Quer rechts
    
    HMK_M02_1FW3				F
    CB_M02_1FW3					M02 Klemmenkastentyp GK603 mit abnehmbarer Kabeleinführungsplatte mit 2 x M63 x 1,5
    
    HMK_P01_1FW3				F
    CB_P01_1FW3					P01 Abnehmbare Kabeleinführungsplatte mit 3 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7700

    HMK_P04_1FW3				F
    CB_P04_1FW3					P04 Abnehmbare Kabeleinführungsplatte mit 4 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7712
    
nicht mehr gültig:	
    HMK_K84_1FW3				F
    CB_K84_1FW3					K84 Steckerabgangsrichtung um -90° gedreht

*/

function SetAnschlusstechnik_Init(oData)
{
    if (oData && !isEmpty(oData)){
        
        Bestimme_Anschlusstechnik(oData);	// PMD_ABU208_001_000_1FW3 + PMD_AAB047_001_000_1FW3
        Bestimme_M02(oData);			// CB_M02_1FW3
        Bestimme_P01(oData);			// CB_P01_1FW3
        Bestimme_P04(oData);			// CB_P04_1FW3
        //Bestimme_K84(oData);			// CB_K84_1FW3
        
    }else{
        
        ExecSetStandardifValueEmpty("PMD_ABU208_001_000_1FW3","00001");	// fix
        ExecSetStandardifValueEmpty("PMD_AAB047_001_000_1FW3","Q_R");
        
    }
}

function SetOptionen(strchangedAttribute, oData)
{
}

/**
    

*/
function Bestimme_Anschlusstechnik(oData)
{
    // MLFB13
    var MLFB13_1FW3 = oData.oParsingData.MLFB.MLFB13;
    
    var sTable = "VT_1FW3_M00078" + sDB_Suffix;
    
    var sSQL = "SELECT PMD_AAB047_001_000_1FW3 FROM " + sTable + " WHERE " +
                "MLFB13_1FW3 = '" + MLFB13_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_AAB047_001_000_1FW3 = aResult[0].PMD_AAB047_001_000_1FW3;
        
        ECL_ActivateValue("PMD_AAB047_001_000_1FW3", PMD_AAB047_001_000_1FW3);
        ECL_SelectValue("PMD_AAB047_001_000_1FW3", PMD_AAB047_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_ANSCHL_NO_DB_RESULT";
		return;
    }
}



/**
    CB_M02_1FW3	
    HMK_M02_1FW3
    M02 Klemmenkastentyp GK603 mit abnehmbarer Kabeleinführungsplatte mit 2 x M63 x 1,5

*/
function Bestimme_M02(oData)
{
    // CB_M02_1FW3
    // KAG: M02, F

    var parseObj = oData.oParsingData;
    var aKAG = parseObj.MLFB.KAG || [];
    var sTargetAttribute = "HMK_M02_1FW3";
    var bCheck = false;
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "M02";
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkM02(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_M02_1FW3");
        ECL_SelectValue("CB_M02_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, NON setzen
    else{
        ECL_DeselectAttribute("CB_M02_1FW3");
    }
}
function checkM02(oData, sTargetAttribute, sKAG)
{
    /* 
    VT_1FW3_M00117	Opt M02 Klemmenkasten GK603
        HMK_RUMPF_1FW3	HMK_M02_1FW3	HMK_VALUE_VALID_1FW3

    */
    var HMK_RUMPF_1FW3 = oData.oParsingData.MLFB.RUMPF;
    
    var sTable = "VT_1FW3_M00117" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// HMK_P01_1FW3				P01/F
//	CB_P01_1FW3				P01 Abnehmbare Kabeleinführungsplatte mit 3 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7700
// ################################################################################################################
function Bestimme_P01(oData)
{
    // CB_P01_1FW3
    // KAG: P01, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_P01_1FW3";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "P01";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkP01(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_P01_1FW3");
        ECL_SelectValue("CB_P01_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, NON setzen
    else{
        ECL_DeselectAttribute("CB_P01_1FW3");
    }

}
function checkP01(oData, sTargetAttribute, sKAG)
{
    /* nur P01 oder P04, nicht beide!
    A VT_1FW3_M00164	Verriegelung P01 P04
        HMK_P01_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    
    B VT_1FW3_M00168	Opt P01 Kabeleinführungsplatte
        HMK_RUMPF_1FW3	HMK_P01_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3

    */
    // A
    if (ECL_ValueSelected("HMK_P04_1FW3", "T")){
        return 0;
    }
    // ----------------------------------------------------------
    // B
    var HMK_RUMPF_1FW3 = oData.oParsingData.MLFB.RUMPF;
    
    var sTable = "VT_1FW3_M00168" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
                "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // ----------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// HMK_P04_1FW3				F
//	CB_P04_1FW3				P04 Abnehmbare Kabeleinführungsplatte mit 4 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7712
// ################################################################################################################
function Bestimme_P04(oData)
{
    // CB_P04_1FW3
    // KAG: P04, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_P04_1FW3";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "P04";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkP04(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_P04_1FW3");
        ECL_SelectValue("CB_P04_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, NON setzen
    else{
        ECL_DeselectAttribute("CB_P04_1FW3");
    }

}
function checkP04(oData, sTargetAttribute, sKAG)
{
    /* nur P01 oder P04, nicht beide!
    A VT_1FW3_M00164	Verriegelung P01 P04
        HMK_P01_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    
    B VT_1FW3_M00163	Opt P04 Kabeleinführungsplatte
        HMK_RUMPF_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    */
    // A
    if (ECL_ValueSelected("HMK_P01_1FW3", "T")){
        return 0;
    }
    // ----------------------------------------------------------
    // B
    var HMK_RUMPF_1FW3 = oData.oParsingData.MLFB.RUMPF;
    
    var sTable = "VT_1FW3_M00163" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // ----------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
/* 	HMK_K84_1FW3				F
    CB_K84_1FW3					K84 Steckerabgangsrichtung um -90° gedreht
    
    nicht mehr für aktuelle Produkte!!!
* /
// ################################################################################################################
function Bestimme_K84(oData)
{
    // CB_K84_1FW3
    // KAG: K84, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_K84_1FW3";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "K84";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkK84(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_K84_1FW3");
        ECL_SelectValue("CB_K84_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, NON setzen
    else{
        ECL_DeselectAttribute("CB_K84_1FW3");
    }

}
function checkK84(oData, sTargetAttribute, sKAG)
{
    /* VT_1FW3_M00178	Opt K84 Steckerabgangsrichtung
        MLFB11_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_K84_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    * /
    
    var MLFB11_1FW3 = oData.oParsingData.MLFB.MLFB11;
    
    var sTable = "VT_1FW3_M00178" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB11_1FW3 = '" + MLFB11_1FW3 + "' AND " +
                "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }
    // ----------------------------------------------------------
    return 1;
}
// ################################################################################################################
*/