//@legacy
//#mode(full-ecma)


//@import "VT_1FW3.js"


// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration
function determineConsequences() {
    /*var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    */
    var oConsequences = {
        MaxRotationSpeedLimit: getN_Max(),
        AdditionalInertia: getAdditionalInertia(),
        IpProtectionLevelMotor: getIpProtectionLevelMotor(),
    }

    return oConsequences;
}

function getN_Max() {
    var PMD_ABV871_001_000_1002782 = ECL_GetValue("PMD_ABV871_001_000_1002782");

    return PMD_ABV871_001_000_1002782;
}

function getAdditionalInertia() {
    // if hollow-shaft selected return value from list, else 0
    // 1FW31501.H....C.

    /* AddInertia
            BASETYPE_ORDERNUMBER	ORDERNUMBER_WITH_SHAFTEND	SHAFTEND_TYPE	J_OF_MOTOR_WITH_SHAFT_END	J_FROM_BASETYPE_SOLID_SHAFT	J_ADD_CONFIG
    */

    var ECSI_MLFB = ECL_GetValue("ECSI_MLFB");
    var MLFB10_1FW3 = ECSI_MLFB.charAt(9);
    var MLFB15_1FW3 = ECSI_MLFB.charAt(14);

    var sMLFB_Pattern = ECSI_MLFB.substring(0, 8) + "." + MLFB10_1FW3 + "...." + MLFB15_1FW3 + ".";;

    var sSQL = "SELECT J_ADD_CONFIG FROM AddInertia WHERE ORDERNUMBER_WITH_SHAFTEND = '" + sMLFB_Pattern + "';";

    var aResult = Object.fromDatabase("1FW3_ADD_DATA", sSQL);

    if (aResult.length > 0) {
        var J_ADD_CONFIG = aResult[0]['J_ADD_CONFIG'];
        return J_ADD_CONFIG;
    } else {
        return "ERROR";
    }

    /*
    var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");
	
    if (PMD_AAA506_001_000_1FW3 == ){
    	
        // get value from list / table
    	
        return "0.11";
    	
    }else{
        return "0";
    }
    */
}


function getIpProtectionLevelMotor() {
    // PMD_ABJ176_001_000_1FW3  	Schutzart
    var IpProtectionLevelMotor = "";
    /*
    // PMD_ABJ176_001_000_1FW3	Schutzart IP				AH+MLFB08+MLFB15

    PMD_ABJ176_001_000_1FW3			MLFB15_1FW3
    Z0037	IP 54					A,C,D
    Z0003	IP 55					H,M,P,S

    */
    var PMD_ABJ176_001_000_1FW3 = ECL_GetValue("PMD_ABJ176_001_000_1FW3");

    switch (PMD_ABJ176_001_000_1FW3) {

        case "Z0037":
            IpProtectionLevelMotor = "54";
            break;

        case "Z0003":
            IpProtectionLevelMotor = "55";
            break;
    }
    return IpProtectionLevelMotor;
}