//@legacy
//#mode(full-ecma)



//@import "VT_1FW3.js"


function isLetter(strValue)
{
    var objRegExp  = /^[a-zA-Z]$/;
    return objRegExp.test(strValue);
}
    
function isDigit(strValue)
{
    var objRegExp  = /^\d/;
    return objRegExp.test(strValue);
}

function formatFreetext(ka, ft)
{
    // Keine Freitexte erzeugen, wenn Text leer ist; dies führt nämlich zu größeren Problemen im Sizer
    if (!ft || (ft == ''))
        return '';
        
    // Filterung von Sonderzeichen im Freitext: {, }
    ft = replace(ft, '{', '');
    ft = replace(ft, '}', '');
        
    // var strRet = '{' + ka + ': *' + ft + '*}';
    var strRet = '{' + ka + ':' + ft + '}';
    return strRet;
}

// Siehe hierzu auch die korrespondierende Funktion zum Parsen von Freitextangaben und
// befüllen der Attribute
function getFreetextSD(attrValNetto)
{
    var strRet = '';
    if (attrValNetto == 'Y84') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('HMK_Y84_TEXT_1FW3'));
    }
    return strRet;
}

/*

>>>> Diese Merkmale können einen Wert annehmen, der bedeutet, dass eine Klartextangabe erforderlich wird:
HMK_Y84_1FW3	Kundenangabe auf dem Leistungsschild	Customer specification on rating plate	Y84	Ja		Yes
HMK_Y84_1FW3	Kundenangabe auf dem Leistungsschild	Customer specification on rating plate	F	Nein	No

>>>> Diese Merkmale enthalten dann die Klartexte:
HMK_Y84_TEXT_1FW3	Kundenangabe auf dem Leistungsschild (Textfeld)	Customer specification on rating plate (text field)			

*/


/**
    Funktion zur Generierung der Kurzangaben anhand der gewählten Merkmale
    Beispiel für einen Fall mit Klartextangaben aus dem Bereich 2KJ:  
    2KJ3203-1BC21-4AK1-Z D01 +K01 +K08 +L02 +M55 +N38 +P91 +W21 +Y00 +Y80 {Y00: *LSK@myident*}{Y80: *RAL@5000*}
*/
function GenKAG(sBaseTypeMLFB, sECSI_MLFB)
{
    var newBaseMLFB = left(sECSI_MLFB, 16); //left(sBaseTypeMLFB, 16);
    
    // In erster Näherung können wir in Datenbank "1FT2_ADD_DATA.db3" die "Tabelle1" durchlaufen und für alle Attribute
    // schauen, ob der gesetzte Wert eine Kurzangabe hergibt (3 Stellen, nicht STD oder NON, Format ANN). Die übernehmen wir dann.
    // Zusätzlich müssen wir ...
    // - Kurzangaben die sich aus mehreren Attributen ergeben bestimmen (spezielle Tabellen)
    // - Klartextangaben generieren
    var aKag   = [];
    var aKagFt = []; // Free Texts

    // Wir gehen alle Attribute durch und schauen mal ob ein Wert mit Kurzangabe selektiert ist.
    // Bei Kurzangaben, die einen Klartext erfordern, bestimmen wir diesen auch
    var aResult = Object.fromDatabase("1FW3_ADD_DATA", "SELECT DISTINCT Attribute FROM DATA WHERE KAG = 'x' AND IsCB <> 'x';"); 
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['ATTRIBUTE'];
        var attrVal = ECL_GetValue(attrname); 
        // Die Attributwerte enthalten wohl nicht den Attributnamen, wohl aber die Dict-Ids der Werte
        // Sicherheitshalber strippen wir hier aber auch
        var attrValNetto = replace(attrVal, attrname, '');
        attrValNetto = replace(attrValNetto, '___', '');
        
        if ((attrValNetto.length == 3) && (attrValNetto != 'STD') && (attrValNetto != 'NON') ) {	// != 'ALT', 'MOT'
            if (isLetter(attrValNetto.charAt(0)) && isDigit(attrValNetto.charAt(1)) && (isDigit(attrValNetto.charAt(2)) || isLetter(attrValNetto.charAt(2))))
                aKag.push(attrValNetto);
                
            if (attrValNetto.charAt(0) == 'Y') {
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrValNetto);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    // Checkbox-Attribute
    var aResult = Object.fromDatabase("1FW3_ADD_DATA", "SELECT DISTINCT Attribute, Wert_ID FROM DATA WHERE IsCB = 'x' AND KAG = 'x'");
    
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['ATTRIBUTE'];
        var attrKAG = aResult[i]['WERT_ID'];
        var bKAG = ECL_ValueSelected(attrname, 'T');
        if (bKAG){
            aKag.push(attrKAG);
            
            // z.B. Y60
            if (attrKAG.charAt(0) == 'Y') {
                
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrKAG);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    // Ab hier beginnt der Zusammenbau des fertigen MLFB - Strings:
    
    aKag.sort();
    var kag = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKag.length; ++j) {
        kag += aKag[j] + '+';
    }
    kag = trimright(kag, '+');

    aKagFt.sort();
    var kagFT = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKagFt.length; ++j) {
        kagFT += aKagFt[j];
    }
    
    // Einfache Regel: Wenn Kurzangaben, dann "-Z" als Marker an der Grund-MLFB
    // Wir ignorieren hier fürs erste die Unterscheidung zwischen ergänzenden Angaben und besonderen Ausführungen
    var fullMLFB = newBaseMLFB + ((kag != '') ? ('-Z '+ kag) : '') + ((kagFT != '') ? ' ' : '') + kagFT; 
    
    return fullMLFB;
}





