//@legacy
//#mode(full-ecma)





/*
Motordaten:
    PMD_ACH516_001_000_1FW3	Achshöhe	MLFB05+06			15
    
    PMD_AAA271_001_000_1FW3	Motortyp 	MLFB08				00001

Wellenende:
    PMD_AAA506_001_000_1FW3		Wellenende					00002	Vollwelle im Standard Di (glatte Welle)

Lagerung:
    PMD_AAA069_001_000_1FW3		Lagerung					00001	Normal (Standard)
    UI_LAGERW_FRIST_1FW3		Lagerwechselfrist			aus VT153

Temperatursensor:
    HMK_TEMP_SENSOR_1FW3		Temperatursensor			00002	PT1000		MLFB14 

Bauform:
    PMD_AAC949_001_000_1FW3		Bauform						00011	IM B3

Leistungsdaten:
    PMD_ABV876_001_000_1002782	Stillstandsdrehmoment
    UI_NENNMOMENT_1FW3			Bemessungsdrehmoment
    PMD_ABV871_001_000_1002782	Maximaldrehzahl

Geber:
    PMD_ABU209_001_000_1FW3		DRIVE-CLiQ					F				MLFB14
    
    CB_DRIVE_CLIQ_1FW3			DRIVE-CLiQ					unchecked		MLFB14
    UI_GEBER_1FW3				Ausführung					OHNE	ohne
    UI_GEBER_AUFLOESUNG_1FW3	Auflösung					00003	ohne
    PMD_ABU278_001_000_1FW3		Gebersystem					00001	Ohne Geber
    PMD_ABV983_001_000_1FW3		Anbau Gebersystem			00001	Koaxialer Anbau		MLFB11 = 6, Riemen = 7

Schutzart:
    PMD_ABJ176_001_000_1FW3		Schutzart IP				Z0003	IP 55


*/

function SetMotor_Init(oData)
{
    if (oData && !isEmpty(oData)){
        
        Bestimme_Motordaten(oData);		// 
        Bestimme_Wellenende(oData);		// 
        Bestimme_Lagerung(oData);		// 
        Bestimme_TempSensor(oData);		// 
        Bestimme_Bauform(oData);		// 
        
        Bestimme_Leistungsdaten(oData);
        
        Bestimme_Geber(oData);		// 
        
        Bestimme_Schutzart(oData);		// 
        
        
    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("PMD_ACH516_001_000_1FW3","15");
        ExecSetStandardifValueEmpty("PMD_AAA271_001_000_1FW3","00001");
        
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FW3","00002");
        
        ExecSetStandardifValueEmpty("PMD_AAA069_001_000_1FW3","00001");
        ExecSetStandardifValueEmpty("UI_LAGERW_FRIST_1FW3","20000");
        
        ExecSetStandardifValueEmpty("HMK_TEMP_SENSOR_1FW3","00002");
        
        ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1FW3","00011");
        
        ExecSetStandardifValueEmpty("UI_GEBER_1FW3","OHNE");
        ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FW3","00003");
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FW3","00001");
        ExecSetStandardifValueEmpty("PMD_ABV983_001_000_1FW3","00001");
        
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FW3","Z0003");
    }
}

function SetMotor(strchangedAttribute, oData)
{
}
// #########################################################################################################################
/**
Motordaten:
    PMD_ACH516_001_000_1FW3	Achshöhe	MLFB05+06			15
    
    PMD_AAA271_001_000_1FW3	Motortyp 	MLFB08				00001
*/
// #########################################################################################################################
function Bestimme_Motordaten(oData)
{
    
    var oParsingData = oData.oParsingData;
    
    // -----------------------------------------------------------------------------------------------------------
    // Achshöhe:			MLFB05+06
    // -----------------------------------------------------------------------------------------------------------
    // 
    var MLFB05_1FW3 = oParsingData.MLFB.MLFB05;
    
    var PMD_ACH516_001_000_1FW3 = MLFB05_1FW3 + "0";
    
    ECL_DeactivateAllAttributeValues("PMD_ACH516_001_000_1FW3");
    
    ECL_ActivateValue("PMD_ACH516_001_000_1FW3", PMD_ACH516_001_000_1FW3);
    ECL_SelectValue("PMD_ACH516_001_000_1FW3", PMD_ACH516_001_000_1FW3);
    
    // -----------------------------------------------------------------------------------------------------------
    // Motortyp
    // -----------------------------------------------------------------------------------------------------------
    // PMD_AAA271_001_000_1FW3	Motortyp		MLFB08

    /*	00001	Standard	1
        00002	High Speed	3
        00003	High Torque	2
    */
    
    var MLFB08_1FW3 = oParsingData.MLFB.MLFB08;
    
    switch (MLFB08_1FW3){
        case "1":	// Standard
            var PMD_AAA271_001_000_1FW3 = "00001";
        break;
        case "2":	// High Torque
            var PMD_AAA271_001_000_1FW3 = "00003";
        break;
        case "3":	// High Speed
            var PMD_AAA271_001_000_1FW3 = "00002";
        break;
        default:
            var PMD_AAA271_001_000_1FW3 = "00001";
    }
    ECL_DeactivateAllAttributeValues("PMD_AAA271_001_000_1FW3");
    
    ECL_ActivateValue("PMD_AAA271_001_000_1FW3", PMD_AAA271_001_000_1FW3);
    ECL_SelectValue("PMD_AAA271_001_000_1FW3", PMD_AAA271_001_000_1FW3);
    
    
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Wellenende:
    PMD_AAA506_001_000_1FW3		Wellenende					00002	Vollwelle im Standard Di (glatte Welle)
*/
// #########################################################################################################################
function Bestimme_Wellenende(oData)
{
    
    var MLFB15_1FW3 = oData.oParsingData.MLFB.MLFB15;
    
    /*
    VT_1FW3_M00084
    MLFB15_1FW3	PMD_AAA506_001_000_1FW3	PMD_ACM689_001_000_1FW3	HMK_VALUE_VALID_1FW3
    A			00001					HOHL 					T    
    C			00006					HOHL 					T    
    M			00002					VOLL 					T    
    P			00003					AUFST					T    
    S			00004					AUFST					T    
    H			00005					VOLL 					T    
    */
    
    var sTable = "VT_1FW3_M00084" + sDB_Suffix;
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_AAA506_001_000_1FW3 = aResult[0].PMD_AAA506_001_000_1FW3;
        
        ECL_ActivateValue("PMD_AAA506_001_000_1FW3", PMD_AAA506_001_000_1FW3);
        ECL_SelectValue("PMD_AAA506_001_000_1FW3", PMD_AAA506_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_SHAFTEND_NO_DB_RESULT";
		return;
    }
    
}
// #########################################################################################################################

// #########################################################################################################################
/**
    Bestimme_Lagerung
    Lagerung:
    PMD_AAA069_001_000_1FW3		Lagerung					00001	Normal (Standard)
    UI_LAGERW_FRIST_1FW3		Lagerwechselfrist			aus VT153
*/
// #########################################################################################################################
function Bestimme_Lagerung(oData)
{
    var MLFB15_1FW3 = oData.oParsingData.MLFB.MLFB15;
    var MLFB16_1FW3 = oData.oParsingData.MLFB.MLFB16;
    var HMK_RUMPF_1FW3 = oData.oParsingData.MLFB.RUMPF;
    // ################################################################################################################
    // Lagerung			PMD_AAA069_001_000_1FW3			MLFB16
    // ################################################################################################################
    /* VT_1FW3_M00009
    MLFB16_1FW3	PMD_AAA069_001_000_1FW3	HMK_VALUE_VALID_1FW3
    0			00001	T    
    3			00002	T    
    7			00003	T    
    8			00004	T    
    */
    var sTable = "VT_1FW3_M00009" + sDB_Suffix;
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB16_1FW3 = '" + MLFB16_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_AAA069_001_000_1FW3 = aResult[0].PMD_AAA069_001_000_1FW3;
        
        ECL_ActivateValue("PMD_AAA069_001_000_1FW3", PMD_AAA069_001_000_1FW3);
        ECL_SelectValue("PMD_AAA069_001_000_1FW3", PMD_AAA069_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_LAGERUNG_NO_DB_RESULT";
		return;
    }
    
    /*	ggf. im PL-Skript bestimmen, da nur Info und abhängig von Optionen
    Lagerwechselfrist		UI_LAGERW_FRIST_1FW3	aus VT153
    VT_1FW3_M00153
    
    HMK_RUMPF_1FW3	MLFB15_1FW3	HMK_K40_1FW3	HMK_L03_H_1FW3	UI_LAGERW_FRIST_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    
    var sTable = "VT_1FW3_M00153" + sDB_Suffix;
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
                "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var UI_LAGERW_FRIST_1FW3 = aResult[0].UI_LAGERW_FRIST_1FW3;
        
        ECL_DeactivateAllAttributeValues("UI_LAGERW_FRIST_1FW3");
        ECL_ActivateValue("UI_LAGERW_FRIST_1FW3", UI_LAGERW_FRIST_1FW3);
        ECL_SelectValue("UI_LAGERW_FRIST_1FW3", UI_LAGERW_FRIST_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_LAGERUNG_NO_DB_RESULT";
		return;
    }
    
}
// #########################################################################################################################

// #########################################################################################################################
/**
Temperatursensor:
    HMK_TEMP_SENSOR_1FW3		Temperatursensor			00002	PT1000		MLFB14 
*/
// #########################################################################################################################
function Bestimme_TempSensor(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB14_1FW3 = oMLFB.MLFB14;
    
    //if (MLFB14_1FW3 == "D"){
        var HMK_TEMP_SENSOR_1FW3 = "00002";
    //}else{	// A
    //	var HMK_TEMP_SENSOR_1FW3 = "00001"; // todo prüfen, ob KTY noch zulässig
    //}
    
    ECL_ActivateValue("HMK_TEMP_SENSOR_1FW3", HMK_TEMP_SENSOR_1FW3);
    ECL_SelectValue("HMK_TEMP_SENSOR_1FW3", HMK_TEMP_SENSOR_1FW3);
    
}
// #########################################################################################################################

// ################################################################################################################
// Bauform
// ################################################################################################################
/*
Bauform:
    PMD_AAC949_001_000_1FW3		Bauform						00011	IM B3
    
    VT_1FW3_M00156
    MLFB12_1FW3	PMD_AAC949_001_000_1FW3	HMK_VALUE_VALID_1FW3

*/
function Bestimme_Bauform(oData)
{
    var MLFB12_1FW3 = oData.oParsingData.MLFB.MLFB12;
    
    sTable = "VT_1FW3_M00156" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_AAC949_001_000_1FW3 = aResult[0].PMD_AAC949_001_000_1FW3;
        
        ECL_ActivateValue("PMD_AAC949_001_000_1FW3", PMD_AAC949_001_000_1FW3);
        ECL_SelectValue("PMD_AAC949_001_000_1FW3", PMD_AAC949_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_DESIGN_NO_DB_RESULT";
		return;
    }
}
// ################################################################################################################


// ################################################################################################################
// Leistungsdaten
// ################################################################################################################
/*
Leistungsdaten:
    PMD_ABV876_001_000_1002782	Stillstandsdrehmoment
    UI_NENNMOMENT_1FW3			Bemessungsdrehmoment
    PMD_ABV871_001_000_1002782	Maximaldrehzahl			zunächst nur max-N

VT_1FW3_M00185
    HMK_RUMPF_1FW3	HMK_SPG_KONSTANTE_1FW3	PMD_AAB326_001_000_1FW3	PMD_ABJ554_001_000_1002782	PMD_ABV783_001_000_1009260	PMD_ABV863_001_000_1FW3	PMD_ABV867_001_000_1FW3	PMD_ABV871_001_000_1002782	PMD_ABV872_001_000_1FW3	PMD_ABV876_001_000_1002782	PMD_ABV884_001_000_1009260	PMD_ACH264_001_000_1002782	HMK_VALUE_VALID_1FW3

*/

function Bestimme_Leistungsdaten(oData)
{
    var HMK_RUMPF_1FW3 = oData.oParsingData.MLFB.RUMPF;
    
    sTable = "VT_1FW3_M00185" + sDB_Suffix;

    var sSQL = "SELECT PMD_ABV876_001_000_1002782, PMD_ABV871_001_000_1002782 FROM " + sTable + " WHERE " +
                "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        //var PMD_ABV876_001_000_1002782 = aResult[0].PMD_ABV876_001_000_1002782;
        var PMD_ABV871_001_000_1002782 = aResult[0].PMD_ABV871_001_000_1002782;
        
        //ECL_SetValue("PMD_ABV876_001_000_1002782", PMD_ABV876_001_000_1002782);
        ECL_SetValue("PMD_ABV871_001_000_1002782", PMD_ABV871_001_000_1002782);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_POWER_DATA_NO_DB_RESULT";
		return;
    }
}
// ################################################################################################################



// ################################################################################################################
// GEBER
// ################################################################################################################
/*
Geber:
    PMD_ABU209_001_000_1FW3		DRIVE-CLiQ					F				MLFB14
    
    CB_DRIVE_CLIQ_1FW3			DRIVE-CLiQ					unchecked		MLFB14
    UI_GEBER_1FW3				Ausführung					OHNE	ohne
    UI_GEBER_AUFLOESUNG_1FW3	Auflösung					00003	ohne
    PMD_ABU278_001_000_1FW3		Gebersystem					00001	Ohne Geber
    PMD_ABV983_001_000_1FW3		Anbau Gebersystem			00001	Koaxialer Anbau		MLFB11 = 6, Riemen = 7
    
    VT_1FW3_M00106	Geber<>MLFB09
        PMD_ABU278_001_000_1FW3	PMD_ABU209_001_000_1FW3	UI_GEBER_1FW3	UI_GEBER_AUFLOESUNG_1FW3	MLFB09_1FW3	HMK_VALUE_VALID_1FW3

*/
function Bestimme_Geber(oData)
{
	var MLFB09_1FW3 = oData.oParsingData.MLFB.MLFB09;
	
	sTable = "VT_1FW3_M00106" + sDB_Suffix;

	var sSQL = "SELECT * FROM " + sTable + " WHERE " +
				"MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
				"HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var PMD_ABU278_001_000_1FW3 = aResult[0].PMD_ABU278_001_000_1FW3;		// Geber
        var PMD_ABU209_001_000_1FW3 = aResult[0].PMD_ABU209_001_000_1FW3;		// DriveCLiQ
        var UI_GEBER_1FW3 = aResult[0].UI_GEBER_1FW3;							// Ausführung
        var UI_GEBER_AUFLOESUNG_1FW3 = aResult[0].UI_GEBER_AUFLOESUNG_1FW3;		// Auflösung
        
        ECL_ActivateValue("PMD_ABU278_001_000_1FW3", PMD_ABU278_001_000_1FW3);
        ECL_SelectValue("PMD_ABU278_001_000_1FW3", PMD_ABU278_001_000_1FW3);
        
        if (PMD_ABU209_001_000_1FW3 == "T"){
            ECL_SelectValue("CB_DRIVE_CLIQ_1FW3", "T");
        }else{
            ECL_DeselectAttribute("CB_DRIVE_CLIQ_1FW3");
        }
        
        ECL_ActivateValue("UI_GEBER_1FW3", UI_GEBER_1FW3);
        ECL_SelectValue("UI_GEBER_1FW3", UI_GEBER_1FW3);
        
        ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FW3", UI_GEBER_AUFLOESUNG_1FW3);
        ECL_SelectValue("UI_GEBER_AUFLOESUNG_1FW3", UI_GEBER_AUFLOESUNG_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_GEBER_NO_DB_RESULT";
		return;
    }
    
    
    // Anbau Gebersystem
    // PMD_ABV983_001_000_1FW3	Anbau Gebersystem			MLFB11
    
    /* VT_1FW3_M00015	Geberanbau, Stoßspg <> MLFB11
        MLFB11_1FW3	PMD_AAD945_001_000_1002782	PMD_ABV983_001_000_1FW3	HMK_VALUE_VALID_1FW3
    */
    var MLFB11_1FW3 = oData.oParsingData.MLFB.MLFB11;
    
    sTable = "VT_1FW3_M00015" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB11_1FW3 = '" + MLFB11_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_ABV983_001_000_1FW3 = aResult[0].PMD_ABV983_001_000_1FW3;
        
        ECL_ActivateValue("PMD_ABV983_001_000_1FW3", PMD_ABV983_001_000_1FW3);
        ECL_SelectValue("PMD_ABV983_001_000_1FW3", PMD_ABV983_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_GEBERSYSTEM_NO_DB_RESULT";
		return;
    }
}

// ################################################################################################################
/* 
    Schutzart:
    PMD_ABJ176_001_000_1FW3		Schutzart IP				Z0003	IP 55
    
    Z0037	IP 54
    Z0003	IP 55
    
    aus VT83	AH+MLFB08+MLFB15
        HMK_MLFB05_06_1FW3	MLFB08_1FW3	MLFB15_1FW3	PMD_ABJ176_001_000_1FW3	HMK_VALUE_VALID_1FW3

*/
// ################################################################################################################
function Bestimme_Schutzart(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var HMK_MLFB05_06_1FW3 = oMLFB.MLFB05;
    var MLFB08_1FW3 = oMLFB.MLFB08;
    var MLFB15_1FW3 = oMLFB.MLFB15;
    
    sTable = "VT_1FW3_M00083" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
                "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
                "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var PMD_ABJ176_001_000_1FW3 = aResult[0].PMD_ABJ176_001_000_1FW3;
        
        ECL_ActivateValue("PMD_ABJ176_001_000_1FW3", PMD_ABJ176_001_000_1FW3);
        ECL_SelectValue("PMD_ABJ176_001_000_1FW3", PMD_ABJ176_001_000_1FW3);
    }else{
		oData.strError = "DICT1_ERR_1FW3___PARSER_SCHUTZART_NO_DB_RESULT";
		return;
    }
}

// ################################################################################################################
