//@legacy
//#mode(full-ecma)



//@import "VT_1FW3.js"


/*
Leistungsschild:
    HMK_Y84_1FW3		Kundenangabe auf dem Leistungsschild		F
    HMK_Y84_TEXT_1FW3	Kundenangabe auf dem Leistungsschild

Farbe:
    HMK_FARBAUSF_1FW3	Ausführung						LACK	Lackierung
    HMK_K24_1FW3		Grundierung (ohne Lackierung)	F
    
    PMD_AAD756_001_000_1002782	Farbe		00001	Anthrazit RAL 7016 (Standard)
    
    HMK_Q95_1FW3	Sonderlack ALEXIT
    CB_Q95_1FW3		Q95 Sonderlack ALEXIT

Werkprüfbescheinigung:	
    HMK_B02_1FW3	Werksprüfzeugnis
    CB_B02_1FW3		B02 Werksprüfzeugnis

Zubehör:
    HMK_Q30_1FW3	Spannelement
    CB_Q30_1FW3		Q30 Spannelement

    HMK_T32_1FW3	Statordrehmomentenstütze
    CB_T32_1FW3		T32 Statordrehmomentenstütze

Gebersystem:
    HMK_OPT_KALTLEITER_1FW3		Motorschutz durch Kaltleiter (3 x PTC)
    CB_A11_1FW3					A11 Motorschutz durch Kaltleiter (3 x PTC)

Wellenende und Flansch:
    HMK_WELLENABDECKUNG_1FW3	Wellenabdeckung auf NDE
    CB_T20_1FW3					T20 Wellenabdeckung auf NDE

Schmierung und Dichtung:
    HMK_OPT_NACHSCHMIER_1FW3	Nachschmiereinrichtung
    CB_K40_1FW3					K40 Nachschmiereinrichtung
    
    HMK_V07_1FW3				Sonderbefettung für niedrige Drehzahlen
    CB_V07_1FW3					V07 Sonderbefettung für niedrige Drehzahlen

Sonstiges:
    HMK_L03_1FW3	Erhöhte Rüttelbeanspruchung (Heavy Duty)
    CB_L03_1FW3		L03 Erhöhte Rüttelbeanspruchung (Heavy Duty)
    
    HMK_G50_1FW3	Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung
    CB_G50_1FW3		G50 Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung

*/

function SetOptionen_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Y84_1FW3(oData);			// HMK_Y84_1FW3	Kundenangabe auf dem Leistungsschild

        Bestimme_Farbe_1FW3(oData); 			// 	Farbe

        Bestimme_B02_1FW3(oData); 			// B02 Werksprüfzeugnis

        Bestimme_Q30_1FW3(oData); 			// HMK_Q30_1FW3	Spannelement
        Bestimme_T32_1FW3(oData);			// HMK_T32_1FW3	Statordrehmomentenstütze

        Bestimme_A11_1FW3(oData);			// HMK_OPT_KALTLEITER_1FW3		A11 Motorschutz durch Kaltleiter (3 x PTC)

        Bestimme_T20_1FW3(oData);			// HMK_WELLENABDECKUNG_1FW3	Wellenabdeckung auf NDE

        Bestimme_K40_1FW3(oData);			// HMK_OPT_NACHSCHMIER_1FW3		K40 Nachschmiereinrichtung
        Bestimme_V07_1FW3(oData);			// HMK_V07_1FW3					V07 Sonderbefettung für niedrige Drehzahlen

        Bestimme_L03_1FW3(oData);			// HMK_L03_1FW3					L03 Erhöhte Rüttelbeanspruchung (Heavy Duty)
        Bestimme_G50_1FW3(oData);			// HMK_G50_1FW3					G50 Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung

    } else {

        ExecSetStandardifValueEmpty("HMK_Y84_1FW3", "F");
        ECL_SetValue("HMK_Y84_TEXT_1FW3", "");

        ExecSetStandardifValueEmpty("HMK_FARBAUSF_1FW3", "LACK");
        ExecSetStandardifValueEmpty("HMK_K24_1FW3", "F");
        ExecSetStandardifValueEmpty("PMD_AAD756_001_000_1002782", "00001");

    }
}

function SetOptionen(strchangedAttribute, oData) {
}


// ################################################################################################################
// Bestimme_Y84(oData)
// ################################################################################################################
function Bestimme_Y84_1FW3(oData) {
    // HMK_Y84_1FW3
    // KAG: Y84, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_Y84_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, immer erlaubt, also setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SelectValue(sTargetAttribute, "F");
    }
}

// ################################################################################################################
/**
    HMK_FARBAUSF_1FW3	Ausführung						LACK	Lackierung
    HMK_K24_1FW3		Grundierung (ohne Lackierung)	F
    
    PMD_AAD756_001_000_1002782	Farbe		00001	Anthrazit RAL 7016 (Standard)
    
    HMK_Q95_1FW3	Sonderlack ALEXIT
    CB_Q95_1FW3		Q95 Sonderlack ALEXIT

*/
// ################################################################################################################
function Bestimme_Farbe_1FW3(oData) {
    // wenn K24, dann nur Grundierung, keine Lackierung/Farbe
    // Farbe aus KAG bestimmen, sonst STD
    var sTargetAttribute = "HMK_K24_1FW3";
    var sKAG = "K24";
    var aKAG = oData.oParsingData.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // Fabe auf "OHNE" setzen
        var bFarbe = false;
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
        // HMK_FARBAUSF_1FW3
        ECL_ActivateValue("HMK_FARBAUSF_1FW3", "GRUND");
        ECL_SelectValue("HMK_FARBAUSF_1FW3", "GRUND");
    }
    // wenn keine KAG, F setzen
    else {
        var bFarbe = true;
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SelectValue(sTargetAttribute, "F");
        // HMK_FARBAUSF_1FW3
        ECL_ActivateValue("HMK_FARBAUSF_1FW3", "LACK");
        ECL_SelectValue("HMK_FARBAUSF_1FW3", "LACK");
    }

    if (bFarbe) {
        // Farbe aus KAG bestimmen, sonst STD
        var sTargetAttribute = "PMD_AAD756_001_000_1002782";

        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

        if (sKAG != "NON") {
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SelectValue(sTargetAttribute, sKAG);
        } else {
            ECL_ActivateValue(sTargetAttribute, "00001");
            ECL_SelectValue(sTargetAttribute, "00001");
        }
    } else {
        ECL_ActivateValue(sTargetAttribute, "OHNE");
        ECL_SelectValue(sTargetAttribute, "OHNE");
    }

    // Q95
    /* 	HMK_Q95_1FW3	Sonderlack ALEXIT
        CB_Q95_1FW3		Q95 Sonderlack ALEXIT
    nur wenn nicht K24
    */
    if (bFarbe) {
        var sTargetAttribute = "HMK_Q95_1FW3";
        var sKAG = "Q95";

        if (aKAG.indexOf(sKAG) > -1) {
            ECL_EnableAttribute("CB_Q95_1FW3");
            ECL_SelectValue("CB_Q95_1FW3", "T");
        }
        // wenn keine KAG oder nicht erlaubt, deselect
        else {
            ECL_DeselectAttribute("CB_Q95_1FW3");
        }
    }

}

// ################################################################################################################
/* Werkprüfbescheinigung:	
    HMK_B02_1FW3	Werksprüfzeugnis
    CB_B02_1FW3		B02 Werksprüfzeugnis
*/
// ################################################################################################################
function Bestimme_B02_1FW3(oData) {
    // HMK_B02_1FW3
    // KAG: B02, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_B02_1FW3";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B02";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute("CB_B02_1FW3");
        ECL_SelectValue("CB_B02_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute("CB_B02_1FW3");
    }

}

// ################################################################################################################
/**
Zubehör:
    HMK_Q30_1FW3	Spannelement
    CB_Q30_1FW3		Q30 Spannelement

*/
// ################################################################################################################

function Bestimme_Q30_1FW3(oData) {
    // HMK_Q30_1FW3
    // KAG: Q30, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_Q30_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q30";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkQ30_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_Q30_1FW3");
        ECL_SelectValue("CB_Q30_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute("CB_Q30_1FW3");
    }
}
function checkQ30_1FW3(oData, sTargetAttribute, sKAG) {
    /* 
    VT_1FW3_M00043	Opt Q30 Spannelement
        HMK_Q30_1FW3	HMK_MLFB05_06_1FW3	MLFB15_1FW3	MLFB16_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    //--------------------------------------------------------------------------------------------------------------
    var HMK_MLFB05_06_1FW3 = oData.oParsingData.MLFB.MLFB05;
    var MLFB15_1FW3 = oData.oParsingData.MLFB.MLFB15;
    var MLFB16_1FW3 = oData.oParsingData.MLFB.MLFB16;

    var sTable = "VT_1FW3_M00043" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "MLFB16_1FW3 = '" + MLFB16_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################
/*
    HMK_T32_1FW3	Statordrehmomentenstütze
    CB_T32_1FW3		T32 Statordrehmomentenstütze
    
    Bestimme_T32(oData);			// HMK_T32_1FW3	Statordrehmomentenstütze
*/
function Bestimme_T32_1FW3(oData) {
    // HMK_T32_1FW3
    // KAG: Q30, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_T32_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "T32";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkT32_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_EnableAttribute("CB_T32_1FW3");
        ECL_SelectValue("CB_T32_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute("CB_T32_1FW3");
    }
}
function checkT32_1FW3(oData, sTargetAttribute, sKAG) {
    /* 
    VT_1FW3_M00041	Opt T32 Drehmomentstütze
        HMK_T32_1FW3	HMK_MLFB05_06_1FW3	MLFB15_1FW3	MLFB16_1FW3	HMK_VALUE_VALID_1FW3
    */
    //--------------------------------------------------------------------------------------------------------------
    var HMK_MLFB05_06_1FW3 = oData.oParsingData.MLFB.MLFB05;
    var MLFB15_1FW3 = oData.oParsingData.MLFB.MLFB15;
    var MLFB16_1FW3 = oData.oParsingData.MLFB.MLFB16;

    var sTable = "VT_1FW3_M00041" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "MLFB16_1FW3 = '" + MLFB16_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
/* Gebersystem:
    HMK_OPT_KALTLEITER_1FW3		Motorschutz durch Kaltleiter (3 x PTC)
    CB_A11_1FW3					A11 Motorschutz durch Kaltleiter (3 x PTC)
*/
// ################################################################################################################
function Bestimme_A11_1FW3(oData) {
    // HMK_OPT_KALTLEITER_1FW3
    // KAG: A11, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_KALTLEITER_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "A11";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute("CB_A11_1FW3");
        ECL_SelectValue("CB_A11_1FW3", "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute("CB_A11_1FW3");
    }
}

// ################################################################################################################

/*
Wellenende und Flansch:
    HMK_WELLENABDECKUNG_1FW3	Wellenabdeckung auf NDE
    CB_T20_1FW3					T20 Wellenabdeckung auf NDE
*/
function Bestimme_T20_1FW3(oData) {
    // HMK_WELLENABDECKUNG_1FW3
    // KAG: T20, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_WELLENABDECKUNG_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "T20";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkT20_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute("CB_T20_1FW3");
        ECL_SelectValue("CB_T20_1FW3", "T");
    } else {
        ECL_DeselectAttribute("CB_T20_1FW3");
    }
}
function checkT20_1FW3(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
    VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
        HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    
    HMK_KEY_GEBER_1FW3 bei 'AKT' immer OHNE
    */
    var HMK_RUMPF_16_1FW3 = oData.oParsingData.MLFB.RUMPF_16;
    var HMK_RUMPF_9_11_12_15_1FW3 = oData.oParsingData.MLFB.RUMPF09_15;

    var sTable = "VT_1FW3_M00180" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_KEY_GEBER_1FW3 = 'OHNE' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################

/*
Schmierung und Dichtung:
    HMK_OPT_NACHSCHMIER_1FW3	Nachschmiereinrichtung
    CB_K40_1FW3					K40 Nachschmiereinrichtung
    
*/
function Bestimme_K40_1FW3(oData) {
    // HMK_OPT_NACHSCHMIER_1FW3
    // KAG: K40, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_OPT_NACHSCHMIER_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "K40";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkK40_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute("CB_K40_1FW3");
        ECL_SelectValue("CB_K40_1FW3", "T");
    } else {
        ECL_DeselectAttribute("CB_K40_1FW3");
    }
}
function checkK40_1FW3(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
    nn VT_1FW3_M00066	Opt K40 <-> V07 Schmierung
        HMK_MLFB05_06_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_V07_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00162	Opt K40 Nachschmier
        HMK_MLFB05_06_1FW3	MLFB09_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var HMK_MLFB05_06_1FW3 = oData.oParsingData.MLFB.MLFB05;
    var MLFB09_1FW3 = oData.oParsingData.MLFB.MLFB09;

    var sTable = "VT_1FW3_M00162" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB08_1FW3 = oData.oParsingData.MLFB.MLFB08;

    var PMD_ACH516_001_000_1FW3 = ECL_GetValue("PMD_ACH516_001_000_1FW3");
    var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");

    var sTable = "VT_1FW3_M00189" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ACH516_001_000_1FW3 = '" + PMD_ACH516_001_000_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "PMD_AAA506_001_000_1FW3 = '" + PMD_AAA506_001_000_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------------------

    return 1;
}
// ################################################################################################################
/*
Schmierung und Dichtung:
    HMK_V07_1FW3				Sonderbefettung für niedrige Drehzahlen
    CB_V07_1FW3					V07 Sonderbefettung für niedrige Drehzahlen

*/
function Bestimme_V07_1FW3(oData) {
    // HMK_V07_1FW3
    // KAG: V07, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_V07_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "V07";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkV07_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute("CB_V07_1FW3");
        ECL_SelectValue("CB_V07_1FW3", "T");
    } else {
        ECL_DeselectAttribute("CB_V07_1FW3");
    }
}
function checkV07_1FW3(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
    VT_1FW3_M00066	Opt K40 <-> V07 Schmierung
    VT_1FW3_M00067	Opt V07 Sonderfett
        HMK_MLFB05_06_1FW3	MLFB08_1FW3	HMK_V07_1FW3	HMK_VALUE_VALID_1FW3

    */
    var HMK_MLFB05_06_1FW3 = oData.oParsingData.MLFB.MLFB05;
    var MLFB08_1FW3 = oData.oParsingData.MLFB.MLFB08;

    var sTable = "VT_1FW3_M00067" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
/*
Sonstiges:
    HMK_L03_1FW3	Erhöhte Rüttelbeanspruchung (Heavy Duty)
    CB_L03_1FW3		L03 Erhöhte Rüttelbeanspruchung (Heavy Duty)
*/
function Bestimme_L03_1FW3(oData) {
    // HMK_L03_1FW3
    // KAG: L03, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_L03_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L03";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkL03_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute("CB_L03_1FW3");
        ECL_SelectValue("CB_L03_1FW3", "T");
    } else {
        ECL_DeselectAttribute("CB_L03_1FW3");
    }
}
function checkL03_1FW3(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
    VT_1FW3_M00174	Opt_Pflicht L03 Erh Ruettelfest
        HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_L03_1FW3	HMK_HINW_L03_PFLICHT_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00175	Verriegelung MLFB13 L03
        HMK_RUMPF_9_11_12_15_1FW3	MLFB13_1FW3	HMK_L03_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00189	AH - Options K40 - L03
    PMD_ACH516_001_000_1FW3	MLFB08_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_L03_1FW3	PMD_AAA506_001_000_1FW3
	
    */
    var HMK_RUMPF_16_1FW3 = oData.oParsingData.MLFB.RUMPF_16;
    var HMK_RUMPF_9_11_12_15_1FW3 = oData.oParsingData.MLFB.RUMPF09_15;
    var MLFB13_1FW3 = oData.oParsingData.MLFB.MLFB13;

    var sTable = "VT_1FW3_M00174" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------

    var sTable = "VT_1FW3_M00175" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "MLFB13_1FW3 = '" + MLFB13_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB08_1FW3 = oData.oParsingData.MLFB.MLFB08;
    if (ECL_ValueSelected("CB_K40_1FW3", "T")) {
        var HMK_OPT_NACHSCHMIER_1FW3 = "K40";
    } else {
        var HMK_OPT_NACHSCHMIER_1FW3 = "F";
    }
    var PMD_ACH516_001_000_1FW3 = ECL_GetValue("PMD_ACH516_001_000_1FW3");
    var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");

    var sTable = "VT_1FW3_M00189" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ACH516_001_000_1FW3 = '" + PMD_ACH516_001_000_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "HMK_OPT_NACHSCHMIER_1FW3 = '" + HMK_OPT_NACHSCHMIER_1FW3 + "' AND " +
        "PMD_AAA506_001_000_1FW3 = '" + PMD_AAA506_001_000_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------

    return 1;
}
// ################################################################################################################

// ################################################################################################################
/*
Sonstiges:
    HMK_G50_1FW3	Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung
    CB_G50_1FW3		G50 Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung
*/
function Bestimme_G50_1FW3(oData) {
    // HMK_G50_1FW3
    // KAG: G50, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "HMK_G50_1FW3";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G50";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkG50_1FW3(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute("CB_G50_1FW3");
        ECL_SelectValue("CB_G50_1FW3", "T");
    } else {
        ECL_DeselectAttribute("CB_G50_1FW3");
    }
}
function checkG50_1FW3(oData, sTargetAttribute, sKAG) {
    //--------------------------------------------------------------------------------------------------------------
    /*
    VT_1FW3_M00166	Opt G50 Sonderlagerschild
        HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_G50_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    */
    var HMK_RUMPF_16_1FW3 = oData.oParsingData.MLFB.RUMPF_16;
    var HMK_RUMPF_9_11_12_15_1FW3 = oData.oParsingData.MLFB.RUMPF09_15;

    var sTable = "VT_1FW3_M00166" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}