//@legacy
//#mode(full-ecma)

//@import "../1FW3_MLFB/Base.misc.js"

//@import "VT_1FW3.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    // var sMLFB1_4 = sMLFB.left(4);
    // var MLFB01_1FW3 = sMLFB.left(4);

    var MLFB05_1FW3 = sMLFB.charAt(4) + sMLFB.charAt(5); //Achshöhe
    var MLFB08_1FW3 = sMLFB.charAt(7); //Motortyp
    var MLFB09_1FW3 = sMLFB.charAt(8); //Geber
    var MLFB10_1FW3 = sMLFB.charAt(9);

    var HMK_RUMPF_1FW3 = ECL_GetValue("HMK_RUMPF_1FW3");
    var HMK_RUMPF_9_11_12_15_1FW3 = ECL_GetValue("HMK_RUMPF_9_11_12_15_1FW3");
    var HMK_RUMPF_16_1FW3 = ECL_GetValue("HMK_RUMPF_16_1FW3");
    var HMK_MLFB05_06_1FW3 = MLFB05_1FW3;

    var MLFB11_1FW3 = ECL_GetValue("MLFB11_1FW3");
    var MLFB12_1FW3 = ECL_GetValue("MLFB12_1FW3");
    var MLFB13_1FW3 = ECL_GetValue("MLFB13_1FW3");
    var MLFB14_1FW3 = ECL_GetValue("MLFB14_1FW3");
    var MLFB15_1FW3 = ECL_GetValue("MLFB15_1FW3");
    var MLFB16_1FW3 = ECL_GetValue("MLFB16_1FW3");

    var PMD_ACH516_001_000_1FW3 = ECL_GetValue("PMD_ACH516_001_000_1FW3");
    // ################################################################################################################


    // ################################################################################################################
    /* HMK_RUMPF_9_11_12_15_1FW3
    Bestimme gültige HMK_RUMPF_9_11_12_15_1FW3 
    
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
            MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00121	MLFB-Logik Kennz Kuehlart Wicklung Dreh
            HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00121" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_9_11_12_15_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    var aRUMPF_9_11_12_15 = [];

    if (aResult.length > 0) {

        for (var i = 0; i < aResult.length; i++) {
            var HMK_RUMPF_9_11_12_15_1FW3 = aResult[i].HMK_RUMPF_9_11_12_15_1FW3;
            aRUMPF_9_11_12_15.push(HMK_RUMPF_9_11_12_15_1FW3);
        }
    }

    /*
        VT_1FW3_M00124	MLFB-Logik Spannfest Geberanbau
            HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00124" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_9_11_12_15_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_9_11_12_15_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_9_11_12_15.indexOf(aResult[i].HMK_RUMPF_9_11_12_15_1FW3) > -1) {
                aRUMPF_9_11_12_15_temp.push(aResult[i].HMK_RUMPF_9_11_12_15_1FW3);
            }
        }
        aRUMPF_9_11_12_15 = aRUMPF_9_11_12_15_temp;
    }

    /*
        VT_1FW3_M00125	MLFB-Logik Bauform
            HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00125" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_9_11_12_15_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_9_11_12_15_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_9_11_12_15.indexOf(aResult[i].HMK_RUMPF_9_11_12_15_1FW3) > -1) {
                aRUMPF_9_11_12_15_temp.push(aResult[i].HMK_RUMPF_9_11_12_15_1FW3);
            }
        }
        aRUMPF_9_11_12_15 = aRUMPF_9_11_12_15_temp;
    }

    /*	
        VT_1FW3_M00149	MLFB Logik Mechnik Rotor o .L03
            HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00149" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_9_11_12_15_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_9_11_12_15_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_9_11_12_15.indexOf(aResult[i].HMK_RUMPF_9_11_12_15_1FW3) > -1) {
                aRUMPF_9_11_12_15_temp.push(aResult[i].HMK_RUMPF_9_11_12_15_1FW3);
            }
        }
        aRUMPF_9_11_12_15 = aRUMPF_9_11_12_15_temp;
    }

    var bSpecialDesign = false;
    var sWhereRUMPF_09_15 = "( HMK_RUMPF_9_11_12_15_1FW3 = '" + aRUMPF_9_11_12_15[0] + "' ";
    for (var i = 1; i < aRUMPF_9_11_12_15.length; i++) {
        sWhereRUMPF_09_15 = sWhereRUMPF_09_15 + "OR HMK_RUMPF_9_11_12_15_1FW3 = '" + aRUMPF_9_11_12_15[i] + "' ";
        if (aRUMPF_9_11_12_15[i].charAt(6) == "S") {
            bSpecialDesign = true;
        }
    }
    sWhereRUMPF_09_15 = sWhereRUMPF_09_15 + ") AND ";

    // aRUMPF_9_11_12_15 weiter einschränken über VT180 mit HMK_RUMPF_16_1FW3 s.u.

    /*		
        VT_1FW3_M00166	Opt G50 Sonderlagerschild
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_G50_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00174	Opt_Pflicht L03 Erh Ruettelfest
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_L03_1FW3	HMK_HINW_L03_PFLICHT_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00175	Verriegelung MLFB13 L03
            HMK_RUMPF_9_11_12_15_1FW3	MLFB13_1FW3	HMK_L03_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
    nn	VT_1FW3_M00177	Opt V31 VW Sonderverzahnung I
            HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_V31_1FW3	HMK_V31_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00179	MLFB-Logik Lagerung
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    */


    /*
    HMK_RUMPF_16_1FW3:
        
        VT_1FW3_M00136	Mapping Rumpf 567810_16
            HMK_RUMPF_1FW3	MLFB16_1FW3	HMK_RUMPF_16_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00136" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_16_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    var aRUMPF_16 = [];

    if (aResult.length > 0) {

        for (var i = 0; i < aResult.length; i++) {
            aRUMPF_16.push(aResult[i].HMK_RUMPF_16_1FW3);
        }
    }
    /*
        VT_1FW3_M00166	Opt G50 Sonderlagerschild
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_G50_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00174	Opt_Pflicht L03 Erh Ruettelfest
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_L03_1FW3	HMK_HINW_L03_PFLICHT_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00174" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_16_1FW3 FROM " + sTable + " WHERE " +
        sWhereRUMPF_09_15 + //"HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_16_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_16.indexOf(aResult[i].HMK_RUMPF_16_1FW3) > -1) {
                aRUMPF_16_temp.push(aResult[i].HMK_RUMPF_16_1FW3);
            }
        }
        aRUMPF_16 = aRUMPF_16_temp;
    }
    /*	
        VT_1FW3_M00179	MLFB-Logik Lagerung
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00179" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_16_1FW3 FROM " + sTable + " WHERE " +
        sWhereRUMPF_09_15 + //"HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_16_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_16.indexOf(aResult[i].HMK_RUMPF_16_1FW3) > -1) {
                aRUMPF_16_temp.push(aResult[i].HMK_RUMPF_16_1FW3);
            }
        }
        aRUMPF_16 = aRUMPF_16_temp;
    }
    /*
        VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00180" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_16_1FW3 FROM " + sTable + " WHERE " +
        sWhereRUMPF_09_15 + //"HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_KEY_GEBER_1FW3 = 'OHNE' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {

        var aRUMPF_16_temp = [];

        for (var i = 0; i < aResult.length; i++) {

            if (aRUMPF_16.indexOf(aResult[i].HMK_RUMPF_16_1FW3) > -1) {
                aRUMPF_16_temp.push(aResult[i].HMK_RUMPF_16_1FW3);
            }
        }
        aRUMPF_16 = aRUMPF_16_temp;
    }

    // gültige MLFB16:
    var aMLFB16_valid = [];

    for (var i = 0; i < aRUMPF_16.length; i++) {

        var sMLFB16_Val = aRUMPF_16[i];

        sMLFB16_Val = sMLFB16_Val.substring(6, 7);

        if (aMLFB16_valid.indexOf(sMLFB16_Val) < 0) {
            aMLFB16_valid.push(sMLFB16_Val);
        }
    }

    // ################################################################################################################
    // aRUMPF_9_11_12_15 weiter einschränken über VT180 mit HMK_RUMPF_16_1FW3 s.u.
    /*
        VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    */
    // gültige MLFB15:
    var aMLFB15_valid = [];
    if (sBaseTypeMLFB.charAt(14) == ".") {
        var aRUMPF_9_11_12_15_temp = [];
        for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

            var RUMPF_9_11_12_15_Value = aRUMPF_9_11_12_15[i];

            var sMLFB15_Val = RUMPF_9_11_12_15_Value.substring(6, 7);

            if (aMLFB15_valid.indexOf(sMLFB15_Val) < 0) {
                aMLFB15_valid.push(sMLFB15_Val);
            }
            if (sMLFB15_Val == MLFB15_1FW3) {
                aRUMPF_9_11_12_15_temp.push(RUMPF_9_11_12_15_Value);
            }
        }
        aRUMPF_9_11_12_15 = aRUMPF_9_11_12_15_temp;
    } else {
        aMLFB15_valid.push(MLFB15_1FW3);
    }
    // alle weiteren in Abhängigkeit der gewählten Welle:
    // ################################################################################################################

    // gültige MLFB09:
    var aMLFB09_valid = [];

    for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

        var sMLFB09_Val = aRUMPF_9_11_12_15[i];

        sMLFB09_Val = sMLFB09_Val.substring(0, 1);

        if (aMLFB09_valid.indexOf(sMLFB09_Val) < 0) {
            aMLFB09_valid.push(sMLFB09_Val);
        }
    }

    // gültige MLFB11:
    var aMLFB11_valid = [];

    for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

        var sMLFB11_Val = aRUMPF_9_11_12_15[i];

        sMLFB11_Val = sMLFB11_Val.substring(2, 3);

        if (aMLFB11_valid.indexOf(sMLFB11_Val) < 0) {
            aMLFB11_valid.push(sMLFB11_Val);
        }
    }

    // gültige MLFB12:
    var aMLFB12_valid = [];

    for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

        var sMLFB12_Val = aRUMPF_9_11_12_15[i];

        sMLFB12_Val = sMLFB12_Val.substring(4, 5);

        if (aMLFB12_valid.indexOf(sMLFB12_Val) < 0) {
            aMLFB12_valid.push(sMLFB12_Val);
        }
    }


    // ################################################################################################################


    // ################################################################################################################
    // PMD_AAA506_001_000_1FW3		Wellenende			MLFB15_1FW3
    // ################################################################################################################
    if (sBaseTypeMLFB.charAt(14) == ".") {
        ECL_EnableAttribute("PMD_AAA506_001_000_1FW3");

        var sTargetMLFB = "MLFB15_1FW3";
        var sTargetAttribute = "PMD_AAA506_001_000_1FW3";
        /*
        VT_1FW3_M00084	MechanikRotor<>MLFB15		// für Übersetzung
            MLFB15_1FW3	PMD_AAA506_001_000_1FW3	PMD_ACM689_001_000_1FW3	HMK_VALUE_VALID_1FW3
    	
        MLFB15_1FW3
        nn	VT_1FW3_M00041	Opt T32 Drehmomentstütze		nur Einschränkung T32
        nn	VT_1FW3_M00043	Opt Q30 Spannelement
            VT_1FW3_M00083	Schutzart IP					Abhängigkeit von AH
                HMK_MLFB05_06_1FW3	MLFB08_1FW3	MLFB15_1FW3	PMD_ABJ176_001_000_1FW3	HMK_VALUE_VALID_1FW3
        	
            VT_1FW3_M00084	MechanikRotor<>MLFB15		// für Übersetzung
            VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
                MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
        	
        nn	VT_1FW3_M00146	TechDaten je Rumpf/Welle
            VT_1FW3_M00153	Lagerwechselfrist
        nn	VT_1FW3_M00169	Verriegelung J1A Q1A U12

        */

        // zunächst Logik auf MLFB15_1FW3

        // aRUMPF_9_11_12_15
        // aMLFB15_valid
        ECL_DeactivateAllAttributeValues(sTargetMLFB);
        if (aMLFB15_valid.length > 0) {
            var sValueValid = aMLFB15_valid[0];
            ECL_ActivateValue(sTargetMLFB, sValueValid);
            var sWhereMLFB15 = "MLFB15_1FW3 = '" + sValueValid + "'";
        }

        for (var i = 1; i < aMLFB15_valid.length; i++) {
            var sValueValid = aMLFB15_valid[i];
            ECL_ActivateValue(sTargetMLFB, sValueValid);
            sWhereMLFB15 += " OR MLFB15_1FW3 = '" + sValueValid + "'";
        }
        if (sWhereMLFB15) {
            sWhereMLFB15 = "(" + sWhereMLFB15 + ") AND";
        } else {
            var sWhereMLFB15 = "";
        }
        // ----------------------------------------------------------------------------------------------------------------
        var sTable = "VT_1FW3_M00083" + sDB_Suffix;
        var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
            "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
            "HMK_VALUE_VALID_1FW3 = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FW3___PLVT_WELLENENDE_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------------------------------

        if (MLFB12_1FW3 == "8") {
            var sWhereMLFB12_Sonder = "MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND ";
        } else {
            var sWhereMLFB12_Sonder = "";
        }
        var sTable = "VT_1FW3_M00119" + sDB_Suffix;
        var sWhere = 	//sWhereMLFB12_Sonder + //"MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND " +
            sWhereRUMPF_09_15 +
            "HMK_VALUE_VALID_1FW3 = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FW3___PLVT_WELLENENDE_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------------------------------
        // Übertragung in PMD_AAA506_001_000_1FW3
        sTable = "VT_1FW3_M00084" + sDB_Suffix;
        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

        if (sStatus == "Error") {
            // Fehler
            strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB15");
            return strError;
        }
        // ################################################################################################################
        if (strchangedAttribute == "PMD_AAC949_001_000_1FW3" && ECL_GetValue("PMD_AAC949_001_000_1FW3") == "00013") {
            ECL_SelectValue("PMD_AAA506_001_000_1FW3", "00004");
        }
        // ################################################################################################################
        // setze MLFB15
        // ################################################################################################################
        /*
        VT_1FW3_M00084	MechanikRotor<>MLFB15		// für Übersetzung
            MLFB15_1FW3	PMD_AAA506_001_000_1FW3	PMD_ACM689_001_000_1FW3	HMK_VALUE_VALID_1FW3
        */
        var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");

        //sTable = "VT_1FW3_M00084" + sDB_Suffix;
        var sSQL = "SELECT MLFB15_1FW3 FROM " + sTable + " WHERE " +
            "PMD_AAA506_001_000_1FW3 = '" + PMD_AAA506_001_000_1FW3 + "' AND " +
            "HMK_VALUE_VALID_1FW3 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            MLFB15_1FW3 = aResult[0].MLFB15_1FW3;
        } else {
            strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB15");
            return strError;
        }

        ECL_SelectValue("MLFB15_1FW3", MLFB15_1FW3);

        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FW3)
        ECL_SetValue("ECSI_MLFB", sMLFB);

        // HMK_RUMPF_9_11_12_15_1FW3 aktualisieren
        HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + MLFB12_1FW3 + "_" + MLFB15_1FW3;
        ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);
        // ################################################################################################################
    } else {
        ECL_DisableAttribute("PMD_AAA506_001_000_1FW3");
    }

    // ################################################################################################################
    // PMD_AAA069_001_000_1FW3	Lagerung
    // ################################################################################################################
    /*
    VT_1FW3_M00009	Lagerung<>MLFB16		Übersetzung
        MLFB16_1FW3	PMD_AAA069_001_000_1FW3	HMK_VALUE_VALID_1FW3

    MLFB16_1FW3:
        VT_1FW3_M00009	Lagerung<>MLFB16						Übersetzung
        VT_1FW3_M00041	Opt T32 Drehmomentstütze
            HMK_T32_1FW3    HMK_MLFB05_06_1FW3  MLFB15_1FW3 MLFB16_1FW3 HMK_VALUE_VALID_1FW3
        VT_1FW3_M00043	Opt Q30 Spannelement
    nn	VT_1FW3_M00130	Opt V31 VW Sonderverzahnung II			nur DI, nicht nötig
        VT_1FW3_M00136	Mapping Rumpf 567810_16
            HMK_RUMPF_1FW3	MLFB16_1FW3	HMK_RUMPF_16_1FW3	HMK_VALUE_VALID_1FW3
        
    HMK_RUMPF_16_1FW3:
        
        VT_1FW3_M00136	Mapping Rumpf 567810_16
            HMK_RUMPF_1FW3	MLFB16_1FW3	HMK_RUMPF_16_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00166	Opt G50 Sonderlagerschild
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_G50_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00174	Opt_Pflicht L03 Erh Ruettelfest
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_L03_1FW3	HMK_HINW_L03_PFLICHT_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00179	MLFB-Logik Lagerung
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
            HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sTargetMLFB = "MLFB16_1FW3";
    var sTargetAttribute = "PMD_AAA069_001_000_1FW3";

    // aRUMPF_16
    // aMLFB16_valid
    ECL_DeactivateAllAttributeValues(sTargetMLFB);
    for (var i = 0; i < aMLFB16_valid.length; i++) {
        var sValueValid = aMLFB16_valid[i];
        ECL_ActivateValue(sTargetMLFB, sValueValid);
    }
    // ----------------------------------------------------------------------------------------------------------------
    /*
     VT_1FW3_M00041	Opt T32 Drehmomentstütze
        HMK_T32_1FW3    HMK_MLFB05_06_1FW3  MLFB15_1FW3 MLFB16_1FW3 HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00041" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB16";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung in PMD_AAA069_001_000_1FW3
    sTable = "VT_1FW3_M00009" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

    if (sStatus == "Error") {
        // Fehler
        strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB16");
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // setze MLFB16
    /*
    VT_1FW3_M00009	Lagerung<>MLFB16		Übersetzung	
        MLFB16_1FW3	PMD_AAA069_001_000_1FW3	HMK_VALUE_VALID_1FW3
    */
    var PMD_AAA069_001_000_1FW3 = ECL_GetValue("PMD_AAA069_001_000_1FW3");

    //sTable = "VT_1FW3_M00009" + sDB_Suffix;
    var sSQL = "SELECT MLFB16_1FW3 FROM " + sTable + " WHERE " +
        "PMD_AAA069_001_000_1FW3 = '" + PMD_AAA069_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB16_1FW3 = aResult[0].MLFB16_1FW3;
    } else {
        strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB16");
        return strError;
    }

    ECL_SelectValue("MLFB16_1FW3", MLFB16_1FW3);

    sMLFB = replaceAt(sMLFB, 15, MLFB16_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);

    // HMK_RUMPF_16_1FW3 aktuelisieren 
    HMK_RUMPF_16_1FW3 = sMLFB.substring(4, 8) + MLFB10_1FW3 + "_" + MLFB16_1FW3;
    ECL_SetValue("HMK_RUMPF_16_1FW3", HMK_RUMPF_16_1FW3);
    // ################################################################################################################


    // ################################################################################################################
    // Lagerwechselfrist	UI_LAGERW_FRIST_1FW3
    // ################################################################################################################
    var sTargetAttribute = "UI_LAGERW_FRIST_1FW3";
    /*
    VT_1FW3_M00153	Lagerwechselfrist
        HMK_RUMPF_1FW3	MLFB15_1FW3	HMK_K40_1FW3	HMK_L03_H_1FW3	UI_LAGERW_FRIST_1FW3	HMK_VALUE_VALID_1FW3

        Attention: to handle interaction with L03 obligation, evaluation of HMK_L03_H_1FW3 according to L03
    */
    var HMK_K40_1FW3 = "F";
    if (ECL_ValueSelected("CB_K40_1FW3", "T")) {
        HMK_K40_1FW3 = "T";
    }
    var HMK_L03_H_1FW3 = "F";
    if (ECL_ValueSelected("CB_L03_1FW3", "T")) {
        HMK_L03_H_1FW3 = "T";
    }

    var sTable = "VT_1FW3_M00153" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_K40_1FW3 = '" + HMK_K40_1FW3 + "' AND " +
        //"HMK_L03_H_1FW3 = '" + HMK_L03_H_1FW3 + "' AND " + // Interaction see below (L03 following)
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_LAGERWECHSELFRIST_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // HMK_TEMP_SENSOR_1FW3	Temperatursensor			MLFB14
    // ################################################################################################################
    /* Nur noch PT1000 ('00002')
        VT_1FW3_M00025	Mapping Temperatursenor
        VT_1FW3_M00133	MLFB14 für Temp.-sensor
        
        MLFB14_1FW3:
        nn	VT_1FW3_M00022	Gehäusetyp und MLFB14
            VT_1FW3_M00038	MLFB-Logik Motorversion
        nn	VT_1FW3_M00130	Opt V31 VW Sonderverzahnung II
            VT_1FW3_M00133	MLFB14 für Temp.-sensor
                MLFB14_1FW3	PMD_ABU209_001_000_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_TEMP_SENSOR_1FW3	HMK_VALUE_VALID_1FW3
                D/A			F/T ohne/mit DQ			AKT						00002					T
            VT_1FW3_M00140	MLFB-Logik Geber II (DI)
        
        // #########################################
        PMD_AAA717_001_000_1FW3	Ausführung der Temperaturüberwachung
        // #########################################
        VT_1FW3_M00025	Mapping Temperatursenor
    */


    // ################################################################################################################

    // ################################################################################################################
    // setze MLFB14
    // ################################################################################################################
    /*
    Abhängig von AH, MLFB08 + DriveCLIQ
    * /
    var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");
    var HMK_WELLENAUSF_1FW3 = ECL_GetValue("HMK_WELLENAUSF_1FW3");
    
    if (PMD_AAA506_001_000_1FW3 == "Z0002" && HMK_WELLENAUSF_1FW3 == "STD"){
        MLFB13_1FW3 = "0";
    }else if (PMD_AAA506_001_000_1FW3 == "Z0002" && HMK_WELLENAUSF_1FW3 == "ALT"){
        MLFB13_1FW3 = "2";
    }else if (PMD_AAA506_001_000_1FW3 == "Z0004" && HMK_WELLENAUSF_1FW3 == "STD"){
        MLFB13_1FW3 = "1";
    }else{
        //Fehler
    }
    
    ECL_SetValue("MLFB13_1FW3", MLFB13_1FW3);
    
    sMLFB = replaceAt(sMLFB, 12, MLFB13_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);
    */
    // ################################################################################################################


    // ################################################################################################################
    // PMD_AAC949_001_000_1FW3	Bauform		MLFB12		HMK_BAUFORM_MAPPING_1FW3
    // ################################################################################################################
    /*
    VT_1FW3_M00081	Mapping Vorselektor Bauform		Übersetzung PMD		nn.
    VT_1FW3_M00156	Bauform<>MLFB12					Übersetzung MLFB12 PMD
        MLFB12_1FW3	PMD_AAC949_001_000_1FW3	HMK_VALUE_VALID_1FW3
    VT_1FW3_M00157	Mapping Bauform<->Bild			nn.

    
    MLFB12_1FW3 VTs:
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
            MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
        VT_1FW3_M00156	Bauform<>MLFB12
            MLFB12_1FW3	PMD_AAC949_001_000_1FW3	HMK_VALUE_VALID_1FW3

    */
    var sTargetMLFB = "MLFB12_1FW3";
    var sTargetAttribute = "PMD_AAC949_001_000_1FW3";

    // aRUMPF_9_11_12_15
    // aMLFB12_valid
    var sWhereMLFB11 = "( MLFB11_1FW3 = '" + aMLFB11_valid[0] + "' ";
    for (var i = 1; i < aMLFB11_valid.length; i++) {
        sWhereMLFB11 = sWhereMLFB11 + "OR MLFB11_1FW3 = '" + aMLFB11_valid[i] + "' ";
    }
    sWhereMLFB11 = sWhereMLFB11 + ") AND ";

    ECL_DeactivateAllAttributeValues(sTargetMLFB);
    for (var i = 0; i < aMLFB12_valid.length; i++) {
        ECL_ActivateValue(sTargetMLFB, aMLFB12_valid[i]);
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Edit 2023/07 Sonderbauform muss wählbar sein bei AH280, dafür ist 1:1 Wellenende Ansteckwelle (MLFB15 = 'S')
    if (bSpecialDesign) {
        var sWhereMLFB15 = "(MLFB15_1FW3 = '" + MLFB15_1FW3 + "' OR MLFB15_1FW3 = 'S') AND ";
    } else {
        var sWhereMLFB15 = "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND ";
    }
    var sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sWhere = sWhereMLFB11 +
        sWhereMLFB15 +
        sWhereRUMPF_09_15 +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_BAUFORM_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung in PMD_AAC949_001_000_1FW3
    sTable = "VT_1FW3_M00156" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

    if (sStatus == "Error") {
        strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB12");
        return strError;
    }
    // ################################################################################################################
    if (strchangedAttribute == "PMD_AAA506_001_000_1FW3" && ECL_GetValue("PMD_AAA506_001_000_1FW3") !== "00004" && MLFB12_1FW3 == "8") {
        ECL_DeselectAttribute("PMD_AAC949_001_000_1FW3");
        ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1FW3", "00008");
    }

    // ################################################################################################################
    // setze MLFB12
    // ################################################################################################################
    var PMD_AAC949_001_000_1FW3 = ECL_GetValue("PMD_AAC949_001_000_1FW3");
    var aValidPMD_AAC949 = ECL_GetAllActiveAttributeValues("PMD_AAC949_001_000_1FW3");


    var sSQL = "SELECT MLFB12_1FW3 FROM " + sTable + " WHERE " +
        "PMD_AAC949_001_000_1FW3 = '" + PMD_AAC949_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB12_1FW3 = aResult[0].MLFB12_1FW3;
    } else {
        strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB12");
        return strError;
    }

    ECL_SelectValue("MLFB12_1FW3", MLFB12_1FW3);

    sMLFB = replaceAt(sMLFB, 11, MLFB12_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);

    // HMK_RUMPF_9_11_12_15_1FW3 aktualisieren
    HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + MLFB12_1FW3 + "_" + MLFB15_1FW3;
    ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);
    // ################################################################################################################


    // ################################################################################################################
    // PMD_ABU209_001_000_1FW3	DRIVE-CLiQ
    // CB_DRIVE_CLIQ_1FW3	DRIVE-CLiQ
    // ################################################################################################################
    /*
    VT_1FW3_M00106	Geber<>MLFB09
    VT_1FW3_M00133	MLFB14 für Temp.-sensor

    
    MLFB09_1FW3 VTs:
        VT_1FW3_M00038	MLFB-Logik Motorversion
        VT_1FW3_M00106	Geber<>MLFB09
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
        VT_1FW3_M00162	Opt K40 Nachschmier
    
    
    aus VT133 
    mit DQ: A
    ohne DQ D
    * /
    var sTable = "VT_1FW3_M00140" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABU278_001_000_1FW3";
    var sWhere = 	"MLFB_RUMPF_01_10_1FW3 = '" + MLFB_RUMPF_01_10_1FW3 + "';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FW3___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }
    */
    // ################################################################################################################


    // ################################################################################################################
    // UI_GEBER_1FW3	Ausführung
    // ################################################################################################################
    /*
    VT_1FW3_M00106	Geber<>MLFB09


    
    MLFB09_1FW3 VTs:
        VT_1FW3_M00038	MLFB-Logik Motorversion
        VT_1FW3_M00106	Geber<>MLFB09
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
        VT_1FW3_M00162	Opt K40 Nachschmier
    */


    // ################################################################################################################

    // ################################################################################################################
    // UI_GEBER_AUFLOESUNG_1FW3	Auflösung
    // ################################################################################################################
    /*
    VT_1FW3_M00106	Geber<>MLFB09


    
    MLFB09_1FW3 VTs:
        VT_1FW3_M00038	MLFB-Logik Motorversion
        VT_1FW3_M00106	Geber<>MLFB09
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
        VT_1FW3_M00162	Opt K40 Nachschmier
    */


    // ################################################################################################################


    // ################################################################################################################
    // PMD_ABU278_001_000_1FW3	Gebersystem				MLFB09
    // ################################################################################################################
    /*
    VT_1FW3_M00106	Geber<>MLFB09
        PMD_ABU278_001_000_1FW3	PMD_ABU209_001_000_1FW3	UI_GEBER_1FW3	UI_GEBER_AUFLOESUNG_1FW3	MLFB09_1FW3	HMK_VALUE_VALID_1FW3


    
    MLFB09_1FW3 VTs:
        VT_1FW3_M00038	MLFB-Logik Motorversion
            HMK_MLFB05_06_1FW3	MLFB09_1FW3	MLFB14_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00106	Geber<>MLFB09
            PMD_ABU278_001_000_1FW3	PMD_ABU209_001_000_1FW3	UI_GEBER_1FW3	UI_GEBER_AUFLOESUNG_1FW3	MLFB09_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
            MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00162	Opt K40 Nachschmier
            HMK_MLFB05_06_1FW3	MLFB09_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_VALUE_VALID_1FW3
        
    */


    // ################################################################################################################
    // neue aRUMPF_9_11_12_15 mit gesetzer MLFB15 und MLFB12
    var sTable = "VT_1FW3_M00180" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_RUMPF_9_11_12_15_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_KEY_GEBER_1FW3 = 'OHNE' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    var bMLFB12NotValid = false;
    if (aResult.length > 0) {

        var aRUMPF_9_11_12_15_temp = [];

        for (var i = 0; i < aResult.length; i++) {
            if ((aRUMPF_9_11_12_15.indexOf(aResult[i].HMK_RUMPF_9_11_12_15_1FW3) > -1) &&
                (aResult[i].HMK_RUMPF_9_11_12_15_1FW3.right(1) == MLFB15_1FW3) &&
                (aResult[i].HMK_RUMPF_9_11_12_15_1FW3.substring(4, 5) == MLFB12_1FW3)
            ) {
                aRUMPF_9_11_12_15_temp.push(aResult[i].HMK_RUMPF_9_11_12_15_1FW3);
            }
        }
        if (aRUMPF_9_11_12_15_temp.length < 1) {
            bMLFB12NotValid = true;
            for (var i = 0; i < aResult.length; i++) {
                if ((aRUMPF_9_11_12_15.indexOf(aResult[i].HMK_RUMPF_9_11_12_15_1FW3) > -1) &&
                    (aResult[i].HMK_RUMPF_9_11_12_15_1FW3.right(1) == MLFB15_1FW3)
                ) {
                    aRUMPF_9_11_12_15_temp.push(aResult[i].HMK_RUMPF_9_11_12_15_1FW3);
                }
            }

        }
        aRUMPF_9_11_12_15 = aRUMPF_9_11_12_15_temp;
    }

    var sWhereRUMPF_09_15 = "( HMK_RUMPF_9_11_12_15_1FW3 = '" + aRUMPF_9_11_12_15[0] + "' ";
    for (var i = 1; i < aRUMPF_9_11_12_15.length; i++) {
        sWhereRUMPF_09_15 = sWhereRUMPF_09_15 + "OR HMK_RUMPF_9_11_12_15_1FW3 = '" + aRUMPF_9_11_12_15[i] + "' ";
    }
    sWhereRUMPF_09_15 = sWhereRUMPF_09_15 + ") AND ";


    // ----------------------------------------------------------------------------------------------------------------
    // gültige MLFB12 mit aRUMPF_9_11_12_15 und gesetzer MLFB15
    // PMD_AAC949_001_000_1FW3	Bauform		MLFB12		HMK_BAUFORM_MAPPING_1FW3
    if (bMLFB12NotValid) {
        var sTargetMLFB = "MLFB12_1FW3";
        var sTargetAttribute = "PMD_AAC949_001_000_1FW3";

        // gültige MLFB12 mit aRUMPF_9_11_12_15 und gesetzer MLFB15: prüfen, ob auch MLFB12?
        var aMLFB12_valid_new = [];

        for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

            var sMLFB12_Val = aRUMPF_9_11_12_15[i];

            sMLFB12_Val = sMLFB12_Val.substring(4, 5);
            if (aMLFB12_valid_new.indexOf(sMLFB12_Val) < 0) {
                aMLFB12_valid_new.push(sMLFB12_Val);
            }
        }

        // aRUMPF_9_11_12_15
        // aMLFB12_valid
        ECL_DeactivateAllAttributeValues(sTargetMLFB);
        for (var i = 0; i < aMLFB12_valid_new.length; i++) {
            ECL_ActivateValue(sTargetMLFB, aMLFB12_valid_new[i]);
        }

        ExecSetStandardifValueEmpty("MLFB12_1FW3", aMLFB12_valid_new[0]);
        MLFB12_1FW3 = ECL_GetValue("MLFB12_1FW3");

        // Übertragung in PMD_AAC949_001_000_1FW3
        sTable = "VT_1FW3_M00156" + sDB_Suffix;
        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

        if (sStatus == "Error") {
            strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB12");
            return strError;
        }

        // ################################################################################################################
        // setze MLFB12
        // ################################################################################################################
        var PMD_AAC949_001_000_1FW3 = ECL_GetValue("PMD_AAC949_001_000_1FW3");

        var sSQL = "SELECT MLFB12_1FW3 FROM " + sTable + " WHERE " +
            "PMD_AAC949_001_000_1FW3 = '" + PMD_AAC949_001_000_1FW3 + "' AND " +
            "HMK_VALUE_VALID_1FW3 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            MLFB12_1FW3 = aResult[0].MLFB12_1FW3;
        } else {
            strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB12");
            return strError;
        }

        ECL_SelectValue("MLFB12_1FW3", MLFB12_1FW3);

        sMLFB = replaceAt(sMLFB, 11, MLFB12_1FW3)
        ECL_SetValue("ECSI_MLFB", sMLFB);

        // HMK_RUMPF_9_11_12_15_1FW3 aktualisieren
        HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + MLFB12_1FW3 + "_" + MLFB15_1FW3;
        ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);

    }

    // ----------------------------------------------------------------------------------------------------------------
    // zunächst MLFB09 einschränken:

    var sTargetMLFB = "MLFB09_1FW3";
    var sTargetAttribute = "PMD_ABU278_001_000_1FW3";

    // gültige MLFB09 mit aRUMPF_9_11_12_15 und gesetzer MLFB15: prüfen, ob auch MLFB12?
    var aMLFB09_valid_new = [];

    for (var i = 0; i < aRUMPF_9_11_12_15.length; i++) {

        var sMLFB09_Val = aRUMPF_9_11_12_15[i];

        sMLFB09_Val = sMLFB09_Val.substring(0, 1);
        if (aMLFB09_valid_new.indexOf(sMLFB09_Val) < 0) {
            aMLFB09_valid_new.push(sMLFB09_Val);
        }
    }
    // aRUMPF_9_11_12_15
    // aMLFB09_valid
    ECL_DeactivateAllAttributeValues(sTargetMLFB);
    for (var i = 0; i < aMLFB09_valid_new.length; i++) {
        ECL_ActivateValue(sTargetMLFB, aMLFB09_valid_new[i]);
    }


    // ----------------------------------------------------------------------------------------------------------------
    /* VT_1FW3_M00038	MLFB-Logik Motorversion
            HMK_MLFB05_06_1FW3	MLFB09_1FW3	MLFB14_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00038" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    /* VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
            MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sWhere = "MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    /* VT_1FW3_M00162	Opt K40 Nachschmier
            HMK_MLFB05_06_1FW3	MLFB09_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_VALUE_VALID_1FW3
    */

    var sTable = "VT_1FW3_M00162" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung in PMD_ABU278_001_000_1FW3
    sTable = "VT_1FW3_M00106" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

    if (sStatus == "Error") {
        // Fehler
        strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB09");
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    /* aus MLFB-Logik noch gültige Geber:
    auf dieser Basis werden 
    - PMD_ABU209_001_000_1FW3	(DriveCLiQ)
    - UI_GEBER_1FW3	
    - UI_GEBER_AUFLOESUNG_1FW3	
    eingeschränkt, damit Umwahl möglich, aber nur wenn gültige Geber vorhanden.
    */
    var aValidValues_Geber = ECL_GetAllActiveAttributeValues("PMD_ABU278_001_000_1FW3");
    if (aValidValues_Geber.length == 1) {
        var sWhereGeber = "PMD_ABU278_001_000_1FW3 = '" + aValidValues_Geber[0] + "' AND ";
    } else if (aValidValues_Geber.length > 1) {
        var sWhereGeber = "(PMD_ABU278_001_000_1FW3 = '" + aValidValues_Geber[0] + "'";
        for (var i = 1; i < aValidValues_Geber.length; i++) {
            sWhereGeber = sWhereGeber + " OR PMD_ABU278_001_000_1FW3 = '" + aValidValues_Geber[i] + "'";
        }
        sWhereGeber = sWhereGeber + ") AND ";
    } else {
        strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    /* weitere Einschränkung aus VT106
    
    für DQ
    
    VT_1FW3_M00106	Geber<>MLFB09
        PMD_ABU278_001_000_1FW3	PMD_ABU209_001_000_1FW3	UI_GEBER_1FW3	UI_GEBER_AUFLOESUNG_1FW3	MLFB09_1FW3	HMK_VALUE_VALID_1FW3
    */
    if (ECL_ValueSelected("CB_DRIVE_CLIQ_1FW3", "T")) {
        var PMD_ABU209_001_000_1FW3 = "T";
    } else {
        var PMD_ABU209_001_000_1FW3 = "F";
    }

    var sTable = "VT_1FW3_M00106" + sDB_Suffix;
    var sWhere = "PMD_ABU209_001_000_1FW3 = '" + PMD_ABU209_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    // DRIVE-CLiQ einschränken
    var sTable = "VT_1FW3_M00106" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT PMD_ABU209_001_000_1FW3 FROM " + sTable + " WHERE " +
        sWhereGeber +
        "HMK_VALUE_VALID_1FW3 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var bDQ_F = false;
        var bDQ_T = false;

        for (var j = 0; j < aResult.length; j++) {
            if (aResult[j].PMD_ABU209_001_000_1FW3 == "F")
                bDQ_F = true;

            if (aResult[j].PMD_ABU209_001_000_1FW3 == "T")
                bDQ_T = true;
        }

        if (bDQ_F && bDQ_T) {
            ECL_EnableAttribute("CB_DRIVE_CLIQ_1FW3");
        } else if (bDQ_T && !(bDQ_F)) {
            ECL_SelectValue("CB_DRIVE_CLIQ_1FW3", "T");
            ECL_DisableAttribute("CB_DRIVE_CLIQ_1FW3");
        } else if (bDQ_F && !(bDQ_T)) {
            ECL_DeselectAttribute("CB_DRIVE_CLIQ_1FW3");
            ECL_DisableAttribute("CB_DRIVE_CLIQ_1FW3");
        } else {
            strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
            return strError;
        }
    } else {
        strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    //ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FW3", "T");
    //var PMD_ABU209_001_000_1FW3 = ECL_GetValue("PMD_ABU209_001_000_1FW3");
    if (ECL_ValueSelected("CB_DRIVE_CLIQ_1FW3", "T")) {
        var PMD_ABU209_001_000_1FW3 = "T";
    } else {
        var PMD_ABU209_001_000_1FW3 = "F";
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Ausführung einschränken
    var sTable = "VT_1FW3_M00106" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_1FW3 FROM " + sTable + " WHERE " +
        sWhereGeber +
        "PMD_ABU209_001_000_1FW3 = '" + PMD_ABU209_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("UI_GEBER_1FW3");
        for (var j = 0; j < aResult.length; j++) {
            ECL_ActivateValue("UI_GEBER_1FW3", aResult[j].UI_GEBER_1FW3);
        }
    } else {
        strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_1FW3", "");
    var UI_GEBER_1FW3 = ECL_GetValue("UI_GEBER_1FW3");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Auflösung einschränken
    var sTable = "VT_1FW3_M00106" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_AUFLOESUNG_1FW3 FROM " + sTable + " WHERE " +
        sWhereGeber +
        "PMD_ABU209_001_000_1FW3 = '" + PMD_ABU209_001_000_1FW3 + "' AND " +
        "UI_GEBER_1FW3 = '" + UI_GEBER_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        ECL_DeactivateAllAttributeValues("UI_GEBER_AUFLOESUNG_1FW3");
        for (var j = 0; j < aResult.length; j++) {
            ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FW3", aResult[j].UI_GEBER_AUFLOESUNG_1FW3);
        }
    } else {
        strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FW3", "");
    var UI_GEBER_AUFLOESUNG_1FW3 = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FW3");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bestimme Geber

    var sTable = "VT_1FW3_M00106" + sDB_Suffix;

    var sWhere = "PMD_ABU209_001_000_1FW3 = '" + PMD_ABU209_001_000_1FW3 + "' AND " +
        "UI_GEBER_1FW3 = '" + UI_GEBER_1FW3 + "' AND " +
        "UI_GEBER_AUFLOESUNG_1FW3 = '" + UI_GEBER_AUFLOESUNG_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }

    var PMD_ABU278_001_000_1FW3 = ECL_GetValue("PMD_ABU278_001_000_1FW3");

    // ################################################################################################################
    // setze MLFB09 + 14
    // ################################################################################################################
    // var PMD_ABU278_001_000_1FW3 = ECL_GetValue("PMD_ABU278_001_000_1FW3");

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ABU278_001_000_1FW3 = '" + PMD_ABU278_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB09_1FW3 = aResult[0].MLFB09_1FW3;
        var PMD_ABU209_001_000_1FW3 = aResult[0].PMD_ABU209_001_000_1FW3;
        if (PMD_ABU209_001_000_1FW3 == "T") {
            MLFB14_1FW3 = "A";
        } else {
            MLFB14_1FW3 = "D";
        }
    } else {
        strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB09");
        return strError;
    }

    ECL_SelectValue("MLFB09_1FW3", MLFB09_1FW3);
    ECL_SelectValue("MLFB14_1FW3", MLFB14_1FW3);

    sMLFB = replaceAt(sMLFB, 8, MLFB09_1FW3)
    sMLFB = replaceAt(sMLFB, 13, MLFB14_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);

    // HMK_RUMPF_9_11_12_15_1FW3 aktualisieren
    HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + MLFB12_1FW3 + "_" + MLFB15_1FW3;
    ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);
    // ################################################################################################################


    // ################################################################################################################
    // PMD_ABV983_001_000_1FW3	Anbau Gebersystem			MLFB11
    // ################################################################################################################
    /* 
    VT_1FW3_M00015	Geberanbau, Stoßspg <> MLFB11
        MLFB11_1FW3	PMD_AAD945_001_000_1002782	PMD_ABV983_001_000_1FW3	HMK_VALUE_VALID_1FW3
    
    
    MLFB11_1FW3:	
        VT_1FW3_M00015	Geberanbau, Stoßspg <> MLFB11
        VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
            MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
        
    nn	VT_1FW3_M00178	Opt K84 Steckerabgangsrichtung
    
    MLFB11_1FW3	PMD_AAD945_001_000_1002782	PMD_ABV983_001_000_1FW3	HMK_VALUE_VALID_1FW3
    6			600							00001					T
    7			600							00002					T

    */

    var sTargetMLFB = "MLFB11_1FW3";
    var sTargetAttribute = "PMD_ABV983_001_000_1FW3";

    // aRUMPF_9_11_12_15
    // aMLFB11_valid
    ECL_DeactivateAllAttributeValues(sTargetMLFB);
    for (var i = 0; i < aMLFB11_valid.length; i++) {
        ECL_ActivateValue(sTargetMLFB, aMLFB11_valid[i]);
    }
    // ----------------------------------------------------------------------------------------------------------------

    // PLUS sWhere HMK_RUMPF_9_11_12_15_1FW3
    var sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sWhere = "MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
        "MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND " +
        //sWhereMLFB15 + 
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        sWhereRUMPF_09_15 +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_ANBAU_GEBER_NO_DB_RESULT";
        return strError;
    }
    var test = ECL_GetAllActiveAttributeValues("MLFB11_1FW3");
    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung in PMD_ABV983_001_000_1FW3
    sTable = "VT_1FW3_M00015" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

    if (sStatus == "Error") {
        // Fehler
        strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB11");
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // setze MLFB11
    // ################################################################################################################
    var PMD_ABV983_001_000_1FW3 = ECL_GetValue("PMD_ABV983_001_000_1FW3");

    var sSQL = "SELECT MLFB11_1FW3 FROM " + sTable + " WHERE " +
        "PMD_ABV983_001_000_1FW3 = '" + PMD_ABV983_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB11_1FW3 = aResult[0].MLFB11_1FW3;
    } else {
        strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB11");
        return strError;
    }

    ECL_SetValue("MLFB11_1FW3", MLFB11_1FW3);

    sMLFB = replaceAt(sMLFB, 10, MLFB11_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);

    // HMK_RUMPF_9_11_12_15_1FW3 aktualisieren
    HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + MLFB12_1FW3 + "_" + MLFB15_1FW3;
    ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);
    // ################################################################################################################


    // ################################################################################################################
    // PMD_ABJ176_001_000_1FW3	Schutzart IP				AH+MLFB08+MLFB15
    // ################################################################################################################
    /* 
    PMD_ABJ176_001_000_1FW3			MLFB15_1FW3
    Z0037	IP 54					A,C,D
    Z0003	IP 55					H,M,P,S

    AH 28 nur IP54 (Z0037)
    VT:
        VT_1FW3_M00083	Schutzart IP
            HMK_MLFB05_06_1FW3	MLFB08_1FW3	MLFB15_1FW3	PMD_ABJ176_001_000_1FW3	HMK_VALUE_VALID_1FW3
    */

    var sTable = "VT_1FW3_M00083" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1FW3";
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK 
    // ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK 
    // ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK ANSCHLUSSTECHNIK 

    // ################################################################################################################
    // PMD_ABU208_001_000_1FW3	Leistungsanschluss
    // ################################################################################################################
    /*
    fix Klemmkasten
    */
    // ################################################################################################################


    /* PMD_AAB047_001_000_1FW3	Leistungsanschluss		<== nicht benötigt

        VT_1FW3_M00078	Anschlusstechnik<>MLFB13
    */


    // ################################################################################################################
    // PMD_AAB047_001_000_1FW3	Leistungseinführung				MLFB13
    // ################################################################################################################
    /*
    keine VTs direkt
    
    MLFB13:
        VT_1FW3_M00078	Anschlusstechnik<>MLFB13		nur Übersetzung MLFB13
            MLFB13_1FW3	PMD_ABU208_001_000_1FW3	PMD_AAB047_001_000_1FW3	HMK_VALUE_VALID_1FW3
        
        VT_1FW3_M00130	Opt V31 VW Sonderverzahnung II		nur Richtung V31
            HMK_KEY_V31_1FW3	MLFB13_1FW3	MLFB14_1FW3	MLFB16_1FW3	HMK_VALUE_VALID_1FW3
            K_V31				5			A			0			T    
        
        VT_1FW3_M00140	MLFB-Logik Geber II (DI)	nur Richtung HMK_KEY_GEBER_1FW3
            HMK_KEY_GEBER_1FW3	MLFB13_1FW3	MLFB14_1FW3	HMK_VALUE_VALID_1FW3
            20_M 				7			A			T    
        
        VT_1FW3_M00169	Verriegelung J1A Q1A U12	nur Richtung HMK-Attribute
            MLFB13_1FW3	MLFB15_1FW3	HMK_J1A_1FW3	HMK_Q1A_1FW3	HMK_U12_1FW3	HMK_VALUE_VALID_1FW3
            6			Z			J1A  			Q1A  			U12  			T    
        
        VT_1FW3_M00175	Verriegelung MLFB13 L03
            HMK_RUMPF_9_11_12_15_1FW3	MLFB13_1FW3	HMK_L03_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3

    VT78 enthält PMD_AAB047_001_000_1FW3	Leistungsanschluss
    MLFB13_1FW3	PMD_ABU208_001_000_1FW3	PMD_AAB047_001_000_1FW3	HMK_VALUE_VALID_1FW3
    5	00001	Q_R  	T    
    6	00001	Q_L  	T    
    7	00001	NDE  	T    
    8	00001	DE   	T    

    */
    var sTargetMLFB = "MLFB13_1FW3";
    var sTargetAttribute = "PMD_AAB047_001_000_1FW3";
    // zunächst Logik auf MLFB13_1FW3

    var sTable = "VT_1FW3_M00175" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_WELLENENDE_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // ggf. HMK-Attribute
    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung in PMD_AAB047_001_000_1FW3
    var sTable = "VT_1FW3_M00078" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable);

    if (sStatus == "Error") {
        // Fehler
        strError = ECL_Translate("DICT1_ERR_1FW3___LOGIC_TRANSFER_MLFB13");
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // setze MLFB13
    // ################################################################################################################
    var PMD_AAB047_001_000_1FW3 = ECL_GetValue("PMD_AAB047_001_000_1FW3");

    // var sTable = "VT_1FW3_M00078" + sDB_Suffix;
    var sSQL = "SELECT MLFB13_1FW3 FROM " + sTable + " WHERE " +
        "PMD_AAB047_001_000_1FW3 = '" + PMD_AAB047_001_000_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB13_1FW3 = aResult[0].MLFB13_1FW3;
    } else {
        strError = ECL_Translate("DICT1_ERR_1FW3___SET_MLFB13");
        return strError;
    }

    ECL_SetValue("MLFB13_1FW3", MLFB13_1FW3);

    sMLFB = replaceAt(sMLFB, 12, MLFB13_1FW3)
    ECL_SetValue("ECSI_MLFB", sMLFB);
    // ################################################################################################################



    // ################################################################################################################
    // HMK_M02_1FW3	Klemmenkastentyp GK603 mit abnehmbarer Kabeleinführungsplatte mit 2 x M63 x 1,5
    // ################################################################################################################
    /*
    HMK_M02_1FW3	Klemmenkastentyp GK603 mit abnehmbarer Kabeleinführungsplatte mit 2 x M63 x 1,5
    CB_M02_1FW3		M02 Klemmenkastentyp GK603 mit abnehmbarer Kabeleinführungsplatte mit 2 x M63 x 1,5
    
    
    VT_1FW3_M00117	Opt M02 Klemmenkasten GK603
        HMK_RUMPF_1FW3	HMK_M02_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sDTKAttribute = "HMK_M02_1FW3";
    var sCB_Attribute = "CB_M02_1FW3";

    var sTable = "VT_1FW3_M00117" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "M02", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_M02_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // HMK_P01_1FW3	Abnehmbare Kabeleinführungsplatte mit 3 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7700
    // ################################################################################################################
    /*
    HMK_P01_1FW3	Abnehmbare Kabeleinführungsplatte mit 3 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7700
    CB_P01_1FW3	P01 Abnehmbare Kabeleinführungsplatte mit 3 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7700

    
    A VT_1FW3_M00164	Verriegelung P01 P04
        HMK_P01_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    
    B VT_1FW3_M00168	Opt P01 Kabeleinführungsplatte
        HMK_RUMPF_1FW3	HMK_P01_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sDTKAttribute = "HMK_P01_1FW3";
    var sCB_Attribute = "CB_P01_1FW3";

    if (ECL_ValueSelected("CB_P04_1FW3", "T")) {
        var HMK_P04_1FW3 = "P04";
    } else {
        var HMK_P04_1FW3 = "F";
    }

    var sTable = "VT_1FW3_M00164" + sDB_Suffix;
    var sWhere = "HMK_P04_1FW3 = '" + HMK_P04_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "P01", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_P01_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FW3_M00168" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "P01", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_P01_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // HMK_P04_1FW3	Abnehmbare Kabeleinführungsplatte mit 4 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7712
    // ################################################################################################################
    /*
    HMK_P04_1FW3	Abnehmbare Kabeleinführungsplatte mit 4 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7712
    CB_P04_1FW3	P04 Abnehmbare Kabeleinführungsplatte mit 4 x M63 x 1,5; Leitungseinführungsplatte für den Klemmenkasten 1XB7712
    
    VT_1FW3_M00163	Opt P04 Kabeleinführungsplatte
        HMK_RUMPF_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    VT_1FW3_M00164	Verriegelung P01 P04
        HMK_P01_1FW3	HMK_P04_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sDTKAttribute = "HMK_P04_1FW3";
    var sCB_Attribute = "CB_P04_1FW3";

    if (ECL_ValueSelected("CB_P01_1FW3", "T")) {
        var HMK_P01_1FW3 = "P01";
    } else {
        var HMK_P01_1FW3 = "F";
    }

    var sTable = "VT_1FW3_M00164" + sDB_Suffix;
    var sWhere = "HMK_P01_1FW3 = '" + HMK_P01_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "P04", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_P04_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FW3_M00163" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "P04", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_P04_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // HMK_K84_1FW3	Steckerabgangsrichtung um -90° gedreht						nicht nötig!
    // ################################################################################################################
    /*
    HMK_K84_1FW3	Steckerabgangsrichtung um -90° gedreht
    CB_K84_1FW3	K84 Steckerabgangsrichtung um -90° gedreht

    VT_1FW3_M00178	Opt K84 Steckerabgangsrichtung
    
    ===> NICHT MEHR FÜR AKTUELLE PRODUKTE!!!
    */
    // ################################################################################################################




    // ################################################################################################################
    // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
    // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
    // OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN OPTIONEN	OPTIONEN OPTIONEN
    // ################################################################################################################

    // ################################################################################################################
    // HMK_Y84_1FW3	Kundenangabe auf dem Leistungsschild
    // ################################################################################################################
    /*
    HMK_Y84_TEXT_1FW3
    
    Wenn eine Eingabe im Textfeld gemacht wird, wird die Option verdeckt gesetzt, wenn Textfeld leer, dann Option 'F'
    */

    if (ECL_ValueEnabled("HMK_Y84_1FW3", "Y84")) {
        ECL_ActivateAttribute("HMK_Y84_TEXT_1FW3");
    } else {
        ECL_DeactivateAttribute("HMK_Y84_TEXT_1FW3");
    }

    if (strchangedAttribute == "HMK_Y84_TEXT_1FW3") {
        var sValueNorm = normalizeOE_Attribute("HMK_Y84_TEXT_1FW3");
        if (sValueNorm == "") {
            ECL_SelectValue("HMK_Y84_1FW3", "F");
        } else {
            ECL_SelectValue("HMK_Y84_1FW3", "Y84");
        }
    }

    // ################################################################################################################


    // ################################################################################################################
    // HMK_FARBAUSF_1FW3	Ausführung		(Farbausführung)
    // ################################################################################################################
    /*
    VT_1FW3_M00094	Opt Farbausführung <-> K24
    VT_1FW3_M00158	Q95 <> K24
        Wenn Q95, nur LACK
        HMK_Q95_1FW3	HMK_FARBAUSF_1FW3	HMK_VALUE_VALID_1FW3
    
    */

    var sTargetAttribute = "HMK_FARBAUSF_1FW3";


    if (ECL_ValueSelected("CB_Q95_1FW3", "T")) {
        var HMK_Q95_1FW3 = "Q95";
        ECL_DeactivateValue("HMK_FARBAUSF_1FW3", "GRUND");
    } else {
        var HMK_Q95_1FW3 = "F";
        ECL_ActivateValue("HMK_FARBAUSF_1FW3", "GRUND");
    }

    var sTable = "VT_1FW3_M00158" + sDB_Suffix;
    var sWhere = "HMK_Q95_1FW3 = '" + HMK_Q95_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    // HMK_K24_1FW3	Grundierung (ohne Lackierung)
    // ################################################################################################################
    /*
    VT_1FW3_M00094	Opt Farbausführung <-> K24
        HMK_FARBAUSF_1FW3	HMK_K24_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sTargetAttribute = "HMK_K24_1FW3";

    var HMK_FARBAUSF_1FW3 = ECL_GetValue("HMK_FARBAUSF_1FW3");

    var sTable = "VT_1FW3_M00094" + sDB_Suffix;
    var sWhere = "HMK_FARBAUSF_1FW3 = '" + HMK_FARBAUSF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_K24_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // PMD_AAD756_001_000_1002782	Farbe
    // ################################################################################################################
    /*
    VT_1FW3_M00095	Opt Mapping Farbe
    
    keine Einschränkungen, Default 00001, keine KAG
    Wenn HMK_FARBAUSF_1FW3 == GRUND, dann nur OOHNE
    */

    var HMK_FARBAUSF_1FW3 = ECL_GetValue("HMK_FARBAUSF_1FW3");

    if (HMK_FARBAUSF_1FW3 == "GRUND") {
        ECL_DeactivateAllAttributeValues("PMD_AAD756_001_000_1002782");
        ECL_ActivateValue("PMD_AAD756_001_000_1002782", "OHNE");
        ECL_SelectValue("PMD_AAD756_001_000_1002782", "OHNE");
    } else {
        ECL_ActivateAllAttributeValues("PMD_AAD756_001_000_1002782");
        ECL_DeactivateValue("PMD_AAD756_001_000_1002782", "OHNE");

        ExecSetStandardifValueEmpty("PMD_AAD756_001_000_1002782", "00001");
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_Q95_1FW3	Sonderlack ALEXIT
    // ################################################################################################################
    /*
    HMK_Q95_1FW3	Sonderlack ALEXIT
    CB_Q95_1FW3	Q95 Sonderlack ALEXIT

    VT_1FW3_M00158	Q95 <> K24
        HMK_Q95_1FW3	HMK_FARBAUSF_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sDTKAttribute = "HMK_Q95_1FW3";
    var sCB_Attribute = "CB_Q95_1FW3";

    var HMK_FARBAUSF_1FW3 = ECL_GetValue("HMK_FARBAUSF_1FW3");

    var sTable = "VT_1FW3_M00158" + sDB_Suffix;
    var sWhere = "HMK_FARBAUSF_1FW3 = '" + HMK_FARBAUSF_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q95", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_Q95_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    // ################################################################################################################


    // ################################################################################################################
    // HMK_B02_1FW3	Werksprüfzeugnis
    // ################################################################################################################
    /*
    HMK_B02_1FW3	Werksprüfzeugnis
    CB_B02_1FW3	B02 Werksprüfzeugnis

    keine Einschränkungen
    */
    // ################################################################################################################



    // ################################################################################################################
    // HMK_Q30_1FW3	Spannelement
    // ################################################################################################################
    /*
    HMK_Q30_1FW3	Spannelement
    CB_Q30_1FW3	Q30 Spannelement
    
    
    VT_1FW3_M00043	Opt Q30 Spannelement
        HMK_Q30_1FW3	HMK_MLFB05_06_1FW3	MLFB15_1FW3	MLFB16_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sDTKAttribute = "HMK_Q30_1FW3";
    var sCB_Attribute = "CB_Q30_1FW3";

    var sTable = "VT_1FW3_M00043" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "MLFB16_1FW3 = '" + MLFB16_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "Q30", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_Q30_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_T32_1FW3	Statordrehmomentenstütze
    // ################################################################################################################
    /*
    HMK_T32_1FW3	Statordrehmomentenstütze
    CB_T32_1FW3	T32 Statordrehmomentenstütze
    
    
    VT_1FW3_M00041	Opt T32 Drehmomentstütze
        HMK_T32_1FW3	HMK_MLFB05_06_1FW3	MLFB15_1FW3	MLFB16_1FW3	HMK_VALUE_VALID_1FW3
    
    */
    var sDTKAttribute = "HMK_T32_1FW3";
    var sCB_Attribute = "CB_T32_1FW3";

    var sTable = "VT_1FW3_M00041" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "MLFB16_1FW3 = '" + MLFB16_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T32", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_T32_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_OPT_KALTLEITER_1FW3	Motorschutz durch Kaltleiter (3 x PTC)
    // ################################################################################################################
    /*
    HMK_OPT_KALTLEITER_1FW3	Motorschutz durch Kaltleiter (3 x PTC)
    CB_A11_1FW3	A11 Motorschutz durch Kaltleiter (3 x PTC)
    
    keine Einscränkungen
    */

    // ################################################################################################################


    // ################################################################################################################
    // HMK_WELLENABDECKUNG_1FW3	Wellenabdeckung auf NDE
    // ################################################################################################################
    /*
    HMK_WELLENABDECKUNG_1FW3	Wellenabdeckung auf NDE
    CB_T20_1FW3	T20 Wellenabdeckung auf NDE
    
    
    VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
        HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    
    HMK_KEY_GEBER_1FW3 bei 'AKT' immer OHNE
    */
    var sDTKAttribute = "HMK_WELLENABDECKUNG_1FW3";
    var sCB_Attribute = "CB_T20_1FW3";

    var sTable = "VT_1FW3_M00180" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_KEY_GEBER_1FW3 = 'OHNE' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "T20", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_T20_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // HMK_OPT_NACHSCHMIER_1FW3	Nachschmiereinrichtung
    // ################################################################################################################
    /*
    HMK_OPT_NACHSCHMIER_1FW3	Nachschmiereinrichtung
    CB_K40_1FW3	K40 Nachschmiereinrichtung
    
    
    VT_1FW3_M00066	Opt K40 <-> V07 Schmierung
        HMK_MLFB05_06_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_V07_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00162	Opt K40 Nachschmier
        HMK_MLFB05_06_1FW3	MLFB09_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00189	AH - Options K40 - L03
    PMD_ACH516_001_000_1FW3	MLFB08_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_L03_1FW3	PMD_AAA506_001_000_1FW3
	
    */
    var sDTKAttribute = "HMK_OPT_NACHSCHMIER_1FW3";
    var sCB_Attribute = "CB_K40_1FW3";

    var sTable = "VT_1FW3_M00162" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K40", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_K40_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("CB_V07_1FW3", "T")) {
        var HMK_V07_1FW3 = "V07";
    } else {
        var HMK_V07_1FW3 = "F";
    }

    var sTable = "VT_1FW3_M00066" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "HMK_V07_1FW3 = '" + HMK_V07_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K40", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_K40_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    /*VT_1FW3_M00189	AH - Options K40 - L03
        PMD_ACH516_001_000_1FW3	MLFB08_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_L03_1FW3	PMD_AAA506_001_000_1FW3
    * /
    if (ECL_ValueSelected("CB_L03_1FW3", "T")){
        var HMK_L03_1FW3 = "L03";
    }else{
        var HMK_L03_1FW3 = "F";
    }
    */
    var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");

    var sTable = "VT_1FW3_M00189" + sDB_Suffix;
    var sWhere = "PMD_ACH516_001_000_1FW3 = '" + PMD_ACH516_001_000_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        //"HMK_L03_1FW3 = '" + HMK_L03_1FW3 + "' AND " +
        "PMD_AAA506_001_000_1FW3 = '" + PMD_AAA506_001_000_1FW3 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "K40", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_K40_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_V07_1FW3	Sonderbefettung für niedrige Drehzahlen
    // ################################################################################################################
    /*
    HMK_V07_1FW3	Sonderbefettung für niedrige Drehzahlen
    CB_V07_1FW3	V07 Sonderbefettung für niedrige Drehzahlen
    
    
    VT_1FW3_M00066	Opt K40 <-> V07 Schmierung
    VT_1FW3_M00067	Opt V07 Sonderfett
        HMK_MLFB05_06_1FW3	MLFB08_1FW3	HMK_V07_1FW3	HMK_VALUE_VALID_1FW3

    
    */
    var sDTKAttribute = "HMK_V07_1FW3";
    var sCB_Attribute = "CB_V07_1FW3";

    var sTable = "VT_1FW3_M00067" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "V07", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_V07_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("CB_K40_1FW3", "T")) {
        var HMK_OPT_NACHSCHMIER_1FW3 = "K40";
    } else {
        var HMK_OPT_NACHSCHMIER_1FW3 = "F";
    }

    var sTable = "VT_1FW3_M00066" + sDB_Suffix;
    var sWhere = "HMK_MLFB05_06_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "HMK_OPT_NACHSCHMIER_1FW3 = '" + HMK_OPT_NACHSCHMIER_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "V07", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_V07_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################





    // ################################################################################################################
    // HMK_L03_1FW3	Erhöhte Rüttelbeanspruchung (Heavy Duty)
    // ################################################################################################################
    /*
    HMK_L03_1FW3	Erhöhte Rüttelbeanspruchung (Heavy Duty)
    CB_L03_1FW3	L03 Erhöhte Rüttelbeanspruchung (Heavy Duty)
    
    
    VT_1FW3_M00174	Opt_Pflicht L03 Erh Ruettelfest
        HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_L03_1FW3	HMK_HINW_L03_PFLICHT_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    
    VT_1FW3_M00175	Verriegelung MLFB13 L03
        HMK_RUMPF_9_11_12_15_1FW3	MLFB13_1FW3	HMK_L03_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    
          VT_1FW3_M00189	AH - Options K40 - L03
    PMD_ACH516_001_000_1FW3	MLFB08_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_L03_1FW3	PMD_AAA506_001_000_1FW3
	
    */
    var sDTKAttribute = "HMK_L03_1FW3";
    var sCB_Attribute = "CB_L03_1FW3";

    var sTable = "VT_1FW3_M00174" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_L03_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FW3_M00175" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "MLFB13_1FW3 = '" + MLFB13_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_L03_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    /*VT_1FW3_M00189	AH - Options K40 - L03
        PMD_ACH516_001_000_1FW3	MLFB08_1FW3	HMK_OPT_NACHSCHMIER_1FW3	HMK_L03_1FW3	PMD_AAA506_001_000_1FW3
    */
    if (ECL_ValueSelected("CB_K40_1FW3", "T")) {
        var HMK_OPT_NACHSCHMIER_1FW3 = "K40";
    } else {
        var HMK_OPT_NACHSCHMIER_1FW3 = "F";
    }
    //var PMD_AAA506_001_000_1FW3 = ECL_GetValue("PMD_AAA506_001_000_1FW3");

    var sTable = "VT_1FW3_M00189" + sDB_Suffix;
    var sWhere = "PMD_ACH516_001_000_1FW3 = '" + PMD_ACH516_001_000_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "HMK_OPT_NACHSCHMIER_1FW3 = '" + HMK_OPT_NACHSCHMIER_1FW3 + "' AND " +
        "PMD_AAA506_001_000_1FW3 = '" + PMD_AAA506_001_000_1FW3 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "L03", "F", sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_L03_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Lagerwechselfrist	UI_LAGERW_FRIST_1FW3        2nd L03-Abhängigkeit
    // ################################################################################################################
    var sTargetAttribute = "UI_LAGERW_FRIST_1FW3";
    /*
    VT_1FW3_M00153	Lagerwechselfrist
        HMK_RUMPF_1FW3	MLFB15_1FW3	HMK_K40_1FW3	HMK_L03_H_1FW3	UI_LAGERW_FRIST_1FW3	HMK_VALUE_VALID_1FW3

        Achtung: um wechselwirkung mit L03-Pflicht zu behandeln, Auswertung von HMK_L03_H_1FW3 nach L03
    */
    var HMK_K40_1FW3 = "F";
    if (ECL_ValueSelected("CB_K40_1FW3", "T")) {
        HMK_K40_1FW3 = "T";
    }
    var HMK_L03_H_1FW3 = "F";
    if (ECL_ValueSelected("CB_L03_1FW3", "T")) {
        HMK_L03_H_1FW3 = "T";
    }

    var sTable = "VT_1FW3_M00153" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_K40_1FW3 = '" + HMK_K40_1FW3 + "' AND " +
        "HMK_L03_H_1FW3 = '" + HMK_L03_H_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_LAGERWECHSELFRIST_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // HMK_G50_1FW3	Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung
    // ################################################################################################################
    /*
    HMK_G50_1FW3
    CB_G50_1FW3		G50 Schwingungsaufnehmer; Sonderlagerschild AS und BS mit Sensorbohrung
    
    VT_1FW3_M00166	Opt G50 Sonderlagerschild
    HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_G50_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3
    */
    var sDTKAttribute = "HMK_G50_1FW3";
    var sCB_Attribute = "CB_G50_1FW3";

    var sTable = "VT_1FW3_M00166" + sDB_Suffix;
    var sWhere = "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, "G50", "F", sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW3___PLVT_G50_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################





    // ################################################################################################################
    // ################################################################################################################


    return "OK";

}
