//@legacy
//#mode(full-ecma)


/**
 * @category   Product Logic
 * @package    Core
 * @copyright  Copyright (c) 2009-2013 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * checks if a value is contained in an array
 * (necessary due to a bug in EasyScript that has introduce an Array.indexOf-function that computes wrong values for empty arrays or arrays with mixed types)
 *
 * @param array - array to check
 * @param value - value to test
 *
 * @return boolean: true - configuration contains array
 *                  false - configuration doesn't contain array
 */
function indexOf( array, value )
{
    if ( !array )
        return( -1 );
        
    var len = array.length;
    if ( !len )
        return( -1 );
    
    var test =arguments[2];
    var from = Number( arguments[2] );
    if ( isNaN( from ) )
        from = 0;
    else 
    {
        from = ( from < 0 ) ? Math.ceil(from) : Math.floor(from);
        if ( from < 0 )
          from += len;
    }

    for ( ; from < len; ++from )
    {
        if ( ( from in array ) && ( array[from] === value ) )
            return( from );
    }
    return( -1 );
}


/**
 * collect all properties that are in the first, but not in the second object
 *
 * @param oSource - first object (should be a superset of the second object)
 * @param oSub - second object (should be a subset of the first object)
 *
 * @return object - collection of properties that are in oSource, but not in oSub
 */
function diffObject( oSource, oSub )
{
    var diff = {};
    for( var p in oSource )
    {
        if ( p in oSub )
            continue;
        diff[p] = oSource[p];
    }
    return( diff );
}


/**
 * test if a value lies within a certain  of another
 *
 * @param dVarValue - value to test
 * @param dConstantValue - center of the intervall
 * @param dTolerance - intervall tolerance
 *
 * @return boolean - true: value lies in range
 *                   false: value lies not in range
 */
function isValueinRange( dVarValue, dConstantValue, dTolerance )
{
    var delta = dTolerance || 1e-8;	// default tolerance: 10^-8
    if ( ( dVarValue < ( dConstantValue - delta ) ) ||
         ( dVarValue > ( dConstantValue + delta ) ) )
        return( false );

    return( true );
}


/**
 * test a string array if one contained string contains a substring
 *
 * @param aStrings - array of strings to search
 * @param strSub - substring
 * @param nStartIndex - position in array where to start the search
 *
 * @return number - index of first string in array that contains the substring
 *                  -1, if no string of the array contains the substring
 */
function containsString( aStrings, strSub, nStartIndex )
{
    if ( !nStartIndex )
        nStartIndex = 0;

    var len = aStrings.length;
    for( var i = nStartIndex; i < len; ++i )
    {
        if ( ( typeof( aStrings[i] ) === 'string' ) && ( aStrings[i].indexOf( strSub ) >= 0 ) )
            return( i );
    }
    
    return( -1 );
}

/**
 * @constructor
 * find the position of the first number in a string
 * 
 * @param str - string to search
 * @return number - position of first number in the string
 *                  -1 if no number is in the string
 */
function findFirstNumber( str )
{
    if(!str)
        return ( -1 );
    
    var oNumbers = { '0': '', '1': '', '2': '', '3': '', '4': '', '5': '', '6': '', '7': '', '8': '', '9': '' };
    for ( var i = 0; i < str.length; ++i )
    {
        if ( str.charAt( i ) in oNumbers )
            return( i );
    }
    return( -1 );
}


/**
 * @constructor
 * test if an object is an array
 *
 * @param obj - object to test
 * @return boolean: true - object is an array
 *                  false - object is not an array
 */
function isArray( obj )
{
    if ( !obj )
        return( false );
    
    // weird that this works in EasyScript, but instanceof doesn't work
    try{		
        return( obj.prototype.toString() === '[object Array]' );
    }
    catch(err){
        logtraceln('Error in fucntion isArray: '+ typeof obj.prototype.toString == 'function');
        //alert(err.message+' -- Array');
    }
}

/**
 * @constructor
 * remove one or more elements from an array
 *
 * @param aArray - array to remove an element from
 * @param nIndexOfElementToRemove - index of first element to remove
 * @param nCount - number of elements to remove
 * @return array: contiguous array without the removed elements
 */
function removeElementsFromArray( aArray, nIndexOfElementToRemove, nCount )
{
    // REMEMBER: since the splice function has a wonderful bug^B^B^Bfeature in EasyScript - it does not provide a contiguous array anymore if one or more elements have been removed 
    // since it doesn't move the elements after the deleted ones as necessary - 
    // we can't modify the array in-place anymore, but we have to write this replacement function
    var nLen = aArray.length;
    if ( !( 'length' in aArray ) || ( nLen <= 0 ) || ( nIndexOfElementToRemove >= nLen ) || !nCount || ( nCount <= 0 ) )
        return( aArray );
    
    var aResult = [];
    var nUpperIndex = nIndexOfElementToRemove + nCount - 1;
    for ( var i = 0; i < nLen; ++i )
    {
        if ( ( i < nIndexOfElementToRemove ) || ( i > nUpperIndex ) )
            aResult.push( aArray[i] );
    }
    
    return( aResult );
}

/**
    ersetzt an gegebener Stelle den Char
*/
function replaceAt(string, index, replace) {
  return string.substring(0, index) + replace + string.substring(index + 1);
}