//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"


//@import "../1FW3_MLFB/Base.misc.js"


/**
 * @category   1FW3 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
    vtTimeStart = Date.getTime();

    var oParsing = {
        strBaseMLFB: '',
        strFullMLFB: '',
        strError: '',
        strWarning: '',
        aTokens: [],
        oFreetext: {}
    };

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    strMLFB = normalizeMLFB(strMLFB);
    strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

    // MLFB Freitexte
    var nFreetext = find(strMLFB, '{');
    var strFreetext = '';
    if (nFreetext > 0) {
        strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
    }
    oParsing.oFreetext = parseFreetext(strFreetext, true);
    strMLFB = replace(strMLFB, strFreetext, "");
    oParsing.strFullMLFB = strMLFB;

    // Kurzangaben aus MLFB 
    var aComponents = tokenize(strMLFB);
    if (!aComponents.length) {
        oParsing.strError = 'ERRORMSG_MLFB_1FW3___INVALID_MLFB';
        return (oParsing)
    } else if (aComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ((aComponents[1] === 'Z') || (aComponents[1] === '-Z')) {
            aComponents = removeElementsFromArray(aComponents, 1, 1);
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;

    if (oParsing.strBaseMLFB.length !== 16) {
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FW3___PARSE_WRONG_SIZE';
        return (oParsing);
    }

    if (oParsing.strBaseMLFB.indexOf("1FW3") < 0) {
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FW3___PARSE_WRONG_PRODUCT';
        return (oParsing);
    }


    // fix sind MLFB1-8 + 10
    var strMLFB_fix = strMLFB.substring(0, 8) + "." + strMLFB.substring(9, 10) + "..." + strMLFB.substring(12, 13);

    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

    if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration = "1";

    if (strStartConfiguration == "1") {
        // entweder unvollständige MLFB, also Defaults setzen oder KEEP-Configuration-Fall, 
        // dann muss die MLFB aber vollständig spezifiziert sein!
        //und eine zur Haupt MLFB unterschiedliche Base Type MLFB übergeben werden.
        //Hier sollen dann möglichst viele Attribute beibehalten werden.
        var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 8) + "." + strBaseTypeMLFB.substring(9, 10) + "..." + strBaseTypeMLFB.substring(12, 13);

        // Abgleich BT (BaseTypeMLFB) und MLFB für Keep Configuration
        // -----------------------------------------------------------------------------------------------
        //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
        // -----------------------------------------------------------------------------------------------
        if ((strBaseTypeMLFB_fix != strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") {
            // #################################################################################################################
            // KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION
            // #################################################################################################################
            //--------------------------------------------------------------------------------------------------------
            // Base-Type-MLFB aufbereiten
            //--------------------------------------------------------------------------------------------------------
            var aBTComponents = tokenize(strBaseTypeMLFB);
            if (aBTComponents.length > 1) {
                // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
                // eliminate the resulting invalid short description 'Z'
                if ((aBTComponents[1] === 'Z') || (aBTComponents[1] === '-Z')) {
                    aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
                }
            }

            strBaseTypeMLFB = aBTComponents[0];

            if (strBaseTypeMLFB.length === 17) {
                // eliminate the -Z 
                strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
            }

            // -----------------------------------------------------------------------------------------------
            // KAG abgleichen und ggf übernehmen/entfernen
            // -----------------------------------------------------------------------------------------------
            /* mögliche Platzhalter
                MLFB01	1FW3
                MLFB05	Achshöhe	{15,20,28,(40)}
                MLFB07	Baulänge
                MLFB08	Kennziffer / Motortyp
                MLFB09	. Geber
                MLFB10	Wicklung/Drehzahl 
                MLFB11	. Spannungsfestigkeit, Geberanbau
                MLFB12	. Bauform
                MLFB13	. Anschlusstechnik
                MLFB14	. Motorversion
                MLFB15	. Mechanik Rotor
                MLFB16	. Lagerung
            */

            // -----------------------------------------------------------------------------------------------
            // Platzhalter aus MLFB in BT übernehmen
            // -----------------------------------------------------------------------------------------------
            // MLFB15 Mechanik Rotor
            // ---------------------------------------------------------------------------------------------------
            var sMLFB15 = strMLFB.charAt(14);
            var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

            if (sBT_MLFB15 == ".") {

                // todo Check MLFB15
                var bCheck = checkMLFB15_Parser(strBaseTypeMLFB, sMLFB15);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
                } else {

                    // Setze Default:
                    var sMLFB05_BT = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
                    var sMLFB08_BT = strBaseTypeMLFB.charAt(7);

                    sTable = "VT_1FW3_M00083" + sDB_Suffix;
                    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "HMK_MLFB05_06_1FW3 = '" + sMLFB05_BT + "' AND " +
                        "MLFB08_1FW3 = '" + sMLFB08_BT + "' AND " +
                        "HMK_VALUE_VALID_1FW3 = 'T' ORDER BY MLFB15_1FW3;";

                    var aResult = GetDBDataSetEXT(sSQL);
                    if (aResult.length > 0) {
                        var MLFB15_1FW3 = aResult[0].MLFB15_1FW3;
                    }
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, MLFB15_1FW3);
                }
            }

            // ---------------------------------------------------------------------------------------------------
            // MLFB12	Bauform
            // ---------------------------------------------------------------------------------------------------
            // 2,3,4,5,6,8
            // 
            // Wenn AH < 280 2 (IM B14) sonst 3 (IM B35)
            /*	var MLFB05_1FW3 = strMLFB.charAt(4) + strMLFB.charAt(5);
                // Default 
                if (strMLFB.charAt(11) == "."){
                    // Setze Default:
                    if (MLFB05_1FW3 == "15" || MLFB05_1FW3 == "20"){
                        strMLFB = replaceAt(strMLFB, 11, "2");
                    }else{
                        strMLFB = replaceAt(strMLFB, 11, "3");
                    }
                }
            */
            // Default 0
            var sMLFB12 = strMLFB.charAt(11);
            var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);

            if (sBT_MLFB12 == ".") {
                // versuche Wert aus MLFB zu setzen: 

                var bCheck = checkMLFB12_Parser(strBaseTypeMLFB, sMLFB12);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
                    // Wenn Z, wurde bereits oben die KAG gesetzt
                } else {
                    var sMLFB05_BT = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
                    // Default, falls nicht erlaubt:
                    if (sMLFB05_BT == "15" || sMLFB05_BT == "20") {
                        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "2");
                    } else {
                        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "3");
                    }
                }
            }

            // ---------------------------------------------------------------------------------------------------

            // ---------------------------------------------------------------------------------------------------
            // MLFB09 Geber
            // ---------------------------------------------------------------------------------------------------
            /* ECSI_CX_EncoderTypeRough
                Null	Any (nothing specific set by the user)
                0		Incremental
                1		Absolute
                
            PMD_ABU278_001_000_1FW3	PMD_ABU209_001_000_1FW3
            A	00002	ohne DQ 	F    				Ink
            E	00003	ohne DQ 	F    				Abs
            S	00005	ohne DQ 	F    				Res
            W	00001	ohne DQ 	F    OHNE GEBER		
            D	00006	mit DQ		T    				Ink
            F	00007	mit DQ		T    				Abs
            U	00009	mit DQ		T    				Res
            B	00010	mit DQ		T    				Abs
            C	00011	mit DQ		T    				Abs Singleturn
            M	00012	ohne DQ 	F    ???			Ink
            G	00015	ohne DQ 	F    ???			Abs
            K	00016	mit DQ		T    ???			Abs
            
            */
            var bRiemen = false;

            var sMLFB09 = strMLFB.charAt(8);
            var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);
            var sMLFB14 = strMLFB.charAt(13);
            var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

            if (sBT_MLFB09 == ".") {
                // default ohne
                /* todo keep config: check_MLFB09
                */
                var ECSI_CX_EncoderTypeRough = ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
                if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {	// nur Absolutwertgeber
                    // E,F,B (F,B mit DQ)
                    if (sBT_MLFB14 == "." || sBT_MLFB14 == "D" || sMLFB14 == "D") {
                        // Default ohne DriveCLiQ
                        var MLFB09_1FW3_BT = "E";
                    } else if (sBT_MLFB14 == "A" || sMLFB14 == "A") {
                        // mit DriveCLiQ (F oder B)
                        // todo 

                        var MLFB09_1FW3_BT = "F";
                    }
                } else if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 0) { // nur Inkrementalgeber
                    if (sBT_MLFB14 == "." || sBT_MLFB14 == "A" || sMLFB14 == "A") {
                        // ohne DriveCLiQ	A
                        var MLFB09_1FW3_BT = sMLFB09;
                    } else if (strMLFB.charAt(13) == "D") {
                        // mit DriveCLiQ	D
                        var MLFB09_1FW3_BT = sMLFB09;
                    }
                    bRiemen = true;
                } else {
                    // Check Geber
                    var bCheck = checkMLFB09_Parser(strBaseTypeMLFB, sMLFB09);
                    if (bCheck) {
                        // setzen
                        var MLFB09_1FW3_BT = sMLFB09;

                        // MLFB14_1FW3 bestimmen
                        var MLFB14_1FW3_BT = sMLFB14;

                    } else {
                        // Default setzen
                        // Ohne
                        var MLFB09_1FW3_BT = getGeberParserDefault(strBaseTypeMLFB);
                        var MLFB14_1FW3_BT = "D";
                    }

                    //var MLFB09_1FW3_BT = sMLFB09;
                }
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, MLFB09_1FW3_BT);
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, MLFB14_1FW3_BT);
            }

            // ---------------------------------------------------------------------------------------------------
            // MLFB11 	Geberanbau
            // ---------------------------------------------------------------------------------------------------

            var sMLFB11 = strMLFB.charAt(10);
            var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);

            if (sBT_MLFB11 == ".") {

                // Default 6, direkter Geberanbau oder Geberlos

                if (bRiemen && sMLFB11 == "7") {
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, "7");
                } else if (bRiemen && sMLFB11 != "7") {
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, "7");
                } else {
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, "6");
                }
            }
            // ---------------------------------------------------------------------------------------------------
            // MLFB13	Anschlusstechnik
            // ---------------------------------------------------------------------------------------------------
            var sMLFB13 = strMLFB.charAt(12);
            var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

            if (sBT_MLFB13 == ".") {

                // 
                var bCheck = checkMLFB13_Parser(strBaseTypeMLFB, sMLFB13);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
                } else {
                    // Setze Default 5:
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, "5");
                }
            }

            // ---------------------------------------------------------------------------------------------------
            // MLFB14	Motorversion (DQ)
            // ---------------------------------------------------------------------------------------------------
            /*
                DriveCLiQ bei Geber behandelt
            */

            // ---------------------------------------------------------------------------------------------------
            // MLFB16 Lagerung
            // ---------------------------------------------------------------------------------------------------
            var sMLFB16 = strMLFB.charAt(15);
            var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

            if (sBT_MLFB16 == ".") {

                var bCheck = checkMLFB16_Parser(strBaseTypeMLFB, sMLFB16);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
                } else {
                    // Setze Default:
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, "0"); // Standard
                }
            }
            // -----------------------------------------------------------------------------------------------
            // Zuweisen der neuen MLFB und KAG-Liste
            strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

            oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
            oParsing.strFullMLFB = strMLFB;
            aComponents[0] = oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
            ECL_SetValue("ECSI_MLFB", strMLFB);
        }
        // #######################################################################################################
        // END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END
        // #######################################################################################################
        else {
            // kein KEEP-Configuration, aber MLFB evtl. nicht vollständig spezifiziert
            if (find(strMLFB.left(16), ".") >= 0) {
                //Unvollständige SIZER MLFB

                // Prüfen, ob '.' an Stelle 1 bis 8 oder 10, dann Fehler
                for (var i = 0; i < 7; i++) {
                    if (strMLFB.charAt(i) == ".") {
                        oParsing.strError = 'ERRORMSG_MLFB_1FW3___INCOMPLETE_MLFB';
                        return (oParsing);
                    }
                }
                if (strMLFB.charAt(9) == ".") {
                    oParsing.strError = 'ERRORMSG_MLFB_1FW3___INCOMPLETE_MLFB';
                    return (oParsing);
                }

                // Wenn an Stelle 9, 11-16 ein Wildcard, dann Default setzen

                /* mögliche Platzhalter
                    MLFB01	1FW3
                    MLFB05	Achshöhe	{15,20,28,(40)}
                    MLFB07	Baulänge
                    MLFB08	Kennziffer / Motortyp
                    MLFB09	. Geber
                    MLFB10	Wicklung/Drehzahl 
                    MLFB11	. Spannungsfestigkeit, Geberanbau
                    MLFB12	. Bauform
                    MLFB13	. Anschlusstechnik
                    MLFB14	. Motorversion (DQ)
                    MLFB15	. Mechanik Rotor {A,C,S,M,H}
                    MLFB16	. Lagerung
                */
                // ---------------------------------------------------------------------------------------------------
                // Mechanik Rotor MLFB15
                // ---------------------------------------------------------------------------------------------------
                // Default M Vollwelle (ohne Paßfedernut) - (Vollwelle im Standard Di (glatte Welle))
                if (strMLFB.charAt(14) == ".") {
                    // Setze Default:
                    // bestimme MLFB15
                    // var sMLFB15 = getMLFB15(strMLFB);
                    /*VT_1FW3_M00083	Schutzart IP					Abhängigkeit von AH
                        HMK_MLFB05_06_1FW3	MLFB08_1FW3	MLFB15_1FW3	PMD_ABJ176_001_000_1FW3	HMK_VALUE_VALID_1FW3
                    VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
                        MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
                    */
                    var HMK_MLFB05_06_1FW3 = strMLFB.charAt(4) + strMLFB.charAt(5);
                    var MLFB08_1FW3 = strMLFB.charAt(7);

                    sTable = "VT_1FW3_M00083" + sDB_Suffix;
                    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
                        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
                        "HMK_VALUE_VALID_1FW3 = 'T' ORDER BY MLFB15_1FW3;";

                    var aResult = GetDBDataSetEXT(sSQL);
                    if (aResult.length > 0) {
                        var MLFB15_1FW3 = aResult[0].MLFB15_1FW3;
                    }

                    strMLFB = replaceAt(strMLFB, 14, MLFB15_1FW3);
                }



                // ---------------------------------------------------------------------------------------------------
                // Bauform MLFB12
                // ---------------------------------------------------------------------------------------------------
                // Wenn AH < 280 2 (IM B14) sonst 3 (IM B35)
                var MLFB05_1FW3 = strMLFB.charAt(4) + strMLFB.charAt(5);
                // Default 
                if (strMLFB.charAt(11) == ".") {
                    // Setze Default:
                    if (MLFB05_1FW3 == "15" || MLFB05_1FW3 == "20") {
                        strMLFB = replaceAt(strMLFB, 11, "2");
                    } else {
                        strMLFB = replaceAt(strMLFB, 11, "3");
                    }
                }


                // ---------------------------------------------------------------------------------------------------
                // MLFB09 Geber
                // ---------------------------------------------------------------------------------------------------
                /// Default W ohne Geber
                var bRiemen = false;
                if (strMLFB.charAt(8) == ".") {

                    var ECSI_CX_EncoderTypeRough = ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
                    if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {	// nur Absolutwertgeber
                        // E,F,B (F,B mit DQ)
                        if (strMLFB.charAt(13) == "." || strMLFB.charAt(13) == "D") {
                            // Default ohne DriveCLiQ
                            var MLFB09_1FW3 = "E";
                        } else if (strMLFB.charAt(13) == "A") {
                            // mit DriveCLiQ
                            var MLFB09_1FW3 = "F";
                        }

                    } else if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 0) { // nur Inkrementalgeber		ACHTUNG MLFB11 = 7
                        if (strMLFB.charAt(13) == "." || strMLFB.charAt(13) == "D") {
                            // ohne DriveCLiQ	A
                            var MLFB09_1FW3 = "A";
                        } else if (strMLFB.charAt(13) == "A") {
                            // mit DriveCLiQ	D
                            var MLFB09_1FW3 = "D";
                        }
                        bRiemen = true;
                    } else {
                        if (strMLFB.charAt(14) == ".") {
                            var MLFB09_1FW3 = "W";
                        } else {
                            var MLFB09_1FW3 = getGeberParserDefault(strMLFB);
                        }
                    }
                    strMLFB = replaceAt(strMLFB, 8, MLFB09_1FW3);
                }

                // ---------------------------------------------------------------------------------------------------
                // MLFB11_1FW3 Spannungsfestigkeit; Geberanbau
                // ---------------------------------------------------------------------------------------------------
                // Default 6, direkter Geberanbau oder Geberlos

                if (strMLFB.charAt(10) == ".") {
                    if (bRiemen) {
                        strMLFB = replaceAt(strMLFB, 10, "7");
                    } else {
                        strMLFB = replaceAt(strMLFB, 10, "6");
                    }
                }

                // ---------------------------------------------------------------------------------------------------
                // Anschlusstechnik MLFB13
                // ---------------------------------------------------------------------------------------------------
                // Default 5
                if (strMLFB.charAt(12) == ".") {
                    // Setze Default:
                    strMLFB = replaceAt(strMLFB, 12, "5");
                }

                // ---------------------------------------------------------------------------------------------------
                // Motorversion	MLFB14
                // ---------------------------------------------------------------------------------------------------
                // Default "D" (ohne DQ)
                if (strMLFB.charAt(13) == ".") {
                    // Setze Default:
                    // todo bestimmen ???
                    strMLFB = replaceAt(strMLFB, 13, "D");
                }

                // ---------------------------------------------------------------------------------------------------
                // Lagerung MLFB16
                // ---------------------------------------------------------------------------------------------------
                // Default 0
                if (strMLFB.charAt(15) == ".") {
                    // Setze Default:
                    strMLFB = replaceAt(strMLFB, 15, "0"); // Standard
                }
                // ---------------------------------------------------------------------------------------------------

                ECL_SetValue("ECSI_MLFB", strMLFB);
            }


            // Zuweisen der neuen MLFB und KAG-Liste
            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
        }
        // Jetzt sollte immer eine vollständig spezifizierte MLFB zur Verfügung stehen
    }	// der vorherige Abschnitt wurde nur bei IsStartConfiguration == 1 durchlaufen. Passt das ? todo


    // Ergebnis-Objekt zusammenbauen
    var oResult;
    oResult = parse_1FW3(oParsing.aTokens);
    //oResult = add_Rumpf(oResult);


    if (oResult) {
        if (oResult.oProduct)
            oParsing.oProduct = oResult.oProduct;
        if (oResult.oParsingData)
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strBaseTypeMLFB = strBaseTypeMLFB;
        oParsing.strError += ((oParsing.strError ? ' ' : '') + oResult.strError);
        oParsing.strWarning += ((oParsing.strWarning ? ' ' : '') + oResult.strWarning);
        oParsing.IsStartConfig = strStartConfiguration;
    }


    vtTimeStop = Date.getTime();
    vtTime = (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

    return (oParsing);
}

function parse_1FW3(aTokens) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /* mögliche Platzhalter
                MLFB01	1FW3
                MLFB05	Achshöhe	{15,20,28,(40)}
                MLFB07	Baulänge
                MLFB08	Kennziffer / Motortyp
                MLFB09	. Geber
                MLFB10	Wicklung/Drehzahl 
                MLFB11	. Spannungsfestigkeit, Geberanbau
                MLFB12	. Bauform
                MLFB13	. Anschlusstechnik
                MLFB14	. Motorversion (DQ, Tempsensor)
                MLFB15	. Mechanik Rotor	// edit 11.2022 now selectable
                MLFB16	. Lagerung
            */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4); // 1FW3
    oResult.oParsingData.MLFB.MLFB05 = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5); 	// 5+6 Achshöhe		{15,20,28,(40)}
    oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt(6);	 // Baulänge									
    oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt(7);  // Kennziffer / Motortyp						
    oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt(8);	 // . Geber										
    oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt(9);	 // Wicklung/Drehzahl 							
    oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt(10); // . Spannungsfestigkeit, Geberanbau
    oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt(11); // . Bauform (B3, B5, ...)						
    oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt(12); // . Anschlusstechnik
    oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt(13); // . Motorversion
    oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt(14); // . Mechanik Rotor
    oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt(15); // . Lagerung


    // Bestimme Rumpf
    var HMK_RUMPF_1FW3 = strBaseMLFB.substring(0, 8) + "X" + oResult.oParsingData.MLFB.MLFB10;

    oResult.oParsingData.MLFB.RUMPF = HMK_RUMPF_1FW3;
    ECL_SetValue("HMK_RUMPF_1FW3", HMK_RUMPF_1FW3);

    // HMK_RUMPF_9_11_12_15_1FW3
    var HMK_RUMPF_9_11_12_15_1FW3 = oResult.oParsingData.MLFB.MLFB09 + "_" + oResult.oParsingData.MLFB.MLFB11 + "_" +
        oResult.oParsingData.MLFB.MLFB12 + "_" + oResult.oParsingData.MLFB.MLFB15;

    oResult.oParsingData.MLFB.RUMPF09_15 = HMK_RUMPF_9_11_12_15_1FW3;
    ECL_SetValue("HMK_RUMPF_9_11_12_15_1FW3", HMK_RUMPF_9_11_12_15_1FW3);

    // HMK_RUMPF_16_1FW3
    var HMK_RUMPF_16_1FW3 = strBaseMLFB.substring(4, 8) + oResult.oParsingData.MLFB.MLFB10 + "_" + oResult.oParsingData.MLFB.MLFB16;
    oResult.oParsingData.MLFB.RUMPF_16 = HMK_RUMPF_16_1FW3;
    ECL_SetValue("HMK_RUMPF_16_1FW3", HMK_RUMPF_16_1FW3);


    ECL_SelectValue("MLFB09_1FW3", oResult.oParsingData.MLFB.MLFB09);
    ECL_SelectValue("MLFB11_1FW3", oResult.oParsingData.MLFB.MLFB11);
    ECL_SelectValue("MLFB12_1FW3", oResult.oParsingData.MLFB.MLFB12);
    ECL_SelectValue("MLFB13_1FW3", oResult.oParsingData.MLFB.MLFB13);
    ECL_SelectValue("MLFB14_1FW3", oResult.oParsingData.MLFB.MLFB14);
    ECL_SelectValue("MLFB15_1FW3", oResult.oParsingData.MLFB.MLFB15);
    ECL_SelectValue("MLFB16_1FW3", oResult.oParsingData.MLFB.MLFB16);


    // Kurzangaben
    if (aTokens.length > 0) {
        if (aTokens[0] === strBaseMLFB) {
            aTokens = removeElementsFromArray(aTokens, 0, 1);
        }
        oResult.oParsingData.MLFB.KAG = aTokens;

        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }

    return oResult;
}


/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1) {
            kagString += ";";
        }
    }
    return kagString;
}



function SetFreetextValue(field, value) {

    value = trimleft(value, '*');
    value = trimright(value, '*');

    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

    /*	zur Info - oParse: 
        {
            strBaseMLFB : '',
            strFullMLFB
            strError : '',
            strWarning : '',
            aTokens : [],
            oFreetext : {}
        };
    */

    // HMK_Y84_1FW3	+ HMK_Y84_TEXT_1FW3
    if (find(oParse.strFullMLFB, 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('HMK_Y84_TEXT_1FW3', oParse.oFreetext['Y84']);
    }

}

function isKAGinMLFB(aArray, sKAG) {
    for (var i = 0; i < aArray.length; i++) {
        if (aArray[i] == sKAG)
            return true;
    }

    return false;
}

// ###############################################################################################################
function getGeberParserDefault(strMLFB) {
    sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sSQL = "SELECT MLFB09_1FW3 FROM " + sTable + " WHERE " +
        "MLFB09_1FW3 = 'W' AND " +
        "MLFB15_1FW3 = '" + strMLFB.charAt(14) + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return "W";
    } else {
        var sSQL = "SELECT MLFB09_1FW3 FROM " + sTable + " WHERE " +
            //"MLFB09_1FW3 = 'W' AND " +
            "MLFB15_1FW3 = '" + strMLFB.charAt(14) + "' AND " +
            "HMK_VALUE_VALID_1FW3 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            return aResult[0].MLFB09_1FW3;
        }
    }
}
// ###############################################################################################################
// Prüfroutinen für KEEP CONFIGURATION
// ###############################################################################################################
function checkMLFB15_Parser(sMLFB, sMLFB15) {
    // -----------------------------------------------------------------------------------
    // zunächst mit VT_1FW3_M00249 die gültigen MLFB15 ermitteln
    //	H_RUMPF_050710_0811_1FW3	MLFB15_1FW3		HMK_VALUE_VALID_1FW3
    var sTargetAttribute = "MLFB15_1FW3";

    var HMK_MLFB05_06_1FW3 = sMLFB.charAt(4) + sMLFB.charAt(5);
    var MLFB08_1FW3 = sMLFB.charAt(7);

    sTable = "VT_1FW3_M00083" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW3 = '" + HMK_MLFB05_06_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB15 + "'AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################

function checkMLFB16_Parser(sMLFB, sMLFB16) {
    // -----------------------------------------------------------------------------------
    // VT_1FW3_M00136	Mapping Rumpf 567810_16
    //		HMK_RUMPF_1FW3	MLFB16_1FW3	HMK_RUMPF_16_1FW3	HMK_VALUE_VALID_1FW3
    var sTargetAttribute = "MLFB16_1FW3";

    var HMK_RUMPF_1FW3 = sMLFB.substring(0, 8) + "X" + sMLFB.charAt(9);

    sTable = "VT_1FW3_M00136" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB16 + "'AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    //	VT_1FW3_M00179	MLFB-Logik Lagerung
    //		HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    var HMK_RUMPF_16_1FW3 = sMLFB.substring(4, 8) + sMLFB.charAt(9) + "_" + sMLFB16;
    var HMK_RUMPF_9_11_12_15_1FW3 = sMLFB.charAt(8) + "_" + sMLFB.charAt(10) + "_" + sMLFB.charAt(11) + "_" + sMLFB.charAt(14);

    sTable = "VT_1FW3_M00179" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    //	VT_1FW3_M00180	MLFB Logik Geber I + Opt T20
    //		HMK_RUMPF_16_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_KEY_GEBER_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_WELLENABDECKUNG_1FW3	HMK_CAD_REITER_1FW3	HMK_VALUE_VALID_1FW3
    sTable = "VT_1FW3_M00180" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_RUMPF_16_1FW3 = '" + HMK_RUMPF_16_1FW3 + "' AND " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "HMK_KEY_GEBER_1FW3 = 'OHNE' AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################


// ################################################################################################
function checkMLFB13_Parser(sMLFB, sMLFB13) {
    // VT_1FW3_M00175	Verriegelung MLFB13 L03
    //	HMK_RUMPF_9_11_12_15_1FW3	MLFB13_1FW3	HMK_L03_1FW3	HMK_PROD_AKT_ALT_1FW3	HMK_VALUE_VALID_1FW3

    var HMK_RUMPF_9_11_12_15_1FW3 = sMLFB.charAt(8) + "_" + sMLFB.charAt(10) + "_" + sMLFB.charAt(11) + "_" + sMLFB.charAt(14);

    var sTable = "VT_1FW3_M00175" + sDB_Suffix;
    var sSQL = "SELECT MLFB13_1FW3 FROM " + sTable + " WHERE " +
        "HMK_RUMPF_9_11_12_15_1FW3 = '" + HMK_RUMPF_9_11_12_15_1FW3 + "' AND " +
        "MLFB13_1FW3 = '" + sMLFB13 + "'AND " +
        "HMK_PROD_AKT_ALT_1FW3 = 'AKT' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // ----------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################
function checkMLFB12_Parser(sMLFB_BT, sMLFB12) {

    // -----------------------------------------------------------------------------------
    // zunächst die gültigen MLFB12 ermitteln
    // 	VT_1FW3_M00119	Mapping Rumpf 9_11_12_15
    //		MLFB09_1FW3	MLFB11_1FW3	MLFB12_1FW3	MLFB15_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    var sTargetAttribute = "MLFB12_1FW3";

    //var MLFB09_1FW3 = sMLFB_BT.charAt(8);
    //var MLFB11_1FW3 = sMLFB_BT.charAt(10);
    //var MLFB15_1FW3 = sMLFB_BT.charAt(10);

    var sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        //"MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
        //"MLFB11_1FW3 = '" + MLFB11_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB12 + "'AND " +
        //"MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    // VT 125 
    //		HMK_RUMPF_1FW3	HMK_RUMPF_9_11_12_15_1FW3	HMK_VALUE_VALID_1FW3
    //var HMK_RUMPF_9_11_12_15_1FW3 = MLFB09_1FW3 + "_" + MLFB11_1FW3 + "_" + sMLFB12 + "_";
    var HMK_RUMPF_1FW3 = sMLFB_BT.substring(0, 8) + "X" + sMLFB_BT.charAt(9);

    var sTable = "VT_1FW3_M00125" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_RUMPF_1FW3 = '" + HMK_RUMPF_1FW3 + "' AND " +
        //"HMK_RUMPF_9_11_12_15_1FW3 LIKE '" + HMK_RUMPF_9_11_12_15_1FW3 + "%' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    return 1;
}

// ################################################################################################
function checkMLFB11_Parser(sMLFB_BT, sMLFB11/*, strMLFB*/) {
    // zunächst die gültigen MLFB11 ermitteln
    // VT_1FW3_M00257
    //	MLFB05_1FW3		MLFB11_1FW3		MLFB09_1FW3		HMK_VALUE_VALID_1FW3
    var sTargetAttribute = "MLFB11_1FW3";

    var MLFB05_1FW3 = sMLFB_BT.charAt(4) + sMLFB_BT.charAt(5);
    //var MLFB09_1FW3 = sMLFB_BT.charAt(8);
    /*var bMLFB09_undefined = false;
    if (MLFB09_1FW3 == "."){
        bMLFB09_undefined = true;
        MLFB09_1FW3 = stsMLFB.charAt(8);
    }*/
    var sTable = "VT_1FW3_M00257" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        //"MLFB09_1FW3 = '" + MLFB09_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB11 + "'AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        /*if (bMLFB09_undefined){
            // ohne Geber prüfen:
            sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_1FW3 = '" + MLFB05_1FW3 + "' AND " +
                sTargetAttribute + " = '" + sMLFB11 + "'AND " +
                "HMK_VALUE_VALID_1FW3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length < 1){
                return 0;
            }
        }else{
        */
        return 0;
        //}
    }

    // -----------------------------------------------------------------------------------
    // VT_1FW3_M00258
    //	MLFB05_1FW3		MLFB11_1FW3		MLFB12_1FW3		MLFB15_1FW3		HMK_VALUE_VALID_1FW3
    /*var MLFB12_1FW3 = sMLFB_BT.charAt(11);
    var bMLFB12_undefined = false;
    if (MLFB12_1FW3 == "."){
        bMLFB12_undefined = true;
        MLFB12_1FW3 = stsMLFB.charAt(11);
    }
    
    var MLFB15_1FW3 = sMLFB_BT.charAt(14);
    var bMLFB15_undefined = false;
    if (MLFB15_1FW3 == "."){
        bMLFB15_undefined = true;
        MLFB15_1FW3 = stsMLFB.charAt(14);
    }
    */
    var sTable = "VT_1FW3_M00258" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB11 + "'AND " +
        //"MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND " +
        //"MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        /*if (bMLFB12_undefined){
            var sWhereMLFB12 = "";
        }else{
            var sWhereMLFB12 = "MLFB12_1FW3 = '" + MLFB12_1FW3 + "' AND ";
        }
        if (bMLFB15_undefined){
            var sWhereMLFB15 = "";
        }else{
            var sWhereMLFB15 = "MLFB15_1FW3 = '" + MLFB15_1FW3 + "' AND ";
        }
        
        if (bMLFB12_undefined || bMLFB15_undefined){
            sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                    "MLFB05_1FW3 = '" + MLFB05_1FW3 + "' AND " +
                    sTargetAttribute + " = '" + sMLFB11 + "'AND " +
                    sWhereMLFB12 +
                    sWhereMLFB15 +
                    "HMK_VALUE_VALID_1FW3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length < 1){
                return 0;
            }
        }else{
        */
        return 0;
        //}
    }
    // -----------------------------------------------------------------------------------
    // VT_1FW3_M00372 Rümpfe
    // MLFB05_1FW3	MLFB07_1FW3	MLFB10_1FW3	MLFB08_1FW3	MLFB11_1FW3	HMK_RUMPF_05_07_1FW3	HMK_RUMPF_05_07_10_1FW3	H_RUMPF_050710_0811_1FW3	HMK_RUMPF_05_08_11_1FW3	HMK_VALUE_VALID_1FW3
    var MLFB07_1FW3 = sMLFB_BT.charAt(6);
    var MLFB08_1FW3 = sMLFB_BT.charAt(7);
    var MLFB10_1FW3 = sMLFB_BT.charAt(9);

    var sTable = "VT_1FW3_M00372" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1FW3 = '" + MLFB05_1FW3 + "' AND " +
        "MLFB07_1FW3 = '" + MLFB07_1FW3 + "' AND " +
        "MLFB08_1FW3 = '" + MLFB08_1FW3 + "' AND " +
        "MLFB10_1FW3 = '" + MLFB10_1FW3 + "' AND " +
        sTargetAttribute + " = '" + sMLFB11 + "'AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // -----------------------------------------------------------------------------------
    return 1;
}


// ################################################################################################
function checkMLFB09_Parser(sMLFB_BT, sMLFB09) {
    //var sTargetAttribute = "MLFB09_1FW3";

    sTable = "VT_1FW3_M00119" + sDB_Suffix;
    var sSQL = "SELECT MLFB09_1FW3 FROM " + sTable + " WHERE " +
        "MLFB09_1FW3 = '" + sMLFB09 + "' AND " +
        "MLFB15_1FW3 = '" + sMLFB_BT.charAt(14) + "' AND " +
        "HMK_VALUE_VALID_1FW3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }

    //--------------------------------------------------------------------------------------------------------------
    return 1;
}