//@legacy
//#mode(full-ecma)



//@import "VT_1FW6.js"


/*


MLFB-Schema
    
    
    
Motordaten:
    HMK_MOTORTYP_1FW6			Motortyp	(Innen-, Außenläufer)
    PMD_ABU210_001_000_1FW6		Ausführung	(std, High speed)
    PMD_AAC310_001_000_1FW6		Außendurchmesser des Gehäuses
    O_S80_FLANSCH_INNEN_1FW6	Flansch-Innendurchmesser
    PMD_AAD612_001_000_1FW6		Aktive Länge
    
    PMD_ABW068_001_000_1FW6		Betriebsstrom / des Motor Modules / Bemessungswert
    PMD_ABW069_001_000_1FW6		Betriebsstrom / des Motor Modules / maximal
    
    PMD_AAA136_001_000_1FW6		Art der Kühlung

    
Anschlusstechnik:
    PMD_AAA492_001_000_1FW6		Ausführung der Kabeleinführung
    PMD_AAA581_001_000_1FW6		Ausführung des elektrischen Anschlusses

Lieferumfang:
    PMD_ABW070_001_000_1FW6		Lieferzustand / des Motors
    
Temperatursensor	
    PMD_ABU365_001_000_1FW6		Ausführung des Sensors / zur Erfassung der Umgebungstemperatur / integriert

Einbauorientierung Läufer / Darstellung				( nur INFO, vorgegeben durch Motortyp und Ausführung)
    HMK_EINBAUORIENTIER_1FW6	Einbauorientierung Läufer / Darstellung

*/

function SetMotor_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Motordaten(oData);			// 

        Bestimme_Lieferumfang(oData);		// 

        Bestimme_Anschlusstechnik(oData);	// 

        // Bestimme_TempSensor(oData);	// immer 00003 fix

    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("HMK_MOTORTYP_1FW6", "00001");			// HMK_MOTORTYP_1FW6			Motortyp	(Innen-, Außenläufer)
        ExecSetStandardifValueEmpty("PMD_ABU210_001_000_1FW6", "00001");		// PMD_ABU210_001_000_1FW6		Ausführung	(std, High speed)
        ExecSetStandardifValueEmpty("PMD_AAC310_001_000_1FW6", "230");		// PMD_AAC310_001_000_1FW6		Außendurchmesser des Gehäuses
        ExecSetStandardifValueEmpty("O_S80_FLANSCH_INNEN_1FW6", "00001");	// O_S80_FLANSCH_INNEN_1FW6		Flansch-Innendurchmesser
        ExecSetStandardifValueEmpty("PMD_AAD612_001_000_1FW6", "30");		// PMD_AAD612_001_000_1FW6		Aktive Länge

        ExecSetStandardifValueEmpty("PMD_ABW068_001_000_1FW6", "5");			// PMD_ABW068_001_000_1FW6		Betriebsstrom / des Motor Modules / Bemessungswert
        ExecSetStandardifValueEmpty("PMD_ABW069_001_000_1FW6", "10");		// PMD_ABW069_001_000_1FW6		Betriebsstrom / des Motor Modules / maximal

        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FW6", "Z0004");		// PMD_AAA136_001_000_1FW6		Art der Kühlung

        //Anschlusstechnik:
        ExecSetStandardifValueEmpty("PMD_AAA492_001_000_1FW6", "00038");		// PMD_AAA492_001_000_1FW6		Ausführung der Kabeleinführung
        ExecSetStandardifValueEmpty("PMD_AAA581_001_000_1FW6", "00001");		// PMD_AAA581_001_000_1FW6		Ausführung des elektrischen Anschlusses

        //Lieferumfang:
        ExecSetStandardifValueEmpty("PMD_ABW070_001_000_1FW6", "00001");		// PMD_ABW070_001_000_1FW6		Lieferzustand / des Motors

        //Temperatursensor	
        ExecSetStandardifValueEmpty("PMD_ABU365_001_000_1FW6", "00003");		// PMD_ABU365_001_000_1FW6		Ausführung des Sensors / zur Erfassung der Umgebungstemperatur / integriert

        // Einbauorientierung Läufer / Darstellung
        ExecSetStandardifValueEmpty("HMK_EINBAUORIENTIER_1FW6", "00001");	// HMK_EINBAUORIENTIER_1FW6		Einbauorientierung Läufer / Darstellung
    }
}

function SetMotor(strchangedAttribute, oData) {
}
// #########################################################################################################################
/**
Motordaten:
    HMK_MOTORTYP_1FW6			Motortyp	(Innen-, Außenläufer)						MLFB05
    PMD_ABU210_001_000_1FW6		Ausführung	(std, High speed)							MLFB10
    PMD_AAC310_001_000_1FW6		Außendurchmesser des Gehäuses							MLFB05+06
    O_S80_FLANSCH_INNEN_1FW6	Flansch-Innendurchmesser								KAG S80 / nur bei MLFB05 == '7' möglich 
    PMD_AAD612_001_000_1FW6		Aktive Länge											MLFB11+12 + VT53 (RUMPF)
    
    PMD_ABW068_001_000_1FW6		Betriebsstrom / des Motor Modules / Bemessungswert		VT52
    PMD_ABW069_001_000_1FW6		Betriebsstrom / des Motor Modules / maximal				VT52
    
    PMD_AAA136_001_000_1FW6		Art der Kühlung											MLFB07 + Kontext
    
    HMK_EINBAUORIENTIER_1FW6	Einbauorientierung Läufer / Darstellung
*/
// #########################################################################################################################
function Bestimme_Motordaten(oData) {

    var oParsingData = oData.oParsingData;

    // -----------------------------------------------------------------------------------------------------------
    // MLFB05	HMK_MOTORTYP_1FW6			Motortyp	(Innen-, Außenläufer)
    // -----------------------------------------------------------------------------------------------------------
    var MLFB05_1FW6 = oParsingData.MLFB.POS05;

    var sTable = "VT_1FW6_M00062" + sDB_Suffix;
    var sSQL = "SELECT HMK_MOTORTYP_1FW6 FROM " + sTable + " WHERE " +
        "MLFB05_1FW6 = '" + MLFB05_1FW6 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var HMK_MOTORTYP_1FW6 = aResult[0].HMK_MOTORTYP_1FW6;
        ECL_DeactivateAllAttributeValues("HMK_MOTORTYP_1FW6");

        ECL_ActivateValue("HMK_MOTORTYP_1FW6", HMK_MOTORTYP_1FW6);
        ECL_SelectValue("HMK_MOTORTYP_1FW6", HMK_MOTORTYP_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_HMK_MOTORTYP");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // PMD_ABU210_001_000_1FW6		Ausführung	(std, High speed)							MLFB10
    // -----------------------------------------------------------------------------------------------------------
    var MLFB10_1FW6 = oParsingData.MLFB.POS10;

    /*
    PMD_ABU210_001_000_1FW6	MLFB10_1FW6	HMK_VALUE_VALID_1FW6
    00001	B	T    
    00002	C	T    
    */
    // VT_1FW6_M00027
    // PMD_ABU210_001_000_1FW6	MLFB10_1FW6	HMK_VALUE_VALID_1FW6

    var sTable = "VT_1FW6_M00027" + sDB_Suffix;
    var sSQL = "SELECT PMD_ABU210_001_000_1FW6 FROM " + sTable + " WHERE " +
        "MLFB10_1FW6 = '" + MLFB10_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ABU210_001_000_1FW6 = aResult[0].PMD_ABU210_001_000_1FW6;

        ECL_DeactivateAllAttributeValues("PMD_ABU210_001_000_1FW6");
        ECL_ActivateValue("PMD_ABU210_001_000_1FW6", PMD_ABU210_001_000_1FW6);
        ECL_SelectValue("PMD_ABU210_001_000_1FW6", PMD_ABU210_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_AUSF_MOTOR");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // PMD_AAC310_001_000_1FW6		Außendurchmesser des Gehäuses							MLFB05+06
    // -----------------------------------------------------------------------------------------------------------
    // VT_1FW6_M00023
    // 	HMK_MLFB05_06_1FW6	PMD_AAC310_001_000_1FW6	HMK_VALUE_VALID_1FW6
    //var MLFB05_1FW6 = oParsingData.MLFB.POS05;
    //var MLFB06_1FW6 = oParsingData.MLFB.POS06;
    var HMK_MLFB05_06_1FW6 = oParsingData.MLFB.POS05 + oParsingData.MLFB.POS06;

    var sTable = "VT_1FW6_M00023" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAC310_001_000_1FW6 FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW6 = '" + HMK_MLFB05_06_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAC310_001_000_1FW6 = aResult[0].PMD_AAC310_001_000_1FW6;

        ECL_DeactivateAllAttributeValues("PMD_AAC310_001_000_1FW6");
        ECL_ActivateValue("PMD_AAC310_001_000_1FW6", PMD_AAC310_001_000_1FW6);
        ECL_SelectValue("PMD_AAC310_001_000_1FW6", PMD_AAC310_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_AD");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // O_S80_FLANSCH_INNEN_1FW6	Flansch-Innendurchmesser								KAG S80 / nur bei MLFB05 == '7' möglich 
    // -----------------------------------------------------------------------------------------------------------
    //var MLFB05_1FW6 = oParsingData.MLFB.POS05;
    var sTargetAttribute = "O_S80_FLANSCH_INNEN_1FW6";

    if (MLFB05_1FW6 == "7") {
        // prüfen, ob S80 gesetzt, sonst "00002"
        var sKAG = "S80";
        var aKAG = oData.oParsingData.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);
        } else {
            ECL_ActivateValue(sTargetAttribute, "00002");
            ECL_SetValue(sTargetAttribute, "00002");
        }
    } else {
        // nur 00001 erlaubt
        ECL_ActivateValue(sTargetAttribute, "00001");
        ECL_SetValue(sTargetAttribute, "00001");

    }


    // -----------------------------------------------------------------------------------------------------------
    // PMD_AAD612_001_000_1FW6		Aktive Länge											MLFB11+12 + VT53 (RUMPF)
    // -----------------------------------------------------------------------------------------------------------
    // VT_1FW6_M00053
    //	PMD_AAD612_001_000_1FW6	HMK_MLFB_RUMPF_1FW6	HMK_VALUE_VALID_1FW6
    var HMK_MLFB_RUMPF_1FW6 = oParsingData.RUMPF;

    var sTable = "VT_1FW6_M00053" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAD612_001_000_1FW6 FROM " + sTable + " WHERE " +
        "HMK_MLFB_RUMPF_1FW6 = '" + HMK_MLFB_RUMPF_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAD612_001_000_1FW6 = aResult[0].PMD_AAD612_001_000_1FW6;

        ECL_DeactivateAllAttributeValues("PMD_AAD612_001_000_1FW6");
        ECL_ActivateValue("PMD_AAD612_001_000_1FW6", PMD_AAD612_001_000_1FW6);
        ECL_SelectValue("PMD_AAD612_001_000_1FW6", PMD_AAD612_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_AL");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // Leistungsdaten
    // -----------------------------------------------------------------------------------------------------------
    /*
    PMD_ABW068_001_000_1FW6		Betriebsstrom / des Motor Modules / Bemessungswert		VT52
    PMD_ABW069_001_000_1FW6		Betriebsstrom / des Motor Modules / maximal				VT52
    
    VT_1FW6_M00052
        PMD_ABW068_001_000_1FW6	PMD_ABW069_001_000_1FW6	HMK_MLFB_RUMPF_1FW6	HMK_VALUE_VALID_1FW6
    */
    //var HMK_MLFB_RUMPF_1FW6 = oParsingData.RUMPF;

    var sTable = "VT_1FW6_M00052" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_MLFB_RUMPF_1FW6 = '" + HMK_MLFB_RUMPF_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        ECL_DeactivateAllAttributeValues("PMD_ABW068_001_000_1FW6");
        ECL_DeactivateAllAttributeValues("PMD_ABW069_001_000_1FW6");

        // Betriebsstrom Bemessungswert
        var PMD_ABW068_001_000_1FW6 = aResult[0].PMD_ABW068_001_000_1FW6;
        // Betriebsstrom maximal
        var PMD_ABW069_001_000_1FW6 = aResult[0].PMD_ABW069_001_000_1FW6;

        ECL_ActivateValue("PMD_ABW068_001_000_1FW6", PMD_ABW068_001_000_1FW6);
        ECL_SetValue("PMD_ABW068_001_000_1FW6", PMD_ABW068_001_000_1FW6);

        ECL_ActivateValue("PMD_ABW069_001_000_1FW6", PMD_ABW069_001_000_1FW6);
        ECL_SetValue("PMD_ABW069_001_000_1FW6", PMD_ABW069_001_000_1FW6);

    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_LEISTUNG");
        return;
    }


    // -----------------------------------------------------------------------------------------------------------
    // PMD_AAA136_001_000_1FW6		Art der Kühlung											MLFB07 + Kontext
    // -----------------------------------------------------------------------------------------------------------
    /* VT_1FW6_M00044
        PMD_AAA136_001_000_1FW6	MLFB07_1FW6	HMK_VALUE_VALID_1FW6
    */
    var MLFB07_1FW6 = oParsingData.MLFB.POS07;

    var sTable = "VT_1FW6_M00044" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB07_1FW6 = '" + MLFB07_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA136_001_000_1FW6 = aResult[0].PMD_AAA136_001_000_1FW6;

        ECL_DeactivateAllAttributeValues("PMD_AAA136_001_000_1FW6");
        ECL_ActivateValue("PMD_AAA136_001_000_1FW6", PMD_AAA136_001_000_1FW6);
        ECL_SelectValue("PMD_AAA136_001_000_1FW6", PMD_AAA136_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_KUEHLART");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // HMK_EINBAUORIENTIER_1FW6		Einbauorientierung Läufer / Darstellung
    // -----------------------------------------------------------------------------------------------------------
    // 	VT_1FW6_M00065	CAD Einbauorientierung
    /* HMK_MOTORTYP_1FW6	PMD_ABU210_001_000_1FW6	HMK_EINBAUORIENTIER_1FW6	HMK_VALUE_VALID_1FW6
    */
    var sTable = "VT_1FW6_M00065" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_MOTORTYP_1FW6 = '" + HMK_MOTORTYP_1FW6 + "' AND " +
        "PMD_ABU210_001_000_1FW6 = '" + PMD_ABU210_001_000_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var HMK_EINBAUORIENTIER_1FW6 = aResult[0].HMK_EINBAUORIENTIER_1FW6;

        ECL_DeactivateAllAttributeValues("HMK_EINBAUORIENTIER_1FW6");
        ECL_ActivateValue("HMK_EINBAUORIENTIER_1FW6", HMK_EINBAUORIENTIER_1FW6);
        ECL_SelectValue("HMK_EINBAUORIENTIER_1FW6", HMK_EINBAUORIENTIER_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_CAD_EINBAUORIENTIERUNG");
        return;
    }


    // -----------------------------------------------------------------------------------------------------------
    // -----------------------------------------------------------------------------------------------------------
}
// #########################################################################################################################

// #########################################################################################################################
/**
Lieferumfang:
    PMD_ABW070_001_000_1FW6		Lieferzustand / des Motors			MLFB08
*/
// #########################################################################################################################
function Bestimme_Lieferumfang(oData) {

    /* VT_1FW6_M00025
        PMD_ABW070_001_000_1FW6	MLFB08_1FW6	HMK_VALUE_VALID_1FW6
    */
    var oMLFB = oData.oParsingData.MLFB;

    var MLFB08_1FW6 = oMLFB.POS08;

    switch (MLFB08_1FW6) {

        case "0":
            var PMD_ABW070_001_000_1FW6 = "00001";
            break;

        /* "2" is not longer valid, EDIT 08/2025
        case "2":
            var PMD_ABW070_001_000_1FW6 = "00003";
            break;
        */
        case "8":
            var PMD_ABW070_001_000_1FW6 = "00002";
            break;

        default:
            var PMD_ABW070_001_000_1FW6 = "00001";
    }

    ECL_SelectValue("PMD_ABW070_001_000_1FW6", PMD_ABW070_001_000_1FW6);

}
// #########################################################################################################################


// #########################################################################################################################
/**
Anschlusstechnik:
    PMD_AAA492_001_000_1FW6		Ausführung der Kabeleinführung				MLFB09	VT26+55
    PMD_AAA581_001_000_1FW6		Ausführung des elektrischen Anschlusses		MLFB15	
    
*/
// #########################################################################################################################
function Bestimme_Anschlusstechnik(oData) {
    // Ausführung der Kabeleinführung		PMD_AAA492_001_000_1FW6			MLFB09	VT26+55

    // VT_1FW6_M00026
    //	PMD_AAA136_001_000_1FW6	PMD_AAA492_001_000_1FW6	MLFB09_1FW6	HMK_VALUE_VALID_1FW6

    var MLFB09_1FW6 = oData.oParsingData.MLFB.POS09;
    var PMD_AAA136_001_000_1FW6 = ECL_GetValue("PMD_AAA136_001_000_1FW6");

    var sTable = "VT_1FW6_M00026" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAA492_001_000_1FW6 FROM " + sTable + " WHERE " +
        "MLFB09_1FW6 = '" + MLFB09_1FW6 + "' AND " +
        "PMD_AAA136_001_000_1FW6 = '" + PMD_AAA136_001_000_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA492_001_000_1FW6 = aResult[0].PMD_AAA492_001_000_1FW6;

        ECL_SelectValue("PMD_AAA492_001_000_1FW6", PMD_AAA492_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_ANSCHLUSSTECH");
        return;
    }


    // Ausführung des elektrischen Anschlusses		PMD_AAA581_001_000_1FW6		MLFB15	
    // VT_1FW6_M00032
    //	PMD_AAA581_001_000_1FW6	MLFB15_1FW6	HMK_VALUE_VALID_1FW6

    var MLFB15_1FW6 = oData.oParsingData.MLFB.POS15;

    var sTable = "VT_1FW6_M00032" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAA581_001_000_1FW6 FROM " + sTable + " WHERE " +
        "MLFB15_1FW6 = '" + MLFB15_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA581_001_000_1FW6 = aResult[0].PMD_AAA581_001_000_1FW6;

        ECL_SelectValue("PMD_AAA581_001_000_1FW6", PMD_AAA581_001_000_1FW6);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___NO_DB_RESULT_ANSCHLUSSTECH");
        return;
    }
}
// #########################################################################################################################

// #########################################################################################################################
/**
Temperatursensor	
    PMD_ABU365_001_000_1FW6		Ausführung des Sensors / zur Erfassung der Umgebungstemperatur / integriert
*/
// #########################################################################################################################
function Bestimme_TempSensor(oData) {
    var MLFB16_1FW6 = oData.oParsingData.MLFB.POS16;

    if (MLFB16_1FW6 == "3") {
        // nur 3 unterstützt
        ECL_SelectValue("PMD_ABU365_001_000_1FW6", "00003");
    } else { // Fehler
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FW6___TEMP_SENSOR_NOT_SUPPORTED");
        return;
    }
}
// #########################################################################################################################
