//@legacy
//#mode(full-ecma)



//@import "../1FW6_MLFB/Base.misc.js"

//@import "VT_1FW6.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");


    var MLFB01_1FW6 = sMLFB.substring(0, 4);
    var MLFB05_1FW6 = sMLFB.charAt(4);
    var MLFB06_1FW6 = sMLFB.charAt(5);
    var HMK_MLFB05_06_1FW6 = "" + MLFB05_1FW6 + MLFB06_1FW6;
    var MLFB07_1FW6 = sMLFB.charAt(6);
    var MLFB08_1FW6 = sMLFB.charAt(7);
    var MLFB09_1FW6 = sMLFB.charAt(8);
    var MLFB10_1FW6 = sMLFB.charAt(9);
    //var MLFB11_1FW6 = sMLFB.charAt(10);
    //var MLFB12_1FW6 = sMLFB.charAt(11);
    //var MLFB13_1FW6 = sMLFB.charAt(12);
    //var MLFB14_1FW6 = sMLFB.charAt(13);
    var MLFB15_1FW6 = sMLFB.charAt(14);
    var MLFB16_1FW6 = sMLFB.charAt(15);

    var HMK_MLFB_RUMPF_1FW6 = ECL_GetValue("HMK_MLFB_RUMPF_1FW6");


    /*
    MLFB08	. Auslieferzustand	{0,2,8}
    MLFB09 	. Leitungsabgang	{,K,L,N,P,Q,T,V,W,R}
    MLFB15	. Leitung			{A,B,C,D}
    MLFB16	. Tempsensor		{0,1,2,3}		fix '3' bzw "00003"
    */

    // ################################################################################################################
    // Auslieferzustand		PMD_ABW070_001_000_1FW6			MLFB08
    // ################################################################################################################
    /*	
    VT_1FW6_M00025
        PMD_ABW070_001_000_1FW6	MLFB08_1FW6	HMK_VALUE_VALID_1FW6
    
    MLFB08:
        VT_1FW6_M00025	Auslieferzustand<>MLFB08
    nn	VT_1FW6_M00060	Ausschluss MLFB Rumpf - CAD
        VT_1FW6_M00061	Auswahl Version Auslieferung

    VT_1FW6_M00061
        HMK_MLFB05_06_1FW6		MLFB07_1FW6		MLFB08_1FW6		MLFB10_1FW6		HMK_VALUE_VALID_1FW6
        
    */
    // zunächst gültige MLFB08 auswerten
    var sTable = "VT_1FW6_M00061" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB08_1FW6 FROM " + sTable + " WHERE " +
        "HMK_MLFB05_06_1FW6 = '" + HMK_MLFB05_06_1FW6 + "' AND " +
        "MLFB07_1FW6 = '" + MLFB07_1FW6 + "' AND " +
        "MLFB10_1FW6 = '" + MLFB10_1FW6 + "' AND " +
        "MLFB08_1FW6 <> '2' AND " + // EDIT 08/2025 '2' is not longer valid
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        // Where-Klausel für Übertragung
        var aWhere = "(MLFB08_1FW6 = '" + aResult[0].MLFB08_1FW6 + "' ";
        for (var i = 1; i < aResult.length; i++) {
            aWhere = aWhere + "OR MLFB08_1FW6 = '" + aResult[i].MLFB08_1FW6 + "' ";
        }
        aWhere = aWhere + ") ";

        // Übertragung des Ergebnisses in PMD_ABW070_001_000_1FW6
        var sTable = "VT_1FW6_M00025" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT PMD_ABW070_001_000_1FW6 FROM " + sTable + " WHERE " +
            aWhere + "AND " +
            "HMK_VALUE_VALID_1FW6 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            ECL_DeactivateAllAttributeValues("PMD_ABW070_001_000_1FW6");

            for (var i = 0; i < aResult.length; i++) {
                var PMD_ABW070_001_000_1FW6 = aResult[i].PMD_ABW070_001_000_1FW6;
                ECL_ActivateValue("PMD_ABW070_001_000_1FW6", PMD_ABW070_001_000_1FW6);
            }
        } else {
            strError = "DICT1_ERR_1FW6___PL_LIEFERZUSTAND_NO_DB_RESULT";
            return strError;
        }
    } else {
        strError = "DICT1_ERR_1FW6___PL_LIEFERZUSTAND_NO_DB_RESULT";
        return strError;
    }
    // bewerten
    ExecSetStandardifValueEmpty("PMD_ABW070_001_000_1FW6", "00001");	// todo 00002 nur noch getrennt! (nur bei HighSpeed? noch offen!

    // ################################################################################################################
    // setze MLFB08
    // ################################################################################################################
    /* VT_1FW6_M00025
        PMD_ABW070_001_000_1FW6	MLFB08_1FW6	HMK_VALUE_VALID_1FW6
    PMD_ABW070_001_000_1FW6	MLFB08_1FW6	HMK_VALUE_VALID_1FW6
    00001					0	T    
    00002					8	T    
    //00003					2	T    // EDIT 08/2025 '2' is not longer valid

    */
    var PMD_ABW070_001_000_1FW6 = ECL_GetValue("PMD_ABW070_001_000_1FW6");

    var sTable = "VT_1FW6_M00025" + sDB_Suffix;
    var sSQL = "SELECT MLFB08_1FW6 FROM " + sTable + " WHERE " +
        "PMD_ABW070_001_000_1FW6 = '" + PMD_ABW070_001_000_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        MLFB08_1FW6 = aResult[0].MLFB08_1FW6;

        sMLFB = replaceAt(sMLFB, 7, MLFB08_1FW6)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FW6___PL_MLFB08_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // Ausführung der Temperaturüberwachung			PMD_AAA717_001_000_1FW6			MLFB13
    // ################################################################################################################
    /*
    fix
    */



    // ################################################################################################################
    // MLFB09 	. Leitungsabgang	{,K,L,N,P,Q,T,V,W,R}		PMD_AAA492_001_000_1FW6
    // ################################################################################################################
    /*
    VT_1FW6_M00026	Leitungsabgang<>MLFB09
        PMD_AAA136_001_000_1FW6		PMD_AAA492_001_000_1FW6		MLFB09_1FW6		HMK_VALUE_VALID_1FW6
    
    VT_1FW6_M00055	Auswahl Leitungsabgang
        HMK_MLFB_RUMPF_1FW6		MLFB09_1FW6		HMK_VALUE_VALID_1FW6
    
    */
    // Zunächst MLFB09 einschränken
    var sTargetMLFB = "MLFB09_1FW6";
    var sTargetAttribute = "PMD_AAA492_001_000_1FW6";

    /* 	VT_1FW6_M00055	Auswahl Leitungsabgang
            HMK_MLFB_RUMPF_1FW6		MLFB09_1FW6		HMK_VALUE_VALID_1FW6
    */
    var sTable = "VT_1FW6_M00055" + sDB_Suffix;
    var sWhere = "HMK_MLFB_RUMPF_1FW6 = '" + HMK_MLFB_RUMPF_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_LEITUNGSABGANG_MLFB09_NO_DB_RESULT";
        return strError;
    }

    // ------------------------------------------------------------------
    /*	VT_1FW6_M00026	Leitungsabgang<>MLFB09
            PMD_AAA136_001_000_1FW6		PMD_AAA492_001_000_1FW6		MLFB09_1FW6		HMK_VALUE_VALID_1FW6
    */
    var PMD_AAA136_001_000_1FW6 = ECL_GetValue("PMD_AAA136_001_000_1FW6");

    var sTable = "VT_1FW6_M00026" + sDB_Suffix;
    var sWhere = "PMD_AAA136_001_000_1FW6 = '" + PMD_AAA136_001_000_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_LEITUNGSABGANG_MLFB09_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkung von MLFB09 übertragen auf PMD_AAA492_001_000_1FW6
    // ----------------------------------------------------------------------------------------------------------------
    //var sTable = "VT_1FW6_M00026" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_LEITUNGSABGANG_MLFB09_NO_DB_RESULT";
        return strError;
    }

    ExecSetStandardifValueEmpty("PMD_AAA492_001_000_1FW6", "00001");

    // ----------------------------------------------------------------------------------------------------------------
    // MLFB09 aktualisieren
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_AAA492_001_000_1FW6 = ECL_GetValue("PMD_AAA492_001_000_1FW6");

    // gültige MLFB09 für Where-Klausel
    var aValidMLFB09 = ECL_GetAllActiveAttributeValues("MLFB09_1FW6");

    var sWhereMLFB09 = "(MLFB09_1FW6 = '" + aValidMLFB09[0] + "' ";
    for (var i = 1; i < aValidMLFB09.length; i++) {
        sWhereMLFB09 = sWhereMLFB09 + "OR MLFB09_1FW6 = '" + aValidMLFB09[i] + "' ";
    }
    sWhereMLFB09 = sWhereMLFB09 + ") AND ";

    //var sTable = "VT_1FW6_M00026" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_AAA492_001_000_1FW6 = '" + PMD_AAA492_001_000_1FW6 + "' AND " +
        "PMD_AAA136_001_000_1FW6 = '" + PMD_AAA136_001_000_1FW6 + "' AND " +
        sWhereMLFB09 + // Einschränkung aus VT55
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        MLFB09_1FW6 = aResult[0].MLFB09_1FW6;

        sMLFB = replaceAt(sMLFB, 8, MLFB09_1FW6)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FW6___PL_MLFB09_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // MLFB15	. Leitung			{A,B,C,D}		PMD_AAA581_001_000_1FW6
    // ################################################################################################################
    /*
    VT_1FW6_M00032	Leitung <> MLFB15
        PMD_AAA581_001_000_1FW6		MLFB15_1FW6		HMK_VALUE_VALID_1FW6
    
    VT_1FW6_M00056	Auswahl Leitung
        HMK_MLFB_RUMPF_1FW6		MLFB15_1FW6		HMK_VALUE_VALID_1FW6
    
    */
    // ----------------------------------------------------------------------------------------------------------------
    // Zunächst MLFB15 einschränken
    // ----------------------------------------------------------------------------------------------------------------
    var sTargetMLFB = "MLFB15_1FW6";
    var sTargetAttribute = "PMD_AAA581_001_000_1FW6";

    /* 	VT_1FW6_M00056	Auswahl Leitung
            HMK_MLFB_RUMPF_1FW6		MLFB15_1FW6		HMK_VALUE_VALID_1FW6
    */
    var sTable = "VT_1FW6_M00056" + sDB_Suffix;
    var sWhere = "HMK_MLFB_RUMPF_1FW6 = '" + HMK_MLFB_RUMPF_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetMLFB, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_LEITUNG_MLFB15_NO_DB_RESULT";
        return strError;
    }


    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkung von MLFB15 übertragen auf PMD_AAA492_001_000_1FW6
    // ----------------------------------------------------------------------------------------------------------------
    /*	VT_1FW6_M00032	Leitung <> MLFB15
            PMD_AAA581_001_000_1FW6		MLFB15_1FW6		HMK_VALUE_VALID_1FW6
    */

    var sTable = "VT_1FW6_M00032" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sTargetMLFB, sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_LEITUNG_MLFB15_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("PMD_AAA581_001_000_1FW6", "00038");

    // ----------------------------------------------------------------------------------------------------------------
    // MLFB15 aktualisieren
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_AAA581_001_000_1FW6 = ECL_GetValue("PMD_AAA581_001_000_1FW6");

    //var sTable = "VT_1FW6_M00032" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB15_1FW6 FROM " + sTable + " WHERE " +
        "PMD_AAA581_001_000_1FW6 = '" + PMD_AAA581_001_000_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        MLFB15_1FW6 = aResult[0].MLFB15_1FW6;

        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FW6)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FW6___PL_MLFB15_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // O_S80_FLANSCH_INNEN_1FW6	Flansch-Innendurchmesser
    // ################################################################################################################
    /*
    VT_1FW6_M00063	MLFB05 - ZO S80 Flanschinnendurchmesser
        MLFB05_1FW6	O_S80_FLANSCH_INNEN_1FW6	HMK_VALUE_VALID_1FW6
        
    */
    var sTargetAttribute = "O_S80_FLANSCH_INNEN_1FW6";

    var sTable = "VT_1FW6_M00063" + sDB_Suffix;
    var sWhere = "MLFB05_1FW6 = '" + MLFB05_1FW6 + "' AND " +
        "HMK_VALUE_VALID_1FW6 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FW6___PL_S80_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    // ################################################################################################################
    return "OK";

}
