//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1FW6_MLFB/Base.misc.js"

//@import "../1FW6_CONFIG/VT_1FW6.js"

/**
 * @category   1FW6 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
  vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

  if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
    strStartConfiguration = "1";

  //if(strStartConfiguration=="1")
  //{
  //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
  //Hier sollen dann möglichst viele Attribute beibehalten werden.
  //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
  if (strBaseTypeMLFB != "") {
    //--------------------------------------------------------------------------------------------------------
    // Base Type  MLFB aufbereiten
    //--------------------------------------------------------------------------------------------------------
    var aBTComponents = tokenize(strBaseTypeMLFB);
    if (aBTComponents.length > 1) {
      // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
      // eliminate the resulting invalid short description 'Z'
      if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
        aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
      }
    }

    strBaseTypeMLFB = aBTComponents[0];

    if (strBaseTypeMLFB.length === 17) {
      // eliminate the -Z
      strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
    }

    var strBaseTypeMLFB_fix =
      strBaseTypeMLFB.substring(0, 8) + ".." + strBaseTypeMLFB.substring(9, 15); // todo
  }

  var oResult;

  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_1FW6___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  // Work around MLFB10
  // --------------------------------------------------------------------------------------------------------
  // MLFB10	. Ausführung
  // --------------------------------------------------------------------------------------------------------
  if (strBaseTypeMLFB.charAt(9) == ".") {
    var sMLFB10 = "B";
    // wenn MLFB07 == 2, High Speed ('C'), sonst Standard 'B'
    if (strBaseTypeMLFB.charAt(6) == "2") {
      sMLFB10 = "C";
    }
    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 9, sMLFB10);
  }

  // Work around MLFB10
  if (strMLFB.charAt(9) == ".") {
    var sMLFB10 = "B";
    // wenn MLFB07 == 2, High Speed ('C'), sonst Standard 'B'
    if (strMLFB.charAt(6) == "2") {
      sMLFB10 = "C";
    }
    strMLFB = replaceAt(strMLFB, 9, sMLFB10);
  }
  // Work around MLFB10

  var strMLFB_fix = strMLFB.substring(0, 8) + ".." + strMLFB.substring(9, 15); // todo

  // EDIT RepairConfig added
  if (
    strStartConfiguration == "1" &&
    strBaseTypeMLFB_fix == strMLFB_fix &&
    strBaseTypeMLFB != "" &&
    find(strMLFB.left(16), ".") < 0
  ) {
    // if same motor is selected again
    var bRepairConfig = true;
  }

  // -----------------------------------------------------------------------------------------------
  //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
  // -----------------------------------------------------------------------------------------------
  if (
    (strBaseTypeMLFB_fix != strMLFB_fix &&
      find(strMLFB.left(16), ".") < 0 &&
      strBaseTypeMLFB != "") ||
    bRepairConfig
  ) {
    // -----------------------------------------------------------------------------------------------
    // Platzhalter aus MLFB in BT übernehmen
    // -----------------------------------------------------------------------------------------------

    /* MLFB-Schema
                
                MLFB01	1FW6
                MLFB05	Außendurchmesser	{05,06,09,13,15,16,19,23,29}
                MLFB07	Ausführung 			{0,2,3}	(Kühlart)
                MLFB08	. Auslieferzustand	{0,2,8} // EDIT 08/2025 '2' is not longer valid
                MLFB09 	. Leitungsabgang		{,K,L,N,P,Q,T,V,W,R}
                MLFB10	Version				{A,B,C}
                MLFB11	Baulänge			{03,05,07,10,11,15,20}
                MLFB12	Baulänge
                MLFB13	Wicklung			{0F,...,0W}
                MLFB14	Wicklung
                MLFB15	. Leitung			{A,B,C,D}
                MLFB16	. Tempsensor		{0,1,2,3}
            */
    // 08,09,15,16 ein Wildcard, dann Wert aus alter MLFB setzen, ggf. Default setzen

    // --------------------------------------------------------------------------------------------------------
    // MLFB08	. Auslieferzustand
    // --------------------------------------------------------------------------------------------------------
    var sMLFB08 = strMLFB.charAt(7);
    var sBT_MLFB08 = strBaseTypeMLFB.charAt(7);

    if (sBT_MLFB08 == ".") {
      sMLFB08 = getMLFB08default_1FW6(strBaseTypeMLFB, sMLFB08);
      if (sMLFB08 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 7, sMLFB08);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FW6___PARSER_NO_DB_RESULT_MLFB08";
        return oParsing;
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB09 	. Leitungsabgang		Abhängig von Kühlart!!! VT26+55
    // --------------------------------------------------------------------------------------------------------
    var sMLFB09 = strMLFB.charAt(8);
    var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);

    if (sBT_MLFB09 == ".") {
      // Check Leitungsabgang
      var HMK_MLFB_RUMPF_1FW6 =
        strBaseTypeMLFB.charAt(4) +
        strBaseTypeMLFB.charAt(5) +
        "_" +
        strBaseTypeMLFB.charAt(6) +
        "_" +
        strBaseTypeMLFB.charAt(10) +
        strBaseTypeMLFB.charAt(11) +
        "_" +
        strBaseTypeMLFB.charAt(12) +
        strBaseTypeMLFB.charAt(13);

      // prüfen, ob es eine Lösung gibt, falls nein, Default bestimmen
      var sTable = "VT_1FW6_M00055" + sDB_Suffix;
      var sSQL =
        "SELECT * FROM " +
        sTable +
        " WHERE " +
        "HMK_MLFB_RUMPF_1FW6 = '" +
        HMK_MLFB_RUMPF_1FW6 +
        "' AND " +
        "MLFB09_1FW6 = '" +
        sMLFB09 +
        "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length == 0) {
        sMLFB09 = getMLFB09Default(strBaseTypeMLFB);
        if (sMLFB09 != "ERROR") {
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, sMLFB09);
        } else {
          oParsing.strError = "ERRORMSG_MLFB_1FW6___MLFB09_UNDEFINED";
          return oParsing;
        }
      } else {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, sMLFB09);
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB15	. Leitung
    // --------------------------------------------------------------------------------------------------------
    var sMLFB15 = strMLFB.charAt(14);
    var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

    if (sBT_MLFB15 == ".") {
      sMLFB15 = getMLFB15default_1FW6(strBaseTypeMLFB, sMLFB15);
      if (sMLFB15 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FW6___PARSER_NO_DB_RESULT_MLFB15";
        return oParsing;
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB16	. Tempsensor
    // --------------------------------------------------------------------------------------------------------
    var sMLFB16 = strMLFB.charAt(15);
    var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

    if (sBT_MLFB16 == ".") {
      sMLFB16 = "3"; // only "3" allowed
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
    }

    // -----------------------------------------------------------------------------------------------
    // Zuweisen der neuen MLFB und KAG-Liste
    strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

    oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
    oParsing.strFullMLFB = strMLFB;
    aComponents[0] = oParsing.strBaseMLFB;
    oParsing.aTokens = aComponents;
    ECL_SetValue("ECSI_MLFB", strMLFB);
  }
  // -- END EDIT KEEP CONF --
  // Wildcards definieren, wenn kein Keep Configuration
  else {
    if (find(strMLFB.left(16), ".") >= 0) {
      //Unvollständige SIZER MLFB
      /* MLFB-Schema
                
                MLFB01	1FW6
                MLFB05	Außendurchmesser	{05,06,09,13,15,16,19,23,29}
                MLFB07	Ausführung 			{0,2,3}
                MLFB08	. Auslieferzustand	{0,2,8} // EDIT 08/2025 '2' is not longer valid
                MLFB09 	. Leitungsabgang		{,K,L,N,P,Q,T,V,W,R}
                MLFB10	Version				{A,B,C}
                MLFB11	Baulänge			{03,05,07,10,11,15,20}
                MLFB12	Baulänge
                MLFB13	Wicklung			{0F,...,0W}
                MLFB14	Wicklung
                MLFB15	. Leitung			{A,B,C,D}
                MLFB16	. Tempsensor		{0,1,2,3}
                */
      // ##########################################################################################
      // Prüfen, ob '.' an Stelle 1 bis 7, 10 bis 14 -  dann Fehler
      // ##########################################################################################
      for (var i = 0; i < 7; i++) {
        if (strMLFB.charAt(i) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1FW6___INCOMPLETE_MLFB";
          return oParsing;
        }
      }
      for (var i = 9; i < 14; i++) {
        if (strMLFB.charAt(i) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1FW6___INCOMPLETE_MLFB";
          return oParsing;
        }
      }

      // ##########################################################################################
      // Wenn MLFB08,09 oder MLFB15,16 ein Wildcard, dann Default setzen
      // ##########################################################################################

      // --------------------------------------------------------------------------------------------------------
      // MLFB08	. Auslieferzustand
      // --------------------------------------------------------------------------------------------------------
      var sMLFB08 = strMLFB.charAt(7);

      if (sMLFB08 == ".") {
        sMLFB08 = "0";
        strMLFB = replaceAt(strMLFB, 7, sMLFB08);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB09 	. Leitungsabgang
      // --------------------------------------------------------------------------------------------------------
      var sMLFB09 = strMLFB.charAt(8);

      if (sMLFB09 == ".") {
        // Bestimmen aus VT55 (default axial (K,P,W))

        sMLFB09 = getMLFB09Default(strMLFB);
        if (sMLFB09 != "ERROR") {
          strMLFB = replaceAt(strMLFB, 8, sMLFB09);
        } else {
          oParsing.strError = "ERRORMSG_MLFB_1FW6___MLFB09_UNDEFINED";
          return oParsing;
        }
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB15	. Leitung
      // --------------------------------------------------------------------------------------------------------
      var sMLFB15 = strMLFB.charAt(14);

      if (sMLFB15 == ".") {
        sMLFB15 = "A";
        strMLFB = replaceAt(strMLFB, 14, sMLFB15);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB16	. Tempsensor			fix '3'
      // --------------------------------------------------------------------------------------------------------
      var sMLFB16 = strMLFB.charAt(15);

      if (strMLFB.charAt(15) == ".") {
        sMLFB16 = "3";
        strMLFB = replaceAt(strMLFB, 15, sMLFB16);
      }

      // --------------------------------------------------------------------------------------------------------

      ECL_SetValue("ECSI_MLFB", strMLFB);

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
      //oParsing.aTokens = aComponents;
    } else {
      // MLFB vollständig definiert, aber Kontexte berücksichtigen

      ECL_SetValue("ECSI_MLFB", strMLFB);

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
    }
  }
  //}
  // END IS-Start-Configuration

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_1FW6___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (oParsing.strBaseMLFB.indexOf("1FW6") < 0) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_1FW6___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var oResult;
  oResult = parse_1FW6(oParsing.aTokens);

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;
  }

  vtTimeStop = Date.getTime();
  vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_1FW6(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };
  /*
    MLFB-Schema
    
    MLFB01	1FW6
    MLFB05	Außendurchmesser	{05,06,09,13,15,16,19,23,29}
    MLFB07	Ausführung 			{0,2,3}
    MLFB08	. Auslieferzustand	{0,2,8}
    MLFB09 	. Leitungsabgang	{,K,L,N,P,Q,T,V,W,R}
    MLFB10	Version				{A,B,C}
    MLFB11	Baulänge			{03,05,07,10,11,15,20}
    MLFB12	Baulänge
    MLFB13	Wicklung			{0F,...,0W}
    MLFB14	Wicklung
    MLFB15	. Leitung			{A,B,C,D}
    MLFB16	. Tempsensor		{0,1,2,3}
    */
  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  oResult.oParsingData.MLFB.POS01 = strBaseMLFB.substring(0, 4); // 01 1FW6
  oResult.oParsingData.MLFB.POS05 = strBaseMLFB.charAt(4); // 05 Außendurchmesser	{05,06,09,13,15,16,19,23,29}
  oResult.oParsingData.MLFB.POS06 = strBaseMLFB.charAt(5); // 06 Außendurchmesser
  oResult.oParsingData.MLFB.POS07 = strBaseMLFB.charAt(6); // 07 Ausführung 			{0,2,3}
  oResult.oParsingData.MLFB.POS08 = strBaseMLFB.charAt(7); // 08 . Auslieferzustand	{0,2,8}
  oResult.oParsingData.MLFB.POS09 = strBaseMLFB.charAt(8); // 09 . Leitungsabgang		{,K,L,N,P,Q,T,V,W,R}
  oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9); // 10 Version				{A,B,C}
  oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt(10); // 11 Baulänge			{03,05,07,10,11,15,20}
  oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt(11); // 12 Baulänge
  oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt(12); // 13 Wicklung			{0F,...,0W}
  oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); // 14 Wicklung
  oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); // 15 . Leitung			{A,B,C,D}
  oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); // 16 . Tempsensor		{0,1,2,3}

  // HMK_MLFB_RUMPF_1FW6 = MLFB05+06_07_11+12_13+14
  oResult.oParsingData.RUMPF =
    oResult.oParsingData.MLFB.POS05 +
    oResult.oParsingData.MLFB.POS06 +
    "_" +
    oResult.oParsingData.MLFB.POS07 +
    "_" +
    strBaseMLFB.charAt(10) +
    strBaseMLFB.charAt(11) +
    "_" +
    strBaseMLFB.charAt(12) +
    strBaseMLFB.charAt(13);

  // Prüfen, ob Rumpf-MLFB in DB abgebildet:  VT51
  var sTable = "VT_1FW6_M00051" + sDB_Suffix; // todo

  var sSQL =
    "SELECT HMK_MLFB_RUMPF_1FW6 FROM " +
    sTable +
    " WHERE " +
    "HMK_MLFB_RUMPF_1FW6 = '" +
    oResult.oParsingData.RUMPF +
    "' AND " +
    "HMK_VALUE_VALID_1FW6 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    oResult.strError = "ERRORMSG_MLFB_1FW6___PARSE_WRONG_MLFB";
  }
  ECL_SetValue("HMK_MLFB_RUMPF_1FW6", oResult.oParsingData.RUMPF); // = HMK_MLFB_RUMPF_1FW6
  // ################################################################################################################

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens || [];

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
  /*/ O_Y84_1FK2	+ O_Y84_TXT_1FK2
    if (find(oParse.strFullMLFB , 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('O_Y84_TXT_1FK2', oParse.oFreetext['Y84']);
    }*/
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}

function getMLFB09Default(strMLFB) {
  // Bestimme aus VT26+55 gültige MLFB09 für den Default
  var HMK_MLFB_RUMPF_1FW6 =
    strMLFB.charAt(4) +
    strMLFB.charAt(5) +
    "_" +
    strMLFB.charAt(6) +
    "_" +
    strMLFB.charAt(10) +
    strMLFB.charAt(11) +
    "_" +
    strMLFB.charAt(12) +
    strMLFB.charAt(13);
  // VT55 reicht, da in Rumpf die MLFB07 (Kühlart) enthalten ist
  // HMK_MLFB_RUMPF_1FW6	MLFB09_1FW6	HMK_VALUE_VALID_1FW6

  var sTable = "VT_1FW6_M00055" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB09_1FW6 FROM " +
    sTable +
    " WHERE " +
    "HMK_MLFB_RUMPF_1FW6 = '" +
    HMK_MLFB_RUMPF_1FW6 +
    "' AND " +
    "HMK_VALUE_VALID_1FW6 = 'T' ORDER BY MLFB09_1FW6;";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    for (var i = 0; i < aResult.length; i++) {
      var MLFB09_1FW6 = aResult[i].MLFB09_1FW6;
      if (MLFB09_1FW6 == "K" || MLFB09_1FW6 == "P" || MLFB09_1FW6 == "W") {
        return MLFB09_1FW6;
      }
    }
    var MLFB09_1FW6 = aResult[0].MLFB09_1FW6;
    return MLFB09_1FW6;
  } else {
    return "ERROR";
  }
}

function getMLFB08default_1FW6(strBaseTypeMLFB, sMLFB08) {
  var HMK_MLFB05_06_1FW6 = strBaseTypeMLFB.substring(4, 6);
  var MLFB07_1FW6 = strBaseTypeMLFB.charAt(6);
  var MLFB10_1FW6 = strBaseTypeMLFB.charAt(9);

  var sTable = "VT_1FW6_M00061" + sDB_Suffix;
  var sSQL =
    "SELECT DISTINCT MLFB08_1FW6 FROM " +
    sTable +
    " WHERE HMK_MLFB05_06_1FW6 = '" +
    HMK_MLFB05_06_1FW6 +
    "' AND MLFB07_1FW6 = '" +
    MLFB07_1FW6 +
    "' AND MLFB08_1FW6 = '" +
    sMLFB08 +
    "' AND MLFB08_1FW6 <> '" +
    "2" +
    "' AND MLFB10_1FW6 = '" +
    MLFB10_1FW6 +
    "' AND HMK_VALUE_VALID_1FW6 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB08;
  } else {
    var sSQL =
      "SELECT DISTINCT MLFB08_1FW6 FROM " +
      sTable +
      " WHERE HMK_MLFB05_06_1FW6 = '" +
      HMK_MLFB05_06_1FW6 +
      "' AND MLFB07_1FW6 = '" +
      MLFB07_1FW6 +
      "' AND MLFB10_1FW6 = '" +
      MLFB10_1FW6 +
      "' AND MLFB08_1FW6 <> '" +
      "2" +
      "' AND HMK_VALUE_VALID_1FW6 = 'T' ORDER BY MLFB08_1FW6;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB08_1FW6 = aResult[0].MLFB08_1FW6;
      return MLFB08_1FW6;
    } else {
      return "ERROR";
    }
  }
}
function getMLFB15default_1FW6(strBaseTypeMLFB, sMLFB15) {
  /*VT_1FW6_M00056	Auswahl Leitung
    HMK_MLFB_RUMPF_1FW6		MLFB15_1FW6		HMK_VALUE_VALID_1FW6
    */
  var HMK_MLFB_RUMPF_1FW6 =
    strBaseTypeMLFB.charAt(4) +
    strBaseTypeMLFB.charAt(5) +
    "_" +
    strBaseTypeMLFB.charAt(6) +
    "_" +
    strBaseTypeMLFB.charAt(10) +
    strBaseTypeMLFB.charAt(11) +
    "_" +
    strBaseTypeMLFB.charAt(12) +
    strBaseTypeMLFB.charAt(13);
  var sTable = "VT_1FW6_M00056" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB15_1FW6 FROM " +
    sTable +
    " WHERE HMK_MLFB_RUMPF_1FW6 = '" +
    HMK_MLFB_RUMPF_1FW6 +
    "' AND MLFB15_1FW6 = '" +
    sMLFB15 +
    "' AND HMK_VALUE_VALID_1FW6 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB15;
  } else {
    var sSQL =
      "SELECT * FROM " +
      sTable +
      " WHERE HMK_MLFB_RUMPF_1FW6 = '" +
      HMK_MLFB_RUMPF_1FW6 +
      "' AND HMK_VALUE_VALID_1FW6 = 'T' ORDER BY MLFB15_1FW6;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB15_1FW6 = aResult[0].MLFB15_1FW6;
      return MLFB15_1FW6;
    } else {
      return "ERROR";
    }
  }
}
