//@legacy
//#mode(full-ecma)


//@import "VT_1PC13.js"


// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration
function determineConsequences() {
    /*var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    */
    var oConsequences = {
        MaxRotationSpeedLimit: getN_Max(),
        IpProtectionLevelMotor: getIpProtectionLevelMotor(),
        BrakeID: getBrakeID()
    }

    return oConsequences;
}

function getN_Max() {
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");

    var sMLFB_PATTERN = sECSI_MLFB.left(13) + "...";

    // DB-Tabelle:
    var sTable = "N_MAX";

    // SZ_MOD_n_MaxMech
    // SZ_MOD_Ordernumber_Ref
    // SZ_MOD_ShortOptions_Ref

    var sSQL = "SELECT SZ_MOD_n_MaxMech FROM " + sTable + " WHERE " +
        "SZ_MOD_Ordernumber_Ref = '" + sMLFB_PATTERN + "';";

    var aResult = Object.fromDatabase("1PC13_ADD_DATA", sSQL);

    if (aResult.length > 0) {
        var MaxRotationSpeedLimit = aResult[0].SZ_MOD_N_MAXMECH;
    } else {
        //Fehler
        return "ERROR: Kein Treffer für max. Drehzahl";
    }

    return MaxRotationSpeedLimit;
}


function getIpProtectionLevelMotor() {
    // O_SCHUTZART_1PC13  	Schutzart
    var IpProtectionLevelMotor = "";
    /*
    O_SCHUTZART_1PC13	Schutzart IP 	STD (IP55), H22 (IP56)
    */
    var O_SCHUTZART_1PC13 = ECL_GetValue("O_SCHUTZART_1PC13");

    switch (O_SCHUTZART_1PC13) {

        case "STD":
            IpProtectionLevelMotor = "55";
            break;

        case "H22":
            IpProtectionLevelMotor = "56";
            break;
    }
    return IpProtectionLevelMotor;
}

function getBrakeID() {
    /**
    
    //Bremsen Consequences
    */
    var sECSI_MLFB = ECL_GetValue("ECSI_MLFB");

    var sBrakeID = "";
    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13"); // F30...F37

    if (O_ANBAU_BREMSE_1PC13 != "NON") {

        var O_BREMSSPANNUNG_1PC13 = ECL_GetValue("O_BREMSSPANNUNG_1PC13");	// F11, F12, F16

        if (O_BREMSSPANNUNG_1PC13 == "NON") {
            return "ERROR: Bremsspannung nicht gültig";
        }

        var MLFB06_1LE1X = sECSI_MLFB.charAt(5);
        var sMLFB_Left9 = sECSI_MLFB.left(9);

        if (sMLFB_Left9 == "1PC13612C") { // KFB 160 not available for 1PC1341 in FS 250

            var sMLFB_PATTERN = "1PC13612C???????";

        } else {
            var sMLFB_PATTERN = sECSI_MLFB.left(5) + "{4;6}" + sECSI_MLFB.charAt(6) + sECSI_MLFB.charAt(7) + sECSI_MLFB.charAt(8) + "???????";

        }

        // DB-Tabelle:
        var sTable = "BrakeID";

        // SZ_MBC_M_OrderNumber
        // SZ_MBC_BrakeId
        // O_ANBAU_BREMSE_1PC13
        // O_BREMSSPANNUNG_1PC13

        var sSQL = "SELECT SZ_MBC_BRAKEID FROM " + sTable + " WHERE " +
            "SZ_MBC_M_OrderNumber = '" + sMLFB_PATTERN + "' AND " +
            "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
            "O_BREMSSPANNUNG_1PC13 = '" + O_BREMSSPANNUNG_1PC13 + "';";


        var aResult = Object.fromDatabase("1PC13_ADD_DATA", sSQL);

        if (aResult.length > 0) {
            var sBrakeID = aResult[0].SZ_MBC_BRAKEID;
        }
        else {
            //Fehler
            return "ERROR: Kein Treffer für BrakeID";
        }
    } else {
        sBrakeID = "";
    }

    return sBrakeID;
}
