//@legacy
//#mode(full-ecma)



//@import "VT_1PC13.js"


function isLetter(strValue)
{
    var objRegExp  = /^[a-zA-Z]$/;
    return objRegExp.test(strValue);
}
    
function isDigit(strValue)
{
    var objRegExp  = /^\d/;
    return objRegExp.test(strValue);
}

function formatFreetext(ka, ft)
{
    // Keine Freitexte erzeugen, wenn Text leer ist; dies führt nämlich zu größeren Problemen im Sizer
    if (!ft || (ft == ''))
        return '';
        
    // Filterung von Sonderzeichen im Freitext: {, }
    ft = replace(ft, '{', '');
    ft = replace(ft, '}', '');
        
    // var strRet = '{' + ka + ': *' + ft + '*}';
    var strRet = '{' + ka + ':' + ft + '}';
    return strRet;
}

// Siehe hierzu auch die korrespondierende Funktion zum Parsen von Freitextangaben und
// befüllen der Attribute
function getFreetextSD(attrValNetto)
{
    var strRet = '';
    
    // Farbanstrich
    if (attrValNetto == 'Y53') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('H_RAL_FARBE_1PC13'));
    }
    else if (attrValNetto == 'Y56') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('H_RAL_FARBE_1PC13'));
    }
    else if (attrValNetto == 'Y66') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('H_RAL_FARBE_1PC13'));
    }
    
    // (Y82) Zusatzschild mit Bestellangaben
    else if (attrValNetto == 'Y82') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('OE_ZUSATZSCHILD_TA_1PC13'));
    }
    
    // Y61, Y73: Kabeleinführungplatte
    else if (attrValNetto == 'Y61' || attrValNetto == 'Y73') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('OE_KABELEINFPLATTE_1PC13'));
    }
    
    else if (attrValNetto == 'Y74' || attrValNetto == 'Y76') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('OE_GEBER_DREHZAHL_1PC13'));
    }
    
    // Y75 Option für Wärmeklasse/KMT/AH	(Y50, Y52 nicht aktiv) 
    else if (attrValNetto == 'Y75') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('IN_AH_1PC13') + "M_" + ECL_GetValue('IN_KMT_1PC13') + "C");
    }
    
    // Y81 Fremdlüfter mit anormaler Spannung und/oder Frequenz		<== aktuell ausgeblendet
    /* else if (attrValNetto == 'Y81') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('OE_FREMDL_DATEN_1PC13'));
    }*/
    
    return strRet;
}

/**
    Funktion zur Generierung der Kurzangaben anhand der gewählten Merkmale
    Beispiel für einen Fall mit Klartextangaben aus dem Bereich 2KJ:  
    2KJ3203-1BC21-4AK1-Z D01 +K01 +K08 +L02 +M55 +N38 +P91 +W21 +Y00 +Y80 {Y00: *LSK@myident*}{Y80: *RAL@5000*}
*/
function GenKAG(sBaseTypeMLFB, sECSI_MLFB)
{
    var newBaseMLFB = left(sECSI_MLFB, 16); //left(sBaseTypeMLFB, 16);
    
    // In erster Näherung können wir in Datenbank "1PC13_ADD_DATA.db3" die "Tabelle1" durchlaufen und für alle Attribute
    // schauen, ob der gesetzte Wert eine Kurzangabe hergibt (3 Stellen, nicht STD oder NON, Format ANN). Die übernehmen wir dann.
    // Zusätzlich müssen wir ...
    // - Kurzangaben die sich aus mehreren Attributen ergeben bestimmen (spezielle Tabellen)
    // - Klartextangaben generieren
    var aKag   = [];
    var aKagFt = []; // Free Texts

    // Wir gehen alle Attribute durch und schauen mal ob ein Wert mit Kurzangabe selektiert ist.
    // Bei Kurzangaben, die einen Klartext erfordern, bestimmen wir diesen auch
    var aResult = Object.fromDatabase("1PC13_ADD_DATA", "SELECT DISTINCT Attribute FROM DATA WHERE KAG = 'x' AND IsCB <> 'x';"); 
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['ATTRIBUTE'];
        var attrVal = ECL_GetValue(attrname); 
        // Die Attributwerte enthalten wohl nicht den Attributnamen, wohl aber die Dict-Ids der Werte
        // Sicherheitshalber strippen wir hier aber auch
        var attrValNetto = replace(attrVal, attrname, '');
        attrValNetto = replace(attrValNetto, '___', '');
        
        // KAG_ANN
        if ((attrValNetto.length == 3) && (attrValNetto != 'STD') && (attrValNetto != 'NON') ) {	// != 'ALT', 'MOT'
            if (isLetter(attrValNetto.charAt(0)) && isDigit(attrValNetto.charAt(1)) && (isDigit(attrValNetto.charAt(2))/* || isLetter(attrValNetto.charAt(2))*/ ))
                aKag.push(attrValNetto);
                
            if (attrValNetto.charAt(0) == 'Y') {
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrValNetto);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    // Checkbox-Attribute
    var aResult = Object.fromDatabase("1PC13_ADD_DATA", "SELECT DISTINCT Attribute, Wert_ID FROM DATA WHERE IsCB = 'x' AND KAG = 'x'");
    
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['ATTRIBUTE'];
        var attrKAG = aResult[i]['WERT_ID'];
        var bKAG = ECL_ValueSelected(attrname, 'T');
        if (bKAG){
            aKag.push(attrKAG);
            
            // z.B. Y60
            if (attrKAG.charAt(0) == 'Y') {
                
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrKAG);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    var bANN_KA = false;
    if(aKag.length > 0 || aKagFt.length > 0)
        bANN_KA = true;
    
    var bANA_KA = false;
    // Wicklungsausführung für Sonderfall, wenn MLFB-Stelle 12 + 13 = 90: dann Spezifizierung durch Kurzangabe
    if (sECSI_MLFB.charAt(11) == '9' && sECSI_MLFB.charAt(12) == '0') {
        var sKAGWicklung = replace(ECL_GetValue("IN_WICKLUNG_1PC13"), "O_", "");
        aKag.push(sKAGWicklung);
        bANA_KA= true;
    }
    
    // Motorschutz Sonderfall, wenn MLFB-Stelle 15 = Z: dann Spezifizierung durch Kurzangabe
    if (sECSI_MLFB.charAt(14) == 'Z') {
        var sKAGMotorschutz = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");
        if (sKAGMotorschutz == "Q3A"){
            aKag.push(sKAGMotorschutz);
            bANA_KA= true;
        }else{
            // Fehler, es darf nicht Z sein!
            return "ERROR_MOTORSCHUTZ";
        }
    }
    
    // Ab hier beginnt der Zusammenbau des fertigen MLFB - Strings:
    
    aKag.sort();
    var kag = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKag.length; ++j) {
        kag += aKag[j] + '+';
    }
    kag = trimright(kag, '+');

    aKagFt.sort();
    var kagFT = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKagFt.length; ++j) {
        kagFT += aKagFt[j];
    }
    
    // Einfache Regel: Wenn Kurzangaben, dann "-Z" als Marker an der Grund-MLFB
    // Unterscheidung bei ergänzenden Angaben und besonderen Ausführungen (mit / ohne -Z)
    
    var fullMLFB = "";
    if(bANA_KA && !bANN_KA)
        fullMLFB = newBaseMLFB + ((kag != '') ? (' '+ kag) : '') + ((kagFT != '') ? ' ' : '') + kagFT; 
    else
        fullMLFB = newBaseMLFB + ((kag != '') ? ('-Z '+ kag) : '') + ((kagFT != '') ? ' ' : '') + kagFT; 
        
    
    return fullMLFB;
}