//@legacy
//#mode(full-ecma)



//@import "VT_1PC13.js"


/*
Motordaten:

Baugröße:	ok
    PMD_AAA726_001_000_HK1LE	Baugröße des Motors		(132S,132M, ...)
    H_BAUGROESSE_DYN_1PC13		in vielen VTs für Logik benutzt, IN_BAUGROESSE_1PC13
    IN_BAUGROESSE_1PC13			Baugröße
    IN_WUNSCH_BAUGROESSE_1PC13	Baugröße (ohne Buchstabe)
    
    HMK_BG_1PC13 = MLFB08+09	(Parser) 
    
Elektrische Parameter:

Kühlart:	ok
    IN_KUEHLART_1PC13			Kühlart						MLFB06	+ Context
    H_KUEHLART_1PC13						(410,411,416)
    O_KUEHLART_1PC13
    
???	IN_BETRIEBSART_1PC13		Betriebsart
    
ok	IN_FREQUENZ_1PC13			Frequenz
ok	IN_SPG_1PC13				Spannung
ok	IN_WICKLUNG_1PC13			Wicklungsausführung			MLFB12+13

ok	IN_DREHZAHL_1PC13			Drehzahl
    IN_BEDARF_LEI_DD_1PC13		Bedarfsleistung

ok	IN_MOTORSCHUTZ_1PC13		Motorschutz					MLFB15		Wenn = "Z", dann KAG
ok	O_MOTORSCHUTZ2_1PC13		Zusätzlicher Motorschutz	nur wenn IN_MOTORSCHUTZ_1PC13 != "A"
    
Umgebungsbedingungen:
    
    IN_WKL_1PC13				Ausnutzung nach Wärmeklasse
    IN_AH_1PC13					Aufstellhöhe

    IN_UMGEB_TEMP_MIN_1PC13		Kühlmitteltemperatur minimal
    IN_KMT_1PC13				Kühlmitteltemperatur maximal

    
Mechanische Parameter
    
ok	IN_KLK_LAGE_1PC13			Anschlusskastenlage		MLFB16
ok	IN_BAUFORM_1PC13			Bauform

ok	O_SCHUTZDACH_H00_1PC13		(H00) Schutzdach								nur bei Bauform C,G	(laut Katalog)	nicht bei Kühlart 410 VT183
ok	O_FUESSE_1PC13				(H01) Füße angeschraubt (statt angegossen)		nicht Bauform F,G,H,K,L,M,N 	siehe VT159
    
ok	O_FUESSE_L17_1PC13			(L17) Füße in Werkstoff GGG40, angeschraubt		erst ab BG 180, siehe VT85
ok	O_SCHILD_L18_1PC13			(L18) Lagerschild DE in GGG40 für Aufstellung IM B5		nur bei IN_BAUFORM_1PC13 = F möglich	VT28



    MLFB14	. Bauform		bei c,G H00 möglich		1:1 übersetzt in IN_BAUFORM_1PC13
    MLFB15	. Motorschutz	bei Z + KAG				1:1 außer Z, da direkt nur Q3A
    MLFB16	. Anschlusskasten	4,5,6 (4 top, 5 right, 6 left)	IN_KLK_LAGE_1PC13
*/

function SetMotor_Init(oData) {
    if (oData && !isEmpty(oData)) {

        // im Parser erfolgt	Bestimme_Baugroesse(oData);
        Bestimme_Kuehlart(oData);
        Bestimme_Leistungsdaten(oData);
        Bestimme_Motorschutz(oData);		// 
        Bestimme_Motorschutz2(oData);		// 

        Bestimme_Bauform(oData);		// 
        Bestimme_KLK_Lage(oData);		// 

        Bestimme_Schutzdach(oData);		// 
        Bestimme_Fuesse(oData);		// 
        Bestimme_FuesseL17(oData);		// 
        Bestimme_SchildL18(oData);		// 

        Bestimme_Umgebungsbedingungen(oData);

    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("IN_BAUGROESSE_1PC13", "15");
        ExecSetStandardifValueEmpty("PMD_AAA726_001_000_HK1LE", "15");
        ExecSetStandardifValueEmpty("H_BAUGROESSE_DYN_1PC13", "15");

        ExecSetStandardifValueEmpty("IN_KUEHLART_1PC13", "410");
        ExecSetStandardifValueEmpty("H_KUEHLART_1PC13", "410");
        ExecSetStandardifValueEmpty("O_KUEHLART_1PC13", "NON");

        ExecSetStandardifValueEmpty("IN_MOTORSCHUTZ_1PC13", "A");
        ExecSetStandardifValueEmpty("O_MOTORSCHUTZ2_1PC13", "NON");

        ExecSetStandardifValueEmpty("IN_DREHZAHL_1PC13", "1000");
        //ExecSetStandardifValueEmpty("IN_BETRIEBSART_1PC13","S1");
        ExecSetStandardifValueEmpty("IN_FREQUENZ_1PC13", "50");
        ExecSetStandardifValueEmpty("IN_SPG_1PC13", "400");
        ExecSetStandardifValueEmpty("IN_WICKLUNG_1PC13", "M4B");
        ExecSetStandardifValueEmpty("H_WICKLUNG_1PC13", "O_M4B");


        ExecSetStandardifValueEmpty("IN_BAUFORM_1PC13", "A");
        ExecSetStandardifValueEmpty("IN_KLK_LAGE_1PC13", "TOP");

        ExecSetStandardifValueEmpty("O_SCHUTZDACH_H00_1PC13", "NON");
        ECL_DeselectAttribute("O_FUESSE_1PC13");

        ECL_DeselectAttribute("O_FUESSE_L17_1PC13");
        ECL_DeselectAttribute("O_SCHILD_L18_1PC13");


        ExecSetStandardifValueEmpty("IN_WKL_1PC13", "FB");
        ExecSetStandardifValueEmpty("IN_AH_1PC13", "1000");
        ExecSetStandardifValueEmpty("IN_UMGEB_TEMP_MIN_1PC13", "STD");
        ExecSetStandardifValueEmpty("IN_KMT_1PC13", "40");
        ExecSetStandardifValueEmpty("O_WKL_KMT_AH_1PC13", "STD");


    }
}

function SetMotor(strchangedAttribute, oData) {
}
// #########################################################################################################################


// #########################################################################################################################
/**
Baugröße:
    PMD_AAA726_001_000_HK1LE	Baugröße des Motors		(132S,132M, ...)
    H_BAUGROESSE_DYN_1PC13		in vielen VTs für Logik benutzt, IN_BAUGROESSE_1PC13
    IN_BAUGROESSE_1PC13			Baugröße
    
    IN_WUNSCH_BAUGROESSE_1PC13	Baugröße (ohne Buchstabe)
    
    HMK_BG_1PC13 = MLFB08+09	(Parser) 
*/
// #########################################################################################################################
function Bestimme_Baugroesse(oData) {

    var oParsingData = oData.oParsingData;

    var H_WWDEV_MLFB_1PC13 = oData.oParsingData.MLFB.RUMPF;

    // IN_BAUGROESSE_1PC13 bestimmen aus Rumpf-MLFB
    var sTable = "VT_1PC13_M00106" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT IN_BAUGROESSE_1PC13 FROM " + sTable + " WHERE " +
        "H_WWDEV_MLFB_1PC13 = '" + H_WWDEV_MLFB_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var IN_BAUGROESSE_1PC13 = aResult[0].IN_BAUGROESSE_1PC13;

        ECL_DeactivateAllAttributeValues("IN_BAUGROESSE_1PC13");
        ECL_ActivateValue("IN_BAUGROESSE_1PC13", IN_BAUGROESSE_1PC13);
        ECL_SelectValue("IN_BAUGROESSE_1PC13", IN_BAUGROESSE_1PC13);
    }

    // Bestimmung PMD_AAA726_001_000_HK1LE, H_BAUGROESSE_DYN_1PC13
    var sTable = "VT_1PC13_M00122" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var PMD_AAA726_001_000_HK1LE = aResult[0].PMD_AAA726_001_000_HK1LE;
        var H_BAUGROESSE_DYN_1PC13 = aResult[0].H_BAUGROESSE_DYN_1PC13;
        var IN_WUNSCH_BAUGROESSE_1PC13 = aResult[0].IN_WUNSCH_BAUGROESSE_1PC13;

        ECL_DeactivateAllAttributeValues("PMD_AAA726_001_000_HK1LE");
        ECL_ActivateValue("PMD_AAA726_001_000_HK1LE", PMD_AAA726_001_000_HK1LE);
        ECL_SelectValue("PMD_AAA726_001_000_HK1LE", PMD_AAA726_001_000_HK1LE);

        ECL_DeactivateAllAttributeValues("H_BAUGROESSE_DYN_1PC13");
        ECL_ActivateValue("H_BAUGROESSE_DYN_1PC13", H_BAUGROESSE_DYN_1PC13);
        ECL_SelectValue("H_BAUGROESSE_DYN_1PC13", H_BAUGROESSE_DYN_1PC13);

        ECL_DeactivateAllAttributeValues("IN_WUNSCH_BAUGROESSE_1PC13");
        ECL_ActivateValue("IN_WUNSCH_BAUGROESSE_1PC13", IN_WUNSCH_BAUGROESSE_1PC13);
        ECL_SelectValue("IN_WUNSCH_BAUGROESSE_1PC13", IN_WUNSCH_BAUGROESSE_1PC13);
    }


}
// #########################################################################################################################
/*
    MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
    ECSI_CX_CoolingMethodMotor
    IN_KUEHLART_1PC13			Kühlart						MLFB06	+ Context
    H_KUEHLART_1PC13						(410,411,416)
    
    wenn MLFB06 = 6 ==> 410 (unbelüftet) O_KUEHLART_1PC13 = NON
    wenn MLFB06 = 4 ==>	411 (eigenbelüftet) wenn keine KAG für O_KUEHLART_1PC13 (nicht F70 oder F79) oder BG nicht 315
                        416 (fremdbelüftet) wenn O_KUEHLART_1PC13 == F70 (BG 132...200), F79 (BG 225...280) oder wenn BG 315, dann STD
                            ==> new: AH315 F79 nessesary, not STD!!!
    
    F70 oder F79 muss vom SIZER übergeben werden vergl. 1LE1/1MB1
*/
function Bestimme_Kuehlart(oData) {
    var MLFB06_1PC13 = oData.oParsingData.MLFB.MLFB06;

    if (MLFB06_1PC13 == "6") {
        // O_KUEHLART_1PC13 = NON
        ECL_DeactivateAllAttributeValues("O_KUEHLART_1PC13");
        ECL_ActivateValue("O_KUEHLART_1PC13", "NON");
        ECL_SelectValue("O_KUEHLART_1PC13", "NON");
        // IN_KUEHLART_1PC13 = 410
        ECL_DeactivateAllAttributeValues("IN_KUEHLART_1PC13");
        ECL_ActivateValue("IN_KUEHLART_1PC13", "410");
        ECL_SelectValue("IN_KUEHLART_1PC13", "410");
        // H_KUEHLART_1PC13 = 410
        ECL_DeactivateAllAttributeValues("H_KUEHLART_1PC13");
        ECL_ActivateValue("H_KUEHLART_1PC13", "410");
        ECL_SelectValue("H_KUEHLART_1PC13", "410");
    } else { // "4"

        // Wenn BG_WUNSCH == 315, dann O_KUEHLART_1PC13 == STD ==> EDIT, according to tables yes, but TST transfers F79, so we have to consider that
        var IN_WUNSCH_BAUGROESSE_1PC13 = ECL_GetValue("IN_WUNSCH_BAUGROESSE_1PC13");
        var sTargetAttribute = "O_KUEHLART_1PC13";
        var aKAG = oData.oParsingData.MLFB.KAG || [];

        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

        if (IN_WUNSCH_BAUGROESSE_1PC13 == "315" && sKAG == "NON") { // no KAG, ==> STD
            // O_KUEHLART_1PC13 = STD
            ECL_DeactivateAllAttributeValues("O_KUEHLART_1PC13");
            ECL_ActivateValue("O_KUEHLART_1PC13", "STD");
            ECL_SelectValue("O_KUEHLART_1PC13", "STD");
            // IN_KUEHLART_1PC13 = 416
            ECL_DeactivateAllAttributeValues("IN_KUEHLART_1PC13");
            ECL_ActivateValue("IN_KUEHLART_1PC13", "416");
            ECL_SelectValue("IN_KUEHLART_1PC13", "416");
            // H_KUEHLART_1PC13 = 416
            ECL_DeactivateAllAttributeValues("H_KUEHLART_1PC13");
            ECL_ActivateValue("H_KUEHLART_1PC13", "416");
            ECL_SelectValue("H_KUEHLART_1PC13", "416");

        } else {    // also AH315, if KAG F79 is transfered
            // wenn F70 oder F79, dann 416, sonst 411
            if (sKAG != "NON") {
                // O_KUEHLART_1PC13 = sKAG
                ECL_DeactivateAllAttributeValues("O_KUEHLART_1PC13");
                ECL_ActivateValue("O_KUEHLART_1PC13", sKAG);
                ECL_SelectValue("O_KUEHLART_1PC13", sKAG);
                // IN_KUEHLART_1PC13 = 416
                ECL_DeactivateAllAttributeValues("IN_KUEHLART_1PC13");
                ECL_ActivateValue("IN_KUEHLART_1PC13", "416");
                ECL_SelectValue("IN_KUEHLART_1PC13", "416");
                // H_KUEHLART_1PC13 = 416
                ECL_DeactivateAllAttributeValues("H_KUEHLART_1PC13");
                ECL_ActivateValue("H_KUEHLART_1PC13", "416");
                ECL_SelectValue("H_KUEHLART_1PC13", "416");
            } else {
                // O_KUEHLART_1PC13 = NON
                ECL_DeactivateAllAttributeValues("O_KUEHLART_1PC13");
                ECL_ActivateValue("O_KUEHLART_1PC13", "NON");
                ECL_SelectValue("O_KUEHLART_1PC13", "NON");
                // IN_KUEHLART_1PC13 = 411
                ECL_DeactivateAllAttributeValues("IN_KUEHLART_1PC13");
                ECL_ActivateValue("IN_KUEHLART_1PC13", "411");
                ECL_SelectValue("IN_KUEHLART_1PC13", "411");
                // H_KUEHLART_1PC13 = 411
                ECL_DeactivateAllAttributeValues("H_KUEHLART_1PC13");
                ECL_ActivateValue("H_KUEHLART_1PC13", "411");
                ECL_SelectValue("H_KUEHLART_1PC13", "411");

            }
        }
    }

}
// #########################################################################################################################

// #########################################################################################################################
/**
Motorschutz:
    MLFB15	. Motorschutz	bei Z + KAG				1:1 außer Z, da direkt nur Q3A
*/
// #########################################################################################################################
function Bestimme_Motorschutz(oData) {

    var MLFB15_1PC13 = oData.oParsingData.MLFB.MLFB15;

    if (MLFB15_1PC13 == "Z") {
        // KAG: bisher nur Q3A
        var sTargetAttribute = "IN_MOTORSCHUTZ_1PC13";
        var aKAG = oData.oParsingData.MLFB.KAG || [];

        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);
        if (sKAG != "NON") {
            ECL_ActivateValue("IN_MOTORSCHUTZ_1PC13", sKAG);
            ECL_SelectValue("IN_MOTORSCHUTZ_1PC13", sKAG);
        } else {
            // da bisher nur Q3A, bei "Z" setzen
            ECL_ActivateValue("IN_MOTORSCHUTZ_1PC13", "Q3A");
            ECL_SelectValue("IN_MOTORSCHUTZ_1PC13", "Q3A");
        }
    } else {
        ECL_ActivateValue("IN_MOTORSCHUTZ_1PC13", MLFB15_1PC13);
        ECL_SelectValue("IN_MOTORSCHUTZ_1PC13", MLFB15_1PC13);
    }

}
// #########################################################################################################################

// #########################################################################################################################
/**
zusätzlicher Motorschutz:
    O_MOTORSCHUTZ2_1PC13 KAG bei IN_MOTORSCHUTZ_1PC13 == A nur NON
    
    
    VT_1PC13_M00050	motorschutz+BG(sperre)
        O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz
        H_BAUGROESSE_DYN_1PC13	Baugröße

    
*/
// #########################################################################################################################
function Bestimme_Motorschutz2(oData) {
    // O_MOTORSCHUTZ2_1PC13
    // KAG: NON, Q11...Q36

    var MLFB15_1PC13 = oData.oParsingData.MLFB.MLFB15;

    if (MLFB15_1PC13 == "A") {
        // nur NON
        ECL_ActivateValue("O_MOTORSCHUTZ2_1PC13", "NON");
        ECL_SelectValue("O_MOTORSCHUTZ2_1PC13", "NON");
    } else {

        var sTargetAttribute = "O_MOTORSCHUTZ2_1PC13";
        var aKAG = oData.oParsingData.MLFB.KAG || [];

        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);
        if (sKAG != "NON") {
            ECL_ActivateValue("O_MOTORSCHUTZ2_1PC13", sKAG);
            ECL_SelectValue("O_MOTORSCHUTZ2_1PC13", sKAG);
        } else {
            ECL_ActivateValue("O_MOTORSCHUTZ2_1PC13", "NON");
            ECL_SelectValue("O_MOTORSCHUTZ2_1PC13", "NON");
        }
    }
}
// #########################################################################################################################


// ################################################################################################################
// Bauform
// ################################################################################################################
/*
Bauform:
    MLFB14	. Bauform		bei c,G H00 möglich		1:1 übersetzt in IN_BAUFORM_1PC13

*/
function Bestimme_Bauform(oData) {
    var MLFB14_1PC13 = oData.oParsingData.MLFB.MLFB14;

    ECL_ActivateValue("IN_BAUFORM_1PC13", MLFB14_1PC13);
    ECL_SelectValue("IN_BAUFORM_1PC13", MLFB14_1PC13);

}
// ################################################################################################################

// ################################################################################################################
// Anschlusskastenlage
// ################################################################################################################
/*
Bauform:
    IN_KLK_LAGE_1PC13			Anschlusskastenlage		MLFB16

*/
function Bestimme_KLK_Lage(oData) {
    var MLFB16_1PC13 = oData.oParsingData.MLFB.MLFB16;

    sTable = "VT_1PC13_M00007" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB16_1PC13 = '" + MLFB16_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var IN_KLK_LAGE_1PC13 = aResult[0].IN_KLK_LAGE_1PC13;

        ECL_ActivateValue("IN_KLK_LAGE_1PC13", IN_KLK_LAGE_1PC13);
        ECL_SetValue("IN_KLK_LAGE_1PC13", IN_KLK_LAGE_1PC13);

    }

}
// ################################################################################################################


// ################################################################################################################
// Leistungsdaten
// ################################################################################################################
/*
    IN_BETRIEBSART_1PC13		Betriebsart
    
    IN_FREQUENZ_1PC13			Frequenz
    IN_SPG_1PC13				Spannung
    IN_WICKLUNG_1PC13			Wicklungsausführung			MLFB12+13 (90 ==> KAG) ist O_XXX KAG
    H_WICKLUNG_1PC13			KAG-Attribut
    
    IN_DREHZAHL_1PC13			Drehzahl	/	Polzahl		MLFB10
    IN_LEISTUNG_1PC13			Leistung
*/

function Bestimme_Leistungsdaten(oData) {
    var MLFB10_1PC13 = oData.oParsingData.MLFB.MLFB10;	// Polzahl/Drehzahl
    var MLFB11_1PC13 = oData.oParsingData.MLFB.MLFB11;
    var MLFB12_1PC13 = oData.oParsingData.MLFB.MLFB12;	// 9
    var MLFB13_1PC13 = oData.oParsingData.MLFB.MLFB13;	// 0

    var sWicklung = MLFB12_1PC13 + MLFB13_1PC13;

    if (sWicklung == "90") {
        var sTargetAttribute = "H_WICKLUNG_1PC13";
        var aKAG = oData.oParsingData.MLFB.KAG || [];

        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);
        if (sKAG != "NON") {


            if (sKAG != "M1Y" && sKAG != "M2Y") {
                ECL_DeactivateAllAttributeValues("H_WICKLUNG_1PC13");
                ECL_ActivateValue("H_WICKLUNG_1PC13", sKAG);
                ECL_SelectValue("H_WICKLUNG_1PC13", sKAG);

                ECL_DeactivateAllAttributeValues("IN_WICKLUNG_1PC13");
                ECL_ActivateValue("IN_WICKLUNG_1PC13", "O_" + sKAG);
                ECL_SelectValue("IN_WICKLUNG_1PC13", "O_" + sKAG);


                sTable = "VT_1PC13_M00012" + sDB_Suffix;

                var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "H_WICKLUNG_1PC13 = '" + sKAG + "';";

                var aResult = GetDBDataSetEXT(sSQL);
                if (aResult.length > 0) {
                    var IN_FREQUENZ_1PC13 = aResult[0].IN_FREQUENZ_1PC13;
                    var IN_SPG_1PC13 = aResult[0].IN_SPG_1PC13;

                    ECL_SetValue("IN_FREQUENZ_1PC13", IN_FREQUENZ_1PC13);
                    ECL_SetValue("IN_SPG_1PC13", IN_SPG_1PC13);
                }

            } else {
                // todo ANORM
            }
        } else {
            // Fehler
        }
    } else {
        //todo
    }

    // Drehzahl
    // IN_DREHZAHL_1PC13
    // PMD_AAA_149_001_000_1PC13	Polzahl
    sTable = "VT_1PC13_M00002" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB10_1PC13 = '" + MLFB10_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var IN_DREHZAHL_1PC13 = aResult[0].IN_DREHZAHL_1PC13;
        //var PMD_AAA_149_001_000_1PC13 = aResult[0].PMD_AAA_149_001_000_1PC13;

        ECL_DeactivateAllAttributeValues("IN_DREHZAHL_1PC13")
        ECL_ActivateValue("IN_DREHZAHL_1PC13", IN_DREHZAHL_1PC13);
        ECL_SetValue("IN_DREHZAHL_1PC13", IN_DREHZAHL_1PC13);

        //ECL_DeactivateAllAttributeValues("PMD_AAA_149_001_000_1PC13")
        //ECL_ActivateValue("PMD_AAA_149_001_000_1PC13", PMD_AAA_149_001_000_1PC13);
        //ECL_SetValue("PMD_AAA_149_001_000_1PC13", PMD_AAA_149_001_000_1PC13);
    }


}
// ################################################################################################################


// ################################################################################################################
// Schutzdach
// ################################################################################################################
/*
Schutzdach:
    O_SCHUTZDACH_H00_1PC13		(H00) Schutzdach		nur bei Bauform C,G	(laut Katalog)	nicht bei Kühlart 410 VT183
    
    als Checkbox, STD nicht aktiv
    
*/
function Bestimme_Schutzdach(oData) {
    var sTargetAttribute = "O_SCHUTZDACH_H00_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sKAG = "H00"; //getKAGforAttribute(sTargetAttribute, aKAG);

    if (aKAG.indexOf(sKAG) > -1) {	// if (sKAG != "NON"){
        bCheck = checkH00(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    } else {
        // STD oder NON? // sperren ohne if ==> derzeit kein STD
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkH00(oData, sTargetAttribute, sKAG) {
    //(H00) Schutzdach		nur bei Bauform C,G (laut Katalog)		nicht bei Kühlart 410 VT183
    var IN_KUEHLART_1PC13 = ECL_GetValue("IN_KUEHLART_1PC13");

    // Bauform identisch zu MLFB14
    var MLFB14_1PC13 = oData.oParsingData.MLFB.MLFB14;

    // VT VT_1PC13_M00183	IC --> H00
    //	IN_KUEHLART_1PC13, O_SCHUTZDACH_H00_1PC13

    var sTable = "VT_1PC13_M00183" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    /* DT-K nicht eingeschränkt)
    if (MLFB14_1PC13 != "C" && MLFB14_1PC13 != "G"){	// ??? todo
        return 0;
    }
    */
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// Füße angeschraubt (statt angegossen)																				Checkbox
// ################################################################################################################
/*

    O_FUESSE_1PC13				(H01) Füße angeschraubt (statt angegossen)		nicht Bauform F,G,H,K,L,M,N 	siehe VT159
    
    
*/
function Bestimme_Fuesse(oData) {
    var sTargetAttribute = "O_FUESSE_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sKAG = "H01"; //getKAGforAttribute(sTargetAttribute, aKAG);

    if (aKAG.indexOf(sKAG) > -1) {	// if (sKAG != "NON"){
        bCheck = checkH01(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }

}
function checkH01(oData, sTargetAttribute, sKAG) {
    //(H01) Füße angeschraubt (statt angegossen)		nicht Bauform F,G,H,K,L,M,N 	siehe VT159

    // Bauform identisch zu MLFB14
    var MLFB14_1PC13 = oData.oParsingData.MLFB.MLFB14;

    // VT_1PC13_M00209	BF-H01-L17-L18
    //	IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13

    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + MLFB14_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// (L17) Füße in Werkstoff GGG40																					Checkbox
// ################################################################################################################
/*
    O_FUESSE_L17_1PC13			(L17) Füße in Werkstoff GGG40, angeschraubt		erst ab BG 180, siehe VT85
*/
function Bestimme_FuesseL17(oData) {
    var sTargetAttribute = "O_FUESSE_L17_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sKAG = "L17"; //getKAGforAttribute(sTargetAttribute, aKAG);

    if (aKAG.indexOf(sKAG) > -1) {	// if (sKAG != "NON"){
        bCheck = checkL17(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }

}
function checkL17(oData, sTargetAttribute, sKAG) {
    if (ECL_ValueSelected("O_FUESSE_1PC13", "T")) {
        var O_FUESSE_1PC13 = "H01";
    } else {
        var O_FUESSE_1PC13 = "NON";
    }
    // Bauform identisch zu MLFB14
    var MLFB14_1PC13 = oData.oParsingData.MLFB.MLFB14;

    // VT_1PC13_M00209	BF-H01-L17-L18
    //    IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13

    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + MLFB14_1PC13 + "' AND " +
        "O_FUESSE_1PC13 = '" + O_FUESSE_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    // VT_1PC13_M00085	Opt. L17 -> BG
    //	O_FUESSE_L17_1PC13	H_BAUGROESSE_DYN_1PC13
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00085" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// (L18) Lagerschild DE in GGG40 für Aufstellung IM B5																Checkbox
// ################################################################################################################
/*
Bauform:
    O_SCHILD_L18_1PC13		(L18) Lagerschild DE in GGG40 für Aufstellung IM B5		nur bei IN_BAUFORM_1PC13 = F möglich	VT28

*/
function Bestimme_SchildL18(oData) {
    var sTargetAttribute = "O_SCHILD_L18_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sKAG = "L18"; //getKAGforAttribute(sTargetAttribute, aKAG);

    if (aKAG.indexOf(sKAG) > -1) {	// if (sKAG != "NON"){
        bCheck = checkL18(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }

}
function checkL18(oData, sTargetAttribute, sKAG) {
    // nur bei IN_BAUFORM_1PC13 = F möglich	VT28 ==> VT209
    var MLFB14_1PC13 = oData.oParsingData.MLFB.MLFB14;
    // VT_1PC13_M00209	BF-H01-L17-L18
    //	IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13
    var O_FUESSE_1PC13 = "NON";
    if (ECL_ValueSelected("O_FUESSE_1PC13", "T")) {
        O_FUESSE_1PC13 = "H01";
    }

    var O_FUESSE_L17_1PC13 = "NON";
    if (ECL_ValueSelected("O_FUESSE_L17_1PC13", "T")) {
        O_FUESSE_L17_1PC13 = "L17";
    }

    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + MLFB14_1PC13 + "' AND " +
        "O_FUESSE_1PC13 = '" + O_FUESSE_1PC13 + "' AND " +
        "O_FUESSE_L17_1PC13 = '" + O_FUESSE_L17_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################



// ################################################################################################################
/* 
Umgebungsbedingungen
    O_WKL_KMT_AH_1PC13			KAG Wärmeklasse, KMT, AH
    
    IN_WKL_1PC13				Ausnutzung nach Wärmeklasse
        VT_1PC13_M00019	Derating Faktor / Wärmeklaase
    
    IN_AH_1PC13					Aufstellhöhe
        VT_1PC13_M00019	Derating Faktor / Wärmeklaase
    
    IN_UMGEB_TEMP_MIN_1PC13		Kühlmitteltemperatur minimal
        VT_1PC13_M00205	Brake + FS + min temp
    
    IN_KMT_1PC13				Kühlmitteltemperatur maximal
        VT_1PC13_M00019	Derating Faktor / Wärmeklaase
        VT_1PC13_M00055	Opt.N31+KMT
        VT_1PC13_M00062	KMT
        VT_1PC13_M00184	KMT --> D31

*/
// ################################################################################################################
function Bestimme_Umgebungsbedingungen(oData) {
    // ###########################################################################################################
    // TemperatureClassUtilization
    // ###########################################################################################################
    var ECSI_CX_TemperatureClassUtilization = parseInt(ECL_GetValue("ECSI_CX_TemperatureClassUtilization")) || 0;




    // ###########################################################################################################
    // Aufstellhöhe
    // ###########################################################################################################
    var ECSI_CX_InstallationAltituteMotor = parseInt(ECL_GetValue("ECSI_CX_InstallationAltituteMotor")) || 0;
    /**
    Integer:
    1000	≤ 1000 m
    1500	≤ 1500 m
    2000	≤ 2000 m
    2500	≤ 2500 m
    3000	≤ 3000 m
    
    IN_AH_1PC13
    1000	bis 1000m
    1500	bis 1500m
    2000	bis 2000m
    2500	bis 2500m
    3000	bis 3000m
    3500	bis 3500m 
    4000	bis 4000m 
    */
    if (ECSI_CX_InstallationAltituteMotor > 0 && ECSI_CX_InstallationAltituteMotor <= 4000) {
        ECL_DeactivateAllAttributeValues("IN_AH_1PC13");
        ECL_ActivateValue("IN_AH_1PC13", ECSI_CX_InstallationAltituteMotor);
        ECL_SetValue("IN_AH_1PC13", ECSI_CX_InstallationAltituteMotor);
    } else {
        // Fehler: Höhe nicht unterstüztz
        oData.strError = "DICT1_ERR_1PC13___ALTITUTE_MOTOR_NOT_SUPPORTED";
    }
    // ###########################################################################################################
    // Umgebungstemperatur --> IN_KMT_1PC13
    // ###########################################################################################################
    var ECSI_CX_AmbientTemperatureMotor = parseInt(ECL_GetValue("ECSI_CX_AmbientTemperatureMotor")) || 0;
    /**
    Integer:			IN_KMT_1PC13
        25	≤ 25 °C		-				--> 40°C
        30	≤ 30 °C		-				--> 40°C
        35	≤ 35 °C		-				--> 40°C
        40	≤ 40 °C		40
        45	≤ 45 °C		45
        50	≤ 50 °C		50
        55	≤ 55 °C		55
        60	≤ 60 °C		60
    */
    // Werte unter 40°C werden auf 40°C gesetzt:
    if (ECSI_CX_AmbientTemperatureMotor < 40) {
        ECL_ActivateAttribute("INFO_KMT_1PC13");
        ECSI_CX_AmbientTemperatureMotor = 40;
    }
    else {
        ECL_DeactivateAttribute("INFO_KMT_1PC13");
    }

    if (ECSI_CX_AmbientTemperatureMotor > 35 && ECSI_CX_AmbientTemperatureMotor != "") {
        ECL_DeactivateAllAttributeValues("IN_KMT_1PC13");
        ECL_ActivateValue("IN_KMT_1PC13", ECSI_CX_AmbientTemperatureMotor);
        ECL_SetValue("IN_KMT_1PC13", ECSI_CX_AmbientTemperatureMotor);
    }
    else {
        // Fehler: Umgebungstemperatur zu niedrig, nicht unterstüztz
        oData.strError = "DICT1_ERR_1PC13___AMBIENT_TEMPERATURE_MOTOR_NOT_SUPPORTED";
    }
    // ###########################################################################################################

    // zunächst prüfen, ob es eine KAG gibt:
    var sTargetAttribute = "O_WKL_KMT_AH_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sMLFB = oData.strFullMLFB;

    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        if (sKAG.left(1) == "Y") {
            // Daten aus Freitext

            var iIndexY = sMLFB.indexOf("M_");
            if (iIndexY > -1) {
                var iAH = parseInt(sMLFB.substr(iIndexY - 4, 4));
                var iKMT = parseInt(sMLFB.substr(iIndexY + 2, 2));
                if (iAH != ECSI_CX_InstallationAltituteMotor) {
                    sError = "ERRORMSG_MLFB_1PC13___CX_AH_OUT_OF_RANGE";
                    return sError;
                }
                if (iKMT != ECSI_CX_AmbientTemperatureMotor && ECSI_CX_AmbientTemperatureMotor > 35) {
                    sError = "ERRORMSG_MLFB_1PC13___CX_KMT_OUT_OF_RANGE";
                    return sError;
                }
            }
        } else {
            // N05...N11
            ECL_ActivateValue("O_WKL_KMT_AH_1PC13", sKAG);
            ECL_SelectValue("O_WKL_KMT_AH_1PC13", sKAG);

            var sWhereWKL = "";
            /** Edit 06.2022: 
                After consultation with M. Gilbert, TemperatureClassUtilization is to be ignored and the FF is to be used as a fixed value.
                The short options N05...N08 should still be applied.
            */
            // actual only FF is needed, to get N05...N08 we use internal FB
            //if (ECSI_CX_TemperatureClassUtilization == 130){
            sWhereWKL = "IN_WKL_1PC13 = 'FB' AND ";
            /*}else{
                sWhereWKL = "(IN_WKL_1PC13 = 'HF' OR IN_WKL_1PC13 = 'H_HH') AND ";
            }*/

            sTable = "VT_1PC13_M00019" + sDB_Suffix;
            // IN_WKL_1PC13	IN_AH_1PC13	IN_KMT_1PC13	O_WKL_KMT_AH_1PC13	H_DERATING_1PC13

            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                sWhereWKL +
                "O_WKL_KMT_AH_1PC13 = '" + O_WKL_KMT_AH_1PC13 + "';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
                var IN_WKL_1PC13 = aResult[0].IN_WKL_1PC13;
                var IN_AH_1PC13 = aResult[0].IN_AH_1PC13;
                var IN_KMT_1PC13 = aResult[0].IN_KMT_1PC13;

                ECL_ActivateValue("IN_WKL_1PC13", IN_WKL_1PC13);
                ECL_SelectValue("IN_WKL_1PC13", IN_WKL_1PC13);

                // gegen Kontext prüfen			todo
                /*ECL_ActivateValue("IN_AH_1PC13", IN_AH_1PC13);
                ECL_SelectValue("IN_AH_1PC13", IN_AH_1PC13);
                // gegen Kontext prüfen
                ECL_ActivateValue("IN_KMT_1PC13", IN_KMT_1PC13);
                ECL_SelectValue("IN_KMT_1PC13", IN_KMT_1PC13);
                */
            } else {
                // nicht gültig, neu bestimmen

                // Error
                sError = "ERRORMSG_MLFB_1PC13___CX_WKL_OUT_OF_RANGE";
                return sError;
            }
        }

        bCheck = checkL18(oData, sTargetAttribute, sKAG);
    } else {
        // STD
        sKAG = "STD"
        ECL_ActivateValue("O_WKL_KMT_AH_1PC13", sKAG);
        ECL_SelectValue("O_WKL_KMT_AH_1PC13", sKAG);

        // IN_WKL_1PC13 = "FB"
        // IN_AH_1PC13 = "1000"
        // IN_KMT_1PC13 = "40"

    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }


    // IN_UMGEB_TEMP_MIN_1PC13
    var sTargetAttribute = "IN_UMGEB_TEMP_MIN_1PC13";
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var bCheck = false;

    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {

        bCheck = checkUmgTempMin(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }

}

function checkUmgTempMin(oData, sTargetAttribute, sKAG) {

    var IN_WUNSCH_BAUGROESSE_1PC13 = ECL_GetValue("IN_WUNSCH_BAUGROESSE_1PC13");
    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");

    // VT_1PC13_M00205	Brake + FS + min temp
    //	IN_WUNSCH_BAUGROESSE_1PC13	IN_UMGEB_TEMP_MIN_1PC13	O_ANBAU_BREMSE_1PC13


    var sTable = "VT_1PC13_M00205" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_WUNSCH_BAUGROESSE_1PC13 = '" + IN_WUNSCH_BAUGROESSE_1PC13 + "' AND " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;

}
// ################################################################################################################
