//@legacy
//#mode(full-ecma)



//@import "VT_1PC13.js"


/*
Elekrischer Anschluss, Anschlusskasten
    O_ANSCHL_RICHTUNG_1PC13				Anschlussrichtung
    O_ANSCHLUSS_ART_1PC13				Anschluss Art
    O_GROESS_ANSCHL_K_1PC13				(R50) Nächst größerer Anschlusskasten
    O_ANSCHLK_BS_1PC13					(H08) Anschlusskasten auf NDE (BS)
    H_KABELKANAL_1PC13					(R01) Vergießen des Kabelkanals (Anschlusskasten / Motorinnenraum) mit Harz
    O_HILFS_KLK_1PC13					(R62) Hilfsanschlusskasten Grauguss (klein)
    O_2_HILFS_KLK_KLEIN_1PC13			(R67) 2 kleine Grauguss-Hilfsanschlusskästen
    
    n.n.	O_HILFS_KLKR60_1PC13		(R60) Hilfsanschlusskasten (klein)
    
    O_KABELEINFPLATTE_1PC13				Kabeleinführungplatte
    OE_KABELEINFPLATTE_1PC13			Bestellangaben:

Geber, Bremse, Rücklaufsperre
    O_DREHIMPULSGEBER_1PC13				Drehimpulsgeber
    OE_GEBER_DREHZAHL_1PC13				Drehzahl (1/min):
    
    O_ANBAU_BREMSE_1PC13				Anbau Bremse
    O_BREMSSPANNUNG_1PC13				Bremsenanschlussspannung
    O_BREMSEVORB_1PC13					Bremse vorbereitet
    O_BREMSE_GELUEFTET_1PC13			(F26) Bremse Microswitch on/off (Bremse gelüftet)
    O_BREMSE_HEIZUNG_1PC13				(F27) Stillstandheizung für Brake AC 230 V
    O_BREMSE_HEBEL_1PC13				(F50) Mechanische Handlüftung der Bremse mit Betätigungshebel
    O_BREMSE_LUFTWACHE_1PC13			(F51) Bremse Microswitch für Luftspaltüberwachung
    
Farbanstrich	
    O_ANSTRICH_1PC13					Anstrich
    H_RAL_FARBE_1PC13					RAL-Farbton
    H_KAG_FARBE_1PC13					KAG Farben

Mechanische Ausführungen:
    O_SCHUTZART_1PC13					Schutzart			(BG keine Einschränkung VT30 nn)
    O_KWL_1PC13							Kondenswasserlöcher			immer Ja (Standard)
    O_ROSTFREI_SCHRAUB_1PC13			Nicht rostende Schrauben (außen)

Zusätzliche Vorschriften
    O_UL_D31_1PC13						(D31) Ausführung nach UL mit „Recognition Mark“
    O_CSA_D40_1PC13						(D40) Kanadische Vorschriften CSA
    O_D47_1PC13							(D47) TR CU Produktsicherheitszertifikat EAC für die eurasische Zollunion

    
*/

function SetOptionen_1_Init(oData) {
    if (oData && !isEmpty(oData)) {

        // Elekrischer Anschluss, Anschlusskasten
        Bestimme_Anschlussrichtung(oData);		// O_ANSCHL_RICHTUNG_1PC13			Anschlussrichtung
        Bestimme_AnschlussArt(oData);			// O_ANSCHLUSS_ART_1PC13			Anschluss Art
        Bestimme_GROESS_ANSCHL_K(oData);		// O_GROESS_ANSCHL_K_1PC13			(R50) Nächst größerer Anschlusskasten			Checkbox

        Bestimme_ANSCHLK_BS(oData);				// O_ANSCHLK_BS_1PC13				(H08) Anschlusskasten auf NDE (BS)				Checkbox

        Bestimme_Kabelkanal(oData);				// H_KABELKANAL_1PC13				(R01) Vergießen des Kabelkanals (Anschlusskasten / Motorinnenraum) mit Harz		Checkbox

        Bestimme_HILFS_KLK(oData);				// O_HILFS_KLK_1PC13				(R62) Hilfsanschlusskasten Grauguss (klein)										Checkbox
        Bestimme_O_2_HILFS_KLK_KLEIN(oData);	// O_2_HILFS_KLK_KLEIN_1PC13		(R67) 2 kleine Grauguss-Hilfsanschlusskästen								    Checkbox
        //Bestimme_HILFS_KLKR60(oData);			//n.n.	O_HILFS_KLKR60_1PC13		(R60) Hilfsanschlusskasten (klein)

        Bestimme_KABELEINFPLATTE(oData);		// O_KABELEINFPLATTE_1PC13			Kabeleinführungplatte

        Bestimme_SchaltungAuslieferung(oData);	// O_SCHALTUNG_AUSLIEF_1PC13		Schaltung Auslieferung

        // Geber, Bremse, Rücklaufsperre
        // zunächst Bremse
        Bestimme_Bremse(oData);					// O_ANBAU_BREMSE_1PC13				Anbau Bremse
        Bestimme_Bremsspannung(oData);		// O_BREMSSPANNUNG_1PC13			Bremsenanschlussspannung
        Bestimme_Bremsvorb(oData);			// O_BREMSEVORB_1PC13				Bremse vorbereitet
        Bestimme_BremseGelueftet(oData);	// O_BREMSE_GELUEFTET_1PC13			(F26) Bremse Microswitch on/off (Bremse gelüftet)					Checkbox
        Bestimme_BremseHeizung(oData);		// O_BREMSE_HEIZUNG_1PC13			(F27) Stillstandheizung für Brake AC 230 V							Checkbox
        Bestimme_BremseHebel(oData);		// O_BREMSE_HEBEL_1PC13				(F50) Mechanische Handlüftung der Bremse mit Betätigungshebel		Checkbox
        Bestimme_BremseLuftwache(oData);	// O_BREMSE_LUFTWACHE_1PC13			(F51) Bremse Microswitch für Luftspaltüberwachung					Checkbox

        // Geber
        Bestimme_Geber(oData);					// O_DREHIMPULSGEBER_1PC13			Drehimpulsgeber
        // OE_GEBER_DREHZAHL_1PC13			Drehzahl (1/min):



        // Farbanstrich	
        Bestimme_Farbe(oData); 					// O_ANSTRICH_1PC13					Anstrich
        // H_RAL_FARBE_1PC13				RAL-Farbton
        // H_KAG_FARBE_1PC13				KAG Farben


        // Mechanische Ausführungen:
        Bestimme_Schutzart(oData);				// O_SCHUTZART_1PC13				Schutzart					(BG keine Einschränkung VT30 nn)
        //Bestimme_KWL(oData);					// O_KWL_1PC13						Kondenswasserlöcher			immer Ja (Standard)
        //Bestimme_RostfreiSchraub(oData);		// O_ROSTFREI_SCHRAUB_1PC13			Nicht rostende Schrauben (außen)
        ExecSetStandardifValueEmpty("O_KWL_1PC13", "STD");					// nur STD
        ExecSetStandardifValueEmpty("O_ROSTFREI_SCHRAUB_1PC13", "STD");		// nur STD

        // Zusätzliche Vorschriften
        Bestimme_D31(oData);					// O_UL_D31_1PC13					(D31) Ausführung nach UL mit „Recognition Mark“
        Bestimme_D40(oData);					// O_CSA_D40_1PC13					(D40) Kanadische Vorschriften CSA
        Bestimme_D47(oData);					// O_D47_1PC13						(D47) TR CU Produktsicherheitszertifikat EAC für die eurasische Zollunion


    } else {

        ExecSetStandardifValueEmpty("O_ANSCHL_RICHTUNG_1PC13", "NON");
        ExecSetStandardifValueEmpty("O_ANSCHLUSS_ART_1PC13", "STD");
        ECL_DeselectAttribute("O_GROESS_ANSCHL_K_1PC13");
        ECL_DeselectAttribute("O_ANSCHLK_BS_1PC13");
        ECL_DeselectAttribute("H_KABELKANAL_1PC13");
        ECL_DeselectAttribute("O_HILFS_KLK_1PC13");

        ExecSetStandardifValueEmpty("O_KABELEINFPLATTE_1PC13", "NON");
        ECL_SetValue("OE_KABELEINFPLATTE_1PC13", "");

        ExecSetStandardifValueEmpty("O_SCHALTUNG_AUSLIEF_1PC13", "STD");

        ExecSetStandardifValueEmpty("O_DREHIMPULSGEBER_1PC13", "NON");
        ECL_SetValue("OE_GEBER_DREHZAHL_1PC13", "");

        ExecSetStandardifValueEmpty("O_ANBAU_BREMSE_1PC13", "NON");
        ExecSetStandardifValueEmpty("O_BREMSSPANNUNG_1PC13", "NON");
        ExecSetStandardifValueEmpty("O_BREMSEVORB_1PC13", "NON");
        ECL_DeselectAttribute("O_BREMSE_GELUEFTET_1PC13");
        ECL_DeselectAttribute("O_BREMSE_HEIZUNG_1PC13");
        ECL_DeselectAttribute("O_BREMSE_HEBEL_1PC13");
        ECL_DeselectAttribute("O_BREMSE_LUFTWACHE_1PC13");

        //Farbanstrich	
        ExecSetStandardifValueEmpty("O_ANSTRICH_1PC13", "STD");
        ExecSetStandardifValueEmpty("H_RAL_FARBE_1PC13", "RAL7030");
        ExecSetStandardifValueEmpty("H_KAG_FARBE_1PC13", "NON");

        // Mechanische Ausführungen:
        ExecSetStandardifValueEmpty("O_SCHUTZART_1PC13", "STD");
        ExecSetStandardifValueEmpty("O_KWL_1PC13", "STD");					// nur STD
        ExecSetStandardifValueEmpty("O_ROSTFREI_SCHRAUB_1PC13", "STD");		// nur STD

        // Zusätzliche Vorschriften
        ECL_DeselectAttribute("O_UL_D31_1PC13");
        ECL_DeselectAttribute("O_CSA_D40_1PC13");
        ECL_DeselectAttribute("O_D47_1PC13");
    }
}

function SetOptionen(strchangedAttribute, oData) {
}


// ################################################################################################################
// Bestimme_Anschlussrichtung(oData)	// O_ANSCHL_RICHTUNG_1PC13				Anschlussrichtung(oData)
// ################################################################################################################
function Bestimme_Anschlussrichtung(oData) {
    // O_ANSCHL_RICHTUNG_1PC13
    // KAG: STD, R10, R11, R12

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_ANSCHL_RICHTUNG_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }
}
// ################################################################################################################

// ################################################################################################################
// Bestimme_AnschlussArt(oData)	// O_ANSCHLUSS_ART_1PC13				Anschluss Art
// ################################################################################################################
function Bestimme_AnschlussArt(oData) {
    // O_ANSCHLUSS_ART_1PC13
    // KAG: STD, R51, R52, R53, R20, R21, R22, R23, R24, R70, R71, R72, R73

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_ANSCHLUSS_ART_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkAnschlussArt(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }
}
function checkAnschlussArt(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00047	AnschlussArt+BG
            O_ANSCHLUSS_ART_1PC13	Anschluss Art
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00047" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_GROESS_ANSCHL_K(oData);		// O_GROESS_ANSCHL_K_1PC13				(R50) Nächst größerer Anschlusskasten
// ################################################################################################################
function Bestimme_GROESS_ANSCHL_K(oData) {
    // O_GROESS_ANSCHL_K_1PC13
    // KAG: R50, NON, (STD - aktuell nicht verfügbar)

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_GROESS_ANSCHL_K_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkGROESS_ANSCHL_K(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }

}
function checkGROESS_ANSCHL_K(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00086	Opt. R62 -> R50
            O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
    */
    //--------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("O_HILFS_KLK_1PC13", "T")) {
        var O_HILFS_KLK_1PC13 = "R62";
    } else {
        var O_HILFS_KLK_1PC13 = "NON";
    }

    var sTable = "VT_1PC13_M00086" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_HILFS_KLK_1PC13 = '" + O_HILFS_KLK_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################



// ################################################################################################################
// Bestimme_ANSCHLK_BS(oData);				// O_ANSCHLK_BS_1PC13				(H08) Anschlusskasten auf NDE (BS)				Checkbox
// ################################################################################################################
function Bestimme_ANSCHLK_BS(oData) {
    // O_ANSCHLK_BS_1PC13
    // KAG: H08, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_ANSCHLK_BS_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "H08";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkANSCHLK_BS(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkANSCHLK_BS(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00042	Opt.H08+BG
            O_ANSCHLK_BS_1PC13	Anschlusskasten auf NDE (BS)
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00042" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_Kabelkanal(oData)	 H_KABELKANAL_1PC13				(R01) Vergießen des Kabelkanals (Anschlusskasten / Motorinnenraum) mit Harz		Checkbox
// ################################################################################################################
function Bestimme_Kabelkanal(oData) {
    // H_KABELKANAL_1PC13
    // KAG: R01, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "H_KABELKANAL_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "R01";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = true; // Abhängige Attribute untergeordnet, da noch nicht bestimmt. checkKabelkanal(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkKabelkanal(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00114	R01 <-> D31/D40
            H_KABELKANAL_1PC13	Vergießen /.../Harz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
    * ggf. keine Einschränkung in diese Richtung?!? todo */
    //--------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("O_UL_D31_1PC13", "T")) {
        var O_UL_D31_1PC13 = "D31";
    } else {
        var O_UL_D31_1PC13 = "NON";
    }

    if (ECL_ValueSelected("O_CSA_D40_1PC13", "T")) {
        var O_CSA_D40_1PC13 = "D40";
    } else {
        var O_CSA_D40_1PC13 = "NON";
    }

    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// Bestimme_HILFS_KLK(oData);		 O_HILFS_KLK_1PC13		(R62) Hilfsanschlusskasten Grauguss (klein)					Checkbox
// ################################################################################################################
function Bestimme_HILFS_KLK(oData) {
    // O_HILFS_KLK_1PC13
    // KAG: R62, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_HILFS_KLK_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "R62";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkHILFS_KLK(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkHILFS_KLK(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00086	Opt. R62 -> R50
            O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
    */
    //--------------------------------------------------------------------------------------------------------------
    var O_GROESS_ANSCHL_K_1PC13 = "NON";
    if (ECL_ValueSelected("O_GROESS_ANSCHL_K_1PC13", "T")) {
        O_GROESS_ANSCHL_K_1PC13 = "R50";
    }

    var sTable = "VT_1PC13_M00086" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_GROESS_ANSCHL_K_1PC13 = '" + O_GROESS_ANSCHL_K_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_O_2_HILFS_KLK_KLEIN(oData);	// O_2_HILFS_KLK_KLEIN_1PC13		(R67) 2 kleine Grauguss-Hilfsanschlusskästen		Checkbox
// ################################################################################################################
function Bestimme_O_2_HILFS_KLK_KLEIN(oData) {
    // O_2_HILFS_KLK_KLEIN_1PC13
    // KAG: R67, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_2_HILFS_KLK_KLEIN_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "R67";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = check_2_HILFS_KLK_KLEIN(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function check_2_HILFS_KLK_KLEIN(oData, sTargetAttribute, sKAG) {
    /*	VT_1PC13_M00208	Opt 2 Hilfsklemmenkaesten R67
            IN_KUEHLART_1PC13	Kühlart
            IN_BAUGROESSE_1PC13	Baugröße
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
            O_2_HILFS_KLK_KLEIN_1PC13	2 /...chlusskästen
    */
    //--------------------------------------------------------------------------------------------------------------
    var IN_KUEHLART_1PC13 = ECL_GetValue("IN_KUEHLART_1PC13");
    var IN_BAUGROESSE_1PC13 = ECL_GetValue("IN_BAUGROESSE_1PC13");
    var O_GROESS_ANSCHL_K_1PC13 = "NON";
    if (ECL_ValueSelected("O_GROESS_ANSCHL_K_1PC13", "T")) {
        O_GROESS_ANSCHL_K_1PC13 = "R50";
    }

    var sTable = "VT_1PC13_M00208" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "' AND " +
        "O_GROESS_ANSCHL_K_1PC13 = '" + O_GROESS_ANSCHL_K_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_KABELEINFPLATTE(oData);		// O_KABELEINFPLATTE_1PC13			Kabeleinführungplatte
// ################################################################################################################
function Bestimme_KABELEINFPLATTE(oData) {
    // O_KABELEINFPLATTE_1PC13
    // KAG: NON, Y61, Y73

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_KABELEINFPLATTE_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkKABELEINFPLATTE(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
function checkKABELEINFPLATTE(oData, sTargetAttribute, sKAG) {
    /*	
    O_KABELEINFPLATTE_1PC13				Kabeleinführungplatte			<== aktuell nur NON und Y61  todo checken!
        VT_1PC13_M00051	Opt.Y73_Y61+BG
            O_KABELEINFPLATTE_1PC13	Kabeleinführungplatte
            H_BAUGROESSE_DYN_1PC13	Baugröße
        
    OE_KABELEINFPLATTE_1PC13			Bestellangaben:
    
    Wenn eine Eingabe im Textfeld gemacht wird, wird die Option verdeckt gesetzt, wenn Textfeld leer, dann Option 'NON'
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00051" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################
// O_SCHALTUNG_AUSLIEF_1PC13		Schaltung Auslieferung
// ################################################################################################################
function Bestimme_SchaltungAuslieferung(oData) {
    // O_SCHALTUNG_AUSLIEF_1PC13
    // KAG: STD, M02
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_SCHALTUNG_AUSLIEF_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "M02";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, STD
    else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }

}
// ################################################################################################################


// ################################################################################################################
// Bestimme_Bremse(oData);					// O_ANBAU_BREMSE_1PC13				Anbau Bremse
// ################################################################################################################
function Bestimme_Bremse(oData) {
    // O_ANBAU_BREMSE_1PC13
    // KAG: NON, F30, F..., F37

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_ANBAU_BREMSE_1PC13";
    var bCheck = false;

    //var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (oData.WithBrake) {

        ECL_ActivateAllAttributeValues("O_ANBAU_BREMSE_1PC13");
        ECL_DeactivateValue("O_ANBAU_BREMSE_1PC13", "NON");
        //ExecSetStandardifValueEmpty("O_ANBAU_BREMSE_1PC13", "");

        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

        var aKAG = parseObj.MLFB.KAG || [];
        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

        if (sKAG != "NON") {
            bCheck = checkBremse(oData, sTargetAttribute, sKAG);
        } else {
            //sKAG = getBrake(oData);
            ExecSetStandardifValueEmpty(sTargetAttribute, "");
            bCheck = ECL_AtLeastOneSelected(sTargetAttribute);
        }
        if (bCheck) {
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SelectValue(sTargetAttribute, sKAG);
        } else {
            oData.strError = "DICT1_ERR_1PC13___BRAKE_NOT_POSSIBLE";

        }
    } else {

        ECL_DeactivateAllAttributeValues("O_ANBAU_BREMSE_1PC13");
        ECL_ActivateValue("O_ANBAU_BREMSE_1PC13", "NON");
        ECL_SetValue("O_ANBAU_BREMSE_1PC13", "NON");
    }
}
function checkBremse(oData, sTargetAttribute, sKAG) {
    /*	A VT_1PC13_M00149	Bremse->BG->Kühlart
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            H_BAUGROESSE_DYN_1PC13	Baugröße
            H_KUEHLART_1PC13	Kühlart (hmk)
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00149" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    /* B VT_1PC13_M00152	L23->Bremse->BG
            O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung			<== schränkt nicht ein, nur umgekehrt
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    var sTable = "VT_1PC13_M00152" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    /* D VT_1PC13_M00205	Brake + FS + min temp
            IN_WUNSCH_BAUGROESSE_1PC13	Baugröße
            IN_UMGEB_TEMP_MIN_1PC13	Kühlmitteltemperatur minimal
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
    */
    var IN_WUNSCH_BAUGROESSE_1PC13 = ECL_GetValue("IN_WUNSCH_BAUGROESSE_1PC13");
    var IN_UMGEB_TEMP_MIN_1PC13 = ECL_GetValue("IN_UMGEB_TEMP_MIN_1PC13");

    var sTable = "VT_1PC13_M00205" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_WUNSCH_BAUGROESSE_1PC13 = '" + IN_WUNSCH_BAUGROESSE_1PC13 + "' AND " +
        "IN_UMGEB_TEMP_MIN_1PC13 = '" + IN_UMGEB_TEMP_MIN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

/*
function getBrake(oData)
{
    
    
}
*/
// ################################################################################################################


// ################################################################################################################
// Bestimme_Bremsspannung(oData);		// O_BREMSSPANNUNG_1PC13			Bremsenanschlussspannung
// ################################################################################################################
function Bestimme_Bremsspannung(oData) {
    // O_BREMSSPANNUNG_1PC13
    // KAG: NON, F11, F12, F16		(NON ergänzt, um besser zu steuern)

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSSPANNUNG_1PC13";
    var bCheck = false;

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        ECL_ActivateAllAttributeValues(sTargetAttribute);
        ECL_DeactivateValue(sTargetAttribute, "NON");

        var aKAG = parseObj.MLFB.KAG || [];
        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

        if (sKAG != "NON") {
            //ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SelectValue(sTargetAttribute, sKAG);
        } else {
            ExecSetStandardifValueEmpty(sTargetAttribute, "");
        }
    } else {
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_Bremsvorb(oData);			// O_BREMSEVORB_1PC13				Bremse vorbereitet
// ################################################################################################################
function Bestimme_Bremsvorb(oData) {
    // O_BREMSEVORB_1PC13
    // KAG: NON, F28, F29

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSEVORB_1PC13";
    var bCheck = false;

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

        var aKAG = parseObj.MLFB.KAG || [];
        var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

        if (sKAG != "NON") {
            bCheck = checkBremsvorb(oData, sTargetAttribute, sKAG);
        }
        if (bCheck) {
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SelectValue(sTargetAttribute, sKAG);
        } else {
            ECL_ActivateValue(sTargetAttribute, "NON");
            ECL_SelectValue(sTargetAttribute, "NON");
        }
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
function checkBremsvorb(oData, sTargetAttribute, sKAG) {
    /* C VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
        H_KUEHLART_1PC13	Kühlart (hmk)
        O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
        O_ANBAU_BREMSE_1PC13	Anbau Bremse
        O_BREMSEVORB_1PC13	Bremse vorbereitet			<== unidirektionale Einschränkung nur auf O_BREMSEVORB_1PC13
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");
    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");

    var sTable = "VT_1PC13_M00051" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_BremseGelueftet(oData);	// O_BREMSE_GELUEFTET_1PC13			(F26) Bremse Microswitch on/off (Bremse gelüftet)					Checkbox
// ################################################################################################################
function Bestimme_BremseGelueftet(oData) {
    // O_BREMSE_GELUEFTET_1PC13
    // KAG: F26, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSE_GELUEFTET_1PC13";

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = "F26";
        var aKAG = parseObj.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {
            ECL_EnableAttribute(sTargetAttribute);
            ECL_SelectValue(sTargetAttribute, "T");
        }
        // wenn keine KAG oder nicht erlaubt, deselect
        else {
            ECL_DeselectAttribute(sTargetAttribute);
        }
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_BremseHeizung(oData);		// O_BREMSE_HEIZUNG_1PC13			(F27) Stillstandheizung für Brake AC 230 V							Checkbox
// ################################################################################################################
function Bestimme_BremseHeizung(oData) {
    // O_BREMSE_HEIZUNG_1PC13
    // KAG: F27, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSE_HEIZUNG_1PC13";

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = "F27";
        var aKAG = parseObj.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {
            ECL_EnableAttribute(sTargetAttribute);
            ECL_SelectValue(sTargetAttribute, "T");
        }
        // wenn keine KAG oder nicht erlaubt, deselect
        else {
            ECL_DeselectAttribute(sTargetAttribute);
        }
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_BremseHebel(oData);		// O_BREMSE_HEBEL_1PC13				(F50) Mechanische Handlüftung der Bremse mit Betätigungshebel		Checkbox
// ################################################################################################################
function Bestimme_BremseHebel(oData) {
    // O_BREMSE_HEBEL_1PC13
    // KAG: F50, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSE_HEBEL_1PC13";

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = "F50";
        var aKAG = parseObj.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {
            ECL_EnableAttribute(sTargetAttribute);
            ECL_SelectValue(sTargetAttribute, "T");
        }
        // wenn keine KAG oder nicht erlaubt, deselect
        else {
            ECL_DeselectAttribute(sTargetAttribute);
        }
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_BremseLuftwache(oData);	// O_BREMSE_LUFTWACHE_1PC13			(F51) Bremse Microswitch für Luftspaltüberwachung		Checkbox
// ################################################################################################################
function Bestimme_BremseLuftwache(oData) {
    // O_BREMSE_LUFTWACHE_1PC13
    // KAG: F51, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_BREMSE_LUFTWACHE_1PC13";

    if (oData.WithBrake) {
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = "F51";
        var aKAG = parseObj.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {
            ECL_EnableAttribute(sTargetAttribute);
            ECL_SelectValue(sTargetAttribute, "T");
        }
        // wenn keine KAG oder nicht erlaubt, deselect
        else {
            ECL_DeselectAttribute(sTargetAttribute);
        }
    } else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################



// ################################################################################################################
// GEBER
// ################################################################################################################
/*
Geber:
    Bestimme_Geber(oData);					// O_DREHIMPULSGEBER_1PC13			Drehimpulsgeber
                                                // OE_GEBER_DREHZAHL_1PC13			Drehzahl (1/min):
    
    Geber, Bremse, Rücklaufsperre
        O_DREHIMPULSGEBER_1PC13				Drehimpulsgeber
            VT_1PC13_M00040	Geber+BG
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                H_BAUGROESSE_DYN_1PC13	Baugröße
                
            VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                O_BREMSEVORB_1PC13	Bremse vorbereitet
                
        OE_GEBER_DREHZAHL_1PC13				Drehzahl (1/min):			<== über Freitexte im Parser abgehandelt
*/
function Bestimme_Geber(oData) {
    // O_DREHIMPULSGEBER_1PC13
    // KAGs: NON, G07, G10, G13, G15, G16, Y74, Y76

    var sTargetAttribute = "O_DREHIMPULSGEBER_1PC13";

    var parseObj = oData.oParsingData;
    var bCheck = false;

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkGeber(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
function checkGeber(oData, sTargetAttribute, sKAG) {
    /* VT_1PC13_M00040	Geber+BG
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                H_BAUGROESSE_DYN_1PC13	Baugröße
                
            VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                O_BREMSEVORB_1PC13	Bremse vorbereitet
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00040" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");
    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");
    var O_BREMSEVORB_1PC13 = ECL_GetValue("O_BREMSEVORB_1PC13");

    var sTable = "VT_1PC13_M00161" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "O_BREMSEVORB_1PC13 = '" + O_BREMSEVORB_1PC13 + "' AND " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
function Bestimme_Farbe(oData) {
    /**
        // O_ANSTRICH_1PC13				Anstrich
        // H_RAL_FARBE_1PC13			RAL-Farbton
        // H_KAG_FARBE_1PC13			KAG Farben
        
        todo ? Check KAG -- Farbe
    */
    // --------------------------------------------------------------------------------------------
    // H_KAG_FARBE_1PC13		KAG Farben
    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "H_KAG_FARBE_1PC13";
    // KAG: Y53, Y56, Y66, NON

    var parseObj = oData.oParsingData;

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }

    // --------------------------------------------------------------------------------------------
    // O_ANSTRICH_1PC13			Anstrich
    // --------------------------------------------------------------------------------------------
    var sTargetAttribute = "O_ANSTRICH_1PC13";
    // KAG: STD, S04, S08, S09

    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    var bCheck = false;

    if (sKAG != "NON") {
        bCheck = checkAnstrich(oData, sTargetAttribute, sKAG);
    }

    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }

    // --------------------------------------------------------------------------------------------
    // H_RAL_FARBE_1PC13			RAL-Farbton
    // --------------------------------------------------------------------------------------------
    // ==> über SetFREETEXTS im Parser abgedeckt.

}

function checkAnstrich(oData, sTargetAttribute, sKAG) {
    var IN_KUEHLART_1PC13 = ECL_GetValue("IN_KUEHLART_1PC13");
    var IN_BAUGROESSE_1PC13 = ECL_GetValue("IN_BAUGROESSE_1PC13");

    var sTable = "VT_1PC13_M00207" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;

}
// ################################################################################################################


// ################################################################################################################
// Bestimme_Schutzart(oData);				// O_SCHUTZART_1PC13				Schutzart					(BG keine Einschränkung VT30 nn)
// ################################################################################################################
function Bestimme_Schutzart(oData) {
    // O_SCHUTZART_1PC13
    // KAG: STD, H22

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_SCHUTZART_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkSchutzart(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SelectValue(sTargetAttribute, "STD");
    }
}
function checkSchutzart(oData, sTargetAttribute, sKAG) {
    /* VT_1PC13_M00030	Opt H22_bg
        HMK_BG_1PC13		BG
        O_SCHUTZART_1PC13	Schutzart
    */
    //--------------------------------------------------------------------------------------------------------------
    var HMK_BG_1PC13 = ECL_GetValue("HMK_BG_1PC13");

    var sTable = "VT_1PC13_M00030" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################





// Zusätzliche Vorschriften
// ################################################################################################################
// Bestimme_D31(oData);			// O_UL_D31_1PC13					(D31) Ausführung nach UL mit „Recognition Mark“				Checkbox
// ################################################################################################################
function Bestimme_D31(oData) {
    // O_UL_D31_1PC13
    // KAG: D31, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_UL_D31_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "D31";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkD31(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkD31(oData, sTargetAttribute, sKAG) {
    /*	
    VT_1PC13_M00114	R01 <-> D31/D40
        H_KABELKANAL_1PC13	Vergießen /.../Harz
        O_UL_D31_1PC13	Ausführung /.../Mark“
        O_CSA_D40_1PC13	Kanadische Vorschriften CSA
        
    VT_1PC13_M00145	Motorschutz->D31/D40
        IN_MOTORSCHUTZ_1PC13	Motorschutz
        O_UL_D31_1PC13	Ausführung /.../Mark“
        O_CSA_D40_1PC13	Kanadische Vorschriften CSA
        
    VT_1PC13_M00184	KMT --> D31
        IN_KMT_1PC13	Kühlmitteltemperatur maximal
        O_UL_D31_1PC13	Ausführung /.../Mark“
    */
    //--------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("H_KABELKANAL_1PC13", "T")) {
        var H_KABELKANAL_1PC13 = "R01";
    } else {
        var H_KABELKANAL_1PC13 = "NON";
    }
    if (ECL_ValueSelected("O_CSA_D40_1PC13", "T")) {
        var O_CSA_D40_1PC13 = "D40";
    } else {
        var O_CSA_D40_1PC13 = "NON";
    }
    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KABELKANAL_1PC13 = '" + H_KABELKANAL_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00145" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var IN_KMT_1PC13 = ECL_GetValue("IN_KMT_1PC13");

    var sTable = "VT_1PC13_M00184" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_KMT_1PC13 = '" + IN_KMT_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_D40(oData);				// O_CSA_D40_1PC13					(D40) Kanadische Vorschriften CSA			Checkbox
// ################################################################################################################
function Bestimme_D40(oData) {
    // O_CSA_D40_1PC13
    // KAG: D40, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_CSA_D40_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "D40";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkD40(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkD40(oData, sTargetAttribute, sKAG) {
    /*	
    VT_1PC13_M00114	R01 <-> D31/D40
        H_KABELKANAL_1PC13	Vergießen /.../Harz
        O_UL_D31_1PC13	Ausführung /.../Mark“
        O_CSA_D40_1PC13	Kanadische Vorschriften CSA
        
    VT_1PC13_M00145	Motorschutz->D31/D40
        IN_MOTORSCHUTZ_1PC13	Motorschutz
        O_UL_D31_1PC13	Ausführung /.../Mark“
        O_CSA_D40_1PC13	Kanadische Vorschriften CSA
    */
    //--------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("H_KABELKANAL_1PC13", "T")) {
        var H_KABELKANAL_1PC13 = "R01";
    } else {
        var H_KABELKANAL_1PC13 = "NON";
    }
    if (ECL_ValueSelected("O_UL_D31_1PC13", "T")) {
        var O_UL_D31_1PC13 = "D31";
    } else {
        var O_UL_D31_1PC13 = "NON";
    }

    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KABELKANAL_1PC13 = '" + H_KABELKANAL_1PC13 + "' AND " +
        "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00145" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "' AND " +
        "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// Bestimme_D47(oData);		// O_D47_1PC13		(D47) TR CU Produktsicherheitszertifikat EAC für die eurasische Zollunion	Checkbox
// ################################################################################################################
function Bestimme_D47(oData) {
    // O_D47_1PC13
    // KAG: D47, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_D47_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "D47";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################
// ################################################################################################################





