//@legacy
//#mode(full-ecma)

//@import "VT_1PC13.js"

/*
Dokumentation
    O_B02_ABNAHME_1PC13					(B02) Abnahmeprüfzeugnis 3.1 nach EN 10204				Checkbox
    O_B54_PAINT_MEAS_1PC13              (B54) Messung der Lackdicke des Motor					Checkbox
    O_AUFTR_MASSBL_1PC13				(B61) Dokument - Auftragsmaßbild						Checkbox
    O_PHOTO_DOC_1PC13					Fotodokumentation

Belüftung
    H_LUEFTERHAUBE_UI_1PC13				Lüfterhaube
    O_LUEFTERHAUBE_1PC13				Lüfterhaube												Checkbox
    
    O_MATAUSSENLUEFT_1PC13				Metall-Außenlüfter										Checkbox

    O_STILLSTANDSHEIZUNG_1PC13			Stillstandsheizung

Welle und Läufer
    O_WELLE_NIROSTA_1PC13				(L06) Standardwelle aus nichtrostendem Stahl			Checkbox

Beschilderung
    O_ZUSATZSCHILD_1PC13				(Y82) Zusatzschild mit Bestellangaben
    OE_ZUSATZSCHILD_TA_1PC13			Bestellangaben:
    
    O_NIROSTA_SCHILD_1PC13				(STD) Leistungsschild, nicht rostender Stahl			nur Standard

Lagerung
    H_L23_UI_NACHSCHMIER_1PC13			Nachschmiereinrichtung	(wenn Std)
    O_L23_NACHSCHMIER_1PC13				Nachschmiereinrichtung	(wenn Auswahl)
    
    H_L25_UI_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)
    O_L25_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)					Checkbox

    I_WELLENDICHTRING_1PC13				Wellendichtring auf DE-Seite	(Std. Info)
    O_RAD_DICHTRING_1PC13	(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar				Checkbox
    
    I_WELLENDICHTRING_NE_1PC13			Wellendichtring auf NDE-Seite	(Std. Info)
    
    O_LAGERISOLIER_DE_1PC13				(L50) Lagerisolierung DE (AS)															Checkbox
    
    H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)
    O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)														Checkbox
    
???	O_LAGERTHERM_1PC13	Lagerthermometer

*/

function SetOptionen_2_Init(oData) {
    if (oData && !isEmpty(oData)) {

        // Dokumentation
        Bestimme_B02(oData); 			// O_B02_ABNAHME_1PC13			(B02) Abnahmeprüfzeugnis 3.1 nach EN 10204				Checkbox
        Bestimme_B54(oData); 			// O_B54_PAINT_MEAS_1PC13		(B54) Messung der Lackdicke des Motor					Checkbox
        Bestimme_B61(oData); 			// O_AUFTR_MASSBL_1PC13			(B61) Dokument - Auftragsmaßbild						Checkbox
        Bestimme_PhotoDoc(oData); 		// O_PHOTO_DOC_1PC13			Fotodokumentation

        // Belüftung
        Bestimme_F74(oData); 			// O_LUEFTERHAUBE_1PC13			Lüfterhaube												Checkbox
        // H_LUEFTERHAUBE_UI_1PC13		Lüfterhaube			INFO-Attribut über Standardwert

        Bestimme_F76(oData); 			// O_MATAUSSENLUEFT_1PC13		Metall-Außenlüfter										Checkbox
        Bestimme_Stillstandsheizung(oData);		// O_STILLSTANDSHEIZUNG_1PC13		Stillstandsheizung

        // Welle und Läufer
        Bestimme_L06(oData); 			// O_WELLE_NIROSTA_1PC13		(L06) Standardwelle aus nichtrostendem Stahl			Checkbox

        /// Beschilderung
        Bestimme_Y82(oData); 			// O_ZUSATZSCHILD_1PC13			(Y82) Zusatzschild mit Bestellangaben
        // OE_ZUSATZSCHILD_TA_1PC13		Bestellangaben:

        ExecSetStandardifValueEmpty("O_NIROSTA_SCHILD_1PC13", "STD");	// nur STD	O_NIROSTA_SCHILD_1PC13	Leistungsschild, nicht rostender Stahl

        // Lagerung
        Bestimme_L23(oData); 			// O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung	(wenn Auswahl)
        // H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung	(wenn Std)

        Bestimme_L25(oData); 			// O_L25_LAGER_63_1PC13			Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)					Checkbox
        // H_L25_UI_LAGER_63_1PC13		Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)

        Bestimme_H23(oData); 			// O_RAD_DICHTRING_1PC13		(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar	Checkbox
        // I_WELLENDICHTRING_1PC13		Wellendichtring auf DE-Seite	(Std. Info)

        // I_WELLENDICHTRING_NE_1PC13	Wellendichtring auf NDE-Seite	(Std. Info)

        Bestimme_L50(oData); 			// O_LAGERISOLIER_DE_1PC13		(L50) Lagerisolierung DE (AS)															Checkbox

        Bestimme_L51(oData); 			// O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)												Checkbox
        // H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)

    } else {

        ECL_DeselectAttribute("O_B02_ABNAHME_1PC13");
        ECL_DeselectAttribute("O_B54_PAINT_MEAS_1PC13");
        ECL_DeselectAttribute("O_AUFTR_MASSBL_1PC13");
        ExecSetStandardifValueEmpty("O_PHOTO_DOC_1PC13", "NON");

        ECL_DeselectAttribute("O_LUEFTERHAUBE_1PC13");
        ExecSetStandardifValueEmpty("H_LUEFTERHAUBE_UI_1PC13", "NON");

        ECL_DeselectAttribute("O_MATAUSSENLUEFT_1PC13");

        ExecSetStandardifValueEmpty("O_STILLSTANDSHEIZUNG_1PC13", "NON");

        ECL_DeselectAttribute("O_WELLE_NIROSTA_1PC13");

        ExecSetStandardifValueEmpty("O_ZUSATZSCHILD_1PC13", "NON");
        ECL_SetValue("OE_ZUSATZSCHILD_TA_1PC13", "");

        ExecSetStandardifValueEmpty("O_NIROSTA_SCHILD_1PC13", "STD");	// nur STD	

        ExecSetStandardifValueEmpty("O_L23_NACHSCHMIER_1PC13", "NON");
        ExecSetStandardifValueEmpty("H_L23_UI_NACHSCHMIER_1PC13", "NO");

        ECL_DeselectAttribute("O_L25_LAGER_63_1PC13");
        ExecSetStandardifValueEmpty("H_L25_UI_LAGER_63_1PC13", "NON");

        ECL_DeselectAttribute("O_RAD_DICHTRING_1PC13");
        ExecSetStandardifValueEmpty("I_WELLENDICHTRING_1PC13", "NON");

        ExecSetStandardifValueEmpty("I_WELLENDICHTRING_NE_1PC13", "NON");

        ECL_DeselectAttribute("O_LAGERISOLIER_DE_1PC13");

        ECL_DeselectAttribute("O_L51_LAGERISOL_NDE_1PC13");
        ExecSetStandardifValueEmpty("H_L51_UI_LAGERIS_NDE_1PC13", "NON");
    }
}

function SetOptionen(strchangedAttribute, oData) {
}


// ################################################################################################################
/* Dokumentation - Werkprüfbescheinigung:	
    O_B02_ABNAHME_1PC13			(B02) Abnahmeprüfzeugnis 3.1 nach EN 10204				Checkbox
*/
// ################################################################################################################
function Bestimme_B02(oData) {
    // O_B02_ABNAHME_1PC13
    // KAG: B02, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_B02_ABNAHME_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B02";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################

// Bestimme_B54(oData); 			// O_B54_PAINT_MEAS_1PC13		(B54) Messung der Lackdicke des Motor					Checkbox
// ################################################################################################################
/* Dokumentation - Werkprüfbescheinigung:	
    O_B54_PAINT_MEAS_1PC13		(B54) Messung der Lackdicke des Motor					Checkbox
*/
// ################################################################################################################
function Bestimme_B54(oData) {
    // O_B54_PAINT_MEAS_1PC13
    // KAG: B54, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_B54_PAINT_MEAS_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B54";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################

// ################################################################################################################
/* Dokumentation - Auftragsmaßbild	
    Bestimme_B61(oData); 			// O_AUFTR_MASSBL_1PC13			(B61) Dokument - Auftragsmaßbild						Checkbox
*/
// ################################################################################################################
function Bestimme_B61(oData) {
    // O_AUFTR_MASSBL_1PC13
    // KAG: B61, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_AUFTR_MASSBL_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B61";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################

// ################################################################################################################
/* Dokumentation - Werkprüfbescheinigung:	
    Bestimme_PhotoDoc(oData); 		// O_PHOTO_DOC_1PC13			Fotodokumentation
*/
function Bestimme_PhotoDoc(oData) {
    // O_PHOTO_DOC_1PC13
    // KAG: NON, B93, B94
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_PHOTO_DOC_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }

}
// ################################################################################################################


// ################################################################################################################
/* Belüftung - Lüfterhaube	
    Bestimme_F74(oData); 			// O_LUEFTERHAUBE_1PC13			Lüfterhaube												Checkbox
                                    // H_LUEFTERHAUBE_UI_1PC13		Lüfterhaube			INFO-Attribut über Standardwert
*/
// ################################################################################################################
function Bestimme_F74(oData) {
    // O_LUEFTERHAUBE_1PC13
    // KAG: F74, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_LUEFTERHAUBE_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "F74";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkF74(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkF74(oData, sTargetAttribute, sKAG) {
    /* VT_1PC13_M00163	Kühlart->F74_UI->F74
        H_KUEHLART_1PC13	Kühlart (hmk)
        O_LUEFTERHAUBE_1PC13	Lüfterhaube
        H_LUEFTERHAUBE_UI_1PC13	Lüfterhaube
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");

    var sTable = "VT_1PC13_M00163" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
/* Belüftung - Lüfterhaube	
    Bestimme_F76(oData); 			// O_MATAUSSENLUEFT_1PC13		Metall-Außenlüfter								Checkbox

*/
// ################################################################################################################
function Bestimme_F76(oData) {
    // O_MATAUSSENLUEFT_1PC13
    // KAG: F76, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_MATAUSSENLUEFT_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "F76";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkF76(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkF76(oData, sTargetAttribute, sKAG) {
    /* VT_1PC13_M00125	Kühlart->F76->BG
        H_KUEHLART_1PC13	Kühlart (hmk)
        O_MATAUSSENLUEFT_1PC13	Metall-Außenlüfter
        H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00125" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################
// Bestimme_Stillstandsheizung(oData);		// O_STILLSTANDSHEIZUNG_1PC13		Stillstandsheizung
// ################################################################################################################
function Bestimme_Stillstandsheizung(oData) {
    // O_STILLSTANDSHEIZUNG_1PC13
    // KAG: NON, Q02, Q03

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_STILLSTANDSHEIZUNG_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
// ################################################################################################################

// ################################################################################################################
/* Welle und Läufer 
    Bestimme_L06(oData); 			// O_WELLE_NIROSTA_1PC13		(L06) Standardwelle aus nichtrostendem Stahl			Checkbox
*/
// ################################################################################################################
function Bestimme_L06(oData) {
    // O_WELLE_NIROSTA_1PC13
    // KAG: L06, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_WELLE_NIROSTA_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L06";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
// ################################################################################################################


// ################################################################################################################
// Beschilderung
// Bestimme_Y82(oData); 	// O_ZUSATZSCHILD_1PC13				(Y82) Zusatzschild mit Bestellangaben
// OE_ZUSATZSCHILD_TA_1PC13			Bestellangaben:			(über Freitext abgehandelt)
// ################################################################################################################
function Bestimme_Y82(oData) {
    // O_ZUSATZSCHILD_1PC13
    // KAG: Y82, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_ZUSATZSCHILD_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y82";
    var aKAG = parseObj.MLFB.KAG || [];

    if (aKAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, immer erlaubt, also setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
// ################################################################################################################


// ####################################################################################################################
// Lagerung
// ####################################################################################################################

// ################################################################################################################
// Bestimme_L23(oData); 		// O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung	(wenn Auswahl)
// H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung	(wenn Std)
// ################################################################################################################
function Bestimme_L23(oData) {
    // O_L23_NACHSCHMIER_1PC13
    // KAG: NON, L19, L23

    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_L23_NACHSCHMIER_1PC13";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden

    var aKAG = parseObj.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkL23(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    } else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
function checkL23(oData, sTargetAttribute, sKAG) {
    /*	O_L23_NACHSCHMIER_1PC13				Nachschmiereinrichtung	(wenn Auswahl)
            VT_1PC13_M00152	L23->Bremse->BG
                O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                H_BAUGROESSE_DYN_1PC13	Baugröße
                
            VT_1PC13_M00182	L23->L23_UI->BG
                O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung
                H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                H_BAUGROESSE_DYN_1PC13		Baugröße
                
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
                HMK_BG_1PC13	BG
                O_SCHILD_L18_1PC13			Lagerschild /.../B5
                H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung
                H_L25_UI_LAGER_63_1PC13		Sonderlager /.../63
                O_L25_LAGER_63_1PC13		Sonderlager /.../63
                H_BEARING_SELECT_1PC13		Bearing selection
        
        H_L23_UI_NACHSCHMIER_1PC13			Nachschmiereinrichtung	(wenn Std)	
            VT_1PC13_M00182	L23->L23_UI->BG
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    */
    //--------------------------------------------------------------------------------------------------------------
    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00152" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1PC13_M00182" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_BG_1PC13 = ECL_GetValue("HMK_BG_1PC13");
    if (ECL_ValueSelected("O_SCHILD_L18_1PC13", "T")) {
        var O_SCHILD_L18_1PC13 = "L18";
    } else {
        var O_SCHILD_L18_1PC13 = "NON";
    }

    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
/* 	Bestimme_L25(oData); 	
    O_L25_LAGER_63_1PC13		Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)					Checkbox
    H_L25_UI_LAGER_63_1PC13		Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)
*/
// ################################################################################################################
function Bestimme_L25(oData) {
    // O_L25_LAGER_63_1PC13
    // KAG: L25, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_L25_LAGER_63_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L25";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkL25(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkL25(oData, sTargetAttribute, sKAG) {
    /*
        O_L25_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
                HMK_BG_1PC13	BG
                O_SCHILD_L18_1PC13	Lagerschild /.../B5
                H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                H_L25_UI_LAGER_63_1PC13	Sonderlager /.../63
                O_L25_LAGER_63_1PC13	Sonderlager /.../63
                H_BEARING_SELECT_1PC13	Bearing selection
            
        H_L25_UI_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    */
    //--------------------------------------------------------------------------------------------------------------
    if (ECL_ValueSelected("O_SCHILD_L18_1PC13", "T")) {
        var O_SCHILD_L18_1PC13 = "L18";
    } else {
        var O_SCHILD_L18_1PC13 = "NON";
    }
    //var H_L23_UI_NACHSCHMIER_1PC13 = ECL_GetValue("H_L23_UI_NACHSCHMIER_1PC13");
    var O_L23_NACHSCHMIER_1PC13 = ECL_GetValue("O_L23_NACHSCHMIER_1PC13");
    var HMK_BG_1PC13 = ECL_GetValue("HMK_BG_1PC13");

    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        //"H_L23_UI_NACHSCHMIER_1PC13 = '" + H_L23_UI_NACHSCHMIER_1PC13 + "' AND " +
        "O_L23_NACHSCHMIER_1PC13 = '" + O_L23_NACHSCHMIER_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
/* Bestimme_H23(oData); 
    O_RAD_DICHTRING_1PC13		(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar	Checkbox
    I_WELLENDICHTRING_1PC13		Wellendichtring auf DE-Seite	(Std. Info)
*/
// ################################################################################################################
function Bestimme_H23(oData) {
    // O_RAD_DICHTRING_1PC13
    // KAG: H23, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_RAD_DICHTRING_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "H23";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkH23(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkH23(oData, sTargetAttribute, sKAG) {
    /*
    O_RAD_DICHTRING_1PC13	(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar
        VT_1PC13_M00083	Radialdichtung rel. Bauform
            O_RAD_DICHTRING_1PC13	Radialdichtring.../bar
            IN_BAUFORM_1PC13		Bauform
            
        VT_1PC13_M00187	Shaft seal DE side
            HMK_BG_1PC13	BG
            I_WELLENDICHTRING_1PC13	Wellendichtring auf DE-Seite
            O_RAD_DICHTRING_1PC13	Radialdichtring.../bar
            
    I_WELLENDICHTRING_1PC13				Wellendichtring auf DE-Seite	(Std. Info)
        VT_1PC13_M00187	Shaft seal DE side
    */
    //--------------------------------------------------------------------------------------------------------------
    var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");

    var sTable = "VT_1PC13_M00083" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_BG_1PC13 = ECL_GetValue("HMK_BG_1PC13");

    var sTable = "VT_1PC13_M00187" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// I_WELLENDICHTRING_NE_1PC13	Wellendichtring auf NDE-Seite	(Std. Info)


// ################################################################################################################
/* Bestimme_L50(oData); 
    O_LAGERISOLIER_DE_1PC13		(L50) Lagerisolierung DE (AS)														Checkbox
*/
// ################################################################################################################
function Bestimme_L50(oData) {
    // O_LAGERISOLIER_DE_1PC13
    // KAG: L50, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_LAGERISOLIER_DE_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L50";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkL50(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkL50(oData, sTargetAttribute, sKAG) {
    /* 	VT_1PC13_M00045	Opt.L50+BG
            O_LAGERISOLIER_DE_1PC13	Lagerisolierung DE (AS)
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00045" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
/* Bestimme_L51(oData);
    O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)												Checkbox
    H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)
*/
// ################################################################################################################
function Bestimme_L51(oData) {
    // O_L51_LAGERISOL_NDE_1PC13
    // KAG: L51, NON
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_L51_LAGERISOL_NDE_1PC13";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L51";
    var aKAG = parseObj.MLFB.KAG || [];
    var bCheck = false;

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkL51(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_EnableAttribute(sTargetAttribute);
        ECL_SelectValue(sTargetAttribute, "T");
    }
    // wenn keine KAG oder nicht erlaubt, deselect
    else {
        ECL_DeselectAttribute(sTargetAttribute);
    }
}
function checkL51(oData, sTargetAttribute, sKAG) {
    /*	O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)
            VT_1PC13_M00154	L51->L51_UI->BG
                O_L51_LAGERISOL_NDE_1PC13	Lagerisolierung NDE (BS)
                H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)
                H_BAUGROESSE_DYN_1PC13	Baugröße
            
        H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)
            VT_1PC13_M00154	L51->L51_UI->BG
    */
    //--------------------------------------------------------------------------------------------------------------
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");

    var sTable = "VT_1PC13_M00154" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################
// ################################################################################################################
