//@legacy
//#mode(full-ecma)



//@import "../1PC13_MLFB/Base.misc.js"

//@import "VT_1PC13.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    // var sMLFB1_4 = sMLFB.left(4);
    // var MLFB01_1PC13 = sMLFB.left(4);
    /*
    var MLFB05_1PC13 = sMLFB.charAt(4) + sMLFB.charAt(5); //Achshöhe
    var MLFB08_1PC13 = sMLFB.charAt(7); //
    var MLFB09_1PC13 = sMLFB.charAt(8); //Geber
    var MLFB10_1PC13 = sMLFB.charAt(9); 
    */
    var HMK_BG_1PC13 = ECL_GetValue("HMK_BG_1PC13");
    var H_BAUGROESSE_DYN_1PC13 = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");
    var IN_BAUGROESSE_1PC13 = ECL_GetValue("IN_BAUGROESSE_1PC13");
    var IN_WUNSCH_BAUGROESSE_1PC13 = ECL_GetValue("IN_WUNSCH_BAUGROESSE_1PC13");


    var H_KUEHLART_1PC13 = ECL_GetValue("H_KUEHLART_1PC13");
    var IN_KUEHLART_1PC13 = ECL_GetValue("IN_KUEHLART_1PC13");
    var IN_KMT_1PC13 = ECL_GetValue("IN_KMT_1PC13");

    // ################################################################################################################


    // ################################################################################################################
    // IN_BAUFORM_1PC13	Bauform
    // ################################################################################################################
    /* 
        VT_1PC13_M00005	Bauform					abh. BG
            IN_BAUFORM_1PC13		Bauform
            HMK_BG_1PC13			BG				bei 3A nicht F,H
        
        VT_1PC13_M00006	Mapping_MLFB_14			1:1 Überstzt, n.n.
            MLFB14_1PC13			Segment Merkmal MLFB14_1PC13
            IN_BAUFORM_1PC13		Bauform
        
       VT_1PC13_M00209	BF-H01-L17-L18                      <=== keine Einschränkung in diese Richtung!
            IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13
        
        VT_1PC13_M00083	Radialdichtung rel. Bauform			<=== keine Einschränkung in diese Richtung!
            O_RAD_DICHTRING_1PC13	Radialdichtring.../bar
            IN_BAUFORM_1PC13		Bauform 
            
        VT_1PC13_M00164	Bauform->PMD			n.n. PMD-Übersetzung
        VT_1PC13_M00169	BF->Bilder				n.n. Bilder
        VT_1PC13_M00171	KLK->Bilder				n.n. Bilder
        VT_1PC13_M00198	Type of construction	n.n.
        
    MLFB14_1PC13	VT_1PC13_M00006	Mapping_MLFB_14		keine Logik auf MLFB-Stelle
        
        
    */

    var sTargetAttribute = "IN_BAUFORM_1PC13";

    var sTable = "VT_1PC13_M00005" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_BAUFORM_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------------
    // MLFB14 aktualisieren

    var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");

    var sTable = "VT_1PC13_M00006" + sDB_Suffix;
    var sSQL = "SELECT MLFB14_1PC13 FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        var MLFB14_1PC13 = aResult[0].MLFB14_1PC13;
    } else {
        strError = ECL_Translate("DICT1_ERR_1PC13___SET_MLFB14");
        return strError;
    }

    //ECL_SelectValue("MLFB14_1PC13", MLFB14_1PC13);

    sMLFB = replaceAt(sMLFB, 13, MLFB14_1PC13)
    ECL_SetValue("ECSI_MLFB", sMLFB);
    // ################################################################################################################






    // IN_MOTORSCHUTZ_1PC13	Motorschutz
    // O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz

    // ################################################################################################################
    // IN_MOTORSCHUTZ_1PC13	Motorschutz
    // ################################################################################################################
    /* 
        VT_1PC13_M00008	Mapping_MLFB_15
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            MLFB15_1PC13	Segment Merkmal MLFB15_1PC13
            
        VT_1PC13_M00026	Motorschutz zusatz Optionen
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz
            
        VT_1PC13_M00078	Motorschutz+BG
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            H_BAUGROESSE_DYN_1PC13	Baugröße
            
        VT_1PC13_M00145	Motorschutz->D31/D40
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
            
        VT_1PC13_M00204	Datasheet - motor protection		n.n.
        
        
        MLFB15_1PC13
            VT_1PC13_M00008	Mapping_MLFB_15
    */
    // VT_1PC13_M00078	Motorschutz+BG
    var sTargetAttribute = "IN_MOTORSCHUTZ_1PC13";

    var sTable = "VT_1PC13_M00078" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_MOTORSCHUTZ_NO_DB_RESULT";
        return strError;
    }
    // --------------------------------------------------------------------------------------------
    // MLFB15 aktualisieren
    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00008" + sDB_Suffix;
    var sSQL = "SELECT MLFB15_1PC13 FROM " + sTable + " WHERE " +
        "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        var MLFB15_1PC13 = aResult[0].MLFB15_1PC13;
    } else {
        strError = ECL_Translate("DICT1_ERR_1PC13___SET_MLFB15");
        return strError;
    }

    //ECL_SelectValue("MLFB15_1PC13", MLFB15_1PC13);

    sMLFB = replaceAt(sMLFB, 14, MLFB15_1PC13)
    ECL_SetValue("ECSI_MLFB", sMLFB);
    // ################################################################################################################


    // ################################################################################################################
    // O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz
    // ################################################################################################################
    /* 
        VT_1PC13_M00026	Motorschutz zusatz Optionen
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz
            
        VT_1PC13_M00050	motorschutz+BG(sperre)
            O_MOTORSCHUTZ2_1PC13	Zusätzlicher Motorschutz
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    // VT_1PC13_M00026	Motorschutz zusatz Optionen
    var sTargetAttribute = "O_MOTORSCHUTZ2_1PC13";

    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00026" + sDB_Suffix;
    var sWhere = "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_MOTORSCHUTZ_2_NO_DB_RESULT";
        return strError;
    }
    // --------------------------------------------------------------------------------------------
    // VT_1PC13_M00050	motorschutz+BG(sperre)
    var sTable = "VT_1PC13_M00050" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_MOTORSCHUTZ_2_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // IN_KLK_LAGE_1PC13 		Anschlusskastenlage
    // ################################################################################################################
    /*
    VT_1PC13_M00007	Mapping_MLFB_16
        MLFB16_1PC13	Segment Merkmal MLFB16_1PC13
        IN_KLK_LAGE_1PC13	Anschlusskastenlage
        
    VT_1PC13_M00021	Klemenkasten_BG
        IN_KLK_LAGE_1PC13	Anschlusskastenlage
        HMK_BG_1PC13	BG
        
    VT_1PC13_M00115	TB Position
        n.n.
    VT_1PC13_M00171	KLK->Bilder
        n.n.
    */
    var sTargetAttribute = "IN_KLK_LAGE_1PC13";

    var sTable = "VT_1PC13_M00021" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_MOTORSCHUTZ_2_NO_DB_RESULT";
        return strError;
    }

    // --------------------------------------------------------------------------------------------
    // MLFB16 aktualisieren
    var IN_KLK_LAGE_1PC13 = ECL_GetValue("IN_KLK_LAGE_1PC13");

    var sTable = "VT_1PC13_M00007" + sDB_Suffix;
    var sSQL = "SELECT MLFB16_1PC13 FROM " + sTable + " WHERE " +
        "IN_KLK_LAGE_1PC13 = '" + IN_KLK_LAGE_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        var MLFB16_1PC13 = aResult[0].MLFB16_1PC13;
    } else {
        strError = ECL_Translate("DICT1_ERR_1PC13___SET_MLFB16");
        return strError;
    }

    //ECL_SelectValue("MLFB16_1PC13", MLFB16_1PC13);

    sMLFB = replaceAt(sMLFB, 15, MLFB16_1PC13)
    ECL_SetValue("ECSI_MLFB", sMLFB);


    // ################################################################################################################

    // ################################################################################################################
    // O_WKL_KMT_AH_1PC13	Option für Wärmeklasse/KMT/AH
    // ################################################################################################################
    /* VT_1PC13_M00019	Derating Faktor / Wärmeklaase
            IN_WKL_1PC13	IN_AH_1PC13	IN_KMT_1PC13	O_WKL_KMT_AH_1PC13	H_DERATING_1PC13
    */
    var sTargetAttribute = "O_WKL_KMT_AH_1PC13";

    var IN_WKL_1PC13 = ECL_GetValue("IN_WKL_1PC13");
    var IN_AH_1PC13 = ECL_GetValue("IN_AH_1PC13");
    var IN_KMT_1PC13 = ECL_GetValue("IN_KMT_1PC13");


    var sTable = "VT_1PC13_M00019" + sDB_Suffix;
    var sWhere = "IN_WKL_1PC13 = '" + IN_WKL_1PC13 + "' AND " +
        "IN_AH_1PC13 = '" + IN_AH_1PC13 + "' AND " +
        "IN_KMT_1PC13 = '" + IN_KMT_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_WKL_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################




    // ################################################################################################################
    //	Elekrischer Anschluss, Anschlusskasten
    // ################################################################################################################
    /*  O_ANSCHL_RICHTUNG_1PC13				Anschlussrichtung							keine Einschränkung aus VT
        
        O_ANSCHLUSS_ART_1PC13				Anschluss Art
            VT_1PC13_M00047	AnschlussArt+BG
                O_ANSCHLUSS_ART_1PC13	Anschluss Art
                H_BAUGROESSE_DYN_1PC13	Baugröße
            
        O_GROESS_ANSCHL_K_1PC13				(R50) Nächst größerer Anschlusskasten
            VT_1PC13_M00086	Opt. R62 -> R50
                O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
                O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
            
        O_ANSCHLK_BS_1PC13					(H08) Anschlusskasten auf NDE (BS)					<== Checkbox
            VT_1PC13_M00042	Opt.H08+BG
                O_ANSCHLK_BS_1PC13	Anschlusskasten auf NDE (BS)
                H_BAUGROESSE_DYN_1PC13	Baugröße
            
        H_KABELKANAL_1PC13					(R01) Vergießen des Kabelkanals (Anschlusskasten / Motorinnenraum) mit Harz				<== Checkbox
            VT_1PC13_M00114	R01 <-> D31/D40
                H_KABELKANAL_1PC13	Vergießen /.../Harz
                O_UL_D31_1PC13	Ausführung /.../Mark“
                O_CSA_D40_1PC13	Kanadische Vorschriften CSA
            
        O_HILFS_KLK_1PC13					(R62) Hilfsanschlusskasten Grauguss (klein)				<== Checkbox
            VT_1PC13_M00086	Opt. R62 -> R50
                O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
                O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
        
        O_2_HILFS_KLK_KLEIN_1PC13
            VT_1PC13_M00208	Opt 2 Hilfsklemmenkaesten R67
                IN_KUEHLART_1PC13	Kühlart
                IN_BAUGROESSE_1PC13	Baugröße
                O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
                O_2_HILFS_KLK_KLEIN_1PC13	2 /...chlusskästen
    
        n.n.	O_HILFS_KLKR60_1PC13				(R60) Hilfsanschlusskasten (klein)			<== aktuell ausgeblendet
            VT_1PC13_M00057	Opt. R60+BG
                O_HILFS_KLKR60_1PC13	Hilfsanschlusskasten (klein)
                H_BAUGROESSE_DYN_1PC13	Baugröße

        O_KABELEINFPLATTE_1PC13				Kabeleinführungplatte			<== aktuell nur NON und Y61  todo checken!
            VT_1PC13_M00051	Opt.Y73_Y61+BG
                O_KABELEINFPLATTE_1PC13	Kabeleinführungplatte
                H_BAUGROESSE_DYN_1PC13	Baugröße
            
        OE_KABELEINFPLATTE_1PC13			Bestellangaben:
        */

    // ################################################################################################################
    // O_ANSCHLUSS_ART_1PC13				Anschluss Art
    // ################################################################################################################
    /*	VT_1PC13_M00047	AnschlussArt+BG
            O_ANSCHLUSS_ART_1PC13	Anschluss Art
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    var sTargetAttribute = "O_ANSCHLUSS_ART_1PC13";

    var sTable = "VT_1PC13_M00047" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_ANSCHLUSS_ART_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_ANSCHLK_BS_1PC13					(H08) Anschlusskasten auf NDE (BS)					<== Checkbox
    // ################################################################################################################
    /*	VT_1PC13_M00042	Opt.H08+BG
            O_ANSCHLK_BS_1PC13	Anschlusskasten auf NDE (BS)
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    //var sTargetAttribute = "O_ANSCHLK_BS_1PC13";

    var sDTKAttribute = "O_ANSCHLK_BS_1PC13";
    var sCB_Attribute = "O_ANSCHLK_BS_1PC13";
    var sKAG = "H08";
    var sNON_Value = "NON";

    var sTable = "VT_1PC13_M00042" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_H08_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // H_KABELKANAL_1PC13					(R01) Vergießen des Kabelkanals (Anschlusskasten / Motorinnenraum) mit Harz		<== Checkbox
    // ################################################################################################################
    /*	VT_1PC13_M00114	R01 <-> D31/D40
            H_KABELKANAL_1PC13	Vergießen /.../Harz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
    * ggf. keine Einschränkung in diese Richtung?!? todo */
    //var sTargetAttribute = "O_ANSCHLK_BS_1PC13";

    var sDTKAttribute = "H_KABELKANAL_1PC13";
    var sCB_Attribute = "H_KABELKANAL_1PC13";
    var sKAG = "R01";
    var sNON_Value = "NON";

    var O_UL_D31_1PC13 = "NON";
    if (ECL_ValueSelected("O_UL_D31_1PC13", "T")) {
        O_UL_D31_1PC13 = "D31";
    }

    var O_CSA_D40_1PC13 = "NON";
    if (ECL_ValueSelected("O_CSA_D40_1PC13", "T")) {
        O_CSA_D40_1PC13 = "D40";
    }

    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sWhere = "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_R01_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_GROESS_ANSCHL_K_1PC13				(R50) Nächst größerer Anschlusskasten
    // ################################################################################################################
    /*	VT_1PC13_M00086	Opt. R62 -> R50
            O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
      	
            VT_1PC13_M00208	Opt 2 Hilfsklemmenkaesten R67
            IN_KUEHLART_1PC13	Kühlart
            IN_BAUGROESSE_1PC13	Baugröße
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
            O_2_HILFS_KLK_KLEIN_1PC13	2 /...chlusskästen
    */

    var sDTKAttribute = "O_GROESS_ANSCHL_K_1PC13";
    var sCB_Attribute = "O_GROESS_ANSCHL_K_1PC13";
    var sKAG = "R50";
    var sNON_Value = "NON";

    var O_HILFS_KLK_1PC13 = "NON";
    if (ECL_ValueSelected("O_HILFS_KLK_1PC13", "T")) {
        O_HILFS_KLK_1PC13 = "R62";
    }

    var sTable = "VT_1PC13_M00086" + sDB_Suffix;
    var sWhere = "O_HILFS_KLK_1PC13 = '" + O_HILFS_KLK_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_R50_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------------------------------
    var O_2_HILFS_KLK_KLEIN_1PC13 = "NON";
    if (ECL_ValueSelected("O_2_HILFS_KLK_KLEIN_1PC13", "T")) {
        O_2_HILFS_KLK_KLEIN_1PC13 = "R67";
    }
    var sTable = "VT_1PC13_M00208" + sDB_Suffix;
    var sWhere = "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "' AND " +
        "O_2_HILFS_KLK_KLEIN_1PC13 = '" + O_2_HILFS_KLK_KLEIN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_R50_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_2_HILFS_KLK_KLEIN_1PC13					(R67) 2 kleine Grauguss-Hilfsanschlusskästen		Checkbox
    // ################################################################################################################
    /*	VT_1PC13_M00208	Opt 2 Hilfsklemmenkaesten R67
            IN_KUEHLART_1PC13	Kühlart
            IN_BAUGROESSE_1PC13	Baugröße
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
            O_2_HILFS_KLK_KLEIN_1PC13	2 /...chlusskästen
    */
    var sDTKAttribute = "O_2_HILFS_KLK_KLEIN_1PC13";
    var sCB_Attribute = "O_2_HILFS_KLK_KLEIN_1PC13";
    var sKAG = "R67";
    var sNON_Value = "NON";

    var O_GROESS_ANSCHL_K_1PC13 = "NON";
    if (ECL_ValueSelected("O_GROESS_ANSCHL_K_1PC13", "T")) {
        O_GROESS_ANSCHL_K_1PC13 = "R50";
    }

    var sTable = "VT_1PC13_M00208" + sDB_Suffix;
    var sWhere = "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "' AND " +
        "O_GROESS_ANSCHL_K_1PC13 = '" + O_GROESS_ANSCHL_K_1PC13 + "';";
    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_R67_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // O_HILFS_KLK_1PC13					(R62) Hilfsanschlusskasten Grauguss (klein)				<== Checkbox
    // ################################################################################################################
    /*	VT_1PC13_M00086	Opt. R62 -> R50
            O_HILFS_KLK_1PC13	Hilfsanschlussk.../(klein)
            O_GROESS_ANSCHL_K_1PC13	Nächst /...chlusskasten
    */
    //var sTargetAttribute = "O_ANSCHLK_BS_1PC13";

    var sDTKAttribute = "O_HILFS_KLK_1PC13";
    var sCB_Attribute = "O_HILFS_KLK_1PC13";
    var sKAG = "R62";
    var sNON_Value = "NON";

    var O_GROESS_ANSCHL_K_1PC13 = "NON";
    if (ECL_ValueSelected("O_GROESS_ANSCHL_K_1PC13", "T")) {
        O_GROESS_ANSCHL_K_1PC13 = "R50";
    }

    var sTable = "VT_1PC13_M00086" + sDB_Suffix;
    var sWhere = "O_GROESS_ANSCHL_K_1PC13 = '" + O_GROESS_ANSCHL_K_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_R62_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_HILFS_KLKR60_1PC13				(R60) Hilfsanschlusskasten (klein)			<== Checkbox						<== aktuell ausgeblendet
    // ################################################################################################################
    /*	n.n.	O_HILFS_KLKR60_1PC13				(R60) Hilfsanschlusskasten (klein)			<== aktuell ausgeblendet
        VT_1PC13_M00057	Opt. R60+BG
            O_HILFS_KLKR60_1PC13	Hilfsanschlusskasten (klein)
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    ECL_DeselectAttribute("O_HILFS_KLKR60_1PC13");
    ECL_DeactivateAttribute("O_HILFS_KLKR60_1PC13");

    // ################################################################################################################

    // ################################################################################################################
    // O_KABELEINFPLATTE_1PC13				Kabeleinführungplatte			<== aktuell nur NON und Y61  todo checken!
    // ################################################################################################################
    /*	
    O_KABELEINFPLATTE_1PC13				Kabeleinführungplatte			<== aktuell nur NON und Y61  todo checken!
        VT_1PC13_M00051	Opt.Y73_Y61+BG
            O_KABELEINFPLATTE_1PC13	Kabeleinführungplatte
            H_BAUGROESSE_DYN_1PC13	Baugröße
        
    OE_KABELEINFPLATTE_1PC13			Bestellangaben:
    
    Wenn eine Eingabe im Textfeld gemacht wird, wird die Option verdeckt gesetzt, wenn Textfeld leer, dann Option 'NON'
    */

    var sTargetAttribute = "O_KABELEINFPLATTE_1PC13";

    var sTable = "VT_1PC13_M00051" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_KABELEINFPLATTE_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------

    if (ECL_ValueSelected("O_KABELEINFPLATTE_1PC13", "Y61")) {
        ECL_ActivateAttribute("OE_KABELEINFPLATTE_1PC13");
    } else {
        ECL_ResetAttribute("OE_KABELEINFPLATTE_1PC13");
        ECL_DeactivateAttribute("OE_KABELEINFPLATTE_1PC13");
    }

    if (strchangedAttribute == "OE_KABELEINFPLATTE_1PC13") {
        var sValueNorm = normalizeOE_Attribute("OE_KABELEINFPLATTE_1PC13");
        /*if (sValueNorm == ""){
            ECL_SelectValue("O_KABELEINFPLATTE_1PC13", "NON");
        }else{
            ECL_SelectValue("O_KABELEINFPLATTE_1PC13", "Y61");
        }*/
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_SCHALTUNG_AUSLIEF_1PC13		Schaltung Auslieferung
    // ################################################################################################################

    // Kein Regelwerk vorhanden
    // ################################################################################################################


    // ################################################################################################################

    /*
    Geber, Bremse, Rücklaufsperre
        O_DREHIMPULSGEBER_1PC13				Drehimpulsgeber
            VT_1PC13_M00040	Geber+BG
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                H_BAUGROESSE_DYN_1PC13	Baugröße
                
            VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                O_BREMSEVORB_1PC13	Bremse vorbereitet
                
        OE_GEBER_DREHZAHL_1PC13				Drehzahl (1/min):
        
    */
    // ################################################################################################################
    // O_DREHIMPULSGEBER_1PC13				Drehimpulsgeber
    // ################################################################################################################
    /*	VT_1PC13_M00040	Geber+BG
            O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    var sTargetAttribute = "O_DREHIMPULSGEBER_1PC13";

    var sTable = "VT_1PC13_M00040" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    /* 	VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
            H_KUEHLART_1PC13	Kühlart (hmk)
            O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            O_BREMSEVORB_1PC13	Bremse vorbereitet
    */

    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");
    var O_BREMSEVORB_1PC13 = ECL_GetValue("O_BREMSEVORB_1PC13");

    var sTable = "VT_1PC13_M00161" + sDB_Suffix;
    var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        "O_BREMSEVORB_1PC13 = '" + O_BREMSEVORB_1PC13 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_GEBER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    // OE_GEBER_DREHZAHL_1PC13 bei Y74,Y76 einblenden
    var O_DREHIMPULSGEBER_1PC13 = ECL_GetValue("O_DREHIMPULSGEBER_1PC13");

    if (O_DREHIMPULSGEBER_1PC13 == "Y74" || O_DREHIMPULSGEBER_1PC13 == "Y76") {
        ECL_ActivateAttribute("OE_GEBER_DREHZAHL_1PC13");
    } else {
        //ECL_ResetAttribute("OE_GEBER_DREHZAHL_1PC13");
        ECL_DeactivateAttribute("OE_GEBER_DREHZAHL_1PC13");
    }
    // ################################################################################################################

    /*	
        O_ANBAU_BREMSE_1PC13				Anbau Bremse
        ==> Über Kontext gesteuert, ob mit oder ohne Bremse, Wert auswählbar
            VT_1PC13_M00059	Bremsendaten			<== PMD, n.n.
        A	VT_1PC13_M00149	Bremse->BG->Kühlart
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                H_BAUGROESSE_DYN_1PC13	Baugröße
                H_KUEHLART_1PC13	Kühlart (hmk)
                
        B	VT_1PC13_M00152	L23->Bremse->BG
                O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung			<== schränkt nicht ein, nur umgekehrt
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                H_BAUGROESSE_DYN_1PC13	Baugröße
                
        C	VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                O_BREMSEVORB_1PC13	Bremse vorbereitet
                
        nn	VT_1PC13_M00189	Shaft seal NDE side
                HMK_BG_1PC13	BG
                IN_KUEHLART_1PC13	Kühlart
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                I_WELLENDICHTRING_NE_1PC13	Wellendichtring auf NDE-Seite
            INFERENCES:
                c.I_WELLENDICHTRING_NE_1PC13
    
                
        D	VT_1PC13_M00205	Brake + FS + min temp
                IN_WUNSCH_BAUGROESSE_1PC13	Baugröße
                IN_UMGEB_TEMP_MIN_1PC13	Kühlmitteltemperatur minimal
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                
            
            // Ausblenden, wenn keine Bremse gewählt
            O_BREMSSPANNUNG_1PC13				Bremsenanschlussspannung
            O_BREMSEVORB_1PC13					Bremse vorbereitet
            O_BREMSE_GELUEFTET_1PC13			(F26) Bremse Microswitch on/off (Bremse gelüftet)
            O_BREMSE_HEIZUNG_1PC13				(F27) Stillstandheizung für Brake AC 230 V
            O_BREMSE_HEBEL_1PC13				(F50) Mechanische Handlüftung der Bremse mit Betätigungshebel
            O_BREMSE_LUFTWACHE_1PC13			(F51) Bremse Microswitch für Luftspaltüberwachung
    */
    // ################################################################################################################
    // O_ANBAU_BREMSE_1PC13				Anbau Bremse
    // ################################################################################################################
    /*	A VT_1PC13_M00149	Bremse->BG->Kühlart
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            H_BAUGROESSE_DYN_1PC13	Baugröße
            H_KUEHLART_1PC13	Kühlart (hmk)
    */

    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (strwithBrake == "1") {

        // ----------------------------------------------------------------------------------------
        ECL_ActivateAllAttributeValues("O_ANBAU_BREMSE_1PC13");
        ECL_DeactivateValue("O_ANBAU_BREMSE_1PC13", "NON");
        ExecSetStandardifValueEmpty("O_ANBAU_BREMSE_1PC13", "");
        // ----------------------------------------------------------------------------------------

        var sTargetAttribute = "O_ANBAU_BREMSE_1PC13";

        var sTable = "VT_1PC13_M00149" + sDB_Suffix;
        var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
            "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1PC13___PLVT_BREMSE_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------
        /* B VT_1PC13_M00152	L23->Bremse->BG
                O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung			<== schränkt nicht ein, nur umgekehrt
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                H_BAUGROESSE_DYN_1PC13	Baugröße
        */
        //var O_L23_NACHSCHMIER_1PC13 = ECL_GetValue("O_L23_NACHSCHMIER_1PC13");

        var sTable = "VT_1PC13_M00152" + sDB_Suffix;
        var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1PC13___PLVT_BREMSE_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------
        /* C VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
                O_BREMSEVORB_1PC13	Bremse vorbereitet			<== unidirektionale Einschränkung nur auf O_BREMSEVORB_1PC13
        */
        var O_DREHIMPULSGEBER_1PC13 = ECL_GetValue("O_DREHIMPULSGEBER_1PC13");

        var sTable = "VT_1PC13_M00161" + sDB_Suffix;
        var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
            "O_DREHIMPULSGEBER_1PC13 = '" + O_DREHIMPULSGEBER_1PC13 + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1PC13___PLVT_BREMSE_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------
        /* D VT_1PC13_M00205	Brake + FS + min temp
                IN_WUNSCH_BAUGROESSE_1PC13	Baugröße
                IN_UMGEB_TEMP_MIN_1PC13	Kühlmitteltemperatur minimal
                O_ANBAU_BREMSE_1PC13	Anbau Bremse
        */
        var IN_UMGEB_TEMP_MIN_1PC13 = ECL_GetValue("IN_UMGEB_TEMP_MIN_1PC13");

        var sTable = "VT_1PC13_M00205" + sDB_Suffix;
        var sWhere = "IN_WUNSCH_BAUGROESSE_1PC13 = '" + IN_WUNSCH_BAUGROESSE_1PC13 + "' AND " +
            "IN_UMGEB_TEMP_MIN_1PC13 = '" + IN_UMGEB_TEMP_MIN_1PC13 + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1PC13___PLVT_BREMSE_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################
    } else {
        // ----------------------------------------------------------------------------------------
        ECL_DeactivateAllAttributeValues("O_ANBAU_BREMSE_1PC13");
        ECL_ActivateValue("O_ANBAU_BREMSE_1PC13", "NON");
        ECL_SetValue("O_ANBAU_BREMSE_1PC13", "NON");
        // ----------------------------------------------------------------------------------------
    }

    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");

    /* Ausblenden, wenn keine Bremse gewählt
    O_BREMSSPANNUNG_1PC13				Bremsenanschlussspannung
        ==> keine Einschränkungen
    O_BREMSEVORB_1PC13					Bremse vorbereitet
        VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
            
    O_BREMSE_GELUEFTET_1PC13			(F26) Bremse Microswitch on/off (Bremse gelüftet)
        ==> keine Einschränkungen
    O_BREMSE_HEIZUNG_1PC13				(F27) Stillstandheizung für Brake AC 230 V
        ==> keine Einschränkungen
    O_BREMSE_HEBEL_1PC13				(F50) Mechanische Handlüftung der Bremse mit Betätigungshebel
        ==> keine Einschränkungen
    O_BREMSE_LUFTWACHE_1PC13			(F51) Bremse Microswitch für Luftspaltüberwachung
        ==> keine Einschränkungen
    */
    if (O_ANBAU_BREMSE_1PC13 == "NON") {
        ECL_DeactivateAllAttributeValues("O_BREMSSPANNUNG_1PC13");
        ECL_ActivateValue("O_BREMSSPANNUNG_1PC13", "NON");
        ECL_SelectValue("O_BREMSSPANNUNG_1PC13", "NON");
        ECL_DeactivateAttribute("O_BREMSSPANNUNG_1PC13");

        ECL_SelectValue("O_BREMSEVORB_1PC13", "NON");
        ECL_DeactivateAttribute("O_BREMSEVORB_1PC13");

        ECL_DeselectAttribute("O_BREMSE_GELUEFTET_1PC13");
        ECL_DeactivateAttribute("O_BREMSE_GELUEFTET_1PC13");

        ECL_DeselectAttribute("O_BREMSE_HEIZUNG_1PC13");
        ECL_DeactivateAttribute("O_BREMSE_HEIZUNG_1PC13");

        ECL_DeselectAttribute("O_BREMSE_HEBEL_1PC13");
        ECL_DeactivateAttribute("O_BREMSE_HEBEL_1PC13");

        ECL_DeselectAttribute("O_BREMSE_LUFTWACHE_1PC13");
        ECL_DeactivateAttribute("O_BREMSE_LUFTWACHE_1PC13");

    } else {
        ECL_ActivateAttribute("O_BREMSSPANNUNG_1PC13");
        ECL_ActivateAllAttributeValues("O_BREMSSPANNUNG_1PC13");
        ECL_DeactivateValue("O_BREMSSPANNUNG_1PC13", "NON");
        ExecSetStandardifValueEmpty("O_BREMSSPANNUNG_1PC13", "");

        ECL_ActivateAttribute("O_BREMSEVORB_1PC13");

        ECL_ActivateAttribute("O_BREMSE_GELUEFTET_1PC13");

        ECL_ActivateAttribute("O_BREMSE_HEIZUNG_1PC13");

        ECL_ActivateAttribute("O_BREMSE_HEBEL_1PC13");

        ECL_ActivateAttribute("O_BREMSE_LUFTWACHE_1PC13");

        // ----------------------------------------------------------------------------------------
        /* C VT_1PC13_M00161	Bremse->Vorb->Geber->Kühlart
            H_KUEHLART_1PC13	Kühlart (hmk)
            O_DREHIMPULSGEBER_1PC13	Drehimpulsgeber
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            O_BREMSEVORB_1PC13	Bremse vorbereitet			<== unidirektionale Einschränkung nur auf O_BREMSEVORB_1PC13
        */
        var sTargetAttribute = "O_BREMSEVORB_1PC13";

        var O_DREHIMPULSGEBER_1PC13 = ECL_GetValue("O_DREHIMPULSGEBER_1PC13");

        var sTable = "VT_1PC13_M00161" + sDB_Suffix;
        var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
            "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
            "O_DREHIMPULSGEBER_1PC13 = '" + O_DREHIMPULSGEBER_1PC13 + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1PC13___PLVT_BREMSEVORB_NO_DB_RESULT";
            return strError;
        }
        // ----------------------------------------------------------------------------------------

    }
    // ################################################################################################################

    // ################################################################################################################
    // Mechanische Ausführungen:
    // ################################################################################################################

    // ################################################################################################################
    // O_SCHUTZDACH_H00_1PC13		(H00) Schutzdach	
    // ################################################################################################################
    /* nur bei Bauform C,G	(laut Katalog)	nicht bei Kühlart 410 VT183
    VT VT_1PC13_M00183	IC --> H00
        IN_KUEHLART_1PC13, O_SCHUTZDACH_H00_1PC13
    */
    var sDTKAttribute = "O_SCHUTZDACH_H00_1PC13";
    var sCB_Attribute = "O_SCHUTZDACH_H00_1PC13";
    var sKAG = "H00";
    var sNON_Value = "NON";

    var IN_KUEHLART_1PC13 = ECL_GetValue("IN_KUEHLART_1PC13");

    var sTable = "VT_1PC13_M00183" + sDB_Suffix;
    var sWhere = "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_SCHUTZDACH_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    // ################################################################################################################
    // O_FUESSE_1PC13	Füße angeschraubt (statt angegossen) (H01)
    // ################################################################################################################
    /*	VT_1PC13_M00209	BF-H01-L17-L18
            IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13
    */
    var sDTKAttribute = "O_FUESSE_1PC13";
    var sCB_Attribute = "O_FUESSE_1PC13";
    var sKAG = "H01";
    var sNON_Value = "NON";

    //var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");
    var O_SCHILD_L18_1PC13 = "NON";
    if (ECL_ValueSelected("O_SCHILD_L18_1PC13", "T")) {
        O_SCHILD_L18_1PC13 = "L18";
    }

    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sWhere = "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_H01_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // O_FUESSE_L17_1PC13	Füße in Werkstoff GGG40, angeschraubt
    // ################################################################################################################
    /*	VT_1PC13_M00085	Opt. L17 -> BG
            O_FUESSE_L17_1PC13
            H_BAUGROESSE_DYN_1PC13
    
        VT_1PC13_M00209	BF-H01-L17-L18
            IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13
    */

    var O_FUESSE_1PC13 = "NON";
    if (ECL_ValueSelected("O_FUESSE_1PC13", "T")) {
        O_FUESSE_1PC13 = "H01";
    }
    var sDTKAttribute = "O_FUESSE_L17_1PC13";
    var sCB_Attribute = "O_FUESSE_L17_1PC13";
    var sKAG = "L17";
    var sNON_Value = "NON";

    //var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");

    var sTable = "VT_1PC13_M00085" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L17_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------------------------------
    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sWhere = "O_FUESSE_1PC13 = '" + O_FUESSE_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L17_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_SCHILD_L18_1PC13		Lagerschild DE in GGG40 für Aufstellung IM B5
    // ################################################################################################################
    /*  VT_1PC13_M00209	BF-H01-L17-L18
            IN_BAUFORM_1PC13	O_FUESSE_1PC13	O_FUESSE_L17_1PC13 (untergeordnet)  O_SCHILD_L18_1PC13
    */

    var sDTKAttribute = "O_SCHILD_L18_1PC13";
    var sCB_Attribute = "O_SCHILD_L18_1PC13";
    var sKAG = "L18";
    var sNON_Value = "NON";

    var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");

    var O_FUESSE_L17_1PC13 = "NON";
    if (ECL_ValueSelected("O_FUESSE_L17_1PC13", "T")) {
        O_FUESSE_L17_1PC13 = "L17";
    }
    var sTable = "VT_1PC13_M00209" + sDB_Suffix;
    var sWhere = "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "' AND " +
        "O_FUESSE_1PC13 = '" + O_FUESSE_1PC13 + "' AND " +
        "O_FUESSE_L17_1PC13 = '" + O_FUESSE_L17_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L18_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    var O_SCHILD_L18_1PC13 = "NON";
    if (ECL_ValueSelected("O_SCHILD_L18_1PC13", "T")) {
        O_SCHILD_L18_1PC13 = "L18";
    }

    // ################################################################################################################
    /*	O_SCHUTZART_1PC13					Schutzart			(BG keine Einschränkung VT30 nn)
            VT_1PC13_M00030	Opt H22_bg
                HMK_BG_1PC13	BG
                O_SCHUTZART_1PC13	Schutzart
                
            VT_1PC13_M00190	Datasheet - IP protection		nn
            
        O_KWL_1PC13							Kondenswasserlöcher						immer Ja (Standard)
        O_ROSTFREI_SCHRAUB_1PC13			Nicht rostende Schrauben (außen)		immer Ja (Standard)
            sperren ohne if		c.O_ROSTFREI_SCHRAUB_1PC13 in ('STD'),

    */
    // ################################################################################################################
    // O_SCHUTZART_1PC13					Schutzart			(BG keine Einschränkung VT30 nn)
    // ################################################################################################################
    /* VT_1PC13_M00030	Opt H22_bg
            HMK_BG_1PC13	BG
            O_SCHUTZART_1PC13	Schutzart
    */
    var sTargetAttribute = "O_SCHUTZART_1PC13";

    var sTable = "VT_1PC13_M00030" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_KWL_1PC13							Kondenswasserlöcher			immer Ja (Standard)
    // ################################################################################################################
    /*immer Ja (Standard)
    */
    // ################################################################################################################

    // ################################################################################################################
    // O_ROSTFREI_SCHRAUB_1PC13			Nicht rostende Schrauben (außen)		immer Ja (Standard)
    // ################################################################################################################
    /*sperren ohne if		c.O_ROSTFREI_SCHRAUB_1PC13 in ('STD'),
    */
    ECL_DeactivateAllAttributeValues("O_ROSTFREI_SCHRAUB_1PC13");
    ECL_ActivateValue("O_ROSTFREI_SCHRAUB_1PC13", "STD");
    ECL_SelectValue("O_ROSTFREI_SCHRAUB_1PC13", "STD");
    // ################################################################################################################


    // ################################################################################################################
    // Farbanstrich
    // ################################################################################################################
    /*
    Farbanstrich	
        O_ANSTRICH_1PC13					Anstrich
            VT_1PC13_M00207	Anstrich PMD
                IN_KUEHLART_1PC13	IN_BAUGROESSE_1PC13	O_ANSTRICH_1PC13	PMD_ABR397_001_000_1PC13
	
        H_RAL_FARBE_1PC13					RAL-Farbton
        H_KAG_FARBE_1PC13					KAG Farben
        
        H_KAG_FARBE_1PC13	H_RAL_FARBE_1PC13
        Restrictions:
            c.H_KAG_FARBE_1PC13 eq 'NON'
            if c.H_RAL_FARBE_1PC13 eq 'RAL7030',
            *
            c.H_KAG_FARBE_1PC13 eq 'Y53'
            if c.H_RAL_FARBE_1PC13 in
            ('RAL1015','RAL3000','RAL5002','RAL5009','RAL5010',
             'RAL5012','RAL5015','RAL6011','RAL7001','RAL7011',
             'RAL7016','RAL7031','RAL7032','RAL7035','RAL7037',
             'RAL8012','RAL9005','RAL9010','RALY53'),
            c.H_KAG_FARBE_1PC13 eq 'Y56'
            if c.H_RAL_FARBE_1PC13 in
            ('RAL1013','RAL2004','RAL3002','RAL3012','RAL3020',
             'RAL5000','RAL5003','RAL5005','RAL5007',
             'RAL5014','RAL5017','RAL5018','RAL5019','RAL5021',
             'RAL5024','RAL6000','RAL6002','RAL6010',
             'RAL6018','RAL6020','RAL6021','RAL6032','RAL7005',
             'RAL7012','RAL7021','RAL7022','RAL7024',
             'RAL7038','RAL7042','RAL7045','RAL9001','RAL9002',
             'RAL9003','RAL9006','RAL9007','RAL9016','RAL9018',
             'RAL9023','RALY56'),
            c.H_KAG_FARBE_1PC13 eq 'Y66'
            if not c.H_RAL_FARBE_1PC13 in
            ('RAL7030',
             'RAL1015','RAL3000','RAL5002','RAL5009','RAL5010',
             'RAL5012','RAL5015','RAL6011','RAL7001','RAL7011',
             'RAL7016','RAL7031','RAL7032','RAL7035','RAL7037',
             'RAL8012','RAL9005','RAL9010','RALY53','RALY56',
             'RAL1013','RAL2004','RAL3002','RAL3012','RAL3020',
             'RAL5000','RAL5003','RAL5005','RAL5007',
             'RAL5014','RAL5017','RAL5018','RAL5019','RAL5021',
             'RAL5024','RAL6000','RAL6002','RAL6010',
             'RAL6018','RAL6020','RAL6021','RAL6032','RAL7005',
             'RAL7012','RAL7021','RAL7022','RAL7024',
             'RAL7038','RAL7042','RAL7045','RAL9001','RAL9002',
             'RAL9003','RAL9006','RAL9007','RAL9016','RAL9018',
             'RAL9023')
        Inferences:
            c.H_KAG_FARBE_1PC13
    */

    // VT_1PC13_M00207	Anstrich PMD
    //	IN_KUEHLART_1PC13	IN_BAUGROESSE_1PC13	O_ANSTRICH_1PC13	PMD_ABR397_001_000_1PC13
    var sTargetAttribute = "O_ANSTRICH_1PC13";

    var sTable = "VT_1PC13_M00207" + sDB_Suffix;
    var sWhere = "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_ANSTRICH_NO_DB_RESULT";
        return strError;
    }


    var H_RAL_FARBE_1PC13 = ECL_GetValue("H_RAL_FARBE_1PC13");

    if (H_RAL_FARBE_1PC13 == "RAL7030") {
        var H_KAG_FARBE_1PC13 = "NON";
        ECL_DeactivateAllAttributeValues("H_KAG_FARBE_1PC13");
        ECL_ActivateValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
        ECL_SelectValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
    } else {
        // Y53
        var aRAL_FARBE_Y53 = ['RAL1015', 'RAL3000', 'RAL5002', 'RAL5009', 'RAL5010',
            'RAL5012', 'RAL5015', 'RAL6011', 'RAL7001', 'RAL7011',
            'RAL7016', 'RAL7031', 'RAL7032', 'RAL7035', 'RAL7037',
            'RAL8012', 'RAL9005', 'RAL9010', 'RALY53'];

        if (aRAL_FARBE_Y53.indexOf(H_RAL_FARBE_1PC13) > -1) {
            var H_KAG_FARBE_1PC13 = "Y53";
            ECL_DeactivateAllAttributeValues("H_KAG_FARBE_1PC13");
            ECL_ActivateValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
            ECL_SelectValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
        }
        // Y56
        var aRAL_FARBE_Y56 = ['RAL1013', 'RAL2004', 'RAL3002', 'RAL3012', 'RAL3020',
            'RAL5000', 'RAL5003', 'RAL5005', 'RAL5007',
            'RAL5014', 'RAL5017', 'RAL5018', 'RAL5019', 'RAL5021',
            'RAL5024', 'RAL6000', 'RAL6002', 'RAL6010',
            'RAL6018', 'RAL6020', 'RAL6021', 'RAL6032', 'RAL7005',
            'RAL7012', 'RAL7021', 'RAL7022', 'RAL7024',
            'RAL7038', 'RAL7042', 'RAL7045', 'RAL9001', 'RAL9002',
            'RAL9003', 'RAL9006', 'RAL9007', 'RAL9016', 'RAL9018',
            'RAL9023', 'RALY56'];

        if (aRAL_FARBE_Y56.indexOf(H_RAL_FARBE_1PC13) > -1) {
            var H_KAG_FARBE_1PC13 = "Y56";
            ECL_DeactivateAllAttributeValues("H_KAG_FARBE_1PC13");
            ECL_ActivateValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
            ECL_SelectValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
        }
        // Y66
        var aRAL_FARBE_Y66 = ['RAL7030',
            'RAL1015', 'RAL3000', 'RAL5002', 'RAL5009', 'RAL5010',
            'RAL5012', 'RAL5015', 'RAL6011', 'RAL7001', 'RAL7011',
            'RAL7016', 'RAL7031', 'RAL7032', 'RAL7035', 'RAL7037',
            'RAL8012', 'RAL9005', 'RAL9010', 'RALY53', 'RALY56',
            'RAL1013', 'RAL2004', 'RAL3002', 'RAL3012', 'RAL3020',
            'RAL5000', 'RAL5003', 'RAL5005', 'RAL5007',
            'RAL5014', 'RAL5017', 'RAL5018', 'RAL5019', 'RAL5021',
            'RAL5024', 'RAL6000', 'RAL6002', 'RAL6010',
            'RAL6018', 'RAL6020', 'RAL6021', 'RAL6032', 'RAL7005',
            'RAL7012', 'RAL7021', 'RAL7022', 'RAL7024',
            'RAL7038', 'RAL7042', 'RAL7045', 'RAL9001', 'RAL9002',
            'RAL9003', 'RAL9006', 'RAL9007', 'RAL9016', 'RAL9018',
            'RAL9023'];

        if (aRAL_FARBE_Y56.indexOf(H_RAL_FARBE_1PC13) < 0) {
            var H_KAG_FARBE_1PC13 = "Y66";
            ECL_DeactivateAllAttributeValues("H_KAG_FARBE_1PC13");
            ECL_ActivateValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
            ECL_SelectValue("H_KAG_FARBE_1PC13", H_KAG_FARBE_1PC13);
        }
    }

    // ################################################################################################################
    /* Zusätzliche Vorschriften
        
        O_UL_D31_1PC13						(D31) Ausführung nach UL mit „Recognition Mark“
            VT_1PC13_M00114	R01 <-> D31/D40
                H_KABELKANAL_1PC13	Vergießen /.../Harz
                O_UL_D31_1PC13	Ausführung /.../Mark“
                O_CSA_D40_1PC13	Kanadische Vorschriften CSA
                
            VT_1PC13_M00145	Motorschutz->D31/D40
                IN_MOTORSCHUTZ_1PC13	Motorschutz
                O_UL_D31_1PC13	Ausführung /.../Mark“
                O_CSA_D40_1PC13	Kanadische Vorschriften CSA
                
            VT_1PC13_M00184	KMT --> D31
                IN_KMT_1PC13	Kühlmitteltemperatur maximal
                O_UL_D31_1PC13	Ausführung /.../Mark“
                
        O_CSA_D40_1PC13						(D40) Kanadische Vorschriften CSA
            VT_1PC13_M00114	R01 <-> D31/D40
            VT_1PC13_M00145	Motorschutz->D31/D40
            
        O_D47_1PC13							(D47) TR CU Produktsicherheitszertifikat EAC für die eurasische Zollunion
            ==> keine VT-Einschränkung
    */
    // ################################################################################################################
    // O_UL_D31_1PC13						(D31) Ausführung nach UL mit „Recognition Mark“
    // ################################################################################################################
    /* VT_1PC13_M00114	R01 <-> D31/D40
            H_KABELKANAL_1PC13	Vergießen /.../Harz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
            
        VT_1PC13_M00145	Motorschutz->D31/D40
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
            
        VT_1PC13_M00184	KMT --> D31
            IN_KMT_1PC13	Kühlmitteltemperatur maximal
            O_UL_D31_1PC13	Ausführung /.../Mark“
    */

    var sDTKAttribute = "O_UL_D31_1PC13";
    var sCB_Attribute = "O_UL_D31_1PC13";
    var sKAG = "D31";
    var sNON_Value = "NON";

    var H_KABELKANAL_1PC13 = "NON";
    if (ECL_ValueSelected("H_KABELKANAL_1PC13", "T")) {
        H_KABELKANAL_1PC13 = "R01";
    }

    var O_CSA_D40_1PC13 = "NON";
    if (ECL_ValueSelected("O_CSA_D40_1PC13", "T")) {
        O_CSA_D40_1PC13 = "D40";
    }


    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sWhere = "H_KABELKANAL_1PC13 = '" + H_KABELKANAL_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_D31_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00145" + sDB_Suffix;
    var sWhere = "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "' AND " +
        "O_CSA_D40_1PC13 = '" + O_CSA_D40_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_D31_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var sTable = "VT_1PC13_M00184" + sDB_Suffix;
    var sWhere = "IN_KMT_1PC13 = '" + IN_KMT_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_D31_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_CSA_D40_1PC13						(D40) Kanadische Vorschriften CSA
    // ################################################################################################################
    /* VT_1PC13_M00114	R01 <-> D31/D40
            H_KABELKANAL_1PC13	Vergießen /.../Harz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
            
        VT_1PC13_M00145	Motorschutz->D31/D40
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            O_UL_D31_1PC13	Ausführung /.../Mark“
            O_CSA_D40_1PC13	Kanadische Vorschriften CSA
    */

    var sDTKAttribute = "O_CSA_D40_1PC13";
    var sCB_Attribute = "O_CSA_D40_1PC13";
    var sKAG = "D40";
    var sNON_Value = "NON";

    var H_KABELKANAL_1PC13 = "NON";
    if (ECL_ValueSelected("H_KABELKANAL_1PC13", "T")) {
        H_KABELKANAL_1PC13 = "R01";
    }
    var O_UL_D31_1PC13 = "NON";
    if (ECL_ValueSelected("O_UL_D31_1PC13", "T")) {
        O_UL_D31_1PC13 = "D31";
    }

    var sTable = "VT_1PC13_M00114" + sDB_Suffix;
    var sWhere = "H_KABELKANAL_1PC13 = '" + H_KABELKANAL_1PC13 + "' AND " +
        "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_D40_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var IN_MOTORSCHUTZ_1PC13 = ECL_GetValue("IN_MOTORSCHUTZ_1PC13");

    var sTable = "VT_1PC13_M00145" + sDB_Suffix;
    var sWhere = "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "' AND " +
        "O_UL_D31_1PC13 = '" + O_UL_D31_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_D40_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################

    // ################################################################################################################
    // Dokumentation
    // ################################################################################################################
    /*	O_B02_ABNAHME_1PC13			(B02) Abnahmeprüfzeugnis 3.1 nach EN 10204
            ==> keine Einschränkung
        O_B54_PAINT_MEAS_1PC13		(B54) Messung der Lackdicke des Motor					Checkbox
            ==> keine Einschränkung
        O_AUFTR_MASSBL_1PC13		(B61) Dokument - Auftragsmaßbild
            ==> keine VT-Einschränkung
        O_PHOTO_DOC_1PC13			Fotodokumentation
            ==> keine VT-Einschränkung
    */
    // ################################################################################################################


    // ################################################################################################################
    // Heizung und Belüftung
    // ################################################################################################################
    /*
        H_LUEFTERHAUBE_UI_1PC13				Lüfterhaube			Info-Attribut über Standardwert
        O_LUEFTERHAUBE_1PC13				Lüfterhaube			KAG									Checkbox
        
            VT_1PC13_M00163	Kühlart->F74_UI->F74
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_LUEFTERHAUBE_1PC13	Lüfterhaube
                H_LUEFTERHAUBE_UI_1PC13	Lüfterhaube
            
        
        O_MATAUSSENLUEFT_1PC13				Metall-Außenlüfter
            VT_1PC13_M00125	Kühlart->F76->BG
                H_KUEHLART_1PC13	Kühlart (hmk)
                O_MATAUSSENLUEFT_1PC13	Metall-Außenlüfter
                H_BAUGROESSE_DYN_1PC13	Baugröße
        
        O_STILLSTANDSHEIZUNG_1PC13			Stillstandsheizung
            VT_1PC13_M00167	Stillstandsheizung->PMD				PMD, nn
    */

    // ################################################################################################################
    // O_LUEFTERHAUBE_1PC13				Lüfterhaube			KAG	F74								Checkbox
    // ################################################################################################################
    /* VT_1PC13_M00163	Kühlart->F74_UI->F74
            H_KUEHLART_1PC13	Kühlart (hmk)
            O_LUEFTERHAUBE_1PC13	Lüfterhaube
            H_LUEFTERHAUBE_UI_1PC13	Lüfterhaube
    */
    var sDTKAttribute = "O_LUEFTERHAUBE_1PC13";
    var sCB_Attribute = "O_LUEFTERHAUBE_1PC13";
    var sKAG = "F74";
    var sNON_Value = "NON";

    var sTable = "VT_1PC13_M00163" + sDB_Suffix;
    var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_BELUEFTUNG_F74_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    // H_LUEFTERHAUBE_UI_1PC13		Lüfterhaube			Info-Attribut über Standardwert
    // ################################################################################################################
    /* VT_1PC13_M00163	Kühlart->F74_UI->F74
            H_KUEHLART_1PC13	Kühlart (hmk)
            O_LUEFTERHAUBE_1PC13	Lüfterhaube
            H_LUEFTERHAUBE_UI_1PC13	Lüfterhaube
    */
    var sTargetAttribute = "H_LUEFTERHAUBE_UI_1PC13";

    var O_LUEFTERHAUBE_1PC13 = "NON";
    if (ECL_ValueSelected("O_LUEFTERHAUBE_1PC13", "T")) {
        O_LUEFTERHAUBE_1PC13 = "F74";
    }

    var sTable = "VT_1PC13_M00163" + sDB_Suffix;
    var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "O_LUEFTERHAUBE_1PC13 = '" + O_LUEFTERHAUBE_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_BELUEFTUNG_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // O_MATAUSSENLUEFT_1PC13				Metall-Außenlüfter			F76				Checkbox
    // ################################################################################################################
    /* 
        VT_1PC13_M00125	Kühlart->F76->BG
            H_KUEHLART_1PC13	Kühlart (hmk)
            O_MATAUSSENLUEFT_1PC13	Metall-Außenlüfter
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    var sDTKAttribute = "O_MATAUSSENLUEFT_1PC13";
    var sCB_Attribute = "O_MATAUSSENLUEFT_1PC13";
    var sKAG = "F76";
    var sNON_Value = "NON";

    var sTable = "VT_1PC13_M00125" + sDB_Suffix;
    var sWhere = "H_KUEHLART_1PC13 = '" + H_KUEHLART_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_MATAUSSENLUEFT_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################


    // ################################################################################################################
    // Welle und Läufer
    // ################################################################################################################
    /* O_WELLE_NIROSTA_1PC13				(L06) Standardwelle aus nichtrostendem Stahl
        ==> keine Einschränkung
    */
    // ################################################################################################################


    // ################################################################################################################
    // Beschilderung
    // ################################################################################################################
    /*
        O_ZUSATZSCHILD_1PC13				(Y82) Zusatzschild mit Bestellangaben
        OE_ZUSATZSCHILD_TA_1PC13			Bestellangaben:
            ==> keine Einschränkung
        
        O_NIROSTA_SCHILD_1PC13	Leistungsschild, nicht rostender Stahl
            ==> keine Einschränkung, NUR STD ("sperren ohne if"	c.O_NIROSTA_SCHILD_1PC13 in ('STD'))
    */
    // ################################################################################################################
    // O_ZUSATZSCHILD_1PC13				(Y82) Zusatzschild mit Bestellangaben
    // ################################################################################################################
    if (ECL_ValueEnabled("O_ZUSATZSCHILD_1PC13", "Y82")) {
        ECL_ActivateAttribute("OE_ZUSATZSCHILD_TA_1PC13");
    } else {
        ECL_DeactivateAttribute("OE_ZUSATZSCHILD_TA_1PC13");
    }

    if (strchangedAttribute == "OE_ZUSATZSCHILD_TA_1PC13") {
        var sValueNorm = normalizeOE_Attribute("OE_ZUSATZSCHILD_TA_1PC13");
        if (sValueNorm == "") {
            ECL_SelectValue("O_ZUSATZSCHILD_1PC13", "NON");
        } else {
            ECL_SelectValue("O_ZUSATZSCHILD_1PC13", "Y82");
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // O_NIROSTA_SCHILD_1PC13	Leistungsschild, nicht rostender Stahl
    // ################################################################################################################
    /*
        KAG: NON, STD, M11
        ==> keine Einschränkung, NUR STD ("sperren ohne if"	c.O_NIROSTA_SCHILD_1PC13 in ('STD'))
    */
    ECL_DeactivateAllAttributeValues("O_NIROSTA_SCHILD_1PC13");
    ECL_ActivateValue("O_NIROSTA_SCHILD_1PC13", "STD");
    ECL_SelectValue("O_NIROSTA_SCHILD_1PC13", "STD");
    // ################################################################################################################

    // ################################################################################################################


    // ################################################################################################################
    // Lagerung
    // ################################################################################################################
    /*
    A	O_L23_NACHSCHMIER_1PC13				Nachschmiereinrichtung	(wenn Auswahl)
            VT_1PC13_M00152	L23->Bremse->BG
            VT_1PC13_M00182	L23->L23_UI->BG
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
            
        H_L23_UI_NACHSCHMIER_1PC13			Nachschmiereinrichtung	(wenn Std)	
            VT_1PC13_M00182	L23->L23_UI->BG
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
        
        // ----------------------------------------------------------------------------------------
    B	H_L25_UI_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
                
        O_L25_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
                
        // ----------------------------------------------------------------------------------------
    C	I_WELLENDICHTRING_1PC13				Wellendichtring auf DE-Seite	(Std. Info)
            VT_1PC13_M00187	Shaft seal DE side
                
        O_RAD_DICHTRING_1PC13	(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar
            VT_1PC13_M00083	Radialdichtung rel. Bauform
            VT_1PC13_M00187	Shaft seal DE side
                
        // ----------------------------------------------------------------------------------------
    D	I_WELLENDICHTRING_NE_1PC13			Wellendichtring auf NDE-Seite	(Std. Info)
            VT_1PC13_M00189	Shaft seal NDE side
            
        // ----------------------------------------------------------------------------------------
    E	O_LAGERISOLIER_DE_1PC13				(L50) Lagerisolierung DE (AS)
            VT_1PC13_M00045	Opt.L50+BG
            
        // ----------------------------------------------------------------------------------------
    F	H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)
            VT_1PC13_M00154	L51->L51_UI->BG
            
        O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)
            VT_1PC13_M00154	L51->L51_UI->BG
            
        // ----------------------------------------------------------------------------------------
        ???	O_LAGERTHERM_1PC13	Lagerthermometer
            Keine Logik vorhanden
    */
    // ################################################################################################################
    // A O_L23_NACHSCHMIER_1PC13				Nachschmiereinrichtung	(wenn Auswahl)
    // ################################################################################################################
    /*
    O_L23_NACHSCHMIER_1PC13				Nachschmiereinrichtung	(wenn Auswahl)
        VT_1PC13_M00152	L23->Bremse->BG
            O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            H_BAUGROESSE_DYN_1PC13	Baugröße
            
        VT_1PC13_M00182	L23->L23_UI->BG
            O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung
            H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
            H_BAUGROESSE_DYN_1PC13		Baugröße
            
        VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
            HMK_BG_1PC13	BG
            O_SCHILD_L18_1PC13			Lagerschild /.../B5
            H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
            O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung
            H_L25_UI_LAGER_63_1PC13		Sonderlager /.../63
            O_L25_LAGER_63_1PC13		Sonderlager /.../63
            H_BEARING_SELECT_1PC13		Bearing selection

    H_L23_UI_NACHSCHMIER_1PC13			Nachschmiereinrichtung	(wenn Std)	
        VT_1PC13_M00182	L23->L23_UI->BG
        VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    */
    var sTargetAttribute = "O_L23_NACHSCHMIER_1PC13";


    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");

    // VT_1PC13_M00152	L23->Bremse->BG
    var sTable = "VT_1PC13_M00152" + sDB_Suffix;
    var sWhere = "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L23_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    // VT_1PC13_M00182	L23->L23_UI->BG
    var sTable = "VT_1PC13_M00182" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L23_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    // VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection

    var H_L25_UI_LAGER_63_1PC13 = ECL_GetValue("H_L25_UI_LAGER_63_1PC13");

    var O_L25_LAGER_63_1PC13 = "NON";
    if (ECL_ValueSelected("O_L25_LAGER_63_1PC13", "T")) {
        O_L25_LAGER_63_1PC13 = "L25";
    }

    //var H_BEARING_SELECT_1PC13 = ECL_GetValue("H_BEARING_SELECT_1PC13");

    // todo klären, was einschränken soll
    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        //"H_L25_UI_LAGER_63_1PC13 = '" + H_L25_UI_LAGER_63_1PC13 + "' AND " +
        "O_L25_LAGER_63_1PC13 = '" + O_L25_LAGER_63_1PC13 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L23_NO_DB_RESULT";
        return strError;
    }
    // #######################################################################
    /*H_L23_UI_NACHSCHMIER_1PC13			Nachschmiereinrichtung	(wenn Std)	
        VT_1PC13_M00182	L23->L23_UI->BG
        VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    */
    var sTargetAttribute = "H_L23_UI_NACHSCHMIER_1PC13";


    /* VT_1PC13_M00182	L23->L23_UI->BG
            O_L23_NACHSCHMIER_1PC13		Nachschmiereinrichtung
            H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
            H_BAUGROESSE_DYN_1PC13		Baugröße
    */
    var O_L23_NACHSCHMIER_1PC13 = ECL_GetValue("O_L23_NACHSCHMIER_1PC13");

    var sTable = "VT_1PC13_M00182" + sDB_Suffix;
    var sWhere = "O_L23_NACHSCHMIER_1PC13 = '" + O_L23_NACHSCHMIER_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L23_HMK_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    // VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection

    var H_L25_UI_LAGER_63_1PC13 = ECL_GetValue("H_L25_UI_LAGER_63_1PC13");

    var O_L25_LAGER_63_1PC13 = "NON";
    if (ECL_ValueSelected("O_L25_LAGER_63_1PC13", "T")) {
        O_L25_LAGER_63_1PC13 = "L25";
    }
    //var H_BEARING_SELECT_1PC13 = ECL_GetValue("H_BEARING_SELECT_1PC13");

    // todo klären, was einschränken soll
    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        "O_L23_NACHSCHMIER_1PC13 = '" + O_L23_NACHSCHMIER_1PC13 + "' AND " +
        //"H_L25_UI_LAGER_63_1PC13 = '" + H_L25_UI_LAGER_63_1PC13 + "' AND " +
        "O_L25_LAGER_63_1PC13 = '" + O_L25_LAGER_63_1PC13 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L23_HMK_NO_DB_RESULT";
        return strError;
    }
    ECL_DisableAttribute(sTargetAttribute);
    // ################################################################################################################


    // ################################################################################################################
    // B O_L25_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63
    // ################################################################################################################
    /* 
        O_L25_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63	(wenn Auswahl)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
                HMK_BG_1PC13	BG
                O_SCHILD_L18_1PC13	Lagerschild /.../B5
                H_L23_UI_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                O_L23_NACHSCHMIER_1PC13	Nachschmiereinrichtung
                H_L25_UI_LAGER_63_1PC13	Sonderlager /.../63
                O_L25_LAGER_63_1PC13	Sonderlager /.../63
                H_BEARING_SELECT_1PC13	Bearing selection
            
        H_L25_UI_LAGER_63_1PC13				Sonderlager für DE (AS) und NDE (BS), Lagergrösse 63 	(wenn Std)
            VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    */
    var sDTKAttribute = "O_L25_LAGER_63_1PC13";
    var sCB_Attribute = "O_L25_LAGER_63_1PC13";
    var sKAG = "L25";
    var sNON_Value = "NON";

    // VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection

    var H_L23_UI_NACHSCHMIER_1PC13 = ECL_GetValue("H_L23_UI_NACHSCHMIER_1PC13");
    var O_L23_NACHSCHMIER_1PC13 = ECL_GetValue("O_L23_NACHSCHMIER_1PC13");
    //var H_BEARING_SELECT_1PC13 = ECL_GetValue("H_BEARING_SELECT_1PC13");

    // todo klären, was einschränken soll
    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        //"H_L23_UI_NACHSCHMIER_1PC13 = '" + H_L23_UI_NACHSCHMIER_1PC13 + "' AND " +
        "O_L23_NACHSCHMIER_1PC13 = '" + O_L23_NACHSCHMIER_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L25_HMK_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "H_L25_UI_LAGER_63_1PC13";

    // VT_1PC13_M00185	L18+L23+L25 -> Bearing type selection
    var O_L25_LAGER_63_1PC13 = "NON";
    if (ECL_ValueSelected("O_L25_LAGER_63_1PC13", "T")) {
        O_L25_LAGER_63_1PC13 = "L25";
    }

    // todo klären, was einschränken soll
    var sTable = "VT_1PC13_M00185" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "' AND " +
        "O_SCHILD_L18_1PC13 = '" + O_SCHILD_L18_1PC13 + "' AND " +
        "O_L25_LAGER_63_1PC13 = '" + O_L25_LAGER_63_1PC13 + "' AND " +
        "H_L23_UI_NACHSCHMIER_1PC13 = '" + H_L23_UI_NACHSCHMIER_1PC13 + "' AND " +
        "O_L23_NACHSCHMIER_1PC13 = '" + O_L23_NACHSCHMIER_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_L25_HMK_HMK_NO_DB_RESULT";
        return strError;
    }
    ECL_DisableAttribute(sTargetAttribute);
    // ################################################################################################################


    // ################################################################################################################
    // C	O_RAD_DICHTRING_1PC13	(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar		Checkbox
    // ################################################################################################################
    /*
    O_RAD_DICHTRING_1PC13	(H23) Radialdichtring auf DE (AS) bei Flanschbauformen mit Öldichtigkeit bis 0,1 bar
        VT_1PC13_M00083	Radialdichtung rel. Bauform
            O_RAD_DICHTRING_1PC13	Radialdichtring.../bar
            IN_BAUFORM_1PC13		Bauform
            
        VT_1PC13_M00187	Shaft seal DE side
            HMK_BG_1PC13	BG
            I_WELLENDICHTRING_1PC13	Wellendichtring auf DE-Seite
            O_RAD_DICHTRING_1PC13	Radialdichtring.../bar
            
    I_WELLENDICHTRING_1PC13				Wellendichtring auf DE-Seite	(Std. Info)
        VT_1PC13_M00187	Shaft seal DE side
        
    */
    var sDTKAttribute = "O_RAD_DICHTRING_1PC13";
    var sCB_Attribute = "O_RAD_DICHTRING_1PC13";
    var sKAG = "H23";
    var sNON_Value = "NON";

    var IN_BAUFORM_1PC13 = ECL_GetValue("IN_BAUFORM_1PC13");

    var sTable = "VT_1PC13_M00083" + sDB_Suffix;
    var sWhere = "IN_BAUFORM_1PC13 = '" + IN_BAUFORM_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_RAD_DICHTRING_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var sTable = "VT_1PC13_M00187" + sDB_Suffix;
    var sWhere = "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, true);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_RAD_DICHTRING_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    // I_WELLENDICHTRING_1PC13				Wellendichtring auf DE-Seite	(Std. Info)
    var sTargetAttribute = "I_WELLENDICHTRING_1PC13";

    var O_RAD_DICHTRING_1PC13 = "NON";
    if (ECL_ValueSelected("O_RAD_DICHTRING_1PC13", "T")) {
        O_RAD_DICHTRING_1PC13 = "H23";
    }

    var sTable = "VT_1PC13_M00187" + sDB_Suffix;
    var sWhere = "O_RAD_DICHTRING_1PC13 = '" + O_RAD_DICHTRING_1PC13 + "' AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_RAD_DICHTRING_NO_DB_RESULT";
        return strError;
    }
    ECL_DisableAttribute(sTargetAttribute);
    // ################################################################################################################


    // ################################################################################################################
    // D I_WELLENDICHTRING_NE_1PC13			Wellendichtring auf NDE-Seite	(Std. Info)
    // ################################################################################################################
    /*	VT_1PC13_M00189	Shaft seal NDE side
            HMK_BG_1PC13	BG
            IN_KUEHLART_1PC13	Kühlart
            O_ANBAU_BREMSE_1PC13	Anbau Bremse
            I_WELLENDICHTRING_NE_1PC13	Wellendichtring auf NDE-Seite
    */
    var sTargetAttribute = "I_WELLENDICHTRING_NE_1PC13";

    var O_ANBAU_BREMSE_1PC13 = ECL_GetValue("O_ANBAU_BREMSE_1PC13");

    var sTable = "VT_1PC13_M00189" + sDB_Suffix;
    var sWhere = "IN_KUEHLART_1PC13 = '" + IN_KUEHLART_1PC13 + "' AND " +
        "O_ANBAU_BREMSE_1PC13 = '" + O_ANBAU_BREMSE_1PC13 + "' AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_RAD_DICHTRING_NDE_NO_DB_RESULT";
        return strError;
    }
    ECL_DisableAttribute(sTargetAttribute);
    // ################################################################################################################


    // ################################################################################################################
    // E O_LAGERISOLIER_DE_1PC13				(L50) Lagerisolierung DE (AS)					Checkbox
    // ################################################################################################################
    /* 	VT_1PC13_M00045	Opt.L50+BG
            O_LAGERISOLIER_DE_1PC13	Lagerisolierung DE (AS)
            H_BAUGROESSE_DYN_1PC13	Baugröße
        
    */
    var sDTKAttribute = "O_LAGERISOLIER_DE_1PC13";
    var sCB_Attribute = "O_LAGERISOLIER_DE_1PC13";
    var sKAG = "L50";
    var sNON_Value = "NON";

    var sTable = "VT_1PC13_M00045" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_LAGERISOLIER_DE_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // F O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)
    // ################################################################################################################
    /*	O_L51_LAGERISOL_NDE_1PC13	(L51) Lagerisolierung NDE (BS)	(Auswahl)
            VT_1PC13_M00154	L51->L51_UI->BG
                O_L51_LAGERISOL_NDE_1PC13	Lagerisolierung NDE (BS)
                H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)
                H_BAUGROESSE_DYN_1PC13	Baugröße
            
        H_L51_UI_LAGERIS_NDE_1PC13	Lagerisolierung NDE (BS)		(INFO)
            VT_1PC13_M00154	L51->L51_UI->BG
    */
    var sDTKAttribute = "O_L51_LAGERISOL_NDE_1PC13";
    var sCB_Attribute = "O_L51_LAGERISOL_NDE_1PC13";
    var sKAG = "L51";
    var sNON_Value = "NON";

    var sTable = "VT_1PC13_M00154" + sDB_Suffix;
    var sWhere = "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic_Checkbox(sTable, sDTKAttribute, sCB_Attribute, sKAG, sNON_Value, sWhere, false);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_LAGERISOLIER_NDE_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------
    var sTargetAttribute = "H_L51_UI_LAGERIS_NDE_1PC13";

    var O_L51_LAGERISOL_NDE_1PC13 = "NON";
    if (ECL_ValueSelected("O_L51_LAGERISOL_NDE_1PC13", "T")) {
        O_L51_LAGERISOL_NDE_1PC13 = "L51";
    }

    var sTable = "VT_1PC13_M00154" + sDB_Suffix;
    var sWhere = "O_L51_LAGERISOL_NDE_1PC13 = '" + O_L51_LAGERISOL_NDE_1PC13 + "' AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1PC13___PLVT_LAGERISOLIER_NDE_NO_DB_RESULT";
        return strError;
    }
    ECL_DisableAttribute(sTargetAttribute);
    // ################################################################################################################


    // ################################################################################################################

    // ################################################################################################################
    // ################################################################################################################


    return "OK";

}
