//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1PC13_MLFB/Base.misc.js"

/**
 * @category   1PC13 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2022 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
    vtTimeStart = Date.getTime();

    var oParsing = {
        strBaseMLFB: '',
        strFullMLFB: '',
        strError: '',
        strWarning: '',
        aTokens: [],
        oFreetext: {}
    };

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    strMLFB = normalizeMLFB(strMLFB);
    strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

    // MLFB Freitexte
    var nFreetext = find(strMLFB, '{');
    var strFreetext = '';
    if (nFreetext > 0) {
        strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
    }
    oParsing.oFreetext = parseFreetext(strFreetext, true);
    strMLFB = replace(strMLFB, strFreetext, "");
    oParsing.strFullMLFB = strMLFB;

    // Kurzangaben aus MLFB 
    var aComponents = tokenize(strMLFB);
    if (!aComponents.length) {
        oParsing.strError = 'ERRORMSG_MLFB_1PC13___INVALID_MLFB';
        return (oParsing)
    } else if (aComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ((aComponents[1] === 'Z') || (aComponents[1] === '-Z')) {
            aComponents = removeElementsFromArray(aComponents, 1, 1);
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;

    if (oParsing.strBaseMLFB.length !== 16) {
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1PC13___PARSE_WRONG_SIZE';
        return (oParsing);
    }

    if (oParsing.strBaseMLFB.indexOf("1PC13") < 0) {
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1PC13___PARSE_WRONG_PRODUCT';
        return (oParsing);
    }

    // fix sind MLFB 1 bis 13
    var strMLFB_fix = strMLFB.substring(0, 13);
    var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 13);

    // #############################################################################################################
    // Bestimme Rumpf
    // #############################################################################################################
    var H_WWDEV_MLFB_1PC13 = getH_WWDEV_MLFB(strBaseTypeMLFB_fix);
    if (H_WWDEV_MLFB_1PC13 != "ERROR") {

        ECL_SetValue("H_WWDEV_MLFB_1PC13", H_WWDEV_MLFB_1PC13);
    } else {
        oParsing.strError = 'ERRORMSG_MLFB_1PC13___GET_RUMPF';
    }
    // #############################################################################################################
    // Bestimme Baugrößen
    // #############################################################################################################
    var HMK_BG_1PC13 = strBaseTypeMLFB_fix.substring(7, 9);
    ECL_SetValue("HMK_BG_1PC13", HMK_BG_1PC13);

    var H_MLFB05_07_1PC13 = strBaseTypeMLFB_fix.substring(4, 7);
    ECL_SetValue("H_MLFB05_07_1PC13", H_MLFB05_07_1PC13);

    var H_BAUGROESSE_DYN_1PC13 = getBG_dyn(H_WWDEV_MLFB_1PC13);
    if (H_BAUGROESSE_DYN_1PC13 == "ERROR") {

        oParsing.strError = 'ERRORMSG_MLFB_1PC13___GET_BG';
    }


    // #############################################################################################################
    // Kühlart
    var bKuehlartKAGpresent_MLFB = false;
    var aKuehlartKAG = ["F70", "F79"];
    var sKuehlartKAG = "NON";

    for (var i = 0; i < aKuehlartKAG.length; i++) {
        bKuehlartKAGpresent_MLFB = isKAGinMLFB(aComponents, aKuehlartKAG[i]);
        if (bKuehlartKAGpresent_MLFB) {
            sKuehlartKAG = aKuehlartKAG[i];
            break;
        }
    }

    // #############################################################################################################
    // Wicklungs KAG
    var bWicklungKAGpresent_MLFB = false;
    var sWicklungMLFB = "NON";
    if (strMLFB.charAt(11) == "9") { // Wenn MLFB12 == "9", dann gibt es eine KAG für die Wicklung
        var aWicklungen = ["M1F", "M1N", "M1L", "M1P", "M1Q",
            "M3A", "M3J", "M3L", "M3M", "M3K", "M3H", "M3N", "M3P",
            "M4B", "M4C", "M4L", "M4E", "M4D", "M4F",
            "M1Y", "M2Y"];
        for (var i = 0; i < aWicklungen.length; i++) {
            bWicklungKAGpresent_MLFB = isKAGinMLFB(aComponents, aWicklungen[i]);
            if (bWicklungKAGpresent_MLFB) {
                sWicklungMLFB = aWicklungen[i];
                break;
            }
        }
    }

    // #############################################################################################################
    // Stelle 15 (Motorschutz)
    /* ACHTUNG Sonderfall mit KAG
    if (sMotorschutz == "Q2A" || sMotorschutz == "Q3A" || sMotorschutz == "Q9A"){
        // Sonderfall
        sMLFB = replaceAt(sMLFB, 14, "Z");
*/
    var bMotorschutzKAGpresent_MLFB = false;
    if (strMLFB.charAt(14) == "Z") { // Wenn MLFB15 == "Z", dann gibt es eine KAG für den Motorschutz
        var aMotorschutzKAG = ["Q3A"];

        for (var i = 0; i < aMotorschutzKAG.length; i++) {
            bMotorschutzKAGpresent_MLFB = isKAGinMLFB(aComponents, aMotorschutzKAG[i]);
            if (bMotorschutzKAGpresent_MLFB) {
                var sMotorschutzMLFB = aMotorschutzKAG[i];
                break;
            }
        }
    }
    // #############################################################################################################
    if (strBaseTypeMLFB != "") {

        //--------------------------------------------------------------------------------------------------------
        // Base Type  MLFB aufbereiten
        //--------------------------------------------------------------------------------------------------------
        var nFreetextBT = find(strBaseTypeMLFB, '{');
        var strFreetextBT = '';
        if (nFreetextBT > 0) {
            strFreetextBT = strBaseTypeMLFB.right(strBaseTypeMLFB.length - nFreetextBT + 1);
        }
        var oFreetextBT = parseFreetext(strFreetextBT, true);
        strBaseTypeMLFB = replace(strBaseTypeMLFB, strFreetextBT, "");
        var strFullMLFB_BT = strBaseTypeMLFB;


        var aBTComponents = tokenize(strBaseTypeMLFB);
        if (aBTComponents.length > 1) {
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ((aBTComponents[1] === 'Z') || (aBTComponents[1] === '-Z')) {
                aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
            }
        }

        strBaseTypeMLFB = aBTComponents[0];
        if (strBaseTypeMLFB.length === 17) {
            // eliminate the -Z 
            strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
        }


        // Kühlart
        var bKuehlartKAGpresent_BT = false;
        var aKuehlartKAG = ["F70", "F79"];
        var sKuehlartKAG_BT = "NON";

        for (var i = 0; i < aKuehlartKAG.length; i++) {
            bKuehlartKAGpresent_BT = isKAGinMLFB(aBTComponents, aKuehlartKAG[i]);
            if (bKuehlartKAGpresent_BT) {
                sKuehlartKAG_BT = aKuehlartKAG[i];
                break;
            }
        }
        // Stelle 15 (Motorschutz)
        var aMotorschutzKAG = ["Q3A"];
        var bMotorschutzKAGpresentBT = false;

        if (strBaseTypeMLFB.charAt(14) == "Z") { // Wenn MLFB14 == "Z", dann gibt es eine KAG für den Motorschutz
            for (var i = 0; i < aMotorschutzKAG.length; i++) {
                bMotorschutzKAGpresentBT = isKAGinMLFB(aBTComponents, aMotorschutzKAG[i]);

                if (bMotorschutzKAGpresentBT) {
                    var sMotorschutzBT = aMotorschutzKAG[i];
                    break;
                }
            }
        }
        var sWicklungBT = "NON";
        // Wicklungs KAG
        if (strBaseTypeMLFB.charAt(11) == "9") { // Wenn MLFB12 == "9", dann gibt es eine KAG für die Wicklung
            var aWicklungen = ["M1F", "M1N", "M1L", "M1P", "M1Q",
                "M3A", "M3J", "M3L", "M3M", "M3K", "M3H", "M3N", "M3P",
                "M4B", "M4C", "M4L", "M4E", "M4D", "M4F",
                "M1Y", "M2Y"];
            for (var i = 0; i < aWicklungen.length; i++) {
                bWicklungKAGpresentBT = isKAGinMLFB(aBTComponents, aWicklungen[i]);
                if (bWicklungKAGpresentBT) {
                    sWicklungBT = aWicklungen[i];
                    break;
                }
            }
        }
    }
    // #############################################################################################################
    var bKAG_Change = false;
    if (sKuehlartKAG != sKuehlartKAG_BT) {
        bKAG_Change = true;
    }

    if (sWicklungMLFB != sWicklungBT) {
        bKAG_Change = true;
    }

    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

    if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration = "1";

    if (strStartConfiguration == "1") {
        // entweder unvollständige MLFB, also Defaults setzen oder KEEP-Configuration-Fall, 
        // dann muss die MLFB aber vollständig spezifiziert sein!
        //und eine zur Haupt MLFB unterschiedliche Base Type MLFB übergeben werden.
        //Hier sollen dann möglichst viele Attribute beibehalten werden.


        // Abgleich BT (BaseTypeMLFB) und MLFB für Keep Configuration
        // -----------------------------------------------------------------------------------------------
        //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
        // -----------------------------------------------------------------------------------------------
        if (((strBaseTypeMLFB_fix != strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") || bKAG_Change) {
            // #################################################################################################################
            // KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION
            // #################################################################################################################
            //--------------------------------------------------------------------------------------------------------
            // Base-Type-MLFB aufbereiten
            //--------------------------------------------------------------------------------------------------------
            /*var aBTComponents = tokenize( strBaseTypeMLFB );
            if ( aBTComponents.length > 1 )
            {
                // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
                // eliminate the resulting invalid short description 'Z'
                if ( ( aBTComponents[1] === 'Z' ) || ( aBTComponents[1] === '-Z' ) ){
                    aBTComponents = removeElementsFromArray( aBTComponents, 1, 1 );
                }
            }
            
            strBaseTypeMLFB = aBTComponents[0];
            
            if ( strBaseTypeMLFB.length === 17 ){
                // eliminate the -Z 
                strBaseTypeMLFB = strBaseTypeMLFB.substring( 0, 16 );
            }
            */
            // -----------------------------------------------------------------------------------------------
            // KAG abgleichen und ggf übernehmen/entfernen
            // -----------------------------------------------------------------------------------------------
            /* mögliche Platzhalter
                MLFB-Schema
                
                MLFB01	1PC13
                MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
                MLFB07	1
                MLFB08	BG 1
                MLFB09	BG 2
                MLFB10	Polzahl/Drehzahl A: 2 polig, B: 4-polig, C: 6, D: 8
                MLFB11	Wicklung
                MLFB12	9 Wicklung 1	90 - KAG!
                MLFB13	0 Wicklung 2	0
                MLFB14	. Bauform		bei c,G H00 möglich
                MLFB15	. Motorschutz	bei Z + KAG
                MLFB16	. Anschlusskasten	4,5,6 (top, right, left)
            */

            // -----------------------------------------------------------------------------------------------
            // Platzhalter aus MLFB in BT übernehmen
            // -----------------------------------------------------------------------------------------------

            // ---------------------------------------------------------------------------------------------------
            // MLFB14	Bauform
            // ---------------------------------------------------------------------------------------------------
            /*
                bei 3A nicht F,H
            */
            var sMLFB14 = strMLFB.charAt(13);
            var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

            if (sBT_MLFB14 == ".") {

                // 
                var bCheck = checkMLFB14_Parser(sMLFB14, HMK_BG_1PC13);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                } else {
                    // Setze Default A:
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "A");
                }
            }

            // ---------------------------------------------------------------------------------------------------
            // MLFB15 Motorschutz 
            // ---------------------------------------------------------------------------------------------------
            /*
            bei Z ist eine KAG vorhanden				todo
            */
            var sMLFB15 = strMLFB.charAt(14);
            var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

            if (sBT_MLFB15 == ".") {

                // todo Check MLFB15
                var bCheck = checkMLFB15_Parser(sMLFB15, H_BAUGROESSE_DYN_1PC13);
                if (bCheck) {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
                } else {

                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, "A");
                }
            }

            // ---------------------------------------------------------------------------------------------------
            // MLFB16 Anschlusskastenlage
            // ---------------------------------------------------------------------------------------------------
            var sMLFB16 = strMLFB.charAt(15);
            var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

            if (sBT_MLFB16 == ".") {

                sMLFB16 = checkMLFB16_Parser(sMLFB16, HMK_BG_1PC13);
                if (sMLFB16 != "ERROR") {
                    // setzen
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
                } else {
                    // Setze Default:
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, "4"); // top
                    oParsing.strError = 'ERRORMSG_MLFB_1PC13___GET_KLK_LAGE';
                }
            }

            // -----------------------------------------------------------------------------------------------
            // KAG abgleichen und ggf übernehmen/entfernen
            // -----------------------------------------------------------------------------------------------

            // -------------------------------------------------------------------------------------------------
            // Kühlart F70/F79
            // -------------------------------------------------------------------------------------------------
            if (bKuehlartKAGpresent_BT) {
                if (!bKuehlartKAGpresent_MLFB) {
                    //F70/F79 ist in Base Type enthalten, aber nicht in Haupt MLFB
                    //F70/F79 ergänzen
                    aComponents.push(sKuehlartKAG_BT);
                    aComponents.sort();

                    strMLFB = strMLFB + " +" + sKuehlartKAG_BT;
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                } else {
                    if (sKuehlartKAG_BT != sKuehlartKAG) {
                        aComponents.push(sKuehlartKAG_BT);
                        aComponents.sort();

                        strMLFB = strMLFB + " +" + sKuehlartKAG_BT;
                        ECL_SetValue("ECSI_MLFB", strMLFB);

                        // entfernen der alten
                        var anewArray = [];
                        for (var i = 0; i < aComponents.length; i++) {
                            if (aComponents[i] != sKuehlartKAG) {
                                anewArray.push(aComponents[i]);
                            }
                        }

                        aComponents = anewArray;

                        strMLFB = replace(strMLFB, "+" + sKuehlartKAG, "");
                        strMLFB = replace(strMLFB, sKuehlartKAG, "");
                        ECL_SetValue("ECSI_MLFB", strMLFB);
                    }
                }
            } else {
                if (bKuehlartKAGpresent_MLFB) {
                    //F70/F79 ist in Base Type nicht enthalten, aber in Haupt MLFB
                    //F70/F79 entfernen
                    var anewArray = [];
                    for (var i = 0; i < aComponents.length; i++) {
                        if (aComponents[i] != sKuehlartKAG) {
                            anewArray.push(aComponents[i]);
                        }
                    }

                    aComponents = anewArray;

                    strMLFB = replace(strMLFB, "+" + sKuehlartKAG, "");
                    strMLFB = replace(strMLFB, sKuehlartKAG, "");
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                }
            }

            // -------------------------------------------------------------------------------------------------
            // WicklungsKAG
            // -------------------------------------------------------------------------------------------------
            if (bWicklungKAGpresentBT) {
                if (!bWicklungKAGpresent_MLFB) {
                    //Mxx ist in Base Type enthalten, aber keine Mxx oder Myy in Haupt MLFB
                    //Mxx ergänzen
                    aComponents.push(sWicklungBT);
                    aComponents.sort();

                    strMLFB = strMLFB + " +" + sWicklungBT;
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                } else {
                    //Mxx ist in Base Type enthalten und es ist eine (andere) Myy in Haupt MLFB
                    //Mxx ergänzen und Myy entfernen, ansonsten (bei Gleichheit) nix tun
                    if (sWicklungBT != sWicklungMLFB) {
                        aComponents.push(sWicklungBT);
                        aComponents.sort();

                        strMLFB = strMLFB + " +" + sWicklungBT;
                        ECL_SetValue("ECSI_MLFB", strMLFB);

                        // entfernen der alten
                        var anewArray = [];
                        for (var i = 0; i < aComponents.length; i++) {
                            if (aComponents[i] != sWicklungMLFB) {
                                anewArray.push(aComponents[i]);
                            }
                        }

                        aComponents = anewArray;

                        strMLFB = replace(strMLFB, "+" + sWicklungMLFB, "");
                        strMLFB = replace(strMLFB, sWicklungMLFB, "");
                        ECL_SetValue("ECSI_MLFB", strMLFB);
                    }
                }
            } else {
                if (bWicklungKAGpresent_MLFB) {
                    //Mxx ist in Base Type nicht enthalten, aber in Haupt MLFB
                    //Mxx entfernen
                    var anewArray = [];
                    for (var i = 0; i < aComponents.length; i++) {
                        if (aComponents[i] != sWicklungMLFB) {
                            anewArray.push(aComponents[i]);
                        }
                    }

                    aComponents = anewArray;

                    strMLFB = replace(strMLFB, "+" + sWicklungMLFB, "");
                    strMLFB = replace(strMLFB, sWicklungMLFB, "");
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                }
            }
            // -------------------------------------------------------------------------------------------------
            // MotorschutzKAG
            // -------------------------------------------------------------------------------------------------
            if (bMotorschutzKAGpresentBT) {
                if (!bMotorschutzKAGpresent_MLFB) {
                    //Qxx ist in Base Type enthalten, aber keine Qxx oder Qyy in Haupt MLFB
                    //Qxx ergänzen
                    aComponents.push(sMotorschutzBT);
                    aComponents.sort();

                    strMLFB = strMLFB + " +" + sMotorschutzBT;
                    //ECL_SetValue("ECSI_MLFB",strMLFB);
                    // MLFB15 auf "Z" setzen
                    strMLFB = replaceAt(strMLFB, 14, "Z");
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                } else {
                    //Qxx ist in Base Type enthalten und es ist eine (andere) Qyy in Haupt MLFB
                    //Qxx ergänzen und Qyy entfernen, ansonsten (bei Gleichheit) nix tun
                    if (sMotorschutzBT != sMotorschutzMLFB) {
                        aComponents.push(sMotorschutzBT);
                        aComponents.sort();

                        strMLFB = strMLFB + " +" + sMotorschutzBT;
                        ECL_SetValue("ECSI_MLFB", strMLFB);

                        // entfernen der alten
                        var anewArray = [];
                        for (var i = 0; i < aComponents.length; i++) {
                            if (aComponents[i] != sMotorschutzMLFB) {
                                anewArray.push(aComponents[i]);
                            }
                        }

                        aComponents = anewArray;

                        strMLFB = replace(strMLFB, "+" + sMotorschutzMLFB, "");
                        strMLFB = replace(strMLFB, +sMotorschutzMLFB, "");
                        ECL_SetValue("ECSI_MLFB", strMLFB);
                    }
                }
            } else {
                if (bMotorschutzKAGpresent_MLFB) {
                    //Q3X ist in Base Type nicht enthalten, aber in Haupt MLFB
                    //Q3X entfernen
                    var anewArray = [];
                    for (var i = 0; i < aComponents.length; i++) {
                        if (aComponents[i] != sMotorschutzMLFB) {
                            anewArray.push(aComponents[i]);
                        }
                    }

                    aComponents = anewArray;

                    strMLFB = replace(strMLFB, "+" + sMotorschutzMLFB, "");
                    strMLFB = replace(strMLFB, sMotorschutzMLFB, "");
                    ECL_SetValue("ECSI_MLFB", strMLFB);
                }
            }


            // -----------------------------------------------------------------------------------------------
            // Zuweisen der neuen MLFB und KAG-Liste
            strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

            oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
            oParsing.strFullMLFB = strMLFB;
            aComponents[0] = oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
            ECL_SetValue("ECSI_MLFB", strMLFB);
        }
        // #######################################################################################################
        // END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END
        // #######################################################################################################
        else {
            // kein KEEP-Configuration, aber MLFB evtl. nicht vollständig spezifiziert
            if (find(strMLFB.left(16), ".") >= 0) {
                //Unvollständige SIZER MLFB

                // Prüfen, ob '.' an Stelle 1 bis 13, dann Fehler				TODO
                for (var i = 0; i < 7; i++) {
                    if (strMLFB.charAt(i) == ".") {
                        oParsing.strError = 'ERRORMSG_MLFB_1PC13___INCOMPLETE_MLFB';
                        return (oParsing);
                    }
                }
                if (strMLFB.charAt(9) == ".") {
                    oParsing.strError = 'ERRORMSG_MLFB_1PC13___INCOMPLETE_MLFB';
                    return (oParsing);
                }

                // Wenn an Stelle 9, 11-16 ein Wildcard, dann Default setzen

                /* mögliche Platzhalter
                    MLFB-Schema
                    
                    MLFB01	1PC13
                    MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
                    MLFB07	1
                    MLFB08	BG 1
                    MLFB09	BG 2
                    MLFB10	Polzahl/Drehzahl A: 2 polig, B: 4-polig, C: 6, D: 8
                    MLFB11	Wicklung
                    MLFB12	9 Wicklung 1	90 - KAG!
                    MLFB13	0 Wicklung 2	0
                    MLFB14	. Bauform		bei c,G H00 möglich
                    MLFB15	. Motorschutz	bei Z + KAG
                    MLFB16	. Anschlusskasten	4,5,6 (top, right, left)
                */


                // ---------------------------------------------------------------------------------------------------
                // Bauform	MLFB14
                // ---------------------------------------------------------------------------------------------------
                // Default "A"
                if (strMLFB.charAt(13) == ".") {
                    // Setze Default:
                    strMLFB = replaceAt(strMLFB, 13, "A");
                }

                // ---------------------------------------------------------------------------------------------------
                // Motorschutz MLFB15
                // ---------------------------------------------------------------------------------------------------

                if (strMLFB.charAt(14) == ".") {

                    strMLFB = replaceAt(strMLFB, 14, "A");
                }

                // ---------------------------------------------------------------------------------------------------
                // Anschlusskasten MLFB16
                // ---------------------------------------------------------------------------------------------------
                // Default 4
                if (strMLFB.charAt(15) == ".") {
                    // Setze Default:
                    strMLFB = replaceAt(strMLFB, 15, "4"); // top
                }
                // ---------------------------------------------------------------------------------------------------

                ECL_SetValue("ECSI_MLFB", strMLFB);
            }


            // Zuweisen der neuen MLFB und KAG-Liste
            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;
            oParsing.aTokens = aComponents;
        }
        // Jetzt sollte immer eine vollständig spezifizierte MLFB zur Verfügung stehen
    }	// der vorherige Abschnitt wurde nur bei IsStartConfiguration == 1 durchlaufen. Passt das ? todo


    // Ergebnis-Objekt zusammenbauen
    var oResult;
    oResult = parse_1PC13(oParsing.aTokens);
    //oResult = add_Rumpf(oResult);


    if (oResult) {
        if (oResult.oProduct)
            oParsing.oProduct = oResult.oProduct;
        if (oResult.oParsingData)
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strBaseTypeMLFB = strBaseTypeMLFB;
        oParsing.strError += ((oParsing.strError ? ' ' : '') + oResult.strError);
        oParsing.strWarning += ((oParsing.strWarning ? ' ' : '') + oResult.strWarning);
        oParsing.IsStartConfig = strStartConfiguration;
        var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
        if (strwithBrake == "1") {
            oParsing.WithBrake = true;
        } else {
            oParsing.WithBrake = false;
        }
    }


    vtTimeStop = Date.getTime();
    vtTime = (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

    return (oParsing);
}

function parse_1PC13(aTokens) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /* mögliche Platzhalter
            MLFB01	1PC13
            MLFB06	Kühlart 4: (self)/forced-ventilated (ab 3A nur forced), 6 non-ventilated
            MLFB07	1
            MLFB08	BG 1
            MLFB09	BG 2
            MLFB10	Polzahl/Drehzahl A: 2 polig, B: 4-polig, C: 6, D: 8
            MLFB11	Wicklung
            MLFB12	9 Wicklung 1	90 - KAG!
            MLFB13	0 Wicklung 2	0
            MLFB14	. Bauform		bei c,G H00 möglich
            MLFB15	. Motorschutz	bei Z + KAG
            MLFB16	. Anschlusskasten	4,5,6 (top, right, left)
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4); // 1PC1
    oResult.oParsingData.MLFB.MLFB05 = strBaseMLFB.charAt(4) 		// 3
    oResult.oParsingData.MLFB.MLFB06 = strBaseMLFB.charAt(5) 		// Kühlart	{4,6}
    oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt(6);	 	// 1								
    oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt(7);  	// BG 1	
    oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt(8);		// BG 2
    oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt(9);	 	// Polzahl/Drehzahl 	(B,C,D)						
    oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt(10); 	// Spannung/Wicklung?
    oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt(11); 	// 9 Wicklung						
    oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt(12); 	// 0 Wicklung
    oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt(13); 	// . Bauform
    oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt(14); 	// . Motorschutz
    oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt(15);	// . Anschlusskastenlage


    // Setze Rumpf
    oResult.oParsingData.MLFB.RUMPF = ECL_GetValue("H_WWDEV_MLFB_1PC13");
    // Setze Baugrößen
    oResult.oParsingData.MLFB.BG_DYN = ECL_GetValue("H_BAUGROESSE_DYN_1PC13");


    // Kurzangaben
    if (aTokens.length > 0) {
        if (aTokens[0] === strBaseMLFB) {
            aTokens = removeElementsFromArray(aTokens, 0, 1);
        }
        oResult.oParsingData.MLFB.KAG = aTokens;

        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }

    return oResult;
}


/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1) {
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {

    value = trimleft(value, '*');
    value = trimright(value, '*');

    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

    /*	zur Info - oParse: 
        {
            strBaseMLFB : '',
            strFullMLFB
            strError : '',
            strWarning : '',
            aTokens : [],
            oFreetext : {}
        };
    */
    /*
    O_KABELEINFPLATTE_1PC13
    (Y61) Anormale Gewindedurchgangsbohrung (NPT- oder G-Gewinde)
    (Y73) Sonder Kabeleinführungplatte
    
    O_DREHIMPULSGEBER_1PC13
    (Y74) Anbau des Drehimpulsgebers HOG 10 DN 1024 I + FSL, Klemmenkasten Feuchteschutz
    (Y76) Anbau des Drehimpulsgebers HOG 10 DN 1024 I + FSL, Klemmenkasten Staubschutz
    
    H_KAG_FARBE_1PC13
    Y53
    (Y54)
    Y56
    Y66
    
    O_ZUSATZSCHILD_1PC13
    (Y82) Zusatzschild mit Bestellangaben
    */

    // Farbanstrich
    if (find(oParse.strFullMLFB, 'Y53') >= 0) {
        if (oParse.oFreetext['Y53']) SetFreetextValue('H_RAL_FARBE_1PC13', oParse.oFreetext['Y53']);
    }
    if (find(oParse.strFullMLFB, 'Y56') >= 0) {
        if (oParse.oFreetext['Y56']) SetFreetextValue('H_RAL_FARBE_1PC13', oParse.oFreetext['Y56']);
    }
    if (find(oParse.strFullMLFB, 'Y66') >= 0) {
        if (oParse.oFreetext['Y66']) SetFreetextValue('H_RAL_FARBE_1PC13', oParse.oFreetext['Y66']);
    }

    //(Y82) Zusatzschild mit Bestellangaben
    if (find(oParse.strFullMLFB, 'Y82') >= 0) {
        if (oParse.oFreetext['Y82']) SetFreetextValue('OE_ZUSATZSCHILD_TA_1PC13', oParse.oFreetext['Y82']);
    }

    // Y61, Y73: Kabeleinführungplatte
    if (find(oParse.strFullMLFB, 'Y61') >= 0) {
        if (oParse.oFreetext['Y61']) SetFreetextValue('OE_KABELEINFPLATTE_1PC13', oParse.oFreetext['Y61']);
    }
    if (find(oParse.strFullMLFB, 'Y73') >= 0) {
        if (oParse.oFreetext['Y73']) SetFreetextValue('OE_KABELEINFPLATTE_1PC13', oParse.oFreetext['Y73']);
    }

    // Geber
    if ((find(oParse.strFullMLFB, 'Y74') >= 0) || (find(oParse.strFullMLFB, 'Y76') >= 0)) {
        if (oParse.oFreetext['Y74']) {
            /*var str = oParse.oFreetext['Y74'];
            var n = str.indexOf('RPM');
            var res = str.substr(0, n);
            */
            SetFreetextValue('OE_GEBER_DREHZAHL_1PC13', oParse.oFreetext['Y74'].substr(0, oParse.oFreetext['Y74'].indexOf('RPM')));	// Einheit 'RPM' entfernen
        }
        if (oParse.oFreetext['Y76']) {
            /*var str = oParse.oFreetext['Y76'];
            var n = str.indexOf('RPM');
            var res = str.substr(0, n);
            */
            SetFreetextValue('OE_GEBER_DREHZAHL_1PC13', oParse.oFreetext['Y76'].substr(0, oParse.oFreetext['Y76'].indexOf('RPM')));	// Einheit 'RPM' entfernen
        }
    }

    // Y75 Option für Wärmeklasse/KMT/AH	(Y50, Y52 nicht aktiv) 
    if (find(oParse.strFullMLFB, 'Y75') >= 0) {
        if (oParse.oFreetext['Y75']) SetFreetextValue('IN_WKL_1PC13', "HF");
    }

    // Y81 Fremdlüfter mit anormaler Spannung und/oder Frequenz		<== aktuell ausgeblendet
    /*if (find(oParse.strFullMLFB , 'Y81') >= 0) {
        if (oParse.oFreetext['Y81']) SetFreetextValue('OE_FREMDL_DATEN_1PC13', oParse.oFreetext['Y81']);
    }*/

}

function isKAGinMLFB(aArray, sKAG) {
    for (var i = 0; i < aArray.length; i++) {
        if (aArray[i] == sKAG)
            return true;
    }

    return false;
}

// ###############################################################################################################
// Bestimmen der Rumpf-MLFB
// ###############################################################################################################
function getH_WWDEV_MLFB(sMLFB) {
    // -----------------------------------------------------------------------------------
    //getH_WWDEV_MLFB(strBaseMLFB);// strBaseMLFB.substring(0, 13);
    /*	VT_1PC13_M00211
            H_WWDEV_MLFB_1PC13		MLFB06_1PC13	MLFB07_1PC13	MLFB08_1PC13	MLFB09_1PC13	MLFB10_1PC13	MLFB11_1PC13    IN_WICKLUNG_1PC13
    */
    var MLFB06_1PC13 = sMLFB.charAt(5);
    var MLFB07_1PC13 = sMLFB.charAt(6);
    var MLFB08_1PC13 = sMLFB.charAt(7);
    var MLFB09_1PC13 = sMLFB.charAt(8);
    var MLFB10_1PC13 = sMLFB.charAt(9);
    var MLFB11_1PC13 = sMLFB.charAt(10);

    sTable = "VT_1PC13_M00211" + sDB_Suffix;
    var sSQL = "SELECT H_WWDEV_MLFB_1PC13 FROM " + sTable + " WHERE " +
        "MLFB06_1PC13 = '" + MLFB06_1PC13 + "' AND " +
        "MLFB07_1PC13 = '" + MLFB07_1PC13 + "' AND " +
        "MLFB08_1PC13 = '" + MLFB08_1PC13 + "' AND " +
        "MLFB09_1PC13 = '" + MLFB09_1PC13 + "' AND " +
        "MLFB10_1PC13 = '" + MLFB10_1PC13 + "' AND " +
        "MLFB11_1PC13 = '" + MLFB11_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var H_WWDEV_MLFB_1PC13 = aResult[0].H_WWDEV_MLFB_1PC13;
        return H_WWDEV_MLFB_1PC13;
    } else {
        return "ERROR";
    }
}
// ###############################################################################################################
// Bestimmen der Baugrößen aus Rumpf
// ###############################################################################################################
function getBG_dyn(H_WWDEV_MLFB_1PC13) {
    // IN_BAUGROESSE_1PC13 bestimmen aus Rumpf-MLFB
    var sTable = "VT_1PC13_M00106" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT IN_BAUGROESSE_1PC13 FROM " + sTable + " WHERE " +
        "H_WWDEV_MLFB_1PC13 = '" + H_WWDEV_MLFB_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var IN_BAUGROESSE_1PC13 = aResult[0].IN_BAUGROESSE_1PC13;

        ECL_DeactivateAllAttributeValues("IN_BAUGROESSE_1PC13");
        ECL_ActivateValue("IN_BAUGROESSE_1PC13", IN_BAUGROESSE_1PC13);
        ECL_SelectValue("IN_BAUGROESSE_1PC13", IN_BAUGROESSE_1PC13);

        //return IN_BAUGROESSE_1PC13;
    } else {
        return "ERROR";
    }

    // Bestimmung PMD_AAA726_001_000_HK1LE, H_BAUGROESSE_DYN_1PC13
    var sTable = "VT_1PC13_M00122" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "IN_BAUGROESSE_1PC13 = '" + IN_BAUGROESSE_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var PMD_AAA726_001_000_HK1LE = aResult[0].PMD_AAA726_001_000_HK1LE;
        var H_BAUGROESSE_DYN_1PC13 = aResult[0].H_BAUGROESSE_DYN_1PC13;
        var IN_WUNSCH_BAUGROESSE_1PC13 = aResult[0].IN_WUNSCH_BAUGROESSE_1PC13;

        ECL_DeactivateAllAttributeValues("PMD_AAA726_001_000_HK1LE");
        ECL_ActivateValue("PMD_AAA726_001_000_HK1LE", PMD_AAA726_001_000_HK1LE);
        ECL_SelectValue("PMD_AAA726_001_000_HK1LE", PMD_AAA726_001_000_HK1LE);

        ECL_DeactivateAllAttributeValues("H_BAUGROESSE_DYN_1PC13");
        ECL_ActivateValue("H_BAUGROESSE_DYN_1PC13", H_BAUGROESSE_DYN_1PC13);
        ECL_SelectValue("H_BAUGROESSE_DYN_1PC13", H_BAUGROESSE_DYN_1PC13);

        ECL_DeactivateAllAttributeValues("IN_WUNSCH_BAUGROESSE_1PC13");
        ECL_ActivateValue("IN_WUNSCH_BAUGROESSE_1PC13", IN_WUNSCH_BAUGROESSE_1PC13);
        ECL_SelectValue("IN_WUNSCH_BAUGROESSE_1PC13", IN_WUNSCH_BAUGROESSE_1PC13);

        return H_BAUGROESSE_DYN_1PC13;
    } else {
        return "ERROR";
    }
}

// ###############################################################################################################
// Prüfroutinen für KEEP CONFIGURATION
// ###############################################################################################################

// ################################################################################################
// Bauform prüfen
function checkMLFB14_Parser(sMLFB14, HMK_BG_1PC13) {
    /* 	VT_1PC13_M00005	Bauform					abh. BG
            IN_BAUFORM_1PC13		Bauform
            HMK_BG_1PC13			BG				bei 3A nicht F,H
    */

    //var IN_BAUFORM_1PC13 = sMLFB14;

    var sTable = "VT_1PC13_M00005" + sDB_Suffix;
    var sSQL = "SELECT IN_BAUFORM_1PC13 FROM " + sTable + " WHERE " +
        "IN_BAUFORM_1PC13 = '" + sMLFB14 + "'AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // ----------------------------------------------------------------------------------------------------------------
    return 1;
}

// Motorschutz prüfen
function checkMLFB15_Parser(sMLFB15, H_BAUGROESSE_DYN_1PC13) {
    /* VT_1PC13_M00078	Motorschutz+BG
            IN_MOTORSCHUTZ_1PC13	Motorschutz
            H_BAUGROESSE_DYN_1PC13	Baugröße
    */
    var IN_MOTORSCHUTZ_1PC13 = sMLFB15;
    if (sMLFB15 == "Z") {
        IN_MOTORSCHUTZ_1PC13 = "Q3A";
    }
    var sTable = "VT_1PC13_M00078" + sDB_Suffix;
    var sSQL = "SELECT IN_MOTORSCHUTZ_1PC13 FROM " + sTable + " WHERE " +
        "IN_MOTORSCHUTZ_1PC13 = '" + IN_MOTORSCHUTZ_1PC13 + "'AND " +
        "H_BAUGROESSE_DYN_1PC13 = '" + H_BAUGROESSE_DYN_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // ----------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################

function checkMLFB16_Parser(sMLFB16, HMK_BG_1PC13) {
    /*
    VT_1PC13_M00007	Mapping_MLFB_16
        MLFB16_1PC13	Segment Merkmal MLFB16_1PC13
        IN_KLK_LAGE_1PC13	Anschlusskastenlage
        
    VT_1PC13_M00021	Klemenkasten_BG
        IN_KLK_LAGE_1PC13	Anschlusskastenlage
        HMK_BG_1PC13	BG
    */

    // -----------------------------------------------------------------------------------
    // Bestimme IN_KLK_LAGE_1PC13

    sTable = "VT_1PC13_M00007" + sDB_Suffix;
    var sSQL = "SELECT IN_KLK_LAGE_1PC13 FROM " + sTable + " WHERE " +
        "MLFB16_1PC13 = '" + sMLFB16 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var IN_KLK_LAGE_1PC13 = aResult[0].IN_KLK_LAGE_1PC13;
    } else {
        return "ERROR";
    }
    // -----------------------------------------------------------------------------------
    sTable = "VT_1PC13_M00021" + sDB_Suffix;
    var sSQL = "SELECT IN_KLK_LAGE_1PC13 FROM " + sTable + " WHERE " +
        "IN_KLK_LAGE_1PC13 = '" + IN_KLK_LAGE_1PC13 + "' AND " +
        "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {

        // Bestimme passenden Wert
        sTable = "VT_1PC13_M00021" + sDB_Suffix;
        var sSQL = "SELECT IN_KLK_LAGE_1PC13 FROM " + sTable + " WHERE " +
            "HMK_BG_1PC13 = '" + HMK_BG_1PC13 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var IN_KLK_LAGE_1PC13 = aResult[0].IN_KLK_LAGE_1PC13;

            sTable = "VT_1PC13_M00007" + sDB_Suffix;
            var sSQL = "SELECT MLFB16_1PC13 FROM " + sTable + " WHERE " +
                "IN_KLK_LAGE_1PC13 = '" + IN_KLK_LAGE_1PC13 + "';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
                var MLFB16_1PC13 = aResult[0].MLFB16_1PC13;

                return MLFB16_1PC13;
            } else {
                return "ERROR";
            }
        } else {
            return "ERROR";
        }
    } else {
        return sMLFB16;
    }
}
// ################################################################################################
