//@legacy
//#mode(full-ecma)



//@import "VT_1PH3.js"


function SetGeber_Init(oData)
{
    /*
    PMD_ABU278_001_000_1PH3		Geber		MLFB09
    
    */
    
    
    if (oData && !isEmpty(oData)){
        
        Bestimme_Geber(oData);
        
    } else {
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1PH3", "A");	// Geber	(Inkrementalgeber 22 bit mit Kommutierungslage (Encoder IC22DQ) mit DQ
    }
}

/**
MLFB09	PMD_ABU278_001_000_1PH3	Geber

A		Z0021	Ohne Geber
D		00022	Inkrementalwertgeber, 22 bit, mit Kommutierungslage

AH 100 ohne und mit Geber erlaubt 	(A, D)
AH 132 nur mit Geber 				(nur D)

Prüfungen erfolgten im Parser
*/

function Bestimme_Geber(oData)
{
    // aus MLFB 09
    var MLFB09_1PH3 = oData.oParsingData.MLFB.MLFB09;
    
    if (MLFB09_1PH3 == "D"){
        var PMD_ABU278_001_000_1PH3 = "00022";
    }else if (MLFB09_1PH3 == "A"){
        var PMD_ABU278_001_000_1PH3 = "Z0021";
    }else{
        var PMD_ABU278_001_000_1PH3 = "Z0021";
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_ENCODER");
    }
    
    ECL_ActivateValue("PMD_ABU278_001_000_1PH3", PMD_ABU278_001_000_1PH3);
    ECL_SetValue("PMD_ABU278_001_000_1PH3", PMD_ABU278_001_000_1PH3);
}
