//@legacy
//#mode(full-ecma)

//@import "VT_1PH3.js"

function SetMotorBasisdaten_Init(oData) {
  /*
    PMD_ABP615_001_000_1PH3		Bemessungsleistung						            auch HMK_RATED_POWER_UI_1PH3
    PMD_AAE020_001_000_1PH3		Synchrondrehzahl						MLFB 10     auch HMK_RATED_SPEED_UI_1PH3
    PMD_ACH516_001_000_1PH3		Achshöhe								MLFB 5+6
    
    neu:
    HMK_SCHALTART_1PH3	        Schaltart                               bei MLFB10 = S (136-S) nicht reproduzierbar

    xxxxxxxxxxxxxxxxxxxxxxx		0 Art der Kühlung						MLFB 11
    
    PMD_ABV672_001_000_1PH3		Art der Befestigung	/ Bauform			MLFB12
    PMD_AAA069_001_000_1PH3		Ausführung des Lagers					MLFB14
    
    PMD_AAB007_001_000_1PH3		Schwinggrößenstufe						MLFB14
    
    
    PMD_AAA271_001_000_1PH3		Ausführung des Motors	Z0003	Asynchronmotor


    */

  if (oData && !isEmpty(oData)) {
    Bestimme_Achshoehe_1PH3(oData);
    Bestimme_Drehzahl_1PH3(oData); // evtl. mit Schaltart
    Bestimme_Leistung_1PH3(oData);
    Bestimme_Schaltart_1PH3(oData);

    Bestimme_Lager_1PH3(oData); // inkl. Schwinggrößenstufe

    Bestimme_Bauform_1PH3(oData);
  } else {
    ExecSetStandardifValueEmpty("PMD_ABP615_001_000_1PH3", "3,7"); //
    ExecSetStandardifValueEmpty("PMD_AAE020_001_000_1PH3", "1000"); //
    ExecSetStandardifValueEmpty("HMK_SCHALTART_1PH3", "00001"); //
    ExecSetStandardifValueEmpty("PMD_ACH516_001_000_1PH3", "00001"); // Achshöhe Zahlenwert
    ExecSetStandardifValueEmpty("PMD_ABV672_001_000_1PH3", "00007");
    ExecSetStandardifValueEmpty("PMD_AAA069_001_000_1PH3", "00001");
    ExecSetStandardifValueEmpty("PMD_AAB007_001_000_1PH3", "00003");
    ExecSetStandardifValueEmpty("PMD_AAA271_001_000_1PH3", "Z0003"); // Ausführung des Motors
    ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1PH3", "00008"); // Bauform
    ExecSetStandardifValueEmpty("HMK_BAUFORM_1PH3", "00001"); // Bauform
  }
}

// ####################################################################################################################
/**

*/
function Bestimme_Achshoehe_1PH3(oData) {
  // VT_1PH3_M00002	ZO MLFB0506 Achshöhe
  //	MLFB05_1PH3	MLFB06_1PH3	MLFB_0506_1PH3	PMD_ACH516_001_000_1PH3	HMK_VALUE_VALID__1PH3

  var MLFB_0506_1PH3 = oData.oParsingData.MLFB_0506_1PH3;

  var sTable = "VT_1PH3_M00002" + sDB_Suffix;
  var sSQL =
    "SELECT PMD_ACH516_001_000_1PH3 FROM " + sTable + " WHERE " + "MLFB_0506_1PH3 = '" + MLFB_0506_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var sAchshoehe = aResult[0].PMD_ACH516_001_000_1PH3;

    ECL_DeactivateAllAttributeValues("PMD_ACH516_001_000_1PH3");
    ECL_ActivateValue("PMD_ACH516_001_000_1PH3", sAchshoehe);
    ECL_SelectValue("PMD_ACH516_001_000_1PH3", sAchshoehe);

    //ECL_DisableAttribute("PMD_ACH516_001_000_1PH3");
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_AH");
  }
}
// ####################################################################################################################

function Bestimme_Drehzahl_1PH3(oData) {
  /*	VT_1PH3_M00005	ZO MLFB10 Drehzahl
            MLFB10_1PH3	PMD_AAE020_001_000_1PH3	HMK_VALUE_VALID__1PH3
        VT_1PH3_M00029	ZO MLFB10 Drehzahl
            MLFB10_1PH3 HMK_RATED_SPEED_UI_1PH3 HMK_VALUE_VALID__1PH3
    */
  var MLFB10_1PH3 = oData.oParsingData.MLFB.MLFB10;

  var sTable = "VT_1PH3_M00029" + sDB_Suffix;
  var sSQL = "SELECT HMK_RATED_SPEED_UI_1PH3 FROM " + sTable + " WHERE " +
    "MLFB10_1PH3 = '" + MLFB10_1PH3 + "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T' ORDER BY HMK_RATED_SPEED_UI_1PH3;";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var sDrehzahl = aResult[0].HMK_RATED_SPEED_UI_1PH3;

    ECL_DeactivateAllAttributeValues("PMD_AAE020_001_000_1PH3");
    ECL_ActivateValue("PMD_AAE020_001_000_1PH3", sDrehzahl);
    ECL_SelectValue("PMD_AAE020_001_000_1PH3", sDrehzahl);

    //ECL_DisableAttribute("PMD_AAE020_001_000_1PH3");
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_SPEED");
  }
}

function Bestimme_Leistung_1PH3(oData) {
  /*	 VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
        
        
    */

  var HMK_TECHDATAKEY_1PH3 = oData.oParsingData.HMK_TECHDATAKEY_1PH3;
  var PMD_AAE020_001_000_1PH3 = ECL_GetValue("PMD_AAE020_001_000_1PH3");

  var sTable = "VT_1PH3_M00027" + sDB_Suffix;
  var sSQL = "SELECT HMK_RATED_POWER_UI_1PH3 FROM " + sTable + " WHERE " +
    "HMK_TECHDATAKEY_1PH3 = '" + HMK_TECHDATAKEY_1PH3 + "' AND " +
    "HMK_RATED_SPEED_UI_1PH3 = '" + PMD_AAE020_001_000_1PH3 + "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_ABP615_001_000_1PH3 = aResult[0].HMK_RATED_POWER_UI_1PH3;

    ECL_DeactivateAllAttributeValues("PMD_ABP615_001_000_1PH3");
    ECL_ActivateValue("PMD_ABP615_001_000_1PH3", PMD_ABP615_001_000_1PH3);
    ECL_SelectValue("PMD_ABP615_001_000_1PH3", PMD_ABP615_001_000_1PH3);

    //ECL_DisableAttribute("PMD_ABP615_001_000_1PH3");
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_POWER");
  }
}

function Bestimme_Schaltart_1PH3(oData) {
  // ################################################################################################################
  // Schaltart		HMK_SCHALTART_1PH3
  // ################################################################################################################
  /*  HMK_SCHALTART_1PH3 nur bei MLFB10 = S bzw. Tech_Key = '136-S'
    nicht eindeutig reproduzierbar!!!

        VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
        
        VT_1PH3_M00034	ZO MLFB-Produktname
        VT_1PH3_M00035	ZO MLFB-Kennlinien
    */
  var HMK_TECHDATAKEY_1PH3 = oData.oParsingData.HMK_TECHDATAKEY_1PH3;
  var PMD_AAE020_001_000_1PH3 = ECL_GetValue("PMD_AAE020_001_000_1PH3");

  var sTable = "VT_1PH3_M00027" + sDB_Suffix;
  var sSQL = "SELECT HMK_RATED_POWER_UI_1PH3 FROM " + sTable + " WHERE " +
    "HMK_TECHDATAKEY_1PH3 = '" + HMK_TECHDATAKEY_1PH3 + "' AND " +
    "HMK_RATED_SPEED_UI_1PH3 = '" + PMD_AAE020_001_000_1PH3 + "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_SCHALTART_1PH3 = aResult[0].HMK_SCHALTART_1PH3;

    ECL_ActivateValue("HMK_SCHALTART_1PH3", HMK_SCHALTART_1PH3);
    ECL_SelectValue("HMK_SCHALTART_1PH3", HMK_SCHALTART_1PH3);
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_CONN_METHOD");
  }
}

function Bestimme_Lager_1PH3(oData) {
  /*	VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
        
        VT_1PH3_M00022	ZO MLFB14 Lager
            MLFB14_1PH3
            PMD_AAA069_001_000_1PH3
            PMD_AAB007_001_000_1PH3
            HMK_VALUE_VALID__1PH3
    */

  var MLFB14_1PH3 = oData.oParsingData.MLFB.MLFB14;

  var sTable = "VT_1PH3_M00022" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB14_1PH3 = '" + MLFB14_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_AAA069_001_000_1PH3 = aResult[0].PMD_AAA069_001_000_1PH3;
    var PMD_AAB007_001_000_1PH3 = aResult[0].PMD_AAB007_001_000_1PH3;

    //ECL_DeactivateAllAttributeValues("PMD_AAA069_001_000_1PH3");
    ECL_ActivateValue("PMD_AAA069_001_000_1PH3", PMD_AAA069_001_000_1PH3);
    ECL_SelectValue("PMD_AAA069_001_000_1PH3", PMD_AAA069_001_000_1PH3);

    ECL_ActivateValue("PMD_AAB007_001_000_1PH3", PMD_AAB007_001_000_1PH3);
    ECL_SelectValue("PMD_AAB007_001_000_1PH3", PMD_AAB007_001_000_1PH3);

    //ECL_DisableAttribute("PMD_AAA069_001_000_1PH3");
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_BEARING");
  }
}

// ####################################################################################################################

function Bestimme_Bauform_1PH3(oData) {
  /*
    PMD_ABV672_001_000_1PH3	Art der Befestigung
        MLFB12 = 0	00007	Fußausführung
        MLFB12 = 2	00006	Flanschausführung
        MLFB12 = 4	00008	Flanschausführung (1PH8 kompatibel)
    
    VT_1PH3_M00006	ZO MLFB12 Befestigung
        MLFB12_1PH3
        PMD_ABV672_001_000_1PH3
        HMK_VALUE_VALID__1PH3

    
    
    HMK_BAUFORM_1PH3	Bauform
        00001	IM B3 / IM V5
        00002	IM B5 / IM V1
    
    VT_1PH3_M00015	ZO Bauform
        PMD_ABV672_001_000_1PH3
        PMD_AAC949_001_000_1PH3
        HMK_AAC949_DEFAULT_1PH3
        HMK_BAUFORM_1PH3

    */
  var MLFB12_1PH3 = oData.oParsingData.MLFB.MLFB12;

  var sTable = "VT_1PH3_M00006" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "MLFB12_1PH3 = '" + MLFB12_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var PMD_ABV672_001_000_1PH3 = aResult[0].PMD_ABV672_001_000_1PH3;

    ECL_ActivateValue("PMD_ABV672_001_000_1PH3", PMD_ABV672_001_000_1PH3);
    ECL_SelectValue("PMD_ABV672_001_000_1PH3", PMD_ABV672_001_000_1PH3);
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_DESIGN");
  }

  var sTable = "VT_1PH3_M00015" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " + "PMD_ABV672_001_000_1PH3 = '" + PMD_ABV672_001_000_1PH3 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_BAUFORM_1PH3 = aResult[0].HMK_BAUFORM_1PH3;

    ECL_ActivateValue("HMK_BAUFORM_1PH3", HMK_BAUFORM_1PH3);
    ECL_SelectValue("HMK_BAUFORM_1PH3", HMK_BAUFORM_1PH3);
  } else {
    // Error
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_DESIGN");
  }
}
// ####################################################################################################################
