//@legacy
//#mode(full-ecma)

//@import "../1PH3_MLFB/Base.misc.js"

//@import "VT_1PH3.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute, HMK_PRODUKT_TRIG_1PH8) {
  var strError = "";

  var sMLFB = ECL_GetValue("ECSI_MLFB");
  var sMLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  var MLFB01_1PH3 = sMLFB.left(4);
  var MLFB05_1PH3 = sMLFB.charAt(4) + sMLFB.charAt(5); //Achshöhe
  var MLFB07_1PH3 = sMLFB.charAt(6);
  var MLFB08_1PH3 = sMLFB.charAt(7);
  var MLFB09_1PH3 = sMLFB.charAt(8);
  var MLFB10_1PH3 = sMLFB.charAt(9);
  var MLFB11_1PH3 = sMLFB.charAt(10);
  var MLFB12_1PH3 = sMLFB.charAt(11);
  var MLFB13_1PH3 = sMLFB.charAt(12);
  var MLFB14_1PH3 = sMLFB.charAt(13);
  var MLFB15_1PH3 = sMLFB.charAt(14);
  var MLFB16_1PH3 = sMLFB.charAt(15);

  var MLFB_0506_1PH3 = ECL_GetValue("MLFB_0506_1PH3");
  var HMK_TECHDATAKEY_1PH3 = ECL_GetValue("HMK_TECHDATAKEY_1PH3");

  var bGearboxMotorCoupling = false;
  var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
  if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
    bGearboxMotorCoupling = true;
  }

  // ################################################################################################################
  // Parameter durch MLFB/SIZER vorgegeben:
  // ################################################################################################################
  /*
    PMD_ACH516_001_000_1PH3	Achshöhe
    PMD_ABP615_001_000_1PH3	Bemessungsleistung	
    PMD_AAE020_001_000_1PH3	Synchrondrehzahl
    PMD_AAA271_001_000_1PH3	Ausführung des Motors
    */
  var PMD_ACH516_001_000_1PH3 = ECL_GetValue("PMD_ACH516_001_000_1PH3");
  var PMD_AAE020_001_000_1PH3 = ECL_GetValue("PMD_AAE020_001_000_1PH3");
  var PMD_ABP615_001_000_1PH3 = ECL_GetValue("PMD_ABP615_001_000_1PH3");
  var PMD_AAA271_001_000_1PH3 = ECL_GetValue("PMD_AAA271_001_000_1PH3");

  // ################################################################################################################

  // ################################################################################################################
  // Schaltart		HMK_SCHALTART_1PH3
  // ################################################################################################################
  /*  HMK_SCHALTART_1PH3 nur bei MLFB10 = S bzw. Tech_Key = '136-S'
    nicht eindeutig reproduzierbar!!!

        VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
        
        VT_1PH3_M00034	ZO MLFB-Produktname
        VT_1PH3_M00035	ZO MLFB-Kennlinien
    */
  var sTargetAttribute = "HMK_SCHALTART_1PH3";

  var sTable = "VT_1PH3_M00027" + sDB_Suffix;
  var sWhere =
    "HMK_TECHDATAKEY_1PH3 = '" +
    HMK_TECHDATAKEY_1PH3 +
    "' AND " +
    "PMD_ACH516_001_000_1PH3 = '" +
    PMD_ACH516_001_000_1PH3 +
    "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH3___PL_SCHALTART_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }
  var HMK_SCHALTART_1PH3 = ECL_GetValue("HMK_SCHALTART_1PH3");
  // ################################################################################################################

  if (MLFB10_1PH3 == "S") {
    //Drehzahl anhand Schaltart ändern
    var sTable = "VT_1PH3_M00027" + sDB_Suffix;
    var sSQL =
      "SELECT HMK_RATED_SPEED_UI_1PH3 FROM " +
      sTable +
      " WHERE " +
      "MLFB07_1PH3 = '" +
      MLFB07_1PH3 +
      "' AND " +
      "HMK_SCHALTART_1PH3 = '" +
      HMK_SCHALTART_1PH3 +
      "' AND " +
      "HMK_TECHDATAKEY_1PH3 = '" +
      HMK_TECHDATAKEY_1PH3 +
      "' AND " +
      "HMK_VALUE_VALID__1PH3 = 'T' ORDER BY HMK_RATED_SPEED_UI_1PH3;";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var sDrehzahl = aResult[0].HMK_RATED_SPEED_UI_1PH3;

      ECL_DeactivateAllAttributeValues("PMD_AAE020_001_000_1PH3");
      ECL_ActivateValue("PMD_AAE020_001_000_1PH3", sDrehzahl);
      ECL_SelectValue("PMD_AAE020_001_000_1PH3", sDrehzahl);

      //ECL_DisableAttribute("PMD_AAE020_001_000_1PH3");
    } else {
      strError = "DICT1_ERR_1PH3___PL_SCHALTART_SPEED_DB_RESULT";
      return strError;
    }
  }

  // ################################################################################################################
  // Art der Befestigung 	PMD_ABV672_001_000_1PH3						MLFB12_1PH3
  // ################################################################################################################
  /*
    PMD_ABV672_001_000_1PH3	Art der Befestigung
    
    VT_1PH3_M00006	ZO MLFB12 Befestigung		<== nur MLFB-Stelle übersetzen
        MLFB12_1PH3
        PMD_ABV672_001_000_1PH3
        HMK_VALUE_VALID__1PH3
    
    VT_1PH3_M00015	ZO Bauform
        PMD_ABV672_001_000_1PH3
        PMD_AAC949_001_000_1PH3
        HMK_AAC949_DEFAULT_1PH3
        HMK_BAUFORM_1PH3
    
    A: VT_1PH3_M00023	ZO AH-Befestigung
        PMD_ACH516_001_000_1PH3
        PMD_ABV672_001_000_1PH3
        HMK_VALUE_VALID__1PH3
    
    Wenn GearboxMotorCoupling, dann nur Standardflansch
    */
  if (bGearboxMotorCoupling) {
    var sTargetAttribute = "PMD_ABV672_001_000_1PH3";
    var aValidValues = ["00006"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH3___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  } else {
    var sTargetAttribute = "PMD_ABV672_001_000_1PH3";

    var sTable = "VT_1PH3_M00023" + sDB_Suffix;
    var sWhere = "PMD_ACH516_001_000_1PH3 = '" + PMD_ACH516_001_000_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH3___PL_BEFESTIGUNG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
    // -----------------------------------------------------------------------------------
    /*var HMK_BAUFORM_1PH3 = ECL_GetValue("HMK_BAUFORM_1PH3");
        
        var sTable = "VT_1PH3_M00015" + sDB_Suffix;
        var sWhere = 	"HMK_BAUFORM_1PH3 = '" + HMK_BAUFORM_1PH3 + "';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1PH3___PL_BEFESTIGUNG_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }*/
  }
  // -----------------------------------------------------------------------------------
  // MLFB12 aktualisieren
  var PMD_ABV672_001_000_1PH3 = ECL_GetValue("PMD_ABV672_001_000_1PH3");

  var sTable = "VT_1PH3_M00006" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB12_1PH3 FROM " +
    sTable +
    " WHERE " +
    "PMD_ABV672_001_000_1PH3 = '" +
    PMD_ABV672_001_000_1PH3 +
    "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB12_1PH3 = aResult[0].MLFB12_1PH3;
  } else {
    strError = "DICT1_ERR_1PH3___PL_MLFB12_NO_DB_RESULT";
  }

  sMLFB = replaceAt(sMLFB, 11, MLFB12_1PH3);

  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // ################################################################################################################
  // HMK_BAUFORM_1PH3	Bauform
  // ################################################################################################################
  /*	VT_1PH3_M00015	ZO Bauform
            PMD_ABV672_001_000_1PH3
            PMD_AAC949_001_000_1PH3
            HMK_AAC949_DEFAULT_1PH3
            HMK_BAUFORM_1PH3
    
    */
  var sTargetAttribute = "HMK_BAUFORM_1PH3";

  // var PMD_ABV672_001_000_1PH3 = ECL_GetValue("PMD_ABV672_001_000_1PH3");

  var sTable = "VT_1PH3_M00015" + sDB_Suffix;
  var sWhere = "PMD_ABV672_001_000_1PH3 = '" + PMD_ABV672_001_000_1PH3 + "';";

  var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

  if (sStatus == "Error") {
    // Fehler
    strError = "DICT1_ERR_1PH3___PL_BAUFORM_LOGIKFEHLER_NO_DB_RESULT";
    return strError;
  }

  // ################################################################################################################

  // ################################################################################################################
  // Ausführung des Lagers		PMD_AAA069_001_000_1PH3						MLFB14_1PH8
  // Schwinggrößenstufe			PMD_AAB007_001_000_1PH3
  // ################################################################################################################
  /*
    PMD_AAA069_001_000_1PH3	Ausführung des Lagers
        VT_1PH3_M00008	ZO Lager - ChgIntv		n.n.
        
        VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
        
        VT_1PH3_M00022	ZO MLFB14 Lager
            MLFB14_1PH3
            PMD_AAA069_001_000_1PH3
            PMD_AAB007_001_000_1PH3
            HMK_VALUE_VALID__1PH3
        
    
    PMD_AAB007_001_000_1PH3	Schwinggrößenstufe
        VT_1PH3_M00022	ZO MLFB14 Lager
            MLFB14_1PH3
            PMD_AAA069_001_000_1PH3
            PMD_AAB007_001_000_1PH3
            HMK_VALUE_VALID__1PH3
    */

  if (sMLFB_BASE_TYPE.charAt(13) == ".") {
    var sTargetAttribute = "PMD_AAA069_001_000_1PH3";

    var sTable = "VT_1PH3_M00027" + sDB_Suffix;
    var sWhere =
      "HMK_TECHDATAKEY_1PH3 = '" +
      HMK_TECHDATAKEY_1PH3 +
      "' AND " +
      "HMK_RATED_SPEED_UI_1PH3 = '" +
      PMD_AAE020_001_000_1PH3 +
      "' AND " +
      "HMK_VALUE_VALID__1PH3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH3___PL_LAGERAUSFUEHRUNG_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }

    // -----------------------------------------------------------------------------------
    // Schwinggrößenstufe			PMD_AAB007_001_000_1PH3
    var sTargetAttribute = "PMD_AAB007_001_000_1PH3";

    var PMD_AAA069_001_000_1PH3 = ECL_GetValue("PMD_AAA069_001_000_1PH3");

    var sTable = "VT_1PH3_M00022" + sDB_Suffix;
    var sWhere = "PMD_AAA069_001_000_1PH3 = '" + PMD_AAA069_001_000_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH3___PL_SCHWINGGROESSE_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }

    // -----------------------------------------------------------------------------------
    // MLFB14 aktualisieren
    //var PMD_AAA069_001_000_1PH3 = ECL_GetValue("PMD_AAA069_001_000_1PH3");
    var PMD_AAB007_001_000_1PH3 = ECL_GetValue("PMD_AAB007_001_000_1PH3");

    var sTable = "VT_1PH3_M00022" + sDB_Suffix;
    var sSQL =
      "SELECT MLFB14_1PH3 FROM " +
      sTable +
      " WHERE " +
      "PMD_AAA069_001_000_1PH3 = '" +
      PMD_AAA069_001_000_1PH3 +
      "' AND " +
      "PMD_AAB007_001_000_1PH3 = '" +
      PMD_AAB007_001_000_1PH3 +
      "' AND " +
      "HMK_VALUE_VALID__1PH3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      MLFB14_1PH3 = aResult[0].MLFB14_1PH3;
    } else {
      strError = "DICT1_ERR_1PH3___PL_MLFB14_NO_DB_RESULT";
    }

    sMLFB = replaceAt(sMLFB, 13, MLFB14_1PH3);

    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    var PMD_AAA069_001_000_1PH3 = ECL_GetValue("PMD_AAA069_001_000_1PH3");
    var PMD_AAB007_001_000_1PH3 = ECL_GetValue("PMD_AAB007_001_000_1PH3");
    ECL_DeactivateAllAttributeValues("PMD_AAA069_001_000_1PH3");
    ECL_DeactivateAllAttributeValues("PMD_AAB007_001_000_1PH3");
    ECL_ActivateValue("PMD_AAA069_001_000_1PH3", PMD_AAA069_001_000_1PH3);
    ECL_ActivateValue("PMD_AAB007_001_000_1PH3", PMD_AAB007_001_000_1PH3);
    ECL_SelectValue("PMD_AAA069_001_000_1PH3", PMD_AAA069_001_000_1PH3);
    ECL_SelectValue("PMD_AAB007_001_000_1PH3", PMD_AAB007_001_000_1PH3);
  }
  // ################################################################################################################

  // ################################################################################################################
  // PMD_AAA506_001_000_1PH3	Wellenausführung					MLFB13_1PH8
  // ################################################################################################################
  /*
        VT_1PH3_M00007	ZO MLFB13 Wellenende		<== nur MLFB-Stelle übersetzen
            MLFB13_1PH3
            PMD_AAA506_001_000_1PH3
            HMK_VALUE_VALID__1PH3
    */
  if (bGearboxMotorCoupling) {
    var sTargetAttribute = "PMD_AAA506_001_000_1PH3";
    var aValidValues = ["00005"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH3___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  } else {
    // keine Einschränkung
    var sTargetAttribute = "PMD_AAA506_001_000_1PH3";
    var aValidValues = ["00005", "00006"];

    var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH3___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  }

  // -----------------------------------------------------------------------------------
  // MLFB13 aktualisieren
  var PMD_AAA506_001_000_1PH3 = ECL_GetValue("PMD_AAA506_001_000_1PH3");

  var sTable = "VT_1PH3_M00007" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB13_1PH3 FROM " +
    sTable +
    " WHERE " +
    "PMD_AAA506_001_000_1PH3 = '" +
    PMD_AAA506_001_000_1PH3 +
    "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB13_1PH3 = aResult[0].MLFB13_1PH3;
  } else {
    strError = "DICT1_ERR_1PH3___PL_MLFB13_NO_DB_RESULT";
  }

  sMLFB = replaceAt(sMLFB, 12, MLFB13_1PH3);

  ECL_SetValue("ECSI_MLFB", sMLFB);

  // ################################################################################################################

  // ################################################################################################################
  // Gebersystem		MLFB09_1PH3		PMD_ABU278_001_000_1PH3
  // ################################################################################################################
  /*
    PMD_ABU278_001_000_1PH3	Geber
    
    VT_1PH3_M00004	ZO MLFB09 Geber		<== nur MLFB-Stelle übersetzen
        MLFB09_1PH3
        PMD_ABU278_001_000_1PH3
        HMK_VALUE_VALID__1PH3

    VT_1PH3_M00009	ZO AH-Geber
        PMD_ACH516_001_000_1PH3
        PMD_ABU278_001_000_1PH3
        HMK_VALUE_VALID__1PH3

    */
  var ECSI_CX_EncoderTypeRough = ECL_GetValue("ECSI_CX_EncoderTypeRough");
  //ECL_ActivateAllAttributeValues("PMD_ABU278_001_000_1PH8");
  if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {
    // nur Absolutwertgeber
    // Fehler, nur Inkrementalgeber
    strError = "DICT1_ERR_1PH3___PL_CX_GEBER_NICHT_GUELTIG";
    return strError;
  } else if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 0) {
    // nur Inkrementalgeber

    var sTargetAttribute = "PMD_ABU278_001_000_1PH3";

    var aValidValues = ["00022"];

    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

    if (sStatus == "Error") {
      // Fehler
      strError = ECL_Translate("DICT1_ERR_1PH3___KEIN_WERT_MEHR_WAEHLBAR_FUER") + ": " + sTargetAttribute;
      return strError;
    }
  } else {
    var sTargetAttribute = "PMD_ABU278_001_000_1PH3";

    var sTable = "VT_1PH3_M00009" + sDB_Suffix;
    var sWhere = "PMD_ACH516_001_000_1PH3 = '" + PMD_ACH516_001_000_1PH3 + "' AND " + "HMK_VALUE_VALID__1PH3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1PH3___PL_GEBER_LOGIKFEHLER_NO_DB_RESULT";
      return strError;
    }
  }
  // ----------------------------------------------------------------------------------------------------------------
  // MLFB09_1PH3 aktualisieren
  var PMD_ABU278_001_000_1PH3 = ECL_GetValue("PMD_ABU278_001_000_1PH3");

  var sTable = "VT_1PH3_M00004" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB09_1PH3 FROM " +
    sTable +
    " WHERE " +
    "PMD_ABU278_001_000_1PH3 = '" +
    PMD_ABU278_001_000_1PH3 +
    "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    MLFB09_1PH3 = aResult[0].MLFB09_1PH3;
  } else {
    strError = "DICT1_ERR_1PH3___PL_MLFB09_NO_DB_RESULT";
  }

  sMLFB = replaceAt(sMLFB, 8, MLFB09_1PH3);

  ECL_SetValue("ECSI_MLFB", sMLFB);
  // ################################################################################################################

  // ################################################################################################################
  // ################################################################################################################

  return "OK";
}
