//@legacy
//#mode(full-ecma)



//@import "VT_1PH3.js"


function SetWellenende_Init(oData)
{
    /*
    PMD_AAA506_001_000_1PH3		Ausführung des Wellenendes / an der Antriebsseite		MLFB13
    
    MLFB13 = 0		00005	Glatte Welle (ohne Passfedernut)
    MLFB13 = 2		00006	Welle mit Passfeder (Halbkeilwuchtung)

    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_Wellenende_MLFB13(oData);
    } else {
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1PH3","00006");	// Passfeder
    }
}

/**

*/
function Bestimme_Wellenende_MLFB13(oData)
{
    // MLFB 13
    var MLFB13_1PH3 = oData.oParsingData.MLFB.MLFB13;
    
    
    if (MLFB13_1PH3 == "2"){
        var PMD_AAA506_001_000_1PH3 = "00006";
    }else if (MLFB13_1PH3 == "0"){
        var PMD_AAA506_001_000_1PH3 = "00005";
    }else{
        var PMD_AAA506_001_000_1PH3 = "00005";
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH3___PARSER_SET_SHAFT_END");
    }
    
    ECL_ActivateValue("PMD_AAA506_001_000_1PH3", PMD_AAA506_001_000_1PH3);
    ECL_SetValue("PMD_AAA506_001_000_1PH3", PMD_AAA506_001_000_1PH3);
    
}
