//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1PH3_MLFB/Base.misc.js"

/**
 * @category   1PH3 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2022 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
  vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  // MLFB Freitexte
  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  // Kurzangaben aus MLFB
  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_1PH3___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_1PH3___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (oParsing.strBaseMLFB.indexOf("1PH3") < 0) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_1PH3___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var bCoolingInMLFB = false;

  // fix sind MLFB1-8 + 10, 11
  var strMLFB_fix = strMLFB.substring(0, 8) + "." + strMLFB.substring(9, 11);

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

  if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
    strStartConfiguration = "1";

  if (strStartConfiguration == "1") {
    // entweder unvollständige MLFB, also Defaults setzen oder KEEP-Configuration-Fall,
    // dann muss die MLFB aber vollständig spezifiziert sein!
    //und eine zur Haupt MLFB unterschiedliche Base Type MLFB übergeben werden.
    //Hier sollen dann möglichst viele Attribute beibehalten werden.
    if (strBaseTypeMLFB != "") {
      /* fixe-BaseTypeMLFB für Abgleich mit MLFB
            1PH31021.D0...A0
            */

      var strBaseTypeMLFB_fix =
        strBaseTypeMLFB.substring(0, 8) +
        "." +
        strBaseTypeMLFB.substring(9, 11);
    }

    // Abgleich BT (BaseTypeMLFB) und MLFB für Keep Configuration
    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if (
      strBaseTypeMLFB_fix != strMLFB_fix &&
      find(strMLFB.left(16), ".") < 0 &&
      strBaseTypeMLFB != ""
    ) {
      // #################################################################################################################
      // KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION KEEP-CONFIGURATION
      // #################################################################################################################
      //--------------------------------------------------------------------------------------------------------
      // Base-Type-MLFB aufbereiten
      //--------------------------------------------------------------------------------------------------------
      var aBTComponents = tokenize(strBaseTypeMLFB);
      if (aBTComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
          aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
        }
      }

      strBaseTypeMLFB = aBTComponents[0];

      if (strBaseTypeMLFB.length === 17) {
        // eliminate the -Z
        strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
      }

      // -----------------------------------------------------------------------------------------------
      // KAG abgleichen und ggf übernehmen/entfernen
      // -----------------------------------------------------------------------------------------------
      /* mögliche Platzhalter
                MLFB Struktur
                MLFB.MLFB01 { 1PH3 }
                MLFB.MLFB05 5+6 Achshhe { 10, 13}
                MLFB.MLFB07 Baulänge		{ 1, 2, 3, 5, 6, 7 }
                MLFB.MLFB08 1 Motortyp 	(Asynchron)
                MLFB.MLFB09 . Geber		{ A, D } (ohne, Inkrement 22 Bit)
                MLFB.MLFB10 (.) Synchrondrehzahl { D, E, F, G } (1000, 1200, 1500, 2000)
                MLFB.MLFB11 0 Kühlung (Gebläsekühlung DE nach NDE
                MLFB.MLFB12 . Bauform 	{ 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
                MLFB.MLFB13 . Wellenende (glatt/Welle mit Keil) 	{ 0, 2 }
                MLFB.MLFB14 . Lagerung + Schwinggrößenstufe	{ G, L, K } Standard/S, Performance/S, Performance/SR
                MLFB.MLFB15 A
                MLFB.MLFB16 0
            */

      // -----------------------------------------------------------------------------------------------
      // Platzhalter aus MLFB in BT übernehmen
      // -----------------------------------------------------------------------------------------------

      var sMLFB05_BT = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);

      // ---------------------------------------------------------------------------------------------------
      // MLFB09 Geber
      // ---------------------------------------------------------------------------------------------------
      /* MLFB09	PMD_ABU278_001_000_1PH3	Geber
                
                A		Z0021	Ohne Geber
                D		00022	Inkrementalwertgeber, 22 bit, mit Kommutierungslage
                
                AH 100 ohne und mit Geber erlaubt 	(A, D)
                AH 132 nur mit Geber 				(nur D)
            */

      var sMLFB09 = strMLFB.charAt(8);
      var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);

      if (sBT_MLFB09 == ".") {
        // default ohne
        /* todo keep config: check_MLFB09
         */
        var ECSI_CX_EncoderTypeRough =
          ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
        if (
          ECSI_CX_EncoderTypeRough &&
          parseInt(ECSI_CX_EncoderTypeRough) == 1
        ) {
          // nur Absolutwertgeber

          oParsing.strError =
            "DICT1_ERR_1PH3___PARSER_CX_INCREMENTAL_ENCODER_ONLY";
        } else if (
          ECSI_CX_EncoderTypeRough &&
          parseInt(ECSI_CX_EncoderTypeRough) == 0
        ) {
          // nur Inkrementalgeber
          var sMLFB09 = "D";
        } else {
          // Wenn AH 132 immer mit Geber!
          if (sMLFB05_BT == "13") {
            sMLFB09 = "D";
          }
        }
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, sMLFB09);
      }

      var bGearboxMotorCoupling = false;
      var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(
        "ECSI_CX_GearboxMotorCoupling"
      );
      if (
        strECSI_CX_GearboxMotorCoupling &&
        parseInt(strECSI_CX_GearboxMotorCoupling) == 1
      ) {
        bGearboxMotorCoupling = true;
      }

      // ---------------------------------------------------------------------------------------------------
      // Bauform MLFB12
      // ---------------------------------------------------------------------------------------------------
      /* 	0,2,4		4 (Flansch 1PH8-kompatibel) nur bei AH 132 | relevant bei KeepConfig
                bei GearboxMotorCoupling == 1 ==> Flansch? todo
            */
      // Default 0
      var sMLFB12 = strMLFB.charAt(11);
      var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);

      if (sBT_MLFB12 == ".") {
        // versuche Wert aus MLFB zu setzen:
        // Wenn AH 100 '4' nicht erlaubt
        if (sMLFB12 == "4") {
          // Flansch-Bauform:
          if (sMLFB05_BT == "10" || bGearboxMotorCoupling) {
            sMLFB12 = "2";
          }
          // setzen
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
        } else {
          if (bGearboxMotorCoupling) {
            sMLFB12 = "2";
          }
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
        }
      } else {
        if (bGearboxMotorCoupling && sBT_MLFB12 != "2") {
          oParsing.strError =
            "DICT1_ERR_1PH3___CX_GEARBOXCOUPLING_PARSER_SET_MLFB12";
        }
      }
      // ---------------------------------------------------------------------------------------------------
      // Wellenende MLFB13
      // ---------------------------------------------------------------------------------------------------
      // bei GearboxMotorCoupling == 1 ==> nur glatte Welle

      var sMLFB13 = strMLFB.charAt(12);
      var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

      if (sBT_MLFB13 == ".") {
        if (bGearboxMotorCoupling) {
          // nur glatte Welle (MLFB13 = 0)
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, "0");
        } else {
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
        }
      } else {
        if (bGearboxMotorCoupling && sBT_MLFB13 != "0") {
          oParsing.strError =
            "DICT1_ERR_1PH3___CX_GEARBOXCOUPLING_PARSER_SET_MLFB13";
        }
      }
      // ---------------------------------------------------------------------------------------------------
      // Lagerung	MLFB14
      // ---------------------------------------------------------------------------------------------------
      /*
            { G, L, K } G: Standard/S, L: Performance/S, K: Performance/SR
                    check VT11
            */
      var sMLFB14 = strMLFB.charAt(13);
      var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

      if (sBT_MLFB14 == ".") {
        // todo check
        var bCheck = checkMLFB14_Parser(strBaseTypeMLFB, sMLFB14);
        if (bCheck) {
          // setzen
          strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
        } else {
          if (sMLFB14 == "L") {
            // Wenn L nicht ging, probiere K
            checkMLFB14_Parser(strBaseTypeMLFB, "K");
            if (bCheck) {
              // Setze Default:
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "K");
            } else {
              checkMLFB14_Parser(strBaseTypeMLFB, "G");
              if (bCheck) {
                // Setze Default:
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "G");
              } else {
                oParsing.strError = "DICT1_ERR_1PH3___PARSER_SET_MLFB14";
              }
            }
          } else if (sMLFB14 == "K") {
            // Wenn K nicht ging, probiere L
            checkMLFB14_Parser(strBaseTypeMLFB, "L");
            if (bCheck) {
              // Setze Default:
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "L");
            } else {
              // sonst Standard testen
              checkMLFB14_Parser(strBaseTypeMLFB, "G");
              if (bCheck) {
                // Setze Default:
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "G");
              } else {
                oParsing.strError = "DICT1_ERR_1PH3___PARSER_SET_MLFB14";
              }
            }
          } else {
            checkMLFB14_Parser(strBaseTypeMLFB, "G");
            if (bCheck) {
              // Setze Default:
              strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "G");
            } else {
              oParsing.strError = "DICT1_ERR_1PH3___PARSER_SET_MLFB14";
            }
          }
        }
      }

      // -----------------------------------------------------------------------------------------------
      // Zuweisen der neuen MLFB und KAG-Liste
      strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

      oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
      oParsing.strFullMLFB = strMLFB;
      aComponents[0] = oParsing.strBaseMLFB;
      oParsing.aTokens = aComponents;
      ECL_SetValue("ECSI_MLFB", strMLFB);
    }
    // #######################################################################################################
    // END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END KEEP CONFIGURATION	END
    // #######################################################################################################
    else {
      // kein KEEP-Configuration, aber MLFB evtl. nicht vollständig spezifiziert
      if (find(strMLFB.left(16), ".") >= 0) {
        //Unvollständige SIZER MLFB

        // Prüfen, ob '.' an Stelle 1 bis 8, 10, 11, 15, 16 -->  dann Fehler
        for (var i = 0; i < 8; i++) {
          if (strMLFB.charAt(i) == ".") {
            oParsing.strError = "ERRORMSG_MLFB_1PH3___INCOMPLETE_MLFB";
            return oParsing;
          }
        }
        if (strMLFB.charAt(9) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1PH3___INCOMPLETE_MLFB";
          return oParsing;
        }
        if (strMLFB.charAt(10) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1PH3___INCOMPLETE_MLFB";
          return oParsing;
        }
        if (strMLFB.charAt(14) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1PH3___INCOMPLETE_MLFB";
          return oParsing;
        }
        if (strMLFB.charAt(15) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1PH3___INCOMPLETE_MLFB";
          return oParsing;
        }
        // Wenn an Stelle 9, 12, 13, 14 ein Wildcard, dann Default setzen

        /* mögliche Platzhalter
                MLFB Struktur
                    MLFB.MLFB01 { 1PH3 }
                    MLFB.MLFB05 5+6 Achshöhe 	{ 10, 13}
                    MLFB.MLFB07 Baulänge		{ 1, 2, 3, 5, 6, 7 }
                    MLFB.MLFB08 1 Motortyp 	(Asynchron)
                    MLFB.MLFB09 . Geber			{ A, D } (ohne, Inkrement 22 Bit)
                    MLFB.MLFB10 (.) Synchrondrehzahl { D, E, F, G, S } (1000, 1200, 1500, 2000)
                    MLFB.MLFB11 0 Kühlung (Gebläsekühlung DE nach NDE
                    MLFB.MLFB12 . Bauform 	{ 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
                    MLFB.MLFB13 . Wellenende (glatt/Welle mit Keil) 	{ 0, 2 }
                    MLFB.MLFB14 . Lagerung + Schwinggrößenstufe	{ G, L, K } Standard/S, Performance/S, Performance/SR
                    MLFB.MLFB15 A
                    MLFB.MLFB16 0
                */

        // ---------------------------------------------------------------------------------------------------
        // MLFB09 Geber
        // ---------------------------------------------------------------------------------------------------
        /* MLFB09	PMD_ABU278_001_000_1PH3	Geber
                    
                    A		Z0021	Ohne Geber
                    D		00022	Inkrementalwertgeber, 22 bit, mit Kommutierungslage
                    
                    AH 100 ohne und mit Geber erlaubt 	(A, D)
                    AH 132 nur mit Geber 				(nur D)
                */
        var MLFB05_1PH3 = strMLFB.charAt(4) + strMLFB.charAt(5);

        // default: AH100 ohne, AH132 D
        if (strMLFB.charAt(8) == ".") {
          /*
           */
          var ECSI_CX_EncoderTypeRough =
            ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
          if (
            ECSI_CX_EncoderTypeRough &&
            parseInt(ECSI_CX_EncoderTypeRough) == 1
          ) {
            // nur Absolutwertgeber
            // Fehler, nur Inkrementalgeber verfügbar todo
            oParsing.strError =
              "DICT1_ERR_1PH3___PARSER_CX_INCREMENTAL_ENCODER_ONLY";
          } else if (
            ECSI_CX_EncoderTypeRough &&
            parseInt(ECSI_CX_EncoderTypeRough) == 0
          ) {
            // nur Inkrementalgeber
            var MLFB09_1PH3 = "D";
          } else {
            if (MLFB05_1PH3 == "13") {
              var MLFB09_1PH3 = "D";
            } else {
              var MLFB09_1PH3 = "A";
            }
          }
          strMLFB = replaceAt(strMLFB, 8, MLFB09_1PH3);
        }

        // ---------------------------------------------------------------------------------------------------
        // fix "0" MLFB11_1PH3 Kühlart
        // ---------------------------------------------------------------------------------------------------

        // ---------------------------------------------------------------------------------------------------
        // Bauform 	MLFB12	{ 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
        // ---------------------------------------------------------------------------------------------------
        // 0,2,4		4 (Flansch 1PH8-kompatibel) nur bei AH 132 | relevant bei KeepConfig
        // bei GearboxMotorCoupling == 1 ==> Flansch? todo

        // Default 0
        if (strMLFB.charAt(11) == ".") {
          var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(
            "ECSI_CX_GearboxMotorCoupling"
          );

          if (
            strECSI_CX_GearboxMotorCoupling &&
            parseInt(strECSI_CX_GearboxMotorCoupling) == 1
          ) {
            var MLFB12_1PH3 = "2";
          } else {
            var MLFB12_1PH3 = "0";
          }
          strMLFB = replaceAt(strMLFB, 11, MLFB12_1PH3);
        }

        // ---------------------------------------------------------------------------------------------------
        // MLFB13 . Wellenende (glatt/Welle mit Keil) 	{ 0, 2 }
        // ---------------------------------------------------------------------------------------------------
        // bei GearboxMotorCoupling == 1 ==> nur glatte Welle

        // Default 0
        if (strMLFB.charAt(12) == ".") {
          var strECSI_CX_GearboxMotorCoupling = ECL_GetValue(
            "ECSI_CX_GearboxMotorCoupling"
          );

          if (
            strECSI_CX_GearboxMotorCoupling &&
            parseInt(strECSI_CX_GearboxMotorCoupling) == 1
          ) {
            var MLFB13_1PH3 = "0";
          } else {
            var MLFB13_1PH3 = "2";
          }
          strMLFB = replaceAt(strMLFB, 12, MLFB13_1PH3);
        }

        // ---------------------------------------------------------------------------------------------------
        // MLFB14 Lagerung + Schwinggrößenstufe
        // ---------------------------------------------------------------------------------------------------
        /*
                    { G, L, K } G: Standard/S, L: Performance/S, K: Performance/SR
                    check VT11
                */

        if (strMLFB.charAt(13) == ".") {
          // Setze Default:
          var bCheck = checkMLFB14_Parser(strMLFB, "G");
          if (bCheck) {
            strMLFB = replaceAt(strMLFB, 13, "G");
          } else {
            bCheck = checkMLFB14_Parser(strMLFB, "L");
            if (bCheck) {
              strMLFB = replaceAt(strMLFB, 13, "L");
            } else {
              /* // L und K sind Performancelager, Schwinggrößenstufe nicht relevant
                            bCheck = checkMLFB14_Parser(strMLFB, "K");
                            if (bCheck){
                                strMLFB = replaceAt(strMLFB, 13, "K");
                            }else{
                            */ oParsing.strError =
                "DICT1_ERR_1PH3___PARSER_SET_MLFB14";
              //}
            }
          }
        }

        // ---------------------------------------------------------------------------------------------------
        ECL_SetValue("ECSI_MLFB", strMLFB);
      }

      // Zuweisen der neuen MLFB und KAG-Liste
      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
      oParsing.aTokens = aComponents;
    }
    // Jetzt sollte immer eine vollständig spezifizierte MLFB zur Verfügung stehen
  } // der vorherige Abschnitt wurde nur bei IsStartConfiguration == 1 durchlaufen. Passt das ? todo

  // Ergebnis-Objekt zusammenbauen
  var oResult;
  oResult = parse_1PH3(oParsing.aTokens);
  //oResult = add_help_shortcuts(oResult);

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strBaseTypeMLFB = strBaseTypeMLFB;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;
    oParsing.IsStartConfig = strStartConfiguration;
  }

  vtTimeStop = Date.getTime();
  vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_1PH3(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };
  /*
    MLFB Struktur
    MLFB.MLFB01 { 1PH3 }
    MLFB.MLFB05 5+6 Achshhe { 10, 13 }
    MLFB.MLFB07 Baulänge	{ 1, 2, 3, 5, 6, 7 }
    MLFB.MLFB08 1 Motortyp 	(Asynchron)
    MLFB.MLFB09 . Geber		{ A, D } (ohne, Inkrement 22 Bit)
    MLFB.MLFB10 . Synchrondrehzahl { D, E, F, G } (1000, 1200, 1500, 2000)
    MLFB.MLFB11 0 Kühlung (Gebläsekühlung DE nach NDE
    MLFB.MLFB12 . Bauform 	{ 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
    MLFB.MLFB13 . Wellenende (glatt/Keil) 	{ 0, 2 }
    MLFB.MLFB14 . Lagerung + Schwinggrößenstufe	{ G, L, K } Standard/S, Performance/S, Performance/SR
    MLFB.MLFB15 A
    MLFB.MLFB16 0
    */
  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4); // 1PH3
  oResult.oParsingData.MLFB.MLFB05 =
    strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5); // 5+6 Achshöhe		{ 10, 13 }
  oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt(6); // (.) Baulänge			{ 1, 2, 3, 5, 6, 7 }
  oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt(7); // 1 Motortyp (Async)
  oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt(8); // . Geber				{ A, D } (ohne, Inkrement 22 Bit)
  oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt(9); // (.) Synchrondrehzahl { D, E, F, G, S } (1000, 1200, 1500, 2000) (S: 1000 default, 2000 möglich je Schaltart, nicht eindeutig)
  oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt(10); // 0 Kühlart										0,1,2
  oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt(11); // . Bauform { 0, 2, 4 }	(Fußbefestigung, Flanschbefestigung, Flansch 1PH8-kompatibel)
  oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt(12); // . Wellenende (glatt/Keil) 	{ 0, 2 }
  oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt(13); // . Lagerung + Schwinggrößenstufe	{ G, L, K } Standard/S, Performance/S, Performance/SR
  oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt(14); // A
  oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt(15); // 0

  // Rümpfe

  // MLFB_0506_1PH3
  var MLFB_0506_1PH3 = oResult.oParsingData.MLFB.MLFB05;
  // HMK_TECHDATAKEY_1PH3	MLFB.05.06.07_10 Key f.techn.Daten
  var HMK_TECHDATAKEY_1PH3 =
    MLFB_0506_1PH3 +
    oResult.oParsingData.MLFB.MLFB07 +
    "-" +
    oResult.oParsingData.MLFB.MLFB10;

  oResult.oParsingData.MLFB_0506_1PH3 = MLFB_0506_1PH3;
  oResult.oParsingData.HMK_TECHDATAKEY_1PH3 = HMK_TECHDATAKEY_1PH3;

  ECL_SetValue("MLFB_0506_1PH3", MLFB_0506_1PH3);
  ECL_SetValue("HMK_TECHDATAKEY_1PH3", HMK_TECHDATAKEY_1PH3);

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens;

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}

// ###############################################################################################################
// Prüfroutinen für KEEP CONFIGURATION
// ###############################################################################################################

function checkMLFB14_Parser(sMLFB, sMLFB14) {
  /*
    Über VT11 prüfen, ob es zum HMK_TECHDATAKEY_1PH3 Standard- oder nur Performance-Lager gibt
    
    VT_1PH3_M00027	ZO AH-Lstg-Dz-Lager-MLFB07-techKey
            PMD_ACH516_001_000_1PH3     
            HMK_RATED_POWER_UI_1PH3     PMD_ABP615_001_000_1PH3
            HMK_RATED_SPEED_UI_1PH3     PMD_AAE020_001_000_1PH3
            PMD_AAA069_001_000_1PH3
            MLFB07_1PH3
            HMK_MOTORLAENGE_1PH3
            HMK_SCHALTART_1PH3          neu
            HMK_TECHDATAKEY_1PH3
            HMK_VALUE_VALID__1PH3
    */
  //var sTargetAttribute = "MLFB14_1PH3";
  var sTargetAttribute = "PMD_AAA069_001_000_1PH3";
  if (sMLFB14 == "G") {
    var PMD_AAA069_001_000_1PH3 = "00001";
  } else {
    var PMD_AAA069_001_000_1PH3 = "00002";
  }
  var HMK_TECHDATAKEY_1PH3 =
    sMLFB.charAt(4) + sMLFB.charAt(5) + sMLFB.charAt(6) + "-" + sMLFB.charAt(9);

  var sTable = "VT_1PH3_M00027" + sDB_Suffix;
  // StandardLager:
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "HMK_TECHDATAKEY_1PH3 = '" +
    HMK_TECHDATAKEY_1PH3 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    PMD_AAA069_001_000_1PH3 +
    "' AND " +
    "HMK_VALUE_VALID__1PH3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }

  // ----------------------------------------------------------------------------------------------------------------
  return 1;
}
// ################################################################################################
