//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"

function SetAnschlusstechnik_Init(oData) {
  /*
    HMK_ANSCHL_KK_1PH8			Leistungsanschluss
    HMK_LAGE_KK_1PH8			Lage
    PMD_ABU208_001_000_1PH8		Position der Kabeleinführung für Leistungsleitung
    PMD_ABU203_001_000_1PH8		Anordnung des elektrischen Anschlusses / für Signalleitung
    O_K83_K84_K85_1PH8			Drehen des Klemmenkastens
    O_P00_BIS_P06_1PH8			Leitungseinführungsplatte
    O_L00_1PH8					Austausch Klemmenkasten durch den nächst Größeren
    O_Q00_1PH8					Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten
    HMK_KK_1PH8					Klemmenkasten-Hilfsmerkmal
    HMK_KK_2_1PH8				Klemmenkasten 2. Hilfsmerkmal
    HMK_REAL_KK_1PH8			Klemmenkasten
    
    * Klemmenkasten
*,$set_default($self,HMK_ANSCHL_KK_1PH8,'00001')
    
    Klemmkastenlage default
    $set_default($self,HMK_LAGE_KK_1PH8,'00001')
if not HMK_LAGE_KK_1PH8 specified
   and HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
   and HMK_ANSCHL_KK_1PH8 EQ '00001'
   and HMK_DIREKT_FERTIG_1PH8 EQ 'T'


    * Default K08, K09, K10
,$SET_DEFAULT($SELF,O_K09_K10_1PH8,'STD') IF
        $SELF.HMK_KONFIG_TYP_1PH8 = 'DIREKT'
     AND $SELF.HMK_DIREKT_FERTIG_1PH8 = 'T'
     AND $SELF.HMK_ANSCHL_KK_1PH8 = '00002'
     AND NOT $SELF.O_K09_K10_1PH8 specified
*
,$SET_DEFAULT($SELF,O_K08_1PH8,'F') IF
        $SELF.HMK_KONFIG_TYP_1PH8 = 'DIREKT'
    AND $SELF.HMK_DIREKT_FERTIG_1PH8 = 'T'
    AND $SELF.HMK_ANSCHL_KK_1PH8 = '00001'
    AND NOT $SELF.O_K08_1PH8 specified

    */

  if (oData && !isEmpty(oData)) {
    // zunächst KAGs Bestimmen
    // O_K08_1PH8
    Bestimme_K08(oData); // O_K08_1PH8					Signalanschluss gegenüberliegend
    // O_K09_K10_1PH8
    Bestimme_K09_K10(oData); // HMK_LAGE_KK_1PH8				Lage			+ O_K09_K10_1PH8
    // O_K83_K84_K85_1PH8
    Bestimme_K83_K84_K85(oData); // O_K83_K84_K85_1PH8			Drehen des Klemmkastens

    Bestimme_Leistungsanschluss(oData); // HMK_ANSCHL_KK_1PH8			Leistungsanschluss
    //Bestimme_LageKK(oData);					// HMK_LAGE_KK_1PH8				Lage
    //Bestimme_Position_Anordnung(oData);			// + PMD_ABU208_001_000_1PH8		Position der Kabeleinführung für Leistungsleitung
    // + PMD_ABU203_001_000_1PH8		Anordnung des elektrischen Anschlusses / für Signalleitung
    // + HMK_KK_1PH8					Klemmenkasten-Hilfsmerkmal
    // HMK_KK_2_1PH8			Klemmenkasten 2. Hilfsmerkmal n.n.

    Bestimme_L00(oData); // O_L00_1PH8				Austausch Klemmenkasten durch den nächst Größeren			CB_O_L00_1PH8
    Bestimme_RealKK_1PH8(oData); // HMK_REAL_KK_1PH8			Klemmenkasten

    Bestimme_P00_BIS_P06(oData); // O_P00_BIS_P06_1PH8		Leitungseinführungsplatte

    Bestimme_Q00(oData); // O_Q00_1PH8				Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten			CB_O_Q00_1PH8
  } else {
    ExecSetStandardifValueEmpty("HMK_ANSCHL_KK_1PH8", "00001"); // Leistungsanschluss 'Klemmkasten'
    ExecSetStandardifValueEmpty("HMK_LAGE_KK_1PH8", "00001"); // Lage 'NDE oben'
    ExecSetStandardifValueEmpty("PMD_ABU208_001_000_1PH8", "0001"); // Position der Kabeleinführung für Leistungsleitung 'rechts'
    ExecSetStandardifValueEmpty("PMD_ABU203_001_000_1PH8", "00001"); // Anordnung des elektrischen Anschlusses 'DE'
    ExecSetStandardifValueEmpty("O_K83_K84_K85_1PH8", "NON"); // Drehen des Klemmenkastens
    ExecSetStandardifValueEmpty("O_P00_BIS_P06_1PH8", "NON"); // Leitungseinführungsplatte
    ExecSetStandardifValueEmpty("O_K08_1PH8", "F"); // Signalanschluss gegenüberliegend
  }
}

function SetAnschlusstechnik(strchangedAttribute, oData) { }
/**

*/
// ###############################################################################################################
//Bestimme_K08(oData);						// O_K08_1PH8					Signalanschluss gegenüberliegend
function Bestimme_K08(oData) {
  var aKAG = oData.oParsingData.MLFB.KAG || [];
  var bCheck = false;
  if (aKAG.indexOf("K08") > -1) {
    bCheck = check_K08_1PH9(oData);
  }
  if (bCheck) {
    ECL_ActivateValue("O_K08_1PH8", "K08");
    ECL_SelectValue("O_K08_1PH8", "K08");
  } else {
    ECL_ActivateValue("O_K08_1PH8", "F");
    ECL_SelectValue("O_K08_1PH8", "F");
  }
}
function check_K08_1PH9(oData) {
  // -----------------------------------------------------------------------------------------
  if (oData.IsDriveTrain == "true" && MLFB15_1PH8 == "X") return 0;
  // -----------------------------------------------------------------------------------------

  /* Auswertung A
    nur für AH 180, 225, 280
    Prüfen, ob überhaupt wählbar, für weitere Einschränkungen
    
    A: VT_1PH8_M00307	K08-AH-MLFB09-MLFB15					==> Auswertung vor Anschlussart
        MLFB05_1PH8	MLFB09_1PH8	MLFB15_1PH8	O_K08_1PH8
    */
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;
  var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;

  var sTable = "VT_1PH8_M00307" + sDB_Suffix;
  var sSQL = "SELECT O_K08_1PH8 FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "O_K08_1PH8 = 'K08';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// ###############################################################################################################
// Bestimme_K09_K10(oData);						// HMK_LAGE_KK_1PH8				Lage		O_K09_K10_1PH8
function Bestimme_K09_K10(oData) {
  // KAGs K09, K10, STD
  var sTargetAttribute = "O_K09_K10_1PH8";
  var bCheck;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON") {
    bCheck = check_K09_K10(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SelectValue(sTargetAttribute, sKAG);
  } else {
    ECL_ActivateValue(sTargetAttribute, "STD");
    ECL_SelectValue(sTargetAttribute, "STD");
  }
}
function check_K09_K10(oData, sTargetAttribute, sKAG) {
  // -----------------------------------------------------------------------------------------
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;

  /* A: 
    VT_1PH8_M00537	AH-MLFB12-K09-K10				Achshöhe und Bauform
        MLFB05_1PH8	MLFB12_1PH8	O_K09_K10_1PH8
    */
  var sTable = "VT_1PH8_M00537" + sDB_Suffix;
  var sSQL = "SELECT O_K09_K10_1PH8 FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  // B:
  // VT_1PH8_M00358	K09-K10-G00-G11
  //	O_K09_K10_1PH8	O_G00_B_G11_1PH8
  var O_G00_B_G11_1PH8 = ECL_GetValue("O_G00_B_G11_1PH8");

  var sTable = "VT_1PH8_M00358" + sDB_Suffix;
  var sSQL = "SELECT O_K09_K10_1PH8 FROM " + sTable + " WHERE " +
    "O_G00_B_G11_1PH8 = '" + O_G00_B_G11_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* C: 
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	HMK_LAGE_KK_1PH8	
        PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	HMK_VALUE_VALID_1PH8
    */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");
  var O_K08_1PH8 = ECL_GetValue("O_K08_1PH8");
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sSQL = "SELECT O_K09_K10_1PH8 FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_K08_1PH8 = '" + O_K08_1PH8 + "' AND " +
    //sWhere_K08 +
    //"O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +		// Drehen des Klemmkastens nachrangig
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    //"PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    //"PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    //"HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// ###############################################################################################################
// Bestimme_K83_K84_K85(oData);				// O_K83_K84_K85_1PH8			Drehen des Klemmkastens
function Bestimme_K83_K84_K85(oData) {
  // KAGs K83, K84, K85, NON
  var sTargetAttribute = "O_K83_K84_K85_1PH8";
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON") {
    bCheck = check_K83_K84_K85(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SetValue(sTargetAttribute, sKAG);
  } else {
    ECL_ActivateValue(sTargetAttribute, "NON");
    ECL_SetValue(sTargetAttribute, "NON");
  }
}

function check_K83_K84_K85(oData, sTargetAttribute, sKAG) {
  // -----------------------------------------------------------------------------------------
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;
  /* A: 
    VT_1PH8_M00371	K83-K84-K85-AH-MLFB11-15
        O_K83_K84_K85_1PH8	MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8
    */
  var sTable = "VT_1PH8_M00371" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // --------------------------------------------------------------------------------------------
  /* B: 
    VT_1PH8_M00376	Anschlusstechnik_MLFB15
        MLFB05_1PH8	MLFB11_1PH8	MLFB15_1PH8	O_K08_1PH8	O_K09_K10_1PH8	O_K83_K84_K85_1PH8	HMK_ANSCHL_KK_1PH8	
            HMK_LAGE_KK_1PH8	PMD_ABU208_001_000_1PH8	PMD_ABU203_001_000_1PH8	HMK_KK_IMG_ID_1PH8	HMK_KK_1PH8	
            HMK_VALUE_VALID_1PH8
    */
  var O_K08_1PH8 = ECL_GetValue("O_K08_1PH8");
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");
  //var PMD_ABU203_001_000_1PH8 = ECL_GetValue("PMD_ABU203_001_000_1PH8");
  //var PMD_ABU208_001_000_1PH8 = ECL_GetValue("PMD_ABU208_001_000_1PH8");
  //var HMK_LAGE_KK_1PH8 = ECL_GetValue("HMK_LAGE_KK_1PH8");
  //var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    "O_K08_1PH8 = '" + O_K08_1PH8 + "' AND " +
    "O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    //"PMD_ABU203_001_000_1PH8 = '" + PMD_ABU203_001_000_1PH8 + "' AND " +
    //"PMD_ABU208_001_000_1PH8 = '" + PMD_ABU208_001_000_1PH8 + "' AND " +
    //"HMK_LAGE_KK_1PH8 = '" + HMK_LAGE_KK_1PH8 + "' AND " +
    //"HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "HMK_VALUE_VALID_1PH8 = 'T' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}

// ###############################################################################################################
// Bestimme_Leistungsanschluss(oData);
// Leistungsanschluss
// Lage
// PMD_ABU208_001_000_1PH8		Position der Kabeleinführung für Leistungsleitung
// PMD_ABU203_001_000_1PH8		Anordnung des elektrischen Anschlusses / für Signalleitung
function Bestimme_Leistungsanschluss(oData) {
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;
  var H_RUMPF_050710_0811_1PH8 = oData.oParsingData.H_RUMPF_050710_0811_1PH8;
  var O_K08_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K08_1PH8", "T")) O_K08_1PH8 = "K08";
  var O_K09_K10_1PH8 = ECL_GetValue("O_K09_K10_1PH8");
  var O_K83_K84_K85_1PH8 = ECL_GetValue("O_K83_K84_K85_1PH8");

  var sTable = "VT_1PH8_M00376" + sDB_Suffix;
  var sTableB = "VT_1PH8_M00636" + sDB_Suffix;
  var sSQL = "SELECT DISTINCT " +
    sTable + ".HMK_ANSCHL_KK_1PH8, " +
    sTable + ".HMK_LAGE_KK_1PH8, " +
    sTable + ".PMD_ABU208_001_000_1PH8," +
    sTable + ".PMD_ABU203_001_000_1PH8, " +
    sTable + ".HMK_KK_1PH8 FROM " + sTable +
    " INNER JOIN " + sTableB + " ON " +
    sTable + ".HMK_KK_1PH8 = " + sTableB + ".HMK_KK_1PH8 WHERE " +
    sTable + ".MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    sTable + ".MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sTable + ".MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
    sTable + ".O_K08_1PH8 = '" + O_K08_1PH8 + "' AND " +
    sTable + ".O_K09_K10_1PH8 = '" + O_K09_K10_1PH8 + "' AND " +
    sTable + ".O_K83_K84_K85_1PH8 = '" + O_K83_K84_K85_1PH8 + "' AND " +
    sTable + ".HMK_VALUE_VALID_1PH8 = 'T' AND " +
    sTableB + ".H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_ANSCHL_KK_1PH8 = aResult[0].HMK_ANSCHL_KK_1PH8;
    ECL_ActivateValue("HMK_ANSCHL_KK_1PH8", HMK_ANSCHL_KK_1PH8);
    ECL_SetValue("HMK_ANSCHL_KK_1PH8", HMK_ANSCHL_KK_1PH8);

    var HMK_LAGE_KK_1PH8 = aResult[0].HMK_LAGE_KK_1PH8;
    ECL_ActivateValue("HMK_LAGE_KK_1PH8", HMK_LAGE_KK_1PH8);
    ECL_SetValue("HMK_LAGE_KK_1PH8", HMK_LAGE_KK_1PH8);

    var PMD_ABU208_001_000_1PH8 = aResult[0].PMD_ABU208_001_000_1PH8;
    ECL_ActivateValue("PMD_ABU208_001_000_1PH8", PMD_ABU208_001_000_1PH8);
    ECL_SetValue("PMD_ABU208_001_000_1PH8", PMD_ABU208_001_000_1PH8);

    var PMD_ABU203_001_000_1PH8 = aResult[0].PMD_ABU203_001_000_1PH8;
    ECL_ActivateValue("PMD_ABU203_001_000_1PH8", PMD_ABU203_001_000_1PH8);
    ECL_SetValue("PMD_ABU203_001_000_1PH8", PMD_ABU203_001_000_1PH8);

    // HMK_KK_1PH8
    var HMK_KK_1PH8 = aResult[0].HMK_KK_1PH8;
    ECL_ActivateValue("HMK_KK_1PH8", HMK_KK_1PH8);
    ECL_SetValue("HMK_KK_1PH8", HMK_KK_1PH8);
  } else {
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_ANSCHLUSSART");
  }
}
// ###############################################################################################################

function Bestimme_RealKK_1PH8(oData) {
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");
  var O_L00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) O_L00_1PH8 = "L00";

  var H_RUMPF_050710_0811_1PH8 = oData.oParsingData.H_RUMPF_050710_0811_1PH8;

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sSQL = "SELECT HMK_REAL_KK_1PH8 FROM " + sTable + " WHERE " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    //sWhereMLFB09_Gruppe +
    //sWhereMLFB15_Gruppe +
    "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    "O_L00_1PH8 = '" + O_L00_1PH8 + "';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var HMK_REAL_KK_1PH8 = aResult[0].HMK_REAL_KK_1PH8;
    ECL_ActivateValue("HMK_REAL_KK_1PH8", HMK_REAL_KK_1PH8);
    ECL_SelectValue("HMK_REAL_KK_1PH8", HMK_REAL_KK_1PH8);
  } else {
    oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_HMK_REAL_KK_1PH8");
  }

}

// ################################################################################################################
//Bestimme_P00_BIS_P06(oData);				// O_P00_BIS_P06_1PH8			Leitungseinführungsplatte
function Bestimme_P00_BIS_P06(oData) {
  // KAGs P00, P01, P02, P03, P04, P05, P06, NON
  var sTargetAttribute = "O_P00_BIS_P06_1PH8";
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];

  // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON") {
    bCheck = check_P00_BIS_P06(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SelectValue(sTargetAttribute, sKAG);
  } else {
    ECL_ActivateValue(sTargetAttribute, "NON");
    ECL_SelectValue(sTargetAttribute, "NON");
  }
}

function check_P00_BIS_P06(oData, sTargetAttribute, sKAG) {
  // -----------------------------------------------------------------------------------------
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
  var HMK_REAL_KK_1PH8 = ECL_GetValue("HMK_REAL_KK_1PH8");

  /*
    VT_1PH8_M00518	P00-P06-AH
        MLFB05_1PH8	MLFB11_1PH8	HMK_REAL_KK_1PH8	O_P00_BIS_P06_1PH8
    */
  var sTable = "VT_1PH8_M00518" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "HMK_REAL_KK_1PH8 = '" + HMK_REAL_KK_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }

  // -----------------------------------------------------------------------------------------
  return 1;
}

// ###############################################################################################################
// Bestimme_L00(oData);						// O_L00_1PH8					Austausch Klemmenkasten durch den nächst Größeren			CB_O_L00_1PH8
function Bestimme_L00(oData) {
  var sTargetAttribute = "O_L00_1PH8";
  var sKAG = "L00";
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];
  // O_L00_1PH8
  if (aKAG.indexOf("L00") >= 0) {
    bCheck = check_L00(oData, sTargetAttribute, sKAG);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_L00_1PH8");
    ECL_SelectValue("CB_O_L00_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_L00_1PH8");
  }
}

function check_L00(oData, sTargetAttribute, sKAG) {
  // -----------------------------------------------------------------------------------------
  /*
    VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8

    VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    
    VT_1PH8_M00627	Klemmenkasten, L00, Q00
        HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8
    */
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  /* VT_1PH8_M00636	Klemmenkasten_Erweiterung_L00
      HMK_MLFB09_GRUPPE_1PH8  HMK_MLFB15_GRUPPE_1PH8  H_RUMPF_050710_0811_1PH8    O_L00_1PH8    HMK_KK_1PH8   HMK_REAL_KK_1PH8
    */
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");

  //var HMK_MLFB09_GRUPPE_1PH8 = ECL_GetValue("HMK_MLFB09_GRUPPE_1PH8");
  //var HMK_MLFB15_GRUPPE_1PH8 = ECL_GetValue("HMK_MLFB15_GRUPPE_1PH8");
  var H_RUMPF_050710_0811_1PH8 = oData.oParsingData.H_RUMPF_050710_0811_1PH8;

  var sTable = "VT_1PH8_M00636" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    //"HMK_MLFB09_GRUPPE_1PH8 = '" + HMK_MLFB09_GRUPPE_1PH8 + "' AND " +
    //"HMK_MLFB15_GRUPPE_1PH8 = '" + HMK_MLFB15_GRUPPE_1PH8 + "' AND " +
    "H_RUMPF_050710_0811_1PH8 = '" + H_RUMPF_050710_0811_1PH8 + "' AND " +
    "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------------------------
  /* VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    */
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");

  var sTable = "VT_1PH8_M00491" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  //VT_1PH8_M00627	Klemmenkasten, L00, Q00
  //    HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8

  var sTable = "VT_1PH8_M00627" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }

  // -----------------------------------------------------------------------------------------
  return 1;
}

// ###############################################################################################################
// Bestimme_Q00(oData);						// O_Q00_1PH8					Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten			CB_O_Q00_1PH8

function Bestimme_Q00(oData) {
  var bCheck = false;
  var aKAG = oData.oParsingData.MLFB.KAG || [];
  // O_Q00_1PH8
  if (aKAG.indexOf("Q00") >= 0) {
    bCheck = check_Q00(oData);
  }
  if (bCheck) {
    ECL_EnableAttribute("CB_O_Q00_1PH8");
    ECL_SelectValue("CB_O_Q00_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_O_Q00_1PH8");
  }
}

function check_Q00(oData) {
  if (oData.IsDriveTrain == "true") return 0;
  // -----------------------------------------------------------------------------------------

  // nur AH 280

  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;

  /* behandelt über VT491
    if (MLFB05_1PH8 != "28"){
        return 0;
    }*/

  /*if (oData.IsStartConfig == "0") {
    return 1;
  }*/
  // -----------------------------------------------------------------------------------------
  /* nur AH 280
    VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        HMK_ANSCHL_KK_1PH8	O_L00_1PH8	O_Q00_1PH8	MLFB05_1PH8	MLFB11_1PH8
    */

  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  var O_L00_1PH8 = ECL_GetValue("O_L00_1PH8");
  var O_L00_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_L00_1PH8", "T")) {
    O_L00_1PH8 = "L00";
  }
  var HMK_ANSCHL_KK_1PH8 = ECL_GetValue("HMK_ANSCHL_KK_1PH8");

  var sTable = "VT_1PH8_M00491" + sDB_Suffix;
  var sSQL = "SELECT * FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    "O_L00_1PH8 = '" + O_L00_1PH8 + "' AND " +
    "HMK_ANSCHL_KK_1PH8 = '" + HMK_ANSCHL_KK_1PH8 + "' AND " +
    "O_Q00_1PH8 = 'Q00';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  //VT_1PH8_M00627	Klemmenkasten, L00, Q00
  //    HMK_KK_1PH8 O_L00_1PH8  O_Q00_1PH8
  var HMK_KK_1PH8 = ECL_GetValue("HMK_KK_1PH8");

  var sTable = "VT_1PH8_M00627" + sDB_Suffix;
  var sSQL =
    "SELECT * FROM " + sTable + " WHERE " + "HMK_KK_1PH8 = '" + HMK_KK_1PH8 + "' AND " + "O_L00_1PH8 = '" + O_L00_1PH8 + "' AND O_Q00_1PH8 = 'Q00';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------
  return 1;
}
