//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetBauform_Init(oData)
{
    /* HMK_BAUFORM_1PH8 nicht eindeutig reproduzierbar, Abbildung über PMD_AAC949_001_000_1PH8
    HMK_BAUFORM_1PH8		Bauform		MLFB 12
    PMD_AAC949_001_000_1PH8	Bauform der drehenden elektrischen Maschine / gemäß Code I
    */
    
    if (oData && !isEmpty(oData)){
        Bestimme_Bauform(oData);		
    } else {
        ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1PH8","00003");	// B3 Produktabhängig
    }
}

function SetBauform(strchangedAttribute, oData)
{
    
}
/**
Merkmalsausprägung ergibt sich aus MLFB-Stellen 12 + 13 in der Tabelle VT_1LE1X_M00007_17944.
Wenn MLFB-Stelle 12 + 13 = 90: dann Spezifizierung durch Kurzangabe
*/
function Bestimme_Bauform(oData)
{
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB12_1PH8 = oData.oParsingData.MLFB.MLFB12;
    var PMD_ABU276_001_000_1PH8 = "F";
    if (ECL_ValueSelected("CB_HALTEBREMSE_1PH8", "T")){
        PMD_ABU276_001_000_1PH8 = "T";
    }
    // Bestimmung PMD_AAC949_001_000_1PH8
    var sTable = "VT_1PH8_M00447" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT PMD_AAC949_001_000_1PH8 FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB12_1PH8 = '" + MLFB12_1PH8 + "' AND " +							// CheckBauform mit Bremse anders lösen todo
                "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var PMD_AAC949_001_000_1PH8 = aResult[0].PMD_AAC949_001_000_1PH8;
        
        ECL_ActivateValue("PMD_AAC949_001_000_1PH8", PMD_AAC949_001_000_1PH8);
        ECL_SelectValue("PMD_AAC949_001_000_1PH8", PMD_AAC949_001_000_1PH8);
        
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_BAUFORM");
    }
    
/*	HMK_BAUFORM_1PH8 ist nicht eindeutig reproduzierbar, daher nur Abbildung von PMD_AAC949_001_000_1PH8
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    // Bauform B3
    if (MLFB12_1PH8 == '0'){
        ECL_SelectValue(HMK_BAUFORM_1PH8, '00001');
    }
    // Bauform V5
    if (MLFB12_1PH8 == '1'){
        ECL_SelectValue(HMK_BAUFORM_1PH8, '00017');
    }
    
    // Bauform B5
    if (MLFB12_1PH8 == '2'){
        switch(MLFB05_1PH8){
            
            case '08':
            case '10':
            case '13':
            case '16':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00023');
            break;
            
            case '18':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00024');
            break;
            
            case '22':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00025');
            break;
            
            case '28':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00026');
            break;
        }
    }

    // Bauform B35
    if (MLFB12_1PH8 == '3'){
        switch(MLFB05_1PH8){
            
            case '10':
            case '13':
            case '16':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00019');
            break;
            
            case '18':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00020');
            break;
            
            case '22':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00021');
            break;
            
            case '28':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00022');
            break;
        }
    }
    
    // Bauform V15
    if (MLFB12_1PH8 == '5'){
        switch(MLFB05_1PH8){
        
            case '18':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00014');
            break;
            
            case '22':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00015');
            break;
            
            case '28':
                ECL_SelectValue(HMK_BAUFORM_1PH8, '00016');
            break;
        }
    }
    
    // VT447 Übersetzung MLFB in PMD_AAC949_001_000_1PH8 (Bauform der drehenden elektrischen Maschine / gemäß Code I)
    // und Abhängigkeit Bremse
    
    // VT459 Übersetzung PMD_AAC949_001_000_1PH8 in HMK_BAUFORM_1PH8	
*/
    
}


/*
PMD_AAC949_001_000_1PH8

00001	IM B3
00002	IM B3 (IM B6, I...M B8, IM V6)
00003	IM B3 (IM V5, IM V6)
00004	IM B3 (IM V6)
00005	IM B35 (IM V15, IM V35)
00006	IM B35 mit Flan...450 (IM V35)
00007	IM B35 mit Flan...550 (IM V35)
00008	IM B35 mit Flan...660 (IM V35)
00009	IM B35 mit Flansch A800
00010	IM B5 (IM V1, IM V3)
00011	IM B5 mit Flansch A450 (IM V3)
00012	IM B5 mit Flansch A550 (IM V3)
00013	IM B5 mit Flansch A660 (IM V3)
00014	IM V15 mit Flansch A450
00015	IM V15 mit Flansch A550
00016	IM V15 mit Flansch A660
00017	IM V5
00018	IM B3 (IM B6, IM B7, IM B8)

HMK_BAUFORM_1PH8
00001	IM B3
00009	IM B35 mit Flansch A800
00014	IM V15 mit Flansch A450
00015	IM V15 mit Flansch A550
00016	IM V15 mit Flansch A660
00017	IM V5
00019	IM B35
00020	IM B35 mit Flansch A450
00021	IM B35 mit Flansch A550
00022	IM B35 mit Flansch A660
00023	IM B5
00024	IM B5 mit Flansch A450
00025	IM B5 mit Flansch A550
00026	IM B5 mit Flansch A660
00027	IM B6
00028	IM B7
00029	IM B8
00030	IM V1
00031	IM V15
00032	IM V3
00033	IM V3 mit Flansch A450
00034	IM V3 mit Flansch A550
00035	IM V3 mit Flansch A660
00036	IM V35
00037	IM V35 mit Flansch A550
00038	IM V35 mit Flansch A450
00039	IM V35 mit Flansch A660
00040	IM V6


* Default bei Konfigurationstyp *= DIREKT
*
*Bauform B3
$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00001') IF
        HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
        AND MLFB12_1PH8 EQ '0'
*
*Bauform V5
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00017') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB12_1PH8 EQ '1'
*
*Bauform B5
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00023') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '08'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00023') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '10'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00023') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '13'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00023') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '16'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00024') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '18'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00025') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '22'
       AND MLFB12_1PH8 EQ '2'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00026') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '28'
       AND MLFB12_1PH8 EQ '2'
*
*Bauform B35
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00019') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '10'
       AND MLFB12_1PH8 EQ '3'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00019') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '13'
       AND MLFB12_1PH8 EQ '3'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00019') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '16'
       AND MLFB12_1PH8 EQ '3'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00022') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '28'
       AND MLFB12_1PH8 EQ '3'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00020') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '18'
       AND MLFB12_1PH8 EQ '3'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00021') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '22'
       AND MLFB12_1PH8 EQ '3'
*
*Bauform V15
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00016') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '28'
       AND MLFB12_1PH8 EQ '5'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00014') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '18'
       AND MLFB12_1PH8 EQ '5'
,$SET_DEFAULT($self,HMK_BAUFORM_1PH8,'00015') IF
       HMK_KONFIG_TYP_1PH8 EQ 'DIREKT'
       AND MLFB05_1PH8 EQ '22'
       AND MLFB12_1PH8 EQ '5'



*/