//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"

function SetBremse_Init(oData) {
  /*
    CB_HALTEBREMSE_1PH8				Checkbox mit/ohne Bremse
    HMK_AUSFUEHR_BREMSE_1PH8		Ausführung Bremse
    HMK_SPANNUNG_BREMSE_1PH8		Versorgungsspannung
    O_U60_BIS_U68_1PH8				Haltebremse
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_Bremse(oData);
  } else {
    ECL_DeselectAttribute("CB_HALTEBREMSE_1PH8");
    ExecSetStandardifValueEmpty("HMK_AUSFUEHR_BREMSE_1PH8", "NON"); //
    ExecSetStandardifValueEmpty("HMK_SPANNUNG_BREMSE_1PH8", "230"); //
    ExecSetStandardifValueEmpty("O_U60_BIS_U68_1PH8", "NON"); //
  }
}

function SetBremse(strchangedAttribute, oData) { }
/**

*/
function Bestimme_Bremse(oData) {
  // ################################################################################################################
  // Produktbestandteil / Haltebremse	PMD_ABU276_001_000_1PH8		Abbildung über CB_HALTEBREMSE
  // ################################################################################################################
  /*
    Da von SIZER vorgegeben, verlagerung in Parser. Dort erfolgt die Prüfung, ob möglich. Alle anderen Objekte sind dann abhängig / nachrangig.
    CB_HALTEBREMSE_1PH8 Checkbox anstelle von PMD_ABU276_001_000_1PH8
    */

  // Wenn Bremse im SIZER gefordert, immer "T", sonst fest auf "ohne" ("F"). Attribut aber nur sekundär,

  var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
  var bBremseGefordert = false;

  if (strwithBrake == "1") {
    // Wenn Vorgabe aus SIZER:
    bBremseGefordert = true;
  }

  /*
    // Motortyp und Bremse MLFB08: 
    3 Async mit Bremse, 
    4 Sync  mit Bremse
    6 Reluktanz mit Bremse Effizienzgest. Ausf. (LEA)
    8 Reluktanz mit Bremse Leistungsgest. Ausf.	(LEA)
    */

  if (bBremseGefordert) {
    ECL_DeactivateValue("O_U60_BIS_U68_1PH8", "NON"); // Produktlogik hängt an diesem Attribut
    ECL_DeactivateValue("HMK_AUSFUEHR_BREMSE_1PH8", "NON");

    ECL_SelectValue("CB_HALTEBREMSE_1PH8", "T");
    ECL_DisableAttribute("CB_HALTEBREMSE_1PH8");

    // ################################################################################################################
    // Haltebremse (KAG)		O_U60_BIS_U68_1PH8
    // ################################################################################################################
    /*	
        KAG: NON, U60, U65, U61, U66, U62, U67, U63, U68
        Kombination aus HMK_AUSFUEHR_BREMSE_1PH8 und HMK_SPANNUNG_BREMSE_1PH8 ergibt KAG
        */
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // O_U60_BIS_U68_1PH8
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var sTargetAttribute = "O_U60_BIS_U68_1PH8";

    var O_U60_BIS_U68_1PH8 = "NON";

    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);
    var bCheck = false;

    // Edit 2025/10: U63--> U64 <== deferred till supported in SPC-version
    /*if (sKAG == "U63") {
      sKAG = "U64";
    }*/

    if (sKAG != "NON" /*&& oData.IsStartConfig == "1"*/) {
      bCheck = check_KAG_Bremse(oData, sKAG, sTargetAttribute);
    }

    if (bCheck) {
      ECL_ActivateValue("O_U60_BIS_U68_1PH8", sKAG);
      ECL_SelectValue("O_U60_BIS_U68_1PH8", sKAG);
      O_U60_BIS_U68_1PH8 = sKAG;
    } else {
      // es muss eine Optione gewählt werden
      var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
      var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
      var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
      // get valid KAG
      var sTable = "VT_1PH8_M00340" + sDB_Suffix;
      var sSQL = "SELECT O_U60_BIS_U68_1PH8 FROM " + sTable + " WHERE " +
        "O_U60_BIS_U68_1PH8 <> 'NON' AND " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
        "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' ORDER BY O_U60_BIS_U68_1PH8;";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        O_U60_BIS_U68_1PH8 = aResult[0].O_U60_BIS_U68_1PH8;
        ECL_ActivateValue("O_U60_BIS_U68_1PH8", O_U60_BIS_U68_1PH8);
        ECL_SelectValue("O_U60_BIS_U68_1PH8", O_U60_BIS_U68_1PH8);
      } else {
        oData.strError +=
          " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_BRAKEDATA");
      }
    }
    // ################################################################################################################

    // ################################################################################################################
    // Ausführung Bremse				HMK_AUSFUEHR_BREMSE_1PH8
    // ################################################################################################################
    // Versorgungsspannung Bremse		HMK_SPANNUNG_BREMSE_1PH8
    // ################################################################################################################
    /*
        VT_1PH8_M00423	Haltebremse
            PMD_ABU276_001_000_1PH8	O_U60_BIS_U68_1PH8	HMK_AUSFUEHR_BREMSE_1PH8	HMK_SPANNUNG_BREMSE_1PH8	HMK_VALUE_VALID_1PH8
        */

    var sTable = "VT_1PH8_M00423" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
      "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
      "HMK_VALUE_VALID_1PH8 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var HMK_AUSFUEHR_BREMSE_1PH8 = aResult[0].HMK_AUSFUEHR_BREMSE_1PH8;
      var HMK_SPANNUNG_BREMSE_1PH8 = aResult[0].HMK_SPANNUNG_BREMSE_1PH8;

      ECL_ActivateValue("HMK_AUSFUEHR_BREMSE_1PH8", HMK_AUSFUEHR_BREMSE_1PH8);
      ECL_SetValue("HMK_AUSFUEHR_BREMSE_1PH8", HMK_AUSFUEHR_BREMSE_1PH8);

      ECL_ActivateValue("HMK_SPANNUNG_BREMSE_1PH8", HMK_SPANNUNG_BREMSE_1PH8);
      ECL_SetValue("HMK_SPANNUNG_BREMSE_1PH8", HMK_SPANNUNG_BREMSE_1PH8);
    } else {
      oData.strError +=
        " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_BRAKEDATA");
    }

    // ################################################################################################################
  } else {
    ECL_DeactivateAllAttributeValues("O_U60_BIS_U68_1PH8"); // Produktlogik hängt an diesem Attribut
    ECL_ActivateValue("O_U60_BIS_U68_1PH8", "NON"); // Produktlogik hängt an diesem Attribut
    ECL_SetValue("O_U60_BIS_U68_1PH8", "NON"); // Produktlogik hängt an diesem Attribut

    ECL_DeactivateAllAttributeValues("HMK_AUSFUEHR_BREMSE_1PH8");
    ECL_ActivateValue("HMK_AUSFUEHR_BREMSE_1PH8", "NON");
    ECL_SelectValue("HMK_AUSFUEHR_BREMSE_1PH8", "NON");

    ECL_DeselectAttribute("CB_HALTEBREMSE_1PH8");
  }
}

function check_KAG_Bremse(oData, sKAG, sTargetAttribute) {
  if (oData.IsStartConfig == "0") return 1;
  // --------------------------------------------------------
  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  var sTable = "VT_1PH8_M00340" + sDB_Suffix;
  var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
    "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
    "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
    sTargetAttribute + " = '" + sKAG + "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ----------------------------------------------------------------------------------------------------------------

  return 1;
}
