//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"
//@import "CFG_1PH8_EXCEPTIONS.js"

// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration
function determineConsequences_1PH8(sECSI_MLFB, HMK_PRODUKT_TRIG_1PH8) {
  var normalizedMLFB = replace(sECSI_MLFB, "-Z", "");
  normalizedMLFB = replace(sECSI_MLFB, "-", "");
  var baseMLFB = left(normalizedMLFB, 16);
  var ka = right(
    normalizedMLFB,
    normalizedMLFB.length > 16 ? normalizedMLFB.length - 16 : 0
  );

  // old: getN_Max(baseMLFB, ka, HMK_PRODUKT_TRIG_1PH8)
  // new in 11/2024: getN_Max() // from configuration
  var oConsequences = {
    MaxRotationSpeedLimit: getN_Max_1PH8(),
    //AdditionalInertia 		: determineOneConsequence(baseMLFB, ka, 'AdditionalInertia', 	 	'sum'),
    //MinPulseFrequency		: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
    IpProtectionLevelMotor: getIpProtectionLevelMotor(),
    BrakeID: getBrakeID(sECSI_MLFB, HMK_PRODUKT_TRIG_1PH8),
  };

  return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
  var dRet = 0;
  if (operator == "min") dRet = 99999;
  var aOrigins =
    Object.fromDatabase(
      "1PH8_ADD_DATA",
      "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" +
      consequence +
      "' "
    ) || [];

  for (var i = 0; i < aOrigins.length; i++) {
    var resval = determineOneConsequenceOrigin(
      baseMLFB,
      ka,
      consequence,
      operator,
      aOrigins[i].ORIGIN
    );
    if (resval != -99999) {
      if (operator == "min" && resval < dRet) dRet = resval;
      else if (operator == "max" && resval > dRet) dRet = resval;
      else if (operator == "sum") dRet += resval;
    }
  }
  var strRet = "";
  if (dRet != 0 && dRet != 99999) strRet = "" + dRet; // als String zurückliefern
  return strRet;
}

function determineOneConsequenceOrigin(
  baseMLFB,
  ka,
  consequence,
  operator,
  origin
) {
  //if (baseMLFB.left(4) == "1LE1"){ // falls nötig, ggf. HMK_PRODUKT_TRIG_1PH8
  var aResult = Object.fromDatabase(
    "1PH8_ADD_DATA",
    "select * from CONSEQUENCES where CONSEQUENCE = '" +
    consequence +
    "' and ORIGIN = '" +
    origin +
    "' order by OPTION DESC"
  );
  /*}else if (baseMLFB.left(4) == "1MB1"){
        var aResult = Object.fromDatabase("1PH8_ADD_DATA", "select * from CONSEQUENCES_MB where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");
    }*/
  for (var i = 0; i < aResult.length; i++) {
    var mlfbPattern = aResult[i]["PATTERN"];
    var dbKAG = aResult[i]["OPTION"];
    var origin = aResult[i]["ORIGIN"]; // für jeden Origin nur max. einen Wert bestimmen
    var resval = aResult[i]["RES_VALUE"] - 0; // Wert als Zahl bestimmen

    var matchP = true;
    if (mlfbPattern) {
      if (!EK_regFound(baseMLFB, mlfbPattern)) matchP = false;
    }
    var matchK = true;
    if (dbKAG) {
      if (find(ka, dbKAG) < 0) matchK = false;
    }
    if (matchP && matchK) {
      return resval;
    }
  }
  return -99999;
}

function getBrakeID(sECSI_MLFB, HMK_PRODUKT_TRIG_1PH8) {
  /**
    
    //Bremsen Consequences
    */
  var sBrakeID = "";
  /*
    O_U60_BIS_U68_1PH8	Haltebremse		NON		Ohne
    O_U60_BIS_U68_1PH8	Haltebremse		U60		AC 230 V
    O_U60_BIS_U68_1PH8	Haltebremse		U61		AC 230 V mit Mikroschalter
    O_U60_BIS_U68_1PH8	Haltebremse		U62		AC 230 V mit Handlüfthebel
    O_U60_BIS_U68_1PH8	Haltebremse		U63		AC 230 V mit Mikroschalter und Handlüfthebel
    O_U60_BIS_U68_1PH8	Haltebremse		U65		DC 24 V
    O_U60_BIS_U68_1PH8	Haltebremse		U66		DC 24 V mit Mikroschalter
    O_U60_BIS_U68_1PH8	Haltebremse		U67		DC 24 V mit Handlüfthebel
    O_U60_BIS_U68_1PH8	Haltebremse		U68		DC 24 V mit Mikroschalter und Handlüfthebel
    */

  /*
    BrakeIDs
    neu:
  DC_1PH808_0
  AC_1PH808_0
  DC_1PH810_0
  AC_1PH810_0
  alt:
    DC_1PH813_0
    AC_1PH813_0
    DC_1PH816_0
    AC_1PH816_0
    */

  if (ECL_ValueSelected("CB_HALTEBREMSE_1PH8", "T")) {
    var HMK_SPANNUNG_BREMSE_1PH8 = ECL_GetValue("HMK_SPANNUNG_BREMSE_1PH8");
    var sBG = sECSI_MLFB.charAt(4) + sECSI_MLFB.charAt(5);

    /*
    HMK_SPANNUNG_BREMSE_1PH8	24	24 V	DC
    HMK_SPANNUNG_BREMSE_1PH8	230	230 V	AC
    */
    if (sBG == "08") {
      if (HMK_SPANNUNG_BREMSE_1PH8 == "24") {
        sBrakeID = "DC_1PH808_0";
      } else {
        sBrakeID = "AC_1PH808_0";
      }
    } else if (sBG == "10") {
      if (HMK_SPANNUNG_BREMSE_1PH8 == "24") {
        sBrakeID = "DC_1PH810_0";
      } else {
        sBrakeID = "AC_1PH810_0";
      }
    } else if (sBG == "13") {
      if (HMK_SPANNUNG_BREMSE_1PH8 == "24") {
        sBrakeID = "DC_1PH813_0";
      } else {
        sBrakeID = "AC_1PH813_0";
      }
    } else if (sBG == "16") {
      if (HMK_SPANNUNG_BREMSE_1PH8 == "24") {
        sBrakeID = "DC_1PH816_0";
      } else {
        sBrakeID = "AC_1PH816_0";
      }
    } else if (sBG == "18") {
      if (HMK_SPANNUNG_BREMSE_1PH8 == "24") {
        sBrakeID = "DC_1PH818_0";
      } else {
        sBrakeID = "AC_1PH818_0";
      }
    } else if (sBG == "22") {
      sBrakeID = "AC_1PH822_0"; // 230V only
    } else {
      //Fehler
      return "ERROR: Kein Treffer für BrakeID";
    }
  } else {
    sBrakeID = "";
  }

  return sBrakeID;
}
function getN_Max_1PH8() {
  // Edit 11/2024 new n-max handling from configuration
  var N_Max = parseInt(ECL_GetValue("HMK_N_MAX_T_1PH8")); // n-max-total from configuration
  return N_Max;
}
/*function getN_Max(baseMLFB, ka, HMK_PRODUKT_TRIG_1PH8) {
  var MLFB05_1PH8 = baseMLFB.charAt(4);
  var MLFB05_06_1PH8 = baseMLFB.substring(4, 6);
  var MLFB07_1PH8 = baseMLFB.charAt(6);
  var MLFB08_1PH8 = baseMLFB.charAt(7);
  var MLFB09_1PH8 = baseMLFB.charAt(8);
  var MLFB10_1PH8 = baseMLFB.charAt(9);
  var MLFB11_1PH8 = baseMLFB.charAt(10);
  var MLFB12_1PH8 = baseMLFB.charAt(11);
  var MLFB14_1PH8 = baseMLFB.charAt(13);
  var shortOptions = ka; //Kurzangaben KA
  var N_Max_Geber = -1;
  var N_Max_Lager = -1;
  var N_Max = -1;

  // Query external Geber (Encoder) Table
  var sQuery = "SELECT NMAX FROM GEBER WHERE MLFB09='" + MLFB09_1PH8 + "';";
  var aDbResult = Object.fromDatabase("1PH8_MAX_ROTATION_SPEED", sQuery);
  if (aDbResult.length === 1) {
    if (aDbResult[0]["NMAX"] == "-1") {
      if (HMK_PRODUKT_TRIG_1PH8 == "1PH8_LEA") {
        N_Max_Geber = 12000; // Limit durch Lagerung immer kleiner!
      } else {
        N_Max_Geber = 24000; // Limit durch Lagerung immer kleiner!
      }
    } else {
      N_Max_Geber = aDbResult[0]["NMAX"];
    }
  }

  // Query external Lagerung (Bearing) Table
  var sQuery =
    "SELECT * FROM LAGER " +
    "WHERE MLFB05_06='" +
    MLFB05_06_1PH8 +
    "' " +
    "AND MLFB08='" +
    MLFB08_1PH8 +
    "' " +
    "AND MLFB14='" +
    MLFB14_1PH8 +
    "';";

  var aDbResult = Object.fromDatabase("1PH8_MAX_ROTATION_SPEED", sQuery);

  // We need to further filter on MLFB07, MLFB09, MLFB10, MLFB11, MLFB12
  if (aDbResult.length > 0) {
    for (var i = 0; i < aDbResult.length; i++) {
      // Check if the value we have is found in the db record.
      // Checking for either-or cases (;) and for arbitrary cases (?)
      try {
        checkField(aDbResult[i]["MLFB07"], MLFB07_1PH8);
        checkField(aDbResult[i]["MLFB09"], MLFB09_1PH8);
        checkField(aDbResult[i]["MLFB10"], MLFB10_1PH8);
        checkField(aDbResult[i]["MLFB11"], MLFB11_1PH8);
        checkField(aDbResult[i]["MLFB12"], MLFB12_1PH8);
        // TODO check shortoptions
        // e.x: ka = "Z Q12"
        checkShortOptions(aDbResult[i]["SHORTOPTIONS"], shortOptions);
        N_Max_Lager = aDbResult[i]["NMAX"];
      } catch (RotationSpeedDatabaseError) {
        // Catch exception thrown during the value checks and continue if any check fails,
        // meaning that the current record isn't what we are looking for.
        continue;
      }
    }
  }

  // Decide on the value to use
  // always use smaller value
  // Lagerung (bearing) seems more restricitve in general,
  // so in case of equality just go with that.
  if (N_Max_Geber !== -1 && N_Max_Lager !== -1 && N_Max_Geber < N_Max_Lager) {
    N_Max = N_Max_Geber;
  } else if (
    N_Max_Geber !== -1 &&
    N_Max_Lager !== -1 &&
    N_Max_Lager <= N_Max_Geber
  ) {
    N_Max = N_Max_Lager;
  } else if ((N_Max_Geber === -1 || N_Max_Lager === -1) && N_Max === -1) {
    N_Max = N_Max_Geber === -1 ? N_Max_Lager : N_Max_Geber;
  }

  return N_Max;
}
*/
function checkField(fieldValue, charToFind) {
  // handle single-digit value
  var fieldValueAsString = fieldValue.toString();
  if (fieldValueAsString.length === 1 && fieldValue !== "?") {
    if (fieldValue == charToFind) {
      return;
    }
    throw new RotationSpeedDatabaseError(
      "Field value does not contain character:" + charToFind
    );
  }

  // handle either-or
  else if (fieldValue.indexOf(";") > -1) {
    var possibleValues = fieldValue.split(";");
    for (var i = 0; i < possibleValues.length; i++) {
      if (possibleValues[i] == charToFind) {
        return;
      }
    }
    throw new RotationSpeedDatabaseError(
      "Field value does not contain character:" + charToFind
    );
  }

  // handle arbitrary
  else if (fieldValue === "?") {
    return;
  }

  // in any other case, exception is thrown that indicates that this record should not be considered
  else {
    throw new RotationSpeedDatabaseError(
      "Field value does not contain character:" + charToFind
    );
  }
}

function checkShortOptions(fieldValue, shortOptions) {
  var normalizedShortOptions = shortOptions.replace("Z ", "");
  var shortOptionsToFind = normalizedShortOptions.split("+");

  // handle single value
  if (
    fieldValue !== "?" &&
    fieldValue !== "" &&
    fieldValue.indexOf(";") === -1
  ) {
    for (var i = 0; i < shortOptionsToFind.length; i++) {
      if (fieldValue === shortOptionsToFind[i]) {
        return;
      }
    }
    throw new RotationSpeedDatabaseError(
      "Field value does not contain short option:" + fieldValue
    );
  }

  // handle either-or values (there is no such value as of 2021.12.07 but going defensive assuming the same notation: ";")
  else if (fieldValue.indexOf(";") > -1) {
    throw new RotationSpeedDatabaseTooManyShortOptions(
      "Field values containing more than 1 short options are not supported. Values found:" +
      fieldValue
    );
  }
  // handle arbitrary value
  else if (fieldValue === "?") {
    return;
  }

  // in any other case, exception is thrown that indicates that this record should not be considered
  else {
    throw new RotationSpeedDatabaseError(
      "Field value does not contain character:" + charToFind
    );
  }
}

function getIpProtectionLevelMotor() {
  // PMD_ABJ176_001_000_1PH8  	Schutzart
  var IpProtectionLevelMotor = "";
  /*
    Z0038	IP23
    Z0003	IP55
    Z0023	IP65

    */
  var PMD_ABJ176_001_000_1PH8 = ECL_GetValue("PMD_ABJ176_001_000_1PH8");

  switch (PMD_ABJ176_001_000_1PH8) {
    case "Z0038":
      IpProtectionLevelMotor = "23";
      break;

    case "Z0003":
      IpProtectionLevelMotor = "55";
      break;

    case "Z0023":
      IpProtectionLevelMotor = "65";
      break;
  }
  return IpProtectionLevelMotor;
}

/*
Berechnungen Trägheitsmoment

* Gewicht und Trägheitsmoment ist Motor- + Bremsen-Werte
*
objects:
c is_a (300) skey '1PH8',
d is_a (300) skey '1002197',
e is_a (300) skey '1006351',
f is_a (300) skey '1006342'
restrictions:
d.PMD_ABU132_001_000_1002197 =
                             e.PMD_AAB904_001_000_1006351
                          + d.PMD_ACC394_001_000_1002197
IF c.PMD_ABU276_001_000_1PH8 = 'T',
*
d.PMD_ABU132_001_000_1002197 = e.PMD_AAB904_001_000_1006351
IF c.PMD_ABU276_001_000_1PH8 = 'F',

aus VT 541 UI-VT-Trägheit übersetzt mit VT399 in PMD_AAB904_001_000_1006351

Bremse soll nicht bestandteil sein!!! analog 1LE1
*/
