//@legacy
//#mode(full-ecma)

//@import "VT_1PH8.js"

function SetGebersystem_Init(oData) {
  /*
    MLFB 09 Geber
    CB_DRIVE_CLIQ_1PH8	 ==> 	TAK_ABU215_001_000_1PH8		Produktbestandteil / Drive-CLiQ-Schnittstelle		VT_1PH8_M00425
    PMD_ABU278_001_000_1PH8		Ausführung des Sensors / integriert					identisch zu Wert aus MLFB 09
    O_G80_H56_H75_1PH8			Anbau-Gebersystem									VT_1PH8_M00306 und VT_1PH8_M00348
    
    Default DriveCLiQ
    *,$set_default($self,TAK_ABU215_001_000_1PH8,'T')
    
    */

  if (oData && !isEmpty(oData)) {
    Bestimme_DriveCLiQ(oData);
    Bestimme_Sensorausfuehrung(oData);
    Bestimme_AnbauGebersystem(oData);
  } else {
    ECL_SelectValue("CB_DRIVE_CLIQ_1PH8", "T"); // Default mit Drive-CLiQ-Schnittstelle
    //ExecSetStandardifValueEmpty("TAK_ABU215_001_000_1PH8","T");	// Drive-CLiQ-Schnittstelle	 ==> CB_DRIVE_CLIQ_1PH8
    ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1PH8", "A"); // Ausführung des Sensors / integriert	(Inkrementalgeber 22 bit mit Kommutierungslage (Encoder IC22DQ) mit DQ
    ExecSetStandardifValueEmpty("O_G80_H56_H75_1PH8", "NON"); // Anbau-Gebersystem
  }
}

function SetGebersystem(strchangedAttribute, oData) {}
/**

*/
function Bestimme_DriveCLiQ(oData) {
  // MLFB 16
  var MLFB16_1PH8 = oData.oParsingData.MLFB.MLFB16;

  if (MLFB16_1PH8 == "1") {
    ECL_EnableAttribute("CB_DRIVE_CLIQ_1PH8");
    ECL_SelectValue("CB_DRIVE_CLIQ_1PH8", "T");
  } else {
    ECL_DeselectAttribute("CB_DRIVE_CLIQ_1PH8");
  }
}

function Bestimme_Sensorausfuehrung(oData) {
  // aus MLFB 09
  var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;

  var sTargetAttribute = "PMD_ABU278_001_000_1PH8";

  var ECSI_CX_EncoderTypeRough =
    ECL_GetValue("ECSI_CX_EncoderTypeRough") || false;
  var aValidValues = [];

  if (ECSI_CX_EncoderTypeRough && parseInt(ECSI_CX_EncoderTypeRough) == 1) {
    // nur Absolutwertgeber
    aValidValues = ["A", "E", "F"];
  } else if (
    ECSI_CX_EncoderTypeRough &&
    parseInt(ECSI_CX_EncoderTypeRough) == 0
  ) {
    // nur Inkrementalgeber
    aValidValues = ["A", "H", "J", "M", "T", "C", "D", "U", "S", "G", "K"]; // W, Y nicht mehr erlaubt
  }

  if (ECSI_CX_EncoderTypeRough) {
    if (aValidValues.indexOf(MLFB09_1PH8) > -1) {
      ECL_ActivateValue(sTargetAttribute, MLFB09_1PH8);
      ECL_SetValue(sTargetAttribute, MLFB09_1PH8);
    } else {
      ECL_ActivateValue(sTargetAttribute, "A");
      ECL_SetValue(sTargetAttribute, "A");
    }
  } else {
    ECL_ActivateValue(sTargetAttribute, MLFB09_1PH8);
    ECL_SetValue(sTargetAttribute, MLFB09_1PH8);
  }

  /*
    alt VT_1PH8_M00243	Gebersystem_MLFB09		// Nur Übersetzung, PMD_ABU278_001_000_1PH8 nicht nötig, keine weiteren Vorkommen
    neu VT_1PH8_M00624	Gebersystem_MLFB09		// Nur Übersetzung, PMD_ABU278_001_000_1PH8 nicht nötig, keine weiteren Vorkommen
        MLFB09_1PH8		PMD_ABU278_001_000_1PH8
        MLFB09_1PH8     PMD_ABU278_001_000_1PH8     HMK_KONFIG_TYP_1PH8     HMK_VALUE_VALID_1PH8
    W und Y nicht mehr für konfiguration erlaubt (25908, 21.33)
    * /
    ECL_ActivateValue(sTargetAttribute, MLFB09_1PH8);
    ECL_SetValue(sTargetAttribute, MLFB09_1PH8);
    */
}

function Bestimme_AnbauGebersystem(oData) {
  // KAGs: G80, H56, H75, NON
  // O_G80_H56_H75_1PH8
  var bCheck = false;
  // nur bei AH 280 Auswahl möglich

  var aKAG = oData.oParsingData.MLFB.KAG || [];
  var sTargetAttribute = "O_G80_H56_H75_1PH8";

  var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

  if (sKAG != "NON" /*&& oData.IsStartConfig == "1"*/) {
    bCheck = check_AnbauGebersystem(oData, sTargetAttribute, sKAG);
  }

  if (bCheck) {
    ECL_ActivateValue(sTargetAttribute, sKAG);
    ECL_SelectValue(sTargetAttribute, sKAG);
  } else {
    ECL_ActivateValue(sTargetAttribute, "NON");
    ECL_SelectValue(sTargetAttribute, "NON");
  }
}
function check_AnbauGebersystem(oData, sTargetAttribute, sKAG) {
  if (oData.IsStartConfig == "0") return 1;
  // -----------------------------------------------------------------------------------------
  if (oData.IsDriveTrain == "true") return 0;
  // -----------------------------------------------------------------------------------------

  var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
  var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;
  var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;

  var sTable = "VT_1PH8_M00306" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "MLFB05_1PH8 = '" +
    MLFB05_1PH8 +
    "' AND " +
    "MLFB09_1PH8 = '" +
    MLFB09_1PH8 +
    "' AND " +
    "MLFB11_1PH8 = '" +
    MLFB11_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // ----------------------------------------------------------------------------------------------------------------
  var O_K16_1PH8 = "F";
  if (ECL_ValueSelected("CB_O_K16_1PH8", "T")) {
    O_K16_1PH8 = "K16";
  }

  var sTable = "VT_1PH8_M00348" + sDB_Suffix;
  var sSQL =
    "SELECT " +
    sTargetAttribute +
    " FROM " +
    sTable +
    " WHERE " +
    "O_K16_1PH8 = '" +
    O_K16_1PH8 +
    "' AND " +
    sTargetAttribute +
    " = '" +
    sKAG +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    return 0;
  }
  // -----------------------------------------------------------------------------------------------------------
  return 1;
}
