//@legacy
//#mode(full-ecma)





function isLetter(strValue)
{
    var objRegExp  = /^[a-zA-Z]$/;
    return objRegExp.test(strValue);
}
    
function isDigit(strValue)
{
    var objRegExp  = /^\d/;
    return objRegExp.test(strValue);
}

function formatFreetext(ka, ft)
{
    // Keine Freitexte erzeugen, wenn Text leer ist; dies führt nämlich zu größeren Problemen im Sizer
    if (!ft || (ft == ''))
        return '';
        
    // Filterung von Sonderzeichen im Freitext: {, }
    ft = replace(ft, '{', '');
    ft = replace(ft, '}', '');
        
    // var strRet = '{' + ka + ': *' + ft + '*}';
    var strRet = '{' + ka + ':' + ft + '}';
    return strRet;
}

// Siehe hierzu auch die korrespondierende Funktion zum Parsen von Freitextangaben und
// befüllen der Attribute
function getFreetextSD(attrValNetto)
{
    /* Freitextattribute
    O_Y84_1PH8				Kundenangabe auf dem Leistungsschild
    H_O_Y84_1006333			Kundenangabe auf dem Leistungsschild (Textfeld)
    O_Y82_1002197			Zusatzschild mit Bestellerangaben
    H_O_Y82_1006333			Zusatzschild mit Bestellerangaben (Textfeld)
    
    Y64 ???? 	O_Y64_1PH8	Vorbereitung für lagerlosen Drehverteiler

    */
    
    var strRet = '';
    if (attrValNetto == 'Y84') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('H_O_Y84_1006333'));
    }
    else if (attrValNetto == 'Y82') {
        strRet = formatFreetext(attrValNetto, ECL_GetValue('H_O_Y82_1006333'));
    }
    
    return strRet;
}

/*

>>>> Diese Merkmale können einen Wert annehmen, der bedeutet, dass eine Klartextangabe erforderlich wird:
O_Y84_1PH8				Kundenangabe auf dem Leistungsschild
O_Y82_1002197			Zusatzschild mit Bestellerangaben

Y64 ???? 	O_Y64_1PH8	Vorbereitung für lagerlosen Drehverteiler
    

>>>> Diese Merkmale enthalten dann die Klartexte:

H_O_Y84_1006333			Kundenangabe auf dem Leistungsschild (Textfeld)
H_O_Y82_1006333			Zusatzschild mit Bestellerangaben (Textfeld)

Y64 ???? 	O_Y64_1PH8	Vorbereitung für lagerlosen Drehverteiler

*/

function getAdditionalSD(aKag, aKagFt)
{	// Arrays werden als Referenz übergeben und können hier weiter gefüllt werden

    // Absoluter Spezialfall: Sonderlackierung
    var kaFarbcode = ECL_GetValue('H_RAL_TYP_1LE1X');
    var gewaehlteFarbe = ECL_GetValue('H_RAL_FARBE_1LE1X');
    if (left(kaFarbcode, 1) == 'Y') {
        var ka = left(kaFarbcode, 3);
        aKag.push(ka);
        aKagFt.push(formatFreetext(ka, gewaehlteFarbe));
    }
    
    
}

/**
    Funktion zur Generierung der Kurzangaben anhand der gewählten Merkmale
    Beispiel für einen Fall mit Klartextangaben aus dem Bereich 2KJ:  
    2KJ3203-1BC21-4AK1-Z D01 +K01 +K08 +L02 +M55 +N38 +P91 +W21 +Y00 +Y80 {Y00: *LSK@myident*}{Y80: *RAL@5000*}
*/
function GenKAG(sBaseTypeMLFB, sECSI_MLFB)
{
    var newBaseMLFB = left(sECSI_MLFB, 16);
    
    // Aus der Datenbank "1PH8_ADD_DATA" die tabelle "DATA" durchlaufen und für alle Attribute, die als KAG gekennzeichnet sind,
    // schauen, ob der gesetzte Wert eine Kurzangabe hergibt (3 Stellen, nicht STD oder NON, Format ANN). Die übernehmen wir dann.
    // Zusätzlich müssen wir ...
    // - die Checkboxen analysieren und KAGs generieren
    // - Kurzangaben die sich aus mehreren Attributen ergeben bestimmen (spezielle Tabellen)
    // - Klartextangaben generieren
    var aKag   = [];
    var aKagFt = []; // Free Texts

    // Wir gehen alle Attribute durch, die als KAG gekennzeichnet sind und nicht als Checkbox abgebildet sind. 
    // Wenn ein Wert mit Kurzangabe selektiert ist, dann KAG erzeugen.
    // Bei Kurzangaben, die einen Klartext erfordern, bestimmen wir diesen auch
    if (ECL_GetValue("HMK_PRODUCT_TRIGGER") == "1PH8_LEA"){
        var aResult = Object.fromDatabase("1PH8_ADD_DATA", "select distinct Attribute from DATA where IsKAG = 'x' and IsCB <> 'x' and LEA = 'x'");
    }else{
        var aResult = Object.fromDatabase("1PH8_ADD_DATA", "select distinct Attribute from DATA where IsKAG = 'x' and IsCB <> 'x' and Abbilden_1PH8 = 'x'");
}
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['ATTRIBUTE'];
        var attrVal = ECL_GetValue(attrname); 
        // Die Attributwerte enthalten wohl nicht den Attributnamen, wohl aber die Dict-Ids der Werte
        // Sicherheitshalber strippen wir hier aber auch
        var attrValNetto = replace(attrVal, attrname, '');
        attrValNetto = replace(attrValNetto, '___', '');
        
        if ((attrValNetto.length == 3) && (attrValNetto != 'STD') && (attrValNetto != 'NON') ) {
            if (isLetter(attrValNetto.charAt(0)) && isDigit(attrValNetto.charAt(1)) && isDigit(attrValNetto.charAt(2)))
                aKag.push(attrValNetto);
                
            if (attrValNetto.charAt(0) == 'Y' && attrValNetto != 'Y64') {
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrValNetto);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    // Checkbox-Attribute
    if (ECL_GetValue("HMK_PRODUCT_TRIGGER") == "1PH8_LEA"){
        var aResult = Object.fromDatabase("1PH8_ADD_DATA", "select distinct CB_Attribute, Wert_ID from DATA where IsCB = 'x' and IsKAG = 'x' and LEA = 'x'");
    }else{
        var aResult = Object.fromDatabase("1PH8_ADD_DATA", "select distinct CB_Attribute, Wert_ID from DATA where IsCB = 'x' and IsKAG = 'x'");
    }
    for (var i=0; i < aResult.length; i++)  {
        var attrname = aResult[i]['CB_ATTRIBUTE'];
        var attrKAG = aResult[i]['WERT_ID'];
        var bKAG = ECL_ValueSelected(attrname, 'T');
        if (bKAG){
            aKag.push(attrKAG);
            
            if (attrKAG.charAt(0) == 'Y') {
                
                // Es muss eine Klartextangabe generiert werden
                var ft = getFreetextSD(attrKAG);
                if (ft && (ft != ''))
                    aKagFt.push(ft);
            }
        }
    }
    
    
    // Jetzt noch ein paar Kurzangaben ergänzen, die sich nicht einfach aus einem Wert
    // bestimmen lassen:
    getAdditionalSD(aKag, aKagFt);
    
    /* / Wicklungsausführung für Sonderfall, wenn MLFB-Stelle 12 + 13 = 90: dann Spezifizierung durch Kurzangabe
    if (sECSI_MLFB.charAt(11) == '9' && sECSI_MLFB.charAt(12) == '0') {
        var sKAGWicklung = ECL_GetValue("IN_WICKLUNG_1LE1X");
        aKag.push(sKAGWicklung);
    }
    */
    /* / Motorschutz Sonderfall, wenn MLFB-Stelle 15 = Z: dann Spezifizierung durch Kurzangabe
    if (sECSI_MLFB.charAt(14) == 'Z') {
        var sKAGMotorschutz = ECL_GetValue("IN_MOTORSCHUTZ_1LE1X");
        aKag.push(sKAGMotorschutz);
    }
    */
    
    // Ab hier beginnt der Zusammenbau des fertigen MLFB - Strings:
    
    aKag.sort();
    var kag = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKag.length; ++j) {
        kag += aKag[j] + '+';
    }
    kag = trimright(kag, '+');

    aKagFt.sort();
    var kagFT = '';	// Kurzangaben alphabetisch sortiert in einen String schreiben
    for (var j = 0; j < aKagFt.length; ++j) {
        kagFT += aKagFt[j];
    }
    
    // Einfache Regel: Wenn Kurzangaben, dann "-Z" als Marker an der Grund-MLFB
    // Wir ignorieren hier fürs erste die Unterscheidung zwischen ergänzenden Angaben und besonderen Ausführungen
    var fullMLFB = newBaseMLFB + ((kag != '') ? ('-Z '+ kag) : '') + ((kagFT != '') ? ' ' : '') + kagFT; 
    
    return fullMLFB;
}

/*
KAGs (Checkbox) Ja/Nein
O_A12_1PH8	Zusätzliche Kaltleiterkette für Warnung und Abschaltung	Additional PTC thermistor chain for alarm and trip	A12	A12 Ja	A12 Yes
O_A12_1PH8	Zusätzliche Kaltleiterkette für Warnung und Abschaltung	Additional PTC thermistor chain for alarm and trip	F	Nein	No
O_A25_1PH8	Zusätzlicher Temperatursensor als Reserve	Additional temperature sensor as reserve	A25	A25 Zusätzlicher Temperatursensor PT1000 als Reserve auf Signal-Klemmenleiste gelegt	A25 Additional PT1000 temperature sensor as reserve connected to signal terminal strip
O_A25_1PH8	Zusätzlicher Temperatursensor als Reserve	Additional temperature sensor as reserve	F	Ohne	Without
O_A72_1002197	2 Widerstandsthermometer PT1000 zur Wälzlagertemperaturüberwachung (DE und NDE)	Two PT1000 resistance thermometers to monitor roller bearing temperature (DE and NDE)	A72	A72 Ja	A72 Yes
O_A72_1002197	2 Widerstandsthermometer PT1000 zur Wälzlagertemperaturüberwachung (DE und NDE)	Two PT1000 resistance thermometers to monitor roller bearing temperature (DE and NDE)	F	Nein	No
O_B02_1PH8	Prüfbescheinigung (für bestellten Motor)	Test certification (for ordered motor)	B02	B02 Ja	B02 Yes
O_B02_1PH8	Prüfbescheinigung (für bestellten Motor)	Test certification (for ordered motor)	F	Nein	No
O_B35_1002197	Werkprüfbescheinigung für Schwingungsprotokoll	Factory test certificate for the vibration report	B35	B35 Ja	B35 Yes
O_B35_1002197	Werkprüfbescheinigung für Schwingungsprotokoll	Factory test certificate for the vibration report	F	Nein	No
O_B36_1002197	Werkprüfbescheinigung für Rundlaufprotokoll	Factory test certificate for the radial eccentricity (runout) report	B36	B36 Ja	B36 Yes
O_B36_1002197	Werkprüfbescheinigung für Rundlaufprotokoll	Factory test certificate for the radial eccentricity (runout) report	F	Nein	No

O_G14_1PH8	Mit Luftfilter	With air filter	G14	Ja	Yes
O_G14_1PH8	Mit Luftfilter	With air filter	F	Nein	No
O_G50_1PH8	Messnippel für SPM, mit M8-Adapter	Measuring nipple for SPM, with M8 adapter	G50	Ja	Yes
O_G50_1PH8	Messnippel für SPM, mit M8-Adapter	Measuring nipple for SPM, with M8 adapter	F	Nein	No
O_K16_1PH8	Zweites Wellenende	Second shaft extension	K16	Ja	Yes
O_K16_1PH8	Zweites Wellenende	Second shaft extension	F	Nein	No
O_K17_1002197	Labyrinthdichtung DE für Performance-Ausführung	Labyrinth seal DE for Performance version	K17	Ja
O_K17_1002197	Labyrinthdichtung DE für Performance-Ausführung	Labyrinth seal DE for Performance version	F	Nein

O_K18_1PH8	Radialwellendichtring DE	Radial shaft sealing ring DE	K18
O_K18_1PH8	Radialwellendichtring DE	Radial shaft sealing ring DE	F
O_K23_1PH8	Sonder-Lackierung Worldwide	Special paint finish worldwide	K23
O_K23_1PH8	Sonder-Lackierung Worldwide	Special paint finish worldwide	F
O_K24_1PH8	Grundierung	Primer	K24
O_K24_1PH8	Grundierung	Primer	F

O_K45_1PH8	Stillstandsheizung AC 230 V	Anti-condensation heater 230 V	K45
O_K45_1PH8	Stillstandsheizung AC 230 V	Anti-condensation heater 230 V	F

O_K90_1PH8	Ausführung mit Flanschgröße A400	Version with flange size A400	K90	Ja (K90)
O_K90_1PH8	Ausführung mit Flanschgröße A400	Version with flange size A400	F	Nein
O_L00_1PH8	Austausch Klemmenkasten durch den nächst Größeren	Terminal box replaced by the next larger box	L00	Ja (L00)
O_L00_1PH8	Austausch Klemmenkasten durch den nächst Größeren	Terminal box replaced by the next larger box	F	Nein
O_L02_1PH8	Schraubensicherung mit Loctite und verstärkte Lüfterausführung	Screws locked with Loctite and a stronger fan version	L02	Ja (L02)
O_L02_1PH8	Schraubensicherung mit Loctite und verstärkte Lüfterausführung	Screws locked with Loctite and a stronger fan version	F	Nein
O_L03_1PH8	Erhöhte Rüttelbeanspruchung	Increased vibration load	L03	Ja (L03)
O_L03_1PH8	Erhöhte Rüttelbeanspruchung	Increased vibration load	F	Nein
O_L12_1PH8	Kondenswasserbohrung	Condensate drain hole	L12	Ja (L12)
O_L12_1PH8	Kondenswasserbohrung	Condensate drain hole	F	Nein
O_L27_1PH8	NDE-Lager in isolierter Ausführung	Insulated NDE bearing	L27	Ja (L27)
O_L27_1PH8	NDE-Lager in isolierter Ausführung	Insulated NDE bearing	F	Nein
O_L29_1PH8	Erweiterter Korrosionsschutz für Industrie-/Seeluftaufstellung	Extended corrosion protection for industry / sea-air installation	L29	Ja (L29)
O_L29_1PH8	Erweiterter Korrosionsschutz für Industrie-/Seeluftaufstellung	Extended corrosion protection for industry / sea-air installation	F	Nein
O_L72_1002197	Welle aus Sonderstahl	Shaft manufactured out of special steel	L72	Ja (L72)
O_L72_1002197	Welle aus Sonderstahl	Shaft manufactured out of special steel	F	Nein
O_L74_1PH8	Lüfterausführung in Schutzart IP65	Fan version IP65 with degree of protection	L74	Ja (L74)
O_L74_1PH8	Lüfterausführung in Schutzart IP65	Fan version IP65 with degree of protection	F	Nein
O_L75_1PH8	Sonderlüfter 3 AC 400 V in Schutzart IP65	Special fan 3 AC 400 V in degree of protection IP65	L75	Ja (L75)
O_L75_1PH8	Sonderlüfter 3 AC 400 V in Schutzart IP65	Special fan 3 AC 400 V in degree of protection IP65	F	Nein
O_L76_1PH8	EC-Lüfter 3 AC 400 V 50/60 Hz	EC fan 400 V 3 AC 50/60 Hz	L76	Ja (L76)
O_L76_1PH8	EC-Lüfter 3 AC 400 V 50/60 Hz	EC fan 400 V 3 AC 50/60 Hz	F	Nein

O_M83_1PH8	Zusätzliche Abdrückgewinde an Motorfüßen	Additional back-of threads on motor feet	M83	Ja (M83)
O_M83_1PH8	Zusätzliche Abdrückgewinde an Motorfüßen	Additional back-of threads on motor feet	F	Nein

O_Q00_1PH8	Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten	Increased number of grounding terminals in the terminal box	Q00	Ja (Q00)
O_Q00_1PH8	Erhöhte Anzahl von Erdungsklemmen im Klemmenkasten	Increased number of grounding terminals in the terminal box	F	Nein
O_Q12_1PH8	Sperrluftanschluss	Sealing air connection	Q12	Ja (Q12)
O_Q12_1PH8	Sperrluftanschluss	Sealing air connection	F	Nein
O_Q14_1PH8	Filter für Sonderlüfter	Filter for special fan	Q14	Ja (Q14)
O_Q14_1PH8	Filter für Sonderlüfter	Filter for special fan	F	Nein
O_Q21_1PH8	Schraubensicherung mit Loctite	Screw locking using Loctite	Q21	Ja (Q21)
O_Q21_1PH8	Schraubensicherung mit Loctite	Screw locking using Loctite	F	Nein
O_Q25_1PH8	Lüfteranschluss NDE / oben (M16 x 1,5)	Fan connection NDE / top (M16 x 1.5)	Q25	Ja
O_Q25_1PH8	Lüfteranschluss NDE / oben (M16 x 1,5)	Fan connection NDE / top (M16 x 1.5)	F	Nein
O_Q31_1PH8	Metallleistungsschild anstatt Klebeschild	Metal rating plate instead of adhesive label	Q31	Ja (Q31)
O_Q31_1PH8	Metallleistungsschild anstatt Klebeschild	Metal rating plate instead of adhesive label	F	Nein
O_Q81_1002197	Erhöhte Lageranstellung	Increased bearing preloading	Q81	Ja (Q81)
O_Q81_1002197	Erhöhte Lageranstellung	Increased bearing preloading	F	Nein




Y angaben Steuerung über Textfeld todo

O_Y64_1PH8	Vorbereitung für lagerlosen Drehverteiler	Prepared for rotary distributor without bearings	Y64	Ja (Y64)
O_Y64_1PH8	Vorbereitung für lagerlosen Drehverteiler	Prepared for rotary distributor without bearings	F	Nein
O_Y82_1002197	Zusatzschild mit Bestellerangaben	Supplementary plate with order data	Y82	Ja (Y82)
O_Y82_1002197	Zusatzschild mit Bestellerangaben	Supplementary plate with order data	F	Nein
O_Y84_1PH8	Kundenangabe auf dem Leistungsschild	Customer specifications on rating plate	Y84	Ja (Y84)
O_Y84_1PH8	Kundenangabe auf dem Leistungsschild	Customer specifications on rating plate	F	Nein

*/



