//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetMotorBasisdaten_Init(oData)
{
    /*
    HMK_AUSFUEHRUNG_1002197		Ausführung								MLFB 08
    PMD_AAA271_001_000_1PH8		Ausführung des Motors					MLFB 08
    PMD_AAA069_001_000_1PH8		Ausführung des Lagers					MLFB 14
        PMD_AAB007_001_000_1PH8			Schwinggrößenstufe									Default A, 00005 
        TAK_AAJ730_001_000_1PH8			Wellen- und Flanschgenauigkeit						Default 00003, N
    
    PMD_ABU276_001_000_1PH8		Produktbestandteil / Haltebremse		MLFB 08
    PMD_ABP663_001_000_1002197	Achshöhe								MLFB 5+6
    PMD_AAA136_001_000_1PH8		Art der Kühlung							MLFB 11
    PMD_ABJ176_001_000_1PH8		Schutzart IP							
    PMD_AAA717_001_000_1PH8		Ausführung der Temperaturüberwachung	nur noch PT1000
    */
    
    
    
    if (oData && !isEmpty(oData)){
        Bestimme_Ausfuehrung(oData);
        Bestimme_Achshoehe(oData);
        Bestimme_Kuehlart(oData);
        
        Bestimme_Lager(oData);	// inkl. Schwinggrößenstufe und Wellen-/Flanschgenauigkeit
        //Bestimme_Bremse(oData);	wird gesondert behandelt
        
        Bestimme_Schutzart(oData);
        Bestimme_Temperaturueberwachung(oData);
        
    } else {
        ExecSetStandardifValueEmpty("HMK_AUSFUEHRUNG_1002197","00001");	// Default Asynchron	//LEA: Sync oder Reluktanz?
        ExecSetStandardifValueEmpty("PMD_AAA271_001_000_1PH8","Z0002");	// Asynchron
        ExecSetStandardifValueEmpty("PMD_AAA069_001_000_1PH8","00001"); // Standard
        ExecSetStandardifValueEmpty("PMD_AAB007_001_000_1PH8","00005");
        ExecSetStandardifValueEmpty("TAK_AAJ730_001_000_1PH8","00003");
        ExecSetStandardifValueEmpty("PMD_ABP663_001_000_1002197","");	// Achshöhe Zahlenwert
        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1PH8","00001");	// 00001	Fremdbelüftung DE-> NDE
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1PH8","Z0003"); // Z0003	IP55
        ExecSetStandardifValueEmpty("PMD_AAA717_001_000_1PH8","00006"); // Temperatursensor Pt1000 in der Ständerwicklung
    }
}

function SetMotorBasisdaten(strchangedAttribute, oData)
{
    
}

// ####################################################################################################################
/**

*/
function Bestimme_Ausfuehrung(oData)
{
    /*
    HMK_AUSFUEHRUNG_1002197	Ausführung	Design	00001	Asynchron
    HMK_AUSFUEHRUNG_1002197	Ausführung	Design	00002	Synchron
    HMK_AUSFUEHRUNG_1002197	Ausführung	Design	00003	Reluktanz (LEA)		// todo LEA zu def.
    
    PMD_AAA271_001_000_1PH8	Ausführung des Motors	Design of the motor	Z0002	Asynchronmotor mit Käfigläufer
    PMD_AAA271_001_000_1PH8	Ausführung des Motors	Design of the motor	Z0001	Permanentmagneterregter Synchronmotor

    */
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    
    if (MLFB08_1PH8 == "1" || MLFB08_1PH8 == "3"){	// 1 ohne, 3 mit Bremse
        // Asynchron
        ECL_ActivateValue("HMK_AUSFUEHRUNG_1002197", "00001");
        ECL_SelectValue("HMK_AUSFUEHRUNG_1002197", "00001");
        ECL_SelectValue("PMD_AAA271_001_000_1PH8", "Z0002");		// Asynchronmotor mit Käfigläufer			todo ??? 00009	Sonderausführung Asynchron (85 dB(A))
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00002");
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00003");
    }
    if (MLFB08_1PH8 == "2" || MLFB08_1PH8 == "4"){	// 2 ohne, 4 mit Bremse
        // Synchron
        ECL_ActivateValue("HMK_AUSFUEHRUNG_1002197", "00002");
        ECL_SelectValue("HMK_AUSFUEHRUNG_1002197", "00002");
        ECL_SelectValue("PMD_AAA271_001_000_1PH8", "Z0001");		// Permanentmagneterregter Synchronmotor		todo ??? 00007	Asynchrone Ausführung, Fremdbelüftung mit Geräuschwert 85 dB(A)
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00001");
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00003");
    }
    if (MLFB08_1PH8 == "5" || MLFB08_1PH8 == "6"){	// 5 ohne, 6 mit Bremse
        // LEA Reluktanzmotor effizienzgesteigert
        ECL_ActivateValue("HMK_AUSFUEHRUNG_1002197", "00003");
        ECL_SelectValue("HMK_AUSFUEHRUNG_1002197", "00003");
        ECL_SelectValue("PMD_AAA271_001_000_1PH8", "00010");		// Reluktanzmotor Efficiency
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00001");
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00002");
    }
    if (MLFB08_1PH8 == "7" || MLFB08_1PH8 == "8"){	// 7 ohne, 8 mit Bremse
        // LEA Reluktanzmotor leistungsgesteigert
        ECL_ActivateValue("HMK_AUSFUEHRUNG_1002197", "00003");
        ECL_SelectValue("HMK_AUSFUEHRUNG_1002197", "00003");
        ECL_SelectValue("PMD_AAA271_001_000_1PH8", "00011");		// Reluktanzmotor Performance
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00001");
        ECL_DeactivateValue("HMK_AUSFUEHRUNG_1002197", "00002");
    }
}
// ####################################################################################################################

function Bestimme_Achshoehe(oData)
{	
    // PMD_ABP663_001_000_1002197	Achshöhe								MLFB05
    // VT_1PH8_M00027	Achshöhe_MLFB05
    // MLFB05_1PH8	PMD_ABP663_001_000_1002197	HMK_VALUE_VALID_1PH8
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    
    var sTable = "VT_1PH8_M00027" + sDB_Suffix;
    var sSQL = "SELECT PMD_ABP663_001_000_1002197 FROM "+sTable+" WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var sAchshoehe = aResult[0].PMD_ABP663_001_000_1002197;
        
        ECL_DeactivateAllAttributeValues("PMD_ABP663_001_000_1002197");
        ECL_ActivateValue("PMD_ABP663_001_000_1002197", sAchshoehe);
        ECL_SelectValue("PMD_ABP663_001_000_1002197", sAchshoehe);
        
        ECL_DisableAttribute("PMD_ABP663_001_000_1002197");
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_AH");
    }
}
// ####################################################################################################################

function Bestimme_Kuehlart(oData)
{
    // PMD_AAA136_001_000_1PH8		Art der Kühlung			MLFB 11
    
    // VT VT_1PH8_M00207
    // HMK_AUSF_KUEHLUNG_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_VALUE_VALID_1PH8
    /*
    Art der Kühlung		PMD_AAA136_001_000_1PH8
        VT_1PH8_M00246	Kühlung_MLFB11		Übersetzung. Einschr. nur für MLFB11 = 3|4 ==> nur 1PH8_L (AH ab 180)
            MLFB05_1PH8	MLFB11_1PH8	PMD_AAA136_001_000_1PH8	HMK_VALUE_VALID_1PH8
    
    MLFB11_1PH8	
        VT_1PH8_M00207	HMK_AUSF_KUEHLUNG<>MLFB08_11		Übersetzung
        VT_1PH8_M00215	Def. Schutzart	
        VT_1PH8_M00246	Kühlung_MLFB11						Übersetzung
        VT_1PH8_M00257	AL BlockD: 05_11_09
        VT_1PH8_M00258	AL BlockD: 05_11_12_15
        VT_1PH8_M00304	G00_G11-AH-MLFB11-MLFB15
        VT_1PH8_M00305	G14-AH-MLFB08-MLFB11
        VT_1PH8_M00306	G80_H56_H75-AH-MLFB09-MLFB11
        VT_1PH8_M00308	K16-AH-MLFB09-11-12
        VT_1PH8_M00607	K69-K70-K71-K80-AH-MLFB11
        VT_1PH8_M00597	L02-AH-MLFB11 Konfigtyp
        VT_1PH8_M00317	L03-AH-MLFB08-09-11-12
        VT_1PH8_M00318	L12-AH-MLFB11-12
        VT_1PH8_M00567	L74-AH-MLFB8-MLFB11
        VT_1PH8_M00320	L75-AH-MLFB11
        VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
        VT_1PH8_M00328	Q14-AH-MLFB11
        VT_1PH8_M00591	V90-V92 RUMPF_050710_0811
        VT_1PH8_M00340	U60-U68-AH-MLFB08-11
        VT_1PH8_M00371	K83-K84-K85-AH-MLFB11-15
        VT_1PH8_M00372	Definition Rümpfe
        VT_1PH8_M00376	Anschlusstechnik_MLFB15
        VT_1PH8_M00440	AH-Kühlart-L29
        VT_1PH8_M00442	AH-Kühlart-L72
        VT_1PH8_M00491	Leistungsstecker<>L00-Q00
        VT_1PH8_M00518	P00-P06-AH
        VT_1PH8_M00519	M83-AH-MLFB12
        VT_1PH8_M00568	K18-AH-MLFB08-11-14
        VT_1PH8_M00524	L76-AH-MLFB11
        VT_1PH8_M00569	Q25-AH-MLFB11-MLFB12
        VT_1PH8_M00551	Geber-Kuehlung-UI_VT
    
    HMK_AUSF_KUEHLUNG_1PH8	MLFB Ausführung-Kühlung
        VT_1PH8_M00207	HMK_AUSF_KUEHLUNG<>MLFB08_11
        VT_1PH8_M00235	maxDrehz <> Lagerung
        VT_1PH8_M00396	Mechanische Daten
        VT_1PH8_M00411	Verbund-MLFB10-Kühl.-Schalt.-Umr.
        VT_1PH8_M00412	Verbund-MLFB07-Kühl.-Schalt.-Umr.
    */
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    // VT_1PH8_M00246
        // MLFB05_1PH8	MLFB11_1PH8	PMD_AAA136_001_000_1PH8	HMK_VALUE_VALID_1PH8
    var sTable = "VT_1PH8_M00246" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAA136_001_000_1PH8 FROM "+sTable+" WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var PMD_AAA136_001_000_1PH8 = aResult[0].PMD_AAA136_001_000_1PH8;
        
        ECL_DeactivateAllAttributeValues("PMD_AAA136_001_000_1PH8");
        ECL_ActivateValue("PMD_AAA136_001_000_1PH8", PMD_AAA136_001_000_1PH8);
        ECL_SelectValue("PMD_AAA136_001_000_1PH8", PMD_AAA136_001_000_1PH8);
        
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_KUEHLART");
    }
    
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    // HMK_AUSF_KUEHLUNG_1PH8
    //	HMK_AUSF_KUEHLUNG_1PH8	MLFB08_1PH8	MLFB11_1PH8	HMK_VALUE_VALID_1PH8		// todo LEA Daten für MLFB08 und HMK_AUSF_KUEHLUNG_1PH8 in DB-Tabellen prüfen
    var sTable = "VT_1PH8_M00207" + sDB_Suffix;
    var sSQL = "SELECT HMK_AUSF_KUEHLUNG_1PH8 FROM "+sTable+" WHERE " +
                "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var HMK_AUSF_KUEHLUNG_1PH8 = aResult[0].HMK_AUSF_KUEHLUNG_1PH8;
        
        ECL_DeactivateAllAttributeValues("HMK_AUSF_KUEHLUNG_1PH8");
        ECL_ActivateValue("HMK_AUSF_KUEHLUNG_1PH8", HMK_AUSF_KUEHLUNG_1PH8);
        ECL_SelectValue("HMK_AUSF_KUEHLUNG_1PH8", HMK_AUSF_KUEHLUNG_1PH8);
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_HMK_KUEHLART");
    }
    
}
// ####################################################################################################################

function Bestimme_Lager(oData)
{
    //zunächst performance/HighPerformance möglichkeit klären
    // VT_1PH8_M00235	maxDrehz <> Lagerung
    //	HMK_RUMPF_05_07_10_1PH8	HMK_AUSF_KUEHLUNG_1PH8	HMK_LAGERG_PERF_1PH8	HMK_LAGERG_HPERF_1PH8	HMK_VALUE_VALID_1PH8
    var HMK_AUSF_KUEHLUNG_1PH8 = ECL_GetValue("HMK_AUSF_KUEHLUNG_1PH8");
    var HMK_RUMPF_05_07_10_1PH8 = oData.oParsingData.HMK_RUMPF_05_07_10_1PH8;
    var bPerf = false;
    var bHPerf = false;
    
    var sTable = "VT_1PH8_M00235" + sDB_Suffix;
    var sSQL = "SELECT HMK_LAGERG_PERF_1PH8, HMK_LAGERG_HPERF_1PH8 FROM " + sTable + " WHERE " +
                "HMK_RUMPF_05_07_10_1PH8 = '" + HMK_RUMPF_05_07_10_1PH8 + "' AND " +
                "HMK_AUSF_KUEHLUNG_1PH8 = '" + HMK_AUSF_KUEHLUNG_1PH8 + "' AND " +
                "HMK_LAGERG_PERF_1PH8 = 'T' AND " +
                "HMK_LAGERG_HPERF_1PH8 = 'T' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        bPerf = true;
        bHPerf = true;
    }else{
        var sSQL = "SELECT HMK_LAGERG_PERF_1PH8, HMK_LAGERG_HPERF_1PH8 FROM " + sTable + " WHERE " +
                    "HMK_RUMPF_05_07_10_1PH8 = '" + HMK_RUMPF_05_07_10_1PH8 + "' AND " +
                    "HMK_AUSF_KUEHLUNG_1PH8 = '" + HMK_AUSF_KUEHLUNG_1PH8 + "' AND " +
                    "HMK_LAGERG_PERF_1PH8 = 'T' AND " +
                    "HMK_LAGERG_HPERF_1PH8 = 'F' AND " +
                    "HMK_VALUE_VALID_1PH8 = 'T';";
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            bPerf = true;
            bHPerf = false;
        }
    }
    if (bPerf){ 
        ECL_SetValue("HMK_LAGERG_PERF_1PH8", "T");
    }else{
        ECL_SetValue("HMK_LAGERG_PERF_1PH8", "F");
    }
    if (bHPerf){
        ECL_SetValue("HMK_LAGERG_HPERF_1PH8", "T");
    }else{
        ECL_SetValue("HMK_LAGERG_HPERF_1PH8", "F");
    }
    
    // todo check lager (im Parser?)
    
    // PMD_AAA069_001_000_1PH8		Ausführung des Lagers		MLFB 14
    // VT 36	VT_1PH8_M00036
    // 									Ausführung des Lagers		Schwinggrößenstufe			Wellen- und Flanschgenauigkeit
    // MLFB05_1PH8		MLFB14_1PH8		PMD_AAA069_001_000_1PH8		PMD_AAB007_001_000_1PH8		TAK_AAJ730_001_000_1PH8		HMK_VALUE_VALID_1PH8
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    
    // wenn "." 
    
    // MLFB14 ergibt sich aus Kombination Achshöhe, Lagerart, Schwinggröße, Flanschgenauigkeit
    /*
    PMD_AAB007_001_000_1PH8			Schwinggrößenstufe									Default A, 00005 
    TAK_AAJ730_001_000_1PH8			Wellen- und Flanschgenauigkeit						Default 00003, N
    */
    var sTable = "VT_1PH8_M00036" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var PMD_AAA069_001_000_1PH8 = aResult[0].PMD_AAA069_001_000_1PH8;	// Ausführung des Lagers
        var PMD_AAB007_001_000_1PH8 = aResult[0].PMD_AAB007_001_000_1PH8;	// Schwinggrößenstufe
        var TAK_AAJ730_001_000_1PH8 = aResult[0].TAK_AAJ730_001_000_1PH8;	// Wellen- und Flanschgenauigkeit
        
        ECL_ActivateValue("PMD_AAA069_001_000_1PH8", PMD_AAA069_001_000_1PH8);
        ECL_ActivateValue("PMD_AAB007_001_000_1PH8", PMD_AAB007_001_000_1PH8);
        ECL_ActivateValue("TAK_AAJ730_001_000_1PH8", TAK_AAJ730_001_000_1PH8);
        ECL_SelectValue("PMD_AAA069_001_000_1PH8", PMD_AAA069_001_000_1PH8);
        ECL_SelectValue("PMD_AAB007_001_000_1PH8", PMD_AAB007_001_000_1PH8);
        ECL_SelectValue("TAK_AAJ730_001_000_1PH8", TAK_AAJ730_001_000_1PH8);
        
        
    }
    else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_LAGER");
    }
    
    /*
    todo Abhängigkeit Bremse 
    z.B. VT_1PH8_M00447	Bauform-MLFB12		ggf ander VT???
        MLFB05_1PH8	PMD_ABU276_001_000_1PH8	MLFB12_1PH8	MLFB14_1PH8	PMD_AAC949_001_000_1PH8	HMK_VALUE_VALID_1PH8
    */
    
    
}

// ####################################################################################################################

function Bestimme_Schutzart(oData)
{
    // PMD_ABJ176_001_000_1PH8		Schutzart IP	
    
    // VT_1PH8_M00215
    // MLFB05_1PH8	MLFB11_1PH8	PMD_ABU276_001_000_1PH8	PMD_ABJ176_001_000_1PH8	HMK_VALUE_VALID_1PH8
    
    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    //var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    
    var PMD_ABU276_001_000_1PH8 = "F";
    
    if (ECL_ValueSelected("CB_HALTEBREMSE_1PH8", "T")){	//  mit Bremse
        PMD_ABU276_001_000_1PH8 = "T";
    }
    
    var sTable = "VT_1PH8_M00215" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1PH8";
    
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_ABU276_001_000_1PH8 = '" + PMD_ABU276_001_000_1PH8 + "' AND " +
                "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
                //"MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
                "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
                "HMK_VALUE_VALID_1PH8 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    ECL_DeactivateAllAttributeValues(sTargetAttribute);
    if (aResult.length > 0){
        ECL_ActivateValue(sTargetAttribute, aResult[0][sTargetAttribute]);
        ECL_SetValue(sTargetAttribute, aResult[0][sTargetAttribute]);
    }else{
        oData.strError += " " + ECL_Translate("DICT1_ERR_1PH8___PARSER_SET_SCHUTZART");
    }
    
}
// ####################################################################################################################
function Bestimme_Temperaturueberwachung(oData)
{
    // aktuell nur noch PT1000 zulässig
    ExecSetStandardifValueEmpty("PMD_AAA717_001_000_1PH8","00006"); // Temperatursensor Pt1000 in der Ständerwicklung
}
// ####################################################################################################################
