//@legacy
//#mode(full-ecma)



//@import "VT_1PH8.js"


function SetOptionenExSchutz_Init(oData) {
    /*
    O_M03_M39_1PH8		Ausführung für explosionsgefährdete Bereiche	
    */
    if (oData && !isEmpty(oData)) {
        Bestimme_ExSchutz(oData);
    } else {
        ExecSetStandardifValueEmpty("O_M03_M39_1PH8", "F");	// Ausführung für explosionsgefährdete Bereiche
    }
}

function SetOptionenExSchutz(strchangedAttribute, oData) {

}
/**

*/
function Bestimme_ExSchutz(oData) {
    // O_M03_M39_1PH8		Ausführung für explosionsgefährdete Bereiche
    // KAGs: NON, M03, M39

    var sTargetAttribute = "O_M03_M39_1PH8";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var aKAG = oData.oParsingData.MLFB.KAG || [];
    var sKAG = getKAGforAttribute(sTargetAttribute, aKAG);

    if (sKAG != "NON") {
        bCheck = checkExSchutz(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SelectValue(sTargetAttribute, sKAG);
    }
    else {
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SelectValue(sTargetAttribute, "NON");
    }
}
function checkExSchutz(oData, sTargetAttribute, sKAG) {

    if (oData.IsStartConfig == "0")
        return 1;
    // -----------------------------------------------------------------------------------------
    if (oData.IsDriveTrain == "true")
        return 0;
    // -----------------------------------------------------------------------------------------

    var MLFB05_1PH8 = oData.oParsingData.MLFB.MLFB05;
    var MLFB08_1PH8 = oData.oParsingData.MLFB.MLFB08;
    var MLFB09_1PH8 = oData.oParsingData.MLFB.MLFB09;
    var MLFB10_1PH8 = oData.oParsingData.MLFB.MLFB10;
    var MLFB11_1PH8 = oData.oParsingData.MLFB.MLFB11;
    var MLFB13_1PH8 = oData.oParsingData.MLFB.MLFB13;
    var MLFB14_1PH8 = oData.oParsingData.MLFB.MLFB14;
    var MLFB15_1PH8 = oData.oParsingData.MLFB.MLFB15;
    /*
    A: VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8
    B: VT_1PH8_M00324	M03-M39-AH-MLFB15
        MLFB05_1PH8	MLFB15_1PH8	O_M03_M39_1PH8
    C: VT_1PH8_M00342	A12-M03-M39-Q12-AH
        MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
    D: VT_1PH8_M00343	M03-M39-U60-U68-K18
        O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8
    E: VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    F: VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
    G: VT_1PH8_M00356	K45-M39
        O_K45_1PH8	O_M03_M39_1PH8
    H: VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
    I: VT_1PH8_M00363	Q52-M03-M39
        O_Q52_1PH8	O_M03_M39_1PH8
    J: VT_1PH8_M00365	Y64-M03-M39
        O_Y64_1PH8	O_M03_M39_1PH8
    K: VT_1PH8_M00367	L12-M39
        O_L12_1PH8	O_M03_M39_1PH8
    L: VT_1PH8_M00369	A25-M03-M39
        O_A25_1PH8	O_M03_M39_1PH8	
    M: VT_1PH8_M00523	M03-M39-AH-MLFB10-13
        MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8
    N: VT_1PH8_M00526	M03-M39-L76
        O_M03_M39_1PH8	O_L76_1PH8
    O: VT_1PH8_M00540	L27-M39
        O_L27_1PH8	O_M03_M39_1PH8
NEU	P: VT_1PH8_M00564	M03-M39-AH-Konfigtyp
        MLFB05_1PH8	O_M03_M39_1PH8	HMK_KONFIG_TYP_1PH8	HMK_VALUE_VALID_1PH8
    */
    // --------------------------------------------------------------------------------------------

    /* A: 
    VT_1PH8_M00323	M03-M39-AH-MLFB08-09-11-14
        MLFB05_1PH8	MLFB08_1PH8	MLFB09_1PH8	MLFB11_1PH8	MLFB14_1PH8	O_M03_M39_1PH8
    */
    var sTable = "VT_1PH8_M00323" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB08_1PH8 = '" + MLFB08_1PH8 + "' AND " +
        "MLFB09_1PH8 = '" + MLFB09_1PH8 + "' AND " +
        "MLFB11_1PH8 = '" + MLFB11_1PH8 + "' AND " +
        "MLFB14_1PH8 = '" + MLFB14_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* B: 
    VT_1PH8_M00324	M03-M39-AH-MLFB15
        MLFB05_1PH8	MLFB15_1PH8	O_M03_M39_1PH8
    */
    var sTable = "VT_1PH8_M00324" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB15_1PH8 = '" + MLFB15_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* C: 
    VT_1PH8_M00342	A12-M03-M39-Q12-AH
        MLFB05_1PH8	O_A12_1PH8	O_M03_M39_1PH8	O_Q12_1PH8
    */
    var O_A12_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_A12_1PH8", "T"))
        O_A12_1PH8 = "A12";
    var O_Q12_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_Q12_1PH8", "T"))
        O_Q12_1PH8 = "Q12";

    var sTable = "VT_1PH8_M00342" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "O_A12_1PH8 = '" + O_A12_1PH8 + "' AND " +
        "O_Q12_1PH8 = '" + O_Q12_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* D: 
    VT_1PH8_M00343	M03-M39-U60-U68-K18
        O_M03_M39_1PH8	O_U60_BIS_U68_1PH8	O_K18_1PH8
    */
    var O_U60_BIS_U68_1PH8 = ECL_GetValue("O_U60_BIS_U68_1PH8");
    var O_K18_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_K18_1PH8", "T"))
        O_K18_1PH8 = "K18";

    var sTable = "VT_1PH8_M00343" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_U60_BIS_U68_1PH8 = '" + O_U60_BIS_U68_1PH8 + "' AND " +
        "O_K18_1PH8 = '" + O_K18_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* E: 
    VT_1PH8_M00344	M03-M39-K80-L74
        O_M03_M39_1PH8	O_K69_K70_K71_K80_1PH8	O_L74_1PH8
    */
    var O_K69_K70_K71_K80_1PH8 = ECL_GetValue("O_K69_K70_K71_K80_1PH8");
    var O_L74_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L74_1PH8", "T"))
        O_L74_1PH8 = "L74";

    var sTable = "VT_1PH8_M00344" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_K69_K70_K71_K80_1PH8 = '" + O_K69_K70_K71_K80_1PH8 + "' AND " +
        "O_L74_1PH8 = '" + O_L74_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* F: 
    VT_1PH8_M00351	M03-M39-G14-L75
        O_M03_M39_1PH8	O_G14_1PH8	O_L75_1PH8
    */
    var O_G14_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_G14_1PH8", "T"))
        O_G14_1PH8 = "G14";
    var O_L75_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L75_1PH8", "T"))
        O_L75_1PH8 = "L75";

    var sTable = "VT_1PH8_M00351" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_G14_1PH8 = '" + O_G14_1PH8 + "' AND " +
        "O_L75_1PH8 = '" + O_L75_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* G: 
    VT_1PH8_M00356	K45-M39
        O_K45_1PH8	O_M03_M39_1PH8
    */
    var O_K45_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_K45_1PH8", "T"))
        O_K45_1PH8 = "K45";

    var sTable = "VT_1PH8_M00356" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_K45_1PH8 = '" + O_K45_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* H: 
    VT_1PH8_M00361	L03-Q14-M39
        O_L03_1PH8	O_Q14_1PH8	O_M03_M39_1PH8
    */
    var O_L03_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L03_1PH8", "T"))
        O_L03_1PH8 = "L03";
    var O_Q14_1PH8 = "F";
    //if (ECL_ValueSelected("CB_O_Q14_1PH8", "T"))
    //    O_Q14_1PH8 = "Q14";

    var sTable = "VT_1PH8_M00361" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_L03_1PH8 = '" + O_L03_1PH8 + "' AND " +
        "O_Q14_1PH8 = '" + O_Q14_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* I: 
    VT_1PH8_M00363	Q52-M03-M39
        O_Q52_1PH8	O_M03_M39_1PH8					Q52 nicht aktiv? todo prüfen
    *  /
    var O_Q52_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_Q52_1PH8", "T"))
        O_Q52_1PH8 = "Q52";
    
    var sTable = "VT_1PH8_M00363" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_Q52_1PH8 = '" + O_Q52_1PH8 + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1){
        return 0;
    }*/
    // --------------------------------------------------------------------------------------------
    /* J: 
    VT_1PH8_M00365	Y64-M03-M39
        O_Y64_1PH8	O_M03_M39_1PH8
    */
    var O_Y64_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_Y64_1PH8", "T"))
        O_Y64_1PH8 = "Y64";

    var sTable = "VT_1PH8_M00365" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_Y64_1PH8 = '" + O_Y64_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* K: 
    VT_1PH8_M00367	L12-M39
        O_L12_1PH8	O_M03_M39_1PH8
    */
    var O_L12_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L12_1PH8", "T"))
        O_L12_1PH8 = "L12";

    var sTable = "VT_1PH8_M00367" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_L12_1PH8 = '" + O_L12_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* L: 
    VT_1PH8_M00369	A25-M03-M39
        O_A25_1PH8	O_M03_M39_1PH8
    */
    var O_A25_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_A25_1PH8", "T"))
        O_A25_1PH8 = "A25";

    var sTable = "VT_1PH8_M00369" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_A25_1PH8 = '" + O_A25_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* M: 
    VT_1PH8_M00523	M03-M39-AH-MLFB10-13
        MLFB05_1PH8	MLFB10_1PH8	MLFB13_1PH8	O_M03_M39_1PH8	HMK_VALUE_VALID_1PH8
    */
    var sTable = "VT_1PH8_M00523" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "MLFB10_1PH8 = '" + MLFB10_1PH8 + "' AND " +
        "MLFB13_1PH8 = '" + MLFB13_1PH8 + "' AND " +
        "HMK_VALUE_VALID_1PH8 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* N: 
    VT_1PH8_M00526	M03-M39-L76
        O_M03_M39_1PH8	O_L76_1PH8
    */
    var O_L76_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L76_1PH8", "T"))
        O_L76_1PH8 = "L76";

    var sTable = "VT_1PH8_M00526" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_L76_1PH8 = '" + O_L76_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* O: 
    VT_1PH8_M00540	L27-M39
        O_L27_1PH8	O_M03_M39_1PH8
    */
    var O_L27_1PH8 = "F";
    if (ECL_ValueSelected("CB_O_L27_1PH8", "T"))
        O_L27_1PH8 = "L27";

    var sTable = "VT_1PH8_M00540" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_L27_1PH8 = '" + O_L27_1PH8 + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    /* P: 
    VT_1PH8_M00564	M03-M39-AH-Konfigtyp
        MLFB05_1PH8	O_M03_M39_1PH8	HMK_KONFIG_TYP_1PH8	HMK_VALUE_VALID_1PH8
    */

    var sTable = "VT_1PH8_M00564" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_1PH8 = '" + MLFB05_1PH8 + "' AND " +
        "HMK_KONFIG_TYP_1PH8 = 'KONFIG' AND " +
        "HMK_VALUE_VALID_1PH8 = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // --------------------------------------------------------------------------------------------
    return 1;
}